import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicebusNamespaceAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule#listen ServicebusNamespaceAuthorizationRule#listen}
    */
    readonly listen?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule#manage ServicebusNamespaceAuthorizationRule#manage}
    */
    readonly manage?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule#name ServicebusNamespaceAuthorizationRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule#namespace_id ServicebusNamespaceAuthorizationRule#namespace_id}
    */
    readonly namespaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule#namespace_name ServicebusNamespaceAuthorizationRule#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule#resource_group_name ServicebusNamespaceAuthorizationRule#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule#send ServicebusNamespaceAuthorizationRule#send}
    */
    readonly send?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule#timeouts ServicebusNamespaceAuthorizationRule#timeouts}
    */
    readonly timeouts?: ServicebusNamespaceAuthorizationRuleTimeouts;
}
export interface ServicebusNamespaceAuthorizationRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule#create ServicebusNamespaceAuthorizationRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule#delete ServicebusNamespaceAuthorizationRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule#read ServicebusNamespaceAuthorizationRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule#update ServicebusNamespaceAuthorizationRule#update}
    */
    readonly update?: string;
}
export declare function servicebusNamespaceAuthorizationRuleTimeoutsToTerraform(struct?: ServicebusNamespaceAuthorizationRuleTimeoutsOutputReference | ServicebusNamespaceAuthorizationRuleTimeouts | cdktf.IResolvable): any;
export declare class ServicebusNamespaceAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicebusNamespaceAuthorizationRuleTimeouts | undefined;
    set internalValue(value: ServicebusNamespaceAuthorizationRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule azurerm_servicebus_namespace_authorization_rule}
*/
export declare class ServicebusNamespaceAuthorizationRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_servicebus_namespace_authorization_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_authorization_rule azurerm_servicebus_namespace_authorization_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicebusNamespaceAuthorizationRuleConfig
    */
    constructor(scope: Construct, id: string, config: ServicebusNamespaceAuthorizationRuleConfig);
    get id(): string;
    private _listen?;
    get listen(): boolean | cdktf.IResolvable;
    set listen(value: boolean | cdktf.IResolvable);
    resetListen(): void;
    get listenInput(): boolean | cdktf.IResolvable | undefined;
    private _manage?;
    get manage(): boolean | cdktf.IResolvable;
    set manage(value: boolean | cdktf.IResolvable);
    resetManage(): void;
    get manageInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceId?;
    get namespaceId(): string;
    set namespaceId(value: string);
    resetNamespaceId(): void;
    get namespaceIdInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    get primaryConnectionString(): string;
    get primaryConnectionStringAlias(): string;
    get primaryKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    get secondaryConnectionString(): string;
    get secondaryConnectionStringAlias(): string;
    get secondaryKey(): string;
    private _send?;
    get send(): boolean | cdktf.IResolvable;
    set send(value: boolean | cdktf.IResolvable);
    resetSend(): void;
    get sendInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): ServicebusNamespaceAuthorizationRuleTimeoutsOutputReference;
    putTimeouts(value: ServicebusNamespaceAuthorizationRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServicebusNamespaceAuthorizationRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
