import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubnetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#address_prefix Subnet#address_prefix}
    */
    readonly addressPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#address_prefixes Subnet#address_prefixes}
    */
    readonly addressPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#enforce_private_link_endpoint_network_policies Subnet#enforce_private_link_endpoint_network_policies}
    */
    readonly enforcePrivateLinkEndpointNetworkPolicies?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#enforce_private_link_service_network_policies Subnet#enforce_private_link_service_network_policies}
    */
    readonly enforcePrivateLinkServiceNetworkPolicies?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#name Subnet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#resource_group_name Subnet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#service_endpoint_policy_ids Subnet#service_endpoint_policy_ids}
    */
    readonly serviceEndpointPolicyIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#service_endpoints Subnet#service_endpoints}
    */
    readonly serviceEndpoints?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#virtual_network_name Subnet#virtual_network_name}
    */
    readonly virtualNetworkName: string;
    /**
    * delegation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#delegation Subnet#delegation}
    */
    readonly delegation?: SubnetDelegation[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#timeouts Subnet#timeouts}
    */
    readonly timeouts?: SubnetTimeouts;
}
export interface SubnetDelegationServiceDelegation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#actions Subnet#actions}
    */
    readonly actions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#name Subnet#name}
    */
    readonly name: string;
}
export declare function subnetDelegationServiceDelegationToTerraform(struct?: SubnetDelegationServiceDelegationOutputReference | SubnetDelegationServiceDelegation): any;
export declare class SubnetDelegationServiceDelegationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubnetDelegationServiceDelegation | undefined;
    set internalValue(value: SubnetDelegationServiceDelegation | undefined);
    private _actions?;
    get actions(): string[];
    set actions(value: string[]);
    resetActions(): void;
    get actionsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface SubnetDelegation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#name Subnet#name}
    */
    readonly name: string;
    /**
    * service_delegation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#service_delegation Subnet#service_delegation}
    */
    readonly serviceDelegation: SubnetDelegationServiceDelegation;
}
export declare function subnetDelegationToTerraform(struct?: SubnetDelegation | cdktf.IResolvable): any;
export interface SubnetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#create Subnet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#delete Subnet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#read Subnet#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet#update Subnet#update}
    */
    readonly update?: string;
}
export declare function subnetTimeoutsToTerraform(struct?: SubnetTimeoutsOutputReference | SubnetTimeouts | cdktf.IResolvable): any;
export declare class SubnetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubnetTimeouts | undefined;
    set internalValue(value: SubnetTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/subnet azurerm_subnet}
*/
export declare class Subnet extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_subnet";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/subnet azurerm_subnet} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubnetConfig
    */
    constructor(scope: Construct, id: string, config: SubnetConfig);
    private _addressPrefix?;
    get addressPrefix(): string;
    set addressPrefix(value: string);
    resetAddressPrefix(): void;
    get addressPrefixInput(): string | undefined;
    private _addressPrefixes?;
    get addressPrefixes(): string[];
    set addressPrefixes(value: string[]);
    resetAddressPrefixes(): void;
    get addressPrefixesInput(): string[] | undefined;
    private _enforcePrivateLinkEndpointNetworkPolicies?;
    get enforcePrivateLinkEndpointNetworkPolicies(): boolean | cdktf.IResolvable;
    set enforcePrivateLinkEndpointNetworkPolicies(value: boolean | cdktf.IResolvable);
    resetEnforcePrivateLinkEndpointNetworkPolicies(): void;
    get enforcePrivateLinkEndpointNetworkPoliciesInput(): boolean | cdktf.IResolvable | undefined;
    private _enforcePrivateLinkServiceNetworkPolicies?;
    get enforcePrivateLinkServiceNetworkPolicies(): boolean | cdktf.IResolvable;
    set enforcePrivateLinkServiceNetworkPolicies(value: boolean | cdktf.IResolvable);
    resetEnforcePrivateLinkServiceNetworkPolicies(): void;
    get enforcePrivateLinkServiceNetworkPoliciesInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceEndpointPolicyIds?;
    get serviceEndpointPolicyIds(): string[];
    set serviceEndpointPolicyIds(value: string[]);
    resetServiceEndpointPolicyIds(): void;
    get serviceEndpointPolicyIdsInput(): string[] | undefined;
    private _serviceEndpoints?;
    get serviceEndpoints(): string[];
    set serviceEndpoints(value: string[]);
    resetServiceEndpoints(): void;
    get serviceEndpointsInput(): string[] | undefined;
    private _virtualNetworkName?;
    get virtualNetworkName(): string;
    set virtualNetworkName(value: string);
    get virtualNetworkNameInput(): string | undefined;
    private _delegation?;
    get delegation(): SubnetDelegation[] | cdktf.IResolvable;
    set delegation(value: SubnetDelegation[] | cdktf.IResolvable);
    resetDelegation(): void;
    get delegationInput(): cdktf.IResolvable | SubnetDelegation[] | undefined;
    private _timeouts;
    get timeouts(): SubnetTimeoutsOutputReference;
    putTimeouts(value: SubnetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SubnetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
