import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseIntegrationRuntimeAzureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure#compute_type SynapseIntegrationRuntimeAzure#compute_type}
    */
    readonly computeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure#core_count SynapseIntegrationRuntimeAzure#core_count}
    */
    readonly coreCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure#description SynapseIntegrationRuntimeAzure#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure#location SynapseIntegrationRuntimeAzure#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure#name SynapseIntegrationRuntimeAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure#synapse_workspace_id SynapseIntegrationRuntimeAzure#synapse_workspace_id}
    */
    readonly synapseWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure#time_to_live_min SynapseIntegrationRuntimeAzure#time_to_live_min}
    */
    readonly timeToLiveMin?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure#timeouts SynapseIntegrationRuntimeAzure#timeouts}
    */
    readonly timeouts?: SynapseIntegrationRuntimeAzureTimeouts;
}
export interface SynapseIntegrationRuntimeAzureTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure#create SynapseIntegrationRuntimeAzure#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure#delete SynapseIntegrationRuntimeAzure#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure#read SynapseIntegrationRuntimeAzure#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure#update SynapseIntegrationRuntimeAzure#update}
    */
    readonly update?: string;
}
export declare function synapseIntegrationRuntimeAzureTimeoutsToTerraform(struct?: SynapseIntegrationRuntimeAzureTimeoutsOutputReference | SynapseIntegrationRuntimeAzureTimeouts | cdktf.IResolvable): any;
export declare class SynapseIntegrationRuntimeAzureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseIntegrationRuntimeAzureTimeouts | undefined;
    set internalValue(value: SynapseIntegrationRuntimeAzureTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure azurerm_synapse_integration_runtime_azure}
*/
export declare class SynapseIntegrationRuntimeAzure extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_synapse_integration_runtime_azure";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_integration_runtime_azure azurerm_synapse_integration_runtime_azure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseIntegrationRuntimeAzureConfig
    */
    constructor(scope: Construct, id: string, config: SynapseIntegrationRuntimeAzureConfig);
    private _computeType?;
    get computeType(): string;
    set computeType(value: string);
    resetComputeType(): void;
    get computeTypeInput(): string | undefined;
    private _coreCount?;
    get coreCount(): number;
    set coreCount(value: number);
    resetCoreCount(): void;
    get coreCountInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _synapseWorkspaceId?;
    get synapseWorkspaceId(): string;
    set synapseWorkspaceId(value: string);
    get synapseWorkspaceIdInput(): string | undefined;
    private _timeToLiveMin?;
    get timeToLiveMin(): number;
    set timeToLiveMin(value: number);
    resetTimeToLiveMin(): void;
    get timeToLiveMinInput(): number | undefined;
    private _timeouts;
    get timeouts(): SynapseIntegrationRuntimeAzureTimeoutsOutputReference;
    putTimeouts(value: SynapseIntegrationRuntimeAzureTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SynapseIntegrationRuntimeAzureTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
