import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpnGatewayNatRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#external_address_space_mappings VpnGatewayNatRule#external_address_space_mappings}
    */
    readonly externalAddressSpaceMappings: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#internal_address_space_mappings VpnGatewayNatRule#internal_address_space_mappings}
    */
    readonly internalAddressSpaceMappings: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#ip_configuration_id VpnGatewayNatRule#ip_configuration_id}
    */
    readonly ipConfigurationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#mode VpnGatewayNatRule#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#name VpnGatewayNatRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#resource_group_name VpnGatewayNatRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#type VpnGatewayNatRule#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#vpn_gateway_id VpnGatewayNatRule#vpn_gateway_id}
    */
    readonly vpnGatewayId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#timeouts VpnGatewayNatRule#timeouts}
    */
    readonly timeouts?: VpnGatewayNatRuleTimeouts;
}
export interface VpnGatewayNatRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#create VpnGatewayNatRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#delete VpnGatewayNatRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#read VpnGatewayNatRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule#update VpnGatewayNatRule#update}
    */
    readonly update?: string;
}
export declare function vpnGatewayNatRuleTimeoutsToTerraform(struct?: VpnGatewayNatRuleTimeoutsOutputReference | VpnGatewayNatRuleTimeouts | cdktf.IResolvable): any;
export declare class VpnGatewayNatRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnGatewayNatRuleTimeouts | undefined;
    set internalValue(value: VpnGatewayNatRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule azurerm_vpn_gateway_nat_rule}
*/
export declare class VpnGatewayNatRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_vpn_gateway_nat_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule azurerm_vpn_gateway_nat_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpnGatewayNatRuleConfig
    */
    constructor(scope: Construct, id: string, config: VpnGatewayNatRuleConfig);
    private _externalAddressSpaceMappings?;
    get externalAddressSpaceMappings(): string[];
    set externalAddressSpaceMappings(value: string[]);
    get externalAddressSpaceMappingsInput(): string[] | undefined;
    get id(): string;
    private _internalAddressSpaceMappings?;
    get internalAddressSpaceMappings(): string[];
    set internalAddressSpaceMappings(value: string[]);
    get internalAddressSpaceMappingsInput(): string[] | undefined;
    private _ipConfigurationId?;
    get ipConfigurationId(): string;
    set ipConfigurationId(value: string);
    resetIpConfigurationId(): void;
    get ipConfigurationIdInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _vpnGatewayId?;
    get vpnGatewayId(): string;
    set vpnGatewayId(value: string);
    get vpnGatewayIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): VpnGatewayNatRuleTimeoutsOutputReference;
    putTimeouts(value: VpnGatewayNatRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VpnGatewayNatRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
