# coding=utf-8
"""
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

"""
from dubbo_client import ApplicationConfig



def test_application_config_new():
    application_config = ApplicationConfig('test_app', version='2.0.0', owner='caozupeng', error='ssd')
    assert application_config.architecture == 'web'
    assert application_config.name == 'test_app'
    assert application_config.environment == 'run'
    assert application_config.version == '2.0.0'
    assert 'owner' in application_config.__dict__
    assert 'ssd' not in application_config.__dict__
