r"""
Copyright &copy; 2023 NetApp Inc.
All rights reserved.

This file has been automatically generated based on the ONTAP REST API documentation.

"""

from marshmallow import EXCLUDE, fields  # type: ignore
from netapp_ontap.resource import Resource, ResourceSchema, ResourceSchemaMeta, ImpreciseDateTime, Size


__all__ = ["TimezoneCluster", "TimezoneClusterSchema"]
__pdoc__ = {
    "TimezoneClusterSchema.resource": False,
    "TimezoneClusterSchema.opts": False,
    "TimezoneCluster": False,
}


class TimezoneClusterSchema(ResourceSchema, metaclass=ResourceSchemaMeta):
    """The fields of the TimezoneCluster object"""

    name = fields.Str(data_key="name")
    r""" The ONTAP time zone name or identification in either IANA time zone format "Area/Location", or an ONTAP traditional time zone.
</br>
The initial first node in cluster setting for time zone is "Etc/UTC".
"Etc/UTC" is the IANA timezone "Area/Location" specifier for
Coordinated Universal Time (UTC), which is an offset of 0.
### IANA time zone format
The IANA time zone, formatted as "Area/Location", is based on geographic areas that have had the same time zone offset for many years.
</br>
"Location" represents a compound name using additional forward slashes.
</br>
An example of the "Area/Location" time zone is "America/New_York" and represents most of the United States Eastern Time Zone.
Examples of "Area/Location" with "Location" as a compound name are "America/Argentina/Buenos_Aires" and "America/Indiana/Indianapolis".
### ONTAP traditional time zone
Examples of the traditional time zones are "EST5EDT" for the United States Eastern Time Zone and "CET" for Central European Time Zone.


Example: America/New_York """

    @property
    def resource(self):
        return TimezoneCluster

    gettable_fields = [
        "name",
    ]
    """name,"""

    patchable_fields = [
        "name",
    ]
    """name,"""

    postable_fields = [
        "name",
    ]
    """name,"""


class TimezoneCluster(Resource):

    _schema = TimezoneClusterSchema
