# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_asyncio_client.api_client import ApiClient
from powerbot_asyncio_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AlgorithmsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_algorithm(self, value, **kwargs):  # noqa: E501
        """Add algorithm  # noqa: E501

        Use this method to create a new algorithm. In order to create an algorithm, you need to use the master-API-key which has been provided to you (other API keys cannot create an algorithm). An algorithm provides a setup which contains the required information. To run an algorithm, create an instance of it and start/stop it via the given endpoint. An algorithm requires a unique id, information about how often it expects a heartbeat and how it should behave if the heartbeat is missing. The image can be any valid docker image name with a tag. The tag can not be \"latest\" to avoid accidental upgrades.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_algorithm(value, async_req=True)
        >>> result = thread.get()

        :param value: (required)
        :type value: AlgoSetup
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.add_algorithm_with_http_info(value, **kwargs)  # noqa: E501

    def add_algorithm_with_http_info(self, value, **kwargs):  # noqa: E501
        """Add algorithm  # noqa: E501

        Use this method to create a new algorithm. In order to create an algorithm, you need to use the master-API-key which has been provided to you (other API keys cannot create an algorithm). An algorithm provides a setup which contains the required information. To run an algorithm, create an instance of it and start/stop it via the given endpoint. An algorithm requires a unique id, information about how often it expects a heartbeat and how it should behave if the heartbeat is missing. The image can be any valid docker image name with a tag. The tag can not be \"latest\" to avoid accidental upgrades.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_algorithm_with_http_info(value, async_req=True)
        >>> result = thread.get()

        :param value: (required)
        :type value: AlgoSetup
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'value'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_algorithm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and local_var_params.get('value') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `value` when calling `add_algorithm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'value' in local_var_params:
            body_params = local_var_params['value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/algorithms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_algorithm(self, algorithm_id, **kwargs):  # noqa: E501
        """Delete algorithm  # noqa: E501

        This is only possible if the algorithm has no instances assigned to it. Only the master-API-key is allowed to delete algorithms.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_algorithm(algorithm_id, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_algorithm_with_http_info(algorithm_id, **kwargs)  # noqa: E501

    def delete_algorithm_with_http_info(self, algorithm_id, **kwargs):  # noqa: E501
        """Delete algorithm  # noqa: E501

        This is only possible if the algorithm has no instances assigned to it. Only the master-API-key is allowed to delete algorithms.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_algorithm_with_http_info(algorithm_id, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'algorithm_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_algorithm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if self.api_client.client_side_validation and local_var_params.get('algorithm_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_id` when calling `delete_algorithm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in local_var_params:
            path_params['algorithm_id'] = local_var_params['algorithm_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_algorithm_instance(self, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Delete algorithm instance  # noqa: E501

        Instances can only be deleted if they are not running. - Master-API-keys can delete all instances. - Tenant-master-API-keys can only delete instances, where the key has access to ALL portfolios specified in the instance. - Standard-API-keys and Scheduling-API-keys are not allowed to delete instances.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_algorithm_instance(algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param instance_id: (required)
        :type instance_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_algorithm_instance_with_http_info(algorithm_id, instance_id, **kwargs)  # noqa: E501

    def delete_algorithm_instance_with_http_info(self, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Delete algorithm instance  # noqa: E501

        Instances can only be deleted if they are not running. - Master-API-keys can delete all instances. - Tenant-master-API-keys can only delete instances, where the key has access to ALL portfolios specified in the instance. - Standard-API-keys and Scheduling-API-keys are not allowed to delete instances.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_algorithm_instance_with_http_info(algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param instance_id: (required)
        :type instance_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'algorithm_id',
            'instance_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_algorithm_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if self.api_client.client_side_validation and local_var_params.get('algorithm_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_id` when calling `delete_algorithm_instance`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if self.api_client.client_side_validation and local_var_params.get('instance_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `instance_id` when calling `delete_algorithm_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in local_var_params:
            path_params['algorithm_id'] = local_var_params['algorithm_id']  # noqa: E501
        if 'instance_id' in local_var_params:
            path_params['instance_id'] = local_var_params['instance_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instance/{instance_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_algo_instance_status(self, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Get algorithm instance details  # noqa: E501

        Retrieves details about the algorithm instance. - Master-API-keys can always retrieve details about an algorithm-instance. - Tenant-master-API-keys can only access algorithm-instances, where the key has access to AT LEAST ONE portfolio specified in the instance. - Standard-API-keys can only access algorithm-instances, where the key has access to AT LEAST ONE portfolio specified in the instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_algo_instance_status(algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param instance_id: (required)
        :type instance_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AlgoInstance
        """
        kwargs['_return_http_data_only'] = True
        return self.get_algo_instance_status_with_http_info(algorithm_id, instance_id, **kwargs)  # noqa: E501

    def get_algo_instance_status_with_http_info(self, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Get algorithm instance details  # noqa: E501

        Retrieves details about the algorithm instance. - Master-API-keys can always retrieve details about an algorithm-instance. - Tenant-master-API-keys can only access algorithm-instances, where the key has access to AT LEAST ONE portfolio specified in the instance. - Standard-API-keys can only access algorithm-instances, where the key has access to AT LEAST ONE portfolio specified in the instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_algo_instance_status_with_http_info(algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param instance_id: (required)
        :type instance_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AlgoInstance, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'algorithm_id',
            'instance_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_algo_instance_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if self.api_client.client_side_validation and local_var_params.get('algorithm_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_id` when calling `get_algo_instance_status`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if self.api_client.client_side_validation and local_var_params.get('instance_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `instance_id` when calling `get_algo_instance_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in local_var_params:
            path_params['algorithm_id'] = local_var_params['algorithm_id']  # noqa: E501
        if 'instance_id' in local_var_params:
            path_params['instance_id'] = local_var_params['instance_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "AlgoInstance",
        }

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instance/{instance_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_algorithm(self, algorithm_id, **kwargs):  # noqa: E501
        """Get algorithm details  # noqa: E501

        Get details for an algorithm and its instances, depending on the access rights of the currently used API key. - The master-API-key can access every algorithm. - A tenant-master-API-key can only access algorithms where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm. - A standard-API-key can only access algorithms where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_algorithm(algorithm_id, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AlgoDetails
        """
        kwargs['_return_http_data_only'] = True
        return self.get_algorithm_with_http_info(algorithm_id, **kwargs)  # noqa: E501

    def get_algorithm_with_http_info(self, algorithm_id, **kwargs):  # noqa: E501
        """Get algorithm details  # noqa: E501

        Get details for an algorithm and its instances, depending on the access rights of the currently used API key. - The master-API-key can access every algorithm. - A tenant-master-API-key can only access algorithms where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm. - A standard-API-key can only access algorithms where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_algorithm_with_http_info(algorithm_id, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AlgoDetails, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'algorithm_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_algorithm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if self.api_client.client_side_validation and local_var_params.get('algorithm_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_id` when calling `get_algorithm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in local_var_params:
            path_params['algorithm_id'] = local_var_params['algorithm_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "AlgoDetails",
        }

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_algorithms(self, **kwargs):  # noqa: E501
        """List algorithms  # noqa: E501

        Get all algorithms and their instances, depending on the access rights of the currently used API key. - The master-API-key will get all algorithms and instances (exchange independent). - A tenant-master-API-key can retrieve only the algorithms and instances, where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm. - A standard-API-key can retrieve only the algorithms and instances, where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_algorithms(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AlgoDetails]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_algorithms_with_http_info(**kwargs)  # noqa: E501

    def get_algorithms_with_http_info(self, **kwargs):  # noqa: E501
        """List algorithms  # noqa: E501

        Get all algorithms and their instances, depending on the access rights of the currently used API key. - The master-API-key will get all algorithms and instances (exchange independent). - A tenant-master-API-key can retrieve only the algorithms and instances, where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm. - A standard-API-key can retrieve only the algorithms and instances, where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_algorithms_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[AlgoDetails], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_algorithms" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[AlgoDetails]",
        }

        return self.api_client.call_api(
            '/algorithms', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def modify_algorithm(self, algorithm_id, value, **kwargs):  # noqa: E501
        """Update algorithm  # noqa: E501

        Modifies the fields of an algorithm. Only the master-API-key is allowed to perform this request. Only fields specified in the request will be updated. Please note that invalid values for the field \"on_missing_heartbeat\" will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_algorithm(algorithm_id, value, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param value: (required)
        :type value: UpdateAlgoSetup
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.modify_algorithm_with_http_info(algorithm_id, value, **kwargs)  # noqa: E501

    def modify_algorithm_with_http_info(self, algorithm_id, value, **kwargs):  # noqa: E501
        """Update algorithm  # noqa: E501

        Modifies the fields of an algorithm. Only the master-API-key is allowed to perform this request. Only fields specified in the request will be updated. Please note that invalid values for the field \"on_missing_heartbeat\" will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_algorithm_with_http_info(algorithm_id, value, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param value: (required)
        :type value: UpdateAlgoSetup
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'algorithm_id',
            'value'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_algorithm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if self.api_client.client_side_validation and local_var_params.get('algorithm_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_id` when calling `modify_algorithm`")  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and local_var_params.get('value') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `value` when calling `modify_algorithm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in local_var_params:
            path_params['algorithm_id'] = local_var_params['algorithm_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'value' in local_var_params:
            body_params = local_var_params['value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def new_instance(self, algorithm_id, start_parameters, **kwargs):  # noqa: E501
        """Add algorithm instance  # noqa: E501

        An instance is used to run an algorithm and pass parameters to it. Only the master-API-key and tenant-master-API-keys are allowed to create algorithm-instances. An instance is always bound to a tenant and a list of portfolios.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.new_instance(algorithm_id, start_parameters, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param start_parameters: (required)
        :type start_parameters: AlgoInstanceParameters
        :param bypass_validation: When set to true, the specified parameters will not be validated against the json schema of the algorithm.
        :type bypass_validation: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AlgoInstance
        """
        kwargs['_return_http_data_only'] = True
        return self.new_instance_with_http_info(algorithm_id, start_parameters, **kwargs)  # noqa: E501

    def new_instance_with_http_info(self, algorithm_id, start_parameters, **kwargs):  # noqa: E501
        """Add algorithm instance  # noqa: E501

        An instance is used to run an algorithm and pass parameters to it. Only the master-API-key and tenant-master-API-keys are allowed to create algorithm-instances. An instance is always bound to a tenant and a list of portfolios.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.new_instance_with_http_info(algorithm_id, start_parameters, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param start_parameters: (required)
        :type start_parameters: AlgoInstanceParameters
        :param bypass_validation: When set to true, the specified parameters will not be validated against the json schema of the algorithm.
        :type bypass_validation: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AlgoInstance, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'algorithm_id',
            'start_parameters',
            'bypass_validation'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method new_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if self.api_client.client_side_validation and local_var_params.get('algorithm_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_id` when calling `new_instance`")  # noqa: E501
        # verify the required parameter 'start_parameters' is set
        if self.api_client.client_side_validation and local_var_params.get('start_parameters') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_parameters` when calling `new_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in local_var_params:
            path_params['algorithm_id'] = local_var_params['algorithm_id']  # noqa: E501

        query_params = []
        if local_var_params.get('bypass_validation') is not None:  # noqa: E501
            query_params.append(('bypass_validation', local_var_params['bypass_validation']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'start_parameters' in local_var_params:
            body_params = local_var_params['start_parameters']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "AlgoInstance",
        }

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instances', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def submit_command(self, algorithm_id, instance_id, command, **kwargs):  # noqa: E501
        """Start/Stop algorithm instance  # noqa: E501

        This request controls the algorithm instance. Use standard-API-keys to start/stop algorithm instances. The key needs access to ALL portfolios specified in the instance. Master-API-keys and tenant-master-API-keys can also start/stop algorithm instances, however this should only be used in exceptional cases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_command(algorithm_id, instance_id, command, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param instance_id: (required)
        :type instance_id: str
        :param command: (required)
        :type command: AlgoCommand
        :param bypass_validation: When set to true, the specified parameters will not be validated against the json schema of the algorithm.
        :type bypass_validation: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AlgoInstance
        """
        kwargs['_return_http_data_only'] = True
        return self.submit_command_with_http_info(algorithm_id, instance_id, command, **kwargs)  # noqa: E501

    def submit_command_with_http_info(self, algorithm_id, instance_id, command, **kwargs):  # noqa: E501
        """Start/Stop algorithm instance  # noqa: E501

        This request controls the algorithm instance. Use standard-API-keys to start/stop algorithm instances. The key needs access to ALL portfolios specified in the instance. Master-API-keys and tenant-master-API-keys can also start/stop algorithm instances, however this should only be used in exceptional cases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_command_with_http_info(algorithm_id, instance_id, command, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param instance_id: (required)
        :type instance_id: str
        :param command: (required)
        :type command: AlgoCommand
        :param bypass_validation: When set to true, the specified parameters will not be validated against the json schema of the algorithm.
        :type bypass_validation: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AlgoInstance, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'algorithm_id',
            'instance_id',
            'command',
            'bypass_validation'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_command" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if self.api_client.client_side_validation and local_var_params.get('algorithm_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_id` when calling `submit_command`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if self.api_client.client_side_validation and local_var_params.get('instance_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `instance_id` when calling `submit_command`")  # noqa: E501
        # verify the required parameter 'command' is set
        if self.api_client.client_side_validation and local_var_params.get('command') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `command` when calling `submit_command`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in local_var_params:
            path_params['algorithm_id'] = local_var_params['algorithm_id']  # noqa: E501
        if 'instance_id' in local_var_params:
            path_params['instance_id'] = local_var_params['instance_id']  # noqa: E501

        query_params = []
        if local_var_params.get('bypass_validation') is not None:  # noqa: E501
            query_params.append(('bypass_validation', local_var_params['bypass_validation']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'command' in local_var_params:
            body_params = local_var_params['command']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "AlgoInstance",
        }

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instance/{instance_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def submit_heart_beat(self, algorithm_id, instance_id, status, **kwargs):  # noqa: E501
        """Submit algorithm instance heartbeat  # noqa: E501

        Use this endpoint to submit a heartbeat to confirm that the algorithm instance is running correctly. The heartbeat must be sent continuously, every X seconds as specified in the algorithm. Note: The \"status\" sent via this request (heartbeat-status) influences the \"status\" of the instance. In case the status of the instance is NOT \"IDLE\" (= deactivated), the following behavior applies: - heartbeat-status = OK -> status RUNNING - heartbeat-status = FAILURE -> status FAILURE  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_heart_beat(algorithm_id, instance_id, status, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param instance_id: (required)
        :type instance_id: str
        :param status: (required)
        :type status: AlgoHeartbeat
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.submit_heart_beat_with_http_info(algorithm_id, instance_id, status, **kwargs)  # noqa: E501

    def submit_heart_beat_with_http_info(self, algorithm_id, instance_id, status, **kwargs):  # noqa: E501
        """Submit algorithm instance heartbeat  # noqa: E501

        Use this endpoint to submit a heartbeat to confirm that the algorithm instance is running correctly. The heartbeat must be sent continuously, every X seconds as specified in the algorithm. Note: The \"status\" sent via this request (heartbeat-status) influences the \"status\" of the instance. In case the status of the instance is NOT \"IDLE\" (= deactivated), the following behavior applies: - heartbeat-status = OK -> status RUNNING - heartbeat-status = FAILURE -> status FAILURE  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_heart_beat_with_http_info(algorithm_id, instance_id, status, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param instance_id: (required)
        :type instance_id: str
        :param status: (required)
        :type status: AlgoHeartbeat
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'algorithm_id',
            'instance_id',
            'status'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_heart_beat" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if self.api_client.client_side_validation and local_var_params.get('algorithm_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_id` when calling `submit_heart_beat`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if self.api_client.client_side_validation and local_var_params.get('instance_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `instance_id` when calling `submit_heart_beat`")  # noqa: E501
        # verify the required parameter 'status' is set
        if self.api_client.client_side_validation and local_var_params.get('status') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `status` when calling `submit_heart_beat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in local_var_params:
            path_params['algorithm_id'] = local_var_params['algorithm_id']  # noqa: E501
        if 'instance_id' in local_var_params:
            path_params['instance_id'] = local_var_params['instance_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'status' in local_var_params:
            body_params = local_var_params['status']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instance/{instance_id}/heartbeat', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_algo_instance(self, algorithm_id, instance_id, update_instance_request, **kwargs):  # noqa: E501
        """Update algorithm instance  # noqa: E501

        Note that algorithm instance changes will only be accepted if the algorithm is in \"IDLE\" state. - Master-API-keys can update all instances. - Tenant-Master-API-keys can only update instances where the key has access to ALL portfolios specified in the instance. - Standard-API-keys can only update instances where the key has access to ALL portfolios specified in the instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_algo_instance(algorithm_id, instance_id, update_instance_request, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param instance_id: (required)
        :type instance_id: str
        :param update_instance_request: (required)
        :type update_instance_request: UpdateInstanceRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AlgoInstance
        """
        kwargs['_return_http_data_only'] = True
        return self.update_algo_instance_with_http_info(algorithm_id, instance_id, update_instance_request, **kwargs)  # noqa: E501

    def update_algo_instance_with_http_info(self, algorithm_id, instance_id, update_instance_request, **kwargs):  # noqa: E501
        """Update algorithm instance  # noqa: E501

        Note that algorithm instance changes will only be accepted if the algorithm is in \"IDLE\" state. - Master-API-keys can update all instances. - Tenant-Master-API-keys can only update instances where the key has access to ALL portfolios specified in the instance. - Standard-API-keys can only update instances where the key has access to ALL portfolios specified in the instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_algo_instance_with_http_info(algorithm_id, instance_id, update_instance_request, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param instance_id: (required)
        :type instance_id: str
        :param update_instance_request: (required)
        :type update_instance_request: UpdateInstanceRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AlgoInstance, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'algorithm_id',
            'instance_id',
            'update_instance_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_algo_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if self.api_client.client_side_validation and local_var_params.get('algorithm_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_id` when calling `update_algo_instance`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if self.api_client.client_side_validation and local_var_params.get('instance_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `instance_id` when calling `update_algo_instance`")  # noqa: E501
        # verify the required parameter 'update_instance_request' is set
        if self.api_client.client_side_validation and local_var_params.get('update_instance_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_instance_request` when calling `update_algo_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in local_var_params:
            path_params['algorithm_id'] = local_var_params['algorithm_id']  # noqa: E501
        if 'instance_id' in local_var_params:
            path_params['instance_id'] = local_var_params['instance_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_instance_request' in local_var_params:
            body_params = local_var_params['update_instance_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PATCH', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "AlgoInstance",
        }

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instance/{instance_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_algo_parameters(self, algorithm_id, instance_id, parameters, **kwargs):  # noqa: E501
        """Update algorithm instance parameter  # noqa: E501

        Note that parameter changes will only be accepted if the algorithm is in \"IDLE\" state. - Master-API-keys can update all instances. - Tenant-Master-API-keys can only update instances where the key has access to ALL portfolios specified in the instance. - Standard-API-keys can only update instances where the key has access to ALL portfolios specified in the instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_algo_parameters(algorithm_id, instance_id, parameters, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param instance_id: (required)
        :type instance_id: str
        :param parameters: (required)
        :type parameters: object
        :param bypass_validation: When set to true, the specified parameters will not be validated against the json schema of the algorithm.
        :type bypass_validation: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AlgoInstance
        """
        kwargs['_return_http_data_only'] = True
        return self.update_algo_parameters_with_http_info(algorithm_id, instance_id, parameters, **kwargs)  # noqa: E501

    def update_algo_parameters_with_http_info(self, algorithm_id, instance_id, parameters, **kwargs):  # noqa: E501
        """Update algorithm instance parameter  # noqa: E501

        Note that parameter changes will only be accepted if the algorithm is in \"IDLE\" state. - Master-API-keys can update all instances. - Tenant-Master-API-keys can only update instances where the key has access to ALL portfolios specified in the instance. - Standard-API-keys can only update instances where the key has access to ALL portfolios specified in the instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_algo_parameters_with_http_info(algorithm_id, instance_id, parameters, async_req=True)
        >>> result = thread.get()

        :param algorithm_id: (required)
        :type algorithm_id: str
        :param instance_id: (required)
        :type instance_id: str
        :param parameters: (required)
        :type parameters: object
        :param bypass_validation: When set to true, the specified parameters will not be validated against the json schema of the algorithm.
        :type bypass_validation: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AlgoInstance, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'algorithm_id',
            'instance_id',
            'parameters',
            'bypass_validation'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_algo_parameters" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if self.api_client.client_side_validation and local_var_params.get('algorithm_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `algorithm_id` when calling `update_algo_parameters`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if self.api_client.client_side_validation and local_var_params.get('instance_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `instance_id` when calling `update_algo_parameters`")  # noqa: E501
        # verify the required parameter 'parameters' is set
        if self.api_client.client_side_validation and local_var_params.get('parameters') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `parameters` when calling `update_algo_parameters`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in local_var_params:
            path_params['algorithm_id'] = local_var_params['algorithm_id']  # noqa: E501
        if 'instance_id' in local_var_params:
            path_params['instance_id'] = local_var_params['instance_id']  # noqa: E501

        query_params = []
        if local_var_params.get('bypass_validation') is not None:  # noqa: E501
            query_params.append(('bypass_validation', local_var_params['bypass_validation']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'parameters' in local_var_params:
            body_params = local_var_params['parameters']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "AlgoInstance",
        }

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instance/{instance_id}/parameters', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
