# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_asyncio_client.configuration import Configuration


class Auction(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'auction_id': 'str',
        'name': 'str',
        'delivery_start': 'datetime',
        'delivery_end': 'datetime',
        'delivery_areas': 'list[str]',
        'contracts': 'list[AuctionContract]',
        'order_entry_start': 'datetime',
        'order_entry_end': 'datetime',
        'state': 'AuctionState',
        'product_name': 'str',
        'auction_type': 'AuctionType'
    }

    attribute_map = {
        'auction_id': 'auction_id',
        'name': 'name',
        'delivery_start': 'delivery_start',
        'delivery_end': 'delivery_end',
        'delivery_areas': 'delivery_areas',
        'contracts': 'contracts',
        'order_entry_start': 'order_entry_start',
        'order_entry_end': 'order_entry_end',
        'state': 'state',
        'product_name': 'product_name',
        'auction_type': 'auction_type'
    }

    def __init__(self, auction_id=None, name=None, delivery_start=None, delivery_end=None, delivery_areas=None, contracts=None, order_entry_start=None, order_entry_end=None, state=None, product_name=None, auction_type=None, local_vars_configuration=None):  # noqa: E501
        """Auction - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._auction_id = None
        self._name = None
        self._delivery_start = None
        self._delivery_end = None
        self._delivery_areas = None
        self._contracts = None
        self._order_entry_start = None
        self._order_entry_end = None
        self._state = None
        self._product_name = None
        self._auction_type = None
        self.discriminator = None

        self.auction_id = auction_id
        self.name = name
        self.delivery_start = delivery_start
        self.delivery_end = delivery_end
        self.delivery_areas = delivery_areas
        self.contracts = contracts
        if order_entry_start is not None:
            self.order_entry_start = order_entry_start
        self.order_entry_end = order_entry_end
        self.state = state
        if product_name is not None:
            self.product_name = product_name
        if auction_type is not None:
            self.auction_type = auction_type

    @property
    def auction_id(self):
        """Gets the auction_id of this Auction.  # noqa: E501

        The ID of the auction.  # noqa: E501

        :return: The auction_id of this Auction.  # noqa: E501
        :rtype: str
        """
        return self._auction_id

    @auction_id.setter
    def auction_id(self, auction_id):
        """Sets the auction_id of this Auction.

        The ID of the auction.  # noqa: E501

        :param auction_id: The auction_id of this Auction.  # noqa: E501
        :type auction_id: str
        """
        if self.local_vars_configuration.client_side_validation and auction_id is None:  # noqa: E501
            raise ValueError("Invalid value for `auction_id`, must not be `None`")  # noqa: E501

        self._auction_id = auction_id

    @property
    def name(self):
        """Gets the name of this Auction.  # noqa: E501

        The name of the auction.  # noqa: E501

        :return: The name of this Auction.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Auction.

        The name of the auction.  # noqa: E501

        :param name: The name of this Auction.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def delivery_start(self):
        """Gets the delivery_start of this Auction.  # noqa: E501

        The first delivery start of the auction.  # noqa: E501

        :return: The delivery_start of this Auction.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_start

    @delivery_start.setter
    def delivery_start(self, delivery_start):
        """Sets the delivery_start of this Auction.

        The first delivery start of the auction.  # noqa: E501

        :param delivery_start: The delivery_start of this Auction.  # noqa: E501
        :type delivery_start: datetime
        """
        if self.local_vars_configuration.client_side_validation and delivery_start is None:  # noqa: E501
            raise ValueError("Invalid value for `delivery_start`, must not be `None`")  # noqa: E501

        self._delivery_start = delivery_start

    @property
    def delivery_end(self):
        """Gets the delivery_end of this Auction.  # noqa: E501

        The last delivery end of the auction.  # noqa: E501

        :return: The delivery_end of this Auction.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_end

    @delivery_end.setter
    def delivery_end(self, delivery_end):
        """Sets the delivery_end of this Auction.

        The last delivery end of the auction.  # noqa: E501

        :param delivery_end: The delivery_end of this Auction.  # noqa: E501
        :type delivery_end: datetime
        """
        if self.local_vars_configuration.client_side_validation and delivery_end is None:  # noqa: E501
            raise ValueError("Invalid value for `delivery_end`, must not be `None`")  # noqa: E501

        self._delivery_end = delivery_end

    @property
    def delivery_areas(self):
        """Gets the delivery_areas of this Auction.  # noqa: E501

        The delivery areas where the auction takes place.  # noqa: E501

        :return: The delivery_areas of this Auction.  # noqa: E501
        :rtype: list[str]
        """
        return self._delivery_areas

    @delivery_areas.setter
    def delivery_areas(self, delivery_areas):
        """Sets the delivery_areas of this Auction.

        The delivery areas where the auction takes place.  # noqa: E501

        :param delivery_areas: The delivery_areas of this Auction.  # noqa: E501
        :type delivery_areas: list[str]
        """
        if self.local_vars_configuration.client_side_validation and delivery_areas is None:  # noqa: E501
            raise ValueError("Invalid value for `delivery_areas`, must not be `None`")  # noqa: E501

        self._delivery_areas = delivery_areas

    @property
    def contracts(self):
        """Gets the contracts of this Auction.  # noqa: E501


        :return: The contracts of this Auction.  # noqa: E501
        :rtype: list[AuctionContract]
        """
        return self._contracts

    @contracts.setter
    def contracts(self, contracts):
        """Sets the contracts of this Auction.


        :param contracts: The contracts of this Auction.  # noqa: E501
        :type contracts: list[AuctionContract]
        """
        if self.local_vars_configuration.client_side_validation and contracts is None:  # noqa: E501
            raise ValueError("Invalid value for `contracts`, must not be `None`")  # noqa: E501

        self._contracts = contracts

    @property
    def order_entry_start(self):
        """Gets the order_entry_start of this Auction.  # noqa: E501

        The time after which orders can be started to be placed.  # noqa: E501

        :return: The order_entry_start of this Auction.  # noqa: E501
        :rtype: datetime
        """
        return self._order_entry_start

    @order_entry_start.setter
    def order_entry_start(self, order_entry_start):
        """Sets the order_entry_start of this Auction.

        The time after which orders can be started to be placed.  # noqa: E501

        :param order_entry_start: The order_entry_start of this Auction.  # noqa: E501
        :type order_entry_start: datetime
        """

        self._order_entry_start = order_entry_start

    @property
    def order_entry_end(self):
        """Gets the order_entry_end of this Auction.  # noqa: E501

        The time after which order placement is closed.  # noqa: E501

        :return: The order_entry_end of this Auction.  # noqa: E501
        :rtype: datetime
        """
        return self._order_entry_end

    @order_entry_end.setter
    def order_entry_end(self, order_entry_end):
        """Sets the order_entry_end of this Auction.

        The time after which order placement is closed.  # noqa: E501

        :param order_entry_end: The order_entry_end of this Auction.  # noqa: E501
        :type order_entry_end: datetime
        """
        if self.local_vars_configuration.client_side_validation and order_entry_end is None:  # noqa: E501
            raise ValueError("Invalid value for `order_entry_end`, must not be `None`")  # noqa: E501

        self._order_entry_end = order_entry_end

    @property
    def state(self):
        """Gets the state of this Auction.  # noqa: E501


        :return: The state of this Auction.  # noqa: E501
        :rtype: AuctionState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Auction.


        :param state: The state of this Auction.  # noqa: E501
        :type state: AuctionState
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def product_name(self):
        """Gets the product_name of this Auction.  # noqa: E501

        The name of the product the auction is applicable to.  # noqa: E501

        :return: The product_name of this Auction.  # noqa: E501
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """Sets the product_name of this Auction.

        The name of the product the auction is applicable to.  # noqa: E501

        :param product_name: The product_name of this Auction.  # noqa: E501
        :type product_name: str
        """

        self._product_name = product_name

    @property
    def auction_type(self):
        """Gets the auction_type of this Auction.  # noqa: E501


        :return: The auction_type of this Auction.  # noqa: E501
        :rtype: AuctionType
        """
        return self._auction_type

    @auction_type.setter
    def auction_type(self, auction_type):
        """Sets the auction_type of this Auction.


        :param auction_type: The auction_type of this Auction.  # noqa: E501
        :type auction_type: AuctionType
        """

        self._auction_type = auction_type

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Auction):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Auction):
            return True

        return self.to_dict() != other.to_dict()
