# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_asyncio_client.configuration import Configuration


class AuctionOrder(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'order_id': 'str',
        'auction_id': 'str',
        'delivery_area': 'str',
        'portfolio_id': 'str',
        'currency': 'str',
        'modified_at': 'datetime',
        'revision': 'int',
        'state': 'AuctionOrderState',
        'type': 'AuctionOrderType',
        'order_data': 'AuctionOrderData'
    }

    attribute_map = {
        'order_id': 'order_id',
        'auction_id': 'auction_id',
        'delivery_area': 'delivery_area',
        'portfolio_id': 'portfolio_id',
        'currency': 'currency',
        'modified_at': 'modified_at',
        'revision': 'revision',
        'state': 'state',
        'type': 'type',
        'order_data': 'order_data'
    }

    def __init__(self, order_id=None, auction_id=None, delivery_area=None, portfolio_id=None, currency=None, modified_at=None, revision=None, state=None, type=None, order_data=None, local_vars_configuration=None):  # noqa: E501
        """AuctionOrder - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._order_id = None
        self._auction_id = None
        self._delivery_area = None
        self._portfolio_id = None
        self._currency = None
        self._modified_at = None
        self._revision = None
        self._state = None
        self._type = None
        self._order_data = None
        self.discriminator = None

        self.order_id = order_id
        self.auction_id = auction_id
        self.delivery_area = delivery_area
        self.portfolio_id = portfolio_id
        if currency is not None:
            self.currency = currency
        self.modified_at = modified_at
        self.revision = revision
        self.state = state
        if type is not None:
            self.type = type
        self.order_data = order_data

    @property
    def order_id(self):
        """Gets the order_id of this AuctionOrder.  # noqa: E501

        The ID of the current order revision.  # noqa: E501

        :return: The order_id of this AuctionOrder.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this AuctionOrder.

        The ID of the current order revision.  # noqa: E501

        :param order_id: The order_id of this AuctionOrder.  # noqa: E501
        :type order_id: str
        """
        if self.local_vars_configuration.client_side_validation and order_id is None:  # noqa: E501
            raise ValueError("Invalid value for `order_id`, must not be `None`")  # noqa: E501

        self._order_id = order_id

    @property
    def auction_id(self):
        """Gets the auction_id of this AuctionOrder.  # noqa: E501

        The ID of the auction.  # noqa: E501

        :return: The auction_id of this AuctionOrder.  # noqa: E501
        :rtype: str
        """
        return self._auction_id

    @auction_id.setter
    def auction_id(self, auction_id):
        """Sets the auction_id of this AuctionOrder.

        The ID of the auction.  # noqa: E501

        :param auction_id: The auction_id of this AuctionOrder.  # noqa: E501
        :type auction_id: str
        """
        if self.local_vars_configuration.client_side_validation and auction_id is None:  # noqa: E501
            raise ValueError("Invalid value for `auction_id`, must not be `None`")  # noqa: E501

        self._auction_id = auction_id

    @property
    def delivery_area(self):
        """Gets the delivery_area of this AuctionOrder.  # noqa: E501

        The delivery area of the order.  # noqa: E501

        :return: The delivery_area of this AuctionOrder.  # noqa: E501
        :rtype: str
        """
        return self._delivery_area

    @delivery_area.setter
    def delivery_area(self, delivery_area):
        """Sets the delivery_area of this AuctionOrder.

        The delivery area of the order.  # noqa: E501

        :param delivery_area: The delivery_area of this AuctionOrder.  # noqa: E501
        :type delivery_area: str
        """
        if self.local_vars_configuration.client_side_validation and delivery_area is None:  # noqa: E501
            raise ValueError("Invalid value for `delivery_area`, must not be `None`")  # noqa: E501

        self._delivery_area = delivery_area

    @property
    def portfolio_id(self):
        """Gets the portfolio_id of this AuctionOrder.  # noqa: E501

        The ID of the portfolio.  # noqa: E501

        :return: The portfolio_id of this AuctionOrder.  # noqa: E501
        :rtype: str
        """
        return self._portfolio_id

    @portfolio_id.setter
    def portfolio_id(self, portfolio_id):
        """Sets the portfolio_id of this AuctionOrder.

        The ID of the portfolio.  # noqa: E501

        :param portfolio_id: The portfolio_id of this AuctionOrder.  # noqa: E501
        :type portfolio_id: str
        """
        if self.local_vars_configuration.client_side_validation and portfolio_id is None:  # noqa: E501
            raise ValueError("Invalid value for `portfolio_id`, must not be `None`")  # noqa: E501

        self._portfolio_id = portfolio_id

    @property
    def currency(self):
        """Gets the currency of this AuctionOrder.  # noqa: E501

        The currency of the order.  # noqa: E501

        :return: The currency of this AuctionOrder.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this AuctionOrder.

        The currency of the order.  # noqa: E501

        :param currency: The currency of this AuctionOrder.  # noqa: E501
        :type currency: str
        """

        self._currency = currency

    @property
    def modified_at(self):
        """Gets the modified_at of this AuctionOrder.  # noqa: E501

        The timestamp of the last order modification.  # noqa: E501

        :return: The modified_at of this AuctionOrder.  # noqa: E501
        :rtype: datetime
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this AuctionOrder.

        The timestamp of the last order modification.  # noqa: E501

        :param modified_at: The modified_at of this AuctionOrder.  # noqa: E501
        :type modified_at: datetime
        """
        if self.local_vars_configuration.client_side_validation and modified_at is None:  # noqa: E501
            raise ValueError("Invalid value for `modified_at`, must not be `None`")  # noqa: E501

        self._modified_at = modified_at

    @property
    def revision(self):
        """Gets the revision of this AuctionOrder.  # noqa: E501


        :return: The revision of this AuctionOrder.  # noqa: E501
        :rtype: int
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this AuctionOrder.


        :param revision: The revision of this AuctionOrder.  # noqa: E501
        :type revision: int
        """
        if self.local_vars_configuration.client_side_validation and revision is None:  # noqa: E501
            raise ValueError("Invalid value for `revision`, must not be `None`")  # noqa: E501

        self._revision = revision

    @property
    def state(self):
        """Gets the state of this AuctionOrder.  # noqa: E501


        :return: The state of this AuctionOrder.  # noqa: E501
        :rtype: AuctionOrderState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this AuctionOrder.


        :param state: The state of this AuctionOrder.  # noqa: E501
        :type state: AuctionOrderState
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def type(self):
        """Gets the type of this AuctionOrder.  # noqa: E501


        :return: The type of this AuctionOrder.  # noqa: E501
        :rtype: AuctionOrderType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this AuctionOrder.


        :param type: The type of this AuctionOrder.  # noqa: E501
        :type type: AuctionOrderType
        """

        self._type = type

    @property
    def order_data(self):
        """Gets the order_data of this AuctionOrder.  # noqa: E501


        :return: The order_data of this AuctionOrder.  # noqa: E501
        :rtype: AuctionOrderData
        """
        return self._order_data

    @order_data.setter
    def order_data(self, order_data):
        """Sets the order_data of this AuctionOrder.


        :param order_data: The order_data of this AuctionOrder.  # noqa: E501
        :type order_data: AuctionOrderData
        """
        if self.local_vars_configuration.client_side_validation and order_data is None:  # noqa: E501
            raise ValueError("Invalid value for `order_data`, must not be `None`")  # noqa: E501

        self._order_data = order_data

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuctionOrder):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AuctionOrder):
            return True

        return self.to_dict() != other.to_dict()
