# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_asyncio_client.configuration import Configuration


class OrderBookStatisticsContract(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'contract_id': 'str',
        'product': 'str',
        'best_bid_price': 'float',
        'best_bid_quantity': 'float',
        'best_ask_price': 'float',
        'best_ask_quantity': 'float',
        'last_price': 'float',
        'last_quantity': 'float',
        'total_quantity': 'float',
        'high': 'float',
        'low': 'float',
        'vwap': 'float',
        'depth_values': 'list[OrderBookDepthValue]',
        'average_bid': 'float',
        'average_ask': 'float'
    }

    attribute_map = {
        'contract_id': 'contract_id',
        'product': 'product',
        'best_bid_price': 'best_bid_price',
        'best_bid_quantity': 'best_bid_quantity',
        'best_ask_price': 'best_ask_price',
        'best_ask_quantity': 'best_ask_quantity',
        'last_price': 'last_price',
        'last_quantity': 'last_quantity',
        'total_quantity': 'total_quantity',
        'high': 'high',
        'low': 'low',
        'vwap': 'vwap',
        'depth_values': 'depth_values',
        'average_bid': 'average_bid',
        'average_ask': 'average_ask'
    }

    def __init__(self, contract_id=None, product=None, best_bid_price=None, best_bid_quantity=None, best_ask_price=None, best_ask_quantity=None, last_price=None, last_quantity=None, total_quantity=None, high=None, low=None, vwap=None, depth_values=None, average_bid=None, average_ask=None, local_vars_configuration=None):  # noqa: E501
        """OrderBookStatisticsContract - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._contract_id = None
        self._product = None
        self._best_bid_price = None
        self._best_bid_quantity = None
        self._best_ask_price = None
        self._best_ask_quantity = None
        self._last_price = None
        self._last_quantity = None
        self._total_quantity = None
        self._high = None
        self._low = None
        self._vwap = None
        self._depth_values = None
        self._average_bid = None
        self._average_ask = None
        self.discriminator = None

        if contract_id is not None:
            self.contract_id = contract_id
        if product is not None:
            self.product = product
        if best_bid_price is not None:
            self.best_bid_price = best_bid_price
        if best_bid_quantity is not None:
            self.best_bid_quantity = best_bid_quantity
        if best_ask_price is not None:
            self.best_ask_price = best_ask_price
        if best_ask_quantity is not None:
            self.best_ask_quantity = best_ask_quantity
        if last_price is not None:
            self.last_price = last_price
        if last_quantity is not None:
            self.last_quantity = last_quantity
        if total_quantity is not None:
            self.total_quantity = total_quantity
        if high is not None:
            self.high = high
        if low is not None:
            self.low = low
        if vwap is not None:
            self.vwap = vwap
        if depth_values is not None:
            self.depth_values = depth_values
        if average_bid is not None:
            self.average_bid = average_bid
        if average_ask is not None:
            self.average_ask = average_ask

    @property
    def contract_id(self):
        """Gets the contract_id of this OrderBookStatisticsContract.  # noqa: E501


        :return: The contract_id of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this OrderBookStatisticsContract.


        :param contract_id: The contract_id of this OrderBookStatisticsContract.  # noqa: E501
        :type contract_id: str
        """

        self._contract_id = contract_id

    @property
    def product(self):
        """Gets the product of this OrderBookStatisticsContract.  # noqa: E501


        :return: The product of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this OrderBookStatisticsContract.


        :param product: The product of this OrderBookStatisticsContract.  # noqa: E501
        :type product: str
        """

        self._product = product

    @property
    def best_bid_price(self):
        """Gets the best_bid_price of this OrderBookStatisticsContract.  # noqa: E501

        The price of the best bid.  # noqa: E501

        :return: The best_bid_price of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: float
        """
        return self._best_bid_price

    @best_bid_price.setter
    def best_bid_price(self, best_bid_price):
        """Sets the best_bid_price of this OrderBookStatisticsContract.

        The price of the best bid.  # noqa: E501

        :param best_bid_price: The best_bid_price of this OrderBookStatisticsContract.  # noqa: E501
        :type best_bid_price: float
        """

        self._best_bid_price = best_bid_price

    @property
    def best_bid_quantity(self):
        """Gets the best_bid_quantity of this OrderBookStatisticsContract.  # noqa: E501

        The quantity of the best bid.  # noqa: E501

        :return: The best_bid_quantity of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: float
        """
        return self._best_bid_quantity

    @best_bid_quantity.setter
    def best_bid_quantity(self, best_bid_quantity):
        """Sets the best_bid_quantity of this OrderBookStatisticsContract.

        The quantity of the best bid.  # noqa: E501

        :param best_bid_quantity: The best_bid_quantity of this OrderBookStatisticsContract.  # noqa: E501
        :type best_bid_quantity: float
        """

        self._best_bid_quantity = best_bid_quantity

    @property
    def best_ask_price(self):
        """Gets the best_ask_price of this OrderBookStatisticsContract.  # noqa: E501

        The price of the best ask.  # noqa: E501

        :return: The best_ask_price of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: float
        """
        return self._best_ask_price

    @best_ask_price.setter
    def best_ask_price(self, best_ask_price):
        """Sets the best_ask_price of this OrderBookStatisticsContract.

        The price of the best ask.  # noqa: E501

        :param best_ask_price: The best_ask_price of this OrderBookStatisticsContract.  # noqa: E501
        :type best_ask_price: float
        """

        self._best_ask_price = best_ask_price

    @property
    def best_ask_quantity(self):
        """Gets the best_ask_quantity of this OrderBookStatisticsContract.  # noqa: E501

        The quantity of the best ask.  # noqa: E501

        :return: The best_ask_quantity of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: float
        """
        return self._best_ask_quantity

    @best_ask_quantity.setter
    def best_ask_quantity(self, best_ask_quantity):
        """Sets the best_ask_quantity of this OrderBookStatisticsContract.

        The quantity of the best ask.  # noqa: E501

        :param best_ask_quantity: The best_ask_quantity of this OrderBookStatisticsContract.  # noqa: E501
        :type best_ask_quantity: float
        """

        self._best_ask_quantity = best_ask_quantity

    @property
    def last_price(self):
        """Gets the last_price of this OrderBookStatisticsContract.  # noqa: E501

        The price of the last trade  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :return: The last_price of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: float
        """
        return self._last_price

    @last_price.setter
    def last_price(self, last_price):
        """Sets the last_price of this OrderBookStatisticsContract.

        The price of the last trade  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :param last_price: The last_price of this OrderBookStatisticsContract.  # noqa: E501
        :type last_price: float
        """

        self._last_price = last_price

    @property
    def last_quantity(self):
        """Gets the last_quantity of this OrderBookStatisticsContract.  # noqa: E501

        The quantity of the last trade  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :return: The last_quantity of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: float
        """
        return self._last_quantity

    @last_quantity.setter
    def last_quantity(self, last_quantity):
        """Sets the last_quantity of this OrderBookStatisticsContract.

        The quantity of the last trade  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :param last_quantity: The last_quantity of this OrderBookStatisticsContract.  # noqa: E501
        :type last_quantity: float
        """

        self._last_quantity = last_quantity

    @property
    def total_quantity(self):
        """Gets the total_quantity of this OrderBookStatisticsContract.  # noqa: E501

        The total volume of all trades  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Each side of a trade is counted separately, so a trade with both sides in the same market area gets counted twice. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :return: The total_quantity of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: float
        """
        return self._total_quantity

    @total_quantity.setter
    def total_quantity(self, total_quantity):
        """Sets the total_quantity of this OrderBookStatisticsContract.

        The total volume of all trades  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Each side of a trade is counted separately, so a trade with both sides in the same market area gets counted twice. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :param total_quantity: The total_quantity of this OrderBookStatisticsContract.  # noqa: E501
        :type total_quantity: float
        """

        self._total_quantity = total_quantity

    @property
    def high(self):
        """Gets the high of this OrderBookStatisticsContract.  # noqa: E501

        The highest traded price  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :return: The high of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: float
        """
        return self._high

    @high.setter
    def high(self, high):
        """Sets the high of this OrderBookStatisticsContract.

        The highest traded price  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :param high: The high of this OrderBookStatisticsContract.  # noqa: E501
        :type high: float
        """

        self._high = high

    @property
    def low(self):
        """Gets the low of this OrderBookStatisticsContract.  # noqa: E501

        The lowest traded price  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :return: The low of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: float
        """
        return self._low

    @low.setter
    def low(self, low):
        """Sets the low of this OrderBookStatisticsContract.

        The lowest traded price  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :param low: The low of this OrderBookStatisticsContract.  # noqa: E501
        :type low: float
        """

        self._low = low

    @property
    def vwap(self):
        """Gets the vwap of this OrderBookStatisticsContract.  # noqa: E501

        The volume weighted average price  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Each side of a trade is counted separately, so a trade with both sides in the same market area gets counted twice. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :return: The vwap of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: float
        """
        return self._vwap

    @vwap.setter
    def vwap(self, vwap):
        """Sets the vwap of this OrderBookStatisticsContract.

        The volume weighted average price  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Each side of a trade is counted separately, so a trade with both sides in the same market area gets counted twice. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :param vwap: The vwap of this OrderBookStatisticsContract.  # noqa: E501
        :type vwap: float
        """

        self._vwap = vwap

    @property
    def depth_values(self):
        """Gets the depth_values of this OrderBookStatisticsContract.  # noqa: E501


        :return: The depth_values of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: list[OrderBookDepthValue]
        """
        return self._depth_values

    @depth_values.setter
    def depth_values(self, depth_values):
        """Sets the depth_values of this OrderBookStatisticsContract.


        :param depth_values: The depth_values of this OrderBookStatisticsContract.  # noqa: E501
        :type depth_values: list[OrderBookDepthValue]
        """

        self._depth_values = depth_values

    @property
    def average_bid(self):
        """Gets the average_bid of this OrderBookStatisticsContract.  # noqa: E501


        :return: The average_bid of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: float
        """
        return self._average_bid

    @average_bid.setter
    def average_bid(self, average_bid):
        """Sets the average_bid of this OrderBookStatisticsContract.


        :param average_bid: The average_bid of this OrderBookStatisticsContract.  # noqa: E501
        :type average_bid: float
        """

        self._average_bid = average_bid

    @property
    def average_ask(self):
        """Gets the average_ask of this OrderBookStatisticsContract.  # noqa: E501


        :return: The average_ask of this OrderBookStatisticsContract.  # noqa: E501
        :rtype: float
        """
        return self._average_ask

    @average_ask.setter
    def average_ask(self, average_ask):
        """Sets the average_ask of this OrderBookStatisticsContract.


        :param average_ask: The average_ask of this OrderBookStatisticsContract.  # noqa: E501
        :type average_ask: float
        """

        self._average_ask = average_ask

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderBookStatisticsContract):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrderBookStatisticsContract):
            return True

        return self.to_dict() != other.to_dict()
