# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_asyncio_client.configuration import Configuration


class OrderEntry(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'delivery_area': 'str',
        'portfolio_id': 'str',
        'side': 'OrderSide',
        'prod': 'str',
        'quantity': 'float',
        'price': 'float',
        'display_qty': 'float',
        'contract_id': 'str',
        'contract_name': 'str',
        'clearing_acct_type': 'str',
        'ordr_exe_restriction': 'OrderExecutionRestriction',
        'pre_arranged': 'bool',
        'pre_arranged_acct': 'str',
        'type': 'OrderType',
        'validity_res': 'ValidityRestriction',
        'state': 'str',
        'validity_date': 'datetime',
        'txt': 'str',
        'ppd': 'float',
        'dlvry_start': 'datetime',
        'dlvry_end': 'datetime',
        'expected_net_pos': 'float',
        'expected_min_net_pos': 'float',
        'expected_max_net_pos': 'float',
        'expected_abs_pos': 'float',
        'expected_sell_abs_pos': 'float',
        'expected_buy_abs_pos': 'float',
        'location': 'str',
        'account_id': 'str',
        'strategy_id': 'str'
    }

    attribute_map = {
        'delivery_area': 'delivery_area',
        'portfolio_id': 'portfolio_id',
        'side': 'side',
        'prod': 'prod',
        'quantity': 'quantity',
        'price': 'price',
        'display_qty': 'displayQty',
        'contract_id': 'contractId',
        'contract_name': 'contractName',
        'clearing_acct_type': 'clearingAcctType',
        'ordr_exe_restriction': 'ordrExeRestriction',
        'pre_arranged': 'preArranged',
        'pre_arranged_acct': 'preArrangedAcct',
        'type': 'type',
        'validity_res': 'validityRes',
        'state': 'state',
        'validity_date': 'validityDate',
        'txt': 'txt',
        'ppd': 'ppd',
        'dlvry_start': 'dlvryStart',
        'dlvry_end': 'dlvryEnd',
        'expected_net_pos': 'expectedNetPos',
        'expected_min_net_pos': 'expectedMinNetPos',
        'expected_max_net_pos': 'expectedMaxNetPos',
        'expected_abs_pos': 'expectedAbsPos',
        'expected_sell_abs_pos': 'expectedSellAbsPos',
        'expected_buy_abs_pos': 'expectedBuyAbsPos',
        'location': 'location',
        'account_id': 'account_id',
        'strategy_id': 'strategy_id'
    }

    def __init__(self, delivery_area=None, portfolio_id=None, side=None, prod=None, quantity=None, price=None, display_qty=None, contract_id=None, contract_name=None, clearing_acct_type=None, ordr_exe_restriction=None, pre_arranged=False, pre_arranged_acct=None, type=None, validity_res=None, state=None, validity_date=None, txt=None, ppd=None, dlvry_start=None, dlvry_end=None, expected_net_pos=None, expected_min_net_pos=None, expected_max_net_pos=None, expected_abs_pos=None, expected_sell_abs_pos=None, expected_buy_abs_pos=None, location=None, account_id=None, strategy_id=None, local_vars_configuration=None):  # noqa: E501
        """OrderEntry - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._delivery_area = None
        self._portfolio_id = None
        self._side = None
        self._prod = None
        self._quantity = None
        self._price = None
        self._display_qty = None
        self._contract_id = None
        self._contract_name = None
        self._clearing_acct_type = None
        self._ordr_exe_restriction = None
        self._pre_arranged = None
        self._pre_arranged_acct = None
        self._type = None
        self._validity_res = None
        self._state = None
        self._validity_date = None
        self._txt = None
        self._ppd = None
        self._dlvry_start = None
        self._dlvry_end = None
        self._expected_net_pos = None
        self._expected_min_net_pos = None
        self._expected_max_net_pos = None
        self._expected_abs_pos = None
        self._expected_sell_abs_pos = None
        self._expected_buy_abs_pos = None
        self._location = None
        self._account_id = None
        self._strategy_id = None
        self.discriminator = None

        if delivery_area is not None:
            self.delivery_area = delivery_area
        self.portfolio_id = portfolio_id
        if side is not None:
            self.side = side
        if prod is not None:
            self.prod = prod
        self.quantity = quantity
        self.price = price
        if display_qty is not None:
            self.display_qty = display_qty
        if contract_id is not None:
            self.contract_id = contract_id
        if contract_name is not None:
            self.contract_name = contract_name
        if clearing_acct_type is not None:
            self.clearing_acct_type = clearing_acct_type
        if ordr_exe_restriction is not None:
            self.ordr_exe_restriction = ordr_exe_restriction
        if pre_arranged is not None:
            self.pre_arranged = pre_arranged
        if pre_arranged_acct is not None:
            self.pre_arranged_acct = pre_arranged_acct
        if type is not None:
            self.type = type
        if validity_res is not None:
            self.validity_res = validity_res
        if state is not None:
            self.state = state
        if validity_date is not None:
            self.validity_date = validity_date
        if txt is not None:
            self.txt = txt
        if ppd is not None:
            self.ppd = ppd
        if dlvry_start is not None:
            self.dlvry_start = dlvry_start
        if dlvry_end is not None:
            self.dlvry_end = dlvry_end
        if expected_net_pos is not None:
            self.expected_net_pos = expected_net_pos
        if expected_min_net_pos is not None:
            self.expected_min_net_pos = expected_min_net_pos
        if expected_max_net_pos is not None:
            self.expected_max_net_pos = expected_max_net_pos
        if expected_abs_pos is not None:
            self.expected_abs_pos = expected_abs_pos
        if expected_sell_abs_pos is not None:
            self.expected_sell_abs_pos = expected_sell_abs_pos
        if expected_buy_abs_pos is not None:
            self.expected_buy_abs_pos = expected_buy_abs_pos
        if location is not None:
            self.location = location
        if account_id is not None:
            self.account_id = account_id
        if strategy_id is not None:
            self.strategy_id = strategy_id

    @property
    def delivery_area(self):
        """Gets the delivery_area of this OrderEntry.  # noqa: E501

        The delivery area of the orderbook's product. Mandatory in a multi-delivery-area configuration  # noqa: E501

        :return: The delivery_area of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._delivery_area

    @delivery_area.setter
    def delivery_area(self, delivery_area):
        """Sets the delivery_area of this OrderEntry.

        The delivery area of the orderbook's product. Mandatory in a multi-delivery-area configuration  # noqa: E501

        :param delivery_area: The delivery_area of this OrderEntry.  # noqa: E501
        :type delivery_area: str
        """

        self._delivery_area = delivery_area

    @property
    def portfolio_id(self):
        """Gets the portfolio_id of this OrderEntry.  # noqa: E501


        :return: The portfolio_id of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._portfolio_id

    @portfolio_id.setter
    def portfolio_id(self, portfolio_id):
        """Sets the portfolio_id of this OrderEntry.


        :param portfolio_id: The portfolio_id of this OrderEntry.  # noqa: E501
        :type portfolio_id: str
        """
        if self.local_vars_configuration.client_side_validation and portfolio_id is None:  # noqa: E501
            raise ValueError("Invalid value for `portfolio_id`, must not be `None`")  # noqa: E501

        self._portfolio_id = portfolio_id

    @property
    def side(self):
        """Gets the side of this OrderEntry.  # noqa: E501


        :return: The side of this OrderEntry.  # noqa: E501
        :rtype: OrderSide
        """
        return self._side

    @side.setter
    def side(self, side):
        """Sets the side of this OrderEntry.


        :param side: The side of this OrderEntry.  # noqa: E501
        :type side: OrderSide
        """

        self._side = side

    @property
    def prod(self):
        """Gets the prod of this OrderEntry.  # noqa: E501

        The product of the order  # noqa: E501

        :return: The prod of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._prod

    @prod.setter
    def prod(self, prod):
        """Sets the prod of this OrderEntry.

        The product of the order  # noqa: E501

        :param prod: The prod of this OrderEntry.  # noqa: E501
        :type prod: str
        """

        self._prod = prod

    @property
    def quantity(self):
        """Gets the quantity of this OrderEntry.  # noqa: E501

        The quantity of the order in MW.  # noqa: E501

        :return: The quantity of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this OrderEntry.

        The quantity of the order in MW.  # noqa: E501

        :param quantity: The quantity of this OrderEntry.  # noqa: E501
        :type quantity: float
        """
        if self.local_vars_configuration.client_side_validation and quantity is None:  # noqa: E501
            raise ValueError("Invalid value for `quantity`, must not be `None`")  # noqa: E501

        self._quantity = quantity

    @property
    def price(self):
        """Gets the price of this OrderEntry.  # noqa: E501

        The price of the order in the contract's currency based on exchange product specification (typically in \"Currency per MWh\")  # noqa: E501

        :return: The price of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this OrderEntry.

        The price of the order in the contract's currency based on exchange product specification (typically in \"Currency per MWh\")  # noqa: E501

        :param price: The price of this OrderEntry.  # noqa: E501
        :type price: float
        """
        if self.local_vars_configuration.client_side_validation and price is None:  # noqa: E501
            raise ValueError("Invalid value for `price`, must not be `None`")  # noqa: E501

        self._price = price

    @property
    def display_qty(self):
        """Gets the display_qty of this OrderEntry.  # noqa: E501

        Used to define display quantity of an iceberg Order. This field is required only in the case of type=\"I\".  # noqa: E501

        :return: The display_qty of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._display_qty

    @display_qty.setter
    def display_qty(self, display_qty):
        """Sets the display_qty of this OrderEntry.

        Used to define display quantity of an iceberg Order. This field is required only in the case of type=\"I\".  # noqa: E501

        :param display_qty: The display_qty of this OrderEntry.  # noqa: E501
        :type display_qty: float
        """

        self._display_qty = display_qty

    @property
    def contract_id(self):
        """Gets the contract_id of this OrderEntry.  # noqa: E501

        The contractId of the order, can be omitted if contractName is specified instead.  # noqa: E501

        :return: The contract_id of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this OrderEntry.

        The contractId of the order, can be omitted if contractName is specified instead.  # noqa: E501

        :param contract_id: The contract_id of this OrderEntry.  # noqa: E501
        :type contract_id: str
        """

        self._contract_id = contract_id

    @property
    def contract_name(self):
        """Gets the contract_name of this OrderEntry.  # noqa: E501

        Set a contract name instead of the contractId, and the attempt is made to look up the contract via it's name. If contractId is set, the contractName field is ignored.  # noqa: E501

        :return: The contract_name of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._contract_name

    @contract_name.setter
    def contract_name(self, contract_name):
        """Sets the contract_name of this OrderEntry.

        Set a contract name instead of the contractId, and the attempt is made to look up the contract via it's name. If contractId is set, the contractName field is ignored.  # noqa: E501

        :param contract_name: The contract_name of this OrderEntry.  # noqa: E501
        :type contract_name: str
        """

        self._contract_name = contract_name

    @property
    def clearing_acct_type(self):
        """Gets the clearing_acct_type of this OrderEntry.  # noqa: E501

        A label for internal use, indicating whether the order is entered on its own account (\"P\") or as an agent (\"A\"). This label does not impact exchange functionality and is primarily used for internal categorization.  **Note**: Only relevant for M7 based exchanges (HUPX, SouthPool, TGE, EPEX, SEMO, OPCOM).  # noqa: E501

        :return: The clearing_acct_type of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._clearing_acct_type

    @clearing_acct_type.setter
    def clearing_acct_type(self, clearing_acct_type):
        """Sets the clearing_acct_type of this OrderEntry.

        A label for internal use, indicating whether the order is entered on its own account (\"P\") or as an agent (\"A\"). This label does not impact exchange functionality and is primarily used for internal categorization.  **Note**: Only relevant for M7 based exchanges (HUPX, SouthPool, TGE, EPEX, SEMO, OPCOM).  # noqa: E501

        :param clearing_acct_type: The clearing_acct_type of this OrderEntry.  # noqa: E501
        :type clearing_acct_type: str
        """

        self._clearing_acct_type = clearing_acct_type

    @property
    def ordr_exe_restriction(self):
        """Gets the ordr_exe_restriction of this OrderEntry.  # noqa: E501


        :return: The ordr_exe_restriction of this OrderEntry.  # noqa: E501
        :rtype: OrderExecutionRestriction
        """
        return self._ordr_exe_restriction

    @ordr_exe_restriction.setter
    def ordr_exe_restriction(self, ordr_exe_restriction):
        """Sets the ordr_exe_restriction of this OrderEntry.


        :param ordr_exe_restriction: The ordr_exe_restriction of this OrderEntry.  # noqa: E501
        :type ordr_exe_restriction: OrderExecutionRestriction
        """

        self._ordr_exe_restriction = ordr_exe_restriction

    @property
    def pre_arranged(self):
        """Gets the pre_arranged of this OrderEntry.  # noqa: E501

        Flag which indicates if the entered order is a pre-arranged order or not.  # noqa: E501

        :return: The pre_arranged of this OrderEntry.  # noqa: E501
        :rtype: bool
        """
        return self._pre_arranged

    @pre_arranged.setter
    def pre_arranged(self, pre_arranged):
        """Sets the pre_arranged of this OrderEntry.

        Flag which indicates if the entered order is a pre-arranged order or not.  # noqa: E501

        :param pre_arranged: The pre_arranged of this OrderEntry.  # noqa: E501
        :type pre_arranged: bool
        """

        self._pre_arranged = pre_arranged

    @property
    def pre_arranged_acct(self):
        """Gets the pre_arranged_acct of this OrderEntry.  # noqa: E501

        Required in case of a pre-arranged order. Contains the account of the counterpart.  # noqa: E501

        :return: The pre_arranged_acct of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._pre_arranged_acct

    @pre_arranged_acct.setter
    def pre_arranged_acct(self, pre_arranged_acct):
        """Sets the pre_arranged_acct of this OrderEntry.

        Required in case of a pre-arranged order. Contains the account of the counterpart.  # noqa: E501

        :param pre_arranged_acct: The pre_arranged_acct of this OrderEntry.  # noqa: E501
        :type pre_arranged_acct: str
        """

        self._pre_arranged_acct = pre_arranged_acct

    @property
    def type(self):
        """Gets the type of this OrderEntry.  # noqa: E501


        :return: The type of this OrderEntry.  # noqa: E501
        :rtype: OrderType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this OrderEntry.


        :param type: The type of this OrderEntry.  # noqa: E501
        :type type: OrderType
        """

        self._type = type

    @property
    def validity_res(self):
        """Gets the validity_res of this OrderEntry.  # noqa: E501


        :return: The validity_res of this OrderEntry.  # noqa: E501
        :rtype: ValidityRestriction
        """
        return self._validity_res

    @validity_res.setter
    def validity_res(self, validity_res):
        """Sets the validity_res of this OrderEntry.


        :param validity_res: The validity_res of this OrderEntry.  # noqa: E501
        :type validity_res: ValidityRestriction
        """

        self._validity_res = validity_res

    @property
    def state(self):
        """Gets the state of this OrderEntry.  # noqa: E501

        * ACTI: The order is entered and immediately exposed to the market for execution. This is the default value. * HIBE: The order is entered into the backend system but not exposed to the market.  # noqa: E501

        :return: The state of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this OrderEntry.

        * ACTI: The order is entered and immediately exposed to the market for execution. This is the default value. * HIBE: The order is entered into the backend system but not exposed to the market.  # noqa: E501

        :param state: The state of this OrderEntry.  # noqa: E501
        :type state: str
        """
        allowed_values = ["ACTI", "HIBE"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def validity_date(self):
        """Gets the validity_date of this OrderEntry.  # noqa: E501

        mandatory in case of validityRes equals \"GTD\". It is used to define the date until which the order is valid. The remaining part of the order will be removed from the order book after this point in time.  # noqa: E501

        :return: The validity_date of this OrderEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._validity_date

    @validity_date.setter
    def validity_date(self, validity_date):
        """Sets the validity_date of this OrderEntry.

        mandatory in case of validityRes equals \"GTD\". It is used to define the date until which the order is valid. The remaining part of the order will be removed from the order book after this point in time.  # noqa: E501

        :param validity_date: The validity_date of this OrderEntry.  # noqa: E501
        :type validity_date: datetime
        """

        self._validity_date = validity_date

    @property
    def txt(self):
        """Gets the txt of this OrderEntry.  # noqa: E501

        Text which can be retrieved at a later point (i.e. via a trade which was triggered by the order)  # noqa: E501

        :return: The txt of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._txt

    @txt.setter
    def txt(self, txt):
        """Sets the txt of this OrderEntry.

        Text which can be retrieved at a later point (i.e. via a trade which was triggered by the order)  # noqa: E501

        :param txt: The txt of this OrderEntry.  # noqa: E501
        :type txt: str
        """

        self._txt = txt

    @property
    def ppd(self):
        """Gets the ppd of this OrderEntry.  # noqa: E501

        Peak price delta for iceberg orders. * The ppd of buy orders must be smaller or equal than zero. * The ppd of sell orders must be greater or equal than zero. If it is omitted the system will assume a value of `0.00`.  # noqa: E501

        :return: The ppd of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._ppd

    @ppd.setter
    def ppd(self, ppd):
        """Sets the ppd of this OrderEntry.

        Peak price delta for iceberg orders. * The ppd of buy orders must be smaller or equal than zero. * The ppd of sell orders must be greater or equal than zero. If it is omitted the system will assume a value of `0.00`.  # noqa: E501

        :param ppd: The ppd of this OrderEntry.  # noqa: E501
        :type ppd: float
        """

        self._ppd = ppd

    @property
    def dlvry_start(self):
        """Gets the dlvry_start of this OrderEntry.  # noqa: E501

        (optional) Start of delivery of the underlying contract.  # noqa: E501

        :return: The dlvry_start of this OrderEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._dlvry_start

    @dlvry_start.setter
    def dlvry_start(self, dlvry_start):
        """Sets the dlvry_start of this OrderEntry.

        (optional) Start of delivery of the underlying contract.  # noqa: E501

        :param dlvry_start: The dlvry_start of this OrderEntry.  # noqa: E501
        :type dlvry_start: datetime
        """

        self._dlvry_start = dlvry_start

    @property
    def dlvry_end(self):
        """Gets the dlvry_end of this OrderEntry.  # noqa: E501

        (optional) End of delivery of the underlying contract.  # noqa: E501

        :return: The dlvry_end of this OrderEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._dlvry_end

    @dlvry_end.setter
    def dlvry_end(self, dlvry_end):
        """Sets the dlvry_end of this OrderEntry.

        (optional) End of delivery of the underlying contract.  # noqa: E501

        :param dlvry_end: The dlvry_end of this OrderEntry.  # noqa: E501
        :type dlvry_end: datetime
        """

        self._dlvry_end = dlvry_end

    @property
    def expected_net_pos(self):
        """Gets the expected_net_pos of this OrderEntry.  # noqa: E501

        The expected net_pos (see portfolio information for more details). Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :return: The expected_net_pos of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._expected_net_pos

    @expected_net_pos.setter
    def expected_net_pos(self, expected_net_pos):
        """Sets the expected_net_pos of this OrderEntry.

        The expected net_pos (see portfolio information for more details). Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :param expected_net_pos: The expected_net_pos of this OrderEntry.  # noqa: E501
        :type expected_net_pos: float
        """

        self._expected_net_pos = expected_net_pos

    @property
    def expected_min_net_pos(self):
        """Gets the expected_min_net_pos of this OrderEntry.  # noqa: E501

        The expected net_pos (see portfolio information for more details) plus the absolute quantity of all standing SELL-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :return: The expected_min_net_pos of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._expected_min_net_pos

    @expected_min_net_pos.setter
    def expected_min_net_pos(self, expected_min_net_pos):
        """Sets the expected_min_net_pos of this OrderEntry.

        The expected net_pos (see portfolio information for more details) plus the absolute quantity of all standing SELL-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :param expected_min_net_pos: The expected_min_net_pos of this OrderEntry.  # noqa: E501
        :type expected_min_net_pos: float
        """

        self._expected_min_net_pos = expected_min_net_pos

    @property
    def expected_max_net_pos(self):
        """Gets the expected_max_net_pos of this OrderEntry.  # noqa: E501

        The expected net_pos (see portfolio information for more details) plus the absolute quantity of all standing BUY-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :return: The expected_max_net_pos of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._expected_max_net_pos

    @expected_max_net_pos.setter
    def expected_max_net_pos(self, expected_max_net_pos):
        """Sets the expected_max_net_pos of this OrderEntry.

        The expected net_pos (see portfolio information for more details) plus the absolute quantity of all standing BUY-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :param expected_max_net_pos: The expected_max_net_pos of this OrderEntry.  # noqa: E501
        :type expected_max_net_pos: float
        """

        self._expected_max_net_pos = expected_max_net_pos

    @property
    def expected_abs_pos(self):
        """Gets the expected_abs_pos of this OrderEntry.  # noqa: E501

        The expected abs_pos (see portfolio information for more details). Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :return: The expected_abs_pos of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._expected_abs_pos

    @expected_abs_pos.setter
    def expected_abs_pos(self, expected_abs_pos):
        """Sets the expected_abs_pos of this OrderEntry.

        The expected abs_pos (see portfolio information for more details). Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :param expected_abs_pos: The expected_abs_pos of this OrderEntry.  # noqa: E501
        :type expected_abs_pos: float
        """

        self._expected_abs_pos = expected_abs_pos

    @property
    def expected_sell_abs_pos(self):
        """Gets the expected_sell_abs_pos of this OrderEntry.  # noqa: E501

        The expected abs_pos (see portfolio information for more details) plus the absolute quantity of all standing SELL-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :return: The expected_sell_abs_pos of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._expected_sell_abs_pos

    @expected_sell_abs_pos.setter
    def expected_sell_abs_pos(self, expected_sell_abs_pos):
        """Sets the expected_sell_abs_pos of this OrderEntry.

        The expected abs_pos (see portfolio information for more details) plus the absolute quantity of all standing SELL-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :param expected_sell_abs_pos: The expected_sell_abs_pos of this OrderEntry.  # noqa: E501
        :type expected_sell_abs_pos: float
        """

        self._expected_sell_abs_pos = expected_sell_abs_pos

    @property
    def expected_buy_abs_pos(self):
        """Gets the expected_buy_abs_pos of this OrderEntry.  # noqa: E501

        The expected abs_pos (see portfolio information for more details) plus the absolute quantity of all standing BUY-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :return: The expected_buy_abs_pos of this OrderEntry.  # noqa: E501
        :rtype: float
        """
        return self._expected_buy_abs_pos

    @expected_buy_abs_pos.setter
    def expected_buy_abs_pos(self, expected_buy_abs_pos):
        """Sets the expected_buy_abs_pos of this OrderEntry.

        The expected abs_pos (see portfolio information for more details) plus the absolute quantity of all standing BUY-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :param expected_buy_abs_pos: The expected_buy_abs_pos of this OrderEntry.  # noqa: E501
        :type expected_buy_abs_pos: float
        """

        self._expected_buy_abs_pos = expected_buy_abs_pos

    @property
    def location(self):
        """Gets the location of this OrderEntry.  # noqa: E501

        Location within the delivery area. Should be only set for products with locations enabled.  # noqa: E501

        :return: The location of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this OrderEntry.

        Location within the delivery area. Should be only set for products with locations enabled.  # noqa: E501

        :param location: The location of this OrderEntry.  # noqa: E501
        :type location: str
        """

        self._location = location

    @property
    def account_id(self):
        """Gets the account_id of this OrderEntry.  # noqa: E501

        Allows to set the exchange account for this order. The default account will be used if this field is unset. See available_account_ids from `GET /market` for possible values.  # noqa: E501

        :return: The account_id of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this OrderEntry.

        Allows to set the exchange account for this order. The default account will be used if this field is unset. See available_account_ids from `GET /market` for possible values.  # noqa: E501

        :param account_id: The account_id of this OrderEntry.  # noqa: E501
        :type account_id: str
        """

        self._account_id = account_id

    @property
    def strategy_id(self):
        """Gets the strategy_id of this OrderEntry.  # noqa: E501

        Allows you to correlate this order with a trading strategy  # noqa: E501

        :return: The strategy_id of this OrderEntry.  # noqa: E501
        :rtype: str
        """
        return self._strategy_id

    @strategy_id.setter
    def strategy_id(self, strategy_id):
        """Sets the strategy_id of this OrderEntry.

        Allows you to correlate this order with a trading strategy  # noqa: E501

        :param strategy_id: The strategy_id of this OrderEntry.  # noqa: E501
        :type strategy_id: str
        """

        self._strategy_id = strategy_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderEntry):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrderEntry):
            return True

        return self.to_dict() != other.to_dict()
