# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_asyncio_client.configuration import Configuration


class OwnOrderTradingStatistics(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'time_series_from': 'datetime',
        'time_series_to': 'datetime',
        'time_series_bucket_size_seconds': 'int',
        'order_revision_series': 'list[int]',
        'trade_volume_series': 'list[float]',
        'order_revisions_total': 'int',
        'trade_volume_total': 'float'
    }

    attribute_map = {
        'time_series_from': 'time_series_from',
        'time_series_to': 'time_series_to',
        'time_series_bucket_size_seconds': 'time_series_bucket_size_seconds',
        'order_revision_series': 'order_revision_series',
        'trade_volume_series': 'trade_volume_series',
        'order_revisions_total': 'order_revisions_total',
        'trade_volume_total': 'trade_volume_total'
    }

    def __init__(self, time_series_from=None, time_series_to=None, time_series_bucket_size_seconds=None, order_revision_series=None, trade_volume_series=None, order_revisions_total=None, trade_volume_total=None, local_vars_configuration=None):  # noqa: E501
        """OwnOrderTradingStatistics - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._time_series_from = None
        self._time_series_to = None
        self._time_series_bucket_size_seconds = None
        self._order_revision_series = None
        self._trade_volume_series = None
        self._order_revisions_total = None
        self._trade_volume_total = None
        self.discriminator = None

        self.time_series_from = time_series_from
        self.time_series_to = time_series_to
        self.time_series_bucket_size_seconds = time_series_bucket_size_seconds
        self.order_revision_series = order_revision_series
        self.trade_volume_series = trade_volume_series
        self.order_revisions_total = order_revisions_total
        self.trade_volume_total = trade_volume_total

    @property
    def time_series_from(self):
        """Gets the time_series_from of this OwnOrderTradingStatistics.  # noqa: E501

        Start of the time period  # noqa: E501

        :return: The time_series_from of this OwnOrderTradingStatistics.  # noqa: E501
        :rtype: datetime
        """
        return self._time_series_from

    @time_series_from.setter
    def time_series_from(self, time_series_from):
        """Sets the time_series_from of this OwnOrderTradingStatistics.

        Start of the time period  # noqa: E501

        :param time_series_from: The time_series_from of this OwnOrderTradingStatistics.  # noqa: E501
        :type time_series_from: datetime
        """
        if self.local_vars_configuration.client_side_validation and time_series_from is None:  # noqa: E501
            raise ValueError("Invalid value for `time_series_from`, must not be `None`")  # noqa: E501

        self._time_series_from = time_series_from

    @property
    def time_series_to(self):
        """Gets the time_series_to of this OwnOrderTradingStatistics.  # noqa: E501

        End of the time period, if bucket size does not divide end of last full bucket  # noqa: E501

        :return: The time_series_to of this OwnOrderTradingStatistics.  # noqa: E501
        :rtype: datetime
        """
        return self._time_series_to

    @time_series_to.setter
    def time_series_to(self, time_series_to):
        """Sets the time_series_to of this OwnOrderTradingStatistics.

        End of the time period, if bucket size does not divide end of last full bucket  # noqa: E501

        :param time_series_to: The time_series_to of this OwnOrderTradingStatistics.  # noqa: E501
        :type time_series_to: datetime
        """
        if self.local_vars_configuration.client_side_validation and time_series_to is None:  # noqa: E501
            raise ValueError("Invalid value for `time_series_to`, must not be `None`")  # noqa: E501

        self._time_series_to = time_series_to

    @property
    def time_series_bucket_size_seconds(self):
        """Gets the time_series_bucket_size_seconds of this OwnOrderTradingStatistics.  # noqa: E501

        Length of the time bucket in seconds  # noqa: E501

        :return: The time_series_bucket_size_seconds of this OwnOrderTradingStatistics.  # noqa: E501
        :rtype: int
        """
        return self._time_series_bucket_size_seconds

    @time_series_bucket_size_seconds.setter
    def time_series_bucket_size_seconds(self, time_series_bucket_size_seconds):
        """Sets the time_series_bucket_size_seconds of this OwnOrderTradingStatistics.

        Length of the time bucket in seconds  # noqa: E501

        :param time_series_bucket_size_seconds: The time_series_bucket_size_seconds of this OwnOrderTradingStatistics.  # noqa: E501
        :type time_series_bucket_size_seconds: int
        """
        if self.local_vars_configuration.client_side_validation and time_series_bucket_size_seconds is None:  # noqa: E501
            raise ValueError("Invalid value for `time_series_bucket_size_seconds`, must not be `None`")  # noqa: E501

        self._time_series_bucket_size_seconds = time_series_bucket_size_seconds

    @property
    def order_revision_series(self):
        """Gets the order_revision_series of this OwnOrderTradingStatistics.  # noqa: E501

        Order revision count per bucket  # noqa: E501

        :return: The order_revision_series of this OwnOrderTradingStatistics.  # noqa: E501
        :rtype: list[int]
        """
        return self._order_revision_series

    @order_revision_series.setter
    def order_revision_series(self, order_revision_series):
        """Sets the order_revision_series of this OwnOrderTradingStatistics.

        Order revision count per bucket  # noqa: E501

        :param order_revision_series: The order_revision_series of this OwnOrderTradingStatistics.  # noqa: E501
        :type order_revision_series: list[int]
        """
        if self.local_vars_configuration.client_side_validation and order_revision_series is None:  # noqa: E501
            raise ValueError("Invalid value for `order_revision_series`, must not be `None`")  # noqa: E501

        self._order_revision_series = order_revision_series

    @property
    def trade_volume_series(self):
        """Gets the trade_volume_series of this OwnOrderTradingStatistics.  # noqa: E501

        Trade volume sum per bucket  # noqa: E501

        :return: The trade_volume_series of this OwnOrderTradingStatistics.  # noqa: E501
        :rtype: list[float]
        """
        return self._trade_volume_series

    @trade_volume_series.setter
    def trade_volume_series(self, trade_volume_series):
        """Sets the trade_volume_series of this OwnOrderTradingStatistics.

        Trade volume sum per bucket  # noqa: E501

        :param trade_volume_series: The trade_volume_series of this OwnOrderTradingStatistics.  # noqa: E501
        :type trade_volume_series: list[float]
        """
        if self.local_vars_configuration.client_side_validation and trade_volume_series is None:  # noqa: E501
            raise ValueError("Invalid value for `trade_volume_series`, must not be `None`")  # noqa: E501

        self._trade_volume_series = trade_volume_series

    @property
    def order_revisions_total(self):
        """Gets the order_revisions_total of this OwnOrderTradingStatistics.  # noqa: E501

        Total revision count over whole range  # noqa: E501

        :return: The order_revisions_total of this OwnOrderTradingStatistics.  # noqa: E501
        :rtype: int
        """
        return self._order_revisions_total

    @order_revisions_total.setter
    def order_revisions_total(self, order_revisions_total):
        """Sets the order_revisions_total of this OwnOrderTradingStatistics.

        Total revision count over whole range  # noqa: E501

        :param order_revisions_total: The order_revisions_total of this OwnOrderTradingStatistics.  # noqa: E501
        :type order_revisions_total: int
        """
        if self.local_vars_configuration.client_side_validation and order_revisions_total is None:  # noqa: E501
            raise ValueError("Invalid value for `order_revisions_total`, must not be `None`")  # noqa: E501

        self._order_revisions_total = order_revisions_total

    @property
    def trade_volume_total(self):
        """Gets the trade_volume_total of this OwnOrderTradingStatistics.  # noqa: E501

        Total trade volume sum over whole range  # noqa: E501

        :return: The trade_volume_total of this OwnOrderTradingStatistics.  # noqa: E501
        :rtype: float
        """
        return self._trade_volume_total

    @trade_volume_total.setter
    def trade_volume_total(self, trade_volume_total):
        """Sets the trade_volume_total of this OwnOrderTradingStatistics.

        Total trade volume sum over whole range  # noqa: E501

        :param trade_volume_total: The trade_volume_total of this OwnOrderTradingStatistics.  # noqa: E501
        :type trade_volume_total: float
        """
        if self.local_vars_configuration.client_side_validation and trade_volume_total is None:  # noqa: E501
            raise ValueError("Invalid value for `trade_volume_total`, must not be `None`")  # noqa: E501

        self._trade_volume_total = trade_volume_total

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OwnOrderTradingStatistics):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OwnOrderTradingStatistics):
            return True

        return self.to_dict() != other.to_dict()
