# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_asyncio_client.configuration import Configuration


class RelatedContract(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'contract_id': 'str',
        'product': 'str',
        'delivery_area': 'str',
        'active_since': 'datetime',
        'revision': 'int',
        'sequence_number': 'int',
        'delivery_start': 'datetime',
        'delivery_end': 'datetime',
        'best_own_bid_price': 'float',
        'best_own_bid_quantity': 'float',
        'best_own_ask_price': 'float',
        'best_own_ask_quantity': 'float',
        'best_third_party_bid_price': 'float',
        'best_third_party_bid_quantity': 'float',
        'best_third_party_ask_price': 'float',
        'best_third_party_ask_quantity': 'float',
        'last_price': 'float',
        'last_quantity': 'float'
    }

    attribute_map = {
        'contract_id': 'contract_id',
        'product': 'product',
        'delivery_area': 'delivery_area',
        'active_since': 'active_since',
        'revision': 'revision',
        'sequence_number': 'sequence_number',
        'delivery_start': 'delivery_start',
        'delivery_end': 'delivery_end',
        'best_own_bid_price': 'best_own_bid_price',
        'best_own_bid_quantity': 'best_own_bid_quantity',
        'best_own_ask_price': 'best_own_ask_price',
        'best_own_ask_quantity': 'best_own_ask_quantity',
        'best_third_party_bid_price': 'best_third_party_bid_price',
        'best_third_party_bid_quantity': 'best_third_party_bid_quantity',
        'best_third_party_ask_price': 'best_third_party_ask_price',
        'best_third_party_ask_quantity': 'best_third_party_ask_quantity',
        'last_price': 'last_price',
        'last_quantity': 'last_quantity'
    }

    def __init__(self, contract_id=None, product=None, delivery_area=None, active_since=None, revision=None, sequence_number=None, delivery_start=None, delivery_end=None, best_own_bid_price=None, best_own_bid_quantity=None, best_own_ask_price=None, best_own_ask_quantity=None, best_third_party_bid_price=None, best_third_party_bid_quantity=None, best_third_party_ask_price=None, best_third_party_ask_quantity=None, last_price=None, last_quantity=None, local_vars_configuration=None):  # noqa: E501
        """RelatedContract - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._contract_id = None
        self._product = None
        self._delivery_area = None
        self._active_since = None
        self._revision = None
        self._sequence_number = None
        self._delivery_start = None
        self._delivery_end = None
        self._best_own_bid_price = None
        self._best_own_bid_quantity = None
        self._best_own_ask_price = None
        self._best_own_ask_quantity = None
        self._best_third_party_bid_price = None
        self._best_third_party_bid_quantity = None
        self._best_third_party_ask_price = None
        self._best_third_party_ask_quantity = None
        self._last_price = None
        self._last_quantity = None
        self.discriminator = None

        if contract_id is not None:
            self.contract_id = contract_id
        if product is not None:
            self.product = product
        if delivery_area is not None:
            self.delivery_area = delivery_area
        if active_since is not None:
            self.active_since = active_since
        if revision is not None:
            self.revision = revision
        if sequence_number is not None:
            self.sequence_number = sequence_number
        if delivery_start is not None:
            self.delivery_start = delivery_start
        if delivery_end is not None:
            self.delivery_end = delivery_end
        if best_own_bid_price is not None:
            self.best_own_bid_price = best_own_bid_price
        if best_own_bid_quantity is not None:
            self.best_own_bid_quantity = best_own_bid_quantity
        if best_own_ask_price is not None:
            self.best_own_ask_price = best_own_ask_price
        if best_own_ask_quantity is not None:
            self.best_own_ask_quantity = best_own_ask_quantity
        if best_third_party_bid_price is not None:
            self.best_third_party_bid_price = best_third_party_bid_price
        if best_third_party_bid_quantity is not None:
            self.best_third_party_bid_quantity = best_third_party_bid_quantity
        if best_third_party_ask_price is not None:
            self.best_third_party_ask_price = best_third_party_ask_price
        if best_third_party_ask_quantity is not None:
            self.best_third_party_ask_quantity = best_third_party_ask_quantity
        if last_price is not None:
            self.last_price = last_price
        if last_quantity is not None:
            self.last_quantity = last_quantity

    @property
    def contract_id(self):
        """Gets the contract_id of this RelatedContract.  # noqa: E501


        :return: The contract_id of this RelatedContract.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this RelatedContract.


        :param contract_id: The contract_id of this RelatedContract.  # noqa: E501
        :type contract_id: str
        """

        self._contract_id = contract_id

    @property
    def product(self):
        """Gets the product of this RelatedContract.  # noqa: E501

        The contract's product.  # noqa: E501

        :return: The product of this RelatedContract.  # noqa: E501
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this RelatedContract.

        The contract's product.  # noqa: E501

        :param product: The product of this RelatedContract.  # noqa: E501
        :type product: str
        """

        self._product = product

    @property
    def delivery_area(self):
        """Gets the delivery_area of this RelatedContract.  # noqa: E501

        The EIC of the delivery area of the order book's product.  # noqa: E501

        :return: The delivery_area of this RelatedContract.  # noqa: E501
        :rtype: str
        """
        return self._delivery_area

    @delivery_area.setter
    def delivery_area(self, delivery_area):
        """Sets the delivery_area of this RelatedContract.

        The EIC of the delivery area of the order book's product.  # noqa: E501

        :param delivery_area: The delivery_area of this RelatedContract.  # noqa: E501
        :type delivery_area: str
        """

        self._delivery_area = delivery_area

    @property
    def active_since(self):
        """Gets the active_since of this RelatedContract.  # noqa: E501

        The timestamp (UTC) since when the contract has been observed as active for trading in the corresponding delivery area. Is reset to current time after a system or market outage or after the market was hibernated. Can be used to determine potential low liquidity situations after activation of new contracts or market outages.  # noqa: E501

        :return: The active_since of this RelatedContract.  # noqa: E501
        :rtype: datetime
        """
        return self._active_since

    @active_since.setter
    def active_since(self, active_since):
        """Sets the active_since of this RelatedContract.

        The timestamp (UTC) since when the contract has been observed as active for trading in the corresponding delivery area. Is reset to current time after a system or market outage or after the market was hibernated. Can be used to determine potential low liquidity situations after activation of new contracts or market outages.  # noqa: E501

        :param active_since: The active_since of this RelatedContract.  # noqa: E501
        :type active_since: datetime
        """

        self._active_since = active_since

    @property
    def revision(self):
        """Gets the revision of this RelatedContract.  # noqa: E501

        Revision number of the order book.  # noqa: E501

        :return: The revision of this RelatedContract.  # noqa: E501
        :rtype: int
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this RelatedContract.

        Revision number of the order book.  # noqa: E501

        :param revision: The revision of this RelatedContract.  # noqa: E501
        :type revision: int
        """

        self._revision = revision

    @property
    def sequence_number(self):
        """Gets the sequence_number of this RelatedContract.  # noqa: E501

        DEPRECATED: use revision instead  # noqa: E501

        :return: The sequence_number of this RelatedContract.  # noqa: E501
        :rtype: int
        """
        return self._sequence_number

    @sequence_number.setter
    def sequence_number(self, sequence_number):
        """Sets the sequence_number of this RelatedContract.

        DEPRECATED: use revision instead  # noqa: E501

        :param sequence_number: The sequence_number of this RelatedContract.  # noqa: E501
        :type sequence_number: int
        """

        self._sequence_number = sequence_number

    @property
    def delivery_start(self):
        """Gets the delivery_start of this RelatedContract.  # noqa: E501

        Delivery start of the contract.  # noqa: E501

        :return: The delivery_start of this RelatedContract.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_start

    @delivery_start.setter
    def delivery_start(self, delivery_start):
        """Sets the delivery_start of this RelatedContract.

        Delivery start of the contract.  # noqa: E501

        :param delivery_start: The delivery_start of this RelatedContract.  # noqa: E501
        :type delivery_start: datetime
        """

        self._delivery_start = delivery_start

    @property
    def delivery_end(self):
        """Gets the delivery_end of this RelatedContract.  # noqa: E501

        Delivery end of the contract.  # noqa: E501

        :return: The delivery_end of this RelatedContract.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_end

    @delivery_end.setter
    def delivery_end(self, delivery_end):
        """Sets the delivery_end of this RelatedContract.

        Delivery end of the contract.  # noqa: E501

        :param delivery_end: The delivery_end of this RelatedContract.  # noqa: E501
        :type delivery_end: datetime
        """

        self._delivery_end = delivery_end

    @property
    def best_own_bid_price(self):
        """Gets the best_own_bid_price of this RelatedContract.  # noqa: E501

        Best bid price placed by your exchange member.  # noqa: E501

        :return: The best_own_bid_price of this RelatedContract.  # noqa: E501
        :rtype: float
        """
        return self._best_own_bid_price

    @best_own_bid_price.setter
    def best_own_bid_price(self, best_own_bid_price):
        """Sets the best_own_bid_price of this RelatedContract.

        Best bid price placed by your exchange member.  # noqa: E501

        :param best_own_bid_price: The best_own_bid_price of this RelatedContract.  # noqa: E501
        :type best_own_bid_price: float
        """

        self._best_own_bid_price = best_own_bid_price

    @property
    def best_own_bid_quantity(self):
        """Gets the best_own_bid_quantity of this RelatedContract.  # noqa: E501

        Quantity of the best bid placed by your exchange member.  # noqa: E501

        :return: The best_own_bid_quantity of this RelatedContract.  # noqa: E501
        :rtype: float
        """
        return self._best_own_bid_quantity

    @best_own_bid_quantity.setter
    def best_own_bid_quantity(self, best_own_bid_quantity):
        """Sets the best_own_bid_quantity of this RelatedContract.

        Quantity of the best bid placed by your exchange member.  # noqa: E501

        :param best_own_bid_quantity: The best_own_bid_quantity of this RelatedContract.  # noqa: E501
        :type best_own_bid_quantity: float
        """

        self._best_own_bid_quantity = best_own_bid_quantity

    @property
    def best_own_ask_price(self):
        """Gets the best_own_ask_price of this RelatedContract.  # noqa: E501

        Best ask price placed by your exchange member.  # noqa: E501

        :return: The best_own_ask_price of this RelatedContract.  # noqa: E501
        :rtype: float
        """
        return self._best_own_ask_price

    @best_own_ask_price.setter
    def best_own_ask_price(self, best_own_ask_price):
        """Sets the best_own_ask_price of this RelatedContract.

        Best ask price placed by your exchange member.  # noqa: E501

        :param best_own_ask_price: The best_own_ask_price of this RelatedContract.  # noqa: E501
        :type best_own_ask_price: float
        """

        self._best_own_ask_price = best_own_ask_price

    @property
    def best_own_ask_quantity(self):
        """Gets the best_own_ask_quantity of this RelatedContract.  # noqa: E501

        Quantity of the best ask placed your exchange member.  # noqa: E501

        :return: The best_own_ask_quantity of this RelatedContract.  # noqa: E501
        :rtype: float
        """
        return self._best_own_ask_quantity

    @best_own_ask_quantity.setter
    def best_own_ask_quantity(self, best_own_ask_quantity):
        """Sets the best_own_ask_quantity of this RelatedContract.

        Quantity of the best ask placed your exchange member.  # noqa: E501

        :param best_own_ask_quantity: The best_own_ask_quantity of this RelatedContract.  # noqa: E501
        :type best_own_ask_quantity: float
        """

        self._best_own_ask_quantity = best_own_ask_quantity

    @property
    def best_third_party_bid_price(self):
        """Gets the best_third_party_bid_price of this RelatedContract.  # noqa: E501

        Best bid price placed by an exchange member other than yours.  # noqa: E501

        :return: The best_third_party_bid_price of this RelatedContract.  # noqa: E501
        :rtype: float
        """
        return self._best_third_party_bid_price

    @best_third_party_bid_price.setter
    def best_third_party_bid_price(self, best_third_party_bid_price):
        """Sets the best_third_party_bid_price of this RelatedContract.

        Best bid price placed by an exchange member other than yours.  # noqa: E501

        :param best_third_party_bid_price: The best_third_party_bid_price of this RelatedContract.  # noqa: E501
        :type best_third_party_bid_price: float
        """

        self._best_third_party_bid_price = best_third_party_bid_price

    @property
    def best_third_party_bid_quantity(self):
        """Gets the best_third_party_bid_quantity of this RelatedContract.  # noqa: E501

        Quantity of the best bid placed by an exchange member other than yours.  # noqa: E501

        :return: The best_third_party_bid_quantity of this RelatedContract.  # noqa: E501
        :rtype: float
        """
        return self._best_third_party_bid_quantity

    @best_third_party_bid_quantity.setter
    def best_third_party_bid_quantity(self, best_third_party_bid_quantity):
        """Sets the best_third_party_bid_quantity of this RelatedContract.

        Quantity of the best bid placed by an exchange member other than yours.  # noqa: E501

        :param best_third_party_bid_quantity: The best_third_party_bid_quantity of this RelatedContract.  # noqa: E501
        :type best_third_party_bid_quantity: float
        """

        self._best_third_party_bid_quantity = best_third_party_bid_quantity

    @property
    def best_third_party_ask_price(self):
        """Gets the best_third_party_ask_price of this RelatedContract.  # noqa: E501

        Best ask price placed by an exchange member other than yours.  # noqa: E501

        :return: The best_third_party_ask_price of this RelatedContract.  # noqa: E501
        :rtype: float
        """
        return self._best_third_party_ask_price

    @best_third_party_ask_price.setter
    def best_third_party_ask_price(self, best_third_party_ask_price):
        """Sets the best_third_party_ask_price of this RelatedContract.

        Best ask price placed by an exchange member other than yours.  # noqa: E501

        :param best_third_party_ask_price: The best_third_party_ask_price of this RelatedContract.  # noqa: E501
        :type best_third_party_ask_price: float
        """

        self._best_third_party_ask_price = best_third_party_ask_price

    @property
    def best_third_party_ask_quantity(self):
        """Gets the best_third_party_ask_quantity of this RelatedContract.  # noqa: E501

        Quantity of the best ask placed by an exchange member other than yours.  # noqa: E501

        :return: The best_third_party_ask_quantity of this RelatedContract.  # noqa: E501
        :rtype: float
        """
        return self._best_third_party_ask_quantity

    @best_third_party_ask_quantity.setter
    def best_third_party_ask_quantity(self, best_third_party_ask_quantity):
        """Sets the best_third_party_ask_quantity of this RelatedContract.

        Quantity of the best ask placed by an exchange member other than yours.  # noqa: E501

        :param best_third_party_ask_quantity: The best_third_party_ask_quantity of this RelatedContract.  # noqa: E501
        :type best_third_party_ask_quantity: float
        """

        self._best_third_party_ask_quantity = best_third_party_ask_quantity

    @property
    def last_price(self):
        """Gets the last_price of this RelatedContract.  # noqa: E501

        The price of the last trade  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :return: The last_price of this RelatedContract.  # noqa: E501
        :rtype: float
        """
        return self._last_price

    @last_price.setter
    def last_price(self, last_price):
        """Sets the last_price of this RelatedContract.

        The price of the last trade  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :param last_price: The last_price of this RelatedContract.  # noqa: E501
        :type last_price: float
        """

        self._last_price = last_price

    @property
    def last_quantity(self):
        """Gets the last_quantity of this RelatedContract.  # noqa: E501

        The quantity of the last trade  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :return: The last_quantity of this RelatedContract.  # noqa: E501
        :rtype: float
        """
        return self._last_quantity

    @last_quantity.setter
    def last_quantity(self, last_quantity):
        """Sets the last_quantity of this RelatedContract.

        The quantity of the last trade  All trades in the market area of the contract's delivery area are included. Trades for the XBID contract of the same delivery period as a local contract and vice versa will also be included. Self trades registered at the exchange and internal trades registered by PowerBot are excluded.  # noqa: E501

        :param last_quantity: The last_quantity of this RelatedContract.  # noqa: E501
        :type last_quantity: float
        """

        self._last_quantity = last_quantity

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RelatedContract):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RelatedContract):
            return True

        return self.to_dict() != other.to_dict()
