# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_asyncio_client.configuration import Configuration


class Signal(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'source': 'str',
        'received_at': 'datetime',
        'updated_at': 'datetime',
        'minutes_to_delivery': 'int',
        'revision': 'int',
        'delivery_start': 'datetime',
        'delivery_end': 'datetime',
        'delivery_areas': 'list[str]',
        'portfolio_ids': 'list[str]',
        'delivery_area': 'str',
        'portfolio_id': 'str',
        'tenant_id': 'str',
        'deleted': 'bool',
        'active': 'bool',
        'position_short': 'float',
        'position_long': 'float',
        'locked': 'bool',
        'value': 'object'
    }

    attribute_map = {
        'id': 'id',
        'source': 'source',
        'received_at': 'received_at',
        'updated_at': 'updated_at',
        'minutes_to_delivery': 'minutes_to_delivery',
        'revision': 'revision',
        'delivery_start': 'delivery_start',
        'delivery_end': 'delivery_end',
        'delivery_areas': 'delivery_areas',
        'portfolio_ids': 'portfolio_ids',
        'delivery_area': 'delivery_area',
        'portfolio_id': 'portfolio_id',
        'tenant_id': 'tenant_id',
        'deleted': 'deleted',
        'active': 'active',
        'position_short': 'position_short',
        'position_long': 'position_long',
        'locked': 'locked',
        'value': 'value'
    }

    def __init__(self, id=None, source=None, received_at=None, updated_at=None, minutes_to_delivery=None, revision=None, delivery_start=None, delivery_end=None, delivery_areas=None, portfolio_ids=None, delivery_area=None, portfolio_id=None, tenant_id=None, deleted=None, active=None, position_short=None, position_long=None, locked=None, value=None, local_vars_configuration=None):  # noqa: E501
        """Signal - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._source = None
        self._received_at = None
        self._updated_at = None
        self._minutes_to_delivery = None
        self._revision = None
        self._delivery_start = None
        self._delivery_end = None
        self._delivery_areas = None
        self._portfolio_ids = None
        self._delivery_area = None
        self._portfolio_id = None
        self._tenant_id = None
        self._deleted = None
        self._active = None
        self._position_short = None
        self._position_long = None
        self._locked = None
        self._value = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if source is not None:
            self.source = source
        if received_at is not None:
            self.received_at = received_at
        if updated_at is not None:
            self.updated_at = updated_at
        if minutes_to_delivery is not None:
            self.minutes_to_delivery = minutes_to_delivery
        if revision is not None:
            self.revision = revision
        if delivery_start is not None:
            self.delivery_start = delivery_start
        if delivery_end is not None:
            self.delivery_end = delivery_end
        if delivery_areas is not None:
            self.delivery_areas = delivery_areas
        if portfolio_ids is not None:
            self.portfolio_ids = portfolio_ids
        if delivery_area is not None:
            self.delivery_area = delivery_area
        if portfolio_id is not None:
            self.portfolio_id = portfolio_id
        if tenant_id is not None:
            self.tenant_id = tenant_id
        if deleted is not None:
            self.deleted = deleted
        if active is not None:
            self.active = active
        if position_short is not None:
            self.position_short = position_short
        if position_long is not None:
            self.position_long = position_long
        if locked is not None:
            self.locked = locked
        if value is not None:
            self.value = value

    @property
    def id(self):
        """Gets the id of this Signal.  # noqa: E501

        The unique id of the signal (within the namespace of the emitting source)  # noqa: E501

        :return: The id of this Signal.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Signal.

        The unique id of the signal (within the namespace of the emitting source)  # noqa: E501

        :param id: The id of this Signal.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def source(self):
        """Gets the source of this Signal.  # noqa: E501

        The identifier of the system which emitted the signal  # noqa: E501

        :return: The source of this Signal.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this Signal.

        The identifier of the system which emitted the signal  # noqa: E501

        :param source: The source of this Signal.  # noqa: E501
        :type source: str
        """

        self._source = source

    @property
    def received_at(self):
        """Gets the received_at of this Signal.  # noqa: E501

        The timestamp when the signal was received  # noqa: E501

        :return: The received_at of this Signal.  # noqa: E501
        :rtype: datetime
        """
        return self._received_at

    @received_at.setter
    def received_at(self, received_at):
        """Sets the received_at of this Signal.

        The timestamp when the signal was received  # noqa: E501

        :param received_at: The received_at of this Signal.  # noqa: E501
        :type received_at: datetime
        """

        self._received_at = received_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Signal.  # noqa: E501

        The timestamp when the signal was last updated  # noqa: E501

        :return: The updated_at of this Signal.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Signal.

        The timestamp when the signal was last updated  # noqa: E501

        :param updated_at: The updated_at of this Signal.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    @property
    def minutes_to_delivery(self):
        """Gets the minutes_to_delivery of this Signal.  # noqa: E501

        The offset in minutes until delivery start, after which the signal becomes valid  # noqa: E501

        :return: The minutes_to_delivery of this Signal.  # noqa: E501
        :rtype: int
        """
        return self._minutes_to_delivery

    @minutes_to_delivery.setter
    def minutes_to_delivery(self, minutes_to_delivery):
        """Sets the minutes_to_delivery of this Signal.

        The offset in minutes until delivery start, after which the signal becomes valid  # noqa: E501

        :param minutes_to_delivery: The minutes_to_delivery of this Signal.  # noqa: E501
        :type minutes_to_delivery: int
        """

        self._minutes_to_delivery = minutes_to_delivery

    @property
    def revision(self):
        """Gets the revision of this Signal.  # noqa: E501

        The number of times the signal has been updated. If the signal has never received any updates, then revision is 0  # noqa: E501

        :return: The revision of this Signal.  # noqa: E501
        :rtype: int
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this Signal.

        The number of times the signal has been updated. If the signal has never received any updates, then revision is 0  # noqa: E501

        :param revision: The revision of this Signal.  # noqa: E501
        :type revision: int
        """

        self._revision = revision

    @property
    def delivery_start(self):
        """Gets the delivery_start of this Signal.  # noqa: E501

        Together with delivery_start and delivery_end specify the delivery period in which the signal is valid  # noqa: E501

        :return: The delivery_start of this Signal.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_start

    @delivery_start.setter
    def delivery_start(self, delivery_start):
        """Sets the delivery_start of this Signal.

        Together with delivery_start and delivery_end specify the delivery period in which the signal is valid  # noqa: E501

        :param delivery_start: The delivery_start of this Signal.  # noqa: E501
        :type delivery_start: datetime
        """

        self._delivery_start = delivery_start

    @property
    def delivery_end(self):
        """Gets the delivery_end of this Signal.  # noqa: E501

        Together with delivery_start and delivery_end specify the delivery period in which the signal is valid  # noqa: E501

        :return: The delivery_end of this Signal.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_end

    @delivery_end.setter
    def delivery_end(self, delivery_end):
        """Sets the delivery_end of this Signal.

        Together with delivery_start and delivery_end specify the delivery period in which the signal is valid  # noqa: E501

        :param delivery_end: The delivery_end of this Signal.  # noqa: E501
        :type delivery_end: datetime
        """

        self._delivery_end = delivery_end

    @property
    def delivery_areas(self):
        """Gets the delivery_areas of this Signal.  # noqa: E501

        DEPRECATED, use 'delivery_area' instead. The EIC of the delivery areas for which the signal is applicable  # noqa: E501

        :return: The delivery_areas of this Signal.  # noqa: E501
        :rtype: list[str]
        """
        return self._delivery_areas

    @delivery_areas.setter
    def delivery_areas(self, delivery_areas):
        """Sets the delivery_areas of this Signal.

        DEPRECATED, use 'delivery_area' instead. The EIC of the delivery areas for which the signal is applicable  # noqa: E501

        :param delivery_areas: The delivery_areas of this Signal.  # noqa: E501
        :type delivery_areas: list[str]
        """

        self._delivery_areas = delivery_areas

    @property
    def portfolio_ids(self):
        """Gets the portfolio_ids of this Signal.  # noqa: E501

        DEPRECATED, use 'portfolio_id' instead. The portfolios for which the signal is applicable  # noqa: E501

        :return: The portfolio_ids of this Signal.  # noqa: E501
        :rtype: list[str]
        """
        return self._portfolio_ids

    @portfolio_ids.setter
    def portfolio_ids(self, portfolio_ids):
        """Sets the portfolio_ids of this Signal.

        DEPRECATED, use 'portfolio_id' instead. The portfolios for which the signal is applicable  # noqa: E501

        :param portfolio_ids: The portfolio_ids of this Signal.  # noqa: E501
        :type portfolio_ids: list[str]
        """

        self._portfolio_ids = portfolio_ids

    @property
    def delivery_area(self):
        """Gets the delivery_area of this Signal.  # noqa: E501

        The EIC of the delivery area for which the signal is applicable  # noqa: E501

        :return: The delivery_area of this Signal.  # noqa: E501
        :rtype: str
        """
        return self._delivery_area

    @delivery_area.setter
    def delivery_area(self, delivery_area):
        """Sets the delivery_area of this Signal.

        The EIC of the delivery area for which the signal is applicable  # noqa: E501

        :param delivery_area: The delivery_area of this Signal.  # noqa: E501
        :type delivery_area: str
        """

        self._delivery_area = delivery_area

    @property
    def portfolio_id(self):
        """Gets the portfolio_id of this Signal.  # noqa: E501

        The portfolio for which the signal is applicable  # noqa: E501

        :return: The portfolio_id of this Signal.  # noqa: E501
        :rtype: str
        """
        return self._portfolio_id

    @portfolio_id.setter
    def portfolio_id(self, portfolio_id):
        """Sets the portfolio_id of this Signal.

        The portfolio for which the signal is applicable  # noqa: E501

        :param portfolio_id: The portfolio_id of this Signal.  # noqa: E501
        :type portfolio_id: str
        """

        self._portfolio_id = portfolio_id

    @property
    def tenant_id(self):
        """Gets the tenant_id of this Signal.  # noqa: E501


        :return: The tenant_id of this Signal.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this Signal.


        :param tenant_id: The tenant_id of this Signal.  # noqa: E501
        :type tenant_id: str
        """

        self._tenant_id = tenant_id

    @property
    def deleted(self):
        """Gets the deleted of this Signal.  # noqa: E501

        Indicates that the time slice was deleted.  # noqa: E501

        :return: The deleted of this Signal.  # noqa: E501
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """Sets the deleted of this Signal.

        Indicates that the time slice was deleted.  # noqa: E501

        :param deleted: The deleted of this Signal.  # noqa: E501
        :type deleted: bool
        """

        self._deleted = deleted

    @property
    def active(self):
        """Gets the active of this Signal.  # noqa: E501

        Indicates that the time slice is active.  # noqa: E501

        :return: The active of this Signal.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this Signal.

        Indicates that the time slice is active.  # noqa: E501

        :param active: The active of this Signal.  # noqa: E501
        :type active: bool
        """

        self._active = active

    @property
    def position_short(self):
        """Gets the position_short of this Signal.  # noqa: E501

        Indicates the deficiency in MW that should or can be bought at the market (equal or greater than zero)  # noqa: E501

        :return: The position_short of this Signal.  # noqa: E501
        :rtype: float
        """
        return self._position_short

    @position_short.setter
    def position_short(self, position_short):
        """Sets the position_short of this Signal.

        Indicates the deficiency in MW that should or can be bought at the market (equal or greater than zero)  # noqa: E501

        :param position_short: The position_short of this Signal.  # noqa: E501
        :type position_short: float
        """

        self._position_short = position_short

    @property
    def position_long(self):
        """Gets the position_long of this Signal.  # noqa: E501

        Indicates the surplus in MW that should or can be sold at the market (equal or greater than zero)  # noqa: E501

        :return: The position_long of this Signal.  # noqa: E501
        :rtype: float
        """
        return self._position_long

    @position_long.setter
    def position_long(self, position_long):
        """Sets the position_long of this Signal.

        Indicates the surplus in MW that should or can be sold at the market (equal or greater than zero)  # noqa: E501

        :param position_long: The position_long of this Signal.  # noqa: E501
        :type position_long: float
        """

        self._position_long = position_long

    @property
    def locked(self):
        """Gets the locked of this Signal.  # noqa: E501

        Locked signals can not be modified, unless the `ignore_lock` parameter is set to `true`  # noqa: E501

        :return: The locked of this Signal.  # noqa: E501
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """Sets the locked of this Signal.

        Locked signals can not be modified, unless the `ignore_lock` parameter is set to `true`  # noqa: E501

        :param locked: The locked of this Signal.  # noqa: E501
        :type locked: bool
        """

        self._locked = locked

    @property
    def value(self):
        """Gets the value of this Signal.  # noqa: E501

        The custom content of the signal, posted as key/value pairs  # noqa: E501

        :return: The value of this Signal.  # noqa: E501
        :rtype: object
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this Signal.

        The custom content of the signal, posted as key/value pairs  # noqa: E501

        :param value: The value of this Signal.  # noqa: E501
        :type value: object
        """

        self._value = value

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Signal):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Signal):
            return True

        return self.to_dict() != other.to_dict()
