# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_asyncio_client.api_client import ApiClient
from powerbot_asyncio_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AuctionConfigurationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_auction_config(self, exchange_id, **kwargs):  # noqa: E501
        """Get Exchange Configuration  # noqa: E501

        Return information regarding the configuration of the auction module and the logged in exchange user. This includes the exchange portfolios with their corresponding PowerBot portfolio mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_config(exchange_id, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AuctionConfig
        """
        kwargs['_return_http_data_only'] = True
        return self.get_auction_config_with_http_info(exchange_id, **kwargs)  # noqa: E501

    def get_auction_config_with_http_info(self, exchange_id, **kwargs):  # noqa: E501
        """Get Exchange Configuration  # noqa: E501

        Return information regarding the configuration of the auction module and the logged in exchange user. This includes the exchange portfolios with their corresponding PowerBot portfolio mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_config_with_http_info(exchange_id, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AuctionConfig, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auction_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_id' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_id` when calling `get_auction_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_id' in local_var_params:
            path_params['exchange_id'] = local_var_params['exchange_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "AuctionConfig",
        }

        return self.api_client.call_api(
            '/auction/{exchange_id}/config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_auction_portfolio_currency(self, exchange_id, powerbot_portfolio_id, delivery_area, **kwargs):  # noqa: E501
        """Get Portfolio Currency  # noqa: E501

        Returns the exchange portfolio name and currency associated with the provided PowerBot portfolio ID and delivery area.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_portfolio_currency(exchange_id, powerbot_portfolio_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param powerbot_portfolio_id: (required)
        :type powerbot_portfolio_id: str
        :param delivery_area: (required)
        :type delivery_area: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AuctionExchangePortfolioCurrency
        """
        kwargs['_return_http_data_only'] = True
        return self.get_auction_portfolio_currency_with_http_info(exchange_id, powerbot_portfolio_id, delivery_area, **kwargs)  # noqa: E501

    def get_auction_portfolio_currency_with_http_info(self, exchange_id, powerbot_portfolio_id, delivery_area, **kwargs):  # noqa: E501
        """Get Portfolio Currency  # noqa: E501

        Returns the exchange portfolio name and currency associated with the provided PowerBot portfolio ID and delivery area.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_portfolio_currency_with_http_info(exchange_id, powerbot_portfolio_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param powerbot_portfolio_id: (required)
        :type powerbot_portfolio_id: str
        :param delivery_area: (required)
        :type delivery_area: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AuctionExchangePortfolioCurrency, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange_id',
            'powerbot_portfolio_id',
            'delivery_area'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auction_portfolio_currency" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_id' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_id` when calling `get_auction_portfolio_currency`")  # noqa: E501
        # verify the required parameter 'powerbot_portfolio_id' is set
        if self.api_client.client_side_validation and local_var_params.get('powerbot_portfolio_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `powerbot_portfolio_id` when calling `get_auction_portfolio_currency`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_auction_portfolio_currency`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_id' in local_var_params:
            path_params['exchange_id'] = local_var_params['exchange_id']  # noqa: E501
        if 'powerbot_portfolio_id' in local_var_params:
            path_params['powerbot_portfolio_id'] = local_var_params['powerbot_portfolio_id']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "AuctionExchangePortfolioCurrency",
            404: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/auction/{exchange_id}/config/{powerbot_portfolio_id}/{delivery_area}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def set_portfolio_mapping(self, exchange_id, **kwargs):  # noqa: E501
        """Set Portfolio Mapping  # noqa: E501

        Map the exchange portfolio that should be used for the given PowerBot portfolio ID. The mapping is applied to per delivery area and exchange portfolio basis. By providing a list of delivery areas one can restrict the mapping for the given delivery area(s), otherwise all accessible areas of the exchange portfolio are mapped. Following restriction are to be considered: - One PowerBot portfolio can only be mapped to one exchange portfolio + area, e.g. mapping   an already mapped powerbot portfolio to another exchange portfolio would remove the existing   mapping and set the provided one. - This operation always overwrites the existing mappings, meaning if an additional area for   the same exchange portfolio is desired, the currently mapped areas plus the new one have to   be provided. - The exchange portfolio must have access to the delivery area(s) provided in the mapping. - If a exchange portfolio has access to the same area multiple times, for example with different   currencies, the currency mapping must also be provided for those areas. - Note that when the exchange portfolio has access to multiple areas, the restrictions of   the PowerBot portfolio regarding delivery area access are prioritized.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_portfolio_mapping(exchange_id, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param auction_exchange_portfolio_mapping: The exchange portfolio mapping to be set.
        :type auction_exchange_portfolio_mapping: AuctionExchangePortfolioMapping
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AuctionExchangePortfolio]
        """
        kwargs['_return_http_data_only'] = True
        return self.set_portfolio_mapping_with_http_info(exchange_id, **kwargs)  # noqa: E501

    def set_portfolio_mapping_with_http_info(self, exchange_id, **kwargs):  # noqa: E501
        """Set Portfolio Mapping  # noqa: E501

        Map the exchange portfolio that should be used for the given PowerBot portfolio ID. The mapping is applied to per delivery area and exchange portfolio basis. By providing a list of delivery areas one can restrict the mapping for the given delivery area(s), otherwise all accessible areas of the exchange portfolio are mapped. Following restriction are to be considered: - One PowerBot portfolio can only be mapped to one exchange portfolio + area, e.g. mapping   an already mapped powerbot portfolio to another exchange portfolio would remove the existing   mapping and set the provided one. - This operation always overwrites the existing mappings, meaning if an additional area for   the same exchange portfolio is desired, the currently mapped areas plus the new one have to   be provided. - The exchange portfolio must have access to the delivery area(s) provided in the mapping. - If a exchange portfolio has access to the same area multiple times, for example with different   currencies, the currency mapping must also be provided for those areas. - Note that when the exchange portfolio has access to multiple areas, the restrictions of   the PowerBot portfolio regarding delivery area access are prioritized.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_portfolio_mapping_with_http_info(exchange_id, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param auction_exchange_portfolio_mapping: The exchange portfolio mapping to be set.
        :type auction_exchange_portfolio_mapping: AuctionExchangePortfolioMapping
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[AuctionExchangePortfolio], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange_id',
            'auction_exchange_portfolio_mapping'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_portfolio_mapping" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_id' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_id` when calling `set_portfolio_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_id' in local_var_params:
            path_params['exchange_id'] = local_var_params['exchange_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auction_exchange_portfolio_mapping' in local_var_params:
            body_params = local_var_params['auction_exchange_portfolio_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[AuctionExchangePortfolio]",
        }

        return self.api_client.call_api(
            '/auction/{exchange_id}/config/portfolio', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
