# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_asyncio_client.api_client import ApiClient
from powerbot_asyncio_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AuctionOrderApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def confirm_order(self, exchange_id, order_id, **kwargs):  # noqa: E501
        """Confirm order  # noqa: E501

        Allows you to confirmation a staged order, after which it will be submitted to the exchange. In case that the order was rejected by the exchange, a modification by the user to the current order is required, after which it may be confirmed again to submit to the market.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.confirm_order(exchange_id, order_id, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param order_id: (required)
        :type order_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AuctionOrder
        """
        kwargs['_return_http_data_only'] = True
        return self.confirm_order_with_http_info(exchange_id, order_id, **kwargs)  # noqa: E501

    def confirm_order_with_http_info(self, exchange_id, order_id, **kwargs):  # noqa: E501
        """Confirm order  # noqa: E501

        Allows you to confirmation a staged order, after which it will be submitted to the exchange. In case that the order was rejected by the exchange, a modification by the user to the current order is required, after which it may be confirmed again to submit to the market.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.confirm_order_with_http_info(exchange_id, order_id, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param order_id: (required)
        :type order_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AuctionOrder, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange_id',
            'order_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method confirm_order" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_id' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_id` when calling `confirm_order`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if self.api_client.client_side_validation and local_var_params.get('order_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `order_id` when calling `confirm_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_id' in local_var_params:
            path_params['exchange_id'] = local_var_params['exchange_id']  # noqa: E501
        if 'order_id' in local_var_params:
            path_params['order_id'] = local_var_params['order_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "AuctionOrder",
        }

        return self.api_client.call_api(
            '/auction/{exchange_id}/{order_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_auction_order_history(self, exchange_id, auction_id, portfolio_id, delivery_area, order_type, **kwargs):  # noqa: E501
        """Get Order History  # noqa: E501

        Return a list of order revisions for the given auction, delivery area and portfolio and order type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_order_history(exchange_id, auction_id, portfolio_id, delivery_area, order_type, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param auction_id: The ID of the auction. (required)
        :type auction_id: str
        :param portfolio_id: The ID of the portfolio. (required)
        :type portfolio_id: str
        :param delivery_area: The delivery area of the order. (required)
        :type delivery_area: str
        :param order_type: The type of the order. Either curve or block. (required)
        :type order_type: AuctionOrderType
        :param revision_from: Specify the starting revision
        :type revision_from: int
        :param revision_to: Specify the ending revision
        :type revision_to: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AuctionOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_auction_order_history_with_http_info(exchange_id, auction_id, portfolio_id, delivery_area, order_type, **kwargs)  # noqa: E501

    def get_auction_order_history_with_http_info(self, exchange_id, auction_id, portfolio_id, delivery_area, order_type, **kwargs):  # noqa: E501
        """Get Order History  # noqa: E501

        Return a list of order revisions for the given auction, delivery area and portfolio and order type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_order_history_with_http_info(exchange_id, auction_id, portfolio_id, delivery_area, order_type, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param auction_id: The ID of the auction. (required)
        :type auction_id: str
        :param portfolio_id: The ID of the portfolio. (required)
        :type portfolio_id: str
        :param delivery_area: The delivery area of the order. (required)
        :type delivery_area: str
        :param order_type: The type of the order. Either curve or block. (required)
        :type order_type: AuctionOrderType
        :param revision_from: Specify the starting revision
        :type revision_from: int
        :param revision_to: Specify the ending revision
        :type revision_to: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[AuctionOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange_id',
            'auction_id',
            'portfolio_id',
            'delivery_area',
            'order_type',
            'revision_from',
            'revision_to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auction_order_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_id' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_id` when calling `get_auction_order_history`")  # noqa: E501
        # verify the required parameter 'auction_id' is set
        if self.api_client.client_side_validation and local_var_params.get('auction_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `auction_id` when calling `get_auction_order_history`")  # noqa: E501
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and local_var_params.get('portfolio_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `portfolio_id` when calling `get_auction_order_history`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_auction_order_history`")  # noqa: E501
        # verify the required parameter 'order_type' is set
        if self.api_client.client_side_validation and local_var_params.get('order_type') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `order_type` when calling `get_auction_order_history`")  # noqa: E501

        if self.api_client.client_side_validation and 'revision_from' in local_var_params and local_var_params['revision_from'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `revision_from` when calling `get_auction_order_history`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'revision_to' in local_var_params and local_var_params['revision_to'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `revision_to` when calling `get_auction_order_history`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'exchange_id' in local_var_params:
            path_params['exchange_id'] = local_var_params['exchange_id']  # noqa: E501
        if 'auction_id' in local_var_params:
            path_params['auction_id'] = local_var_params['auction_id']  # noqa: E501
        if 'portfolio_id' in local_var_params:
            path_params['portfolio_id'] = local_var_params['portfolio_id']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501
        if 'order_type' in local_var_params:
            path_params['order_type'] = local_var_params['order_type']  # noqa: E501

        query_params = []
        if local_var_params.get('revision_from') is not None:  # noqa: E501
            query_params.append(('revision_from', local_var_params['revision_from']))  # noqa: E501
        if local_var_params.get('revision_to') is not None:  # noqa: E501
            query_params.append(('revision_to', local_var_params['revision_to']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[AuctionOrder]",
            403: "ErrorResponse",
            404: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/auction/{exchange_id}/{auction_id}/{delivery_area}/{portfolio_id}/{order_type}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_auction_orders(self, exchange_id, auction_id, portfolio_id, delivery_area, **kwargs):  # noqa: E501
        """Get Orders  # noqa: E501

        Return the latest revision of curve and block orders for the given auction, delivery area and portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_orders(exchange_id, auction_id, portfolio_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param auction_id: The ID of the auction. (required)
        :type auction_id: str
        :param portfolio_id: The ID of the portfolio. (required)
        :type portfolio_id: str
        :param delivery_area: The delivery area used for the request. (required)
        :type delivery_area: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AuctionOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_auction_orders_with_http_info(exchange_id, auction_id, portfolio_id, delivery_area, **kwargs)  # noqa: E501

    def get_auction_orders_with_http_info(self, exchange_id, auction_id, portfolio_id, delivery_area, **kwargs):  # noqa: E501
        """Get Orders  # noqa: E501

        Return the latest revision of curve and block orders for the given auction, delivery area and portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_orders_with_http_info(exchange_id, auction_id, portfolio_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param auction_id: The ID of the auction. (required)
        :type auction_id: str
        :param portfolio_id: The ID of the portfolio. (required)
        :type portfolio_id: str
        :param delivery_area: The delivery area used for the request. (required)
        :type delivery_area: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[AuctionOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange_id',
            'auction_id',
            'portfolio_id',
            'delivery_area'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auction_orders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_id' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_id` when calling `get_auction_orders`")  # noqa: E501
        # verify the required parameter 'auction_id' is set
        if self.api_client.client_side_validation and local_var_params.get('auction_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `auction_id` when calling `get_auction_orders`")  # noqa: E501
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and local_var_params.get('portfolio_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `portfolio_id` when calling `get_auction_orders`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_auction_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_id' in local_var_params:
            path_params['exchange_id'] = local_var_params['exchange_id']  # noqa: E501
        if 'auction_id' in local_var_params:
            path_params['auction_id'] = local_var_params['auction_id']  # noqa: E501
        if 'portfolio_id' in local_var_params:
            path_params['portfolio_id'] = local_var_params['portfolio_id']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[AuctionOrder]",
            403: "ErrorResponse",
            404: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/auction/{exchange_id}/{auction_id}/{delivery_area}/{portfolio_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def save_order(self, exchange_id, **kwargs):  # noqa: E501
        """Save Order  # noqa: E501

        This endpoint allows for the addition or modification of an order. Each order is uniquely identified by the auction ID, delivery area and portfolio ID. It contains either curves or blocks, but not both. Only one of them can be provided at a time. In case there is no existing order, a new order will be created, otherwise the existing order will be updated. To deactivate an order, provide an empty curves or blocks array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_order(exchange_id, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param auction_order_entry:
        :type auction_order_entry: AuctionOrderEntry
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AuctionOrder
        """
        kwargs['_return_http_data_only'] = True
        return self.save_order_with_http_info(exchange_id, **kwargs)  # noqa: E501

    def save_order_with_http_info(self, exchange_id, **kwargs):  # noqa: E501
        """Save Order  # noqa: E501

        This endpoint allows for the addition or modification of an order. Each order is uniquely identified by the auction ID, delivery area and portfolio ID. It contains either curves or blocks, but not both. Only one of them can be provided at a time. In case there is no existing order, a new order will be created, otherwise the existing order will be updated. To deactivate an order, provide an empty curves or blocks array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_order_with_http_info(exchange_id, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param auction_order_entry:
        :type auction_order_entry: AuctionOrderEntry
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AuctionOrder, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange_id',
            'auction_order_entry'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_order" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_id' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_id` when calling `save_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_id' in local_var_params:
            path_params['exchange_id'] = local_var_params['exchange_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auction_order_entry' in local_var_params:
            body_params = local_var_params['auction_order_entry']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "AuctionOrder",
        }

        return self.api_client.call_api(
            '/auction/{exchange_id}/order', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
