# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_asyncio_client.api_client import ApiClient
from powerbot_asyncio_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AuctionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_auction_constraints(self, exchange_id, auction_id, delivery_area, portfolio_id, **kwargs):  # noqa: E501
        """Get auction constraints  # noqa: E501

        Returns the price constraints of the specified auction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_constraints(exchange_id, auction_id, delivery_area, portfolio_id, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param auction_id: (required)
        :type auction_id: str
        :param delivery_area: (required)
        :type delivery_area: str
        :param portfolio_id: (required)
        :type portfolio_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AuctionConstraints
        """
        kwargs['_return_http_data_only'] = True
        return self.get_auction_constraints_with_http_info(exchange_id, auction_id, delivery_area, portfolio_id, **kwargs)  # noqa: E501

    def get_auction_constraints_with_http_info(self, exchange_id, auction_id, delivery_area, portfolio_id, **kwargs):  # noqa: E501
        """Get auction constraints  # noqa: E501

        Returns the price constraints of the specified auction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_constraints_with_http_info(exchange_id, auction_id, delivery_area, portfolio_id, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param auction_id: (required)
        :type auction_id: str
        :param delivery_area: (required)
        :type delivery_area: str
        :param portfolio_id: (required)
        :type portfolio_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AuctionConstraints, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange_id',
            'auction_id',
            'delivery_area',
            'portfolio_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auction_constraints" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_id' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_id` when calling `get_auction_constraints`")  # noqa: E501
        # verify the required parameter 'auction_id' is set
        if self.api_client.client_side_validation and local_var_params.get('auction_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `auction_id` when calling `get_auction_constraints`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_auction_constraints`")  # noqa: E501
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and local_var_params.get('portfolio_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `portfolio_id` when calling `get_auction_constraints`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_id' in local_var_params:
            path_params['exchange_id'] = local_var_params['exchange_id']  # noqa: E501
        if 'auction_id' in local_var_params:
            path_params['auction_id'] = local_var_params['auction_id']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501
        if 'portfolio_id' in local_var_params:
            path_params['portfolio_id'] = local_var_params['portfolio_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "AuctionConstraints",
        }

        return self.api_client.call_api(
            '/auction/{exchange_id}/{auction_id}/{delivery_area}/{portfolio_id}/constraints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_auction_results(self, exchange_id, auction_ids, **kwargs):  # noqa: E501
        """Get Auction Results  # noqa: E501

        Returns the auction results for the provided parameters  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_results(exchange_id, auction_ids, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param auction_ids: The IDs of the auctions (required)
        :type auction_ids: list[str]
        :param delivery_areas: The delivery areas that should be contained by the auctions
        :type delivery_areas: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AuctionResult]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_auction_results_with_http_info(exchange_id, auction_ids, **kwargs)  # noqa: E501

    def get_auction_results_with_http_info(self, exchange_id, auction_ids, **kwargs):  # noqa: E501
        """Get Auction Results  # noqa: E501

        Returns the auction results for the provided parameters  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_auction_results_with_http_info(exchange_id, auction_ids, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param auction_ids: The IDs of the auctions (required)
        :type auction_ids: list[str]
        :param delivery_areas: The delivery areas that should be contained by the auctions
        :type delivery_areas: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[AuctionResult], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange_id',
            'auction_ids',
            'delivery_areas'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auction_results" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_id' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_id` when calling `get_auction_results`")  # noqa: E501
        # verify the required parameter 'auction_ids' is set
        if self.api_client.client_side_validation and local_var_params.get('auction_ids') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `auction_ids` when calling `get_auction_results`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_id' in local_var_params:
            path_params['exchange_id'] = local_var_params['exchange_id']  # noqa: E501

        query_params = []
        if local_var_params.get('auction_ids') is not None:  # noqa: E501
            query_params.append(('auction_ids', local_var_params['auction_ids']))  # noqa: E501
            collection_formats['auction_ids'] = 'multi'  # noqa: E501
        if local_var_params.get('delivery_areas') is not None:  # noqa: E501
            query_params.append(('delivery_areas', local_var_params['delivery_areas']))  # noqa: E501
            collection_formats['delivery_areas'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[AuctionResult]",
        }

        return self.api_client.call_api(
            '/auction/{exchange_id}/auctions/results', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_auctions(self, exchange_id, **kwargs):  # noqa: E501
        """List Auctions  # noqa: E501

        Returns all auctions for the provided parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_auctions(exchange_id, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param delivery_areas: This filter applies to auctions and auction contracts.
        :type delivery_areas: list[str]
        :param delivery_from: The starting point of the delivery period.
        :type delivery_from: datetime
        :param delivery_to: The end point of the delivery period.
        :type delivery_to: datetime
        :param auction_ids: The IDs of the auctions.
        :type auction_ids: list[str]
        :param gate_closure_from: The start time in which the auctions gate closure time should be contained.
        :type gate_closure_from: datetime
        :param gate_closure_to: The end time in which the auctions gate closure time should be contained.
        :type gate_closure_to: datetime
        :param portfolio_ids: limit the results to auctions that are available to the provided portfolios
        :type portfolio_ids: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Auction]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_auctions_with_http_info(exchange_id, **kwargs)  # noqa: E501

    def list_auctions_with_http_info(self, exchange_id, **kwargs):  # noqa: E501
        """List Auctions  # noqa: E501

        Returns all auctions for the provided parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_auctions_with_http_info(exchange_id, async_req=True)
        >>> result = thread.get()

        :param exchange_id: (required)
        :type exchange_id: Exchange
        :param delivery_areas: This filter applies to auctions and auction contracts.
        :type delivery_areas: list[str]
        :param delivery_from: The starting point of the delivery period.
        :type delivery_from: datetime
        :param delivery_to: The end point of the delivery period.
        :type delivery_to: datetime
        :param auction_ids: The IDs of the auctions.
        :type auction_ids: list[str]
        :param gate_closure_from: The start time in which the auctions gate closure time should be contained.
        :type gate_closure_from: datetime
        :param gate_closure_to: The end time in which the auctions gate closure time should be contained.
        :type gate_closure_to: datetime
        :param portfolio_ids: limit the results to auctions that are available to the provided portfolios
        :type portfolio_ids: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Auction], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'exchange_id',
            'delivery_areas',
            'delivery_from',
            'delivery_to',
            'auction_ids',
            'gate_closure_from',
            'gate_closure_to',
            'portfolio_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_auctions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_id' is set
        if self.api_client.client_side_validation and local_var_params.get('exchange_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_id` when calling `list_auctions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_id' in local_var_params:
            path_params['exchange_id'] = local_var_params['exchange_id']  # noqa: E501

        query_params = []
        if local_var_params.get('delivery_areas') is not None:  # noqa: E501
            query_params.append(('delivery_areas', local_var_params['delivery_areas']))  # noqa: E501
            collection_formats['delivery_areas'] = 'multi'  # noqa: E501
        if local_var_params.get('delivery_from') is not None:  # noqa: E501
            query_params.append(('delivery_from', local_var_params['delivery_from']))  # noqa: E501
        if local_var_params.get('delivery_to') is not None:  # noqa: E501
            query_params.append(('delivery_to', local_var_params['delivery_to']))  # noqa: E501
        if local_var_params.get('auction_ids') is not None:  # noqa: E501
            query_params.append(('auction_ids', local_var_params['auction_ids']))  # noqa: E501
            collection_formats['auction_ids'] = 'multi'  # noqa: E501
        if local_var_params.get('gate_closure_from') is not None:  # noqa: E501
            query_params.append(('gate_closure_from', local_var_params['gate_closure_from']))  # noqa: E501
        if local_var_params.get('gate_closure_to') is not None:  # noqa: E501
            query_params.append(('gate_closure_to', local_var_params['gate_closure_to']))  # noqa: E501
        if local_var_params.get('portfolio_ids') is not None:  # noqa: E501
            query_params.append(('portfolio_ids', local_var_params['portfolio_ids']))  # noqa: E501
            collection_formats['portfolio_ids'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[Auction]",
        }

        return self.api_client.call_api(
            '/auction/{exchange_id}/auctions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
