# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_asyncio_client.api_client import ApiClient
from powerbot_asyncio_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class SignalsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_signals(self, source, delivery_start, delivery_end, **kwargs):  # noqa: E501
        """Delete signals  # noqa: E501

        DEPRECATED. Signals are replaced by Trading Signals. Allows you to delete signals. By setting the optional delivery_areas and/or portfolio_ids parameters, you can delete signals for selected cases only. Without specifying these parameters, the signal is removed completely. **Heads up** The \"source\" of a signal containing position_long and position_short is always \"POSITION\".  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_signals(source, delivery_start, delivery_end, async_req=True)
        >>> result = thread.get()

        :param source: (required)
        :type source: str
        :param delivery_start: (required)
        :type delivery_start: datetime
        :param delivery_end: (required)
        :type delivery_end: datetime
        :param delivery_areas:
        :type delivery_areas: list[str]
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param exact: only delete signals matching `delivery_start` and `delivery_end` exactly
        :type exact: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_signals_with_http_info(source, delivery_start, delivery_end, **kwargs)  # noqa: E501

    def delete_signals_with_http_info(self, source, delivery_start, delivery_end, **kwargs):  # noqa: E501
        """Delete signals  # noqa: E501

        DEPRECATED. Signals are replaced by Trading Signals. Allows you to delete signals. By setting the optional delivery_areas and/or portfolio_ids parameters, you can delete signals for selected cases only. Without specifying these parameters, the signal is removed completely. **Heads up** The \"source\" of a signal containing position_long and position_short is always \"POSITION\".  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_signals_with_http_info(source, delivery_start, delivery_end, async_req=True)
        >>> result = thread.get()

        :param source: (required)
        :type source: str
        :param delivery_start: (required)
        :type delivery_start: datetime
        :param delivery_end: (required)
        :type delivery_end: datetime
        :param delivery_areas:
        :type delivery_areas: list[str]
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param exact: only delete signals matching `delivery_start` and `delivery_end` exactly
        :type exact: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'source',
            'delivery_start',
            'delivery_end',
            'delivery_areas',
            'portfolio_id',
            'exact'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_signals" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'source' is set
        if self.api_client.client_side_validation and local_var_params.get('source') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `source` when calling `delete_signals`")  # noqa: E501
        # verify the required parameter 'delivery_start' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_start') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_start` when calling `delete_signals`")  # noqa: E501
        # verify the required parameter 'delivery_end' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_end') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_end` when calling `delete_signals`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'source' in local_var_params:
            path_params['source'] = local_var_params['source']  # noqa: E501
        if 'delivery_start' in local_var_params:
            path_params['delivery_start'] = local_var_params['delivery_start']  # noqa: E501
        if 'delivery_end' in local_var_params:
            path_params['delivery_end'] = local_var_params['delivery_end']  # noqa: E501

        query_params = []
        if local_var_params.get('delivery_areas') is not None:  # noqa: E501
            query_params.append(('delivery_areas', local_var_params['delivery_areas']))  # noqa: E501
            collection_formats['delivery_areas'] = 'csv'  # noqa: E501
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if local_var_params.get('exact') is not None:  # noqa: E501
            query_params.append(('exact', local_var_params['exact']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/signals/{source}/{delivery_start}/{delivery_end}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_time_slice(self, source, delivery_area, portfolio_id, delivery_start, delivery_end, minutes_to_delivery, **kwargs):  # noqa: E501
        """Delete a time slice  # noqa: E501

        Deletes a single time slice of a trading signal. Will not increase the revision of a time slice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_time_slice(source, delivery_area, portfolio_id, delivery_start, delivery_end, minutes_to_delivery, async_req=True)
        >>> result = thread.get()

        :param source: The source of the signal (required)
        :type source: str
        :param delivery_area: The delivery area of the signal (required)
        :type delivery_area: str
        :param portfolio_id: The portfolio ID of the signal (required)
        :type portfolio_id: str
        :param delivery_start: The delivery start of the signal (required)
        :type delivery_start: datetime
        :param delivery_end: The delivery end of the signal (required)
        :type delivery_end: datetime
        :param minutes_to_delivery: The offset until delivery start (required)
        :type minutes_to_delivery: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_time_slice_with_http_info(source, delivery_area, portfolio_id, delivery_start, delivery_end, minutes_to_delivery, **kwargs)  # noqa: E501

    def delete_time_slice_with_http_info(self, source, delivery_area, portfolio_id, delivery_start, delivery_end, minutes_to_delivery, **kwargs):  # noqa: E501
        """Delete a time slice  # noqa: E501

        Deletes a single time slice of a trading signal. Will not increase the revision of a time slice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_time_slice_with_http_info(source, delivery_area, portfolio_id, delivery_start, delivery_end, minutes_to_delivery, async_req=True)
        >>> result = thread.get()

        :param source: The source of the signal (required)
        :type source: str
        :param delivery_area: The delivery area of the signal (required)
        :type delivery_area: str
        :param portfolio_id: The portfolio ID of the signal (required)
        :type portfolio_id: str
        :param delivery_start: The delivery start of the signal (required)
        :type delivery_start: datetime
        :param delivery_end: The delivery end of the signal (required)
        :type delivery_end: datetime
        :param minutes_to_delivery: The offset until delivery start (required)
        :type minutes_to_delivery: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'source',
            'delivery_area',
            'portfolio_id',
            'delivery_start',
            'delivery_end',
            'minutes_to_delivery'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_time_slice" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'source' is set
        if self.api_client.client_side_validation and local_var_params.get('source') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `source` when calling `delete_time_slice`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `delete_time_slice`")  # noqa: E501
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and local_var_params.get('portfolio_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `portfolio_id` when calling `delete_time_slice`")  # noqa: E501
        # verify the required parameter 'delivery_start' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_start') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_start` when calling `delete_time_slice`")  # noqa: E501
        # verify the required parameter 'delivery_end' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_end') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_end` when calling `delete_time_slice`")  # noqa: E501
        # verify the required parameter 'minutes_to_delivery' is set
        if self.api_client.client_side_validation and local_var_params.get('minutes_to_delivery') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `minutes_to_delivery` when calling `delete_time_slice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'source' in local_var_params:
            path_params['source'] = local_var_params['source']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501
        if 'portfolio_id' in local_var_params:
            path_params['portfolio_id'] = local_var_params['portfolio_id']  # noqa: E501
        if 'delivery_start' in local_var_params:
            path_params['delivery_start'] = local_var_params['delivery_start']  # noqa: E501
        if 'delivery_end' in local_var_params:
            path_params['delivery_end'] = local_var_params['delivery_end']  # noqa: E501
        if 'minutes_to_delivery' in local_var_params:
            path_params['minutes_to_delivery'] = local_var_params['minutes_to_delivery']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/trading-signal/{source}/{delivery_area}/{portfolio_id}/{delivery_start}/{delivery_end}/{minutes_to_delivery}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_trading_signal(self, source, delivery_area, portfolio_id, delivery_start, delivery_end, **kwargs):  # noqa: E501
        """Delete a trading signal  # noqa: E501

        Delete a trading signal with all of its time slices, meaning all signals which have the same source, delivery area, portfolio ID and delivery period. Deletion will not increase the revision of a time slice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_trading_signal(source, delivery_area, portfolio_id, delivery_start, delivery_end, async_req=True)
        >>> result = thread.get()

        :param source: The source of the signal (required)
        :type source: str
        :param delivery_area: The delivery area of the signal (required)
        :type delivery_area: str
        :param portfolio_id: The portfolio ID of the signal (required)
        :type portfolio_id: str
        :param delivery_start: The delivery start of the signal (required)
        :type delivery_start: datetime
        :param delivery_end: The delivery end of the signal (required)
        :type delivery_end: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_trading_signal_with_http_info(source, delivery_area, portfolio_id, delivery_start, delivery_end, **kwargs)  # noqa: E501

    def delete_trading_signal_with_http_info(self, source, delivery_area, portfolio_id, delivery_start, delivery_end, **kwargs):  # noqa: E501
        """Delete a trading signal  # noqa: E501

        Delete a trading signal with all of its time slices, meaning all signals which have the same source, delivery area, portfolio ID and delivery period. Deletion will not increase the revision of a time slice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_trading_signal_with_http_info(source, delivery_area, portfolio_id, delivery_start, delivery_end, async_req=True)
        >>> result = thread.get()

        :param source: The source of the signal (required)
        :type source: str
        :param delivery_area: The delivery area of the signal (required)
        :type delivery_area: str
        :param portfolio_id: The portfolio ID of the signal (required)
        :type portfolio_id: str
        :param delivery_start: The delivery start of the signal (required)
        :type delivery_start: datetime
        :param delivery_end: The delivery end of the signal (required)
        :type delivery_end: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'source',
            'delivery_area',
            'portfolio_id',
            'delivery_start',
            'delivery_end'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_trading_signal" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'source' is set
        if self.api_client.client_side_validation and local_var_params.get('source') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `source` when calling `delete_trading_signal`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `delete_trading_signal`")  # noqa: E501
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and local_var_params.get('portfolio_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `portfolio_id` when calling `delete_trading_signal`")  # noqa: E501
        # verify the required parameter 'delivery_start' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_start') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_start` when calling `delete_trading_signal`")  # noqa: E501
        # verify the required parameter 'delivery_end' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_end') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_end` when calling `delete_trading_signal`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'source' in local_var_params:
            path_params['source'] = local_var_params['source']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501
        if 'portfolio_id' in local_var_params:
            path_params['portfolio_id'] = local_var_params['portfolio_id']  # noqa: E501
        if 'delivery_start' in local_var_params:
            path_params['delivery_start'] = local_var_params['delivery_start']  # noqa: E501
        if 'delivery_end' in local_var_params:
            path_params['delivery_end'] = local_var_params['delivery_end']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/trading-signal/{source}/{delivery_area}/{portfolio_id}/{delivery_start}/{delivery_end}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def find_trading_signals(self, delivery_area, portfolio_id, **kwargs):  # noqa: E501
        """Find trading signals  # noqa: E501

        Retrieves trading signals based on the given filter criteria. This endpoint also provides historic signal data when the `include_historic` parameter is set to true. The response object will contain the list of all unique sources and the actual signals, grouped by their source, delivery area, portfolio ID and delivery period. Signals will be sorted in ascending order by the aforementioned parameters — time slices are in descending order based on their minutes to delivery. Note that you have to either specify 'delivery_start' and 'delivery_end' or 'delivery_from' and 'delivery_to'. The maximum timespan is limited to 48 hours.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_trading_signals(delivery_area, portfolio_id, async_req=True)
        >>> result = thread.get()

        :param delivery_area: The delivery area of the trading signal. (required)
        :type delivery_area: str
        :param portfolio_id: The portfolio ID of the trading signal. (required)
        :type portfolio_id: str
        :param source: The source of the trading signal.
        :type source: str
        :param delivery_start: The 'delivery_start' of the signal in UTC. Has be used together with 'delivery_end' and cannot be combined with 'delivery_from' or 'delivery_to'.
        :type delivery_start: datetime
        :param delivery_end: The 'delivery_end' of the signal in UTC. Has be used together with 'delivery_start' and cannot be combined with 'delivery_from' or 'delivery_to'.
        :type delivery_end: datetime
        :param delivery_from: Limit trading signals to those that have a 'delivery_start' greater or equal to the given value. Has be used together with 'delivery_to' and cannot be combined with 'delivery_start' or 'delivery_end'. The maximum timespan is limited to 48 hours.
        :type delivery_from: datetime
        :param delivery_to: Limit trading signals to those that have a delivery end less than or equal to the given value. Has be used together with 'delivery_from' and cannot be combined with 'delivery_start' or 'delivery_end'. The maximum timespan is limited to 48 hours.
        :type delivery_to: datetime
        :param minutes_to_delivery_gte: The value of `minutes_to_delivery` which is greater than or equal to input parameter. Has to be used together with `minutes_to_delivery_lte` and cannot be combined with `active_only`.
        :type minutes_to_delivery_gte: int
        :param minutes_to_delivery_lte: The value of `minutes_to_delivery` which is less than or equal to input parameter. Has to be used together with `minutes_to_delivery_gte` and cannot be combined with `active_only`.
        :type minutes_to_delivery_lte: int
        :param received_from: from timestamp is 'inclusive' (i.e. >=), use UTC timezone
        :type received_from: datetime
        :param received_to: to timestamp is 'exclusive' (i.e. <), use UTC timezone
        :type received_to: datetime
        :param revision_from: The starting revision from 0
        :type revision_from: int
        :param revision_to: The ending revision (non-inclusive)
        :type revision_to: int
        :param offset: Offset when loading a list of items.
        :type offset: int
        :param limit: Limits the number of loaded items.
        :type limit: int
        :param include_historic: Setting this to `true` will also return old (overwritten) signal revisions. Cannot be combined with `active_only=true`.
        :type include_historic: bool
        :param include_deleted: Setting this to `true` will also return deleted time slices. Cannot be combined with `active_only=true`.
        :type include_deleted: bool
        :param active_only: Filter for only currently active time slices. Cannot be combined with `include_historic=true`.
        :type active_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalSearchResult
        """
        kwargs['_return_http_data_only'] = True
        return self.find_trading_signals_with_http_info(delivery_area, portfolio_id, **kwargs)  # noqa: E501

    def find_trading_signals_with_http_info(self, delivery_area, portfolio_id, **kwargs):  # noqa: E501
        """Find trading signals  # noqa: E501

        Retrieves trading signals based on the given filter criteria. This endpoint also provides historic signal data when the `include_historic` parameter is set to true. The response object will contain the list of all unique sources and the actual signals, grouped by their source, delivery area, portfolio ID and delivery period. Signals will be sorted in ascending order by the aforementioned parameters — time slices are in descending order based on their minutes to delivery. Note that you have to either specify 'delivery_start' and 'delivery_end' or 'delivery_from' and 'delivery_to'. The maximum timespan is limited to 48 hours.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_trading_signals_with_http_info(delivery_area, portfolio_id, async_req=True)
        >>> result = thread.get()

        :param delivery_area: The delivery area of the trading signal. (required)
        :type delivery_area: str
        :param portfolio_id: The portfolio ID of the trading signal. (required)
        :type portfolio_id: str
        :param source: The source of the trading signal.
        :type source: str
        :param delivery_start: The 'delivery_start' of the signal in UTC. Has be used together with 'delivery_end' and cannot be combined with 'delivery_from' or 'delivery_to'.
        :type delivery_start: datetime
        :param delivery_end: The 'delivery_end' of the signal in UTC. Has be used together with 'delivery_start' and cannot be combined with 'delivery_from' or 'delivery_to'.
        :type delivery_end: datetime
        :param delivery_from: Limit trading signals to those that have a 'delivery_start' greater or equal to the given value. Has be used together with 'delivery_to' and cannot be combined with 'delivery_start' or 'delivery_end'. The maximum timespan is limited to 48 hours.
        :type delivery_from: datetime
        :param delivery_to: Limit trading signals to those that have a delivery end less than or equal to the given value. Has be used together with 'delivery_from' and cannot be combined with 'delivery_start' or 'delivery_end'. The maximum timespan is limited to 48 hours.
        :type delivery_to: datetime
        :param minutes_to_delivery_gte: The value of `minutes_to_delivery` which is greater than or equal to input parameter. Has to be used together with `minutes_to_delivery_lte` and cannot be combined with `active_only`.
        :type minutes_to_delivery_gte: int
        :param minutes_to_delivery_lte: The value of `minutes_to_delivery` which is less than or equal to input parameter. Has to be used together with `minutes_to_delivery_gte` and cannot be combined with `active_only`.
        :type minutes_to_delivery_lte: int
        :param received_from: from timestamp is 'inclusive' (i.e. >=), use UTC timezone
        :type received_from: datetime
        :param received_to: to timestamp is 'exclusive' (i.e. <), use UTC timezone
        :type received_to: datetime
        :param revision_from: The starting revision from 0
        :type revision_from: int
        :param revision_to: The ending revision (non-inclusive)
        :type revision_to: int
        :param offset: Offset when loading a list of items.
        :type offset: int
        :param limit: Limits the number of loaded items.
        :type limit: int
        :param include_historic: Setting this to `true` will also return old (overwritten) signal revisions. Cannot be combined with `active_only=true`.
        :type include_historic: bool
        :param include_deleted: Setting this to `true` will also return deleted time slices. Cannot be combined with `active_only=true`.
        :type include_deleted: bool
        :param active_only: Filter for only currently active time slices. Cannot be combined with `include_historic=true`.
        :type active_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SignalSearchResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'delivery_area',
            'portfolio_id',
            'source',
            'delivery_start',
            'delivery_end',
            'delivery_from',
            'delivery_to',
            'minutes_to_delivery_gte',
            'minutes_to_delivery_lte',
            'received_from',
            'received_to',
            'revision_from',
            'revision_to',
            'offset',
            'limit',
            'include_historic',
            'include_deleted',
            'active_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_trading_signals" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `find_trading_signals`")  # noqa: E501
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and local_var_params.get('portfolio_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `portfolio_id` when calling `find_trading_signals`")  # noqa: E501

        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `find_trading_signals`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 150:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `find_trading_signals`, must be a value less than or equal to `150`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `find_trading_signals`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('source') is not None:  # noqa: E501
            query_params.append(('source', local_var_params['source']))  # noqa: E501
        if local_var_params.get('delivery_area') is not None:  # noqa: E501
            query_params.append(('delivery_area', local_var_params['delivery_area']))  # noqa: E501
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
        if local_var_params.get('delivery_start') is not None:  # noqa: E501
            query_params.append(('delivery_start', local_var_params['delivery_start']))  # noqa: E501
        if local_var_params.get('delivery_end') is not None:  # noqa: E501
            query_params.append(('delivery_end', local_var_params['delivery_end']))  # noqa: E501
        if local_var_params.get('delivery_from') is not None:  # noqa: E501
            query_params.append(('delivery_from', local_var_params['delivery_from']))  # noqa: E501
        if local_var_params.get('delivery_to') is not None:  # noqa: E501
            query_params.append(('delivery_to', local_var_params['delivery_to']))  # noqa: E501
        if local_var_params.get('minutes_to_delivery_gte') is not None:  # noqa: E501
            query_params.append(('minutes_to_delivery_gte', local_var_params['minutes_to_delivery_gte']))  # noqa: E501
        if local_var_params.get('minutes_to_delivery_lte') is not None:  # noqa: E501
            query_params.append(('minutes_to_delivery_lte', local_var_params['minutes_to_delivery_lte']))  # noqa: E501
        if local_var_params.get('received_from') is not None:  # noqa: E501
            query_params.append(('received_from', local_var_params['received_from']))  # noqa: E501
        if local_var_params.get('received_to') is not None:  # noqa: E501
            query_params.append(('received_to', local_var_params['received_to']))  # noqa: E501
        if local_var_params.get('revision_from') is not None:  # noqa: E501
            query_params.append(('revision_from', local_var_params['revision_from']))  # noqa: E501
        if local_var_params.get('revision_to') is not None:  # noqa: E501
            query_params.append(('revision_to', local_var_params['revision_to']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('include_historic') is not None:  # noqa: E501
            query_params.append(('include_historic', local_var_params['include_historic']))  # noqa: E501
        if local_var_params.get('include_deleted') is not None:  # noqa: E501
            query_params.append(('include_deleted', local_var_params['include_deleted']))  # noqa: E501
        if local_var_params.get('active_only') is not None:  # noqa: E501
            query_params.append(('active_only', local_var_params['active_only']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "SignalSearchResult",
        }

        return self.api_client.call_api(
            '/trading-signals', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_signals(self, **kwargs):  # noqa: E501
        """List signals  # noqa: E501

        DEPRECATED. Signals are replaced by Trading Signals. Allows you to retrieve signals you have previously sent to the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_signals(async_req=True)
        >>> result = thread.get()

        :param portfolio_id:
        :type portfolio_id: list[str]
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded items
        :type limit: int
        :param received_from: from timestamp is 'inclusive' (i.e. >=), use UTC timezone
        :type received_from: datetime
        :param received_to: to timestamp is 'exclusive' (i.e. <), use UTC timezone
        :type received_to: datetime
        :param delivery_area: filter by delivery area
        :type delivery_area: str
        :param delivery_start: filter by delivery_start, use UTC timezone
        :type delivery_start: datetime
        :param delivery_end: filter by delivery_end, use UTC timezone
        :type delivery_end: datetime
        :param delivery_from: limit signals to those that have a delivery start greater or equal to the given value
        :type delivery_from: datetime
        :param delivery_to: limit signals to those that have a delivery end less than or equal to the given value
        :type delivery_to: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Signal]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_signals_with_http_info(**kwargs)  # noqa: E501

    def get_signals_with_http_info(self, **kwargs):  # noqa: E501
        """List signals  # noqa: E501

        DEPRECATED. Signals are replaced by Trading Signals. Allows you to retrieve signals you have previously sent to the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_signals_with_http_info(async_req=True)
        >>> result = thread.get()

        :param portfolio_id:
        :type portfolio_id: list[str]
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded items
        :type limit: int
        :param received_from: from timestamp is 'inclusive' (i.e. >=), use UTC timezone
        :type received_from: datetime
        :param received_to: to timestamp is 'exclusive' (i.e. <), use UTC timezone
        :type received_to: datetime
        :param delivery_area: filter by delivery area
        :type delivery_area: str
        :param delivery_start: filter by delivery_start, use UTC timezone
        :type delivery_start: datetime
        :param delivery_end: filter by delivery_end, use UTC timezone
        :type delivery_end: datetime
        :param delivery_from: limit signals to those that have a delivery start greater or equal to the given value
        :type delivery_from: datetime
        :param delivery_to: limit signals to those that have a delivery end less than or equal to the given value
        :type delivery_to: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Signal], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'portfolio_id',
            'offset',
            'limit',
            'received_from',
            'received_to',
            'delivery_area',
            'delivery_start',
            'delivery_end',
            'delivery_from',
            'delivery_to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_signals" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_signals`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_signals`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_signals`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('received_from') is not None:  # noqa: E501
            query_params.append(('received_from', local_var_params['received_from']))  # noqa: E501
        if local_var_params.get('received_to') is not None:  # noqa: E501
            query_params.append(('received_to', local_var_params['received_to']))  # noqa: E501
        if local_var_params.get('delivery_area') is not None:  # noqa: E501
            query_params.append(('delivery_area', local_var_params['delivery_area']))  # noqa: E501
        if local_var_params.get('delivery_start') is not None:  # noqa: E501
            query_params.append(('delivery_start', local_var_params['delivery_start']))  # noqa: E501
        if local_var_params.get('delivery_end') is not None:  # noqa: E501
            query_params.append(('delivery_end', local_var_params['delivery_end']))  # noqa: E501
        if local_var_params.get('delivery_from') is not None:  # noqa: E501
            query_params.append(('delivery_from', local_var_params['delivery_from']))  # noqa: E501
        if local_var_params.get('delivery_to') is not None:  # noqa: E501
            query_params.append(('delivery_to', local_var_params['delivery_to']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[Signal]",
        }

        return self.api_client.call_api(
            '/signals', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_signals_history(self, **kwargs):  # noqa: E501
        """List signals history  # noqa: E501

        DEPRECATED. Signals are replaced by Trading Signals. Allows you to retrieve the signal history.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_signals_history(async_req=True)
        >>> result = thread.get()

        :param portfolio_id:
        :type portfolio_id: list[str]
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded items
        :type limit: int
        :param received_from: from timestamp is 'inclusive' (i.e. >=), use UTC timezone
        :type received_from: datetime
        :param received_to: to timestamp is 'exclusive' (i.e. <), use UTC timezone
        :type received_to: datetime
        :param delivery_area: filter by delivery area
        :type delivery_area: str
        :param delivery_start: filter by delivery_start, use UTC timezone
        :type delivery_start: datetime
        :param delivery_end: filter by delivery_end, use UTC timezone
        :type delivery_end: datetime
        :param delivery_from: limit signals to those that have a delivery start greater or equal to the given value
        :type delivery_from: datetime
        :param delivery_to: limit signals to those that have a delivery end less than or equal to the given value
        :type delivery_to: datetime
        :param source: filter by signal source
        :type source: str
        :param revision_from: limit to revisions greater or equal to the given value
        :type revision_from: int
        :param revision_to: limit to revisions greater or equal to the given value
        :type revision_to: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Signal]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_signals_history_with_http_info(**kwargs)  # noqa: E501

    def get_signals_history_with_http_info(self, **kwargs):  # noqa: E501
        """List signals history  # noqa: E501

        DEPRECATED. Signals are replaced by Trading Signals. Allows you to retrieve the signal history.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_signals_history_with_http_info(async_req=True)
        >>> result = thread.get()

        :param portfolio_id:
        :type portfolio_id: list[str]
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded items
        :type limit: int
        :param received_from: from timestamp is 'inclusive' (i.e. >=), use UTC timezone
        :type received_from: datetime
        :param received_to: to timestamp is 'exclusive' (i.e. <), use UTC timezone
        :type received_to: datetime
        :param delivery_area: filter by delivery area
        :type delivery_area: str
        :param delivery_start: filter by delivery_start, use UTC timezone
        :type delivery_start: datetime
        :param delivery_end: filter by delivery_end, use UTC timezone
        :type delivery_end: datetime
        :param delivery_from: limit signals to those that have a delivery start greater or equal to the given value
        :type delivery_from: datetime
        :param delivery_to: limit signals to those that have a delivery end less than or equal to the given value
        :type delivery_to: datetime
        :param source: filter by signal source
        :type source: str
        :param revision_from: limit to revisions greater or equal to the given value
        :type revision_from: int
        :param revision_to: limit to revisions greater or equal to the given value
        :type revision_to: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Signal], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'portfolio_id',
            'offset',
            'limit',
            'received_from',
            'received_to',
            'delivery_area',
            'delivery_start',
            'delivery_end',
            'delivery_from',
            'delivery_to',
            'source',
            'revision_from',
            'revision_to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_signals_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_signals_history`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_signals_history`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_signals_history`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('received_from') is not None:  # noqa: E501
            query_params.append(('received_from', local_var_params['received_from']))  # noqa: E501
        if local_var_params.get('received_to') is not None:  # noqa: E501
            query_params.append(('received_to', local_var_params['received_to']))  # noqa: E501
        if local_var_params.get('delivery_area') is not None:  # noqa: E501
            query_params.append(('delivery_area', local_var_params['delivery_area']))  # noqa: E501
        if local_var_params.get('delivery_start') is not None:  # noqa: E501
            query_params.append(('delivery_start', local_var_params['delivery_start']))  # noqa: E501
        if local_var_params.get('delivery_end') is not None:  # noqa: E501
            query_params.append(('delivery_end', local_var_params['delivery_end']))  # noqa: E501
        if local_var_params.get('delivery_from') is not None:  # noqa: E501
            query_params.append(('delivery_from', local_var_params['delivery_from']))  # noqa: E501
        if local_var_params.get('delivery_to') is not None:  # noqa: E501
            query_params.append(('delivery_to', local_var_params['delivery_to']))  # noqa: E501
        if local_var_params.get('source') is not None:  # noqa: E501
            query_params.append(('source', local_var_params['source']))  # noqa: E501
        if local_var_params.get('revision_from') is not None:  # noqa: E501
            query_params.append(('revision_from', local_var_params['revision_from']))  # noqa: E501
        if local_var_params.get('revision_to') is not None:  # noqa: E501
            query_params.append(('revision_to', local_var_params['revision_to']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[Signal]",
        }

        return self.api_client.call_api(
            '/signals/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_sources_durations(self, delivery_area, portfolio_id, **kwargs):  # noqa: E501
        """Get sources and durations  # noqa: E501

        Retrieves all unique sources and durations of a trading signals delivery period. Note that you have to either specify 'delivery_start' and 'delivery_end' or 'delivery_from' and 'delivery_to'. The maximum timespan is limited to 48 hours.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sources_durations(delivery_area, portfolio_id, async_req=True)
        >>> result = thread.get()

        :param delivery_area: The delivery area of the trading signal. (required)
        :type delivery_area: str
        :param portfolio_id: The portfolio ID of the trading signal. (required)
        :type portfolio_id: str
        :param delivery_start: filter by delivery_start, use UTC timezone
        :type delivery_start: datetime
        :param delivery_end: filter by delivery_end, use UTC timezone
        :type delivery_end: datetime
        :param delivery_from: limit signals to those that have a delivery start greater or equal to the given value
        :type delivery_from: datetime
        :param delivery_to: limit signals to those that have a delivery end less than or equal to the given value
        :type delivery_to: datetime
        :param minutes_to_delivery_gte: The value of `minutes_to_delivery` which is greater than or equal to input parameter. Has to be used together with `minutes_to_delivery_lte` and cannot be combined with `active_only`.
        :type minutes_to_delivery_gte: int
        :param minutes_to_delivery_lte: The value of `minutes_to_delivery` which is less than or equal to input parameter. Has to be used together with `minutes_to_delivery_gte` and cannot be combined with `active_only`.
        :type minutes_to_delivery_lte: int
        :param received_from: from timestamp is 'inclusive' (i.e. >=), use UTC timezone
        :type received_from: datetime
        :param received_to: to timestamp is 'exclusive' (i.e. <), use UTC timezone
        :type received_to: datetime
        :param revision_from: The starting revision from 0
        :type revision_from: int
        :param revision_to: The ending revision (non-inclusive)
        :type revision_to: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[SignalSourceDurations]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_sources_durations_with_http_info(delivery_area, portfolio_id, **kwargs)  # noqa: E501

    def get_sources_durations_with_http_info(self, delivery_area, portfolio_id, **kwargs):  # noqa: E501
        """Get sources and durations  # noqa: E501

        Retrieves all unique sources and durations of a trading signals delivery period. Note that you have to either specify 'delivery_start' and 'delivery_end' or 'delivery_from' and 'delivery_to'. The maximum timespan is limited to 48 hours.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sources_durations_with_http_info(delivery_area, portfolio_id, async_req=True)
        >>> result = thread.get()

        :param delivery_area: The delivery area of the trading signal. (required)
        :type delivery_area: str
        :param portfolio_id: The portfolio ID of the trading signal. (required)
        :type portfolio_id: str
        :param delivery_start: filter by delivery_start, use UTC timezone
        :type delivery_start: datetime
        :param delivery_end: filter by delivery_end, use UTC timezone
        :type delivery_end: datetime
        :param delivery_from: limit signals to those that have a delivery start greater or equal to the given value
        :type delivery_from: datetime
        :param delivery_to: limit signals to those that have a delivery end less than or equal to the given value
        :type delivery_to: datetime
        :param minutes_to_delivery_gte: The value of `minutes_to_delivery` which is greater than or equal to input parameter. Has to be used together with `minutes_to_delivery_lte` and cannot be combined with `active_only`.
        :type minutes_to_delivery_gte: int
        :param minutes_to_delivery_lte: The value of `minutes_to_delivery` which is less than or equal to input parameter. Has to be used together with `minutes_to_delivery_gte` and cannot be combined with `active_only`.
        :type minutes_to_delivery_lte: int
        :param received_from: from timestamp is 'inclusive' (i.e. >=), use UTC timezone
        :type received_from: datetime
        :param received_to: to timestamp is 'exclusive' (i.e. <), use UTC timezone
        :type received_to: datetime
        :param revision_from: The starting revision from 0
        :type revision_from: int
        :param revision_to: The ending revision (non-inclusive)
        :type revision_to: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[SignalSourceDurations], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'delivery_area',
            'portfolio_id',
            'delivery_start',
            'delivery_end',
            'delivery_from',
            'delivery_to',
            'minutes_to_delivery_gte',
            'minutes_to_delivery_lte',
            'received_from',
            'received_to',
            'revision_from',
            'revision_to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sources_durations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_sources_durations`")  # noqa: E501
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and local_var_params.get('portfolio_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `portfolio_id` when calling `get_sources_durations`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('delivery_area') is not None:  # noqa: E501
            query_params.append(('delivery_area', local_var_params['delivery_area']))  # noqa: E501
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
        if local_var_params.get('delivery_start') is not None:  # noqa: E501
            query_params.append(('delivery_start', local_var_params['delivery_start']))  # noqa: E501
        if local_var_params.get('delivery_end') is not None:  # noqa: E501
            query_params.append(('delivery_end', local_var_params['delivery_end']))  # noqa: E501
        if local_var_params.get('delivery_from') is not None:  # noqa: E501
            query_params.append(('delivery_from', local_var_params['delivery_from']))  # noqa: E501
        if local_var_params.get('delivery_to') is not None:  # noqa: E501
            query_params.append(('delivery_to', local_var_params['delivery_to']))  # noqa: E501
        if local_var_params.get('minutes_to_delivery_gte') is not None:  # noqa: E501
            query_params.append(('minutes_to_delivery_gte', local_var_params['minutes_to_delivery_gte']))  # noqa: E501
        if local_var_params.get('minutes_to_delivery_lte') is not None:  # noqa: E501
            query_params.append(('minutes_to_delivery_lte', local_var_params['minutes_to_delivery_lte']))  # noqa: E501
        if local_var_params.get('received_from') is not None:  # noqa: E501
            query_params.append(('received_from', local_var_params['received_from']))  # noqa: E501
        if local_var_params.get('received_to') is not None:  # noqa: E501
            query_params.append(('received_to', local_var_params['received_to']))  # noqa: E501
        if local_var_params.get('revision_from') is not None:  # noqa: E501
            query_params.append(('revision_from', local_var_params['revision_from']))  # noqa: E501
        if local_var_params.get('revision_to') is not None:  # noqa: E501
            query_params.append(('revision_to', local_var_params['revision_to']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[SignalSourceDurations]",
        }

        return self.api_client.call_api(
            '/trading-signals/sources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def save_trading_signals(self, signal_entry, **kwargs):  # noqa: E501
        """Save trading signals  # noqa: E501

        This endpoint allows you to add or update trading signals. A trading signal can consist of multiple time slices, each with its individual validity period and set of parameters. The validity of a time slice is defined by an offset (in minutes) relative to the respective delivery start. For each trading signal only one time slice can be active at any given point in time. For a time slice to be considered active, the current time to delivery start must have passed the offset configuration. Moreover, only the time slice closest to the current time takes effect. For instance, suppose a trading signal has two time slices with their respective offsets set to 45 and 75 minutes relative to delivery start. Assuming that there are still 60 minutes until delivery start, then the active time slice would be one with an offset of 75 minutes. Eventually, as the time to delivery start passes the 45 minute mark the active time slice is switched.  Sending multiple time slices with the same offset is not allowed and will return an error message for each time slice affected. When sending multiple time slices, you can use the `delete_related` parameter to remove existing related time slices. Related time slices in this context are defined as those which have the same source, area, portfolio ID and delivery period. Only unlocked slices will be deleted when set. Updating the parameters of an existing time slice always completely override existing data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_trading_signals(signal_entry, async_req=True)
        >>> result = thread.get()

        :param signal_entry: Signal payload (required)
        :type signal_entry: list[SignalEntry]
        :param ignore_lock: Setting this parameter to true allows for modification of locked signals. Unlocking a signal also requires this parameter to be true.
        :type ignore_lock: bool
        :param delete_related: Set this to `true`, if related slices, meaning slices with the same source, delivery area, portfolio ID and delivery period should be overridden and replaced by the newly sent items.
        :type delete_related: bool
        :param algorithm_id: The algorithm associated with the posted signals. When set, the parameters of the signals will be validated against the schema of the algorithm.
        :type algorithm_id: str
        :param disable_history: Setting this value to true disables the persistence and historization feature for signals, meaning that only the latest revisions of updated signals will be stored. We strongly encourage you to enable this if you plan on submitting more than a few dozen revisions per signal source, as it improves performance of subsequent requests that use signals significantly.
        :type disable_history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalEntryResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.save_trading_signals_with_http_info(signal_entry, **kwargs)  # noqa: E501

    def save_trading_signals_with_http_info(self, signal_entry, **kwargs):  # noqa: E501
        """Save trading signals  # noqa: E501

        This endpoint allows you to add or update trading signals. A trading signal can consist of multiple time slices, each with its individual validity period and set of parameters. The validity of a time slice is defined by an offset (in minutes) relative to the respective delivery start. For each trading signal only one time slice can be active at any given point in time. For a time slice to be considered active, the current time to delivery start must have passed the offset configuration. Moreover, only the time slice closest to the current time takes effect. For instance, suppose a trading signal has two time slices with their respective offsets set to 45 and 75 minutes relative to delivery start. Assuming that there are still 60 minutes until delivery start, then the active time slice would be one with an offset of 75 minutes. Eventually, as the time to delivery start passes the 45 minute mark the active time slice is switched.  Sending multiple time slices with the same offset is not allowed and will return an error message for each time slice affected. When sending multiple time slices, you can use the `delete_related` parameter to remove existing related time slices. Related time slices in this context are defined as those which have the same source, area, portfolio ID and delivery period. Only unlocked slices will be deleted when set. Updating the parameters of an existing time slice always completely override existing data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_trading_signals_with_http_info(signal_entry, async_req=True)
        >>> result = thread.get()

        :param signal_entry: Signal payload (required)
        :type signal_entry: list[SignalEntry]
        :param ignore_lock: Setting this parameter to true allows for modification of locked signals. Unlocking a signal also requires this parameter to be true.
        :type ignore_lock: bool
        :param delete_related: Set this to `true`, if related slices, meaning slices with the same source, delivery area, portfolio ID and delivery period should be overridden and replaced by the newly sent items.
        :type delete_related: bool
        :param algorithm_id: The algorithm associated with the posted signals. When set, the parameters of the signals will be validated against the schema of the algorithm.
        :type algorithm_id: str
        :param disable_history: Setting this value to true disables the persistence and historization feature for signals, meaning that only the latest revisions of updated signals will be stored. We strongly encourage you to enable this if you plan on submitting more than a few dozen revisions per signal source, as it improves performance of subsequent requests that use signals significantly.
        :type disable_history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SignalEntryResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'signal_entry',
            'ignore_lock',
            'delete_related',
            'algorithm_id',
            'disable_history'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_trading_signals" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'signal_entry' is set
        if self.api_client.client_side_validation and local_var_params.get('signal_entry') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `signal_entry` when calling `save_trading_signals`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('ignore_lock') is not None:  # noqa: E501
            query_params.append(('ignore_lock', local_var_params['ignore_lock']))  # noqa: E501
        if local_var_params.get('delete_related') is not None:  # noqa: E501
            query_params.append(('delete_related', local_var_params['delete_related']))  # noqa: E501
        if local_var_params.get('algorithm_id') is not None:  # noqa: E501
            query_params.append(('algorithm_id', local_var_params['algorithm_id']))  # noqa: E501
        if local_var_params.get('disable_history') is not None:  # noqa: E501
            query_params.append(('disable_history', local_var_params['disable_history']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'signal_entry' in local_var_params:
            body_params = local_var_params['signal_entry']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "SignalEntryResponse",
            409: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/trading-signals', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_signals(self, value, **kwargs):  # noqa: E501
        """Add signals  # noqa: E501

        DEPRECATED. Signals are replaced by Trading Signals. Any request to this endpoint will also add a trading signal with a offset from now until delivery start. Allows you to send trading signals to the system, e.g. positions, fundamental data, weather data or outputs of an optimization software. This data is then aligned to contracts at the market and delivered with the orderbook. This way, trading signals are automatically archived for ex-post analysis and algorithms do not need to import data themselves. In addition, signals are displayed in the dashboard.  This methods can receive a collection of signals at once and each signal has a freely defined source (e.g. ETRM_system).  Note that it is not possible to post signals for a defined contract. All contracts which have the specified \"delivery_start\" and \"delivery_end\" field will receive the signal (e.g. XBID and local contracts), limited to the specified delivery areas and portfolios.  A signal can contain EITHER a position_long and position_short (the MWs to be traded, both need to be equal or greater than zero) OR a freely defined JSON object containing key/value pairs, but not both at once.  **Heads up** The \"source\" of a signal containing position_long and position_short will always be \"POSITION\", no matter what is defined in the request body.  * \"position_long\" indicates the surplus in MW that should or can be sold at the market (equal or greater than zero)  * \"position_short\" indicates the deficiency in MW that should or can be bought at the market (equal or greater than zero)  * \"value\" should contain the freely defined JSON object with key/value pairs. Please be aware that a signal-key for each contract is unique and data is overwritten, if sent from multiple sources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_signals(value, async_req=True)
        >>> result = thread.get()

        :param value: Signals payload (required)
        :type value: list[BulkSignal]
        :param ignore_lock: Setting this parameter to true allows for modification of locked signals. Unlocking a signal also requires this parameter to be true.
        :type ignore_lock: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[BulkSignalResponse]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_signals_with_http_info(value, **kwargs)  # noqa: E501

    def update_signals_with_http_info(self, value, **kwargs):  # noqa: E501
        """Add signals  # noqa: E501

        DEPRECATED. Signals are replaced by Trading Signals. Any request to this endpoint will also add a trading signal with a offset from now until delivery start. Allows you to send trading signals to the system, e.g. positions, fundamental data, weather data or outputs of an optimization software. This data is then aligned to contracts at the market and delivered with the orderbook. This way, trading signals are automatically archived for ex-post analysis and algorithms do not need to import data themselves. In addition, signals are displayed in the dashboard.  This methods can receive a collection of signals at once and each signal has a freely defined source (e.g. ETRM_system).  Note that it is not possible to post signals for a defined contract. All contracts which have the specified \"delivery_start\" and \"delivery_end\" field will receive the signal (e.g. XBID and local contracts), limited to the specified delivery areas and portfolios.  A signal can contain EITHER a position_long and position_short (the MWs to be traded, both need to be equal or greater than zero) OR a freely defined JSON object containing key/value pairs, but not both at once.  **Heads up** The \"source\" of a signal containing position_long and position_short will always be \"POSITION\", no matter what is defined in the request body.  * \"position_long\" indicates the surplus in MW that should or can be sold at the market (equal or greater than zero)  * \"position_short\" indicates the deficiency in MW that should or can be bought at the market (equal or greater than zero)  * \"value\" should contain the freely defined JSON object with key/value pairs. Please be aware that a signal-key for each contract is unique and data is overwritten, if sent from multiple sources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_signals_with_http_info(value, async_req=True)
        >>> result = thread.get()

        :param value: Signals payload (required)
        :type value: list[BulkSignal]
        :param ignore_lock: Setting this parameter to true allows for modification of locked signals. Unlocking a signal also requires this parameter to be true.
        :type ignore_lock: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[BulkSignalResponse], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'value',
            'ignore_lock'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_signals" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and local_var_params.get('value') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `value` when calling `update_signals`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('ignore_lock') is not None:  # noqa: E501
            query_params.append(('ignore_lock', local_var_params['ignore_lock']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'value' in local_var_params:
            body_params = local_var_params['value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[BulkSignalResponse]",
            409: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/signals', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
