# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_asyncio_client.configuration import Configuration


class Alert(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'unique_identifier': 'str',
        'severity': 'Severity',
        'tags': 'dict[str, str]',
        'message': 'str',
        'expiry_time_seconds': 'int',
        'first_occurrence_time': 'datetime',
        'last_occurrence_time': 'datetime',
        'occurrence_count': 'int',
        'resolved': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'unique_identifier': 'unique_identifier',
        'severity': 'severity',
        'tags': 'tags',
        'message': 'message',
        'expiry_time_seconds': 'expiry_time_seconds',
        'first_occurrence_time': 'first_occurrence_time',
        'last_occurrence_time': 'last_occurrence_time',
        'occurrence_count': 'occurrence_count',
        'resolved': 'resolved'
    }

    def __init__(self, id=None, unique_identifier=None, severity=None, tags=None, message=None, expiry_time_seconds=None, first_occurrence_time=None, last_occurrence_time=None, occurrence_count=None, resolved=None, local_vars_configuration=None):  # noqa: E501
        """Alert - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._unique_identifier = None
        self._severity = None
        self._tags = None
        self._message = None
        self._expiry_time_seconds = None
        self._first_occurrence_time = None
        self._last_occurrence_time = None
        self._occurrence_count = None
        self._resolved = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.unique_identifier = unique_identifier
        self.severity = severity
        if tags is not None:
            self.tags = tags
        self.message = message
        if expiry_time_seconds is not None:
            self.expiry_time_seconds = expiry_time_seconds
        if first_occurrence_time is not None:
            self.first_occurrence_time = first_occurrence_time
        if last_occurrence_time is not None:
            self.last_occurrence_time = last_occurrence_time
        if occurrence_count is not None:
            self.occurrence_count = occurrence_count
        if resolved is not None:
            self.resolved = resolved

    @property
    def id(self):
        """Gets the id of this Alert.  # noqa: E501


        :return: The id of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Alert.


        :param id: The id of this Alert.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def unique_identifier(self):
        """Gets the unique_identifier of this Alert.  # noqa: E501

        This is used to deduplicate alerts into an alert instance by  # noqa: E501

        :return: The unique_identifier of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._unique_identifier

    @unique_identifier.setter
    def unique_identifier(self, unique_identifier):
        """Sets the unique_identifier of this Alert.

        This is used to deduplicate alerts into an alert instance by  # noqa: E501

        :param unique_identifier: The unique_identifier of this Alert.  # noqa: E501
        :type unique_identifier: str
        """
        if self.local_vars_configuration.client_side_validation and unique_identifier is None:  # noqa: E501
            raise ValueError("Invalid value for `unique_identifier`, must not be `None`")  # noqa: E501

        self._unique_identifier = unique_identifier

    @property
    def severity(self):
        """Gets the severity of this Alert.  # noqa: E501


        :return: The severity of this Alert.  # noqa: E501
        :rtype: Severity
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this Alert.


        :param severity: The severity of this Alert.  # noqa: E501
        :type severity: Severity
        """
        if self.local_vars_configuration.client_side_validation and severity is None:  # noqa: E501
            raise ValueError("Invalid value for `severity`, must not be `None`")  # noqa: E501

        self._severity = severity

    @property
    def tags(self):
        """Gets the tags of this Alert.  # noqa: E501

        Label-Value Pairs to identify properties about an alert  # noqa: E501

        :return: The tags of this Alert.  # noqa: E501
        :rtype: dict[str, str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this Alert.

        Label-Value Pairs to identify properties about an alert  # noqa: E501

        :param tags: The tags of this Alert.  # noqa: E501
        :type tags: dict[str, str]
        """

        self._tags = tags

    @property
    def message(self):
        """Gets the message of this Alert.  # noqa: E501

        Message to be used to inform recipients about the alert event's context  # noqa: E501

        :return: The message of this Alert.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this Alert.

        Message to be used to inform recipients about the alert event's context  # noqa: E501

        :param message: The message of this Alert.  # noqa: E501
        :type message: str
        """
        if self.local_vars_configuration.client_side_validation and message is None:  # noqa: E501
            raise ValueError("Invalid value for `message`, must not be `None`")  # noqa: E501

        self._message = message

    @property
    def expiry_time_seconds(self):
        """Gets the expiry_time_seconds of this Alert.  # noqa: E501

        Defines after how many seconds without further occurrences the alert is automatically resolved. If further alerts happen during this period of time, they are added to the same alert instance.  The expiry time can be left empty for an alert to persist until it is manually resolved.  Alert expiry always uses the expiry time set by the last alert in the chain.   # noqa: E501

        :return: The expiry_time_seconds of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._expiry_time_seconds

    @expiry_time_seconds.setter
    def expiry_time_seconds(self, expiry_time_seconds):
        """Sets the expiry_time_seconds of this Alert.

        Defines after how many seconds without further occurrences the alert is automatically resolved. If further alerts happen during this period of time, they are added to the same alert instance.  The expiry time can be left empty for an alert to persist until it is manually resolved.  Alert expiry always uses the expiry time set by the last alert in the chain.   # noqa: E501

        :param expiry_time_seconds: The expiry_time_seconds of this Alert.  # noqa: E501
        :type expiry_time_seconds: int
        """
        if (self.local_vars_configuration.client_side_validation and
                expiry_time_seconds is not None and expiry_time_seconds > 3600):  # noqa: E501
            raise ValueError("Invalid value for `expiry_time_seconds`, must be a value less than or equal to `3600`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                expiry_time_seconds is not None and expiry_time_seconds < 10):  # noqa: E501
            raise ValueError("Invalid value for `expiry_time_seconds`, must be a value greater than or equal to `10`")  # noqa: E501

        self._expiry_time_seconds = expiry_time_seconds

    @property
    def first_occurrence_time(self):
        """Gets the first_occurrence_time of this Alert.  # noqa: E501

        The first occurrence of an alert in this alert instance  # noqa: E501

        :return: The first_occurrence_time of this Alert.  # noqa: E501
        :rtype: datetime
        """
        return self._first_occurrence_time

    @first_occurrence_time.setter
    def first_occurrence_time(self, first_occurrence_time):
        """Sets the first_occurrence_time of this Alert.

        The first occurrence of an alert in this alert instance  # noqa: E501

        :param first_occurrence_time: The first_occurrence_time of this Alert.  # noqa: E501
        :type first_occurrence_time: datetime
        """

        self._first_occurrence_time = first_occurrence_time

    @property
    def last_occurrence_time(self):
        """Gets the last_occurrence_time of this Alert.  # noqa: E501

        The last occurrence of an alert in this alert instance  # noqa: E501

        :return: The last_occurrence_time of this Alert.  # noqa: E501
        :rtype: datetime
        """
        return self._last_occurrence_time

    @last_occurrence_time.setter
    def last_occurrence_time(self, last_occurrence_time):
        """Sets the last_occurrence_time of this Alert.

        The last occurrence of an alert in this alert instance  # noqa: E501

        :param last_occurrence_time: The last_occurrence_time of this Alert.  # noqa: E501
        :type last_occurrence_time: datetime
        """

        self._last_occurrence_time = last_occurrence_time

    @property
    def occurrence_count(self):
        """Gets the occurrence_count of this Alert.  # noqa: E501

        Total count of alerts published in this instance  # noqa: E501

        :return: The occurrence_count of this Alert.  # noqa: E501
        :rtype: int
        """
        return self._occurrence_count

    @occurrence_count.setter
    def occurrence_count(self, occurrence_count):
        """Sets the occurrence_count of this Alert.

        Total count of alerts published in this instance  # noqa: E501

        :param occurrence_count: The occurrence_count of this Alert.  # noqa: E501
        :type occurrence_count: int
        """

        self._occurrence_count = occurrence_count

    @property
    def resolved(self):
        """Gets the resolved of this Alert.  # noqa: E501

        This is true when either the alert has expired or was manually resolved  # noqa: E501

        :return: The resolved of this Alert.  # noqa: E501
        :rtype: bool
        """
        return self._resolved

    @resolved.setter
    def resolved(self, resolved):
        """Sets the resolved of this Alert.

        This is true when either the alert has expired or was manually resolved  # noqa: E501

        :param resolved: The resolved of this Alert.  # noqa: E501
        :type resolved: bool
        """

        self._resolved = resolved

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Alert):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Alert):
            return True

        return self.to_dict() != other.to_dict()
