# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_asyncio_client.configuration import Configuration


class AlertNotificationPolicy(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'active': 'bool',
        'name': 'str',
        'description': 'str',
        'min_severity': 'Severity',
        'match_tags': 'list[TagMatcher]',
        'delay_before_send_seconds': 'int',
        'notification_targets': 'NotificationTarget'
    }

    attribute_map = {
        'id': 'id',
        'active': 'active',
        'name': 'name',
        'description': 'description',
        'min_severity': 'min_severity',
        'match_tags': 'match_tags',
        'delay_before_send_seconds': 'delay_before_send_seconds',
        'notification_targets': 'notification_targets'
    }

    def __init__(self, id=None, active=True, name=None, description=None, min_severity=None, match_tags=None, delay_before_send_seconds=None, notification_targets=None, local_vars_configuration=None):  # noqa: E501
        """AlertNotificationPolicy - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._active = None
        self._name = None
        self._description = None
        self._min_severity = None
        self._match_tags = None
        self._delay_before_send_seconds = None
        self._notification_targets = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.active = active
        self.name = name
        if description is not None:
            self.description = description
        if min_severity is not None:
            self.min_severity = min_severity
        if match_tags is not None:
            self.match_tags = match_tags
        self.delay_before_send_seconds = delay_before_send_seconds
        self.notification_targets = notification_targets

    @property
    def id(self):
        """Gets the id of this AlertNotificationPolicy.  # noqa: E501


        :return: The id of this AlertNotificationPolicy.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AlertNotificationPolicy.


        :param id: The id of this AlertNotificationPolicy.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def active(self):
        """Gets the active of this AlertNotificationPolicy.  # noqa: E501

        If active is set to false, this notification policy will not be used to deliver alerts  # noqa: E501

        :return: The active of this AlertNotificationPolicy.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this AlertNotificationPolicy.

        If active is set to false, this notification policy will not be used to deliver alerts  # noqa: E501

        :param active: The active of this AlertNotificationPolicy.  # noqa: E501
        :type active: bool
        """
        if self.local_vars_configuration.client_side_validation and active is None:  # noqa: E501
            raise ValueError("Invalid value for `active`, must not be `None`")  # noqa: E501

        self._active = active

    @property
    def name(self):
        """Gets the name of this AlertNotificationPolicy.  # noqa: E501


        :return: The name of this AlertNotificationPolicy.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AlertNotificationPolicy.


        :param name: The name of this AlertNotificationPolicy.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this AlertNotificationPolicy.  # noqa: E501


        :return: The description of this AlertNotificationPolicy.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AlertNotificationPolicy.


        :param description: The description of this AlertNotificationPolicy.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def min_severity(self):
        """Gets the min_severity of this AlertNotificationPolicy.  # noqa: E501


        :return: The min_severity of this AlertNotificationPolicy.  # noqa: E501
        :rtype: Severity
        """
        return self._min_severity

    @min_severity.setter
    def min_severity(self, min_severity):
        """Sets the min_severity of this AlertNotificationPolicy.


        :param min_severity: The min_severity of this AlertNotificationPolicy.  # noqa: E501
        :type min_severity: Severity
        """

        self._min_severity = min_severity

    @property
    def match_tags(self):
        """Gets the match_tags of this AlertNotificationPolicy.  # noqa: E501

        Can be used to filter for specific tags of alerts. The tags specified all have to be included in the alert instances if `EQUAL` is used. If `NOT_EQUAL` none of the tags specified can be present in alerts to match this rule.   # noqa: E501

        :return: The match_tags of this AlertNotificationPolicy.  # noqa: E501
        :rtype: list[TagMatcher]
        """
        return self._match_tags

    @match_tags.setter
    def match_tags(self, match_tags):
        """Sets the match_tags of this AlertNotificationPolicy.

        Can be used to filter for specific tags of alerts. The tags specified all have to be included in the alert instances if `EQUAL` is used. If `NOT_EQUAL` none of the tags specified can be present in alerts to match this rule.   # noqa: E501

        :param match_tags: The match_tags of this AlertNotificationPolicy.  # noqa: E501
        :type match_tags: list[TagMatcher]
        """

        self._match_tags = match_tags

    @property
    def delay_before_send_seconds(self):
        """Gets the delay_before_send_seconds of this AlertNotificationPolicy.  # noqa: E501

        Defines for how long an alert has to be active before it is published to recipients of this policy  # noqa: E501

        :return: The delay_before_send_seconds of this AlertNotificationPolicy.  # noqa: E501
        :rtype: int
        """
        return self._delay_before_send_seconds

    @delay_before_send_seconds.setter
    def delay_before_send_seconds(self, delay_before_send_seconds):
        """Sets the delay_before_send_seconds of this AlertNotificationPolicy.

        Defines for how long an alert has to be active before it is published to recipients of this policy  # noqa: E501

        :param delay_before_send_seconds: The delay_before_send_seconds of this AlertNotificationPolicy.  # noqa: E501
        :type delay_before_send_seconds: int
        """
        if self.local_vars_configuration.client_side_validation and delay_before_send_seconds is None:  # noqa: E501
            raise ValueError("Invalid value for `delay_before_send_seconds`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                delay_before_send_seconds is not None and delay_before_send_seconds < 60):  # noqa: E501
            raise ValueError("Invalid value for `delay_before_send_seconds`, must be a value greater than or equal to `60`")  # noqa: E501

        self._delay_before_send_seconds = delay_before_send_seconds

    @property
    def notification_targets(self):
        """Gets the notification_targets of this AlertNotificationPolicy.  # noqa: E501


        :return: The notification_targets of this AlertNotificationPolicy.  # noqa: E501
        :rtype: NotificationTarget
        """
        return self._notification_targets

    @notification_targets.setter
    def notification_targets(self, notification_targets):
        """Sets the notification_targets of this AlertNotificationPolicy.


        :param notification_targets: The notification_targets of this AlertNotificationPolicy.  # noqa: E501
        :type notification_targets: NotificationTarget
        """
        if self.local_vars_configuration.client_side_validation and notification_targets is None:  # noqa: E501
            raise ValueError("Invalid value for `notification_targets`, must not be `None`")  # noqa: E501

        self._notification_targets = notification_targets

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AlertNotificationPolicy):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AlertNotificationPolicy):
            return True

        return self.to_dict() != other.to_dict()
