# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_asyncio_client.configuration import Configuration


class AuctionTrade(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'auction_id': 'str',
        'contract_id': 'str',
        'portfolio_id': 'str',
        'delivery_start': 'datetime',
        'delivery_end': 'datetime',
        'last_updated': 'datetime',
        'order_id': 'str',
        'delivery_area': 'str',
        'price': 'float',
        'currency': 'str',
        'quantity': 'float',
        'state': 'AuctionTradeState',
        'user_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'auction_id': 'auction_id',
        'contract_id': 'contract_id',
        'portfolio_id': 'portfolio_id',
        'delivery_start': 'delivery_start',
        'delivery_end': 'delivery_end',
        'last_updated': 'last_updated',
        'order_id': 'order_id',
        'delivery_area': 'delivery_area',
        'price': 'price',
        'currency': 'currency',
        'quantity': 'quantity',
        'state': 'state',
        'user_id': 'user_id'
    }

    def __init__(self, id=None, auction_id=None, contract_id=None, portfolio_id=None, delivery_start=None, delivery_end=None, last_updated=None, order_id=None, delivery_area=None, price=None, currency=None, quantity=None, state=None, user_id=None, local_vars_configuration=None):  # noqa: E501
        """AuctionTrade - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._auction_id = None
        self._contract_id = None
        self._portfolio_id = None
        self._delivery_start = None
        self._delivery_end = None
        self._last_updated = None
        self._order_id = None
        self._delivery_area = None
        self._price = None
        self._currency = None
        self._quantity = None
        self._state = None
        self._user_id = None
        self.discriminator = None

        self.id = id
        self.auction_id = auction_id
        self.contract_id = contract_id
        if portfolio_id is not None:
            self.portfolio_id = portfolio_id
        if delivery_start is not None:
            self.delivery_start = delivery_start
        if delivery_end is not None:
            self.delivery_end = delivery_end
        if last_updated is not None:
            self.last_updated = last_updated
        self.order_id = order_id
        self.delivery_area = delivery_area
        self.price = price
        if currency is not None:
            self.currency = currency
        self.quantity = quantity
        self.state = state
        self.user_id = user_id

    @property
    def id(self):
        """Gets the id of this AuctionTrade.  # noqa: E501

        The ID of the trade, provided by the exchange.  # noqa: E501

        :return: The id of this AuctionTrade.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AuctionTrade.

        The ID of the trade, provided by the exchange.  # noqa: E501

        :param id: The id of this AuctionTrade.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def auction_id(self):
        """Gets the auction_id of this AuctionTrade.  # noqa: E501

        The ID of the auction the trade belongs to.  # noqa: E501

        :return: The auction_id of this AuctionTrade.  # noqa: E501
        :rtype: str
        """
        return self._auction_id

    @auction_id.setter
    def auction_id(self, auction_id):
        """Sets the auction_id of this AuctionTrade.

        The ID of the auction the trade belongs to.  # noqa: E501

        :param auction_id: The auction_id of this AuctionTrade.  # noqa: E501
        :type auction_id: str
        """
        if self.local_vars_configuration.client_side_validation and auction_id is None:  # noqa: E501
            raise ValueError("Invalid value for `auction_id`, must not be `None`")  # noqa: E501

        self._auction_id = auction_id

    @property
    def contract_id(self):
        """Gets the contract_id of this AuctionTrade.  # noqa: E501

        The ID of the contract the trade belongs to.  # noqa: E501

        :return: The contract_id of this AuctionTrade.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this AuctionTrade.

        The ID of the contract the trade belongs to.  # noqa: E501

        :param contract_id: The contract_id of this AuctionTrade.  # noqa: E501
        :type contract_id: str
        """
        if self.local_vars_configuration.client_side_validation and contract_id is None:  # noqa: E501
            raise ValueError("Invalid value for `contract_id`, must not be `None`")  # noqa: E501

        self._contract_id = contract_id

    @property
    def portfolio_id(self):
        """Gets the portfolio_id of this AuctionTrade.  # noqa: E501

        The portfolio ID of the trade.  # noqa: E501

        :return: The portfolio_id of this AuctionTrade.  # noqa: E501
        :rtype: str
        """
        return self._portfolio_id

    @portfolio_id.setter
    def portfolio_id(self, portfolio_id):
        """Sets the portfolio_id of this AuctionTrade.

        The portfolio ID of the trade.  # noqa: E501

        :param portfolio_id: The portfolio_id of this AuctionTrade.  # noqa: E501
        :type portfolio_id: str
        """

        self._portfolio_id = portfolio_id

    @property
    def delivery_start(self):
        """Gets the delivery_start of this AuctionTrade.  # noqa: E501

        The delivery start of the trade.  # noqa: E501

        :return: The delivery_start of this AuctionTrade.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_start

    @delivery_start.setter
    def delivery_start(self, delivery_start):
        """Sets the delivery_start of this AuctionTrade.

        The delivery start of the trade.  # noqa: E501

        :param delivery_start: The delivery_start of this AuctionTrade.  # noqa: E501
        :type delivery_start: datetime
        """

        self._delivery_start = delivery_start

    @property
    def delivery_end(self):
        """Gets the delivery_end of this AuctionTrade.  # noqa: E501

        The delivery end of the trade.  # noqa: E501

        :return: The delivery_end of this AuctionTrade.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_end

    @delivery_end.setter
    def delivery_end(self, delivery_end):
        """Sets the delivery_end of this AuctionTrade.

        The delivery end of the trade.  # noqa: E501

        :param delivery_end: The delivery_end of this AuctionTrade.  # noqa: E501
        :type delivery_end: datetime
        """

        self._delivery_end = delivery_end

    @property
    def last_updated(self):
        """Gets the last_updated of this AuctionTrade.  # noqa: E501

        The timestamp of the last update of the trade.  # noqa: E501

        :return: The last_updated of this AuctionTrade.  # noqa: E501
        :rtype: datetime
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """Sets the last_updated of this AuctionTrade.

        The timestamp of the last update of the trade.  # noqa: E501

        :param last_updated: The last_updated of this AuctionTrade.  # noqa: E501
        :type last_updated: datetime
        """

        self._last_updated = last_updated

    @property
    def order_id(self):
        """Gets the order_id of this AuctionTrade.  # noqa: E501

        The ID of the order the trade belongs to.  # noqa: E501

        :return: The order_id of this AuctionTrade.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this AuctionTrade.

        The ID of the order the trade belongs to.  # noqa: E501

        :param order_id: The order_id of this AuctionTrade.  # noqa: E501
        :type order_id: str
        """
        if self.local_vars_configuration.client_side_validation and order_id is None:  # noqa: E501
            raise ValueError("Invalid value for `order_id`, must not be `None`")  # noqa: E501

        self._order_id = order_id

    @property
    def delivery_area(self):
        """Gets the delivery_area of this AuctionTrade.  # noqa: E501

        The delivery area of the trade.  # noqa: E501

        :return: The delivery_area of this AuctionTrade.  # noqa: E501
        :rtype: str
        """
        return self._delivery_area

    @delivery_area.setter
    def delivery_area(self, delivery_area):
        """Sets the delivery_area of this AuctionTrade.

        The delivery area of the trade.  # noqa: E501

        :param delivery_area: The delivery_area of this AuctionTrade.  # noqa: E501
        :type delivery_area: str
        """
        if self.local_vars_configuration.client_side_validation and delivery_area is None:  # noqa: E501
            raise ValueError("Invalid value for `delivery_area`, must not be `None`")  # noqa: E501

        self._delivery_area = delivery_area

    @property
    def price(self):
        """Gets the price of this AuctionTrade.  # noqa: E501

        The price of the trade.  # noqa: E501

        :return: The price of this AuctionTrade.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this AuctionTrade.

        The price of the trade.  # noqa: E501

        :param price: The price of this AuctionTrade.  # noqa: E501
        :type price: float
        """
        if self.local_vars_configuration.client_side_validation and price is None:  # noqa: E501
            raise ValueError("Invalid value for `price`, must not be `None`")  # noqa: E501

        self._price = price

    @property
    def currency(self):
        """Gets the currency of this AuctionTrade.  # noqa: E501


        :return: The currency of this AuctionTrade.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this AuctionTrade.


        :param currency: The currency of this AuctionTrade.  # noqa: E501
        :type currency: str
        """

        self._currency = currency

    @property
    def quantity(self):
        """Gets the quantity of this AuctionTrade.  # noqa: E501

        The quantity of the trade.  # noqa: E501

        :return: The quantity of this AuctionTrade.  # noqa: E501
        :rtype: float
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this AuctionTrade.

        The quantity of the trade.  # noqa: E501

        :param quantity: The quantity of this AuctionTrade.  # noqa: E501
        :type quantity: float
        """
        if self.local_vars_configuration.client_side_validation and quantity is None:  # noqa: E501
            raise ValueError("Invalid value for `quantity`, must not be `None`")  # noqa: E501

        self._quantity = quantity

    @property
    def state(self):
        """Gets the state of this AuctionTrade.  # noqa: E501


        :return: The state of this AuctionTrade.  # noqa: E501
        :rtype: AuctionTradeState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this AuctionTrade.


        :param state: The state of this AuctionTrade.  # noqa: E501
        :type state: AuctionTradeState
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def user_id(self):
        """Gets the user_id of this AuctionTrade.  # noqa: E501

        The exchange user that was used to place the order  # noqa: E501

        :return: The user_id of this AuctionTrade.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this AuctionTrade.

        The exchange user that was used to place the order  # noqa: E501

        :param user_id: The user_id of this AuctionTrade.  # noqa: E501
        :type user_id: str
        """
        if self.local_vars_configuration.client_side_validation and user_id is None:  # noqa: E501
            raise ValueError("Invalid value for `user_id`, must not be `None`")  # noqa: E501

        self._user_id = user_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuctionTrade):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AuctionTrade):
            return True

        return self.to_dict() != other.to_dict()
