# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool, TGE, OPCOM or ETPA. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance      | Base URL for REST Endpoints                                      | |---------------|------------------------------------------------------------------| | EPEX          | https://staging.powerbot-trading.com/playground/epex/v2/api      | | Nord Pool     | https://staging.powerbot-trading.com/playground/nordpool/v2/api  | | HUPX          | https://staging.powerbot-trading.com/playground/hupx/v2/api      | | BSP Southpool | https://staging.powerbot-trading.com/playground/southpool/v2/api | | TGE           | https://staging.powerbot-trading.com/playground/tge/v2/api       | | IBEX          | https://staging.powerbot-trading.com/playground/ibex/v2/api      | | CROPEX        | https://staging.powerbot-trading.com/playground/cropex/v2/api    | | OPCOM         | https://staging.powerbot-trading.com/playground/opcom/v2/api     | | ETPA          | https://staging.powerbot-trading.com/playground/etpa/v2/api      | | BRM           | https://staging.powerbot-trading.com/playground/brm/v2/api       |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at in our [knowledge base](https://docs.powerbot-trading.com/docs/programmatic-access/)  # noqa: E501

    The version of the OpenAPI document: 2.18.0-rc1
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_asyncio_client.configuration import Configuration


class Orders(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'contract_id': 'str',
        'product': 'str',
        'delivery_area': 'str',
        'sequence_number': 'int',
        'revision_no': 'int',
        'delta': 'bool',
        'bid': 'list[OrderBookEntry]',
        'ask': 'list[OrderBookEntry]'
    }

    attribute_map = {
        'contract_id': 'contract_id',
        'product': 'product',
        'delivery_area': 'delivery_area',
        'sequence_number': 'sequence_number',
        'revision_no': 'revision_no',
        'delta': 'delta',
        'bid': 'bid',
        'ask': 'ask'
    }

    def __init__(self, contract_id=None, product=None, delivery_area=None, sequence_number=None, revision_no=None, delta=None, bid=None, ask=None, local_vars_configuration=None):  # noqa: E501
        """Orders - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._contract_id = None
        self._product = None
        self._delivery_area = None
        self._sequence_number = None
        self._revision_no = None
        self._delta = None
        self._bid = None
        self._ask = None
        self.discriminator = None

        if contract_id is not None:
            self.contract_id = contract_id
        if product is not None:
            self.product = product
        if delivery_area is not None:
            self.delivery_area = delivery_area
        if sequence_number is not None:
            self.sequence_number = sequence_number
        if revision_no is not None:
            self.revision_no = revision_no
        if delta is not None:
            self.delta = delta
        if bid is not None:
            self.bid = bid
        if ask is not None:
            self.ask = ask

    @property
    def contract_id(self):
        """Gets the contract_id of this Orders.  # noqa: E501


        :return: The contract_id of this Orders.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this Orders.


        :param contract_id: The contract_id of this Orders.  # noqa: E501
        :type contract_id: str
        """

        self._contract_id = contract_id

    @property
    def product(self):
        """Gets the product of this Orders.  # noqa: E501

        the contract's product  # noqa: E501

        :return: The product of this Orders.  # noqa: E501
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this Orders.

        the contract's product  # noqa: E501

        :param product: The product of this Orders.  # noqa: E501
        :type product: str
        """

        self._product = product

    @property
    def delivery_area(self):
        """Gets the delivery_area of this Orders.  # noqa: E501


        :return: The delivery_area of this Orders.  # noqa: E501
        :rtype: str
        """
        return self._delivery_area

    @delivery_area.setter
    def delivery_area(self, delivery_area):
        """Sets the delivery_area of this Orders.


        :param delivery_area: The delivery_area of this Orders.  # noqa: E501
        :type delivery_area: str
        """

        self._delivery_area = delivery_area

    @property
    def sequence_number(self):
        """Gets the sequence_number of this Orders.  # noqa: E501

        DEPRECATED: use revision_no instead  # noqa: E501

        :return: The sequence_number of this Orders.  # noqa: E501
        :rtype: int
        """
        return self._sequence_number

    @sequence_number.setter
    def sequence_number(self, sequence_number):
        """Sets the sequence_number of this Orders.

        DEPRECATED: use revision_no instead  # noqa: E501

        :param sequence_number: The sequence_number of this Orders.  # noqa: E501
        :type sequence_number: int
        """

        self._sequence_number = sequence_number

    @property
    def revision_no(self):
        """Gets the revision_no of this Orders.  # noqa: E501


        :return: The revision_no of this Orders.  # noqa: E501
        :rtype: int
        """
        return self._revision_no

    @revision_no.setter
    def revision_no(self, revision_no):
        """Sets the revision_no of this Orders.


        :param revision_no: The revision_no of this Orders.  # noqa: E501
        :type revision_no: int
        """

        self._revision_no = revision_no

    @property
    def delta(self):
        """Gets the delta of this Orders.  # noqa: E501

        if true, the underlying bid / asks need to be interpreted as delta to the previous revision, if false the bids/ask represent a current snapshot.  # noqa: E501

        :return: The delta of this Orders.  # noqa: E501
        :rtype: bool
        """
        return self._delta

    @delta.setter
    def delta(self, delta):
        """Sets the delta of this Orders.

        if true, the underlying bid / asks need to be interpreted as delta to the previous revision, if false the bids/ask represent a current snapshot.  # noqa: E501

        :param delta: The delta of this Orders.  # noqa: E501
        :type delta: bool
        """

        self._delta = delta

    @property
    def bid(self):
        """Gets the bid of this Orders.  # noqa: E501


        :return: The bid of this Orders.  # noqa: E501
        :rtype: list[OrderBookEntry]
        """
        return self._bid

    @bid.setter
    def bid(self, bid):
        """Sets the bid of this Orders.


        :param bid: The bid of this Orders.  # noqa: E501
        :type bid: list[OrderBookEntry]
        """

        self._bid = bid

    @property
    def ask(self):
        """Gets the ask of this Orders.  # noqa: E501


        :return: The ask of this Orders.  # noqa: E501
        :rtype: list[OrderBookEntry]
        """
        return self._ask

    @ask.setter
    def ask(self, ask):
        """Sets the ask of this Orders.


        :param ask: The ask of this Orders.  # noqa: E501
        :type ask: list[OrderBookEntry]
        """

        self._ask = ask

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Orders):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Orders):
            return True

        return self.to_dict() != other.to_dict()
