"""
Action enums.
"""

# pylint: disable=too-many-public-methods, unused-import

import typing as t
import typing_extensions as te  # noqa: F401
import typing_extensions as te
from composio.client.enums.base import ACTIONS_CACHE, ActionData, _AnnotatedEnum, enum

@enum
class Action(_AnnotatedEnum[ActionData], path=ACTIONS_CACHE):
    """Class to represent `Action` entity."""
    AFFINITY_GET_ALL_COMPANIES: 'Action'
    AFFINITY_GET_ALL_LIST_ENTRIES_ON_A_LIST: 'Action'
    AFFINITY_GET_ALL_LIST_ENTRIES_ON_A_SAVED_VIEW: 'Action'
    AFFINITY_GET_ALL_OPPORTUNITIES: 'Action'
    AFFINITY_GET_ALL_PERSONS: 'Action'
    AFFINITY_GET_A_COMPANY_S_LISTS: 'Action'
    AFFINITY_GET_A_COMPANY_S_LIST_ENTRIES: 'Action'
    AFFINITY_GET_A_PERSON_S_LISTS: 'Action'
    AFFINITY_GET_A_PERSON_S_LIST_ENTRIES: 'Action'
    AFFINITY_GET_A_SINGLE_COMPANY: 'Action'
    AFFINITY_GET_A_SINGLE_OPPORTUNITY: 'Action'
    AFFINITY_GET_A_SINGLE_PERSON: 'Action'
    AFFINITY_GET_CURRENT_USER: 'Action'
    AFFINITY_GET_METADATA_ON_ALL_LISTS: 'Action'
    AFFINITY_GET_METADATA_ON_A_SINGLE_LIST: 'Action'
    AFFINITY_GET_METADATA_ON_A_SINGLE_LIST_S_FIELDS: 'Action'
    AFFINITY_GET_METADATA_ON_A_SINGLE_SAVED_VIEW: 'Action'
    AFFINITY_GET_METADATA_ON_COMPANY_FIELDS: 'Action'
    AFFINITY_GET_METADATA_ON_PERSON_FIELDS: 'Action'
    AFFINITY_GET_METADATA_ON_SAVED_VIEWS: 'Action'
    AGENCYZOOM_AUTHENTICATE_FOR_JWTVIA_V4_SSO: 'Action'
    AGENCYZOOM_BATCH_CREATE_CONTACT: 'Action'
    AGENCYZOOM_BATCH_CREATE_LEAD: 'Action'
    AGENCYZOOM_BATCH_DELETE_TASK: 'Action'
    AGENCYZOOM_CHANGE_STATUS_FOR_LEAD: 'Action'
    AGENCYZOOM_COMPLETE_TASK: 'Action'
    AGENCYZOOM_CREATE_AN_OPPORTUNITY: 'Action'
    AGENCYZOOM_CREATE_A_CUSTOMER_NOTE: 'Action'
    AGENCYZOOM_CREATE_A_DRIVER_FOR_AN_OPPORTUNITY: 'Action'
    AGENCYZOOM_CREATE_A_LEAD_NOTE: 'Action'
    AGENCYZOOM_CREATE_A_LEAD_OPPORTUNITY: 'Action'
    AGENCYZOOM_CREATE_A_LEAD_QUOTE: 'Action'
    AGENCYZOOM_CREATE_A_VEHICLE_FOR_AN_OPPORTUNITY: 'Action'
    AGENCYZOOM_CREATE_BIZ_LEAD: 'Action'
    AGENCYZOOM_CREATE_LEAD: 'Action'
    AGENCYZOOM_CREATE_TASK: 'Action'
    AGENCYZOOM_DELETE_AN_OPPORTUNITY: 'Action'
    AGENCYZOOM_DELETE_A_CUSTOMER: 'Action'
    AGENCYZOOM_DELETE_A_CUSTOMER_FILE: 'Action'
    AGENCYZOOM_DELETE_A_CUSTOMER_POLICY: 'Action'
    AGENCYZOOM_DELETE_A_DRIVER: 'Action'
    AGENCYZOOM_DELETE_A_LEAD_FILE: 'Action'
    AGENCYZOOM_DELETE_A_LEAD_OPPORTUNITY: 'Action'
    AGENCYZOOM_DELETE_A_LEAD_QUOTE: 'Action'
    AGENCYZOOM_DELETE_A_TASK: 'Action'
    AGENCYZOOM_DELETE_A_VEHICLE: 'Action'
    AGENCYZOOM_DELETE_MESSAGE: 'Action'
    AGENCYZOOM_DELETE_THREAD: 'Action'
    AGENCYZOOM_GET_AMS_POLICIES_FOR_A_CUSTOMER: 'Action'
    AGENCYZOOM_GET_AUTH_URL_FOR_V4SSO: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_ASSIGN_GROUPS: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_CARRIERS: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_CSRS: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_CUSTOM_FIELDS: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_DRIVERS_FOR_AN_OPPORTUNITY: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_EMPLOYEES: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_LEAD_SOURCES: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_LEAD_SOURCE_CATEGORIES: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_LIFE_PROFESSIONALS: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_LOCATIONS: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_LOSS_REASONS: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_PIPELINES: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_PRODUCER: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_PRODUCT_CATEGORIES_POLICY_CATEGORIES: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_PRODUCT_LINES_POLICY_TYPES: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_RECYCLE_EVENTS: 'Action'
    AGENCYZOOM_GET_A_LIST_OF_VEHICLES_FOR_AN_OPPORTUNITY: 'Action'
    AGENCYZOOM_GET_DEPARTMENTS_GROUPS: 'Action'
    AGENCYZOOM_GET_LEAD_FILES: 'Action'
    AGENCYZOOM_GET_LEAD_NOTES: 'Action'
    AGENCYZOOM_GET_LEAD_QUOTES: 'Action'
    AGENCYZOOM_GET_LEAD_TASKS: 'Action'
    AGENCYZOOM_GET_LIST_OF_END_STAGES: 'Action'
    AGENCYZOOM_GET_POLICIES_FOR_A_CUSTOMER: 'Action'
    AGENCYZOOM_GET_THE_CUSTOMER_DETAILS: 'Action'
    AGENCYZOOM_GET_THE_CUSTOMER_TASKS: 'Action'
    AGENCYZOOM_GET_THE_DRIVER_DETAILS: 'Action'
    AGENCYZOOM_GET_THE_LEAD_DETAILS: 'Action'
    AGENCYZOOM_GET_THE_OPPORTUNITIES_FOR_A_LEAD: 'Action'
    AGENCYZOOM_GET_THE_OPPORTUNITY_DETAILS: 'Action'
    AGENCYZOOM_GET_THE_TASK_DETAILS: 'Action'
    AGENCYZOOM_GET_THE_VEHICLE_DETAILS: 'Action'
    AGENCYZOOM_GET_THREAD_DETAILS: 'Action'
    AGENCYZOOM_LINK_A_DRIVER_TO_OPPORTUNITY: 'Action'
    AGENCYZOOM_LINK_A_VEHICLE_TO_OPPORTUNITY: 'Action'
    AGENCYZOOM_LOG_THE_USER_IN: 'Action'
    AGENCYZOOM_LOG_THE_USER_OUT: 'Action'
    AGENCYZOOM_MARK_THREAD_AS_UNREAD_API_ENDPOINT: 'Action'
    AGENCYZOOM_MOVE_LEAD_TO_SOLD: 'Action'
    AGENCYZOOM_REMOVE_TEXT_THREAD_ENDPOINT: 'Action'
    AGENCYZOOM_REOPEN_A_TASK: 'Action'
    AGENCYZOOM_SEARCH_BUSINESS_CLASSIFICATIONS: 'Action'
    AGENCYZOOM_SEARCH_CUSTOMERS: 'Action'
    AGENCYZOOM_SEARCH_EMAIL_THREADS: 'Action'
    AGENCYZOOM_SEARCH_LEADS: 'Action'
    AGENCYZOOM_SEARCH_LEADS_COUNT: 'Action'
    AGENCYZOOM_SEARCH_LIFE_AND_HEALTH_LEADS: 'Action'
    AGENCYZOOM_SEARCH_SMS_THREADS: 'Action'
    AGENCYZOOM_SEARCH_TASKS: 'Action'
    AGENCYZOOM_SERVICE_TICKET_LIST: 'Action'
    AGENCYZOOM_TEXT_DETAIL_THREAD: 'Action'
    AGENCYZOOM_UNLINK_A_DRIVER_FROM_OPPORTUNITY: 'Action'
    AGENCYZOOM_UNLINK_A_VEHICLE_FROM_OPPORTUNITY: 'Action'
    AGENCYZOOM_UNREAD_THREAD: 'Action'
    AGENCYZOOM_UPDATE_AN_OPPORTUNITY: 'Action'
    AGENCYZOOM_UPDATE_A_DRIVER_S_DETAILS: 'Action'
    AGENCYZOOM_UPDATE_A_LEAD_FILE_NAME: 'Action'
    AGENCYZOOM_UPDATE_A_LEAD_OPPORTUNITY: 'Action'
    AGENCYZOOM_UPDATE_A_LEAD_QUOTE: 'Action'
    AGENCYZOOM_UPDATE_A_POLICY: 'Action'
    AGENCYZOOM_UPDATE_A_VEHICLE_S_DETAILS: 'Action'
    AGENCYZOOM_UPDATE_BUSINESS_LEAD: 'Action'
    AGENCYZOOM_UPDATE_CUSTOMER: 'Action'
    AGENCYZOOM_UPDATE_LEAD: 'Action'
    AGENCYZOOM_UPDATE_LEAD_STATUS_BY_ID: 'Action'
    AGENCYZOOM_UPDATE_MY_PROFILE: 'Action'
    AGENCYZOOM_UPDATE_TAGS_FOR_A_POLICY: 'Action'
    AGENCYZOOM_UPDATE_TASK: 'Action'
    AGENCYZOOM_V4_SSO_LOG_THE_USER_IN: 'Action'
    AIRTABLE_CREATE_BASE: 'Action'
    AIRTABLE_CREATE_COMMENT: 'Action'
    AIRTABLE_CREATE_FIELD: 'Action'
    AIRTABLE_CREATE_MULTIPLE_RECORDS: 'Action'
    AIRTABLE_CREATE_RECORD: 'Action'
    AIRTABLE_CREATE_TABLE: 'Action'
    AIRTABLE_DELETE_COMMENT: 'Action'
    AIRTABLE_DELETE_MULTIPLE_RECORDS: 'Action'
    AIRTABLE_DELETE_RECORD: 'Action'
    AIRTABLE_GET_BASE_SCHEMA: 'Action'
    AIRTABLE_GET_RECORD: 'Action'
    AIRTABLE_GET_USER_INFO: 'Action'
    AIRTABLE_LIST_BASES: 'Action'
    AIRTABLE_LIST_COMMENTS: 'Action'
    AIRTABLE_LIST_RECORDS: 'Action'
    AIRTABLE_UPDATE_MULTIPLE_RECORDS: 'Action'
    AIRTABLE_UPDATE_RECORD: 'Action'
    ASANA_ADD_A_COLLABORATOR_TO_A_GOAL: 'Action'
    ASANA_ADD_A_CUSTOM_FIELD_TO_A_PORTFOLIO: 'Action'
    ASANA_ADD_A_CUSTOM_FIELD_TO_A_PROJECT: 'Action'
    ASANA_ADD_A_PORTFOLIO_ITEM: 'Action'
    ASANA_ADD_A_PROJECT_TO_A_TASK: 'Action'
    ASANA_ADD_A_SUPPORTING_GOAL_RELATIONSHIP: 'Action'
    ASANA_ADD_A_TAG_TO_A_TASK: 'Action'
    ASANA_ADD_A_USER_TO_A_TEAM: 'Action'
    ASANA_ADD_A_USER_TO_A_WORKSPACE_OR_ORGANIZATION: 'Action'
    ASANA_ADD_FOLLOWERS_TO_A_PROJECT: 'Action'
    ASANA_ADD_FOLLOWERS_TO_A_TASK: 'Action'
    ASANA_ADD_TASK_TO_SECTION: 'Action'
    ASANA_ADD_USERS_TO_A_PORTFOLIO: 'Action'
    ASANA_ADD_USERS_TO_A_PROJECT: 'Action'
    ASANA_CREATE_AN_ALLOCATION: 'Action'
    ASANA_CREATE_AN_ENUM_OPTION: 'Action'
    ASANA_CREATE_AN_ORGANIZATION_EXPORT_REQUEST: 'Action'
    ASANA_CREATE_A_CUSTOM_FIELD: 'Action'
    ASANA_CREATE_A_GOAL: 'Action'
    ASANA_CREATE_A_GOAL_METRIC: 'Action'
    ASANA_CREATE_A_MEMBERSHIP: 'Action'
    ASANA_CREATE_A_PORTFOLIO: 'Action'
    ASANA_CREATE_A_PROJECT: 'Action'
    ASANA_CREATE_A_PROJECT_BRIEF: 'Action'
    ASANA_CREATE_A_PROJECT_IN_A_TEAM: 'Action'
    ASANA_CREATE_A_PROJECT_IN_A_WORKSPACE: 'Action'
    ASANA_CREATE_A_PROJECT_STATUS: 'Action'
    ASANA_CREATE_A_PROJECT_TEMPLATE_FROM_A_PROJECT: 'Action'
    ASANA_CREATE_A_SECTION_IN_A_PROJECT: 'Action'
    ASANA_CREATE_A_STATUS_UPDATE: 'Action'
    ASANA_CREATE_A_STORY_ON_A_TASK: 'Action'
    ASANA_CREATE_A_SUBTASK: 'Action'
    ASANA_CREATE_A_TAG: 'Action'
    ASANA_CREATE_A_TAG_IN_A_WORKSPACE: 'Action'
    ASANA_CREATE_A_TASK: 'Action'
    ASANA_CREATE_A_TEAM: 'Action'
    ASANA_CREATE_A_TIME_TRACKING_ENTRY: 'Action'
    ASANA_DELETE_AN_ALLOCATION: 'Action'
    ASANA_DELETE_AN_ATTACHMENT: 'Action'
    ASANA_DELETE_A_CUSTOM_FIELD: 'Action'
    ASANA_DELETE_A_GOAL: 'Action'
    ASANA_DELETE_A_MEMBERSHIP: 'Action'
    ASANA_DELETE_A_PORTFOLIO: 'Action'
    ASANA_DELETE_A_PROJECT: 'Action'
    ASANA_DELETE_A_PROJECT_BRIEF: 'Action'
    ASANA_DELETE_A_PROJECT_STATUS: 'Action'
    ASANA_DELETE_A_PROJECT_TEMPLATE: 'Action'
    ASANA_DELETE_A_SECTION: 'Action'
    ASANA_DELETE_A_STATUS_UPDATE: 'Action'
    ASANA_DELETE_A_STORY: 'Action'
    ASANA_DELETE_A_TAG: 'Action'
    ASANA_DELETE_A_TASK: 'Action'
    ASANA_DELETE_A_TASK_TEMPLATE: 'Action'
    ASANA_DELETE_A_TIME_TRACKING_ENTRY: 'Action'
    ASANA_DELETE_A_WEBHOOK: 'Action'
    ASANA_DUPLICATE_A_PROJECT: 'Action'
    ASANA_DUPLICATE_A_TASK: 'Action'
    ASANA_ESTABLISH_A_WEBHOOK: 'Action'
    ASANA_GET_ALL_PROJECTS_IN_A_WORKSPACE: 'Action'
    ASANA_GET_AN_ALLOCATION: 'Action'
    ASANA_GET_AN_ATTACHMENT: 'Action'
    ASANA_GET_ATTACHMENTS_FROM_AN_OBJECT: 'Action'
    ASANA_GET_AUDIT_LOG_EVENTS: 'Action'
    ASANA_GET_A_CUSTOM_FIELD: 'Action'
    ASANA_GET_A_GOAL: 'Action'
    ASANA_GET_A_GOAL_RELATIONSHIP: 'Action'
    ASANA_GET_A_JOB_BY_ID: 'Action'
    ASANA_GET_A_MEMBERSHIP: 'Action'
    ASANA_GET_A_PORTFOLIO: 'Action'
    ASANA_GET_A_PORTFOLIO_MEMBERSHIP: 'Action'
    ASANA_GET_A_PORTFOLIO_S_CUSTOM_FIELDS: 'Action'
    ASANA_GET_A_PROJECT: 'Action'
    ASANA_GET_A_PROJECT_BRIEF: 'Action'
    ASANA_GET_A_PROJECT_MEMBERSHIP: 'Action'
    ASANA_GET_A_PROJECT_STATUS: 'Action'
    ASANA_GET_A_PROJECT_S_CUSTOM_FIELDS: 'Action'
    ASANA_GET_A_PROJECT_TEMPLATE: 'Action'
    ASANA_GET_A_SECTION: 'Action'
    ASANA_GET_A_STATUS_UPDATE: 'Action'
    ASANA_GET_A_STORY: 'Action'
    ASANA_GET_A_TAG: 'Action'
    ASANA_GET_A_TASK: 'Action'
    ASANA_GET_A_TASK_FOR_A_GIVEN_CUSTOM_ID: 'Action'
    ASANA_GET_A_TASK_S_TAGS: 'Action'
    ASANA_GET_A_TASK_TEMPLATE: 'Action'
    ASANA_GET_A_TEAM: 'Action'
    ASANA_GET_A_TEAM_MEMBERSHIP: 'Action'
    ASANA_GET_A_TEAM_S_PROJECTS: 'Action'
    ASANA_GET_A_TEAM_S_PROJECT_TEMPLATES: 'Action'
    ASANA_GET_A_TIME_PERIOD: 'Action'
    ASANA_GET_A_TIME_TRACKING_ENTRY: 'Action'
    ASANA_GET_A_USER: 'Action'
    ASANA_GET_A_USER_S_FAVORITES: 'Action'
    ASANA_GET_A_USER_S_TASK_LIST: 'Action'
    ASANA_GET_A_USER_TASK_LIST: 'Action'
    ASANA_GET_A_WEBHOOK: 'Action'
    ASANA_GET_A_WORKSPACE: 'Action'
    ASANA_GET_A_WORKSPACE_MEMBERSHIP: 'Action'
    ASANA_GET_A_WORKSPACE_S_CUSTOM_FIELDS: 'Action'
    ASANA_GET_DEPENDENCIES_FROM_A_TASK: 'Action'
    ASANA_GET_DEPENDENTS_FROM_A_TASK: 'Action'
    ASANA_GET_DETAILS_ON_AN_ORG_EXPORT_REQUEST: 'Action'
    ASANA_GET_EVENTS_ON_A_RESOURCE: 'Action'
    ASANA_GET_GOALS: 'Action'
    ASANA_GET_GOAL_RELATIONSHIPS: 'Action'
    ASANA_GET_MEMBERSHIPS_FROM_A_PORTFOLIO: 'Action'
    ASANA_GET_MEMBERSHIPS_FROM_A_PROJECT: 'Action'
    ASANA_GET_MEMBERSHIPS_FROM_A_TEAM: 'Action'
    ASANA_GET_MEMBERSHIPS_FROM_A_USER: 'Action'
    ASANA_GET_MULTIPLE_ALLOCATIONS: 'Action'
    ASANA_GET_MULTIPLE_MEMBERSHIPS: 'Action'
    ASANA_GET_MULTIPLE_PORTFOLIOS: 'Action'
    ASANA_GET_MULTIPLE_PORTFOLIO_MEMBERSHIPS: 'Action'
    ASANA_GET_MULTIPLE_PROJECTS: 'Action'
    ASANA_GET_MULTIPLE_PROJECT_TEMPLATES: 'Action'
    ASANA_GET_MULTIPLE_TAGS: 'Action'
    ASANA_GET_MULTIPLE_TASKS: 'Action'
    ASANA_GET_MULTIPLE_TASK_TEMPLATES: 'Action'
    ASANA_GET_MULTIPLE_USERS: 'Action'
    ASANA_GET_MULTIPLE_WEBHOOKS: 'Action'
    ASANA_GET_MULTIPLE_WORKSPACES: 'Action'
    ASANA_GET_OBJECTS_VIA_TYPEAHEAD: 'Action'
    ASANA_GET_PARENT_GOALS_FROM_A_GOAL: 'Action'
    ASANA_GET_PORTFOLIO_ITEMS: 'Action'
    ASANA_GET_PROJECTS_A_TASK_IS_IN: 'Action'
    ASANA_GET_SECTIONS_IN_A_PROJECT: 'Action'
    ASANA_GET_STATUSES_FROM_A_PROJECT: 'Action'
    ASANA_GET_STATUS_UPDATES_FROM_AN_OBJECT: 'Action'
    ASANA_GET_STORIES_FROM_A_TASK: 'Action'
    ASANA_GET_SUBTASKS_FROM_A_TASK: 'Action'
    ASANA_GET_TAGS_IN_A_WORKSPACE: 'Action'
    ASANA_GET_TASKS_FROM_A_PROJECT: 'Action'
    ASANA_GET_TASKS_FROM_A_SECTION: 'Action'
    ASANA_GET_TASKS_FROM_A_TAG: 'Action'
    ASANA_GET_TASKS_FROM_A_USER_TASK_LIST: 'Action'
    ASANA_GET_TASK_COUNT_OF_A_PROJECT: 'Action'
    ASANA_GET_TEAMS_FOR_A_USER: 'Action'
    ASANA_GET_TEAMS_IN_A_WORKSPACE: 'Action'
    ASANA_GET_TEAM_MEMBERSHIPS: 'Action'
    ASANA_GET_THE_WORKSPACE_MEMBERSHIPS_FOR_A_WORKSPACE: 'Action'
    ASANA_GET_TIME_PERIODS: 'Action'
    ASANA_GET_TIME_TRACKING_ENTRIES_FOR_A_TASK: 'Action'
    ASANA_GET_USERS_IN_A_TEAM: 'Action'
    ASANA_GET_USERS_IN_A_WORKSPACE_OR_ORGANIZATION: 'Action'
    ASANA_GET_WORKSPACE_MEMBERSHIPS_FOR_A_USER: 'Action'
    ASANA_INSTANTIATE_A_PROJECT_FROM_A_PROJECT_TEMPLATE: 'Action'
    ASANA_INSTANTIATE_A_TASK_FROM_A_TASK_TEMPLATE: 'Action'
    ASANA_MOVE_OR_INSERT_SECTIONS: 'Action'
    ASANA_REMOVES_A_SUPPORTING_GOAL_RELATIONSHIP: 'Action'
    ASANA_REMOVE_A_COLLABORATOR_FROM_A_GOAL: 'Action'
    ASANA_REMOVE_A_CUSTOM_FIELD_FROM_A_PORTFOLIO: 'Action'
    ASANA_REMOVE_A_CUSTOM_FIELD_FROM_A_PROJECT: 'Action'
    ASANA_REMOVE_A_PORTFOLIO_ITEM: 'Action'
    ASANA_REMOVE_A_PROJECT_FROM_A_TASK: 'Action'
    ASANA_REMOVE_A_TAG_FROM_A_TASK: 'Action'
    ASANA_REMOVE_A_USER_FROM_A_TEAM: 'Action'
    ASANA_REMOVE_A_USER_FROM_A_WORKSPACE_OR_ORGANIZATION: 'Action'
    ASANA_REMOVE_FOLLOWERS_FROM_A_PROJECT: 'Action'
    ASANA_REMOVE_FOLLOWERS_FROM_A_TASK: 'Action'
    ASANA_REMOVE_USERS_FROM_A_PORTFOLIO: 'Action'
    ASANA_REMOVE_USERS_FROM_A_PROJECT: 'Action'
    ASANA_REORDER_A_CUSTOM_FIELD_S_ENUM: 'Action'
    ASANA_SEARCH_TASKS_IN_A_WORKSPACE: 'Action'
    ASANA_SET_DEPENDENCIES_FOR_A_TASK: 'Action'
    ASANA_SET_DEPENDENTS_FOR_A_TASK: 'Action'
    ASANA_SET_THE_PARENT_OF_A_TASK: 'Action'
    ASANA_SUBMIT_PARALLEL_REQUESTS: 'Action'
    ASANA_TRIGGER_A_RULE: 'Action'
    ASANA_UNLINK_DEPENDENCIES_FROM_A_TASK: 'Action'
    ASANA_UNLINK_DEPENDENTS_FROM_A_TASK: 'Action'
    ASANA_UPDATE_AN_ALLOCATION: 'Action'
    ASANA_UPDATE_AN_ENUM_OPTION: 'Action'
    ASANA_UPDATE_A_CUSTOM_FIELD: 'Action'
    ASANA_UPDATE_A_GOAL: 'Action'
    ASANA_UPDATE_A_GOAL_METRIC: 'Action'
    ASANA_UPDATE_A_GOAL_RELATIONSHIP: 'Action'
    ASANA_UPDATE_A_MEMBERSHIP: 'Action'
    ASANA_UPDATE_A_PORTFOLIO: 'Action'
    ASANA_UPDATE_A_PROJECT: 'Action'
    ASANA_UPDATE_A_PROJECT_BRIEF: 'Action'
    ASANA_UPDATE_A_SECTION: 'Action'
    ASANA_UPDATE_A_STORY: 'Action'
    ASANA_UPDATE_A_TAG: 'Action'
    ASANA_UPDATE_A_TASK: 'Action'
    ASANA_UPDATE_A_TEAM: 'Action'
    ASANA_UPDATE_A_TIME_TRACKING_ENTRY: 'Action'
    ASANA_UPDATE_A_WEBHOOK: 'Action'
    ASANA_UPDATE_A_WORKSPACE: 'Action'
    ASANA_UPLOAD_AN_ATTACHMENT: 'Action'
    ATTIO_ASSERT_A_LIST_ENTRY_BY_PARENT: 'Action'
    ATTIO_ASSERT_A_RECORD: 'Action'
    ATTIO_CREATE_AN_ATTRIBUTE: 'Action'
    ATTIO_CREATE_AN_ENTRY_ADD_RECORD_TO_LIST: 'Action'
    ATTIO_CREATE_AN_OBJECT: 'Action'
    ATTIO_CREATE_A_COMMENT: 'Action'
    ATTIO_CREATE_A_LIST: 'Action'
    ATTIO_CREATE_A_NOTE: 'Action'
    ATTIO_CREATE_A_RECORD: 'Action'
    ATTIO_CREATE_A_SELECT_OPTION: 'Action'
    ATTIO_CREATE_A_STATUS: 'Action'
    ATTIO_CREATE_A_TASK: 'Action'
    ATTIO_CREATE_A_WEBHOOK: 'Action'
    ATTIO_DELETE_A_COMMENT: 'Action'
    ATTIO_DELETE_A_LIST_ENTRY: 'Action'
    ATTIO_DELETE_A_NOTE: 'Action'
    ATTIO_DELETE_A_RECORD: 'Action'
    ATTIO_DELETE_A_TASK: 'Action'
    ATTIO_DELETE_A_WEBHOOK: 'Action'
    ATTIO_GET_AN_ATTRIBUTE: 'Action'
    ATTIO_GET_AN_OBJECT: 'Action'
    ATTIO_GET_A_COMMENT: 'Action'
    ATTIO_GET_A_LIST: 'Action'
    ATTIO_GET_A_LIST_ENTRY: 'Action'
    ATTIO_GET_A_NOTE: 'Action'
    ATTIO_GET_A_RECORD: 'Action'
    ATTIO_GET_A_TASK: 'Action'
    ATTIO_GET_A_THREAD: 'Action'
    ATTIO_GET_A_WEBHOOK: 'Action'
    ATTIO_GET_A_WORKSPACE_MEMBER: 'Action'
    ATTIO_IDENTIFY: 'Action'
    ATTIO_LIST_ALL_LISTS: 'Action'
    ATTIO_LIST_ATTRIBUTES: 'Action'
    ATTIO_LIST_ATTRIBUTE_VALUES_FOR_A_LIST_ENTRY: 'Action'
    ATTIO_LIST_ENTRIES: 'Action'
    ATTIO_LIST_NOTES: 'Action'
    ATTIO_LIST_OBJECTS: 'Action'
    ATTIO_LIST_RECORDS: 'Action'
    ATTIO_LIST_RECORD_ATTRIBUTE_VALUES: 'Action'
    ATTIO_LIST_RECORD_ENTRIES: 'Action'
    ATTIO_LIST_SELECT_OPTIONS: 'Action'
    ATTIO_LIST_STATUSES: 'Action'
    ATTIO_LIST_TASKS: 'Action'
    ATTIO_LIST_THREADS: 'Action'
    ATTIO_LIST_WEBHOOKS: 'Action'
    ATTIO_LIST_WORKSPACE_MEMBERS: 'Action'
    ATTIO_UPDATE_AN_ATTRIBUTE: 'Action'
    ATTIO_UPDATE_AN_OBJECT: 'Action'
    ATTIO_UPDATE_A_LIST: 'Action'
    ATTIO_UPDATE_A_LIST_ENTRY_APPEND_MULTISELECT_VALUES: 'Action'
    ATTIO_UPDATE_A_LIST_ENTRY_OVERWRITE_MULTISELECT_VALUES: 'Action'
    ATTIO_UPDATE_A_RECORD: 'Action'
    ATTIO_UPDATE_A_SELECT_OPTION: 'Action'
    ATTIO_UPDATE_A_STATUS: 'Action'
    ATTIO_UPDATE_A_TASK: 'Action'
    ATTIO_UPDATE_A_WEBHOOK: 'Action'
    BAMBOOHR_ADDS_A_TABLE_ROW: 'Action'
    BAMBOOHR_ADD_AN_EMPLOYEE_BENEFIT: 'Action'
    BAMBOOHR_ADD_AN_EMPLOYEE_DEPENDENT: 'Action'
    BAMBOOHR_ADD_AN_EMPLOYEE_S_DEFAULT_WITHHOLDINGS: 'Action'
    BAMBOOHR_ADD_AN_EMPLOYEE_S_DIRECT_DEPOSIT_INFORMATION: 'Action'
    BAMBOOHR_ADD_AN_EMPLOYEE_S_PAYSTUB: 'Action'
    BAMBOOHR_ADD_AN_EMPLOYEE_S_UNPAID_PAYSTUBS: 'Action'
    BAMBOOHR_ADD_AN_HOUR_RECORD: 'Action'
    BAMBOOHR_ADD_APPLICATION_COMMENT: 'Action'
    BAMBOOHR_ADD_A_BENEFIT_GROUP_EMPLOYEE: 'Action'
    BAMBOOHR_ADD_A_NEW_COMPANY_BENEFIT: 'Action'
    BAMBOOHR_ADD_A_TIME_OFF_HISTORY_ITEM_FOR_TIME_OFF_REQUEST: 'Action'
    BAMBOOHR_ADD_A_TIME_OFF_REQUEST: 'Action'
    BAMBOOHR_ADD_EDIT_TIMESHEET_CLOCK_ENTRIES: 'Action'
    BAMBOOHR_ADD_EDIT_TIMESHEET_HOUR_ENTRIES: 'Action'
    BAMBOOHR_ADD_EMPLOYEE: 'Action'
    BAMBOOHR_ADD_NEW_CANDIDATE: 'Action'
    BAMBOOHR_ADD_NEW_EMPLOYEE_TRAINING_RECORD: 'Action'
    BAMBOOHR_ADD_NEW_JOB_OPENING: 'Action'
    BAMBOOHR_ADD_OR_UPDATE_VALUES_FOR_LIST_FIELDS: 'Action'
    BAMBOOHR_ADD_TIMESHEET_CLOCK_IN_ENTRY: 'Action'
    BAMBOOHR_ADD_TIMESHEET_CLOCK_OUT_ENTRY: 'Action'
    BAMBOOHR_ADD_TRAINING_CATEGORY: 'Action'
    BAMBOOHR_ADD_TRAINING_TYPE: 'Action'
    BAMBOOHR_ADD_WEBHOOK: 'Action'
    BAMBOOHR_ADJUST_TIME_OFF_BALANCE: 'Action'
    BAMBOOHR_ALIGNABLE_GOAL_OPTIONS: 'Action'
    BAMBOOHR_APPROVE_EMPLOYEE_TIMESHEETS: 'Action'
    BAMBOOHR_APPROVE_TIMESHEETS_FOR_EMPLOYEES_THAT_ARE_CURRENTLY_CLOCKED_IN: 'Action'
    BAMBOOHR_AVAILABLE_GOAL_SHARING_OPTIONS: 'Action'
    BAMBOOHR_CAN_CREATE_A_GOAL: 'Action'
    BAMBOOHR_CHANGE_APPLICANT_S_STATUS: 'Action'
    BAMBOOHR_CHANGE_A_REQUEST_STATUS: 'Action'
    BAMBOOHR_CLEAR_AN_EMPLOYEE_S_DEFAULT_WITHHOLDINGS: 'Action'
    BAMBOOHR_CLEAR_AN_EMPLOYEE_S_DIRECT_DEPOSIT_INFORMATION: 'Action'
    BAMBOOHR_CLEAR_AN_EMPLOYEE_S_UNPAID_PAYSTUBS: 'Action'
    BAMBOOHR_CLOCK_IN_EMPLOYEE_ID_OPTIONAL: 'Action'
    BAMBOOHR_CLOCK_OUT_AN_EMPLOYEE_AT_A_SPECIFIC_TIME: 'Action'
    BAMBOOHR_CLOCK_OUT_EMPLOYEE_ID_OPTIONAL: 'Action'
    BAMBOOHR_CLOSE_GOAL: 'Action'
    BAMBOOHR_CREATE_A_TIME_TRACKING_PROJECT: 'Action'
    BAMBOOHR_CREATE_GOAL: 'Action'
    BAMBOOHR_CREATE_GOAL_COMMENT: 'Action'
    BAMBOOHR_DELETES_A_TABLE_ROW: 'Action'
    BAMBOOHR_DELETE_AN_EMPLOYEE_S_PAYSTUB: 'Action'
    BAMBOOHR_DELETE_AN_HOUR_RECORD: 'Action'
    BAMBOOHR_DELETE_A_COMPANY_BENEFIT: 'Action'
    BAMBOOHR_DELETE_CLOCK_ENTRIES: 'Action'
    BAMBOOHR_DELETE_COMPANY_FILE: 'Action'
    BAMBOOHR_DELETE_EMPLOYEE_FILE: 'Action'
    BAMBOOHR_DELETE_EMPLOYEE_TRAINING_RECORD: 'Action'
    BAMBOOHR_DELETE_GOAL: 'Action'
    BAMBOOHR_DELETE_GOAL_COMMENT: 'Action'
    BAMBOOHR_DELETE_TIMESHEET_CLOCK_ENTRIES: 'Action'
    BAMBOOHR_DELETE_TIMESHEET_HOUR_ENTRIES: 'Action'
    BAMBOOHR_DELETE_TRAINING_CATEGORY: 'Action'
    BAMBOOHR_DELETE_TRAINING_TYPE: 'Action'
    BAMBOOHR_DELETE_WEBHOOK: 'Action'
    BAMBOOHR_EDIT_AN_HOUR_RECORD: 'Action'
    BAMBOOHR_EDIT_INFORMATION_ON_THE_CURRENTLY_CLOCKED_IN_ENTRY: 'Action'
    BAMBOOHR_ENSURE_EMPLOYEE_FIELDS_FOR_TABLE_ROW: 'Action'
    BAMBOOHR_ESTIMATE_FUTURE_TIME_OFF_BALANCES: 'Action'
    BAMBOOHR_GETS_ALL_UPDATED_EMPLOYEE_IDS: 'Action'
    BAMBOOHR_GETS_ALL_UPDATED_EMPLOYEE_TABLE_DATA: 'Action'
    BAMBOOHR_GETS_AS_LIST_OF_WEBHOOKS_FOR_THE_USER_API_KEY: 'Action'
    BAMBOOHR_GETS_TABLE_ROWS_FOR_A_GIVEN_EMPLOYEE_AND_TABLE_COMBINATION: 'Action'
    BAMBOOHR_GET_AGGREGATE_GOAL_INFO: 'Action'
    BAMBOOHR_GET_ALL_AGGREGATE_GOAL_INFO: 'Action'
    BAMBOOHR_GET_ALL_AGGREGATE_GOAL_INFO_VERSION_1_1: 'Action'
    BAMBOOHR_GET_ALL_AGGREGATE_GOAL_INFO_VERSION_1_2: 'Action'
    BAMBOOHR_GET_ALL_EMPLOYEE_DEPENDENTS: 'Action'
    BAMBOOHR_GET_AN_COMPANY_FILE: 'Action'
    BAMBOOHR_GET_AN_EMPLOYEE_FILE: 'Action'
    BAMBOOHR_GET_AN_EMPLOYEE_PHOTO: 'Action'
    BAMBOOHR_GET_AN_EMPLOYEE_S_DEFAULT_WITHHOLDINGS: 'Action'
    BAMBOOHR_GET_AN_EMPLOYEE_S_DIRECT_DEPOSIT_INFORMATION: 'Action'
    BAMBOOHR_GET_AN_EMPLOYEE_S_PAYSTUB: 'Action'
    BAMBOOHR_GET_AN_EMPLOYEE_S_UNPAID_PAYSTUBS: 'Action'
    BAMBOOHR_GET_AN_HOUR_RECORD: 'Action'
    BAMBOOHR_GET_APPLICATIONS: 'Action'
    BAMBOOHR_GET_APPLICATION_DETAILS: 'Action'
    BAMBOOHR_GET_A_CLOCK_ENTRY: 'Action'
    BAMBOOHR_GET_A_COMPANY_BENEFIT: 'Action'
    BAMBOOHR_GET_A_DAILY_ENTRY: 'Action'
    BAMBOOHR_GET_A_LIST_OF_COMPANY_BENEFITS: 'Action'
    BAMBOOHR_GET_A_LIST_OF_COMPANY_BENEFIT_TYPES: 'Action'
    BAMBOOHR_GET_A_LIST_OF_EMPLOYEE_BENEFITS: 'Action'
    BAMBOOHR_GET_A_LIST_OF_FIELDS: 'Action'
    BAMBOOHR_GET_A_LIST_OF_TABULAR_FIELDS: 'Action'
    BAMBOOHR_GET_A_LIST_OF_USERS: 'Action'
    BAMBOOHR_GET_A_LIST_OF_WHO_S_OUT: 'Action'
    BAMBOOHR_GET_A_TIMESHEET_FOR_AN_EMPLOYEE: 'Action'
    BAMBOOHR_GET_BENEFIT_COVERAGES: 'Action'
    BAMBOOHR_GET_BENEFIT_DEDUCTIONS_FOR_EMPLOYEE: 'Action'
    BAMBOOHR_GET_BENEFIT_DEDUCTION_TYPES: 'Action'
    BAMBOOHR_GET_BENEFIT_GROUPS: 'Action'
    BAMBOOHR_GET_BENEFIT_GROUP_EMPLOYEES: 'Action'
    BAMBOOHR_GET_BENEFIT_GROUP_PLANS: 'Action'
    BAMBOOHR_GET_BENEFIT_GROUP_PLAN_COSTS: 'Action'
    BAMBOOHR_GET_BENEFIT_PLANS: 'Action'
    BAMBOOHR_GET_BENEFIT_PLAN_COVERAGES: 'Action'
    BAMBOOHR_GET_BENEFIT_PLAN_DEDUCTIONS_BY_EMPLOYEE: 'Action'
    BAMBOOHR_GET_COMPANY_LOCATIONS: 'Action'
    BAMBOOHR_GET_COMPANY_REPORT: 'Action'
    BAMBOOHR_GET_DETAILS_FOR_LIST_FIELDS: 'Action'
    BAMBOOHR_GET_EMPLOYEE: 'Action'
    BAMBOOHR_GET_EMPLOYEE_DEDUCTIONS_BY_BENEFIT_PLAN: 'Action'
    BAMBOOHR_GET_EMPLOYEE_DEPENDENT: 'Action'
    BAMBOOHR_GET_EMPLOYEE_DIRECTORY: 'Action'
    BAMBOOHR_GET_EMPLOYEE_PROJECTS: 'Action'
    BAMBOOHR_GET_GOALS: 'Action'
    BAMBOOHR_GET_GOAL_COMMENTS: 'Action'
    BAMBOOHR_GET_GOAL_STATUS_COUNTS: 'Action'
    BAMBOOHR_GET_GOAL_STATUS_COUNTS_VERSION_1_1: 'Action'
    BAMBOOHR_GET_HIRING_LEADS: 'Action'
    BAMBOOHR_GET_JOB_SUMMARIES: 'Action'
    BAMBOOHR_GET_MONITOR_FIELDS: 'Action'
    BAMBOOHR_GET_PROJECTS_AN_EMPLOYEE_CAN_LOG_TIME_TO: 'Action'
    BAMBOOHR_GET_STATUSES: 'Action'
    BAMBOOHR_GET_TASKS_FOR_A_PROJECT: 'Action'
    BAMBOOHR_GET_TIMESHEETS_BY_IDS: 'Action'
    BAMBOOHR_GET_TIMESHEET_ENTRIES: 'Action'
    BAMBOOHR_GET_TIME_OFF_POLICIES: 'Action'
    BAMBOOHR_GET_TIME_OFF_REQUESTS: 'Action'
    BAMBOOHR_GET_TIME_OFF_TYPES: 'Action'
    BAMBOOHR_GET_WEBHOOK: 'Action'
    BAMBOOHR_GET_WEBHOOK_LOGS: 'Action'
    BAMBOOHR_IS_EMPLOYEE_CLOCKED_IN: 'Action'
    BAMBOOHR_LIST_COMPANY_FILES_AND_CATEGORIES: 'Action'
    BAMBOOHR_LIST_EMPLOYEE_FILES_AND_CATEGORIES: 'Action'
    BAMBOOHR_LIST_EMPLOYEE_TRAININGS: 'Action'
    BAMBOOHR_LIST_TIME_OFF_POLICIES_FOR_EMPLOYEE: 'Action'
    BAMBOOHR_LIST_TIME_OFF_POLICIES_FOR_EMPLOYEE_VERSION_1_1: 'Action'
    BAMBOOHR_LIST_TRAINING_CATEGORIES: 'Action'
    BAMBOOHR_LIST_TRAINING_TYPES: 'Action'
    BAMBOOHR_MODIFIES_ROW_CONTENTS: 'Action'
    BAMBOOHR_REOPEN_A_GOAL: 'Action'
    BAMBOOHR_REQUEST_A_CUSTOM_REPORT: 'Action'
    BAMBOOHR_STORE_A_NEW_EMPLOYEE_PHOTO: 'Action'
    BAMBOOHR_STORE_CLOCK_ENTRIES: 'Action'
    BAMBOOHR_STORE_DAILY_ENTRIES: 'Action'
    BAMBOOHR_UPDATES_A_TABLE_ROW: 'Action'
    BAMBOOHR_UPDATE_AN_EMPLOYEE_DEPENDENT: 'Action'
    BAMBOOHR_UPDATE_A_COMPANY_BENEFIT: 'Action'
    BAMBOOHR_UPDATE_COMPANY_FILE: 'Action'
    BAMBOOHR_UPDATE_EMPLOYEE: 'Action'
    BAMBOOHR_UPDATE_EMPLOYEE_FILE: 'Action'
    BAMBOOHR_UPDATE_EMPLOYEE_TRAINING_RECORD: 'Action'
    BAMBOOHR_UPDATE_GOAL: 'Action'
    BAMBOOHR_UPDATE_GOAL_COMMENT: 'Action'
    BAMBOOHR_UPDATE_GOAL_PROGRESS: 'Action'
    BAMBOOHR_UPDATE_GOAL_SHARING: 'Action'
    BAMBOOHR_UPDATE_GOAL_V1_1: 'Action'
    BAMBOOHR_UPDATE_TRAINING_CATEGORY: 'Action'
    BAMBOOHR_UPDATE_TRAINING_TYPE: 'Action'
    BAMBOOHR_UPDATE_WEBHOOK: 'Action'
    BAMBOOHR_UPLOAD_COMPANY_FILE: 'Action'
    BAMBOOHR_UPLOAD_EMPLOYEE_FILE: 'Action'
    BAMBOOHR_USER_LOGIN: 'Action'
    BLACKBOARD_ACCESS_AND_VISIBILITY_CONTROL_FOR_GRADEBOOK_COLUMNS: 'Action'
    BLACKBOARD_ACCESS_CONTROLLED_COURSE_ANNOUNCEMENTS: 'Action'
    BLACKBOARD_ACCESS_CONTROL_BY_ENTITLEMENTS_ON_COURSE_ENDPOINT: 'Action'
    BLACKBOARD_ACCESS_COURSE_ANNOUNCEMENTS_BASED_ON_PERMISSIONS: 'Action'
    BLACKBOARD_ADD_CHILD_COURSE: 'Action'
    BLACKBOARD_ATTACH_FILE: 'Action'
    BLACKBOARD_AUTHORIZATION_CODE: 'Action'
    BLACKBOARD_CONDITIONAL_GRADE_ACCESS: 'Action'
    BLACKBOARD_COPY_COURSE: 'Action'
    BLACKBOARD_COURSE_AND_ORG_DUPLICATION_PERMISSIONS_UPDATE: 'Action'
    BLACKBOARD_COURSE_ANNOUNCEMENT_CREATION_PERMISSION: 'Action'
    BLACKBOARD_COURSE_DATA_ACCESS_CONTROL_BY_USER_ENTITLEMENT: 'Action'
    BLACKBOARD_COURSE_ENROLLMENT_WITH_ROLE_AND_PERMISSIONS_CONTROL: 'Action'
    BLACKBOARD_COURSE_ENTITLEMENT_AND_DATA_ACCESS_CONTROL: 'Action'
    BLACKBOARD_COURSE_GROUP_INITIATION: 'Action'
    BLACKBOARD_COURSE_GROUP_MODIFICATION: 'Action'
    BLACKBOARD_COURSE_MODIFICATION_PERMISSIONS: 'Action'
    BLACKBOARD_COURSE_MODIFICATION_PERMISSION_CHECKS: 'Action'
    BLACKBOARD_COURSE_ORG_SYNC_REMOVAL: 'Action'
    BLACKBOARD_COURSE_OR_ORGANIZATION_CREATION: 'Action'
    BLACKBOARD_COURSE_USER_REMOVAL: 'Action'
    BLACKBOARD_CREATE_ADAPTIVE_RELEASE_ACL_USER_PREDICATE: 'Action'
    BLACKBOARD_CREATE_ADAPTIVE_RELEASE_RULE_CRITERIA: 'Action'
    BLACKBOARD_CREATE_ANNOUNCEMENT: 'Action'
    BLACKBOARD_CREATE_ASSIGNMENT: 'Action'
    BLACKBOARD_CREATE_ATTENDANCE_RECORD: 'Action'
    BLACKBOARD_CREATE_CALENDAR_ITEM: 'Action'
    BLACKBOARD_CREATE_CATEGORY: 'Action'
    BLACKBOARD_CREATE_CHILD: 'Action'
    BLACKBOARD_CREATE_CHILD_NODE: 'Action'
    BLACKBOARD_CREATE_COLUMN_ATTEMPT: 'Action'
    BLACKBOARD_CREATE_COLUMN_GROUP_ATTEMPT: 'Action'
    BLACKBOARD_CREATE_CONTENT: 'Action'
    BLACKBOARD_CREATE_CONTENT_GROUP: 'Action'
    BLACKBOARD_CREATE_COURSE: 'Action'
    BLACKBOARD_CREATE_COURSE_MEETING: 'Action'
    BLACKBOARD_CREATE_DATA_SOURCE: 'Action'
    BLACKBOARD_CREATE_DISCUSSION: 'Action'
    BLACKBOARD_CREATE_DOMAIN_CONFIG: 'Action'
    BLACKBOARD_CREATE_FILE_ATTACHMENT: 'Action'
    BLACKBOARD_CREATE_GRADE_COLUMN: 'Action'
    BLACKBOARD_CREATE_GRADE_NOTATION: 'Action'
    BLACKBOARD_CREATE_GRADE_SCHEMA: 'Action'
    BLACKBOARD_CREATE_GRADING_PERIOD: 'Action'
    BLACKBOARD_CREATE_GROUP: 'Action'
    BLACKBOARD_CREATE_GROUP_MEMBERSHIP: 'Action'
    BLACKBOARD_CREATE_GROUP_PREDICATE: 'Action'
    BLACKBOARD_CREATE_GROUP_SET: 'Action'
    BLACKBOARD_CREATE_GROUP_SET_CHILD: 'Action'
    BLACKBOARD_CREATE_MEMBERSHIP: 'Action'
    BLACKBOARD_CREATE_MESSAGE: 'Action'
    BLACKBOARD_CREATE_MESSAGE_REPLY: 'Action'
    BLACKBOARD_CREATE_NODE: 'Action'
    BLACKBOARD_CREATE_NODE_COURSE_ASSOCIATION: 'Action'
    BLACKBOARD_CREATE_NODE_USER_ASSOCIATION: 'Action'
    BLACKBOARD_CREATE_OBSERVER: 'Action'
    BLACKBOARD_CREATE_PLACEMENT: 'Action'
    BLACKBOARD_CREATE_PRONOUN: 'Action'
    BLACKBOARD_CREATE_QUESTION: 'Action'
    BLACKBOARD_CREATE_RUBRIC: 'Action'
    BLACKBOARD_CREATE_RUBRIC_ASSOCIATION: 'Action'
    BLACKBOARD_CREATE_RUBRIC_EVALUATIONS: 'Action'
    BLACKBOARD_CREATE_RULE: 'Action'
    BLACKBOARD_CREATE_TERM: 'Action'
    BLACKBOARD_CREATE_USER: 'Action'
    BLACKBOARD_DELETE_ACL_USER_PREDICATE: 'Action'
    BLACKBOARD_DELETE_ADAPTIVE_RELEASE_RULE_CRITERION: 'Action'
    BLACKBOARD_DELETE_ALL_ATTENDANCE_BY_USER_ID: 'Action'
    BLACKBOARD_DELETE_ALL_ATTENDANCE_RECORDS_BY_COURSE_AND_USER_ID: 'Action'
    BLACKBOARD_DELETE_ALL_MEETINGS_IN_COURSE: 'Action'
    BLACKBOARD_DELETE_ALL_RECORDS_IN_MEETING: 'Action'
    BLACKBOARD_DELETE_ANNOUNCEMENT: 'Action'
    BLACKBOARD_DELETE_ATTACHMENT: 'Action'
    BLACKBOARD_DELETE_ATTENDANCE_RECORD: 'Action'
    BLACKBOARD_DELETE_CALENDAR_ITEM: 'Action'
    BLACKBOARD_DELETE_CATEGORY: 'Action'
    BLACKBOARD_DELETE_CONTENT: 'Action'
    BLACKBOARD_DELETE_CONTENT_GROUP: 'Action'
    BLACKBOARD_DELETE_COURSE: 'Action'
    BLACKBOARD_DELETE_COURSE_MEETING: 'Action'
    BLACKBOARD_DELETE_DATA_SOURCE: 'Action'
    BLACKBOARD_DELETE_DOMAIN_CONFIG: 'Action'
    BLACKBOARD_DELETE_FILE_ATTACHMENT: 'Action'
    BLACKBOARD_DELETE_GRADE_COLUMN: 'Action'
    BLACKBOARD_DELETE_GRADE_NOTATION: 'Action'
    BLACKBOARD_DELETE_GRADING_PERIOD: 'Action'
    BLACKBOARD_DELETE_GROUP: 'Action'
    BLACKBOARD_DELETE_GROUP_MEMBERSHIP: 'Action'
    BLACKBOARD_DELETE_GROUP_PREDICATE: 'Action'
    BLACKBOARD_DELETE_GROUP_SET: 'Action'
    BLACKBOARD_DELETE_MEMBERSHIP: 'Action'
    BLACKBOARD_DELETE_MESSAGE: 'Action'
    BLACKBOARD_DELETE_NODE: 'Action'
    BLACKBOARD_DELETE_NODE_ADMIN: 'Action'
    BLACKBOARD_DELETE_NODE_COURSE_ASSOCIATION: 'Action'
    BLACKBOARD_DELETE_NODE_USER_ASSOCIATION: 'Action'
    BLACKBOARD_DELETE_OBSERVER: 'Action'
    BLACKBOARD_DELETE_PLACEMENT: 'Action'
    BLACKBOARD_DELETE_PRONOUN: 'Action'
    BLACKBOARD_DELETE_QUESTION: 'Action'
    BLACKBOARD_DELETE_RUBRIC: 'Action'
    BLACKBOARD_DELETE_RUBRIC_ASSOCIATION: 'Action'
    BLACKBOARD_DELETE_TERM: 'Action'
    BLACKBOARD_DELETE_USER: 'Action'
    BLACKBOARD_DEPRECATED_GRADE_COLUMN_ACCESS: 'Action'
    BLACKBOARD_DEPRECATE_COURSE_GROUP_DELETE: 'Action'
    BLACKBOARD_DOWNLOAD: 'Action'
    BLACKBOARD_ENHANCE_GRADEBOOK_ENTRIES: 'Action'
    BLACKBOARD_FETCH_COURSE_CATEGORY_ASSOCIATIONS: 'Action'
    BLACKBOARD_FETCH_COURSE_RUBRIC_ASSESSMENTS: 'Action'
    BLACKBOARD_FETCH_GROUP_ATTEMPT_RUBRIC_SCORES: 'Action'
    BLACKBOARD_FILTER_GRADES_WITH_EXCLUSIONS_AND_SECURITY: 'Action'
    BLACKBOARD_GENERATE_ATTENDANCE_DATA_DOWNLOAD_URL: 'Action'
    BLACKBOARD_GET_ACTIVE_SESSIONS: 'Action'
    BLACKBOARD_GET_ADAPTIVE_RELEASE_ACL_GROUP_PREDICATES: 'Action'
    BLACKBOARD_GET_ADAPTIVE_RELEASE_ACL_USER_PREDICATES: 'Action'
    BLACKBOARD_GET_ADAPTIVE_RELEASE_RULE_CRITERION: 'Action'
    BLACKBOARD_GET_ANNOUNCEMENT: 'Action'
    BLACKBOARD_GET_ANNOUNCEMENTS: 'Action'
    BLACKBOARD_GET_ATTEMPT_FILE_META_DATA: 'Action'
    BLACKBOARD_GET_ATTEMPT_FILE_META_DATA_LIST: 'Action'
    BLACKBOARD_GET_ATTEMPT_RECEIPT: 'Action'
    BLACKBOARD_GET_ATTENDANCE_RECORD: 'Action'
    BLACKBOARD_GET_ATTENDANCE_RECORDS_BY_MEETING_ID: 'Action'
    BLACKBOARD_GET_ATTENDANCE_RECORDS_BY_USER_ID: 'Action'
    BLACKBOARD_GET_CALENDARS: 'Action'
    BLACKBOARD_GET_CALENDAR_ITEM: 'Action'
    BLACKBOARD_GET_CALENDAR_ITEMS: 'Action'
    BLACKBOARD_GET_CATEGORIES: 'Action'
    BLACKBOARD_GET_CATEGORY: 'Action'
    BLACKBOARD_GET_CHILD: 'Action'
    BLACKBOARD_GET_CHILDREN_GOALS: 'Action'
    BLACKBOARD_GET_CHILD_CATEGORIES: 'Action'
    BLACKBOARD_GET_COLUMN_ATTEMPT: 'Action'
    BLACKBOARD_GET_COLUMN_ATTEMPTS: 'Action'
    BLACKBOARD_GET_COLUMN_GRADE: 'Action'
    BLACKBOARD_GET_COLUMN_GRADES: 'Action'
    BLACKBOARD_GET_COLUMN_GRADE_LAST_CHANGED: 'Action'
    BLACKBOARD_GET_COLUMN_GROUP_ATTEMPTS: 'Action'
    BLACKBOARD_GET_CONTENT: 'Action'
    BLACKBOARD_GET_CONTENTS: 'Action'
    BLACKBOARD_GET_CONTENT_CHILDREN: 'Action'
    BLACKBOARD_GET_CONTENT_COLLECTION_RESOURCE: 'Action'
    BLACKBOARD_GET_CONTENT_GROUP: 'Action'
    BLACKBOARD_GET_CONTENT_GROUPS: 'Action'
    BLACKBOARD_GET_COURSE: 'Action'
    BLACKBOARD_GET_COURSES: 'Action'
    BLACKBOARD_GET_COURSE_CHILDREN: 'Action'
    BLACKBOARD_GET_COURSE_GOAL_ALIGNMENTS: 'Action'
    BLACKBOARD_GET_COURSE_GRADEBOOK_LOGS: 'Action'
    BLACKBOARD_GET_COURSE_GRADEBOOK_LOGS_BY_GRADEBOOK_COLUMN_ID: 'Action'
    BLACKBOARD_GET_COURSE_MEETING: 'Action'
    BLACKBOARD_GET_COURSE_MEETINGS: 'Action'
    BLACKBOARD_GET_COURSE_MEMBERSHIPS: 'Action'
    BLACKBOARD_GET_COURSE_RESOURCE: 'Action'
    BLACKBOARD_GET_COURSE_RESOURCE_CHILDREN: 'Action'
    BLACKBOARD_GET_COURSE_ROLE: 'Action'
    BLACKBOARD_GET_COURSE_ROLES: 'Action'
    BLACKBOARD_GET_CRITERIA: 'Action'
    BLACKBOARD_GET_CROSS_LIST_SET: 'Action'
    BLACKBOARD_GET_CURRENT_ACTIVE_USER_BY_ID: 'Action'
    BLACKBOARD_GET_DATA_SOURCE: 'Action'
    BLACKBOARD_GET_DATA_SOURCES: 'Action'
    BLACKBOARD_GET_DISCUSSION: 'Action'
    BLACKBOARD_GET_DISCUSSIONS: 'Action'
    BLACKBOARD_GET_DISCUSSION_MESSAGES: 'Action'
    BLACKBOARD_GET_DOMAIN_CONFIG: 'Action'
    BLACKBOARD_GET_DOMAIN_CONFIGS: 'Action'
    BLACKBOARD_GET_FILE_ATTACHMENT: 'Action'
    BLACKBOARD_GET_FILE_ATTACHMENTS: 'Action'
    BLACKBOARD_GET_FOLDERS: 'Action'
    BLACKBOARD_GET_GOALS: 'Action'
    BLACKBOARD_GET_GOALS_FROM_SET_AND_CATEGORY: 'Action'
    BLACKBOARD_GET_GOAL_ALIGNMENTS: 'Action'
    BLACKBOARD_GET_GOAL_BY_ID: 'Action'
    BLACKBOARD_GET_GOAL_SETS: 'Action'
    BLACKBOARD_GET_GOAL_SET_BY_ID: 'Action'
    BLACKBOARD_GET_GOAL_SET_CATEGORY_BY_ID: 'Action'
    BLACKBOARD_GET_GRADEBOOK_CATEGORIES: 'Action'
    BLACKBOARD_GET_GRADEBOOK_CATEGORY: 'Action'
    BLACKBOARD_GET_GRADE_COLUMN: 'Action'
    BLACKBOARD_GET_GRADE_COLUMNS: 'Action'
    BLACKBOARD_GET_GRADE_NOTATION: 'Action'
    BLACKBOARD_GET_GRADE_NOTATIONS: 'Action'
    BLACKBOARD_GET_GRADE_SCHEMAS: 'Action'
    BLACKBOARD_GET_GRADING_PERIOD: 'Action'
    BLACKBOARD_GET_GRADING_PERIODS: 'Action'
    BLACKBOARD_GET_GROUP: 'Action'
    BLACKBOARD_GET_GROUPS: 'Action'
    BLACKBOARD_GET_GROUP_MEMBERSHIP: 'Action'
    BLACKBOARD_GET_GROUP_MEMBERSHIPS: 'Action'
    BLACKBOARD_GET_GROUP_SET: 'Action'
    BLACKBOARD_GET_GROUP_SETS: 'Action'
    BLACKBOARD_GET_GROUP_SET_CHILDREN: 'Action'
    BLACKBOARD_GET_INFO: 'Action'
    BLACKBOARD_GET_INSTITUTION_ROLE: 'Action'
    BLACKBOARD_GET_INSTITUTION_ROLES: 'Action'
    BLACKBOARD_GET_LOGIN_AS_SESSIONS: 'Action'
    BLACKBOARD_GET_MEMBERSHIP: 'Action'
    BLACKBOARD_GET_MEMBERSHIPS: 'Action'
    BLACKBOARD_GET_MESSAGES: 'Action'
    BLACKBOARD_GET_MESSAGE_PARTICIPANTS: 'Action'
    BLACKBOARD_GET_MESSAGE_REPLIES: 'Action'
    BLACKBOARD_GET_NODE: 'Action'
    BLACKBOARD_GET_NODES: 'Action'
    BLACKBOARD_GET_NODES_FOR_COURSE: 'Action'
    BLACKBOARD_GET_NODES_FOR_USER: 'Action'
    BLACKBOARD_GET_NODE_ADMIN: 'Action'
    BLACKBOARD_GET_NODE_ADMINS: 'Action'
    BLACKBOARD_GET_NODE_CHILDREN: 'Action'
    BLACKBOARD_GET_NODE_COURSE_ASSOCIATIONS: 'Action'
    BLACKBOARD_GET_NODE_USER_ASSOCIATIONS: 'Action'
    BLACKBOARD_GET_OBSERVEES: 'Action'
    BLACKBOARD_GET_OBSERVERS: 'Action'
    BLACKBOARD_GET_PLACEMENT: 'Action'
    BLACKBOARD_GET_PLACEMENTS: 'Action'
    BLACKBOARD_GET_POLICIES: 'Action'
    BLACKBOARD_GET_PROCTORING_SERVICE: 'Action'
    BLACKBOARD_GET_PROCTORING_SERVICES: 'Action'
    BLACKBOARD_GET_PRONOUNS: 'Action'
    BLACKBOARD_GET_QUESTIONS: 'Action'
    BLACKBOARD_GET_QUESTION_BY_ID: 'Action'
    BLACKBOARD_GET_RESOURCES: 'Action'
    BLACKBOARD_GET_RESOURCE_CHILDREN: 'Action'
    BLACKBOARD_GET_REVIEW_STATUS: 'Action'
    BLACKBOARD_GET_REVIEW_STATUS_BY_COURSE_ID: 'Action'
    BLACKBOARD_GET_RUBRICS: 'Action'
    BLACKBOARD_GET_RUBRIC_ASSOCIATIONS: 'Action'
    BLACKBOARD_GET_RUBRIC_ASSOCIATIONS_BY_COLUMN_ID: 'Action'
    BLACKBOARD_GET_RUBRIC_ASSOCIATION_BY_ID: 'Action'
    BLACKBOARD_GET_RUBRIC_BY_ID: 'Action'
    BLACKBOARD_GET_RUBRIC_EVALUATIONS: 'Action'
    BLACKBOARD_GET_RUBRIC_EVALUATION_BY_ID: 'Action'
    BLACKBOARD_GET_RULES: 'Action'
    BLACKBOARD_GET_SETTINGS: 'Action'
    BLACKBOARD_GET_SIS_LOGS_BY_DATA_SET_UID: 'Action'
    BLACKBOARD_GET_SYSTEM_ROLE: 'Action'
    BLACKBOARD_GET_SYSTEM_ROLES: 'Action'
    BLACKBOARD_GET_SYSTEM_TASK: 'Action'
    BLACKBOARD_GET_TASK: 'Action'
    BLACKBOARD_GET_TERM: 'Action'
    BLACKBOARD_GET_TERMS: 'Action'
    BLACKBOARD_GET_TOC_ITEMS: 'Action'
    BLACKBOARD_GET_TOKEN_INFO: 'Action'
    BLACKBOARD_GET_TOOLS: 'Action'
    BLACKBOARD_GET_TOP_LEVEL_COURSE_RESOURCES: 'Action'
    BLACKBOARD_GET_TYPES: 'Action'
    BLACKBOARD_GET_USER: 'Action'
    BLACKBOARD_GET_USERS: 'Action'
    BLACKBOARD_GET_USER_AVATAR: 'Action'
    BLACKBOARD_GET_USER_GRADES: 'Action'
    BLACKBOARD_GET_USER_MEMBERSHIPS: 'Action'
    BLACKBOARD_GET_USER_PRONUNCIATION_AUDIO: 'Action'
    BLACKBOARD_GET_VERSION: 'Action'
    BLACKBOARD_GRADE_ACCESS_WITH_RIGHTS_VALIDATION: 'Action'
    BLACKBOARD_GROUP_MEMBERSHIP_API_DETAILS: 'Action'
    BLACKBOARD_INITIALIZE_EDUCATIONAL_ENTITY: 'Action'
    BLACKBOARD_INITIATE_GROUP_MEMBER_ADDITION: 'Action'
    BLACKBOARD_LIST_GOAL_SET_CATEGORIES: 'Action'
    BLACKBOARD_LOAD_COURSE_GROUP_DETAILS: 'Action'
    BLACKBOARD_LOAD_COURSE_GROUP_USER_INFO: 'Action'
    BLACKBOARD_MANAGE_COURSE_DATA_ACCESS: 'Action'
    BLACKBOARD_MANUAL_GRADE_COLUMN_CREATION: 'Action'
    BLACKBOARD_MANUAL_GRADE_COLUMN_MODIFICATION: 'Action'
    BLACKBOARD_MODIFY_COURSE_ANNOUNCEMENT_ACCESS: 'Action'
    BLACKBOARD_PATCH_TOOL: 'Action'
    BLACKBOARD_POST_ULTRA_COURSE_DISCUSSION_REPLY: 'Action'
    BLACKBOARD_REMOVE_CHILD_COURSE: 'Action'
    BLACKBOARD_REMOVE_COURSE_GROUP: 'Action'
    BLACKBOARD_REMOVE_COURSE_NOTICE: 'Action'
    BLACKBOARD_REMOVE_SPECIFIC_GRADE_FIELD: 'Action'
    BLACKBOARD_REMOVE_ULTRA_COURSE_DISCUSSION_POST: 'Action'
    BLACKBOARD_REQUEST_TOKEN: 'Action'
    BLACKBOARD_RETRIEVE_STUDENT_SUBMISSION_FILE: 'Action'
    BLACKBOARD_REVISE_ULTRA_COURSE_DISCUSSION_POST: 'Action'
    BLACKBOARD_ROLE_BASED_GRADE_ATTEMPT_VISIBILITY: 'Action'
    BLACKBOARD_SECURE_GRADE_ATTEMPT_ACCESS_WITH_VERSION_CONTROL: 'Action'
    BLACKBOARD_SET_NODE_ADMIN_ASSOCIATION: 'Action'
    BLACKBOARD_SYNCHRONOUS_COURSE_OR_ORG_REMOVAL: 'Action'
    BLACKBOARD_UPDATE_ADAPTIVE_RELEASE_RULE_CRITERION: 'Action'
    BLACKBOARD_UPDATE_ANNOUNCEMENT: 'Action'
    BLACKBOARD_UPDATE_ATTENDANCE_RECORD: 'Action'
    BLACKBOARD_UPDATE_ATTENDANCE_RECORDS: 'Action'
    BLACKBOARD_UPDATE_CALENDAR_ITEM: 'Action'
    BLACKBOARD_UPDATE_CATEGORY: 'Action'
    BLACKBOARD_UPDATE_COLUMN_ATTEMPT: 'Action'
    BLACKBOARD_UPDATE_COLUMN_GRADE: 'Action'
    BLACKBOARD_UPDATE_CONTENT: 'Action'
    BLACKBOARD_UPDATE_COURSE: 'Action'
    BLACKBOARD_UPDATE_COURSE_MEETING: 'Action'
    BLACKBOARD_UPDATE_DATA_SOURCE: 'Action'
    BLACKBOARD_UPDATE_DISCUSSION: 'Action'
    BLACKBOARD_UPDATE_DOMAIN_CONFIG: 'Action'
    BLACKBOARD_UPDATE_GRADE_COLUMN: 'Action'
    BLACKBOARD_UPDATE_GRADE_NOTATION: 'Action'
    BLACKBOARD_UPDATE_GRADING_PERIOD: 'Action'
    BLACKBOARD_UPDATE_GROUP: 'Action'
    BLACKBOARD_UPDATE_GROUP_SET: 'Action'
    BLACKBOARD_UPDATE_MEMBERSHIP: 'Action'
    BLACKBOARD_UPDATE_MESSAGE: 'Action'
    BLACKBOARD_UPDATE_NODE: 'Action'
    BLACKBOARD_UPDATE_NODE_COURSE_ASSOCIATION: 'Action'
    BLACKBOARD_UPDATE_PLACEMENT: 'Action'
    BLACKBOARD_UPDATE_PRONOUN: 'Action'
    BLACKBOARD_UPDATE_QUESTION: 'Action'
    BLACKBOARD_UPDATE_REVIEW_STATUS: 'Action'
    BLACKBOARD_UPDATE_RUBRIC: 'Action'
    BLACKBOARD_UPDATE_RUBRIC_ASSOCIATION: 'Action'
    BLACKBOARD_UPDATE_RUBRIC_EVALUATION: 'Action'
    BLACKBOARD_UPDATE_TERM: 'Action'
    BLACKBOARD_UPDATE_TOC_ITEM: 'Action'
    BLACKBOARD_UPDATE_USER: 'Action'
    BLACKBOARD_UPLOAD: 'Action'
    BLACKBOARD_VIEW_COURSE_GROUP_ACCESSIBILITIES: 'Action'
    BREVO_ACTIVATE_THE_E_COMMERCE_APP: 'Action'
    BREVO_ADD_A_NEW_DOMAIN_TO_THE_LIST_OF_BLOCKED_DOMAINS: 'Action'
    BREVO_ADD_EMAIL_AND_OR_SMS_CREDITS_TO_A_SPECIFIC_CHILD_ACCOUNT: 'Action'
    BREVO_ADD_EXISTING_CONTACTS_TO_A_LIST: 'Action'
    BREVO_AGGREGATE_EMAIL_ACTIVITY: 'Action'
    BREVO_ASSOCIATE_A_DEDICATED_IP_TO_THE_CHILD: 'Action'
    BREVO_AUTHENTICATE_A_DOMAIN: 'Action'
    BREVO_CHECK_ADMIN_USER_PERMISSIONS: 'Action'
    BREVO_CHECK_RESELLER_CHILD_ACCOUNT_CREATION_STATUS: 'Action'
    BREVO_CHECK_USER_PERMISSION: 'Action'
    BREVO_CREATES_AN_SMS_CAMPAIGN: 'Action'
    BREVO_CREATES_A_RESELLER_CHILD: 'Action'
    BREVO_CREATE_AND_SEND_A_WHATS_APP_CAMPAIGN: 'Action'
    BREVO_CREATE_AN_API_KEY_FOR_A_SUB_ACCOUNT: 'Action'
    BREVO_CREATE_AN_EMAIL_CAMPAIGN: 'Action'
    BREVO_CREATE_AN_EMAIL_TEMPLATE: 'Action'
    BREVO_CREATE_AN_EVENT: 'Action'
    BREVO_CREATE_AN_EXTERNAL_FEED: 'Action'
    BREVO_CREATE_A_COMPANY: 'Action'
    BREVO_CREATE_A_CONTACT: 'Action'
    BREVO_CREATE_A_COUPON_COLLECTION: 'Action'
    BREVO_CREATE_A_DEAL: 'Action'
    BREVO_CREATE_A_DOMAIN_FOR_A_CHILD_ACCOUNT: 'Action'
    BREVO_CREATE_A_FOLDER: 'Action'
    BREVO_CREATE_A_GROUP_OF_SUB_ACCOUNTS: 'Action'
    BREVO_CREATE_A_LIST: 'Action'
    BREVO_CREATE_A_NEW_DOMAIN: 'Action'
    BREVO_CREATE_A_NEW_SENDER: 'Action'
    BREVO_CREATE_A_NEW_SUB_ACCOUNT_UNDER_A_MASTER_ACCOUNT: 'Action'
    BREVO_CREATE_A_NOTE: 'Action'
    BREVO_CREATE_A_TASK: 'Action'
    BREVO_CREATE_A_WEBHOOK: 'Action'
    BREVO_CREATE_A_WHATS_APP_TEMPLATE: 'Action'
    BREVO_CREATE_CATEGORIES_IN_BATCH: 'Action'
    BREVO_CREATE_CONTACT_ATTRIBUTE: 'Action'
    BREVO_CREATE_CONTACT_VIA_DOI_DOUBLE_OPT_IN_FLOW: 'Action'
    BREVO_CREATE_COUPONS_FOR_A_COUPON_COLLECTION: 'Action'
    BREVO_CREATE_ORDERS_IN_BATCH: 'Action'
    BREVO_CREATE_PRODUCTS_IN_BATCH: 'Action'
    BREVO_CREATE_UPDATE_A_CATEGORY: 'Action'
    BREVO_CREATE_UPDATE_A_PRODUCT: 'Action'
    BREVO_DELETE_AN_ATTRIBUTE: 'Action'
    BREVO_DELETE_AN_AUTOMATED_MESSAGE: 'Action'
    BREVO_DELETE_AN_EMAIL_CAMPAIGN: 'Action'
    BREVO_DELETE_AN_EXTERNAL_FEED: 'Action'
    BREVO_DELETE_AN_INACTIVE_EMAIL_TEMPLATE: 'Action'
    BREVO_DELETE_AN_SMS_CAMPAIGN: 'Action'
    BREVO_DELETE_AN_SMTP_TRANSACTIONAL_LOG: 'Action'
    BREVO_DELETE_A_COMPANY: 'Action'
    BREVO_DELETE_A_CONTACT: 'Action'
    BREVO_DELETE_A_CONTACT_FROM_A_LIST: 'Action'
    BREVO_DELETE_A_DEAL: 'Action'
    BREVO_DELETE_A_DOMAIN: 'Action'
    BREVO_DELETE_A_FILE: 'Action'
    BREVO_DELETE_A_FOLDER_AND_ALL_ITS_LISTS: 'Action'
    BREVO_DELETE_A_GROUP: 'Action'
    BREVO_DELETE_A_LIST: 'Action'
    BREVO_DELETE_A_MESSAGE_SENT_BY_AN_AGENT: 'Action'
    BREVO_DELETE_A_NOTE: 'Action'
    BREVO_DELETE_A_SENDER: 'Action'
    BREVO_DELETE_A_SUB_ACCOUNT: 'Action'
    BREVO_DELETE_A_TASK: 'Action'
    BREVO_DELETE_A_WEBHOOK: 'Action'
    BREVO_DELETE_A_WHATS_APP_CAMPAIGN: 'Action'
    BREVO_DELETE_HARDBOUNCES: 'Action'
    BREVO_DELETE_RESELLER_CHILD_BY_ID: 'Action'
    BREVO_DELETE_SCHEDULED_EMAILS_BY_BATCH_ID_OR_MESSAGE_ID: 'Action'
    BREVO_DELETE_SUB_ACCOUNT_FROM_GROUP: 'Action'
    BREVO_DISSOCIATE_A_DEDICATED_IP_TO_THE_CHILD: 'Action'
    BREVO_DOWNLOAD_A_FILE: 'Action'
    BREVO_ENABLE_DISABLE_SUB_ACCOUNT_APPLICATION_S: 'Action'
    BREVO_EXPORT_ALL_WEBHOOK_EVENTS: 'Action'
    BREVO_EXPORT_AN_SMS_CAMPAIGN_S_RECIPIENTS: 'Action'
    BREVO_EXPORT_CONTACTS: 'Action'
    BREVO_EXPORT_THE_RECIPIENTS_OF_AN_EMAIL_CAMPAIGN: 'Action'
    BREVO_FETCH_ALL_EVENTS_HISTORY_FOR_ONE_PARTICULAR_RECEIVED_EMAIL: 'Action'
    BREVO_FETCH_ALL_EXTERNAL_FEEDS: 'Action'
    BREVO_FETCH_SCHEDULED_EMAILS_BY_BATCH_ID_OR_MESSAGE_ID: 'Action'
    BREVO_FILTER_TRANSACTIONAL_EMAILS_LIST: 'Action'
    BREVO_GENERATE_SSO_TOKEN_TO_ACCESS_ADMIN_ACCOUNT: 'Action'
    BREVO_GENERATE_SSO_TOKEN_TO_ACCESS_SUB_ACCOUNT: 'Action'
    BREVO_GET_ALL_COMPANIES: 'Action'
    BREVO_GET_ALL_DEALS: 'Action'
    BREVO_GET_ALL_FILES: 'Action'
    BREVO_GET_ALL_FOLDERS: 'Action'
    BREVO_GET_ALL_NOTES: 'Action'
    BREVO_GET_ALL_PIPELINES: 'Action'
    BREVO_GET_ALL_SENDER_DOMAINS_FOR_A_SPECIFIC_CHILD_ACCOUNT: 'Action'
    BREVO_GET_ALL_TASKS: 'Action'
    BREVO_GET_ALL_TASK_TYPES: 'Action'
    BREVO_GET_ALL_THE_CONTACTS: 'Action'
    BREVO_GET_ALL_THE_DEDICATED_IPS_FOR_A_SENDER: 'Action'
    BREVO_GET_ALL_THE_DEDICATED_IPS_FOR_YOUR_ACCOUNT: 'Action'
    BREVO_GET_ALL_THE_LISTS: 'Action'
    BREVO_GET_ALL_THE_SEGMENTS: 'Action'
    BREVO_GET_ALL_WEBHOOKS: 'Action'
    BREVO_GET_ALL_YOUR_COUPON_COLLECTIONS: 'Action'
    BREVO_GET_ALL_YOUR_SMS_ACTIVITY_UNAGGREGATED_EVENTS: 'Action'
    BREVO_GET_ALL_YOUR_TRANSACTIONAL_EMAIL_ACTIVITY_UNAGGREGATED_EVENTS: 'Action'
    BREVO_GET_ALL_YOUR_WHATS_APP_ACTIVITY_UNAGGREGATED_EVENTS: 'Action'
    BREVO_GET_AN_AUTOMATED_MESSAGE: 'Action'
    BREVO_GET_AN_A_B_TEST_EMAIL_CAMPAIGN_RESULTS: 'Action'
    BREVO_GET_AN_EMAIL_CAMPAIGN_REPORT: 'Action'
    BREVO_GET_AN_EXTERNAL_FEED_BY_UUID: 'Action'
    BREVO_GET_AN_SMS_CAMPAIGN: 'Action'
    BREVO_GET_A_CATEGORY_DETAILS: 'Action'
    BREVO_GET_A_CHILD_ACCOUNT_S_DETAILS: 'Action'
    BREVO_GET_A_COMPANY: 'Action'
    BREVO_GET_A_CONTACT_S_DETAILS: 'Action'
    BREVO_GET_A_COUPON_COLLECTION_BY_ID: 'Action'
    BREVO_GET_A_DEAL: 'Action'
    BREVO_GET_A_GROUP_DETAILS: 'Action'
    BREVO_GET_A_LIST_S_DETAILS: 'Action'
    BREVO_GET_A_MESSAGE: 'Action'
    BREVO_GET_A_NOTE: 'Action'
    BREVO_GET_A_PIPELINE: 'Action'
    BREVO_GET_A_PRODUCT_S_DETAILS: 'Action'
    BREVO_GET_A_SHARED_TEMPLATE_URL: 'Action'
    BREVO_GET_A_TASK: 'Action'
    BREVO_GET_A_WEBHOOK_DETAILS: 'Action'
    BREVO_GET_A_WHATS_APP_CAMPAIGN: 'Action'
    BREVO_GET_COMPANY_ATTRIBUTES: 'Action'
    BREVO_GET_CONTACTS_IN_A_LIST: 'Action'
    BREVO_GET_DEAL_ATTRIBUTES: 'Action'
    BREVO_GET_EMAIL_CAMPAIGNS_STATISTICS_FOR_A_CONTACT: 'Action'
    BREVO_GET_FILE_DETAILS: 'Action'
    BREVO_GET_LISTS_IN_A_FOLDER: 'Action'
    BREVO_GET_ORDER_DETAILS: 'Action'
    BREVO_GET_PIPELINE_STAGES: 'Action'
    BREVO_GET_SESSION_TOKEN_TO_ACCESS_BREVO_SSO: 'Action'
    BREVO_GET_SUB_ACCOUNT_DETAILS: 'Action'
    BREVO_GET_THE_DETAILS_OF_REQUESTED_MASTER_ACCOUNT: 'Action'
    BREVO_GET_THE_LIST_OF_ALL_ADMIN_USERS: 'Action'
    BREVO_GET_THE_LIST_OF_ALL_CHILDREN_ACCOUNTS: 'Action'
    BREVO_GET_THE_LIST_OF_ALL_THE_EVENTS_FOR_THE_RECEIVED_EMAILS: 'Action'
    BREVO_GET_THE_LIST_OF_ALL_THE_SUB_ACCOUNTS_OF_THE_MASTER_ACCOUNT: 'Action'
    BREVO_GET_THE_LIST_OF_ALL_YOUR_DOMAINS: 'Action'
    BREVO_GET_THE_LIST_OF_ALL_YOUR_SENDERS: 'Action'
    BREVO_GET_THE_LIST_OF_ALL_YOUR_USERS: 'Action'
    BREVO_GET_THE_LIST_OF_BLOCKED_DOMAINS: 'Action'
    BREVO_GET_THE_LIST_OF_BLOCKED_OR_UNSUBSCRIBED_TRANSACTIONAL_CONTACTS: 'Action'
    BREVO_GET_THE_LIST_OF_EMAIL_TEMPLATES: 'Action'
    BREVO_GET_THE_LIST_OF_GROUPS: 'Action'
    BREVO_GET_THE_PERSONALIZED_CONTENT_OF_A_SENT_TRANSACTIONAL_EMAIL: 'Action'
    BREVO_GET_USER_ACTIVITY_LOGS: 'Action'
    BREVO_GET_YOUR_ACCOUNT_INFORMATION_PLAN_AND_CREDITS_DETAILS: 'Action'
    BREVO_GET_YOUR_SMS_ACTIVITY_AGGREGATED_OVER_A_PERIOD_OF_TIME: 'Action'
    BREVO_GET_YOUR_SMS_ACTIVITY_AGGREGATED_PER_DAY: 'Action'
    BREVO_GET_YOUR_TRANSACTIONAL_EMAIL_ACTIVITY_AGGREGATED_PER_DAY: 'Action'
    BREVO_GET_YOUR_WHATS_APP_API_ACCOUNT_INFORMATION: 'Action'
    BREVO_IMPORT_CONTACTS: 'Action'
    BREVO_LINK_AND_UNLINK_A_DEAL_WITH_CONTACTS_AND_COMPANIES: 'Action'
    BREVO_LINK_AND_UNLINK_COMPANY_WITH_CONTACT_AND_DEAL: 'Action'
    BREVO_LIST_ALL_ATTRIBUTES: 'Action'
    BREVO_MANAGING_THE_STATUS_OF_THE_ORDER: 'Action'
    BREVO_REMOVE_EMAIL_AND_OR_SMS_CREDITS_FROM_A_SPECIFIC_CHILD_ACCOUNT: 'Action'
    BREVO_REMOVE_RESELLER_CHILD_S_SENDER_DOMAIN: 'Action'
    BREVO_RESEND_CANCEL_ADMIN_USER_INVITATION: 'Action'
    BREVO_RESEND_CANCEL_INVITATION: 'Action'
    BREVO_RETRIEVE_INBOUND_ATTACHMENT_WITH_DOWNLOAD_TOKEN: 'Action'
    BREVO_RETURNS_A_FOLDER_S_DETAILS: 'Action'
    BREVO_RETURNS_THE_INFORMATION_FOR_ALL_YOUR_CREATED_SMS_CAMPAIGNS: 'Action'
    BREVO_RETURNS_THE_TEMPLATE_INFORMATION: 'Action'
    BREVO_RETURN_ALL_THE_PROCESSES_FOR_YOUR_ACCOUNT: 'Action'
    BREVO_RETURN_ALL_YOUR_CATEGORIES: 'Action'
    BREVO_RETURN_ALL_YOUR_CREATED_EMAIL_CAMPAIGNS: 'Action'
    BREVO_RETURN_ALL_YOUR_CREATED_WHATS_APP_CAMPAIGNS: 'Action'
    BREVO_RETURN_ALL_YOUR_CREATED_WHATS_APP_TEMPLATES: 'Action'
    BREVO_RETURN_ALL_YOUR_PRODUCTS: 'Action'
    BREVO_RETURN_THE_INFORMATIONS_FOR_A_PROCESS: 'Action'
    BREVO_REVOKE_AN_ADMIN_USER: 'Action'
    BREVO_REVOKE_USER_PERMISSION: 'Action'
    BREVO_SEND_AN_AUTOMATED_MESSAGE_TO_A_VISITOR: 'Action'
    BREVO_SEND_AN_EMAIL_CAMPAIGN_IMMEDIATELY_BASED_ON_CAMPAIGN_ID: 'Action'
    BREVO_SEND_AN_EMAIL_CAMPAIGN_TO_YOUR_TEST_LIST: 'Action'
    BREVO_SEND_AN_SMS_CAMPAIGN_S_REPORT: 'Action'
    BREVO_SEND_A_MESSAGE_AS_AN_AGENT: 'Action'
    BREVO_SEND_A_TEMPLATE_TO_YOUR_TEST_LIST: 'Action'
    BREVO_SEND_A_TEST_SMS_CAMPAIGN: 'Action'
    BREVO_SEND_A_TRANSACTIONAL_EMAIL: 'Action'
    BREVO_SEND_A_WHATS_APP_MESSAGE: 'Action'
    BREVO_SEND_INVITATION_TO_AN_ADMIN_USER: 'Action'
    BREVO_SEND_INVITATION_TO_USER: 'Action'
    BREVO_SEND_SMS_MESSAGE_TO_A_MOBILE_NUMBER: 'Action'
    BREVO_SEND_THE_REPORT_OF_A_CAMPAIGN: 'Action'
    BREVO_SEND_YOUR_SMS_CAMPAIGN_IMMEDIATELY: 'Action'
    BREVO_SEND_YOUR_WHATS_APP_TEMPLATE_FOR_APPROVAL: 'Action'
    BREVO_SETS_AGENT_S_STATUS_TO_ONLINE_FOR_2_3_MINUTES: 'Action'
    BREVO_UNBLOCK_AN_EXISTING_DOMAIN_FROM_THE_LIST_OF_BLOCKED_DOMAINS: 'Action'
    BREVO_UNBLOCK_OR_RESUBSCRIBE_A_TRANSACTIONAL_CONTACT: 'Action'
    BREVO_UPDATE_AN_AUTOMATED_MESSAGE: 'Action'
    BREVO_UPDATE_AN_EMAIL_CAMPAIGN: 'Action'
    BREVO_UPDATE_AN_EMAIL_CAMPAIGN_STATUS: 'Action'
    BREVO_UPDATE_AN_EMAIL_TEMPLATE: 'Action'
    BREVO_UPDATE_AN_EXTERNAL_FEED: 'Action'
    BREVO_UPDATE_AN_SMS_CAMPAIGN: 'Action'
    BREVO_UPDATE_A_CAMPAIGN_S_STATUS: 'Action'
    BREVO_UPDATE_A_COMPANY: 'Action'
    BREVO_UPDATE_A_CONTACT: 'Action'
    BREVO_UPDATE_A_COUPON_COLLECTION_BY_ID: 'Action'
    BREVO_UPDATE_A_DEAL: 'Action'
    BREVO_UPDATE_A_FOLDER: 'Action'
    BREVO_UPDATE_A_GROUP_OF_SUB_ACCOUNTS: 'Action'
    BREVO_UPDATE_A_LIST: 'Action'
    BREVO_UPDATE_A_MESSAGE_SENT_BY_AN_AGENT: 'Action'
    BREVO_UPDATE_A_NOTE: 'Action'
    BREVO_UPDATE_A_SENDER: 'Action'
    BREVO_UPDATE_A_TASK: 'Action'
    BREVO_UPDATE_A_WEBHOOK: 'Action'
    BREVO_UPDATE_A_WHATS_APP_CAMPAIGN: 'Action'
    BREVO_UPDATE_CHILD_ACCOUNT_STATUS_BY_IDENTIFIER: 'Action'
    BREVO_UPDATE_CHILD_INFO_BASED_ON_ID: 'Action'
    BREVO_UPDATE_CONTACT_ATTRIBUTE: 'Action'
    BREVO_UPDATE_MULTIPLE_CONTACTS: 'Action'
    BREVO_UPDATE_PERMISSION_FOR_A_USER: 'Action'
    BREVO_UPDATE_RESELLER_CHILD_S_SENDER_DOMAIN: 'Action'
    BREVO_UPDATE_SUB_ACCOUNT_PLAN: 'Action'
    BREVO_UPLOAD_AN_IMAGE_TO_YOUR_ACCOUNT_S_IMAGE_GALLERY: 'Action'
    BREVO_UPLOAD_A_FILE: 'Action'
    BREVO_VALIDATE_DOMAIN_CONFIGURATION: 'Action'
    BREVO_VALIDATE_SENDER_USING_OTP: 'Action'
    BROWSERBASE_TOOL_BROWSERBASE_LOAD_TOOL: 'Action'
    BROWSER_TOOL_CLICK_ELEMENT: 'Action'
    BROWSER_TOOL_GET_ELEMENT_DETAILS: 'Action'
    BROWSER_TOOL_GET_PAGE_DETAILS: 'Action'
    BROWSER_TOOL_GET_SCREENSHOT: 'Action'
    BROWSER_TOOL_GOTO_PAGE: 'Action'
    BROWSER_TOOL_NAVIGATE_HISTORY: 'Action'
    BROWSER_TOOL_REFRESH_PAGE: 'Action'
    BROWSER_TOOL_SCROLL_PAGE: 'Action'
    BROWSER_TOOL_TYPE_TEXT: 'Action'
    CALENDLY_CANCEL_EVENT: 'Action'
    CALENDLY_CREATE_INVITEE_NO_SHOW: 'Action'
    CALENDLY_CREATE_ONE_OFF_EVENT_TYPE: 'Action'
    CALENDLY_CREATE_SHARE: 'Action'
    CALENDLY_CREATE_SINGLE_USE_SCHEDULING_LINK: 'Action'
    CALENDLY_CREATE_WEBHOOK_SUBSCRIPTION: 'Action'
    CALENDLY_DELETE_INVITEE_DATA: 'Action'
    CALENDLY_DELETE_INVITEE_NO_SHOW: 'Action'
    CALENDLY_DELETE_SCHEDULED_EVENT_DATA: 'Action'
    CALENDLY_DELETE_WEBHOOK_SUBSCRIPTION: 'Action'
    CALENDLY_GET_CURRENT_USER: 'Action'
    CALENDLY_GET_EVENT: 'Action'
    CALENDLY_GET_EVENT_INVITEE: 'Action'
    CALENDLY_GET_EVENT_TYPE: 'Action'
    CALENDLY_GET_GROUP: 'Action'
    CALENDLY_GET_GROUP_RELATIONSHIP: 'Action'
    CALENDLY_GET_INVITEE_NO_SHOW: 'Action'
    CALENDLY_GET_ORGANIZATION_INVITATION: 'Action'
    CALENDLY_GET_ORGANIZATION_MEMBERSHIP: 'Action'
    CALENDLY_GET_ROUTING_FORM: 'Action'
    CALENDLY_GET_USER: 'Action'
    CALENDLY_GET_USER_AVAILABILITY_SCHEDULE: 'Action'
    CALENDLY_GET_WEBHOOK_SUBSCRIPTION: 'Action'
    CALENDLY_INVITE_USER_TO_ORGANIZATION: 'Action'
    CALENDLY_LIST_ACTIVITY_LOG_ENTRIES: 'Action'
    CALENDLY_LIST_EVENTS: 'Action'
    CALENDLY_LIST_EVENT_INVITEES: 'Action'
    CALENDLY_LIST_EVENT_TYPE_AVAILABLE_TIMES: 'Action'
    CALENDLY_LIST_EVENT_TYPE_HOSTS: 'Action'
    CALENDLY_LIST_GROUPS: 'Action'
    CALENDLY_LIST_GROUP_RELATIONSHIPS: 'Action'
    CALENDLY_LIST_ORGANIZATION_INVITATIONS: 'Action'
    CALENDLY_LIST_ORGANIZATION_MEMBERSHIPS: 'Action'
    CALENDLY_LIST_OUTGOING_COMMUNICATIONS: 'Action'
    CALENDLY_LIST_ROUTING_FORMS: 'Action'
    CALENDLY_LIST_USER_AVAILABILITY_SCHEDULES: 'Action'
    CALENDLY_LIST_USER_BUSY_TIMES: 'Action'
    CALENDLY_LIST_USER_S_EVENT_TYPES: 'Action'
    CALENDLY_LIST_WEBHOOK_SUBSCRIPTIONS: 'Action'
    CALENDLY_REMOVE_USER_FROM_ORGANIZATION: 'Action'
    CALENDLY_REVOKE_USER_S_ORGANIZATION_INVITATION: 'Action'
    CANVAS_CREATE_ASSIGNMENT: 'Action'
    CANVAS_DELETE_ASSIGNMENT: 'Action'
    CANVAS_EDIT_ASSIGNMENT: 'Action'
    CANVAS_GET_ALL_ASSIGNMENTS: 'Action'
    CANVAS_GET_ASSIGNMENT: 'Action'
    CLICKUP_ADD_DEPENDENCY: 'Action'
    CLICKUP_ADD_GUEST_TO_FOLDER: 'Action'
    CLICKUP_ADD_GUEST_TO_LIST: 'Action'
    CLICKUP_ADD_GUEST_TO_TASK: 'Action'
    CLICKUP_ADD_TAGS_FROM_TIME_ENTRIES: 'Action'
    CLICKUP_ADD_TAG_TO_TASK: 'Action'
    CLICKUP_ADD_TASK_LINK: 'Action'
    CLICKUP_ADD_TASK_TO_LIST: 'Action'
    CLICKUP_AUTHORIZATION_GET_WORK_SPACE_LIST: 'Action'
    CLICKUP_AUTHORIZATION_VIEW_ACCOUNT_DETAILS: 'Action'
    CLICKUP_CHANGE_TAG_NAMES_FROM_TIME_ENTRIES: 'Action'
    CLICKUP_CREATE_A_TIME_ENTRY: 'Action'
    CLICKUP_CREATE_CHAT_VIEW_COMMENT: 'Action'
    CLICKUP_CREATE_CHECKLIST: 'Action'
    CLICKUP_CREATE_CHECKLIST_ITEM: 'Action'
    CLICKUP_CREATE_FOLDER: 'Action'
    CLICKUP_CREATE_FOLDERLESS_LIST: 'Action'
    CLICKUP_CREATE_FOLDER_VIEW: 'Action'
    CLICKUP_CREATE_GOAL: 'Action'
    CLICKUP_CREATE_KEY_RESULT: 'Action'
    CLICKUP_CREATE_LIST: 'Action'
    CLICKUP_CREATE_LIST_COMMENT: 'Action'
    CLICKUP_CREATE_LIST_VIEW: 'Action'
    CLICKUP_CREATE_SPACE: 'Action'
    CLICKUP_CREATE_SPACE_TAG: 'Action'
    CLICKUP_CREATE_SPACE_VIEW: 'Action'
    CLICKUP_CREATE_TASK: 'Action'
    CLICKUP_CREATE_TASK_ATTACHMENT: 'Action'
    CLICKUP_CREATE_TASK_COMMENT: 'Action'
    CLICKUP_CREATE_TASK_FROM_TEMPLATE: 'Action'
    CLICKUP_CREATE_TEAM: 'Action'
    CLICKUP_CREATE_WEBHOOK: 'Action'
    CLICKUP_CREATE_WORKSPACE_EVERYTHING_LEVEL_VIEW: 'Action'
    CLICKUP_DELETE_A_TIME_ENTRY: 'Action'
    CLICKUP_DELETE_CHECKLIST: 'Action'
    CLICKUP_DELETE_CHECKLIST_ITEM: 'Action'
    CLICKUP_DELETE_COMMENT: 'Action'
    CLICKUP_DELETE_DEPENDENCY: 'Action'
    CLICKUP_DELETE_FOLDER: 'Action'
    CLICKUP_DELETE_GOAL: 'Action'
    CLICKUP_DELETE_KEY_RESULT: 'Action'
    CLICKUP_DELETE_LIST: 'Action'
    CLICKUP_DELETE_SPACE: 'Action'
    CLICKUP_DELETE_SPACE_TAG: 'Action'
    CLICKUP_DELETE_TASK: 'Action'
    CLICKUP_DELETE_TASK_LINK: 'Action'
    CLICKUP_DELETE_TEAM: 'Action'
    CLICKUP_DELETE_TIME_TRACKED: 'Action'
    CLICKUP_DELETE_VIEW: 'Action'
    CLICKUP_DELETE_WEBHOOK: 'Action'
    CLICKUP_EDIT_CHECKLIST: 'Action'
    CLICKUP_EDIT_CHECKLIST_ITEM: 'Action'
    CLICKUP_EDIT_GUEST_ON_WORKSPACE: 'Action'
    CLICKUP_EDIT_KEY_RESULT: 'Action'
    CLICKUP_EDIT_SPACE_TAG: 'Action'
    CLICKUP_EDIT_TIME_TRACKED: 'Action'
    CLICKUP_EDIT_USER_ON_WORKSPACE: 'Action'
    CLICKUP_GET_ACCESSIBLE_CUSTOM_FIELDS: 'Action'
    CLICKUP_GET_ACCESS_TOKEN: 'Action'
    CLICKUP_GET_ALL_TAGS_FROM_TIME_ENTRIES: 'Action'
    CLICKUP_GET_AUTHORIZED_TEAMS_WORKSPACES: 'Action'
    CLICKUP_GET_AUTHORIZED_USER: 'Action'
    CLICKUP_GET_BULK_TASKS_TIME_IN_STATUS: 'Action'
    CLICKUP_GET_CHAT_VIEW_COMMENTS: 'Action'
    CLICKUP_GET_CUSTOM_ROLES: 'Action'
    CLICKUP_GET_CUSTOM_TASK_TYPES: 'Action'
    CLICKUP_GET_FILTERED_TEAM_TASKS: 'Action'
    CLICKUP_GET_FOLDER: 'Action'
    CLICKUP_GET_FOLDERLESS_LISTS: 'Action'
    CLICKUP_GET_FOLDERS: 'Action'
    CLICKUP_GET_FOLDER_VIEWS: 'Action'
    CLICKUP_GET_GOAL: 'Action'
    CLICKUP_GET_GOALS: 'Action'
    CLICKUP_GET_GUEST: 'Action'
    CLICKUP_GET_LIST: 'Action'
    CLICKUP_GET_LISTS: 'Action'
    CLICKUP_GET_LIST_COMMENTS: 'Action'
    CLICKUP_GET_LIST_MEMBERS: 'Action'
    CLICKUP_GET_LIST_VIEWS: 'Action'
    CLICKUP_GET_RUNNING_TIME_ENTRY: 'Action'
    CLICKUP_GET_SINGULAR_TIME_ENTRY: 'Action'
    CLICKUP_GET_SPACE: 'Action'
    CLICKUP_GET_SPACES: 'Action'
    CLICKUP_GET_SPACE_TAGS: 'Action'
    CLICKUP_GET_SPACE_VIEWS: 'Action'
    CLICKUP_GET_TASK: 'Action'
    CLICKUP_GET_TASKS: 'Action'
    CLICKUP_GET_TASK_COMMENTS: 'Action'
    CLICKUP_GET_TASK_MEMBERS: 'Action'
    CLICKUP_GET_TASK_S_TIME_IN_STATUS: 'Action'
    CLICKUP_GET_TASK_TEMPLATES: 'Action'
    CLICKUP_GET_TEAMS: 'Action'
    CLICKUP_GET_TIME_ENTRIES_WITHIN_A_DATE_RANGE: 'Action'
    CLICKUP_GET_TIME_ENTRY_HISTORY: 'Action'
    CLICKUP_GET_TRACKED_TIME: 'Action'
    CLICKUP_GET_USER: 'Action'
    CLICKUP_GET_VIEW: 'Action'
    CLICKUP_GET_VIEW_TASKS: 'Action'
    CLICKUP_GET_WEBHOOKS: 'Action'
    CLICKUP_GET_WORKSPACE_EVERYTHING_LEVEL_VIEWS: 'Action'
    CLICKUP_GET_WORKSPACE_PLAN: 'Action'
    CLICKUP_GET_WORKSPACE_SEATS: 'Action'
    CLICKUP_INVITE_GUEST_TO_WORKSPACE: 'Action'
    CLICKUP_INVITE_USER_TO_WORKSPACE: 'Action'
    CLICKUP_REMOVE_CUSTOM_FIELD_VALUE: 'Action'
    CLICKUP_REMOVE_GUEST_FROM_FOLDER: 'Action'
    CLICKUP_REMOVE_GUEST_FROM_LIST: 'Action'
    CLICKUP_REMOVE_GUEST_FROM_TASK: 'Action'
    CLICKUP_REMOVE_GUEST_FROM_WORKSPACE: 'Action'
    CLICKUP_REMOVE_TAGS_FROM_TIME_ENTRIES: 'Action'
    CLICKUP_REMOVE_TAG_FROM_TASK: 'Action'
    CLICKUP_REMOVE_TASK_FROM_LIST: 'Action'
    CLICKUP_REMOVE_USER_FROM_WORKSPACE: 'Action'
    CLICKUP_SET_CUSTOM_FIELD_VALUE: 'Action'
    CLICKUP_SHARED_HIERARCHY: 'Action'
    CLICKUP_START_A_TIME_ENTRY: 'Action'
    CLICKUP_STOP_A_TIME_ENTRY: 'Action'
    CLICKUP_TASKS_GET_TASK_DETAILS: 'Action'
    CLICKUP_TEAMS_WORK_SPACES_GET_WORK_SPACE_PLAN: 'Action'
    CLICKUP_TEAMS_WORK_SPACES_GET_WORK_SPACE_SEATS: 'Action'
    CLICKUP_TRACK_TIME: 'Action'
    CLICKUP_UPDATE_A_TIME_ENTRY: 'Action'
    CLICKUP_UPDATE_COMMENT: 'Action'
    CLICKUP_UPDATE_FOLDER: 'Action'
    CLICKUP_UPDATE_GOAL: 'Action'
    CLICKUP_UPDATE_LIST: 'Action'
    CLICKUP_UPDATE_SPACE: 'Action'
    CLICKUP_UPDATE_TASK: 'Action'
    CLICKUP_UPDATE_TEAM: 'Action'
    CLICKUP_UPDATE_VIEW: 'Action'
    CLICKUP_UPDATE_WEBHOOK: 'Action'
    CLICKUP_VIEWS_GET_EVERYTHING_LEVEL: 'Action'
    CODEINTERPRETER_EXECUTE_CODE: 'Action'
    CODEINTERPRETER_GET_FILE_CMD: 'Action'
    CODEINTERPRETER_RUN_TERMINAL_CMD: 'Action'
    CODE_ANALYSIS_TOOL_CREATE_CODE_MAP: 'Action'
    CODE_ANALYSIS_TOOL_GET_CLASS_INFO: 'Action'
    CODE_ANALYSIS_TOOL_GET_METHOD_BODY: 'Action'
    CODE_ANALYSIS_TOOL_GET_METHOD_SIGNATURE: 'Action'
    CODE_ANALYSIS_TOOL_GET_RELEVANT_CODE: 'Action'
    CODE_FORMAT_TOOL_FORMAT_AND_LINT_CODEBASE: 'Action'
    COMPOSIO_CHECK_ACTIVE_CONNECTION: 'Action'
    COMPOSIO_ENABLE_TRIGGER: 'Action'
    COMPOSIO_EXECUTE_ACTION: 'Action'
    COMPOSIO_INITIATE_CONNECTION: 'Action'
    COMPOSIO_LIST_APPS: 'Action'
    COMPOSIO_LIST_TRIGGERS: 'Action'
    COMPOSIO_RETRIEVE_ACTIONS: 'Action'
    COMPOSIO_RETRIEVE_APPS: 'Action'
    COMPOSIO_WAIT_FOR_CONNECTION: 'Action'
    DISCORDBOT_ADD_GROUP_DM_USER: 'Action'
    DISCORDBOT_ADD_GUILD_MEMBER: 'Action'
    DISCORDBOT_ADD_GUILD_MEMBER_ROLE: 'Action'
    DISCORDBOT_ADD_MY_MESSAGE_REACTION: 'Action'
    DISCORDBOT_ADD_THREAD_MEMBER: 'Action'
    DISCORDBOT_BAN_USER_FROM_GUILD: 'Action'
    DISCORDBOT_BULK_BAN_USERS_FROM_GUILD: 'Action'
    DISCORDBOT_BULK_DELETE_MESSAGES: 'Action'
    DISCORDBOT_CREATEGUILD: 'Action'
    DISCORDBOT_CREATE_APPLICATION_COMMAND: 'Action'
    DISCORDBOT_CREATE_AUTO_MODERATION_RULE: 'Action'
    DISCORDBOT_CREATE_CHANNEL_INVITE: 'Action'
    DISCORDBOT_CREATE_DM: 'Action'
    DISCORDBOT_CREATE_GUILD: 'Action'
    DISCORDBOT_CREATE_GUILD_APPLICATION_COMMAND: 'Action'
    DISCORDBOT_CREATE_GUILD_CHANNEL: 'Action'
    DISCORDBOT_CREATE_GUILD_EMOJI: 'Action'
    DISCORDBOT_CREATE_GUILD_FROM_TEMPLATE: 'Action'
    DISCORDBOT_CREATE_GUILD_ROLE: 'Action'
    DISCORDBOT_CREATE_GUILD_SCHEDULED_EVENT: 'Action'
    DISCORDBOT_CREATE_GUILD_STICKER: 'Action'
    DISCORDBOT_CREATE_GUILD_TEMPLATE: 'Action'
    DISCORDBOT_CREATE_INTERACTION_RESPONSE: 'Action'
    DISCORDBOT_CREATE_MESSAGE: 'Action'
    DISCORDBOT_CREATE_STAGE_INSTANCE: 'Action'
    DISCORDBOT_CREATE_THREAD: 'Action'
    DISCORDBOT_CREATE_THREAD_FROM_MESSAGE: 'Action'
    DISCORDBOT_CREATE_WEBHOOK: 'Action'
    DISCORDBOT_CROSSPOST_MESSAGE: 'Action'
    DISCORDBOT_DELETE_ALL_MESSAGE_REACTIONS: 'Action'
    DISCORDBOT_DELETE_ALL_MESSAGE_REACTIONS_BY_EMOJI: 'Action'
    DISCORDBOT_DELETE_APPLICATION_COMMAND: 'Action'
    DISCORDBOT_DELETE_AUTO_MODERATION_RULE: 'Action'
    DISCORDBOT_DELETE_CHANNEL: 'Action'
    DISCORDBOT_DELETE_CHANNEL_PERMISSION_OVERWRITE: 'Action'
    DISCORDBOT_DELETE_GROUP_DM_USER: 'Action'
    DISCORDBOT_DELETE_GUILD: 'Action'
    DISCORDBOT_DELETE_GUILD_APPLICATION_COMMAND: 'Action'
    DISCORDBOT_DELETE_GUILD_EMOJI: 'Action'
    DISCORDBOT_DELETE_GUILD_INTEGRATION: 'Action'
    DISCORDBOT_DELETE_GUILD_MEMBER: 'Action'
    DISCORDBOT_DELETE_GUILD_MEMBER_ROLE: 'Action'
    DISCORDBOT_DELETE_GUILD_ROLE: 'Action'
    DISCORDBOT_DELETE_GUILD_SCHEDULED_EVENT: 'Action'
    DISCORDBOT_DELETE_GUILD_STICKER: 'Action'
    DISCORDBOT_DELETE_GUILD_TEMPLATE: 'Action'
    DISCORDBOT_DELETE_MESSAGE: 'Action'
    DISCORDBOT_DELETE_MY_MESSAGE_REACTION: 'Action'
    DISCORDBOT_DELETE_ORIGINAL_WEBHOOK_MESSAGE: 'Action'
    DISCORDBOT_DELETE_STAGE_INSTANCE: 'Action'
    DISCORDBOT_DELETE_THREAD_MEMBER: 'Action'
    DISCORDBOT_DELETE_USER_MESSAGE_REACTION: 'Action'
    DISCORDBOT_DELETE_WEBHOOK: 'Action'
    DISCORDBOT_DELETE_WEBHOOK_BY_TOKEN: 'Action'
    DISCORDBOT_DELETE_WEBHOOK_MESSAGE: 'Action'
    DISCORDBOT_EXECUTE_GITHUB_COMPATIBLE_WEBHOOK: 'Action'
    DISCORDBOT_EXECUTE_SLACK_COMPATIBLE_WEBHOOK: 'Action'
    DISCORDBOT_EXECUTE_WEBHOOK: 'Action'
    DISCORDBOT_FOLLOW_CHANNEL: 'Action'
    DISCORDBOT_GETMESSAGE: 'Action'
    DISCORDBOT_GETMYAPPLICATION: 'Action'
    DISCORDBOT_GETMYOAUTH2APPLICATION: 'Action'
    DISCORDBOT_GETMYOAUTH2AUTHORIZATION: 'Action'
    DISCORDBOT_GETMYUSER: 'Action'
    DISCORDBOT_GETPUBLICKEYS: 'Action'
    DISCORDBOT_GETUSER: 'Action'
    DISCORDBOT_GET_ACTIVE_GUILD_THREADS: 'Action'
    DISCORDBOT_GET_APPLICATION: 'Action'
    DISCORDBOT_GET_APPLICATION_COMMAND: 'Action'
    DISCORDBOT_GET_APPLICATION_ROLE_CONNECTIONS_METADATA: 'Action'
    DISCORDBOT_GET_APPLICATION_USER_ROLE_CONNECTION: 'Action'
    DISCORDBOT_GET_AUTO_MODERATION_RULE: 'Action'
    DISCORDBOT_GET_BOT_GATEWAY: 'Action'
    DISCORDBOT_GET_CHANNEL: 'Action'
    DISCORDBOT_GET_GATEWAY: 'Action'
    DISCORDBOT_GET_GUILD: 'Action'
    DISCORDBOT_GET_GUILDS_ONBOARDING: 'Action'
    DISCORDBOT_GET_GUILD_APPLICATION_COMMAND: 'Action'
    DISCORDBOT_GET_GUILD_APPLICATION_COMMAND_PERMISSIONS: 'Action'
    DISCORDBOT_GET_GUILD_BAN: 'Action'
    DISCORDBOT_GET_GUILD_EMOJI: 'Action'
    DISCORDBOT_GET_GUILD_MEMBER: 'Action'
    DISCORDBOT_GET_GUILD_NEW_MEMBER_WELCOME: 'Action'
    DISCORDBOT_GET_GUILD_PREVIEW: 'Action'
    DISCORDBOT_GET_GUILD_SCHEDULED_EVENT: 'Action'
    DISCORDBOT_GET_GUILD_STICKER: 'Action'
    DISCORDBOT_GET_GUILD_TEMPLATE: 'Action'
    DISCORDBOT_GET_GUILD_VANITY_URL: 'Action'
    DISCORDBOT_GET_GUILD_WEBHOOKS: 'Action'
    DISCORDBOT_GET_GUILD_WELCOME_SCREEN: 'Action'
    DISCORDBOT_GET_GUILD_WIDGET: 'Action'
    DISCORDBOT_GET_GUILD_WIDGET_SETTINGS: 'Action'
    DISCORDBOT_GET_MESSAGE: 'Action'
    DISCORDBOT_GET_MY_APPLICATION: 'Action'
    DISCORDBOT_GET_MY_GUILD_MEMBER: 'Action'
    DISCORDBOT_GET_MY_OAUTH2_APPLICATION: 'Action'
    DISCORDBOT_GET_MY_OAUTH2_AUTHORIZATION: 'Action'
    DISCORDBOT_GET_MY_USER: 'Action'
    DISCORDBOT_GET_ORIGINAL_WEBHOOK_MESSAGE: 'Action'
    DISCORDBOT_GET_PUBLIC_KEYS: 'Action'
    DISCORDBOT_GET_STAGE_INSTANCE: 'Action'
    DISCORDBOT_GET_STICKER: 'Action'
    DISCORDBOT_GET_THREAD_MEMBER: 'Action'
    DISCORDBOT_GET_USER: 'Action'
    DISCORDBOT_GET_WEBHOOK: 'Action'
    DISCORDBOT_GET_WEBHOOK_BY_TOKEN: 'Action'
    DISCORDBOT_GET_WEBHOOK_MESSAGE: 'Action'
    DISCORDBOT_INVITE_RESOLVE: 'Action'
    DISCORDBOT_INVITE_REVOKE: 'Action'
    DISCORDBOT_JOIN_THREAD: 'Action'
    DISCORDBOT_LEAVE_GUILD: 'Action'
    DISCORDBOT_LEAVE_THREAD: 'Action'
    DISCORDBOT_LISTMYCONNECTIONS: 'Action'
    DISCORDBOT_LISTMYGUILDS: 'Action'
    DISCORDBOT_LIST_APPLICATION_COMMANDS: 'Action'
    DISCORDBOT_LIST_AUTO_MODERATION_RULES: 'Action'
    DISCORDBOT_LIST_CHANNEL_INVITES: 'Action'
    DISCORDBOT_LIST_CHANNEL_WEBHOOKS: 'Action'
    DISCORDBOT_LIST_GUILD_APPLICATION_COMMANDS: 'Action'
    DISCORDBOT_LIST_GUILD_APPLICATION_COMMAND_PERMISSIONS: 'Action'
    DISCORDBOT_LIST_GUILD_AUDIT_LOG_ENTRIES: 'Action'
    DISCORDBOT_LIST_GUILD_BANS: 'Action'
    DISCORDBOT_LIST_GUILD_CHANNELS: 'Action'
    DISCORDBOT_LIST_GUILD_EMOJIS: 'Action'
    DISCORDBOT_LIST_GUILD_INTEGRATIONS: 'Action'
    DISCORDBOT_LIST_GUILD_INVITES: 'Action'
    DISCORDBOT_LIST_GUILD_MEMBERS: 'Action'
    DISCORDBOT_LIST_GUILD_ROLES: 'Action'
    DISCORDBOT_LIST_GUILD_SCHEDULED_EVENTS: 'Action'
    DISCORDBOT_LIST_GUILD_SCHEDULED_EVENT_USERS: 'Action'
    DISCORDBOT_LIST_GUILD_STICKERS: 'Action'
    DISCORDBOT_LIST_GUILD_TEMPLATES: 'Action'
    DISCORDBOT_LIST_GUILD_VOICE_REGIONS: 'Action'
    DISCORDBOT_LIST_MESSAGES: 'Action'
    DISCORDBOT_LIST_MESSAGE_REACTIONS_BY_EMOJI: 'Action'
    DISCORDBOT_LIST_MY_CONNECTIONS: 'Action'
    DISCORDBOT_LIST_MY_GUILDS: 'Action'
    DISCORDBOT_LIST_MY_PRIVATE_ARCHIVED_THREADS: 'Action'
    DISCORDBOT_LIST_PINNED_MESSAGES: 'Action'
    DISCORDBOT_LIST_PRIVATE_ARCHIVED_THREADS: 'Action'
    DISCORDBOT_LIST_PUBLIC_ARCHIVED_THREADS: 'Action'
    DISCORDBOT_LIST_STICKER_PACKS: 'Action'
    DISCORDBOT_LIST_THREAD_MEMBERS: 'Action'
    DISCORDBOT_LIST_VOICE_REGIONS: 'Action'
    DISCORDBOT_PIN_MESSAGE: 'Action'
    DISCORDBOT_PREVIEW_PRUNE_GUILD: 'Action'
    DISCORDBOT_PRUNE_GUILD: 'Action'
    DISCORDBOT_PUT_GUILDS_ONBOARDING: 'Action'
    DISCORDBOT_SEARCH_GUILD_MEMBERS: 'Action'
    DISCORDBOT_SET_CHANNEL_PERMISSION_OVERWRITE: 'Action'
    DISCORDBOT_SET_GUILD_APPLICATION_COMMAND_PERMISSIONS: 'Action'
    DISCORDBOT_SYNC_GUILD_TEMPLATE: 'Action'
    DISCORDBOT_TRIGGER_TYPING_INDICATOR: 'Action'
    DISCORDBOT_UNBAN_USER_FROM_GUILD: 'Action'
    DISCORDBOT_UNPIN_MESSAGE: 'Action'
    DISCORDBOT_UPDATE_APPLICATION: 'Action'
    DISCORDBOT_UPDATE_APPLICATION_COMMAND: 'Action'
    DISCORDBOT_UPDATE_APPLICATION_USER_ROLE_CONNECTION: 'Action'
    DISCORDBOT_UPDATE_AUTO_MODERATION_RULE: 'Action'
    DISCORDBOT_UPDATE_CHANNEL: 'Action'
    DISCORDBOT_UPDATE_GUILD: 'Action'
    DISCORDBOT_UPDATE_GUILD_APPLICATION_COMMAND: 'Action'
    DISCORDBOT_UPDATE_GUILD_EMOJI: 'Action'
    DISCORDBOT_UPDATE_GUILD_MEMBER: 'Action'
    DISCORDBOT_UPDATE_GUILD_ROLE: 'Action'
    DISCORDBOT_UPDATE_GUILD_SCHEDULED_EVENT: 'Action'
    DISCORDBOT_UPDATE_GUILD_STICKER: 'Action'
    DISCORDBOT_UPDATE_GUILD_TEMPLATE: 'Action'
    DISCORDBOT_UPDATE_GUILD_WELCOME_SCREEN: 'Action'
    DISCORDBOT_UPDATE_GUILD_WIDGET_SETTINGS: 'Action'
    DISCORDBOT_UPDATE_MESSAGE: 'Action'
    DISCORDBOT_UPDATE_MY_APPLICATION: 'Action'
    DISCORDBOT_UPDATE_MY_GUILD_MEMBER: 'Action'
    DISCORDBOT_UPDATE_MY_USER: 'Action'
    DISCORDBOT_UPDATE_ORIGINAL_WEBHOOK_MESSAGE: 'Action'
    DISCORDBOT_UPDATE_SELF_VOICE_STATE: 'Action'
    DISCORDBOT_UPDATE_VOICE_STATE: 'Action'
    DISCORDBOT_UPDATE_WEBHOOK: 'Action'
    DISCORDBOT_UPDATE_WEBHOOK_BY_TOKEN: 'Action'
    DISCORDBOT_UPDATE_WEBHOOK_MESSAGE: 'Action'
    DISCORD_ADD_GROUP_DM_USER: 'Action'
    DISCORD_ADD_GUILD_MEMBER: 'Action'
    DISCORD_ADD_GUILD_MEMBER_ROLE: 'Action'
    DISCORD_ADD_MY_MESSAGE_REACTION: 'Action'
    DISCORD_ADD_THREAD_MEMBER: 'Action'
    DISCORD_BAN_USER_FROM_GUILD: 'Action'
    DISCORD_BULK_BAN_USERS_FROM_GUILD: 'Action'
    DISCORD_BULK_DELETE_MESSAGES: 'Action'
    DISCORD_CREATE_APPLICATION_COMMAND: 'Action'
    DISCORD_CREATE_AUTO_MODERATION_RULE: 'Action'
    DISCORD_CREATE_CHANNEL_INVITE: 'Action'
    DISCORD_CREATE_DM: 'Action'
    DISCORD_CREATE_GUILD: 'Action'
    DISCORD_CREATE_GUILD_APPLICATION_COMMAND: 'Action'
    DISCORD_CREATE_GUILD_CHANNEL: 'Action'
    DISCORD_CREATE_GUILD_EMOJI: 'Action'
    DISCORD_CREATE_GUILD_FROM_TEMPLATE: 'Action'
    DISCORD_CREATE_GUILD_ROLE: 'Action'
    DISCORD_CREATE_GUILD_SCHEDULED_EVENT: 'Action'
    DISCORD_CREATE_GUILD_STICKER: 'Action'
    DISCORD_CREATE_GUILD_TEMPLATE: 'Action'
    DISCORD_CREATE_INTERACTION_RESPONSE: 'Action'
    DISCORD_CREATE_MESSAGE: 'Action'
    DISCORD_CREATE_STAGE_INSTANCE: 'Action'
    DISCORD_CREATE_THREAD: 'Action'
    DISCORD_CREATE_THREAD_FROM_MESSAGE: 'Action'
    DISCORD_CREATE_WEBHOOK: 'Action'
    DISCORD_CROSSPOST_MESSAGE: 'Action'
    DISCORD_DELETE_ALL_MESSAGE_REACTIONS: 'Action'
    DISCORD_DELETE_ALL_MESSAGE_REACTIONS_BY_EMOJI: 'Action'
    DISCORD_DELETE_APPLICATION_COMMAND: 'Action'
    DISCORD_DELETE_AUTO_MODERATION_RULE: 'Action'
    DISCORD_DELETE_CHANNEL: 'Action'
    DISCORD_DELETE_CHANNEL_PERMISSION_OVERWRITE: 'Action'
    DISCORD_DELETE_GROUP_DM_USER: 'Action'
    DISCORD_DELETE_GUILD: 'Action'
    DISCORD_DELETE_GUILD_APPLICATION_COMMAND: 'Action'
    DISCORD_DELETE_GUILD_EMOJI: 'Action'
    DISCORD_DELETE_GUILD_INTEGRATION: 'Action'
    DISCORD_DELETE_GUILD_MEMBER: 'Action'
    DISCORD_DELETE_GUILD_MEMBER_ROLE: 'Action'
    DISCORD_DELETE_GUILD_ROLE: 'Action'
    DISCORD_DELETE_GUILD_SCHEDULED_EVENT: 'Action'
    DISCORD_DELETE_GUILD_STICKER: 'Action'
    DISCORD_DELETE_GUILD_TEMPLATE: 'Action'
    DISCORD_DELETE_MESSAGE: 'Action'
    DISCORD_DELETE_MY_MESSAGE_REACTION: 'Action'
    DISCORD_DELETE_ORIGINAL_WEBHOOK_MESSAGE: 'Action'
    DISCORD_DELETE_STAGE_INSTANCE: 'Action'
    DISCORD_DELETE_THREAD_MEMBER: 'Action'
    DISCORD_DELETE_USER_MESSAGE_REACTION: 'Action'
    DISCORD_DELETE_WEBHOOK: 'Action'
    DISCORD_DELETE_WEBHOOK_BY_TOKEN: 'Action'
    DISCORD_DELETE_WEBHOOK_MESSAGE: 'Action'
    DISCORD_EXECUTE_GITHUB_COMPATIBLE_WEBHOOK: 'Action'
    DISCORD_EXECUTE_SLACK_COMPATIBLE_WEBHOOK: 'Action'
    DISCORD_EXECUTE_WEBHOOK: 'Action'
    DISCORD_FOLLOW_CHANNEL: 'Action'
    DISCORD_GETMYOAUTH2APPLICATION: 'Action'
    DISCORD_GETMYOAUTH2AUTHORIZATION: 'Action'
    DISCORD_GETPUBLICKEYS: 'Action'
    DISCORD_GETUSER: 'Action'
    DISCORD_GET_ACTIVE_GUILD_THREADS: 'Action'
    DISCORD_GET_APPLICATION: 'Action'
    DISCORD_GET_APPLICATION_COMMAND: 'Action'
    DISCORD_GET_APPLICATION_ROLE_CONNECTIONS_METADATA: 'Action'
    DISCORD_GET_APPLICATION_USER_ROLE_CONNECTION: 'Action'
    DISCORD_GET_AUTO_MODERATION_RULE: 'Action'
    DISCORD_GET_BOT_GATEWAY: 'Action'
    DISCORD_GET_CHANNEL: 'Action'
    DISCORD_GET_GATEWAY: 'Action'
    DISCORD_GET_GUILD: 'Action'
    DISCORD_GET_GUILDS_ONBOARDING: 'Action'
    DISCORD_GET_GUILD_APPLICATION_COMMAND: 'Action'
    DISCORD_GET_GUILD_APPLICATION_COMMAND_PERMISSIONS: 'Action'
    DISCORD_GET_GUILD_BAN: 'Action'
    DISCORD_GET_GUILD_EMOJI: 'Action'
    DISCORD_GET_GUILD_MEMBER: 'Action'
    DISCORD_GET_GUILD_NEW_MEMBER_WELCOME: 'Action'
    DISCORD_GET_GUILD_PREVIEW: 'Action'
    DISCORD_GET_GUILD_SCHEDULED_EVENT: 'Action'
    DISCORD_GET_GUILD_STICKER: 'Action'
    DISCORD_GET_GUILD_TEMPLATE: 'Action'
    DISCORD_GET_GUILD_VANITY_URL: 'Action'
    DISCORD_GET_GUILD_WEBHOOKS: 'Action'
    DISCORD_GET_GUILD_WELCOME_SCREEN: 'Action'
    DISCORD_GET_GUILD_WIDGET: 'Action'
    DISCORD_GET_GUILD_WIDGET_SETTINGS: 'Action'
    DISCORD_GET_MESSAGE: 'Action'
    DISCORD_GET_MY_APPLICATION: 'Action'
    DISCORD_GET_MY_GUILD_MEMBER: 'Action'
    DISCORD_GET_MY_OAUTH2_APPLICATION: 'Action'
    DISCORD_GET_MY_OAUTH2_AUTHORIZATION: 'Action'
    DISCORD_GET_MY_USER: 'Action'
    DISCORD_GET_ORIGINAL_WEBHOOK_MESSAGE: 'Action'
    DISCORD_GET_PUBLIC_KEYS: 'Action'
    DISCORD_GET_STAGE_INSTANCE: 'Action'
    DISCORD_GET_STICKER: 'Action'
    DISCORD_GET_THREAD_MEMBER: 'Action'
    DISCORD_GET_USER: 'Action'
    DISCORD_GET_WEBHOOK: 'Action'
    DISCORD_GET_WEBHOOK_BY_TOKEN: 'Action'
    DISCORD_GET_WEBHOOK_MESSAGE: 'Action'
    DISCORD_INVITE_RESOLVE: 'Action'
    DISCORD_INVITE_REVOKE: 'Action'
    DISCORD_JOIN_THREAD: 'Action'
    DISCORD_LEAVE_GUILD: 'Action'
    DISCORD_LEAVE_THREAD: 'Action'
    DISCORD_LISTMYCONNECTIONS: 'Action'
    DISCORD_LISTMYGUILDS: 'Action'
    DISCORD_LIST_APPLICATION_COMMANDS: 'Action'
    DISCORD_LIST_AUTO_MODERATION_RULES: 'Action'
    DISCORD_LIST_CHANNEL_INVITES: 'Action'
    DISCORD_LIST_CHANNEL_WEBHOOKS: 'Action'
    DISCORD_LIST_GUILD_APPLICATION_COMMANDS: 'Action'
    DISCORD_LIST_GUILD_APPLICATION_COMMAND_PERMISSIONS: 'Action'
    DISCORD_LIST_GUILD_AUDIT_LOG_ENTRIES: 'Action'
    DISCORD_LIST_GUILD_BANS: 'Action'
    DISCORD_LIST_GUILD_CHANNELS: 'Action'
    DISCORD_LIST_GUILD_EMOJIS: 'Action'
    DISCORD_LIST_GUILD_INTEGRATIONS: 'Action'
    DISCORD_LIST_GUILD_INVITES: 'Action'
    DISCORD_LIST_GUILD_MEMBERS: 'Action'
    DISCORD_LIST_GUILD_ROLES: 'Action'
    DISCORD_LIST_GUILD_SCHEDULED_EVENTS: 'Action'
    DISCORD_LIST_GUILD_SCHEDULED_EVENT_USERS: 'Action'
    DISCORD_LIST_GUILD_STICKERS: 'Action'
    DISCORD_LIST_GUILD_TEMPLATES: 'Action'
    DISCORD_LIST_GUILD_VOICE_REGIONS: 'Action'
    DISCORD_LIST_MESSAGES: 'Action'
    DISCORD_LIST_MESSAGE_REACTIONS_BY_EMOJI: 'Action'
    DISCORD_LIST_MY_CONNECTIONS: 'Action'
    DISCORD_LIST_MY_GUILDS: 'Action'
    DISCORD_LIST_MY_PRIVATE_ARCHIVED_THREADS: 'Action'
    DISCORD_LIST_PINNED_MESSAGES: 'Action'
    DISCORD_LIST_PRIVATE_ARCHIVED_THREADS: 'Action'
    DISCORD_LIST_PUBLIC_ARCHIVED_THREADS: 'Action'
    DISCORD_LIST_STICKER_PACKS: 'Action'
    DISCORD_LIST_THREAD_MEMBERS: 'Action'
    DISCORD_LIST_VOICE_REGIONS: 'Action'
    DISCORD_PIN_MESSAGE: 'Action'
    DISCORD_PREVIEW_PRUNE_GUILD: 'Action'
    DISCORD_PRUNE_GUILD: 'Action'
    DISCORD_PUT_GUILDS_ONBOARDING: 'Action'
    DISCORD_SEARCH_GUILD_MEMBERS: 'Action'
    DISCORD_SET_CHANNEL_PERMISSION_OVERWRITE: 'Action'
    DISCORD_SET_GUILD_APPLICATION_COMMAND_PERMISSIONS: 'Action'
    DISCORD_SYNC_GUILD_TEMPLATE: 'Action'
    DISCORD_TRIGGER_TYPING_INDICATOR: 'Action'
    DISCORD_UNBAN_USER_FROM_GUILD: 'Action'
    DISCORD_UNPIN_MESSAGE: 'Action'
    DISCORD_UPDATE_APPLICATION: 'Action'
    DISCORD_UPDATE_APPLICATION_COMMAND: 'Action'
    DISCORD_UPDATE_APPLICATION_USER_ROLE_CONNECTION: 'Action'
    DISCORD_UPDATE_AUTO_MODERATION_RULE: 'Action'
    DISCORD_UPDATE_CHANNEL: 'Action'
    DISCORD_UPDATE_GUILD: 'Action'
    DISCORD_UPDATE_GUILD_APPLICATION_COMMAND: 'Action'
    DISCORD_UPDATE_GUILD_EMOJI: 'Action'
    DISCORD_UPDATE_GUILD_MEMBER: 'Action'
    DISCORD_UPDATE_GUILD_ROLE: 'Action'
    DISCORD_UPDATE_GUILD_SCHEDULED_EVENT: 'Action'
    DISCORD_UPDATE_GUILD_STICKER: 'Action'
    DISCORD_UPDATE_GUILD_TEMPLATE: 'Action'
    DISCORD_UPDATE_GUILD_WELCOME_SCREEN: 'Action'
    DISCORD_UPDATE_GUILD_WIDGET_SETTINGS: 'Action'
    DISCORD_UPDATE_MESSAGE: 'Action'
    DISCORD_UPDATE_MY_APPLICATION: 'Action'
    DISCORD_UPDATE_MY_GUILD_MEMBER: 'Action'
    DISCORD_UPDATE_MY_USER: 'Action'
    DISCORD_UPDATE_ORIGINAL_WEBHOOK_MESSAGE: 'Action'
    DISCORD_UPDATE_SELF_VOICE_STATE: 'Action'
    DISCORD_UPDATE_VOICE_STATE: 'Action'
    DISCORD_UPDATE_WEBHOOK: 'Action'
    DISCORD_UPDATE_WEBHOOK_BY_TOKEN: 'Action'
    DISCORD_UPDATE_WEBHOOK_MESSAGE: 'Action'
    DROPBOX_CREATE_FILE_REQUEST: 'Action'
    DROPBOX_CREATE_FOLDER: 'Action'
    DROPBOX_CREATE_PAPER: 'Action'
    DROPBOX_DELETE_FILE_OR_FOLDER: 'Action'
    DROPBOX_GET_ABOUT_ME: 'Action'
    DROPBOX_MOVE_FILE_OR_FOLDER: 'Action'
    DROPBOX_SEARCH_FILE_OR_FOLDER: 'Action'
    DROPBOX_UPLOAD_FILE: 'Action'
    ELEVENLABS_ADD_A_PRONUNCIATION_DICTIONARY: 'Action'
    ELEVENLABS_ADD_PROJECT: 'Action'
    ELEVENLABS_ADD_RULES_TO_THE_PRONUNCIATION_DICTIONARY: 'Action'
    ELEVENLABS_ADD_SHARING_VOICE: 'Action'
    ELEVENLABS_ADD_VOICE: 'Action'
    ELEVENLABS_CONVERT_CHAPTER: 'Action'
    ELEVENLABS_CONVERT_PROJECT: 'Action'
    ELEVENLABS_CREATES_AUDIONATIVE_ENABLED_PROJECT: 'Action'
    ELEVENLABS_CREATE_A_PREVIOUSLY_GENERATED_VOICE: 'Action'
    ELEVENLABS_DELETE_CHAPTER: 'Action'
    ELEVENLABS_DELETE_DUBBING_PROJECT: 'Action'
    ELEVENLABS_DELETE_HISTORY_ITEM: 'Action'
    ELEVENLABS_DELETE_PROJECT: 'Action'
    ELEVENLABS_DELETE_SAMPLE: 'Action'
    ELEVENLABS_DELETE_VOICE: 'Action'
    ELEVENLABS_DOWNLOAD_HISTORY_ITEMS: 'Action'
    ELEVENLABS_DUB_A_VIDEO_OR_AN_AUDIO_FILE: 'Action'
    ELEVENLABS_EDIT_VOICE: 'Action'
    ELEVENLABS_EDIT_VOICE_SETTINGS: 'Action'
    ELEVENLABS_GENERATE_A_RANDOM_VOICE: 'Action'
    ELEVENLABS_GET_AUDIO_FROM_HISTORY_ITEM: 'Action'
    ELEVENLABS_GET_AUDIO_FROM_SAMPLE: 'Action'
    ELEVENLABS_GET_A_PROFILE_PAGE: 'Action'
    ELEVENLABS_GET_CHAPTERS: 'Action'
    ELEVENLABS_GET_CHAPTER_BY_ID: 'Action'
    ELEVENLABS_GET_CHAPTER_SNAPSHOTS: 'Action'
    ELEVENLABS_GET_DEFAULT_VOICE_SETTINGS: 'Action'
    ELEVENLABS_GET_DUBBED_FILE: 'Action'
    ELEVENLABS_GET_DUBBING_PROJECT_METADATA: 'Action'
    ELEVENLABS_GET_GENERATED_ITEMS: 'Action'
    ELEVENLABS_GET_HISTORY_ITEM_BY_ID: 'Action'
    ELEVENLABS_GET_METADATA_FOR_A_PRONUNCIATION_DICTIONARY: 'Action'
    ELEVENLABS_GET_MODELS: 'Action'
    ELEVENLABS_GET_PLS_FILE_WITH_A_PRONUNCIATION_DICTIONARY_VERSION_RULES: 'Action'
    ELEVENLABS_GET_PROJECTS: 'Action'
    ELEVENLABS_GET_PROJECT_BY_ID: 'Action'
    ELEVENLABS_GET_PROJECT_SNAPSHOTS: 'Action'
    ELEVENLABS_GET_PRONUNCIATION_DICTIONARIES: 'Action'
    ELEVENLABS_GET_SHARED_VOICES: 'Action'
    ELEVENLABS_GET_SSO_PROVIDER_ADMIN: 'Action'
    ELEVENLABS_GET_TRANSCRIPT_FOR_DUB: 'Action'
    ELEVENLABS_GET_USER_INFO: 'Action'
    ELEVENLABS_GET_USER_SUBSCRIPTION_INFO: 'Action'
    ELEVENLABS_GET_VOICE: 'Action'
    ELEVENLABS_GET_VOICES: 'Action'
    ELEVENLABS_GET_VOICE_SETTINGS: 'Action'
    ELEVENLABS_REDIRECT_TO_MINTLIFY: 'Action'
    ELEVENLABS_REMOVE_RULES_FROM_THE_PRONUNCIATION_DICTIONARY: 'Action'
    ELEVENLABS_SPEECH_TO_SPEECH: 'Action'
    ELEVENLABS_SPEECH_TO_SPEECH_STREAMING: 'Action'
    ELEVENLABS_STREAMS_ARCHIVE_WITH_PROJECT_AUDIO: 'Action'
    ELEVENLABS_STREAM_CHAPTER_AUDIO: 'Action'
    ELEVENLABS_STREAM_PROJECT_AUDIO: 'Action'
    ELEVENLABS_TEXT_TO_SPEECH: 'Action'
    ELEVENLABS_TEXT_TO_SPEECH_STREAM: 'Action'
    ELEVENLABS_UPDATE_PRONUNCIATION_DICTIONARIES: 'Action'
    ELEVENLABS_VOICE_GENERATION_PARAMETERS: 'Action'
    EMBED_TOOL_CREATE_IMAGE_VECTOR_STORE: 'Action'
    EMBED_TOOL_QUERY_IMAGE_VECTOR_STORE: 'Action'
    ENTELLIGENCE_ADD_A_NEW_REPOSITORY: 'Action'
    ENTELLIGENCE_INTERACT_WITH_THE_REPOSITORY_AGENT: 'Action'
    EXA_SEARCH: 'Action'
    EXA_SIMILARLINK: 'Action'
    FIGMA_ADD_A_COMMENT_TO_A_FILE: 'Action'
    FIGMA_ADD_A_REACTION_TO_A_COMMENT: 'Action'
    FIGMA_CREATE_A_WEBHOOK: 'Action'
    FIGMA_CREATE_DEV_RESOURCES: 'Action'
    FIGMA_CREATE_MODIFY_DELETE_VARIABLES: 'Action'
    FIGMA_DELETE_A_COMMENT: 'Action'
    FIGMA_DELETE_A_REACTION: 'Action'
    FIGMA_DELETE_A_WEBHOOK: 'Action'
    FIGMA_DELETE_DEV_RESOURCE: 'Action'
    FIGMA_GET_ACTIVITY_LOGS: 'Action'
    FIGMA_GET_A_WEBHOOK: 'Action'
    FIGMA_GET_COMMENTS_IN_A_FILE: 'Action'
    FIGMA_GET_COMPONENT: 'Action'
    FIGMA_GET_COMPONENT_SET: 'Action'
    FIGMA_GET_CURRENT_USER: 'Action'
    FIGMA_GET_DEV_RESOURCES: 'Action'
    FIGMA_GET_FILES_IN_A_PROJECT: 'Action'
    FIGMA_GET_FILE_COMPONENTS: 'Action'
    FIGMA_GET_FILE_COMPONENT_SETS: 'Action'
    FIGMA_GET_FILE_JSON: 'Action'
    FIGMA_GET_FILE_JSON_FOR_SPECIFIC_NODES: 'Action'
    FIGMA_GET_FILE_STYLES: 'Action'
    FIGMA_GET_IMAGE_FILLS: 'Action'
    FIGMA_GET_LOCAL_VARIABLES: 'Action'
    FIGMA_GET_ME: 'Action'
    FIGMA_GET_PAYMENTS: 'Action'
    FIGMA_GET_PROJECTS_IN_A_TEAM: 'Action'
    FIGMA_GET_PUBLISHED_VARIABLES: 'Action'
    FIGMA_GET_REACTIONS_FOR_A_COMMENT: 'Action'
    FIGMA_GET_STYLE: 'Action'
    FIGMA_GET_TEAM_COMPONENTS: 'Action'
    FIGMA_GET_TEAM_COMPONENT_SETS: 'Action'
    FIGMA_GET_TEAM_STYLES: 'Action'
    FIGMA_GET_TEAM_WEBHOOKS: 'Action'
    FIGMA_GET_VERSIONS_OF_A_FILE: 'Action'
    FIGMA_GET_WEBHOOK_REQUESTS: 'Action'
    FIGMA_RENDER_IMAGES_OF_FILE_NODES: 'Action'
    FIGMA_UPDATE_A_WEBHOOK: 'Action'
    FIGMA_UPDATE_DEV_RESOURCES: 'Action'
    FILETOOL_CHANGE_WORKING_DIRECTORY: 'Action'
    FILETOOL_CREATE_FILE: 'Action'
    FILETOOL_EDIT_FILE: 'Action'
    FILETOOL_FIND_FILE: 'Action'
    FILETOOL_GIT_CLONE: 'Action'
    FILETOOL_GIT_CUSTOM: 'Action'
    FILETOOL_GIT_PATCH: 'Action'
    FILETOOL_GIT_REPO_TREE: 'Action'
    FILETOOL_LIST_FILES: 'Action'
    FILETOOL_OPEN_FILE: 'Action'
    FILETOOL_RENAME_FILE: 'Action'
    FILETOOL_SCROLL: 'Action'
    FILETOOL_SEARCH_WORD: 'Action'
    FILETOOL_WRITE: 'Action'
    FIRECRAWL_CHECK_CRAWL_STATUS: 'Action'
    FIRECRAWL_CRAWL: 'Action'
    FIRECRAWL_EXTRACT: 'Action'
    FIRECRAWL_SCRAPE: 'Action'
    FIRECRAWL_SEARCH: 'Action'
    FRESHDESK_CREATE_TICKET: 'Action'
    FRESHDESK_DELETE_TICKET: 'Action'
    FRESHDESK_LIST_ALL_TICKETS: 'Action'
    FRESHDESK_UPDATE_TICKET: 'Action'
    FRESHDESK_VIEW_TICKET: 'Action'
    GITHUB_ACCEPT_A_REPOSITORY_INVITATION: 'Action'
    GITHUB_ACTIVITY_LIST_STARGAZERS_FOR_REPO: 'Action'
    GITHUB_ADD_AN_EMAIL_ADDRESS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_ADD_APP_ACCESS_RESTRICTIONS: 'Action'
    GITHUB_ADD_ASSIGNEES_TO_AN_ISSUE: 'Action'
    GITHUB_ADD_A_REPOSITORY_COLLABORATOR: 'Action'
    GITHUB_ADD_A_REPOSITORY_TO_AN_APP_INSTALLATION: 'Action'
    GITHUB_ADD_A_SECURITY_MANAGER_TEAM: 'Action'
    GITHUB_ADD_A_SELECTED_REPOSITORY_TO_A_USER_SECRET: 'Action'
    GITHUB_ADD_CUSTOM_LABELS_TO_A_SELF_HOSTED_RUNNER_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_ADD_CUSTOM_LABELS_TO_A_SELF_HOSTED_RUNNER_FOR_A_REPOSITORY: 'Action'
    GITHUB_ADD_LABELS_TO_AN_ISSUE: 'Action'
    GITHUB_ADD_OR_UPDATE_TEAM_MEMBERSHIP_FOR_A_USER: 'Action'
    GITHUB_ADD_OR_UPDATE_TEAM_MEMBERSHIP_FOR_A_USER_LEGACY: 'Action'
    GITHUB_ADD_OR_UPDATE_TEAM_PROJECT_PERMISSIONS: 'Action'
    GITHUB_ADD_OR_UPDATE_TEAM_PROJECT_PERMISSIONS_LEGACY: 'Action'
    GITHUB_ADD_OR_UPDATE_TEAM_REPOSITORY_PERMISSIONS: 'Action'
    GITHUB_ADD_OR_UPDATE_TEAM_REPOSITORY_PERMISSIONS_LEGACY: 'Action'
    GITHUB_ADD_PROJECT_COLLABORATOR: 'Action'
    GITHUB_ADD_REPO_TO_ORG_SECRET_WITH_SELECTED_ACCESS: 'Action'
    GITHUB_ADD_REPO_TO_ORG_SECRET_WITH_SELECTED_VISIBILITY: 'Action'
    GITHUB_ADD_SELECTED_REPOSITORY_TO_AN_ORGANIZATION_SECRET: 'Action'
    GITHUB_ADD_SELECTED_REPOSITORY_TO_AN_ORGANIZATION_VARIABLE: 'Action'
    GITHUB_ADD_SOCIAL_ACCOUNTS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_ADD_STATUS_CHECK_CONTEXTS: 'Action'
    GITHUB_ADD_TEAMS_TO_THE_COPILOT_SUBSCRIPTION_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_ADD_TEAM_ACCESS_RESTRICTIONS: 'Action'
    GITHUB_ADD_TEAM_MEMBER_LEGACY: 'Action'
    GITHUB_ADD_USERS_TO_CODESPACES_ACCESS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_ADD_USERS_TO_THE_COPILOT_SUBSCRIPTION_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_ADD_USER_ACCESS_RESTRICTIONS: 'Action'
    GITHUB_APPROVE_A_WORKFLOW_RUN_FOR_A_FORK_PULL_REQUEST: 'Action'
    GITHUB_ASSIGN_AN_ORGANIZATION_ROLE_TO_A_TEAM: 'Action'
    GITHUB_ASSIGN_AN_ORGANIZATION_ROLE_TO_A_USER: 'Action'
    GITHUB_AUTH_USER_DOCKER_CONFLICT_PACKAGES_LIST: 'Action'
    GITHUB_BLOCK_A_USER: 'Action'
    GITHUB_BLOCK_A_USER_FROM_AN_ORGANIZATION: 'Action'
    GITHUB_CANCEL_AN_IMPORT: 'Action'
    GITHUB_CANCEL_AN_ORGANIZATION_INVITATION: 'Action'
    GITHUB_CANCEL_A_GITHUB_PAGES_DEPLOYMENT: 'Action'
    GITHUB_CANCEL_A_WORKFLOW_RUN: 'Action'
    GITHUB_CHECK_A_TOKEN: 'Action'
    GITHUB_CHECK_IF_AUTOMATED_SECURITY_FIXES_ARE_ENABLED_FOR_A_REPOSITORY: 'Action'
    GITHUB_CHECK_IF_A_GIST_IS_STARRED: 'Action'
    GITHUB_CHECK_IF_A_PERSON_IS_FOLLOWED_BY_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_CHECK_IF_A_PULL_REQUEST_HAS_BEEN_MERGED: 'Action'
    GITHUB_CHECK_IF_A_REPOSITORY_IS_STARRED_BY_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_CHECK_IF_A_USER_CAN_BE_ASSIGNED: 'Action'
    GITHUB_CHECK_IF_A_USER_CAN_BE_ASSIGNED_TO_A_ISSUE: 'Action'
    GITHUB_CHECK_IF_A_USER_FOLLOWS_ANOTHER_USER: 'Action'
    GITHUB_CHECK_IF_A_USER_IS_A_REPOSITORY_COLLABORATOR: 'Action'
    GITHUB_CHECK_IF_A_USER_IS_BLOCKED_BY_AN_ORGANIZATION: 'Action'
    GITHUB_CHECK_IF_A_USER_IS_BLOCKED_BY_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_CHECK_IF_VULNERABILITY_ALERTS_ARE_ENABLED_FOR_A_REPOSITORY: 'Action'
    GITHUB_CHECK_ORGANIZATION_MEMBERSHIP_FOR_A_USER: 'Action'
    GITHUB_CHECK_PRIVATE_VULNERABILITY_REPORTING_STATUS: 'Action'
    GITHUB_CHECK_PUBLIC_ORGANIZATION_MEMBERSHIP_FOR_A_USER: 'Action'
    GITHUB_CHECK_TEAM_PERMISSIONS_FOR_A_PROJECT: 'Action'
    GITHUB_CHECK_TEAM_PERMISSIONS_FOR_A_PROJECT_LEGACY: 'Action'
    GITHUB_CHECK_TEAM_PERMISSIONS_FOR_A_REPOSITORY: 'Action'
    GITHUB_CHECK_TEAM_PERMISSIONS_FOR_A_REPOSITORY_LEGACY: 'Action'
    GITHUB_CLEAR_REPOSITORY_CACHE_BY_KEY: 'Action'
    GITHUB_CLEAR_SELF_HOSTED_RUNNER_ORG_LABELS: 'Action'
    GITHUB_COMPARE_TWO_COMMITS: 'Action'
    GITHUB_CONFIGURE_JITRUNNER_FOR_ORG: 'Action'
    GITHUB_CONFIGURE_OIDCSUBJECT_CLAIM_TEMPLATE: 'Action'
    GITHUB_CONVERT_AN_ORGANIZATION_MEMBER_TO_OUTSIDE_COLLABORATOR: 'Action'
    GITHUB_CREATE_AN_AUTOLINK_REFERENCE_FOR_A_REPOSITORY: 'Action'
    GITHUB_CREATE_AN_ENVIRONMENT_VARIABLE: 'Action'
    GITHUB_CREATE_AN_ISSUE: 'Action'
    GITHUB_CREATE_AN_ISSUE_COMMENT: 'Action'
    GITHUB_CREATE_AN_ORGANIZATION_INVITATION: 'Action'
    GITHUB_CREATE_AN_ORGANIZATION_PROJECT: 'Action'
    GITHUB_CREATE_AN_ORGANIZATION_REPOSITORY: 'Action'
    GITHUB_CREATE_AN_ORGANIZATION_REPOSITORY_RULESET: 'Action'
    GITHUB_CREATE_AN_ORGANIZATION_VARIABLE: 'Action'
    GITHUB_CREATE_AN_ORGANIZATION_WEBHOOK: 'Action'
    GITHUB_CREATE_A_BLOB: 'Action'
    GITHUB_CREATE_A_CHECK_RUN: 'Action'
    GITHUB_CREATE_A_CHECK_SUITE: 'Action'
    GITHUB_CREATE_A_CODESPACE_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_CREATE_A_CODESPACE_FROM_A_PULL_REQUEST: 'Action'
    GITHUB_CREATE_A_CODESPACE_IN_A_REPOSITORY: 'Action'
    GITHUB_CREATE_A_COMMIT: 'Action'
    GITHUB_CREATE_A_COMMIT_COMMENT: 'Action'
    GITHUB_CREATE_A_COMMIT_STATUS: 'Action'
    GITHUB_CREATE_A_CUSTOM_DEPLOYMENT_PROTECTION_RULE_ON_AN_ENVIRONMENT: 'Action'
    GITHUB_CREATE_A_CUSTOM_ORGANIZATION_ROLE: 'Action'
    GITHUB_CREATE_A_DEPLOYMENT: 'Action'
    GITHUB_CREATE_A_DEPLOYMENT_BRANCH_POLICY: 'Action'
    GITHUB_CREATE_A_DEPLOYMENT_STATUS: 'Action'
    GITHUB_CREATE_A_DEPLOY_KEY: 'Action'
    GITHUB_CREATE_A_DISCUSSION: 'Action'
    GITHUB_CREATE_A_DISCUSSION_COMMENT: 'Action'
    GITHUB_CREATE_A_DISCUSSION_COMMENT_LEGACY: 'Action'
    GITHUB_CREATE_A_DISCUSSION_LEGACY: 'Action'
    GITHUB_CREATE_A_FORK: 'Action'
    GITHUB_CREATE_A_GIST: 'Action'
    GITHUB_CREATE_A_GIST_COMMENT: 'Action'
    GITHUB_CREATE_A_GITHUB_APP_FROM_A_MANIFEST: 'Action'
    GITHUB_CREATE_A_GITHUB_PAGES_DEPLOYMENT: 'Action'
    GITHUB_CREATE_A_GITHUB_PAGES_SITE: 'Action'
    GITHUB_CREATE_A_GPG_KEY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_CREATE_A_LABEL: 'Action'
    GITHUB_CREATE_A_MILESTONE: 'Action'
    GITHUB_CREATE_A_PROJECT_CARD: 'Action'
    GITHUB_CREATE_A_PROJECT_COLUMN: 'Action'
    GITHUB_CREATE_A_PUBLIC_SSH_KEY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_CREATE_A_PULL_REQUEST: 'Action'
    GITHUB_CREATE_A_REFERENCE: 'Action'
    GITHUB_CREATE_A_REGISTRATION_TOKEN_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_CREATE_A_REGISTRATION_TOKEN_FOR_A_REPOSITORY: 'Action'
    GITHUB_CREATE_A_RELEASE: 'Action'
    GITHUB_CREATE_A_REMOVE_TOKEN_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_CREATE_A_REMOVE_TOKEN_FOR_A_REPOSITORY: 'Action'
    GITHUB_CREATE_A_REPLY_FOR_A_REVIEW_COMMENT: 'Action'
    GITHUB_CREATE_A_REPOSITORY_DISPATCH_EVENT: 'Action'
    GITHUB_CREATE_A_REPOSITORY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_CREATE_A_REPOSITORY_FROM_AN_UNPUBLISHED_CODESPACE: 'Action'
    GITHUB_CREATE_A_REPOSITORY_PROJECT: 'Action'
    GITHUB_CREATE_A_REPOSITORY_RULESET: 'Action'
    GITHUB_CREATE_A_REPOSITORY_SECURITY_ADVISORY: 'Action'
    GITHUB_CREATE_A_REPOSITORY_USING_A_TEMPLATE: 'Action'
    GITHUB_CREATE_A_REPOSITORY_VARIABLE: 'Action'
    GITHUB_CREATE_A_REPOSITORY_WEBHOOK: 'Action'
    GITHUB_CREATE_A_REVIEW_COMMENT_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_CREATE_A_REVIEW_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_CREATE_A_SCOPED_ACCESS_TOKEN: 'Action'
    GITHUB_CREATE_A_SNAPSHOT_OF_DEPENDENCIES_FOR_A_REPOSITORY: 'Action'
    GITHUB_CREATE_A_SSH_SIGNING_KEY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_CREATE_A_TAG_OBJECT: 'Action'
    GITHUB_CREATE_A_TAG_PROTECTION_STATE_FOR_A_REPOSITORY: 'Action'
    GITHUB_CREATE_A_TEAM: 'Action'
    GITHUB_CREATE_A_TEMPORARY_PRIVATE_FORK: 'Action'
    GITHUB_CREATE_A_TREE: 'Action'
    GITHUB_CREATE_A_USER_PROJECT: 'Action'
    GITHUB_CREATE_A_WORKFLOW_DISPATCH_EVENT: 'Action'
    GITHUB_CREATE_COMMIT_SIGNATURE_PROTECTION: 'Action'
    GITHUB_CREATE_CONFIGURATION_FOR_A_JUST_IN_TIME_RUNNER_FOR_A_REPOSITORY: 'Action'
    GITHUB_CREATE_OR_UPDATE_AN_ENVIRONMENT: 'Action'
    GITHUB_CREATE_OR_UPDATE_AN_ENVIRONMENT_SECRET: 'Action'
    GITHUB_CREATE_OR_UPDATE_AN_ORGANIZATION_SECRET: 'Action'
    GITHUB_CREATE_OR_UPDATE_A_CUSTOM_PROPERTY_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_CREATE_OR_UPDATE_A_REPOSITORY_SECRET: 'Action'
    GITHUB_CREATE_OR_UPDATE_A_SECRET_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_CREATE_OR_UPDATE_CUSTOM_PROPERTIES_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_CREATE_OR_UPDATE_CUSTOM_PROPERTY_VALUES_FOR_A_REPOSITORY: 'Action'
    GITHUB_CREATE_OR_UPDATE_FILE_CONTENTS: 'Action'
    GITHUB_CREATE_OR_UPDATE_REPO_SECRET_WITH_ENCRYPTED_VALUE: 'Action'
    GITHUB_CREATE_REACTION_FOR_AN_ISSUE: 'Action'
    GITHUB_CREATE_REACTION_FOR_AN_ISSUE_COMMENT: 'Action'
    GITHUB_CREATE_REACTION_FOR_A_COMMIT_COMMENT: 'Action'
    GITHUB_CREATE_REACTION_FOR_A_PULL_REQUEST_REVIEW_COMMENT: 'Action'
    GITHUB_CREATE_REACTION_FOR_A_RELEASE: 'Action'
    GITHUB_CREATE_REACTION_FOR_A_TEAM_DISCUSSION: 'Action'
    GITHUB_CREATE_REACTION_FOR_A_TEAM_DISCUSSION_COMMENT: 'Action'
    GITHUB_CREATE_REACTION_FOR_A_TEAM_DISCUSSION_COMMENT_LEGACY: 'Action'
    GITHUB_CREATE_REACTION_FOR_A_TEAM_DISCUSSION_LEGACY: 'Action'
    GITHUB_CREATE_UPDATE_ORG_SECRET_WITH_LIB_SODIUM: 'Action'
    GITHUB_CUSTOMIZE_OIDC_SUBJECT_CLAIM_TEMPLATE: 'Action'
    GITHUB_CUSTOM_OIDCSUBJECT_CLAIM_TEMPLATE: 'Action'
    GITHUB_CUSTOM_OIDCSUBJECT_CLAIM_TEMPLATE_SETTER: 'Action'
    GITHUB_DECLINE_A_REPOSITORY_INVITATION: 'Action'
    GITHUB_DELETE_ACCESS_RESTRICTIONS: 'Action'
    GITHUB_DELETE_ADMIN_BRANCH_PROTECTION: 'Action'
    GITHUB_DELETE_AN_APP_AUTHORIZATION: 'Action'
    GITHUB_DELETE_AN_APP_TOKEN: 'Action'
    GITHUB_DELETE_AN_ARTIFACT: 'Action'
    GITHUB_DELETE_AN_AUTOLINK_REFERENCE_FROM_A_REPOSITORY: 'Action'
    GITHUB_DELETE_AN_EMAIL_ADDRESS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_DELETE_AN_ENVIRONMENT: 'Action'
    GITHUB_DELETE_AN_ENVIRONMENT_SECRET: 'Action'
    GITHUB_DELETE_AN_ENVIRONMENT_VARIABLE: 'Action'
    GITHUB_DELETE_AN_ISSUE_COMMENT: 'Action'
    GITHUB_DELETE_AN_ISSUE_COMMENT_REACTION: 'Action'
    GITHUB_DELETE_AN_ISSUE_REACTION: 'Action'
    GITHUB_DELETE_AN_ORGANIZATION: 'Action'
    GITHUB_DELETE_AN_ORGANIZATION_MIGRATION_ARCHIVE: 'Action'
    GITHUB_DELETE_AN_ORGANIZATION_REPOSITORY_RULESET: 'Action'
    GITHUB_DELETE_AN_ORGANIZATION_SECRET: 'Action'
    GITHUB_DELETE_AN_ORGANIZATION_VARIABLE: 'Action'
    GITHUB_DELETE_AN_ORGANIZATION_WEBHOOK: 'Action'
    GITHUB_DELETE_AN_SSH_SIGNING_KEY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_DELETE_A_CODESPACE_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_DELETE_A_CODESPACE_FROM_THE_ORGANIZATION: 'Action'
    GITHUB_DELETE_A_CODE_SCANNING_ANALYSIS_FROM_A_REPOSITORY: 'Action'
    GITHUB_DELETE_A_COMMIT_COMMENT: 'Action'
    GITHUB_DELETE_A_COMMIT_COMMENT_REACTION: 'Action'
    GITHUB_DELETE_A_CUSTOM_ORGANIZATION_ROLE: 'Action'
    GITHUB_DELETE_A_DEPLOYMENT: 'Action'
    GITHUB_DELETE_A_DEPLOYMENT_BRANCH_POLICY: 'Action'
    GITHUB_DELETE_A_DEPLOY_KEY: 'Action'
    GITHUB_DELETE_A_DISCUSSION: 'Action'
    GITHUB_DELETE_A_DISCUSSION_COMMENT: 'Action'
    GITHUB_DELETE_A_DISCUSSION_COMMENT_LEGACY: 'Action'
    GITHUB_DELETE_A_DISCUSSION_LEGACY: 'Action'
    GITHUB_DELETE_A_FILE: 'Action'
    GITHUB_DELETE_A_GIST: 'Action'
    GITHUB_DELETE_A_GIST_COMMENT: 'Action'
    GITHUB_DELETE_A_GITHUB_PAGES_SITE: 'Action'
    GITHUB_DELETE_A_GPG_KEY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_DELETE_A_LABEL: 'Action'
    GITHUB_DELETE_A_MILESTONE: 'Action'
    GITHUB_DELETE_A_PACKAGE_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_DELETE_A_PACKAGE_FOR_A_USER: 'Action'
    GITHUB_DELETE_A_PACKAGE_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_DELETE_A_PACKAGE_VERSION_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_DELETE_A_PENDING_REVIEW_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_DELETE_A_PROJECT: 'Action'
    GITHUB_DELETE_A_PROJECT_CARD: 'Action'
    GITHUB_DELETE_A_PROJECT_COLUMN: 'Action'
    GITHUB_DELETE_A_PUBLIC_SSH_KEY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_DELETE_A_PULL_REQUEST_COMMENT_REACTION: 'Action'
    GITHUB_DELETE_A_REFERENCE: 'Action'
    GITHUB_DELETE_A_RELEASE: 'Action'
    GITHUB_DELETE_A_RELEASE_ASSET: 'Action'
    GITHUB_DELETE_A_RELEASE_REACTION: 'Action'
    GITHUB_DELETE_A_REPOSITORY: 'Action'
    GITHUB_DELETE_A_REPOSITORY_INVITATION: 'Action'
    GITHUB_DELETE_A_REPOSITORY_RULESET: 'Action'
    GITHUB_DELETE_A_REPOSITORY_SECRET: 'Action'
    GITHUB_DELETE_A_REPOSITORY_SUBSCRIPTION: 'Action'
    GITHUB_DELETE_A_REPOSITORY_VARIABLE: 'Action'
    GITHUB_DELETE_A_REPOSITORY_WEBHOOK: 'Action'
    GITHUB_DELETE_A_REVIEW_COMMENT_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_DELETE_A_SECRET_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_DELETE_A_SELF_HOSTED_RUNNER_FROM_AN_ORGANIZATION: 'Action'
    GITHUB_DELETE_A_SELF_HOSTED_RUNNER_FROM_A_REPOSITORY: 'Action'
    GITHUB_DELETE_A_TAG_PROTECTION_STATE_FOR_A_REPOSITORY: 'Action'
    GITHUB_DELETE_A_TEAM: 'Action'
    GITHUB_DELETE_A_TEAM_LEGACY: 'Action'
    GITHUB_DELETE_A_THREAD_SUBSCRIPTION: 'Action'
    GITHUB_DELETE_A_USER_MIGRATION_ARCHIVE: 'Action'
    GITHUB_DELETE_A_WORKFLOW_RUN: 'Action'
    GITHUB_DELETE_BRANCH_PROTECTION: 'Action'
    GITHUB_DELETE_COMMIT_SIGNATURE_PROTECTION: 'Action'
    GITHUB_DELETE_DEPENDEBOT_SECRET_BY_NAME: 'Action'
    GITHUB_DELETE_GITHUB_ACTIONS_CACHE_BY_ID: 'Action'
    GITHUB_DELETE_PACKAGE_VERSION_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_DELETE_PACKAGE_VERSION_FOR_A_USER: 'Action'
    GITHUB_DELETE_PULL_REQUEST_REVIEW_PROTECTION: 'Action'
    GITHUB_DELETE_REPO_CODESPACE_SECRET_BY_NAME: 'Action'
    GITHUB_DELETE_SOCIAL_ACCOUNTS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_DELETE_TEAM_DISCUSSION_COMMENT_REACTION: 'Action'
    GITHUB_DELETE_TEAM_DISCUSSION_REACTION: 'Action'
    GITHUB_DELETE_WORKFLOW_RUN_LOGS: 'Action'
    GITHUB_DISABLE_AUTOMATED_SECURITY_FIXES: 'Action'
    GITHUB_DISABLE_A_CUSTOM_PROTECTION_RULE_FOR_AN_ENVIRONMENT: 'Action'
    GITHUB_DISABLE_A_WORKFLOW: 'Action'
    GITHUB_DISABLE_PRIVATE_VULNERABILITY_REPORTING_FOR_A_REPOSITORY: 'Action'
    GITHUB_DISABLE_REPOSITORY_ACTIONS_IN_ORG: 'Action'
    GITHUB_DISABLE_VULNERABILITY_ALERTS: 'Action'
    GITHUB_DISMISS_A_REVIEW_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_DOWNLOAD_AN_ARTIFACT: 'Action'
    GITHUB_DOWNLOAD_AN_ORGANIZATION_MIGRATION_ARCHIVE: 'Action'
    GITHUB_DOWNLOAD_A_REPOSITORY_ARCHIVE_TAR: 'Action'
    GITHUB_DOWNLOAD_A_REPOSITORY_ARCHIVE_ZIP: 'Action'
    GITHUB_DOWNLOAD_A_USER_MIGRATION_ARCHIVE: 'Action'
    GITHUB_DOWNLOAD_JOB_LOGS_FOR_A_WORKFLOW_RUN: 'Action'
    GITHUB_DOWNLOAD_WORKFLOW_RUN_ATTEMPT_LOGS: 'Action'
    GITHUB_DOWNLOAD_WORKFLOW_RUN_LOGS: 'Action'
    GITHUB_ENABLE_AUTOMATED_SECURITY_FIXES: 'Action'
    GITHUB_ENABLE_A_WORKFLOW: 'Action'
    GITHUB_ENABLE_GITHUB_ACTIONS_IN_SELECTED_REPOSITORIES: 'Action'
    GITHUB_ENABLE_OR_DISABLE_A_SECURITY_FEATURE_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_ENABLE_PRIVATE_VULNERABILITY_REPORTING_FOR_A_REPOSITORY: 'Action'
    GITHUB_ENABLE_REPO_FORGITHUB_ACTIONS: 'Action'
    GITHUB_ENABLE_VULNERABILITY_ALERTS: 'Action'
    GITHUB_ENCRYPT_AND_UPDATE_DEV_SECRET: 'Action'
    GITHUB_ENCRYPT_ORG_DEV_ENV_SECRET: 'Action'
    GITHUB_ENCRYPT_ORG_SECRETS_USING_PUBLIC_KEY: 'Action'
    GITHUB_EXPORT_A_CODESPACE_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_EXPORT_A_SOFTWARE_BILL_OF_MATERIALS_SBOM_FOR_A_REPOSITORY: 'Action'
    GITHUB_FETCH_PUBLIC_KEY_FOR_SECRET_ENCRYPTION: 'Action'
    GITHUB_FIND_CONFLICTING_PACKAGES_FOR_DOCKER_MIGRATION: 'Action'
    GITHUB_FOLLOW_A_USER: 'Action'
    GITHUB_FORCE_CANCEL_A_WORKFLOW_RUN: 'Action'
    GITHUB_FORK_A_GIST: 'Action'
    GITHUB_GENERATE_RELEASE_NOTES_CONTENT_FOR_A_RELEASE: 'Action'
    GITHUB_GET_ACCESS_RESTRICTIONS: 'Action'
    GITHUB_GET_ADMIN_BRANCH_PROTECTION: 'Action'
    GITHUB_GET_ALLOWED_ACTIONS_AND_REUSABLE_WORKFLOWS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_ALLOWED_ACTIONS_AND_REUSABLE_WORKFLOWS_FOR_A_REPOSITORY: 'Action'
    GITHUB_GET_ALL_API_VERSIONS: 'Action'
    GITHUB_GET_ALL_AUTOLINKS_OF_A_REPOSITORY: 'Action'
    GITHUB_GET_ALL_CODES_OF_CONDUCT: 'Action'
    GITHUB_GET_ALL_COMMONLY_USED_LICENSES: 'Action'
    GITHUB_GET_ALL_CONTRIBUTOR_COMMIT_ACTIVITY: 'Action'
    GITHUB_GET_ALL_CUSTOM_PROPERTIES_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_ALL_CUSTOM_PROPERTY_VALUES_FOR_A_REPOSITORY: 'Action'
    GITHUB_GET_ALL_DEPLOYMENT_PROTECTION_RULES_FOR_AN_ENVIRONMENT: 'Action'
    GITHUB_GET_ALL_GITIGNORE_TEMPLATES: 'Action'
    GITHUB_GET_ALL_ORGANIZATION_REPOSITORY_RULESETS: 'Action'
    GITHUB_GET_ALL_ORGANIZATION_ROLES_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_ALL_REPOSITORY_RULESETS: 'Action'
    GITHUB_GET_ALL_REPOSITORY_TOPICS: 'Action'
    GITHUB_GET_ALL_REQUESTED_REVIEWERS_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_GET_ALL_STATUS_CHECK_CONTEXTS: 'Action'
    GITHUB_GET_AN_APP: 'Action'
    GITHUB_GET_AN_ARTIFACT: 'Action'
    GITHUB_GET_AN_ASSIGNMENT: 'Action'
    GITHUB_GET_AN_AUTOLINK_REFERENCE_OF_A_REPOSITORY: 'Action'
    GITHUB_GET_AN_ENVIRONMENT: 'Action'
    GITHUB_GET_AN_ENVIRONMENT_PUBLIC_KEY: 'Action'
    GITHUB_GET_AN_ENVIRONMENT_SECRET: 'Action'
    GITHUB_GET_AN_ENVIRONMENT_VARIABLE: 'Action'
    GITHUB_GET_AN_IMPORT_STATUS: 'Action'
    GITHUB_GET_AN_ISSUE: 'Action'
    GITHUB_GET_AN_ISSUE_COMMENT: 'Action'
    GITHUB_GET_AN_ISSUE_EVENT: 'Action'
    GITHUB_GET_AN_ORGANIZATION: 'Action'
    GITHUB_GET_AN_ORGANIZATION_MEMBERSHIP_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_GET_AN_ORGANIZATION_MIGRATION_STATUS: 'Action'
    GITHUB_GET_AN_ORGANIZATION_PUBLIC_KEY: 'Action'
    GITHUB_GET_AN_ORGANIZATION_REPOSITORY_RULESET: 'Action'
    GITHUB_GET_AN_ORGANIZATION_ROLE: 'Action'
    GITHUB_GET_AN_ORGANIZATION_RULE_SUITE: 'Action'
    GITHUB_GET_AN_ORGANIZATION_SECRET: 'Action'
    GITHUB_GET_AN_ORGANIZATION_VARIABLE: 'Action'
    GITHUB_GET_AN_ORGANIZATION_WEBHOOK: 'Action'
    GITHUB_GET_AN_SSH_SIGNING_KEY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_GET_APPS_WITH_ACCESS_TO_THE_PROTECTED_BRANCH: 'Action'
    GITHUB_GET_ASSIGNMENT_GRADES: 'Action'
    GITHUB_GET_A_BLOB: 'Action'
    GITHUB_GET_A_BRANCH: 'Action'
    GITHUB_GET_A_CHECK_RUN: 'Action'
    GITHUB_GET_A_CHECK_SUITE: 'Action'
    GITHUB_GET_A_CLASSROOM: 'Action'
    GITHUB_GET_A_CODESPACE_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_GET_A_CODE_OF_CONDUCT: 'Action'
    GITHUB_GET_A_CODE_QL_DATABASE_FOR_A_REPOSITORY: 'Action'
    GITHUB_GET_A_CODE_SCANNING_ALERT: 'Action'
    GITHUB_GET_A_CODE_SCANNING_ANALYSIS_FOR_A_REPOSITORY: 'Action'
    GITHUB_GET_A_CODE_SCANNING_DEFAULT_SETUP_CONFIGURATION: 'Action'
    GITHUB_GET_A_COMMIT: 'Action'
    GITHUB_GET_A_COMMIT_COMMENT: 'Action'
    GITHUB_GET_A_COMMIT_OBJECT: 'Action'
    GITHUB_GET_A_CUSTOM_DEPLOYMENT_PROTECTION_RULE: 'Action'
    GITHUB_GET_A_CUSTOM_PROPERTY_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_A_DELIVERY_FOR_A_REPOSITORY_WEBHOOK: 'Action'
    GITHUB_GET_A_DEPENDABOT_ALERT: 'Action'
    GITHUB_GET_A_DEPLOYMENT: 'Action'
    GITHUB_GET_A_DEPLOYMENT_BRANCH_POLICY: 'Action'
    GITHUB_GET_A_DEPLOYMENT_STATUS: 'Action'
    GITHUB_GET_A_DEPLOY_KEY: 'Action'
    GITHUB_GET_A_DIFF_OF_THE_DEPENDENCIES_BETWEEN_COMMITS: 'Action'
    GITHUB_GET_A_DISCUSSION: 'Action'
    GITHUB_GET_A_DISCUSSION_COMMENT: 'Action'
    GITHUB_GET_A_DISCUSSION_COMMENT_LEGACY: 'Action'
    GITHUB_GET_A_DISCUSSION_LEGACY: 'Action'
    GITHUB_GET_A_DNS_HEALTH_CHECK_FOR_GITHUB_PAGES: 'Action'
    GITHUB_GET_A_GIST: 'Action'
    GITHUB_GET_A_GIST_COMMENT: 'Action'
    GITHUB_GET_A_GIST_REVISION: 'Action'
    GITHUB_GET_A_GITHUB_PAGES_SITE: 'Action'
    GITHUB_GET_A_GITIGNORE_TEMPLATE: 'Action'
    GITHUB_GET_A_GLOBAL_SECURITY_ADVISORY: 'Action'
    GITHUB_GET_A_GPG_KEY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_GET_A_JOB_FOR_A_WORKFLOW_RUN: 'Action'
    GITHUB_GET_A_LABEL: 'Action'
    GITHUB_GET_A_LICENSE: 'Action'
    GITHUB_GET_A_MILESTONE: 'Action'
    GITHUB_GET_A_PACKAGE_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_A_PACKAGE_FOR_A_USER: 'Action'
    GITHUB_GET_A_PACKAGE_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_GET_A_PACKAGE_VERSION_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_A_PACKAGE_VERSION_FOR_A_USER: 'Action'
    GITHUB_GET_A_PACKAGE_VERSION_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_GET_A_PROJECT: 'Action'
    GITHUB_GET_A_PROJECT_CARD: 'Action'
    GITHUB_GET_A_PROJECT_COLUMN: 'Action'
    GITHUB_GET_A_PUBLIC_SSH_KEY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_GET_A_PULL_REQUEST: 'Action'
    GITHUB_GET_A_REFERENCE: 'Action'
    GITHUB_GET_A_RELEASE: 'Action'
    GITHUB_GET_A_RELEASE_ASSET: 'Action'
    GITHUB_GET_A_RELEASE_BY_TAG_NAME: 'Action'
    GITHUB_GET_A_REPOSITORY: 'Action'
    GITHUB_GET_A_REPOSITORY_PUBLIC_KEY: 'Action'
    GITHUB_GET_A_REPOSITORY_README: 'Action'
    GITHUB_GET_A_REPOSITORY_README_FOR_A_DIRECTORY: 'Action'
    GITHUB_GET_A_REPOSITORY_RULESET: 'Action'
    GITHUB_GET_A_REPOSITORY_RULE_SUITE: 'Action'
    GITHUB_GET_A_REPOSITORY_SECRET: 'Action'
    GITHUB_GET_A_REPOSITORY_SECURITY_ADVISORY: 'Action'
    GITHUB_GET_A_REPOSITORY_SUBSCRIPTION: 'Action'
    GITHUB_GET_A_REPOSITORY_VARIABLE: 'Action'
    GITHUB_GET_A_REPOSITORY_WEBHOOK: 'Action'
    GITHUB_GET_A_REVIEW_COMMENT_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_GET_A_REVIEW_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_GET_A_SECRET_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_GET_A_SECRET_SCANNING_ALERT: 'Action'
    GITHUB_GET_A_SELF_HOSTED_RUNNER_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_A_SELF_HOSTED_RUNNER_FOR_A_REPOSITORY: 'Action'
    GITHUB_GET_A_TAG: 'Action'
    GITHUB_GET_A_TEAM_BY_NAME: 'Action'
    GITHUB_GET_A_TEAM_LEGACY: 'Action'
    GITHUB_GET_A_THREAD: 'Action'
    GITHUB_GET_A_THREAD_SUBSCRIPTION_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_GET_A_TREE: 'Action'
    GITHUB_GET_A_USER: 'Action'
    GITHUB_GET_A_USER_MIGRATION_STATUS: 'Action'
    GITHUB_GET_A_WEBHOOK_CONFIGURATION_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_A_WEBHOOK_CONFIGURATION_FOR_A_REPOSITORY: 'Action'
    GITHUB_GET_A_WEBHOOK_DELIVERY_FOR_AN_ORGANIZATION_WEBHOOK: 'Action'
    GITHUB_GET_A_WORKFLOW: 'Action'
    GITHUB_GET_A_WORKFLOW_RUN: 'Action'
    GITHUB_GET_A_WORKFLOW_RUN_ATTEMPT: 'Action'
    GITHUB_GET_BRANCH_PROTECTION: 'Action'
    GITHUB_GET_COMMIT_AUTHORS: 'Action'
    GITHUB_GET_COMMIT_SIGNATURE_PROTECTION: 'Action'
    GITHUB_GET_COMMUNITY_PROFILE_METRICS: 'Action'
    GITHUB_GET_CONTEXTUAL_INFORMATION_FOR_A_USER: 'Action'
    GITHUB_GET_COPILOT_SEAT_ASSIGNMENT_DETAILS_FOR_A_USER: 'Action'
    GITHUB_GET_COPILOT_SEAT_INFORMATION_AND_SETTINGS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_DEFAULT_ATTRIBUTES_FOR_A_CODESPACE: 'Action'
    GITHUB_GET_DEFAULT_WORKFLOW_PERMISSIONS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_DEFAULT_WORKFLOW_PERMISSIONS_FOR_A_REPOSITORY: 'Action'
    GITHUB_GET_DETAILS_ABOUT_A_CODESPACE_EXPORT: 'Action'
    GITHUB_GET_EMOJIS: 'Action'
    GITHUB_GET_FEEDS: 'Action'
    GITHUB_GET_GITHUB_ACTIONS_BILLING_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_GITHUB_ACTIONS_BILLING_FOR_A_USER: 'Action'
    GITHUB_GET_GITHUB_ACTIONS_CACHE_USAGE_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_GITHUB_ACTIONS_CACHE_USAGE_FOR_A_REPOSITORY: 'Action'
    GITHUB_GET_GITHUB_ACTIONS_PERMISSIONS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_GITHUB_ACTIONS_PERMISSIONS_FOR_A_REPOSITORY: 'Action'
    GITHUB_GET_GITHUB_META_INFORMATION: 'Action'
    GITHUB_GET_GITHUB_PACKAGES_BILLING_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_GITHUB_PACKAGES_BILLING_FOR_A_USER: 'Action'
    GITHUB_GET_GITHUB_PAGES_BUILD: 'Action'
    GITHUB_GET_INFORMATION_ABOUT_A_SARIF_UPLOAD: 'Action'
    GITHUB_GET_INTERACTION_RESTRICTIONS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_INTERACTION_RESTRICTIONS_FOR_A_REPOSITORY: 'Action'
    GITHUB_GET_INTERACTION_RESTRICTIONS_FOR_YOUR_PUBLIC_REPOSITORIES: 'Action'
    GITHUB_GET_LARGE_FILES: 'Action'
    GITHUB_GET_LATEST_PAGES_BUILD: 'Action'
    GITHUB_GET_OCTOCAT: 'Action'
    GITHUB_GET_ORGANIZATION_MEMBERSHIP_FOR_A_USER: 'Action'
    GITHUB_GET_ORG_DEV_ENVIRONMENT_SECRET_SAFELY: 'Action'
    GITHUB_GET_PAGE_VIEWS: 'Action'
    GITHUB_GET_PENDING_DEPLOYMENTS_FOR_A_WORKFLOW_RUN: 'Action'
    GITHUB_GET_PROJECT_PERMISSION_FOR_A_USER: 'Action'
    GITHUB_GET_PUBLIC_KEY_FOR_SECRET_ENCRYPTION: 'Action'
    GITHUB_GET_PUBLIC_KEY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_GET_PULL_REQUEST_REVIEW_PROTECTION: 'Action'
    GITHUB_GET_RATE_LIMIT_STATUS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_GET_REPOSITORY_CLONES: 'Action'
    GITHUB_GET_REPOSITORY_CONTENT: 'Action'
    GITHUB_GET_REPOSITORY_PERMISSIONS_FOR_A_USER: 'Action'
    GITHUB_GET_REPOSITORY_SECRET_SECURELY: 'Action'
    GITHUB_GET_REPO_DEV_ENV_SECRET: 'Action'
    GITHUB_GET_RULES_FOR_A_BRANCH: 'Action'
    GITHUB_GET_SHARED_STORAGE_BILLING_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_GET_SHARED_STORAGE_BILLING_FOR_A_USER: 'Action'
    GITHUB_GET_SINGLE_ORG_SECRET_WITHOUT_DECRYPTION: 'Action'
    GITHUB_GET_STATUS_CHECKS_PROTECTION: 'Action'
    GITHUB_GET_TEAMS_WITH_ACCESS_TO_THE_PROTECTED_BRANCH: 'Action'
    GITHUB_GET_TEAM_MEMBERSHIP_FOR_A_USER: 'Action'
    GITHUB_GET_TEAM_MEMBERSHIP_FOR_A_USER_LEGACY: 'Action'
    GITHUB_GET_TEAM_MEMBER_LEGACY: 'Action'
    GITHUB_GET_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_GET_THE_COMBINED_STATUS_FOR_A_SPECIFIC_REFERENCE: 'Action'
    GITHUB_GET_THE_HOURLY_COMMIT_COUNT_FOR_EACH_DAY: 'Action'
    GITHUB_GET_THE_LAST_YEAR_OF_COMMIT_ACTIVITY: 'Action'
    GITHUB_GET_THE_LATEST_RELEASE: 'Action'
    GITHUB_GET_THE_LEVEL_OF_ACCESS_FOR_WORKFLOWS_OUTSIDE_OF_THE_REPOSITORY: 'Action'
    GITHUB_GET_THE_LICENSE_FOR_A_REPOSITORY: 'Action'
    GITHUB_GET_THE_REVIEW_HISTORY_FOR_A_WORKFLOW_RUN: 'Action'
    GITHUB_GET_THE_STATUS_OF_A_GITHUB_PAGES_DEPLOYMENT: 'Action'
    GITHUB_GET_THE_WEEKLY_COMMIT_ACTIVITY: 'Action'
    GITHUB_GET_THE_WEEKLY_COMMIT_COUNT: 'Action'
    GITHUB_GET_THE_ZEN_OF_GITHUB: 'Action'
    GITHUB_GET_TOP_REFERRAL_PATHS: 'Action'
    GITHUB_GET_TOP_REFERRAL_SOURCES: 'Action'
    GITHUB_GET_USERS_WITH_ACCESS_TO_THE_PROTECTED_BRANCH: 'Action'
    GITHUB_GET_WORKFLOW_RUN_USAGE: 'Action'
    GITHUB_GET_WORKFLOW_USAGE: 'Action'
    GITHUB_GITHUB_API_ROOT: 'Action'
    GITHUB_ISSUES_LIST_FOR_REPO: 'Action'
    GITHUB_LIST_ACCEPTED_ASSIGNMENTS_FOR_AN_ASSIGNMENT: 'Action'
    GITHUB_LIST_ALL_COPILOT_SEAT_ASSIGNMENTS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_APP_INSTALLATIONS_ACCESSIBLE_TO_THE_USER_ACCESS_TOKEN: 'Action'
    GITHUB_LIST_APP_INSTALLATIONS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_ARTIFACTS_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_ASSIGNEES: 'Action'
    GITHUB_LIST_ASSIGNMENTS_FOR_A_CLASSROOM: 'Action'
    GITHUB_LIST_AVAILABLE_MACHINE_TYPES_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_BRANCHES: 'Action'
    GITHUB_LIST_BRANCHES_FOR_HEAD_COMMIT: 'Action'
    GITHUB_LIST_CHECK_RUNS_FOR_A_GIT_REFERENCE: 'Action'
    GITHUB_LIST_CHECK_RUNS_IN_A_CHECK_SUITE: 'Action'
    GITHUB_LIST_CHECK_RUN_ANNOTATIONS: 'Action'
    GITHUB_LIST_CHECK_SUITES_FOR_A_GIT_REFERENCE: 'Action'
    GITHUB_LIST_CHILD_TEAMS: 'Action'
    GITHUB_LIST_CHILD_TEAMS_LEGACY: 'Action'
    GITHUB_LIST_CLASSROOMS: 'Action'
    GITHUB_LIST_CODEOWNERS_ERRORS: 'Action'
    GITHUB_LIST_CODESPACES_FOR_A_USER_IN_ORGANIZATION: 'Action'
    GITHUB_LIST_CODESPACES_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_CODESPACES_FOR_THE_ORGANIZATION: 'Action'
    GITHUB_LIST_CODESPACES_IN_A_REPOSITORY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_CODE_QL_DATABASES_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_CODE_SCANNING_ALERTS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_CODE_SCANNING_ALERTS_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_CODE_SCANNING_ANALYSES_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_COMMENTS_FOR_A_PULL_REQUEST_REVIEW: 'Action'
    GITHUB_LIST_COMMITS: 'Action'
    GITHUB_LIST_COMMITS_ON_A_PULL_REQUEST: 'Action'
    GITHUB_LIST_COMMIT_COMMENTS: 'Action'
    GITHUB_LIST_COMMIT_COMMENTS_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_COMMIT_STATUSES_FOR_A_REFERENCE: 'Action'
    GITHUB_LIST_CUSTOM_PROPERTY_VALUES_FOR_ORGANIZATION_REPOSITORIES: 'Action'
    GITHUB_LIST_DELIVERIES_FOR_AN_ORGANIZATION_WEBHOOK: 'Action'
    GITHUB_LIST_DELIVERIES_FOR_A_REPOSITORY_WEBHOOK: 'Action'
    GITHUB_LIST_DEPENDABOT_ALERTS_FOR_AN_ENTERPRISE: 'Action'
    GITHUB_LIST_DEPENDABOT_ALERTS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_DEPENDABOT_ALERTS_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_DEPLOYMENTS: 'Action'
    GITHUB_LIST_DEPLOYMENT_BRANCH_POLICIES: 'Action'
    GITHUB_LIST_DEPLOYMENT_STATUSES: 'Action'
    GITHUB_LIST_DEPLOY_KEYS: 'Action'
    GITHUB_LIST_DISCUSSIONS: 'Action'
    GITHUB_LIST_DISCUSSIONS_LEGACY: 'Action'
    GITHUB_LIST_DISCUSSION_COMMENTS: 'Action'
    GITHUB_LIST_DISCUSSION_COMMENTS_LEGACY: 'Action'
    GITHUB_LIST_DOCKER_MIGRATION_CONFLICTS: 'Action'
    GITHUB_LIST_EMAIL_ADDRESSES_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_ENVIRONMENTS: 'Action'
    GITHUB_LIST_ENVIRONMENT_CUSTOM_DEPLOYMENT_RULES: 'Action'
    GITHUB_LIST_ENVIRONMENT_SECRETS: 'Action'
    GITHUB_LIST_ENVIRONMENT_VARIABLES: 'Action'
    GITHUB_LIST_EVENTS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_EVENTS_RECEIVED_BY_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_FAILED_ORGANIZATION_INVITATIONS: 'Action'
    GITHUB_LIST_FOLLOWERS_OF_A_USER: 'Action'
    GITHUB_LIST_FOLLOWERS_OF_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_FORKS: 'Action'
    GITHUB_LIST_GISTS_FOR_A_USER: 'Action'
    GITHUB_LIST_GISTS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_GIST_COMMENTS: 'Action'
    GITHUB_LIST_GIST_COMMITS: 'Action'
    GITHUB_LIST_GIST_FORKS: 'Action'
    GITHUB_LIST_GITHUB_ACTIONS_CACHES_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_GITHUB_PAGES_BUILDS: 'Action'
    GITHUB_LIST_GLOBAL_SECURITY_ADVISORIES: 'Action'
    GITHUB_LIST_GPG_KEYS_FOR_A_USER: 'Action'
    GITHUB_LIST_GPG_KEYS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_INSTALLATION_REQUESTS_FOR_THE_AUTHENTICATED_APP: 'Action'
    GITHUB_LIST_INSTANCES_OF_A_CODE_SCANNING_ALERT: 'Action'
    GITHUB_LIST_ISSUES_ASSIGNED_TO_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_ISSUE_COMMENTS: 'Action'
    GITHUB_LIST_ISSUE_COMMENTS_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_ISSUE_EVENTS: 'Action'
    GITHUB_LIST_ISSUE_EVENTS_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_JOBS_FOR_A_WORKFLOW_RUN: 'Action'
    GITHUB_LIST_JOBS_FOR_A_WORKFLOW_RUN_ATTEMPT: 'Action'
    GITHUB_LIST_LABELS_FOR_AN_ISSUE: 'Action'
    GITHUB_LIST_LABELS_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_LABELS_FOR_A_SELF_HOSTED_RUNNER_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_LABELS_FOR_A_SELF_HOSTED_RUNNER_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_LABELS_FOR_ISSUES_IN_A_MILESTONE: 'Action'
    GITHUB_LIST_LOCATIONS_FOR_A_SECRET_SCANNING_ALERT: 'Action'
    GITHUB_LIST_MACHINE_TYPES_FOR_A_CODESPACE: 'Action'
    GITHUB_LIST_MATCHING_REFERENCES: 'Action'
    GITHUB_LIST_MILESTONES: 'Action'
    GITHUB_LIST_NOTIFICATIONS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_ORGANIZATIONS: 'Action'
    GITHUB_LIST_ORGANIZATIONS_FOR_A_USER: 'Action'
    GITHUB_LIST_ORGANIZATIONS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_ORGANIZATION_EVENTS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_ORGANIZATION_FINE_GRAINED_PERMISSIONS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_ORGANIZATION_INVITATION_TEAMS: 'Action'
    GITHUB_LIST_ORGANIZATION_ISSUES_ASSIGNED_TO_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_ORGANIZATION_MEMBERS: 'Action'
    GITHUB_LIST_ORGANIZATION_MEMBERSHIPS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_ORGANIZATION_MIGRATIONS: 'Action'
    GITHUB_LIST_ORGANIZATION_PROJECTS: 'Action'
    GITHUB_LIST_ORGANIZATION_REPOSITORIES: 'Action'
    GITHUB_LIST_ORGANIZATION_RULE_SUITES: 'Action'
    GITHUB_LIST_ORGANIZATION_SECRETS: 'Action'
    GITHUB_LIST_ORGANIZATION_VARIABLES: 'Action'
    GITHUB_LIST_ORGANIZATION_WEBHOOKS: 'Action'
    GITHUB_LIST_ORG_LEVEL_CODESPACES_SECRETS: 'Action'
    GITHUB_LIST_ORG_REPOS_WITHGITHUB_ACTIONS_ENABLED: 'Action'
    GITHUB_LIST_ORG_RESOURCES_WITH_PERSONAL_TOKENS: 'Action'
    GITHUB_LIST_ORG_RESOURCE_ACCESS_TOKENS: 'Action'
    GITHUB_LIST_ORG_SECRETS_WITHOUT_VALUES: 'Action'
    GITHUB_LIST_OUTSIDE_COLLABORATORS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_OWNED_PACKAGE_VERSIONS: 'Action'
    GITHUB_LIST_PACKAGES_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_PACKAGES_FOR_A_USER: 'Action'
    GITHUB_LIST_PACKAGES_FOR_THE_AUTHENTICATED_USER_S_NAMESPACE: 'Action'
    GITHUB_LIST_PACKAGE_VERSIONS_FOR_A_PACKAGE_OWNED_BY_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_PACKAGE_VERSIONS_FOR_A_PACKAGE_OWNED_BY_A_USER: 'Action'
    GITHUB_LIST_PENDING_ORGANIZATION_INVITATIONS: 'Action'
    GITHUB_LIST_PENDING_TEAM_INVITATIONS: 'Action'
    GITHUB_LIST_PENDING_TEAM_INVITATIONS_LEGACY: 'Action'
    GITHUB_LIST_PROJECT_CARDS: 'Action'
    GITHUB_LIST_PROJECT_COLLABORATORS: 'Action'
    GITHUB_LIST_PROJECT_COLUMNS: 'Action'
    GITHUB_LIST_PUBLIC_EMAIL_ADDRESSES_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_PUBLIC_EVENTS: 'Action'
    GITHUB_LIST_PUBLIC_EVENTS_FOR_A_NETWORK_OF_REPOSITORIES: 'Action'
    GITHUB_LIST_PUBLIC_EVENTS_FOR_A_USER: 'Action'
    GITHUB_LIST_PUBLIC_EVENTS_RECEIVED_BY_A_USER: 'Action'
    GITHUB_LIST_PUBLIC_GISTS: 'Action'
    GITHUB_LIST_PUBLIC_KEYS_FOR_A_USER: 'Action'
    GITHUB_LIST_PUBLIC_ORGANIZATION_EVENTS: 'Action'
    GITHUB_LIST_PUBLIC_ORGANIZATION_MEMBERS: 'Action'
    GITHUB_LIST_PUBLIC_REPOSITORIES: 'Action'
    GITHUB_LIST_PUBLIC_SSH_KEYS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_PULL_REQUESTS: 'Action'
    GITHUB_LIST_PULL_REQUESTS_ASSOCIATED_WITH_A_COMMIT: 'Action'
    GITHUB_LIST_PULL_REQUESTS_FILES: 'Action'
    GITHUB_LIST_REACTIONS_FOR_AN_ISSUE: 'Action'
    GITHUB_LIST_REACTIONS_FOR_AN_ISSUE_COMMENT: 'Action'
    GITHUB_LIST_REACTIONS_FOR_A_COMMIT_COMMENT: 'Action'
    GITHUB_LIST_REACTIONS_FOR_A_PULL_REQUEST_REVIEW_COMMENT: 'Action'
    GITHUB_LIST_REACTIONS_FOR_A_RELEASE: 'Action'
    GITHUB_LIST_REACTIONS_FOR_A_TEAM_DISCUSSION: 'Action'
    GITHUB_LIST_REACTIONS_FOR_A_TEAM_DISCUSSION_COMMENT: 'Action'
    GITHUB_LIST_REACTIONS_FOR_A_TEAM_DISCUSSION_COMMENT_LEGACY: 'Action'
    GITHUB_LIST_REACTIONS_FOR_A_TEAM_DISCUSSION_LEGACY: 'Action'
    GITHUB_LIST_RELEASES: 'Action'
    GITHUB_LIST_RELEASE_ASSETS: 'Action'
    GITHUB_LIST_REPOSITORIES_ACCESSIBLE_TO_THE_APP_INSTALLATION: 'Action'
    GITHUB_LIST_REPOSITORIES_ACCESSIBLE_TO_THE_USER_ACCESS_TOKEN: 'Action'
    GITHUB_LIST_REPOSITORIES_FOR_A_USER: 'Action'
    GITHUB_LIST_REPOSITORIES_FOR_A_USER_MIGRATION: 'Action'
    GITHUB_LIST_REPOSITORIES_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_REPOSITORIES_IN_AN_ORGANIZATION_MIGRATION: 'Action'
    GITHUB_LIST_REPOSITORIES_STARRED_BY_A_USER: 'Action'
    GITHUB_LIST_REPOSITORIES_STARRED_BY_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_REPOSITORIES_WATCHED_BY_A_USER: 'Action'
    GITHUB_LIST_REPOSITORIES_WATCHED_BY_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_REPOSITORY_ACTIVITIES: 'Action'
    GITHUB_LIST_REPOSITORY_COLLABORATORS: 'Action'
    GITHUB_LIST_REPOSITORY_CONTRIBUTORS: 'Action'
    GITHUB_LIST_REPOSITORY_EVENTS: 'Action'
    GITHUB_LIST_REPOSITORY_INVITATIONS: 'Action'
    GITHUB_LIST_REPOSITORY_INVITATIONS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_REPOSITORY_ISSUES: 'Action'
    GITHUB_LIST_REPOSITORY_LANGUAGES: 'Action'
    GITHUB_LIST_REPOSITORY_NOTIFICATIONS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_REPOSITORY_ORGANIZATION_SECRETS: 'Action'
    GITHUB_LIST_REPOSITORY_ORGANIZATION_VARIABLES: 'Action'
    GITHUB_LIST_REPOSITORY_PROJECTS: 'Action'
    GITHUB_LIST_REPOSITORY_RULE_SUITES: 'Action'
    GITHUB_LIST_REPOSITORY_SECRETS: 'Action'
    GITHUB_LIST_REPOSITORY_SECRETS_WITHOUT_DECRYPTING: 'Action'
    GITHUB_LIST_REPOSITORY_SECURITY_ADVISORIES: 'Action'
    GITHUB_LIST_REPOSITORY_SECURITY_ADVISORIES_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_REPOSITORY_TAGS: 'Action'
    GITHUB_LIST_REPOSITORY_TEAMS: 'Action'
    GITHUB_LIST_REPOSITORY_VARIABLES: 'Action'
    GITHUB_LIST_REPOSITORY_WEBHOOKS: 'Action'
    GITHUB_LIST_REPOSITORY_WORKFLOWS: 'Action'
    GITHUB_LIST_REPOS_WITH_GHACTIONS_CACHE_USAGE: 'Action'
    GITHUB_LIST_REPO_ACCESS_BY_TOKEN: 'Action'
    GITHUB_LIST_REPO_DEV_CONTAINER_CONFIGS_FOR_USER: 'Action'
    GITHUB_LIST_REPO_SECRETS_WITHOUT_VALUES: 'Action'
    GITHUB_LIST_REVIEWS_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_LIST_REVIEW_COMMENTS_IN_A_REPOSITORY: 'Action'
    GITHUB_LIST_REVIEW_COMMENTS_ON_A_PULL_REQUEST: 'Action'
    GITHUB_LIST_RUNNER_APPLICATIONS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_RUNNER_APPLICATIONS_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_SECRETS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_SECRET_SCANNING_ALERTS_FOR_AN_ENTERPRISE: 'Action'
    GITHUB_LIST_SECRET_SCANNING_ALERTS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_SECRET_SCANNING_ALERTS_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_SECURITY_MANAGER_TEAMS: 'Action'
    GITHUB_LIST_SELECTED_REPOSITORIES_FOR_AN_ORGANIZATION_SECRET: 'Action'
    GITHUB_LIST_SELECTED_REPOSITORIES_FOR_AN_ORGANIZATION_VARIABLE: 'Action'
    GITHUB_LIST_SELECTED_REPOSITORIES_FOR_A_USER_SECRET: 'Action'
    GITHUB_LIST_SELECTED_REPOS_FOR_SECRET_ACCESS: 'Action'
    GITHUB_LIST_SELF_HOSTED_RUNNERS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_SELF_HOSTED_RUNNERS_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_SOCIAL_ACCOUNTS_FOR_A_USER: 'Action'
    GITHUB_LIST_SOCIAL_ACCOUNTS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_SSH_SIGNING_KEYS_FOR_A_USER: 'Action'
    GITHUB_LIST_SSH_SIGNING_KEYS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_STARGAZERS: 'Action'
    GITHUB_LIST_STARRED_GISTS: 'Action'
    GITHUB_LIST_SUBSCRIPTIONS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_SUBSCRIPTIONS_FOR_THE_AUTHENTICATED_USER_STUBBED: 'Action'
    GITHUB_LIST_TAG_PROTECTION_STATES_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_TEAMS: 'Action'
    GITHUB_LIST_TEAMS_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_TEAMS_THAT_ARE_ASSIGNED_TO_AN_ORGANIZATION_ROLE: 'Action'
    GITHUB_LIST_TEAM_MEMBERS: 'Action'
    GITHUB_LIST_TEAM_MEMBERS_LEGACY: 'Action'
    GITHUB_LIST_TEAM_PROJECTS: 'Action'
    GITHUB_LIST_TEAM_PROJECTS_LEGACY: 'Action'
    GITHUB_LIST_TEAM_REPOSITORIES: 'Action'
    GITHUB_LIST_TEAM_REPOSITORIES_LEGACY: 'Action'
    GITHUB_LIST_THE_PEOPLE_A_USER_FOLLOWS: 'Action'
    GITHUB_LIST_THE_PEOPLE_THE_AUTHENTICATED_USER_FOLLOWS: 'Action'
    GITHUB_LIST_TIMELINE_EVENTS_FOR_AN_ISSUE: 'Action'
    GITHUB_LIST_TOKEN_ACCESS_REPOSITORIES: 'Action'
    GITHUB_LIST_USERS: 'Action'
    GITHUB_LIST_USERS_BLOCKED_BY_AN_ORGANIZATION: 'Action'
    GITHUB_LIST_USERS_BLOCKED_BY_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_USERS_THAT_ARE_ASSIGNED_TO_AN_ORGANIZATION_ROLE: 'Action'
    GITHUB_LIST_USER_ACCOUNT_ISSUES_ASSIGNED_TO_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_LIST_USER_MIGRATIONS: 'Action'
    GITHUB_LIST_USER_PROJECTS: 'Action'
    GITHUB_LIST_WATCHERS: 'Action'
    GITHUB_LIST_WORKFLOW_RUNS_FOR_A_REPOSITORY: 'Action'
    GITHUB_LIST_WORKFLOW_RUNS_FOR_A_WORKFLOW: 'Action'
    GITHUB_LIST_WORKFLOW_RUN_ARTIFACTS: 'Action'
    GITHUB_LOCK_AN_ISSUE: 'Action'
    GITHUB_MANAGE_ACCESS_CONTROL_FOR_ORGANIZATION_CODESPACES: 'Action'
    GITHUB_MANAGE_CUSTOM_PROPERTIES_FOR_ORG_REPOS: 'Action'
    GITHUB_MANAGE_SECRETS_IN_SELECTED_REPOSITORIES_WITH_PROPER_ACCESS: 'Action'
    GITHUB_MAP_A_COMMIT_AUTHOR: 'Action'
    GITHUB_MARK_A_THREAD_AS_DONE: 'Action'
    GITHUB_MARK_A_THREAD_AS_READ: 'Action'
    GITHUB_MARK_NOTIFICATIONS_AS_READ: 'Action'
    GITHUB_MARK_REPOSITORY_NOTIFICATIONS_AS_READ: 'Action'
    GITHUB_MERGE_A_BRANCH: 'Action'
    GITHUB_MERGE_A_PULL_REQUEST: 'Action'
    GITHUB_META_ROOT: 'Action'
    GITHUB_MOVE_A_PROJECT_CARD: 'Action'
    GITHUB_MOVE_A_PROJECT_COLUMN: 'Action'
    GITHUB_PING_AN_ORGANIZATION_WEBHOOK: 'Action'
    GITHUB_PING_A_REPOSITORY_WEBHOOK: 'Action'
    GITHUB_PRIVATELY_REPORT_A_SECURITY_VULNERABILITY: 'Action'
    GITHUB_PULLS_CREATE: 'Action'
    GITHUB_PULLS_CREATE_REVIEW: 'Action'
    GITHUB_PULLS_CREATE_REVIEW_COMMENT: 'Action'
    GITHUB_PULLS_LIST: 'Action'
    GITHUB_REDELIVER_A_DELIVERY_FOR_AN_ORGANIZATION_WEBHOOK: 'Action'
    GITHUB_REDELIVER_A_DELIVERY_FOR_A_REPOSITORY_WEBHOOK: 'Action'
    GITHUB_REMOVE_ALL_LABELS_FROM_AN_ISSUE: 'Action'
    GITHUB_REMOVE_ALL_ORGANIZATION_ROLES_FOR_A_TEAM: 'Action'
    GITHUB_REMOVE_ALL_ORGANIZATION_ROLES_FOR_A_USER: 'Action'
    GITHUB_REMOVE_AN_ORGANIZATION_MEMBER: 'Action'
    GITHUB_REMOVE_AN_ORGANIZATION_ROLE_FROM_A_TEAM: 'Action'
    GITHUB_REMOVE_AN_ORGANIZATION_ROLE_FROM_A_USER: 'Action'
    GITHUB_REMOVE_APP_ACCESS_RESTRICTIONS: 'Action'
    GITHUB_REMOVE_ASSIGNEES_FROM_AN_ISSUE: 'Action'
    GITHUB_REMOVE_A_CUSTOM_PROPERTY_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_REMOVE_A_LABEL_FROM_AN_ISSUE: 'Action'
    GITHUB_REMOVE_A_PROJECT_FROM_A_TEAM: 'Action'
    GITHUB_REMOVE_A_PROJECT_FROM_A_TEAM_LEGACY: 'Action'
    GITHUB_REMOVE_A_REPOSITORY_COLLABORATOR: 'Action'
    GITHUB_REMOVE_A_REPOSITORY_FROM_AN_APP_INSTALLATION: 'Action'
    GITHUB_REMOVE_A_REPOSITORY_FROM_A_TEAM: 'Action'
    GITHUB_REMOVE_A_REPOSITORY_FROM_A_TEAM_LEGACY: 'Action'
    GITHUB_REMOVE_A_SECURITY_MANAGER_TEAM: 'Action'
    GITHUB_REMOVE_A_SELECTED_REPOSITORY_FROM_A_USER_SECRET: 'Action'
    GITHUB_REMOVE_CUSTOM_LABELS_FROM_SELF_HOSTED_REPOSITORY_RUNNER: 'Action'
    GITHUB_REMOVE_CUSTOM_LABEL_FROM_REPO_RUNNER: 'Action'
    GITHUB_REMOVE_CUSTOM_LABEL_FROM_SELF_HOSTED_RUNNER: 'Action'
    GITHUB_REMOVE_INTERACTION_RESTRICTIONS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_REMOVE_INTERACTION_RESTRICTIONS_FOR_A_REPOSITORY: 'Action'
    GITHUB_REMOVE_INTERACTION_RESTRICTIONS_FROM_YOUR_PUBLIC_REPOSITORIES: 'Action'
    GITHUB_REMOVE_ORGANIZATION_MEMBERSHIP_FOR_A_USER: 'Action'
    GITHUB_REMOVE_ORG_DEV_ENV_SECRET_BY_NAME: 'Action'
    GITHUB_REMOVE_ORG_SECRET_BY_NAME: 'Action'
    GITHUB_REMOVE_OUTSIDE_COLLABORATOR_FROM_AN_ORGANIZATION: 'Action'
    GITHUB_REMOVE_PUBLIC_ORG_MEMBERSHIP: 'Action'
    GITHUB_REMOVE_REPO_FROM_ORG_DEV_ENV_SECRET: 'Action'
    GITHUB_REMOVE_REPO_FROM_ORG_SECRET_WITH_SELECTED_VISIBILITY: 'Action'
    GITHUB_REMOVE_REQUESTED_REVIEWERS_FROM_A_PULL_REQUEST: 'Action'
    GITHUB_REMOVE_SELECTED_REPOSITORY_FROM_AN_ORGANIZATION_SECRET: 'Action'
    GITHUB_REMOVE_SELECTED_REPOSITORY_FROM_AN_ORGANIZATION_VARIABLE: 'Action'
    GITHUB_REMOVE_STATUS_CHECK_CONTEXTS: 'Action'
    GITHUB_REMOVE_STATUS_CHECK_PROTECTION: 'Action'
    GITHUB_REMOVE_TEAMS_FROM_THE_COPILOT_SUBSCRIPTION_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_REMOVE_TEAM_ACCESS_RESTRICTIONS: 'Action'
    GITHUB_REMOVE_TEAM_MEMBERSHIP_FOR_A_USER: 'Action'
    GITHUB_REMOVE_TEAM_MEMBERSHIP_FOR_A_USER_LEGACY: 'Action'
    GITHUB_REMOVE_TEAM_MEMBER_LEGACY: 'Action'
    GITHUB_REMOVE_USERS_FROM_CODESPACES_ACCESS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_REMOVE_USERS_FROM_THE_COPILOT_SUBSCRIPTION_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_REMOVE_USER_ACCESS_RESTRICTIONS: 'Action'
    GITHUB_REMOVE_USER_AS_A_COLLABORATOR: 'Action'
    GITHUB_RENAME_A_BRANCH: 'Action'
    GITHUB_RENDER_A_MARKDOWN_DOCUMENT: 'Action'
    GITHUB_REPLACE_ALL_REPOSITORY_TOPICS: 'Action'
    GITHUB_REPLACE_ORG_SECRET_VISIBILITY_TO_SELECTED: 'Action'
    GITHUB_REPLACE_REPO_ACCESS_ON_ORG_DEV_ENV_SECRET_SET: 'Action'
    GITHUB_REPO_S_CREATE_FOR_AUTHENTICATED_USER: 'Action'
    GITHUB_REPO_S_GET_COMMIT: 'Action'
    GITHUB_REPO_S_GET_CONTENT: 'Action'
    GITHUB_REPO_S_LIST_FOR_ORG: 'Action'
    GITHUB_REQUEST_A_CVE_FOR_A_REPOSITORY_SECURITY_ADVISORY: 'Action'
    GITHUB_REQUEST_A_GITHUB_PAGES_BUILD: 'Action'
    GITHUB_REQUEST_REVIEWERS_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_REREQUEST_A_CHECK_RUN: 'Action'
    GITHUB_REREQUEST_A_CHECK_SUITE: 'Action'
    GITHUB_RESET_A_TOKEN: 'Action'
    GITHUB_RESTORE_A_PACKAGE_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_RESTORE_A_PACKAGE_FOR_A_USER: 'Action'
    GITHUB_RESTORE_A_PACKAGE_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_RESTORE_A_PACKAGE_VERSION_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_RESTORE_PACKAGE_VERSION_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_RESTORE_PACKAGE_VERSION_FOR_A_USER: 'Action'
    GITHUB_RETRIEVE_REPO_PUBLIC_KEY_FOR_ENCRYPTION: 'Action'
    GITHUB_REVIEW_ACCESS_WITH_PERSONAL_TOKEN: 'Action'
    GITHUB_REVIEW_CUSTOM_DEPLOYMENT_PROTECTION_RULES_FOR_A_WORKFLOW_RUN: 'Action'
    GITHUB_REVIEW_PENDING_DEPLOYMENTS_FOR_A_WORKFLOW_RUN: 'Action'
    GITHUB_REVIEW_RESOURCE_REQUESTS_WITH_FINE_GRAINED_TOKENS: 'Action'
    GITHUB_REVOKE_AN_INSTALLATION_ACCESS_TOKEN: 'Action'
    GITHUB_RE_RUN_A_JOB_FROM_A_WORKFLOW_RUN: 'Action'
    GITHUB_RE_RUN_A_WORKFLOW: 'Action'
    GITHUB_RE_RUN_FAILED_JOBS_FROM_A_WORKFLOW_RUN: 'Action'
    GITHUB_SEARCH_CODE: 'Action'
    GITHUB_SEARCH_COMMITS: 'Action'
    GITHUB_SEARCH_ISSUES_AND_PULL_REQUESTS: 'Action'
    GITHUB_SEARCH_LABELS: 'Action'
    GITHUB_SEARCH_REPOSITORIES: 'Action'
    GITHUB_SEARCH_REPO_S: 'Action'
    GITHUB_SEARCH_TOPICS: 'Action'
    GITHUB_SEARCH_USERS: 'Action'
    GITHUB_SET_ADMIN_BRANCH_PROTECTION: 'Action'
    GITHUB_SET_ALLOWED_ACTIONS_AND_REUSABLE_WORKFLOWS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_SET_ALLOWED_ACTIONS_AND_REUSABLE_WORKFLOWS_FOR_A_REPOSITORY: 'Action'
    GITHUB_SET_APP_ACCESS_RESTRICTIONS: 'Action'
    GITHUB_SET_A_REPOSITORY_SUBSCRIPTION: 'Action'
    GITHUB_SET_A_THREAD_SUBSCRIPTION: 'Action'
    GITHUB_SET_CUSTOM_LABELS_FOR_A_SELF_HOSTED_RUNNER_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_SET_CUSTOM_LABELS_FOR_A_SELF_HOSTED_RUNNER_FOR_A_REPOSITORY: 'Action'
    GITHUB_SET_DEFAULT_WORKFLOW_PERMISSIONS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_SET_DEFAULT_WORKFLOW_PERMISSIONS_FOR_A_REPOSITORY: 'Action'
    GITHUB_SET_GITHUB_ACTIONS_PERMISSIONS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_SET_GITHUB_ACTIONS_PERMISSIONS_FOR_A_REPOSITORY: 'Action'
    GITHUB_SET_INTERACTION_RESTRICTIONS_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_SET_INTERACTION_RESTRICTIONS_FOR_A_REPOSITORY: 'Action'
    GITHUB_SET_INTERACTION_RESTRICTIONS_FOR_YOUR_PUBLIC_REPOSITORIES: 'Action'
    GITHUB_SET_LABELS_FOR_AN_ISSUE: 'Action'
    GITHUB_SET_ORGANIZATION_MEMBERSHIP_FOR_A_USER: 'Action'
    GITHUB_SET_PRIMARY_EMAIL_VISIBILITY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_SET_PUBLIC_ORGANIZATION_MEMBERSHIP_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_SET_SELECTED_REPOSITORIES_FOR_AN_ORGANIZATION_SECRET: 'Action'
    GITHUB_SET_SELECTED_REPOSITORIES_FOR_AN_ORGANIZATION_VARIABLE: 'Action'
    GITHUB_SET_SELECTED_REPOSITORIES_FOR_A_USER_SECRET: 'Action'
    GITHUB_SET_STATUS_CHECK_CONTEXTS: 'Action'
    GITHUB_SET_TEAM_ACCESS_RESTRICTIONS: 'Action'
    GITHUB_SET_THE_LEVEL_OF_ACCESS_FOR_WORKFLOWS_OUTSIDE_OF_THE_REPOSITORY: 'Action'
    GITHUB_SET_USER_ACCESS_RESTRICTIONS: 'Action'
    GITHUB_START_AN_IMPORT: 'Action'
    GITHUB_START_AN_ORGANIZATION_MIGRATION: 'Action'
    GITHUB_START_A_CODESPACE_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_START_A_USER_MIGRATION: 'Action'
    GITHUB_STAR_A_GIST: 'Action'
    GITHUB_STAR_A_REPOSITORY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_STOP_A_CODESPACE_FOR_AN_ORGANIZATION_USER: 'Action'
    GITHUB_STOP_A_CODESPACE_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_SUBMIT_A_REVIEW_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_SYNC_A_FORK_BRANCH_WITH_THE_UPSTREAM_REPOSITORY: 'Action'
    GITHUB_TEST_THE_PUSH_REPOSITORY_WEBHOOK: 'Action'
    GITHUB_TRANSFER_A_REPOSITORY: 'Action'
    GITHUB_UNBLOCK_A_USER: 'Action'
    GITHUB_UNBLOCK_A_USER_FROM_AN_ORGANIZATION: 'Action'
    GITHUB_UNFOLLOW_A_USER: 'Action'
    GITHUB_UNLOCK_AN_ISSUE: 'Action'
    GITHUB_UNLOCK_AN_ORGANIZATION_REPOSITORY: 'Action'
    GITHUB_UNLOCK_A_USER_REPOSITORY: 'Action'
    GITHUB_UNSTAR_A_GIST: 'Action'
    GITHUB_UNSTAR_A_REPOSITORY_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_UPDATE_AN_ENVIRONMENT_VARIABLE: 'Action'
    GITHUB_UPDATE_AN_EXISTING_PROJECT_CARD: 'Action'
    GITHUB_UPDATE_AN_EXISTING_PROJECT_COLUMN: 'Action'
    GITHUB_UPDATE_AN_IMPORT: 'Action'
    GITHUB_UPDATE_AN_ISSUE: 'Action'
    GITHUB_UPDATE_AN_ISSUE_COMMENT: 'Action'
    GITHUB_UPDATE_AN_ORGANIZATION: 'Action'
    GITHUB_UPDATE_AN_ORGANIZATION_MEMBERSHIP_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_UPDATE_AN_ORGANIZATION_REPOSITORY_RULESET: 'Action'
    GITHUB_UPDATE_AN_ORGANIZATION_VARIABLE: 'Action'
    GITHUB_UPDATE_AN_ORGANIZATION_WEBHOOK: 'Action'
    GITHUB_UPDATE_A_CHECK_RUN: 'Action'
    GITHUB_UPDATE_A_CODESPACE_FOR_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_UPDATE_A_CODE_SCANNING_ALERT: 'Action'
    GITHUB_UPDATE_A_CODE_SCANNING_DEFAULT_SETUP_CONFIGURATION: 'Action'
    GITHUB_UPDATE_A_COMMIT_COMMENT: 'Action'
    GITHUB_UPDATE_A_CUSTOM_ORGANIZATION_ROLE: 'Action'
    GITHUB_UPDATE_A_DEPENDABOT_ALERT: 'Action'
    GITHUB_UPDATE_A_DEPLOYMENT_BRANCH_POLICY: 'Action'
    GITHUB_UPDATE_A_DISCUSSION: 'Action'
    GITHUB_UPDATE_A_DISCUSSION_COMMENT: 'Action'
    GITHUB_UPDATE_A_DISCUSSION_COMMENT_LEGACY: 'Action'
    GITHUB_UPDATE_A_DISCUSSION_LEGACY: 'Action'
    GITHUB_UPDATE_A_GIST: 'Action'
    GITHUB_UPDATE_A_GIST_COMMENT: 'Action'
    GITHUB_UPDATE_A_LABEL: 'Action'
    GITHUB_UPDATE_A_MILESTONE: 'Action'
    GITHUB_UPDATE_A_PROJECT: 'Action'
    GITHUB_UPDATE_A_PULL_REQUEST: 'Action'
    GITHUB_UPDATE_A_PULL_REQUEST_BRANCH: 'Action'
    GITHUB_UPDATE_A_REFERENCE: 'Action'
    GITHUB_UPDATE_A_RELEASE: 'Action'
    GITHUB_UPDATE_A_RELEASE_ASSET: 'Action'
    GITHUB_UPDATE_A_REPOSITORY: 'Action'
    GITHUB_UPDATE_A_REPOSITORY_INVITATION: 'Action'
    GITHUB_UPDATE_A_REPOSITORY_RULESET: 'Action'
    GITHUB_UPDATE_A_REPOSITORY_SECURITY_ADVISORY: 'Action'
    GITHUB_UPDATE_A_REPOSITORY_VARIABLE: 'Action'
    GITHUB_UPDATE_A_REPOSITORY_WEBHOOK: 'Action'
    GITHUB_UPDATE_A_REVIEW_COMMENT_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_UPDATE_A_REVIEW_FOR_A_PULL_REQUEST: 'Action'
    GITHUB_UPDATE_A_SECRET_SCANNING_ALERT: 'Action'
    GITHUB_UPDATE_A_TEAM: 'Action'
    GITHUB_UPDATE_A_TEAM_LEGACY: 'Action'
    GITHUB_UPDATE_A_WEBHOOK_CONFIGURATION_FOR_AN_ORGANIZATION: 'Action'
    GITHUB_UPDATE_A_WEBHOOK_CONFIGURATION_FOR_A_REPOSITORY: 'Action'
    GITHUB_UPDATE_BRANCH_PROTECTION: 'Action'
    GITHUB_UPDATE_GIT_LFS_PREFERENCE: 'Action'
    GITHUB_UPDATE_INFORMATION_ABOUT_A_GITHUB_PAGES_SITE: 'Action'
    GITHUB_UPDATE_PULL_REQUEST_REVIEW_PROTECTION: 'Action'
    GITHUB_UPDATE_REPOSITORY_PREFERENCES_FOR_CHECK_SUITES: 'Action'
    GITHUB_UPDATE_RESOURCE_ACCESS_WITH_TOKENS: 'Action'
    GITHUB_UPDATE_STATUS_CHECK_PROTECTION: 'Action'
    GITHUB_UPDATE_THE_AUTHENTICATED_USER: 'Action'
    GITHUB_UPDATE_TOKEN_ORG_ACCESS: 'Action'
    GITHUB_UPLOAD_AN_ANALYSIS_AS_SARIF_DATA: 'Action'
    GITHUB_USERS_GET_AUTHENTICATED: 'Action'
    GITHUB_USERS_GET_BY_USERNAME: 'Action'
    GITHUB_USERS_LIST_PUBLIC_EMAILS_FOR_AUTHENTICATED_USER: 'Action'
    GITHUB_USERS_LIST_SOCIAL_ACCOUNTS_FOR_USER: 'Action'
    GITHUB_VERIFY_DEV_CONTAINER_PERMISSIONS_ACCEPTED: 'Action'
    GIT_GET_PATCH_CMD: 'Action'
    GIT_GITHUB_CLONE_CMD: 'Action'
    GIT_GIT_REPO_TREE: 'Action'
    GMAIL_ADD_LABEL_TO_EMAIL: 'Action'
    GMAIL_CREATE_EMAIL_DRAFT: 'Action'
    GMAIL_CREATE_LABEL: 'Action'
    GMAIL_FETCH_EMAILS: 'Action'
    GMAIL_FETCH_MESSAGE_BY_THREAD_ID: 'Action'
    GMAIL_GET_ATTACHMENT: 'Action'
    GMAIL_GET_PEOPLE: 'Action'
    GMAIL_GET_PROFILE: 'Action'
    GMAIL_LIST_LABELS: 'Action'
    GMAIL_LIST_THREADS: 'Action'
    GMAIL_MODIFY_THREAD_LABELS: 'Action'
    GMAIL_REMOVE_LABEL: 'Action'
    GMAIL_REPLY_TO_THREAD: 'Action'
    GMAIL_SEND_EMAIL: 'Action'
    GOOGLECALENDAR_CREATE_EVENT: 'Action'
    GOOGLECALENDAR_DELETE_EVENT: 'Action'
    GOOGLECALENDAR_DUPLICATE_CALENDAR: 'Action'
    GOOGLECALENDAR_FIND_EVENT: 'Action'
    GOOGLECALENDAR_FIND_FREE_SLOTS: 'Action'
    GOOGLECALENDAR_GET_CALENDAR: 'Action'
    GOOGLECALENDAR_GET_CURRENT_DATE_TIME: 'Action'
    GOOGLECALENDAR_LIST_CALENDARS: 'Action'
    GOOGLECALENDAR_PATCH_CALENDAR: 'Action'
    GOOGLECALENDAR_QUICK_ADD: 'Action'
    GOOGLECALENDAR_REMOVE_ATTENDEE: 'Action'
    GOOGLECALENDAR_UPDATE_EVENT: 'Action'
    GOOGLEDOCS_CREATE_DOCUMENT: 'Action'
    GOOGLEDOCS_GET_DOCUMENT_BY_ID: 'Action'
    GOOGLEDOCS_UPDATE_EXISTING_DOCUMENT: 'Action'
    GOOGLEDRIVE_ADD_FILE_SHARING_PREFERENCE: 'Action'
    GOOGLEDRIVE_COPY_FILE: 'Action'
    GOOGLEDRIVE_CREATE_FILE_FROM_TEXT: 'Action'
    GOOGLEDRIVE_CREATE_FOLDER: 'Action'
    GOOGLEDRIVE_DELETE_FOLDER_OR_FILE: 'Action'
    GOOGLEDRIVE_EDIT_FILE: 'Action'
    GOOGLEDRIVE_EXPORT_FILE: 'Action'
    GOOGLEDRIVE_FIND_FILE: 'Action'
    GOOGLEDRIVE_FIND_FOLDER: 'Action'
    GOOGLEMEET_CREATE_MEET: 'Action'
    GOOGLEMEET_GET_CONFERENCE_RECORD_FOR_MEET: 'Action'
    GOOGLEMEET_GET_MEET: 'Action'
    GOOGLEMEET_GET_RECORDINGS_BY_CONFERENCE_RECORD_ID: 'Action'
    GOOGLEMEET_GET_TRANSCRIPTS_BY_CONFERENCE_RECORD_ID: 'Action'
    GOOGLESHEETS_BATCH_GET: 'Action'
    GOOGLESHEETS_BATCH_UPDATE: 'Action'
    GOOGLESHEETS_CLEAR_VALUES: 'Action'
    GOOGLESHEETS_CREATE_GOOGLE_SHEET1: 'Action'
    GOOGLESHEETS_GET_SPREADSHEET_INFO: 'Action'
    GOOGLESHEETS_LOOKUP_SPREADSHEET_ROW: 'Action'
    GOOGLETASKS_CLEAR_TASKS: 'Action'
    GOOGLETASKS_CREATE_TASK_LIST: 'Action'
    GOOGLETASKS_DELETE_TASK: 'Action'
    GOOGLETASKS_DELETE_TASK_LIST: 'Action'
    GOOGLETASKS_GET_TASK: 'Action'
    GOOGLETASKS_GET_TASK_LIST: 'Action'
    GOOGLETASKS_INSERT_TASK: 'Action'
    GOOGLETASKS_LIST_TASKS: 'Action'
    GOOGLETASKS_LIST_TASK_LISTS: 'Action'
    GOOGLETASKS_PATCH_TASK: 'Action'
    GOOGLETASKS_PATCH_TASK_LIST: 'Action'
    GREPTILE_CODE_QUERY: 'Action'
    HACKERNEWS_GET_FRONTPAGE: 'Action'
    HACKERNEWS_GET_ITEM_WITH_ID: 'Action'
    HACKERNEWS_GET_LATEST_POSTS: 'Action'
    HACKERNEWS_GET_TODAYS_POSTS: 'Action'
    HACKERNEWS_GET_USER: 'Action'
    HACKERNEWS_SEARCH_POSTS: 'Action'
    HEYGEN_PERSONALIZED_VIDEO_ADD_CONTACT: 'Action'
    HEYGEN_PERSONALIZED_VIDEO_AUDIENCE_DETAIL: 'Action'
    HEYGEN_PERSONALIZED_VIDEO_PROJECT_DETAIL: 'Action'
    HEYGEN_STREAMING_AVATAR_LIST: 'Action'
    HEYGEN_STREAMING_CREATE_TOKEN: 'Action'
    HEYGEN_STREAMING_ICE: 'Action'
    HEYGEN_STREAMING_INTERRUPT: 'Action'
    HEYGEN_STREAMING_LIST: 'Action'
    HEYGEN_STREAMING_NEW: 'Action'
    HEYGEN_STREAMING_START: 'Action'
    HEYGEN_STREAMING_STOP: 'Action'
    HEYGEN_STREAMING_TASK: 'Action'
    HEYGEN_V1_AVATAR_LIST: 'Action'
    HEYGEN_V1_TALKING_PHOTO_LIST: 'Action'
    HEYGEN_V1_VIDEO_DELETE: 'Action'
    HEYGEN_V1_VIDEO_LIST: 'Action'
    HEYGEN_V1_VIDEO_STATUS_GET_LATEST_ID: 'Action'
    HEYGEN_V1_VOICE_LIST: 'Action'
    HEYGEN_V1_WEBHOOK_ENDPOINT_ADD: 'Action'
    HEYGEN_V1_WEBHOOK_ENDPOINT_DELETE: 'Action'
    HEYGEN_V1_WEBHOOK_ENDPOINT_LIST: 'Action'
    HEYGEN_V1_WEBHOOK_WEBHOOK_LIST: 'Action'
    HEYGEN_V2_AVATARS: 'Action'
    HEYGEN_V2_TALKING_PHOTO_ID_DELETE: 'Action'
    HEYGEN_V2_TEMPLATES: 'Action'
    HEYGEN_V2_TEMPLATE_GENERATE: 'Action'
    HEYGEN_V2_TEMPLATE_ID: 'Action'
    HEYGEN_V2_USER_REMAINING_QUOTA: 'Action'
    HEYGEN_V2_VIDEO_GENERATE: 'Action'
    HEYGEN_V2_VIDEO_TRANSLATE: 'Action'
    HEYGEN_V2_VIDEO_TRANSLATE_ID_STATUS: 'Action'
    HEYGEN_V2_VIDEO_TRANSLATE_TARGET_LANGUAGES: 'Action'
    HEYGEN_V2_VOICES: 'Action'
    HISTORY_FETCHER_GET_WORKSPACE_HISTORY: 'Action'
    HUBSPOT_ADDS_A_TOKEN_TO_AN_EXISTING_EVENT_TEMPLATE: 'Action'
    HUBSPOT_ARCHIVE: 'Action'
    HUBSPOT_ARCHIVE_A_BATCH_OF_COMPANIES_BY_ID: 'Action'
    HUBSPOT_ARCHIVE_A_BATCH_OF_CONTACTS_BY_ID: 'Action'
    HUBSPOT_ARCHIVE_A_BATCH_OF_DEALS_BY_ID: 'Action'
    HUBSPOT_ARCHIVE_A_BATCH_OF_FEEDBACK_SUBMISSIONS_BY_ID: 'Action'
    HUBSPOT_ARCHIVE_A_BATCH_OF_LINE_ITEMS_BY_ID: 'Action'
    HUBSPOT_ARCHIVE_A_BATCH_OF_OBJECTS_BY_ID: 'Action'
    HUBSPOT_ARCHIVE_A_BATCH_OF_PRODUCTS_BY_ID: 'Action'
    HUBSPOT_ARCHIVE_A_BATCH_OF_PROPERTIES: 'Action'
    HUBSPOT_ARCHIVE_A_BATCH_OF_QUOTES_BY_ID: 'Action'
    HUBSPOT_ARCHIVE_A_BATCH_OF_TICKETS_BY_ID: 'Action'
    HUBSPOT_ARCHIVE_A_PROPERTY: 'Action'
    HUBSPOT_ARCHIVE_A_PROPERTY_GROUP: 'Action'
    HUBSPOT_BATCH_COMPANIES_RETRIEVAL_BY_ID_OR_PROPERTIES: 'Action'
    HUBSPOT_BATCH_CONTACT_RETRIEVAL_BY_ID_PROPERTIES: 'Action'
    HUBSPOT_BATCH_PRODUCT_READ_BY_ID_OR_PROPERTIES: 'Action'
    HUBSPOT_BATCH_READ_OBJECTS_BY_ID_OR_PROPERTIES: 'Action'
    HUBSPOT_BATCH_TICKET_RETRIEVAL_BY_ID_OR_PROPERTIES: 'Action'
    HUBSPOT_BATCH_UPDATE_CRM_OBJECTS_BY_ID_OR_PROPERTIES: 'Action'
    HUBSPOT_BIN_QUOTE_OBJECT: 'Action'
    HUBSPOT_CANCEL_AN_ACTIVE_IMPORT: 'Action'
    HUBSPOT_COMPLIANT_CONTACT_CONTENT_REMOVAL: 'Action'
    HUBSPOT_CONFIGURE_A_CALLING_EXTENSION: 'Action'
    HUBSPOT_CONFIGURE_VIDEO_CONFERENCE_APP: 'Action'
    HUBSPOT_CONTACT_AND_CONTENT_DELETION_FOR_COMPLIANCE: 'Action'
    HUBSPOT_CONTACT_REMOVAL_FOR_GDPR_COMPLIANCE: 'Action'
    HUBSPOT_CREATE: 'Action'
    HUBSPOT_CREATES_MULTIPLE_EVENTS: 'Action'
    HUBSPOT_CREATE_AN_ASSOCIATION: 'Action'
    HUBSPOT_CREATE_AN_EVENT_TEMPLATE_FOR_YOUR_APP: 'Action'
    HUBSPOT_CREATE_A_BATCH_OF_COMPANIES: 'Action'
    HUBSPOT_CREATE_A_BATCH_OF_CONTACTS: 'Action'
    HUBSPOT_CREATE_A_BATCH_OF_DEALS: 'Action'
    HUBSPOT_CREATE_A_BATCH_OF_FEEDBACK_SUBMISSIONS: 'Action'
    HUBSPOT_CREATE_A_BATCH_OF_LINE_ITEMS: 'Action'
    HUBSPOT_CREATE_A_BATCH_OF_OBJECTS: 'Action'
    HUBSPOT_CREATE_A_BATCH_OF_PRODUCTS: 'Action'
    HUBSPOT_CREATE_A_BATCH_OF_PROPERTIES: 'Action'
    HUBSPOT_CREATE_A_BATCH_OF_QUOTES: 'Action'
    HUBSPOT_CREATE_A_BATCH_OF_TICKETS: 'Action'
    HUBSPOT_CREATE_A_NEW_SCHEMA: 'Action'
    HUBSPOT_CREATE_A_PIPELINE: 'Action'
    HUBSPOT_CREATE_A_PIPELINE_STAGE: 'Action'
    HUBSPOT_CREATE_A_PROPERTY: 'Action'
    HUBSPOT_CREATE_A_PROPERTY_GROUP: 'Action'
    HUBSPOT_CREATE_A_SINGLE_EVENT: 'Action'
    HUBSPOT_CUSTOMIZABLE_CONTACTS_PAGE_RETRIEVAL: 'Action'
    HUBSPOT_CUSTOMIZABLE_DEAL_PAGE_READER: 'Action'
    HUBSPOT_CUSTOM_OBJECT_SUMMARY_BY_ID: 'Action'
    HUBSPOT_DELETES_AN_EVENT_TEMPLATE_FOR_THE_APP: 'Action'
    HUBSPOT_DELETE_A_PIPELINE: 'Action'
    HUBSPOT_DELETE_A_PIPELINE_STAGE: 'Action'
    HUBSPOT_DELETE_A_SCHEMA: 'Action'
    HUBSPOT_DELETE_CALLING_SETTINGS: 'Action'
    HUBSPOT_DELETE_SETTINGS: 'Action'
    HUBSPOT_DUPLICATE_QUOTE_WITH_ID: 'Action'
    HUBSPOT_EMAIL_BASED_CONTACT_DATA_EXPUNGEMENT: 'Action'
    HUBSPOT_ERASE_CONTACT_FOR_COMPLIANCE: 'Action'
    HUBSPOT_ERASE_CONTACT_FOR_GDPR_COMPLIANCE: 'Action'
    HUBSPOT_FEEDBACK_SUBMISSION_WITH_OBJECT_COPY_AND_ID: 'Action'
    HUBSPOT_FETCH_COMPANY_DETAILS_BY_IDENTIFIER: 'Action'
    HUBSPOT_FETCH_CONTACT_DETAILS_BY_ID: 'Action'
    HUBSPOT_FETCH_LINE_ITEMS_BY_ID_OR_ATTRIBUTES: 'Action'
    HUBSPOT_FETCH_MULTIPLE_QUOTES_BY_ID_OR_PROPERTY: 'Action'
    HUBSPOT_FETCH_OBJECT_BY_IDENTIFIER_WITH_OPTIONAL_PROPERTIES: 'Action'
    HUBSPOT_FETCH_OBJECT_DETAILS_BY_ID_AND_PROPERTIES: 'Action'
    HUBSPOT_FETCH_OBJECT_DETAILS_BY_ID_OR_PROPERTY: 'Action'
    HUBSPOT_FETCH_SPECIFIC_OBJECT_DETAILS: 'Action'
    HUBSPOT_GDPR_DELETE: 'Action'
    HUBSPOT_GENERATE_AND_RETURN_CONTACT_WITH_ID: 'Action'
    HUBSPOT_GENERATE_NEW_LINE_ITEM_COPY: 'Action'
    HUBSPOT_GENERATE_TICKET_WITH_PROPERTIES_AND_ID: 'Action'
    HUBSPOT_GETS_A_SPECIFIC_EVENT_TEMPLATE_FOR_YOUR_APP: 'Action'
    HUBSPOT_GETS_THE_DETAIL_TEMPLATE_AS_RENDERED: 'Action'
    HUBSPOT_GETS_THE_EVENT: 'Action'
    HUBSPOT_GET_ACTIVE_IMPORTS: 'Action'
    HUBSPOT_GET_ALL_SCHEMAS: 'Action'
    HUBSPOT_GET_AN_EXISTING_SCHEMA: 'Action'
    HUBSPOT_GET_A_PAGE_OF_OWNERS: 'Action'
    HUBSPOT_GET_CALLING_SETTINGS: 'Action'
    HUBSPOT_GET_SETTINGS: 'Action'
    HUBSPOT_GET_THE_INFORMATION_ON_ANY_IMPORT: 'Action'
    HUBSPOT_INSTANTIATE_AND_RETURN_NEW_COMPANY_OBJECT: 'Action'
    HUBSPOT_INSTANTIATE_CRM_ENTITY_WITH_PROPERTIES_ID: 'Action'
    HUBSPOT_INSTANTIATE_DEAL_WITH_ID_RETURN: 'Action'
    HUBSPOT_LIST: 'Action'
    HUBSPOT_LIST_ALL_EVENT_TEMPLATES_FOR_YOUR_APP: 'Action'
    HUBSPOT_MERGE_TWO_COMPANIES_WITH_SAME_TYPE: 'Action'
    HUBSPOT_MERGE_TWO_CONTACTS_WITH_SAME_TYPE: 'Action'
    HUBSPOT_MERGE_TWO_DEALS_WITH_SAME_TYPE: 'Action'
    HUBSPOT_MERGE_TWO_FEEDBACK_SUBMISSIONS_WITH_SAME_TYPE: 'Action'
    HUBSPOT_MERGE_TWO_LINE_ITEMS_WITH_SAME_TYPE: 'Action'
    HUBSPOT_MERGE_TWO_OBJECTS_WITH_SAME_TYPE: 'Action'
    HUBSPOT_MERGE_TWO_PRODUCTS_WITH_SAME_TYPE: 'Action'
    HUBSPOT_MERGE_TWO_QUOTES_WITH_SAME_TYPE: 'Action'
    HUBSPOT_MERGE_TWO_TICKETS_WITH_SAME_TYPE: 'Action'
    HUBSPOT_MODIFY_COMPANY_BY_ID: 'Action'
    HUBSPOT_MODIFY_CONTACT_PROPERTIES_CONDITIONALLY: 'Action'
    HUBSPOT_MODIFY_OBJECT_PROPERTIES: 'Action'
    HUBSPOT_MODIFY_OBJECT_PROPERTIES_BY_ID_OR_ALTERNATE_KEY: 'Action'
    HUBSPOT_MODIFY_SPECIFIED_QUOTE_PROPERTIES: 'Action'
    HUBSPOT_OVERWRITE_FEEDBACK_SUBMISSION_PROPERTIES: 'Action'
    HUBSPOT_OVERWRITE_OBJECT_PROPERTIES: 'Action'
    HUBSPOT_PAGED_TICKET_RETRIEVAL_WITH_CUSTOMIZED_PROPERTIES: 'Action'
    HUBSPOT_PAGE_THROUGH_OBJECTS_WITH_PROPERTIES: 'Action'
    HUBSPOT_PAGINATED_COMPANY_DATA_RETRIEVAL: 'Action'
    HUBSPOT_PAGINATE_FEEDBACK_SUBMISSIONS_RETRIEVAL: 'Action'
    HUBSPOT_PERMANENTLY_ERASE_CONTACT_BY_EMAIL: 'Action'
    HUBSPOT_PERMANENT_CONTACT_ERASURE_AND_BLOCKLIST: 'Action'
    HUBSPOT_PURGE_SPECIFIC_OBJECT_TYPE_SCHEMA: 'Action'
    HUBSPOT_QUOTE_PAGE_RETRIEVAL_WITH_PROPERTY_FILTERING: 'Action'
    HUBSPOT_READ: 'Action'
    HUBSPOT_READ_ALL_PROPERTIES: 'Action'
    HUBSPOT_READ_ALL_PROPERTY_GROUPS: 'Action'
    HUBSPOT_READ_AN_OWNER_BY_GIVEN_ID_OR_USER_ID: 'Action'
    HUBSPOT_READ_A_BATCH_OF_DEALS_BY_INTERNAL_ID_OR_UNIQUE_PROPERTY_VALUES: 'Action'
    HUBSPOT_READ_A_BATCH_OF_PROPERTIES: 'Action'
    HUBSPOT_READ_A_PROPERTY: 'Action'
    HUBSPOT_READ_A_PROPERTY_GROUP: 'Action'
    HUBSPOT_READ_FEEDBACK_SUBMISSIONS_IN_BATCH_BY_ID_OR_PROPERTIES: 'Action'
    HUBSPOT_RECYCLE_BIN_OBJECT_MOVE: 'Action'
    HUBSPOT_RECYCLE_COMPANY_OBJECT: 'Action'
    HUBSPOT_RECYCLE_CONTACT_BY_ID: 'Action'
    HUBSPOT_RECYCLE_DEAL_BY_ID: 'Action'
    HUBSPOT_RECYCLE_FEEDBACK_SUBMISSION: 'Action'
    HUBSPOT_RECYCLE_OBJECT_BY_ID: 'Action'
    HUBSPOT_RECYCLE_TICKET_BY_ID: 'Action'
    HUBSPOT_REMOVES_A_TOKEN_FROM_THE_EVENT_TEMPLATE: 'Action'
    HUBSPOT_REMOVE_AN_ASSOCIATION: 'Action'
    HUBSPOT_RENDERS_THE_HEADER_OR_DETAIL_AS_HTML: 'Action'
    HUBSPOT_REPLACE_A_PIPELINE: 'Action'
    HUBSPOT_REPLACE_A_PIPELINE_STAGE: 'Action'
    HUBSPOT_RETRIEVE_ALL_PIPELINES: 'Action'
    HUBSPOT_RETRIEVE_APP_S_RECORDING_SETTINGS: 'Action'
    HUBSPOT_RETRIEVE_IMPORT_ERROR_DETAILS_WITH_PAGING: 'Action'
    HUBSPOT_RETRIEVE_OBJECT_RECORD_BY_ID_OR_PROPERTY: 'Action'
    HUBSPOT_RETRIEVE_PAGINATED_LINE_ITEMS_WITH_CUSTOMIZABLE_PROPERTIES: 'Action'
    HUBSPOT_RETURN_ALL_STAGES_OF_A_PIPELINE: 'Action'
    HUBSPOT_RETURN_AN_AUDIT_OF_ALL_CHANGES_TO_THE_PIPELINE: 'Action'
    HUBSPOT_RETURN_AN_AUDIT_OF_ALL_CHANGES_TO_THE_PIPELINE_STAGE: 'Action'
    HUBSPOT_RETURN_A_PIPELINE_BY_ID: 'Action'
    HUBSPOT_RETURN_A_PIPELINE_STAGE_BY_ID: 'Action'
    HUBSPOT_REVISE_OBJECT_PROPERTIES: 'Action'
    HUBSPOT_SEARCH_COMPANIES_INFORMATION: 'Action'
    HUBSPOT_SEARCH_CONTACTS_WITH_CRITERIA: 'Action'
    HUBSPOT_SEARCH_CRM_OBJECTS_BY_CRITERIA: 'Action'
    HUBSPOT_SEARCH_DEALS_BY_CRITERIA: 'Action'
    HUBSPOT_SEARCH_FEEDBACK_SUBMISSIONS_ENDPOINT: 'Action'
    HUBSPOT_SEARCH_FOR_LINE_ITEMS_USING_CRITERIA: 'Action'
    HUBSPOT_SEARCH_QUOTES_WITH_CRITERIA: 'Action'
    HUBSPOT_SEARCH_TICKETS_BY_CRITERIA: 'Action'
    HUBSPOT_SECURE_PRODUCT_SEARCH_BY_CRITERIA: 'Action'
    HUBSPOT_SET_CRM_CALL_RECORDING_OPTIONS_BY_APP_ID: 'Action'
    HUBSPOT_START_A_NEW_IMPORT: 'Action'
    HUBSPOT_UPDATE: 'Action'
    HUBSPOT_UPDATES_AN_EXISTING_TOKEN_ON_AN_EVENT_TEMPLATE: 'Action'
    HUBSPOT_UPDATE_AN_EXISTING_EVENT_TEMPLATE: 'Action'
    HUBSPOT_UPDATE_APP_S_CALL_RECORDING_SETTINGS: 'Action'
    HUBSPOT_UPDATE_A_BATCH_OF_COMPANIES: 'Action'
    HUBSPOT_UPDATE_A_BATCH_OF_CONTACTS: 'Action'
    HUBSPOT_UPDATE_A_BATCH_OF_DEALS: 'Action'
    HUBSPOT_UPDATE_A_BATCH_OF_FEEDBACK_SUBMISSIONS: 'Action'
    HUBSPOT_UPDATE_A_BATCH_OF_LINE_ITEMS: 'Action'
    HUBSPOT_UPDATE_A_BATCH_OF_PRODUCTS: 'Action'
    HUBSPOT_UPDATE_A_BATCH_OF_QUOTES: 'Action'
    HUBSPOT_UPDATE_A_BATCH_OF_TICKETS: 'Action'
    HUBSPOT_UPDATE_A_PIPELINE: 'Action'
    HUBSPOT_UPDATE_A_PIPELINE_STAGE: 'Action'
    HUBSPOT_UPDATE_A_PROPERTY: 'Action'
    HUBSPOT_UPDATE_A_PROPERTY_GROUP: 'Action'
    HUBSPOT_UPDATE_A_SCHEMA: 'Action'
    HUBSPOT_UPDATE_SETTINGS: 'Action'
    IMAGE_ANALYSER_ANALYSE: 'Action'
    INDUCED_AI_EXTRACT_DATA: 'Action'
    INDUCED_AI_GET_AUTONOMOUS_TASK_STATUS: 'Action'
    INDUCED_AI_GET_DATA_EXTRACTION_STATUS: 'Action'
    INDUCED_AI_PERFORM_AUTONOMOUS_TASK: 'Action'
    INDUCED_AI_STOP_AUTONOMOUS_TASK: 'Action'
    JIRA_ADD_ACTORS_TO_PROJECT_ROLE: 'Action'
    JIRA_ADD_ATTACHMENT: 'Action'
    JIRA_ADD_COMMENT: 'Action'
    JIRA_ADD_DEFAULT_ACTORS_TO_PROJECT_ROLE: 'Action'
    JIRA_ADD_FIELD_TO_DEFAULT_SCREEN: 'Action'
    JIRA_ADD_FILTER_AS_FAVORITE: 'Action'
    JIRA_ADD_GADGET_TO_DASHBOARD: 'Action'
    JIRA_ADD_ISSUE_SECURITY_LEVELS: 'Action'
    JIRA_ADD_ISSUE_SECURITY_LEVEL_MEMBERS: 'Action'
    JIRA_ADD_ISSUE_TYPES_TO_CONTEXT: 'Action'
    JIRA_ADD_ISSUE_TYPES_TO_ISSUE_TYPE_SCHEME: 'Action'
    JIRA_ADD_NOTIFICATIONS_TO_NOTIFICATION_SCHEME: 'Action'
    JIRA_ADD_SCREEN_TAB_FIELD: 'Action'
    JIRA_ADD_SHARE_PERMISSION: 'Action'
    JIRA_ADD_USER_TO_GROUP: 'Action'
    JIRA_ADD_VOTE: 'Action'
    JIRA_ADD_WATCHER: 'Action'
    JIRA_ADD_WORKLOG: 'Action'
    JIRA_ANALYSE_JIRA_EXPRESSION: 'Action'
    JIRA_APPEND_MAPPINGS_TO_ISSUE_TYPE_SCREEN_SCHEME: 'Action'
    JIRA_ARCHIVE_ISSUE_S_BY_ISSUE_ID_KEY: 'Action'
    JIRA_ARCHIVE_ISSUE_S_BY_JQL: 'Action'
    JIRA_ARCHIVE_PROJECT: 'Action'
    JIRA_ASSIGN_CUSTOM_FIELD_CONTEXT_TO_PROJECTS: 'Action'
    JIRA_ASSIGN_FIELD_CONFIGURATION_SCHEME_TO_PROJECT: 'Action'
    JIRA_ASSIGN_ISSUE: 'Action'
    JIRA_ASSIGN_ISSUE_TYPES_TO_FIELD_CONFIGURATIONS: 'Action'
    JIRA_ASSIGN_ISSUE_TYPE_SCHEME_TO_PROJECT: 'Action'
    JIRA_ASSIGN_ISSUE_TYPE_SCREEN_SCHEME_TO_PROJECT: 'Action'
    JIRA_ASSIGN_PERMISSION_SCHEME: 'Action'
    JIRA_ASSIGN_WORKFLOW_SCHEME_TO_PROJECT: 'Action'
    JIRA_ASSOCIATE_SECURITY_SCHEME_TO_PROJECT: 'Action'
    JIRA_BULK_CREATE_ISSUE: 'Action'
    JIRA_BULK_CREATE_STATUSES: 'Action'
    JIRA_BULK_CREATE_WORKFLOWS: 'Action'
    JIRA_BULK_DELETE_ISSUE_PROPERTY: 'Action'
    JIRA_BULK_DELETE_STATUSES: 'Action'
    JIRA_BULK_EDIT_DASHBOARDS: 'Action'
    JIRA_BULK_GET_GROUPS: 'Action'
    JIRA_BULK_GET_STATUSES: 'Action'
    JIRA_BULK_GET_USERS: 'Action'
    JIRA_BULK_GET_WORKFLOWS: 'Action'
    JIRA_BULK_GET_WORKFLOW_SCHEMES: 'Action'
    JIRA_BULK_SET_ISSUES_PROPERTIES_BY_LIST: 'Action'
    JIRA_BULK_SET_ISSUE_PROPERTIES_BY_ISSUE: 'Action'
    JIRA_BULK_SET_ISSUE_PROPERTY: 'Action'
    JIRA_BULK_UPDATE_CUSTOM_FIELD_VALUE: 'Action'
    JIRA_BULK_UPDATE_STATUSES: 'Action'
    JIRA_BULK_UPDATE_WORKFLOWS: 'Action'
    JIRA_CANCEL_TASK: 'Action'
    JIRA_CHANGE_FILTER_OWNER: 'Action'
    JIRA_CHANGE_ORDER_OF_ISSUE_TYPES: 'Action'
    JIRA_CHECK_ISSUES_AGAINST_JQL: 'Action'
    JIRA_CLASSIC_UPDATE_WORKFLOW_SCHEME: 'Action'
    JIRA_CONVERT_USER_IDENTIFIERS_TO_ACCOUNT_IDS_IN_JQL_QUERIES: 'Action'
    JIRA_COPY_DASHBOARD: 'Action'
    JIRA_CREATE_COMPONENT: 'Action'
    JIRA_CREATE_CUSTOM_FIELD: 'Action'
    JIRA_CREATE_CUSTOM_FIELD_CONTEXT: 'Action'
    JIRA_CREATE_CUSTOM_FIELD_OPTIONS_CONTEXT: 'Action'
    JIRA_CREATE_DASHBOARD: 'Action'
    JIRA_CREATE_DRAFT_WORKFLOW_SCHEME: 'Action'
    JIRA_CREATE_FIELD_CONFIGURATION: 'Action'
    JIRA_CREATE_FIELD_CONFIGURATION_SCHEME: 'Action'
    JIRA_CREATE_FILTER: 'Action'
    JIRA_CREATE_GROUP: 'Action'
    JIRA_CREATE_ISSUE: 'Action'
    JIRA_CREATE_ISSUE_FIELD_OPTION: 'Action'
    JIRA_CREATE_ISSUE_LINK: 'Action'
    JIRA_CREATE_ISSUE_LINK_TYPE: 'Action'
    JIRA_CREATE_ISSUE_SECURITY_SCHEME: 'Action'
    JIRA_CREATE_ISSUE_TYPE: 'Action'
    JIRA_CREATE_ISSUE_TYPE_SCHEME: 'Action'
    JIRA_CREATE_ISSUE_TYPE_SCREEN_SCHEME: 'Action'
    JIRA_CREATE_NOTIFICATION_SCHEME: 'Action'
    JIRA_CREATE_OR_UPDATE_REMOTE_ISSUE_LINK: 'Action'
    JIRA_CREATE_PERMISSION_GRANT: 'Action'
    JIRA_CREATE_PERMISSION_SCHEME: 'Action'
    JIRA_CREATE_PRIORITY: 'Action'
    JIRA_CREATE_PROJECT: 'Action'
    JIRA_CREATE_PROJECT_CATEGORY: 'Action'
    JIRA_CREATE_PROJECT_ROLE: 'Action'
    JIRA_CREATE_RELATED_WORK: 'Action'
    JIRA_CREATE_RESOLUTION: 'Action'
    JIRA_CREATE_SCREEN: 'Action'
    JIRA_CREATE_SCREEN_SCHEME: 'Action'
    JIRA_CREATE_SCREEN_TAB: 'Action'
    JIRA_CREATE_UI_MODIFICATION: 'Action'
    JIRA_CREATE_USER: 'Action'
    JIRA_CREATE_VERSION: 'Action'
    JIRA_CREATE_WORKFLOW: 'Action'
    JIRA_CREATE_WORKFLOW_SCHEME: 'Action'
    JIRA_CREATE_WORKFLOW_TRANSITION_PROPERTY: 'Action'
    JIRA_DELETE_ACTORS_FROM_PROJECT_ROLE: 'Action'
    JIRA_DELETE_AND_REPLACE_VERSION: 'Action'
    JIRA_DELETE_APP_PROPERTY: 'Action'
    JIRA_DELETE_APP_PROPERTY_FORGE: 'Action'
    JIRA_DELETE_ATTACHMENT: 'Action'
    JIRA_DELETE_AVATAR: 'Action'
    JIRA_DELETE_COMMENT: 'Action'
    JIRA_DELETE_COMMENT_PROPERTY: 'Action'
    JIRA_DELETE_COMPONENT: 'Action'
    JIRA_DELETE_CUSTOM_FIELD: 'Action'
    JIRA_DELETE_CUSTOM_FIELD_CONTEXT: 'Action'
    JIRA_DELETE_CUSTOM_FIELD_OPTIONS_CONTEXT: 'Action'
    JIRA_DELETE_DASHBOARD: 'Action'
    JIRA_DELETE_DASHBOARD_ITEM_PROPERTY: 'Action'
    JIRA_DELETE_DEFAULT_ACTORS_FROM_PROJECT_ROLE: 'Action'
    JIRA_DELETE_DEFAULT_WORKFLOW: 'Action'
    JIRA_DELETE_DRAFT_DEFAULT_WORKFLOW: 'Action'
    JIRA_DELETE_DRAFT_WORKFLOW_SCHEME: 'Action'
    JIRA_DELETE_FIELD_CONFIGURATION: 'Action'
    JIRA_DELETE_FIELD_CONFIGURATION_SCHEME: 'Action'
    JIRA_DELETE_FILTER: 'Action'
    JIRA_DELETE_INACTIVE_WORKFLOW: 'Action'
    JIRA_DELETE_ISSUE: 'Action'
    JIRA_DELETE_ISSUE_FIELD_OPTION: 'Action'
    JIRA_DELETE_ISSUE_LINK: 'Action'
    JIRA_DELETE_ISSUE_LINK_TYPE: 'Action'
    JIRA_DELETE_ISSUE_PROPERTY: 'Action'
    JIRA_DELETE_ISSUE_SECURITY_SCHEME: 'Action'
    JIRA_DELETE_ISSUE_TYPE: 'Action'
    JIRA_DELETE_ISSUE_TYPES_FOR_WORKFLOW_IN_DRAFT_WORKFLOW_SCHEME: 'Action'
    JIRA_DELETE_ISSUE_TYPES_FOR_WORKFLOW_IN_WORKFLOW_SCHEME: 'Action'
    JIRA_DELETE_ISSUE_TYPE_PROPERTY: 'Action'
    JIRA_DELETE_ISSUE_TYPE_SCHEME: 'Action'
    JIRA_DELETE_ISSUE_TYPE_SCREEN_SCHEME: 'Action'
    JIRA_DELETE_LOCALE: 'Action'
    JIRA_DELETE_NOTIFICATION_SCHEME: 'Action'
    JIRA_DELETE_PERMISSION_SCHEME: 'Action'
    JIRA_DELETE_PERMISSION_SCHEME_GRANT: 'Action'
    JIRA_DELETE_PREFERENCE: 'Action'
    JIRA_DELETE_PRIORITY: 'Action'
    JIRA_DELETE_PROJECT: 'Action'
    JIRA_DELETE_PROJECT_ASYNCHRONOUSLY: 'Action'
    JIRA_DELETE_PROJECT_AVATAR: 'Action'
    JIRA_DELETE_PROJECT_CATEGORY: 'Action'
    JIRA_DELETE_PROJECT_PROPERTY: 'Action'
    JIRA_DELETE_PROJECT_ROLE: 'Action'
    JIRA_DELETE_RELATED_WORK: 'Action'
    JIRA_DELETE_REMOTE_ISSUE_LINK_BY_GLOBAL_ID: 'Action'
    JIRA_DELETE_REMOTE_ISSUE_LINK_BY_ID: 'Action'
    JIRA_DELETE_RESOLUTION: 'Action'
    JIRA_DELETE_SCREEN: 'Action'
    JIRA_DELETE_SCREEN_SCHEME: 'Action'
    JIRA_DELETE_SCREEN_TAB: 'Action'
    JIRA_DELETE_SHARE_PERMISSION: 'Action'
    JIRA_DELETE_UI_MODIFICATION: 'Action'
    JIRA_DELETE_USER: 'Action'
    JIRA_DELETE_USER_PROPERTY: 'Action'
    JIRA_DELETE_VERSION: 'Action'
    JIRA_DELETE_VOTE: 'Action'
    JIRA_DELETE_WATCHER: 'Action'
    JIRA_DELETE_WEBHOOKS_BY_ID: 'Action'
    JIRA_DELETE_WORKFLOW_FOR_ISSUE_TYPE_IN_DRAFT_WORKFLOW_SCHEME: 'Action'
    JIRA_DELETE_WORKFLOW_FOR_ISSUE_TYPE_IN_WORKFLOW_SCHEME: 'Action'
    JIRA_DELETE_WORKFLOW_SCHEME: 'Action'
    JIRA_DELETE_WORKFLOW_TRANSITION_PROPERTY: 'Action'
    JIRA_DELETE_WORKFLOW_TRANSITION_RULE_CONFIGURATIONS: 'Action'
    JIRA_DELETE_WORKLOG: 'Action'
    JIRA_DELETE_WORKLOG_PROPERTY: 'Action'
    JIRA_EDIT_ISSUE: 'Action'
    JIRA_EVALUATE_JIRA_EXPRESSION: 'Action'
    JIRA_EXPORT_ARCHIVED_ISSUE_S: 'Action'
    JIRA_EXTEND_WEBHOOK_LIFE: 'Action'
    JIRA_FETCH_MIGRATED_WORKFLOW_RULE_DETAILS: 'Action'
    JIRA_FIND_COMPONENTS_FOR_PROJECTS: 'Action'
    JIRA_FIND_GROUPS: 'Action'
    JIRA_FIND_USERS: 'Action'
    JIRA_FIND_USERS_AND_GROUPS: 'Action'
    JIRA_FIND_USERS_ASSIGNABLE_TO_ISSUES: 'Action'
    JIRA_FIND_USERS_ASSIGNABLE_TO_PROJECTS: 'Action'
    JIRA_FIND_USERS_BY_QUERY: 'Action'
    JIRA_FIND_USERS_FOR_PICKER: 'Action'
    JIRA_FIND_USERS_WITH_BROWSE_PERMISSION: 'Action'
    JIRA_FIND_USERS_WITH_PERMISSIONS: 'Action'
    JIRA_FIND_USER_KEYS_BY_QUERY: 'Action'
    JIRA_FULLY_UPDATE_PROJECT_ROLE: 'Action'
    JIRA_GET_ACCESSIBLE_PROJECT_TYPE_BY_KEY: 'Action'
    JIRA_GET_ACCOUNT_IDS_FOR_USERS: 'Action'
    JIRA_GET_ADVANCED_SETTINGS: 'Action'
    JIRA_GET_ALL_APPLICATION_ROLES: 'Action'
    JIRA_GET_ALL_CLASSIFICATION_LEVELS: 'Action'
    JIRA_GET_ALL_DASHBOARDS: 'Action'
    JIRA_GET_ALL_FIELD_CONFIGURATIONS: 'Action'
    JIRA_GET_ALL_FIELD_CONFIGURATION_SCHEMES: 'Action'
    JIRA_GET_ALL_ISSUE_FIELD_OPTIONS: 'Action'
    JIRA_GET_ALL_ISSUE_TYPES_FOR_USER: 'Action'
    JIRA_GET_ALL_ISSUE_TYPE_SCHEMES: 'Action'
    JIRA_GET_ALL_LABELS: 'Action'
    JIRA_GET_ALL_METADATA_FOR_AN_EXPANDED_ATTACHMENT: 'Action'
    JIRA_GET_ALL_PERMISSIONS: 'Action'
    JIRA_GET_ALL_PERMISSION_SCHEMES: 'Action'
    JIRA_GET_ALL_PROJECTS: 'Action'
    JIRA_GET_ALL_PROJECT_AVATARS: 'Action'
    JIRA_GET_ALL_PROJECT_CATEGORIES: 'Action'
    JIRA_GET_ALL_PROJECT_ROLES: 'Action'
    JIRA_GET_ALL_PROJECT_TYPES: 'Action'
    JIRA_GET_ALL_SCREEN_TABS: 'Action'
    JIRA_GET_ALL_SCREEN_TAB_FIELDS: 'Action'
    JIRA_GET_ALL_STATUSES: 'Action'
    JIRA_GET_ALL_STATUSES_FOR_PROJECT: 'Action'
    JIRA_GET_ALL_STATUS_CATEGORIES: 'Action'
    JIRA_GET_ALL_TIME_TRACKING_PROVIDERS: 'Action'
    JIRA_GET_ALL_USERS: 'Action'
    JIRA_GET_ALL_USERS_DEFAULT: 'Action'
    JIRA_GET_ALL_WORKFLOWS: 'Action'
    JIRA_GET_ALL_WORKFLOW_SCHEMES: 'Action'
    JIRA_GET_ALTERNATIVE_ISSUE_TYPES: 'Action'
    JIRA_GET_ANNOUNCEMENT_BANNER_CONFIGURATION: 'Action'
    JIRA_GET_APPLICATION_PROPERTY: 'Action'
    JIRA_GET_APPLICATION_ROLE: 'Action'
    JIRA_GET_APPROXIMATE_APPLICATION_LICENSE_COUNT: 'Action'
    JIRA_GET_APPROXIMATE_LICENSE_COUNT: 'Action'
    JIRA_GET_APP_PROPERTIES: 'Action'
    JIRA_GET_APP_PROPERTY: 'Action'
    JIRA_GET_ASSIGNED_PERMISSION_SCHEME: 'Action'
    JIRA_GET_ATTACHMENT_CONTENT: 'Action'
    JIRA_GET_ATTACHMENT_METADATA: 'Action'
    JIRA_GET_ATTACHMENT_THUMBNAIL: 'Action'
    JIRA_GET_AUDIT_RECORDS: 'Action'
    JIRA_GET_AVAILABLE_GADGETS: 'Action'
    JIRA_GET_AVAILABLE_SCREEN_FIELDS: 'Action'
    JIRA_GET_AVAILABLE_WORKFLOW_CAPABILITIES: 'Action'
    JIRA_GET_AVATARS: 'Action'
    JIRA_GET_AVATAR_IMAGE_BY_ID: 'Action'
    JIRA_GET_AVATAR_IMAGE_BY_OWNER: 'Action'
    JIRA_GET_AVATAR_IMAGE_BY_TYPE: 'Action'
    JIRA_GET_BULK_PERMISSIONS: 'Action'
    JIRA_GET_BULK_SCREEN_TABS: 'Action'
    JIRA_GET_CHANGELOGS: 'Action'
    JIRA_GET_CHANGELOGS_BY_IDS: 'Action'
    JIRA_GET_COLUMNS: 'Action'
    JIRA_GET_COMMENT: 'Action'
    JIRA_GET_COMMENTS: 'Action'
    JIRA_GET_COMMENTS_BY_IDS: 'Action'
    JIRA_GET_COMMENT_PROPERTY: 'Action'
    JIRA_GET_COMMENT_PROPERTY_KEYS: 'Action'
    JIRA_GET_COMPONENT: 'Action'
    JIRA_GET_COMPONENT_ISSUES_COUNT: 'Action'
    JIRA_GET_CONTENTS_METADATA_FOR_AN_EXPANDED_ATTACHMENT: 'Action'
    JIRA_GET_CONTEXTS_FOR_A_FIELD: 'Action'
    JIRA_GET_CREATE_FIELD_METADATA_FOR_A_PROJECT_AND_ISSUE_TYPE_ID: 'Action'
    JIRA_GET_CREATE_ISSUE_METADATA: 'Action'
    JIRA_GET_CREATE_METADATA_ISSUE_TYPES_FOR_A_PROJECT: 'Action'
    JIRA_GET_CURRENT_USER: 'Action'
    JIRA_GET_CUSTOM_FIELD_CONFIGURATIONS: 'Action'
    JIRA_GET_CUSTOM_FIELD_CONTEXTS: 'Action'
    JIRA_GET_CUSTOM_FIELD_CONTEXTS_DEFAULT_VALUES: 'Action'
    JIRA_GET_CUSTOM_FIELD_CONTEXTS_FOR_PROJECTS_AND_ISSUE_TYPES: 'Action'
    JIRA_GET_CUSTOM_FIELD_OPTION: 'Action'
    JIRA_GET_CUSTOM_FIELD_OPTIONS_CONTEXT: 'Action'
    JIRA_GET_DASHBOARD: 'Action'
    JIRA_GET_DASHBOARD_ITEM_PROPERTY: 'Action'
    JIRA_GET_DASHBOARD_ITEM_PROPERTY_KEYS: 'Action'
    JIRA_GET_DATA_POLICY_FOR_PROJECTS_EAP: 'Action'
    JIRA_GET_DATA_POLICY_FOR_THE_WORKSPACE_EAP: 'Action'
    JIRA_GET_DEFAULT_ACTORS_FOR_PROJECT_ROLE: 'Action'
    JIRA_GET_DEFAULT_SHARE_SCOPE: 'Action'
    JIRA_GET_DEFAULT_WORKFLOW: 'Action'
    JIRA_GET_DRAFT_DEFAULT_WORKFLOW: 'Action'
    JIRA_GET_DRAFT_WORKFLOW_SCHEME: 'Action'
    JIRA_GET_DYNAMIC_WEBHOOKS_FOR_APP: 'Action'
    JIRA_GET_EDIT_ISSUE_METADATA: 'Action'
    JIRA_GET_EVENTS: 'Action'
    JIRA_GET_FAILED_WEBHOOKS: 'Action'
    JIRA_GET_FAVORITE_FILTERS: 'Action'
    JIRA_GET_FIELDS: 'Action'
    JIRA_GET_FIELDS_IN_TRASH_PAGINATED: 'Action'
    JIRA_GET_FIELDS_PAGINATED: 'Action'
    JIRA_GET_FIELD_AUTO_COMPLETE_SUGGESTIONS: 'Action'
    JIRA_GET_FIELD_CONFIGURATION_ISSUE_TYPE_ITEMS: 'Action'
    JIRA_GET_FIELD_CONFIGURATION_ITEMS: 'Action'
    JIRA_GET_FIELD_CONFIGURATION_SCHEMES_FOR_PROJECTS: 'Action'
    JIRA_GET_FIELD_REFERENCE_DATA_GET: 'Action'
    JIRA_GET_FIELD_REFERENCE_DATA_POST: 'Action'
    JIRA_GET_FILTER: 'Action'
    JIRA_GET_GADGETS: 'Action'
    JIRA_GET_GLOBAL_SETTINGS: 'Action'
    JIRA_GET_GROUP: 'Action'
    JIRA_GET_IDS_OF_DELETED_WORKLOGS: 'Action'
    JIRA_GET_IDS_OF_UPDATED_WORKLOGS: 'Action'
    JIRA_GET_ISSUE: 'Action'
    JIRA_GET_ISSUE_FIELD_OPTION: 'Action'
    JIRA_GET_ISSUE_LINK: 'Action'
    JIRA_GET_ISSUE_LINK_TYPE: 'Action'
    JIRA_GET_ISSUE_LINK_TYPES: 'Action'
    JIRA_GET_ISSUE_NAVIGATOR_DEFAULT_COLUMNS: 'Action'
    JIRA_GET_ISSUE_PICKER_SUGGESTIONS: 'Action'
    JIRA_GET_ISSUE_PROPERTY: 'Action'
    JIRA_GET_ISSUE_PROPERTY_KEYS: 'Action'
    JIRA_GET_ISSUE_SECURITY_LEVEL: 'Action'
    JIRA_GET_ISSUE_SECURITY_LEVELS: 'Action'
    JIRA_GET_ISSUE_SECURITY_LEVEL_MEMBERS: 'Action'
    JIRA_GET_ISSUE_SECURITY_LEVEL_MEMBERS_BY_ISSUE_SECURITY_SCHEME: 'Action'
    JIRA_GET_ISSUE_SECURITY_SCHEME: 'Action'
    JIRA_GET_ISSUE_SECURITY_SCHEMES: 'Action'
    JIRA_GET_ISSUE_TYPE: 'Action'
    JIRA_GET_ISSUE_TYPES_FOR_CUSTOM_FIELD_CONTEXT: 'Action'
    JIRA_GET_ISSUE_TYPES_FOR_PROJECT: 'Action'
    JIRA_GET_ISSUE_TYPES_FOR_WORKFLOWS_IN_DRAFT_WORKFLOW_SCHEME: 'Action'
    JIRA_GET_ISSUE_TYPES_FOR_WORKFLOWS_IN_WORKFLOW_SCHEME: 'Action'
    JIRA_GET_ISSUE_TYPE_PROPERTY: 'Action'
    JIRA_GET_ISSUE_TYPE_PROPERTY_KEYS: 'Action'
    JIRA_GET_ISSUE_TYPE_SCHEMES_FOR_PROJECTS: 'Action'
    JIRA_GET_ISSUE_TYPE_SCHEME_ITEMS: 'Action'
    JIRA_GET_ISSUE_TYPE_SCREEN_SCHEMES: 'Action'
    JIRA_GET_ISSUE_TYPE_SCREEN_SCHEMES_FOR_PROJECTS: 'Action'
    JIRA_GET_ISSUE_TYPE_SCREEN_SCHEME_ITEMS: 'Action'
    JIRA_GET_ISSUE_TYPE_SCREEN_SCHEME_PROJECTS: 'Action'
    JIRA_GET_ISSUE_WATCHERS: 'Action'
    JIRA_GET_ISSUE_WORKLOGS: 'Action'
    JIRA_GET_IS_WATCHING_ISSUE_BULK: 'Action'
    JIRA_GET_JIRA_ATTACHMENT_SETTINGS: 'Action'
    JIRA_GET_JIRA_INSTANCE_INFO: 'Action'
    JIRA_GET_LICENSE: 'Action'
    JIRA_GET_LICENSED_PROJECT_TYPES: 'Action'
    JIRA_GET_LOCALE: 'Action'
    JIRA_GET_MODULES: 'Action'
    JIRA_GET_MY_FILTERS: 'Action'
    JIRA_GET_MY_PERMISSIONS: 'Action'
    JIRA_GET_NOTIFICATION_SCHEME: 'Action'
    JIRA_GET_NOTIFICATION_SCHEMES_PAGINATED: 'Action'
    JIRA_GET_PERMISSION_SCHEME: 'Action'
    JIRA_GET_PERMISSION_SCHEME_GRANT: 'Action'
    JIRA_GET_PERMISSION_SCHEME_GRANTS: 'Action'
    JIRA_GET_PERMITTED_PROJECTS: 'Action'
    JIRA_GET_PRECOMPUTATIONS_APPS: 'Action'
    JIRA_GET_PREFERENCE: 'Action'
    JIRA_GET_PRIORITIES: 'Action'
    JIRA_GET_PRIORITY: 'Action'
    JIRA_GET_PROJECT: 'Action'
    JIRA_GET_PROJECTS_PAGINATED: 'Action'
    JIRA_GET_PROJECTS_USING_ISSUE_SECURITY_SCHEMES: 'Action'
    JIRA_GET_PROJECTS_USING_NOTIFICATION_SCHEMES_PAGINATED: 'Action'
    JIRA_GET_PROJECT_CATEGORY_BY_ID: 'Action'
    JIRA_GET_PROJECT_COMPONENTS: 'Action'
    JIRA_GET_PROJECT_COMPONENTS_PAGINATED: 'Action'
    JIRA_GET_PROJECT_FEATURES: 'Action'
    JIRA_GET_PROJECT_ISSUE_SECURITY_LEVELS: 'Action'
    JIRA_GET_PROJECT_ISSUE_SECURITY_SCHEME: 'Action'
    JIRA_GET_PROJECT_ISSUE_TYPE_HIERARCHY: 'Action'
    JIRA_GET_PROJECT_MAPPINGS_FOR_CUSTOM_FIELD_CONTEXT: 'Action'
    JIRA_GET_PROJECT_NOTIFICATION_SCHEME: 'Action'
    JIRA_GET_PROJECT_PROPERTY: 'Action'
    JIRA_GET_PROJECT_PROPERTY_KEYS: 'Action'
    JIRA_GET_PROJECT_ROLES_FOR_PROJECT: 'Action'
    JIRA_GET_PROJECT_ROLE_BY_ID: 'Action'
    JIRA_GET_PROJECT_ROLE_DETAILS: 'Action'
    JIRA_GET_PROJECT_ROLE_FOR_PROJECT: 'Action'
    JIRA_GET_PROJECT_S_SENDER_EMAIL: 'Action'
    JIRA_GET_PROJECT_TYPE_BY_KEY: 'Action'
    JIRA_GET_PROJECT_VERSIONS: 'Action'
    JIRA_GET_PROJECT_VERSIONS_PAGINATED: 'Action'
    JIRA_GET_RECENT_PROJECTS: 'Action'
    JIRA_GET_RELATED_WORK: 'Action'
    JIRA_GET_REMOTE_ISSUE_LINKS: 'Action'
    JIRA_GET_REMOTE_ISSUE_LINK_BY_ID: 'Action'
    JIRA_GET_REQUIRED_STATUS_MAPPINGS_FOR_WORKFLOW_SCHEME_UPDATE: 'Action'
    JIRA_GET_RESOLUTION: 'Action'
    JIRA_GET_RESOLUTIONS: 'Action'
    JIRA_GET_SCREENS: 'Action'
    JIRA_GET_SCREENS_FOR_A_FIELD: 'Action'
    JIRA_GET_SCREEN_SCHEMES: 'Action'
    JIRA_GET_SELECTABLE_ISSUE_FIELD_OPTIONS: 'Action'
    JIRA_GET_SELECTED_TIME_TRACKING_PROVIDER: 'Action'
    JIRA_GET_SHARE_PERMISSION: 'Action'
    JIRA_GET_SHARE_PERMISSIONS: 'Action'
    JIRA_GET_STATUS: 'Action'
    JIRA_GET_STATUS_CATEGORY: 'Action'
    JIRA_GET_SYSTEM_AVATARS_BY_TYPE: 'Action'
    JIRA_GET_TASK: 'Action'
    JIRA_GET_THE_DEFAULT_DATA_CLASSIFICATION_LEVEL_OF_A_PROJECT: 'Action'
    JIRA_GET_TIME_TRACKING_SETTINGS: 'Action'
    JIRA_GET_TRANSITIONS: 'Action'
    JIRA_GET_UI_MODIFICATIONS: 'Action'
    JIRA_GET_USER: 'Action'
    JIRA_GET_USERS_FROM_GROUP: 'Action'
    JIRA_GET_USER_DEFAULT_COLUMNS: 'Action'
    JIRA_GET_USER_EMAIL: 'Action'
    JIRA_GET_USER_EMAIL_BULK: 'Action'
    JIRA_GET_USER_GROUPS: 'Action'
    JIRA_GET_USER_PROPERTY: 'Action'
    JIRA_GET_USER_PROPERTY_KEYS: 'Action'
    JIRA_GET_VALID_PROJECT_KEY: 'Action'
    JIRA_GET_VALID_PROJECT_NAME: 'Action'
    JIRA_GET_VERSION: 'Action'
    JIRA_GET_VERSION_S_RELATED_ISSUES_COUNT: 'Action'
    JIRA_GET_VERSION_S_UNRESOLVED_ISSUES_COUNT: 'Action'
    JIRA_GET_VISIBLE_ISSUE_FIELD_OPTIONS: 'Action'
    JIRA_GET_VOTES: 'Action'
    JIRA_GET_WORKFLOWS_PAGINATED: 'Action'
    JIRA_GET_WORKFLOW_FOR_ISSUE_TYPE_IN_DRAFT_WORKFLOW_SCHEME: 'Action'
    JIRA_GET_WORKFLOW_FOR_ISSUE_TYPE_IN_WORKFLOW_SCHEME: 'Action'
    JIRA_GET_WORKFLOW_SCHEME: 'Action'
    JIRA_GET_WORKFLOW_SCHEME_PROJECT_ASSOCIATIONS: 'Action'
    JIRA_GET_WORKFLOW_TRANSITION_PROPERTIES: 'Action'
    JIRA_GET_WORKFLOW_TRANSITION_RULE_CONFIGURATIONS: 'Action'
    JIRA_GET_WORKLOG: 'Action'
    JIRA_GET_WORKLOGS: 'Action'
    JIRA_GET_WORKLOG_PROPERTY: 'Action'
    JIRA_GET_WORKLOG_PROPERTY_KEYS: 'Action'
    JIRA_MAP_ISSUE_TYPES_TO_SCHEME_WORKFLOWS: 'Action'
    JIRA_MERGE_VERSIONS: 'Action'
    JIRA_MOVE_CUSTOM_FIELD_TO_TRASH: 'Action'
    JIRA_MOVE_PRIORITIES: 'Action'
    JIRA_MOVE_RESOLUTIONS: 'Action'
    JIRA_MOVE_SCREEN_TAB: 'Action'
    JIRA_MOVE_SCREEN_TAB_FIELD: 'Action'
    JIRA_MOVE_VERSION: 'Action'
    JIRA_PARSE_JQL_QUERY: 'Action'
    JIRA_PARTIAL_UPDATE_PROJECT_ROLE: 'Action'
    JIRA_PUBLISH_DRAFT_WORKFLOW_SCHEME: 'Action'
    JIRA_REGISTER_DYNAMIC_WEBHOOKS: 'Action'
    JIRA_REGISTER_MODULES: 'Action'
    JIRA_REMOVE_CUSTOM_FIELD_CONTEXT_FROM_PROJECTS: 'Action'
    JIRA_REMOVE_FILTER_AS_FAVORITE: 'Action'
    JIRA_REMOVE_GADGET_FROM_DASHBOARD: 'Action'
    JIRA_REMOVE_GROUP: 'Action'
    JIRA_REMOVE_ISSUE_SECURITY_LEVEL: 'Action'
    JIRA_REMOVE_ISSUE_TYPES_FROM_CONTEXT: 'Action'
    JIRA_REMOVE_ISSUE_TYPES_FROM_FIELD_CONFIGURATION_SCHEME: 'Action'
    JIRA_REMOVE_ISSUE_TYPE_FROM_ISSUE_TYPE_SCHEME: 'Action'
    JIRA_REMOVE_MAPPINGS_FROM_ISSUE_TYPE_SCREEN_SCHEME: 'Action'
    JIRA_REMOVE_MEMBER_FROM_ISSUE_SECURITY_LEVEL: 'Action'
    JIRA_REMOVE_MODULES: 'Action'
    JIRA_REMOVE_NOTIFICATION_FROM_NOTIFICATION_SCHEME: 'Action'
    JIRA_REMOVE_SCREEN_TAB_FIELD: 'Action'
    JIRA_REMOVE_THE_DEFAULT_DATA_CLASSIFICATION_LEVEL_FROM_A_PROJECT: 'Action'
    JIRA_REMOVE_USER_FROM_GROUP: 'Action'
    JIRA_REORDER_CUSTOM_FIELD_OPTIONS_CONTEXT: 'Action'
    JIRA_REPLACE_CUSTOM_FIELD_OPTIONS: 'Action'
    JIRA_REPLACE_ISSUE_FIELD_OPTION: 'Action'
    JIRA_RESET_COLUMNS: 'Action'
    JIRA_RESET_USER_DEFAULT_COLUMNS: 'Action'
    JIRA_RESTORE_CUSTOM_FIELD_FROM_TRASH: 'Action'
    JIRA_RESTORE_DELETED_OR_ARCHIVED_PROJECT: 'Action'
    JIRA_RETRIEVE_THE_ATTRIBUTES_OF_SERVICE_REGISTRIES: 'Action'
    JIRA_SANITIZE_JQL_QUERIES: 'Action'
    JIRA_SEARCH_FOR_DASHBOARDS: 'Action'
    JIRA_SEARCH_FOR_FILTERS: 'Action'
    JIRA_SEARCH_FOR_ISSUES_USING_JQL_GET: 'Action'
    JIRA_SEARCH_FOR_ISSUES_USING_JQL_POST: 'Action'
    JIRA_SEARCH_ISSUE_IDS_USING_JQL: 'Action'
    JIRA_SEARCH_ISSUE_SECURITY_SCHEMES: 'Action'
    JIRA_SEARCH_PRIORITIES: 'Action'
    JIRA_SEARCH_RESOLUTIONS: 'Action'
    JIRA_SEARCH_STATUSES_PAGINATED: 'Action'
    JIRA_SELECT_TIME_TRACKING_PROVIDER: 'Action'
    JIRA_SEND_NOTIFICATION_FOR_ISSUE: 'Action'
    JIRA_SET_ACTORS_FOR_PROJECT_ROLE: 'Action'
    JIRA_SET_APPLICATION_PROPERTY: 'Action'
    JIRA_SET_APP_PROPERTY: 'Action'
    JIRA_SET_APP_PROPERTY_FORGE: 'Action'
    JIRA_SET_COLUMNS: 'Action'
    JIRA_SET_COMMENT_PROPERTY: 'Action'
    JIRA_SET_CUSTOM_FIELD_CONTEXTS_DEFAULT_VALUES: 'Action'
    JIRA_SET_DASHBOARD_ITEM_PROPERTY: 'Action'
    JIRA_SET_DEFAULT_ISSUE_SECURITY_LEVELS: 'Action'
    JIRA_SET_DEFAULT_PRIORITY: 'Action'
    JIRA_SET_DEFAULT_RESOLUTION: 'Action'
    JIRA_SET_DEFAULT_SHARE_SCOPE: 'Action'
    JIRA_SET_ISSUE_NAVIGATOR_DEFAULT_COLUMNS: 'Action'
    JIRA_SET_ISSUE_PROPERTY: 'Action'
    JIRA_SET_ISSUE_TYPES_FOR_WORKFLOW_IN_WORKFLOW_SCHEME: 'Action'
    JIRA_SET_ISSUE_TYPE_PROPERTY: 'Action'
    JIRA_SET_LOCALE: 'Action'
    JIRA_SET_PREFERENCE: 'Action'
    JIRA_SET_PROJECT_AVATAR: 'Action'
    JIRA_SET_PROJECT_FEATURE_STATE: 'Action'
    JIRA_SET_PROJECT_PROPERTY: 'Action'
    JIRA_SET_PROJECT_S_SENDER_EMAIL: 'Action'
    JIRA_SET_TIME_TRACKING_SETTINGS: 'Action'
    JIRA_SET_USER_DEFAULT_COLUMNS: 'Action'
    JIRA_SET_USER_PROPERTY: 'Action'
    JIRA_SET_WORKFLOW_FOR_ISSUE_TYPE_IN_DRAFT_WORKFLOW_SCHEME: 'Action'
    JIRA_SET_WORKFLOW_FOR_ISSUE_TYPE_IN_WORKFLOW_SCHEME: 'Action'
    JIRA_SET_WORKLOG_PROPERTY: 'Action'
    JIRA_TRANSITION_ISSUE: 'Action'
    JIRA_UNARCHIVE_ISSUE_S_BY_ISSUE_KEYS_ID: 'Action'
    JIRA_UPDATE_ANNOUNCEMENT_BANNER_CONFIGURATION: 'Action'
    JIRA_UPDATE_COMMENT: 'Action'
    JIRA_UPDATE_COMPONENT: 'Action'
    JIRA_UPDATE_CUSTOM_FIELD: 'Action'
    JIRA_UPDATE_CUSTOM_FIELDS: 'Action'
    JIRA_UPDATE_CUSTOM_FIELD_CONFIGURATIONS: 'Action'
    JIRA_UPDATE_CUSTOM_FIELD_CONTEXT: 'Action'
    JIRA_UPDATE_CUSTOM_FIELD_OPTIONS_CONTEXT: 'Action'
    JIRA_UPDATE_CUSTOM_FIELD_VALUE: 'Action'
    JIRA_UPDATE_DASHBOARD: 'Action'
    JIRA_UPDATE_DEFAULT_WORKFLOW: 'Action'
    JIRA_UPDATE_DRAFT_DEFAULT_WORKFLOW: 'Action'
    JIRA_UPDATE_DRAFT_WORKFLOW_SCHEME: 'Action'
    JIRA_UPDATE_FIELD_CONFIGURATION: 'Action'
    JIRA_UPDATE_FIELD_CONFIGURATION_ITEMS: 'Action'
    JIRA_UPDATE_FIELD_CONFIGURATION_SCHEME: 'Action'
    JIRA_UPDATE_FILTER: 'Action'
    JIRA_UPDATE_GADGET_ON_DASHBOARD: 'Action'
    JIRA_UPDATE_ISSUE_FIELD_OPTION: 'Action'
    JIRA_UPDATE_ISSUE_LINK_TYPE: 'Action'
    JIRA_UPDATE_ISSUE_SECURITY_LEVEL: 'Action'
    JIRA_UPDATE_ISSUE_SECURITY_SCHEME: 'Action'
    JIRA_UPDATE_ISSUE_TYPE: 'Action'
    JIRA_UPDATE_ISSUE_TYPE_SCHEME: 'Action'
    JIRA_UPDATE_ISSUE_TYPE_SCREEN_SCHEME: 'Action'
    JIRA_UPDATE_ISSUE_TYPE_SCREEN_SCHEME_DEFAULT_SCREEN_SCHEME: 'Action'
    JIRA_UPDATE_NOTIFICATION_SCHEME: 'Action'
    JIRA_UPDATE_PERMISSION_SCHEME: 'Action'
    JIRA_UPDATE_PRECOMPUTATIONS_APPS: 'Action'
    JIRA_UPDATE_PRIORITY: 'Action'
    JIRA_UPDATE_PROJECT: 'Action'
    JIRA_UPDATE_PROJECT_CATEGORY: 'Action'
    JIRA_UPDATE_RELATED_WORK: 'Action'
    JIRA_UPDATE_REMOTE_ISSUE_LINK_BY_ID: 'Action'
    JIRA_UPDATE_RESOLUTION: 'Action'
    JIRA_UPDATE_SCREEN: 'Action'
    JIRA_UPDATE_SCREEN_SCHEME: 'Action'
    JIRA_UPDATE_SCREEN_TAB: 'Action'
    JIRA_UPDATE_THE_DEFAULT_DATA_CLASSIFICATION_LEVEL_OF_A_PROJECT: 'Action'
    JIRA_UPDATE_UI_MODIFICATION: 'Action'
    JIRA_UPDATE_VERSION: 'Action'
    JIRA_UPDATE_WORKFLOW_SCHEME: 'Action'
    JIRA_UPDATE_WORKFLOW_TRANSITION_PROPERTY: 'Action'
    JIRA_UPDATE_WORKFLOW_TRANSITION_RULE_CONFIGURATIONS: 'Action'
    JIRA_UPDATE_WORKLOG: 'Action'
    JIRA_VALIDATE_CREATE_WORKFLOWS: 'Action'
    JIRA_VALIDATE_PROJECT_KEY: 'Action'
    JIRA_VALIDATE_UPDATE_WORKFLOWS: 'Action'
    JUNGLESCOUT_QUERY_THE_PRODUCT_DATABASE: 'Action'
    JUNGLESCOUT_RETRIEVE_DATA_FOR_A_SPECIFIC_KEYWORD_QUERY: 'Action'
    JUNGLESCOUT_RETRIEVE_HISTORICAL_SEARCH_VOLUME_DATA_FOR_SPECIFIED_KEYWORDS: 'Action'
    JUNGLESCOUT_RETRIEVE_KEYWORD_DATA_FOR_SPECIFIED_ASINS: 'Action'
    JUNGLESCOUT_RETRIEVE_SALES_ESTIMATES_DATA: 'Action'
    JUNGLESCOUT_RETRIEVE_SHARE_OF_VOICE_DATA: 'Action'
    KLAVIYO_ADD_PROFILE_TO_LIST: 'Action'
    KLAVIYO_ASSIGN_CAMPAIGN_MESSAGE_TEMPLATE: 'Action'
    KLAVIYO_BULK_CREATE_CLIENT_EVENTS: 'Action'
    KLAVIYO_BULK_CREATE_EVENTS: 'Action'
    KLAVIYO_CREATE_BACK_IN_STOCK_SUBSCRIPTION: 'Action'
    KLAVIYO_CREATE_CAMPAIGN: 'Action'
    KLAVIYO_CREATE_CAMPAIGN_CLONE: 'Action'
    KLAVIYO_CREATE_CAMPAIGN_RECIPIENT_ESTIMATION_JOB: 'Action'
    KLAVIYO_CREATE_CAMPAIGN_SEND_JOB: 'Action'
    KLAVIYO_CREATE_CATALOG_CATEGORY: 'Action'
    KLAVIYO_CREATE_CATALOG_CATEGORY_RELATIONSHIPS_ITEMS: 'Action'
    KLAVIYO_CREATE_CATALOG_ITEM: 'Action'
    KLAVIYO_CREATE_CATALOG_ITEM_RELATIONSHIPS_CATEGORIES: 'Action'
    KLAVIYO_CREATE_CATALOG_VARIANT: 'Action'
    KLAVIYO_CREATE_CLIENT_BACK_IN_STOCK_SUBSCRIPTION: 'Action'
    KLAVIYO_CREATE_CLIENT_EVENT: 'Action'
    KLAVIYO_CREATE_CLIENT_SUBSCRIPTION: 'Action'
    KLAVIYO_CREATE_COUPON: 'Action'
    KLAVIYO_CREATE_COUPON_CODE: 'Action'
    KLAVIYO_CREATE_EVENT: 'Action'
    KLAVIYO_CREATE_LIST: 'Action'
    KLAVIYO_CREATE_OR_UPDATE_CLIENT_PROFILE: 'Action'
    KLAVIYO_CREATE_OR_UPDATE_CLIENT_PUSH_TOKEN: 'Action'
    KLAVIYO_CREATE_OR_UPDATE_PROFILE: 'Action'
    KLAVIYO_CREATE_OR_UPDATE_PUSH_TOKEN: 'Action'
    KLAVIYO_CREATE_PROFILE: 'Action'
    KLAVIYO_CREATE_SEGMENT: 'Action'
    KLAVIYO_CREATE_TAG: 'Action'
    KLAVIYO_CREATE_TAG_GROUP: 'Action'
    KLAVIYO_CREATE_TAG_RELATIONSHIPS_CAMPAIGNS: 'Action'
    KLAVIYO_CREATE_TAG_RELATIONSHIPS_FLOWS: 'Action'
    KLAVIYO_CREATE_TAG_RELATIONSHIPS_LISTS: 'Action'
    KLAVIYO_CREATE_TAG_RELATIONSHIPS_SEGMENTS: 'Action'
    KLAVIYO_CREATE_TEMPLATE: 'Action'
    KLAVIYO_CREATE_TEMPLATE_CLONE: 'Action'
    KLAVIYO_CREATE_TEMPLATE_RENDER: 'Action'
    KLAVIYO_CREATE_WEBHOOK: 'Action'
    KLAVIYO_DELETE_CAMPAIGN: 'Action'
    KLAVIYO_DELETE_CATALOG_CATEGORY: 'Action'
    KLAVIYO_DELETE_CATALOG_CATEGORY_RELATIONSHIPS_ITEMS: 'Action'
    KLAVIYO_DELETE_CATALOG_ITEM: 'Action'
    KLAVIYO_DELETE_CATALOG_ITEM_RELATIONSHIPS_CATEGORIES: 'Action'
    KLAVIYO_DELETE_CATALOG_VARIANT: 'Action'
    KLAVIYO_DELETE_COUPON: 'Action'
    KLAVIYO_DELETE_COUPON_CODE: 'Action'
    KLAVIYO_DELETE_FLOW: 'Action'
    KLAVIYO_DELETE_LIST: 'Action'
    KLAVIYO_DELETE_SEGMENT: 'Action'
    KLAVIYO_DELETE_TAG: 'Action'
    KLAVIYO_DELETE_TAG_GROUP: 'Action'
    KLAVIYO_DELETE_TAG_RELATIONSHIPS_CAMPAIGNS: 'Action'
    KLAVIYO_DELETE_TAG_RELATIONSHIPS_FLOWS: 'Action'
    KLAVIYO_DELETE_TAG_RELATIONSHIPS_LISTS: 'Action'
    KLAVIYO_DELETE_TAG_RELATIONSHIPS_SEGMENTS: 'Action'
    KLAVIYO_DELETE_TEMPLATE: 'Action'
    KLAVIYO_DELETE_WEBHOOK: 'Action'
    KLAVIYO_GET_ACCOUNT: 'Action'
    KLAVIYO_GET_ACCOUNTS: 'Action'
    KLAVIYO_GET_BULK_PROFILE_IMPORT_JOB: 'Action'
    KLAVIYO_GET_BULK_PROFILE_IMPORT_JOBS: 'Action'
    KLAVIYO_GET_BULK_PROFILE_IMPORT_JOB_ERRORS: 'Action'
    KLAVIYO_GET_BULK_PROFILE_IMPORT_JOB_LISTS: 'Action'
    KLAVIYO_GET_BULK_PROFILE_IMPORT_JOB_PROFILES: 'Action'
    KLAVIYO_GET_BULK_PROFILE_IMPORT_JOB_RELATIONSHIPS_LISTS: 'Action'
    KLAVIYO_GET_BULK_PROFILE_IMPORT_JOB_RELATIONSHIPS_PROFILES: 'Action'
    KLAVIYO_GET_CAMPAIGN: 'Action'
    KLAVIYO_GET_CAMPAIGNS: 'Action'
    KLAVIYO_GET_CAMPAIGN_CAMPAIGN_MESSAGES: 'Action'
    KLAVIYO_GET_CAMPAIGN_MESSAGE: 'Action'
    KLAVIYO_GET_CAMPAIGN_MESSAGE_CAMPAIGN: 'Action'
    KLAVIYO_GET_CAMPAIGN_MESSAGE_RELATIONSHIPS_CAMPAIGN: 'Action'
    KLAVIYO_GET_CAMPAIGN_MESSAGE_RELATIONSHIPS_TEMPLATE: 'Action'
    KLAVIYO_GET_CAMPAIGN_MESSAGE_TEMPLATE: 'Action'
    KLAVIYO_GET_CAMPAIGN_RECIPIENT_ESTIMATION: 'Action'
    KLAVIYO_GET_CAMPAIGN_RECIPIENT_ESTIMATION_JOB: 'Action'
    KLAVIYO_GET_CAMPAIGN_RELATIONSHIPS_CAMPAIGN_MESSAGES: 'Action'
    KLAVIYO_GET_CAMPAIGN_RELATIONSHIPS_TAGS: 'Action'
    KLAVIYO_GET_CAMPAIGN_SEND_JOB: 'Action'
    KLAVIYO_GET_CAMPAIGN_TAGS: 'Action'
    KLAVIYO_GET_CATALOG_CATEGORIES: 'Action'
    KLAVIYO_GET_CATALOG_CATEGORY: 'Action'
    KLAVIYO_GET_CATALOG_CATEGORY_ITEMS: 'Action'
    KLAVIYO_GET_CATALOG_CATEGORY_RELATIONSHIPS_ITEMS: 'Action'
    KLAVIYO_GET_CATALOG_ITEM: 'Action'
    KLAVIYO_GET_CATALOG_ITEMS: 'Action'
    KLAVIYO_GET_CATALOG_ITEM_CATEGORIES: 'Action'
    KLAVIYO_GET_CATALOG_ITEM_RELATIONSHIPS_CATEGORIES: 'Action'
    KLAVIYO_GET_CATALOG_ITEM_VARIANTS: 'Action'
    KLAVIYO_GET_CATALOG_VARIANT: 'Action'
    KLAVIYO_GET_CATALOG_VARIANTS: 'Action'
    KLAVIYO_GET_COUPON: 'Action'
    KLAVIYO_GET_COUPONS: 'Action'
    KLAVIYO_GET_COUPON_CODE: 'Action'
    KLAVIYO_GET_COUPON_CODES: 'Action'
    KLAVIYO_GET_COUPON_CODES_FOR_COUPON: 'Action'
    KLAVIYO_GET_COUPON_CODE_BULK_CREATE_JOB: 'Action'
    KLAVIYO_GET_COUPON_CODE_BULK_CREATE_JOBS: 'Action'
    KLAVIYO_GET_COUPON_CODE_RELATIONSHIPS_COUPON: 'Action'
    KLAVIYO_GET_COUPON_FOR_COUPON_CODE: 'Action'
    KLAVIYO_GET_COUPON_RELATIONSHIPS_COUPON_CODES: 'Action'
    KLAVIYO_GET_CREATE_CATEGORIES_JOB: 'Action'
    KLAVIYO_GET_CREATE_CATEGORIES_JOBS: 'Action'
    KLAVIYO_GET_CREATE_ITEMS_JOB: 'Action'
    KLAVIYO_GET_CREATE_ITEMS_JOBS: 'Action'
    KLAVIYO_GET_CREATE_VARIANTS_JOB: 'Action'
    KLAVIYO_GET_CREATE_VARIANTS_JOBS: 'Action'
    KLAVIYO_GET_DELETE_CATEGORIES_JOB: 'Action'
    KLAVIYO_GET_DELETE_CATEGORIES_JOBS: 'Action'
    KLAVIYO_GET_DELETE_ITEMS_JOB: 'Action'
    KLAVIYO_GET_DELETE_ITEMS_JOBS: 'Action'
    KLAVIYO_GET_DELETE_VARIANTS_JOB: 'Action'
    KLAVIYO_GET_DELETE_VARIANTS_JOBS: 'Action'
    KLAVIYO_GET_EVENT: 'Action'
    KLAVIYO_GET_EVENTS: 'Action'
    KLAVIYO_GET_EVENT_METRIC: 'Action'
    KLAVIYO_GET_EVENT_PROFILE: 'Action'
    KLAVIYO_GET_EVENT_RELATIONSHIPS_METRIC: 'Action'
    KLAVIYO_GET_EVENT_RELATIONSHIPS_PROFILE: 'Action'
    KLAVIYO_GET_FLOW: 'Action'
    KLAVIYO_GET_FLOWS: 'Action'
    KLAVIYO_GET_FLOW_ACTION: 'Action'
    KLAVIYO_GET_FLOW_ACTION_FOR_MESSAGE: 'Action'
    KLAVIYO_GET_FLOW_ACTION_MESSAGES: 'Action'
    KLAVIYO_GET_FLOW_ACTION_RELATIONSHIPS_FLOW: 'Action'
    KLAVIYO_GET_FLOW_ACTION_RELATIONSHIPS_MESSAGES: 'Action'
    KLAVIYO_GET_FLOW_FLOW_ACTIONS: 'Action'
    KLAVIYO_GET_FLOW_FOR_FLOW_ACTION: 'Action'
    KLAVIYO_GET_FLOW_MESSAGE: 'Action'
    KLAVIYO_GET_FLOW_MESSAGE_RELATIONSHIPS_ACTION: 'Action'
    KLAVIYO_GET_FLOW_MESSAGE_RELATIONSHIPS_TEMPLATE: 'Action'
    KLAVIYO_GET_FLOW_MESSAGE_TEMPLATE: 'Action'
    KLAVIYO_GET_FLOW_RELATIONSHIPS_FLOW_ACTIONS: 'Action'
    KLAVIYO_GET_FLOW_RELATIONSHIPS_TAGS: 'Action'
    KLAVIYO_GET_FLOW_TAGS: 'Action'
    KLAVIYO_GET_FORM: 'Action'
    KLAVIYO_GET_FORMS: 'Action'
    KLAVIYO_GET_FORM_FOR_FORM_VERSION: 'Action'
    KLAVIYO_GET_FORM_ID_FOR_FORM_VERSION: 'Action'
    KLAVIYO_GET_FORM_VERSION: 'Action'
    KLAVIYO_GET_IMAGE: 'Action'
    KLAVIYO_GET_IMAGES: 'Action'
    KLAVIYO_GET_LIST: 'Action'
    KLAVIYO_GET_LISTS: 'Action'
    KLAVIYO_GET_LIST_PROFILES: 'Action'
    KLAVIYO_GET_LIST_RELATIONSHIPS_PROFILES: 'Action'
    KLAVIYO_GET_LIST_RELATIONSHIPS_TAGS: 'Action'
    KLAVIYO_GET_LIST_TAGS: 'Action'
    KLAVIYO_GET_METRIC: 'Action'
    KLAVIYO_GET_METRICS: 'Action'
    KLAVIYO_GET_PROFILE: 'Action'
    KLAVIYO_GET_PROFILES: 'Action'
    KLAVIYO_GET_PROFILE_LISTS: 'Action'
    KLAVIYO_GET_PROFILE_RELATIONSHIPS_LISTS: 'Action'
    KLAVIYO_GET_PROFILE_RELATIONSHIPS_SEGMENTS: 'Action'
    KLAVIYO_GET_PROFILE_SEGMENTS: 'Action'
    KLAVIYO_GET_SEGMENT: 'Action'
    KLAVIYO_GET_SEGMENTS: 'Action'
    KLAVIYO_GET_SEGMENT_PROFILES: 'Action'
    KLAVIYO_GET_SEGMENT_RELATIONSHIPS_PROFILES: 'Action'
    KLAVIYO_GET_SEGMENT_RELATIONSHIPS_TAGS: 'Action'
    KLAVIYO_GET_SEGMENT_TAGS: 'Action'
    KLAVIYO_GET_TAG: 'Action'
    KLAVIYO_GET_TAGS: 'Action'
    KLAVIYO_GET_TAG_GROUP: 'Action'
    KLAVIYO_GET_TAG_GROUPS: 'Action'
    KLAVIYO_GET_TAG_GROUP_RELATIONSHIPS_TAGS: 'Action'
    KLAVIYO_GET_TAG_GROUP_TAGS: 'Action'
    KLAVIYO_GET_TAG_RELATIONSHIPS_CAMPAIGNS: 'Action'
    KLAVIYO_GET_TAG_RELATIONSHIPS_FLOWS: 'Action'
    KLAVIYO_GET_TAG_RELATIONSHIPS_LISTS: 'Action'
    KLAVIYO_GET_TAG_RELATIONSHIPS_SEGMENTS: 'Action'
    KLAVIYO_GET_TAG_RELATIONSHIPS_TAG_GROUP: 'Action'
    KLAVIYO_GET_TAG_TAG_GROUP: 'Action'
    KLAVIYO_GET_TEMPLATE: 'Action'
    KLAVIYO_GET_TEMPLATES: 'Action'
    KLAVIYO_GET_UPDATE_CATEGORIES_JOB: 'Action'
    KLAVIYO_GET_UPDATE_CATEGORIES_JOBS: 'Action'
    KLAVIYO_GET_UPDATE_ITEMS_JOB: 'Action'
    KLAVIYO_GET_UPDATE_ITEMS_JOBS: 'Action'
    KLAVIYO_GET_UPDATE_VARIANTS_JOB: 'Action'
    KLAVIYO_GET_UPDATE_VARIANTS_JOBS: 'Action'
    KLAVIYO_GET_VERSIONS_FOR_FORM: 'Action'
    KLAVIYO_GET_VERSION_IDS_FOR_FORM: 'Action'
    KLAVIYO_GET_WEBHOOK: 'Action'
    KLAVIYO_GET_WEBHOOKS: 'Action'
    KLAVIYO_GET_WEBHOOK_TOPIC: 'Action'
    KLAVIYO_GET_WEBHOOK_TOPICS: 'Action'
    KLAVIYO_MERGE_PROFILES: 'Action'
    KLAVIYO_QUERY_CAMPAIGN_VALUES: 'Action'
    KLAVIYO_QUERY_FLOW_SERIES: 'Action'
    KLAVIYO_QUERY_FLOW_VALUES: 'Action'
    KLAVIYO_QUERY_METRIC_AGGREGATES: 'Action'
    KLAVIYO_REMOVE_PROFILE_FROM_LIST: 'Action'
    KLAVIYO_REQUEST_PROFILE_DELETION: 'Action'
    KLAVIYO_SPAWN_BULK_PROFILE_IMPORT_JOB: 'Action'
    KLAVIYO_SPAWN_COUPON_CODE_BULK_CREATE_JOB: 'Action'
    KLAVIYO_SPAWN_CREATE_CATEGORIES_JOB: 'Action'
    KLAVIYO_SPAWN_CREATE_ITEMS_JOB: 'Action'
    KLAVIYO_SPAWN_CREATE_VARIANTS_JOB: 'Action'
    KLAVIYO_SPAWN_DELETE_CATEGORIES_JOB: 'Action'
    KLAVIYO_SPAWN_DELETE_ITEMS_JOB: 'Action'
    KLAVIYO_SPAWN_DELETE_VARIANTS_JOB: 'Action'
    KLAVIYO_SPAWN_UPDATE_CATEGORIES_JOB: 'Action'
    KLAVIYO_SPAWN_UPDATE_ITEMS_JOB: 'Action'
    KLAVIYO_SPAWN_UPDATE_VARIANTS_JOB: 'Action'
    KLAVIYO_SUBSCRIBE_PROFILES: 'Action'
    KLAVIYO_SUPPRESS_PROFILES: 'Action'
    KLAVIYO_UNREGISTER_CLIENT_PUSH_TOKEN: 'Action'
    KLAVIYO_UNSUBSCRIBE_PROFILES: 'Action'
    KLAVIYO_UNSUPPRESS_PROFILES: 'Action'
    KLAVIYO_UPDATE_CAMPAIGN: 'Action'
    KLAVIYO_UPDATE_CAMPAIGN_MESSAGE: 'Action'
    KLAVIYO_UPDATE_CAMPAIGN_SEND_JOB: 'Action'
    KLAVIYO_UPDATE_CATALOG_CATEGORY: 'Action'
    KLAVIYO_UPDATE_CATALOG_CATEGORY_RELATIONSHIPS_ITEMS: 'Action'
    KLAVIYO_UPDATE_CATALOG_ITEM: 'Action'
    KLAVIYO_UPDATE_CATALOG_ITEM_RELATIONSHIPS_CATEGORIES: 'Action'
    KLAVIYO_UPDATE_CATALOG_VARIANT: 'Action'
    KLAVIYO_UPDATE_COUPON: 'Action'
    KLAVIYO_UPDATE_COUPON_CODE: 'Action'
    KLAVIYO_UPDATE_FLOW_STATUS: 'Action'
    KLAVIYO_UPDATE_IMAGE: 'Action'
    KLAVIYO_UPDATE_LIST: 'Action'
    KLAVIYO_UPDATE_PROFILE: 'Action'
    KLAVIYO_UPDATE_SEGMENT: 'Action'
    KLAVIYO_UPDATE_TAG: 'Action'
    KLAVIYO_UPDATE_TAG_GROUP: 'Action'
    KLAVIYO_UPDATE_TEMPLATE: 'Action'
    KLAVIYO_UPDATE_WEBHOOK: 'Action'
    KLAVIYO_UPLOAD_IMAGE_FROM_FILE: 'Action'
    KLAVIYO_UPLOAD_IMAGE_FROM_URL: 'Action'
    LINEAR_CREATE_LINEAR_ISSUE: 'Action'
    LINEAR_LIST_LINEAR_PROJECTS: 'Action'
    LINEAR_LIST_LINEAR_TEAMS: 'Action'
    LINKEDIN_CREATE_LINKED_IN_SHARE: 'Action'
    LINKEDIN_DELETE_LINKED_IN_SHARE: 'Action'
    LINKEDIN_GET_USER_INFO: 'Action'
    LISTENNOTES_BATCH_FETCH_BASIC_META_DATA_FOR_EPISODES: 'Action'
    LISTENNOTES_BATCH_FETCH_BASIC_META_DATA_FOR_PODCASTS: 'Action'
    LISTENNOTES_FETCH_AUDIENCE_DEMOGRAPHICS_FOR_A_PODCAST: 'Action'
    LISTENNOTES_FETCH_A_CURATED_LIST_OF_PODCASTS_BY_ID: 'Action'
    LISTENNOTES_FETCH_A_LIST_OF_BEST_PODCASTS_BY_GENRE: 'Action'
    LISTENNOTES_FETCH_A_LIST_OF_PODCAST_GENRES: 'Action'
    LISTENNOTES_FETCH_A_LIST_OF_SUPPORTED_COUNTRIES_REGIONS_FOR_BEST_PODCASTS: 'Action'
    LISTENNOTES_FETCH_A_LIST_OF_SUPPORTED_LANGUAGES_FOR_PODCASTS: 'Action'
    LISTENNOTES_FETCH_A_LIST_OF_YOUR_PLAYLISTS: 'Action'
    LISTENNOTES_FETCH_A_PLAYLIST_S_INFO_AND_ITEMS_I_E_EPISODES_OR_PODCASTS: 'Action'
    LISTENNOTES_FETCH_A_RANDOM_PODCAST_EPISODE: 'Action'
    LISTENNOTES_FETCH_CURATED_LISTS_OF_PODCASTS: 'Action'
    LISTENNOTES_FETCH_DETAILED_META_DATA_AND_EPISODES_FOR_A_PODCAST_BY_ID: 'Action'
    LISTENNOTES_FETCH_DETAILED_META_DATA_FOR_AN_EPISODE_BY_ID: 'Action'
    LISTENNOTES_FETCH_PODCASTS_BY_A_PUBLISHER_S_DOMAIN_NAME: 'Action'
    LISTENNOTES_FETCH_RECOMMENDATIONS_FOR_AN_EPISODE: 'Action'
    LISTENNOTES_FETCH_RECOMMENDATIONS_FOR_A_PODCAST: 'Action'
    LISTENNOTES_FETCH_RELATED_SEARCH_TERMS: 'Action'
    LISTENNOTES_FETCH_TRENDING_SEARCH_TERMS: 'Action'
    LISTENNOTES_FIND_INDIVIDUAL_EPISODES_BY_SEARCHING_FOR_THEIR_TITLES: 'Action'
    LISTENNOTES_FULL_TEXT_SEARCH: 'Action'
    LISTENNOTES_REFRESH_RSS_FEED_OF_A_PODCAST: 'Action'
    LISTENNOTES_REQUEST_TO_DELETE_A_PODCAST: 'Action'
    LISTENNOTES_SPELL_CHECK_ON_A_SEARCH_TERM: 'Action'
    LISTENNOTES_SUBMIT_A_PODCAST_TO_LISTEN_NOTES_DATABASE: 'Action'
    LISTENNOTES_TYPEAHEAD_SEARCH: 'Action'
    MAILCHIMP_ADD_AUTOMATION: 'Action'
    MAILCHIMP_ADD_BATCH_WEBHOOK: 'Action'
    MAILCHIMP_ADD_CAMPAIGN: 'Action'
    MAILCHIMP_ADD_CAMPAIGN_FEEDBACK: 'Action'
    MAILCHIMP_ADD_CAMPAIGN_FOLDER: 'Action'
    MAILCHIMP_ADD_CART: 'Action'
    MAILCHIMP_ADD_CART_LINE_ITEM: 'Action'
    MAILCHIMP_ADD_CONNECTED_SITE: 'Action'
    MAILCHIMP_ADD_CUSTOMER: 'Action'
    MAILCHIMP_ADD_DOMAIN_TO_ACCOUNT: 'Action'
    MAILCHIMP_ADD_EVENT: 'Action'
    MAILCHIMP_ADD_EXPORT: 'Action'
    MAILCHIMP_ADD_FILE: 'Action'
    MAILCHIMP_ADD_FOLDER: 'Action'
    MAILCHIMP_ADD_INTEREST_CATEGORY: 'Action'
    MAILCHIMP_ADD_INTEREST_IN_CATEGORY: 'Action'
    MAILCHIMP_ADD_LANDING_PAGE: 'Action'
    MAILCHIMP_ADD_LIST: 'Action'
    MAILCHIMP_ADD_MEMBER_NOTE: 'Action'
    MAILCHIMP_ADD_MEMBER_TO_LIST: 'Action'
    MAILCHIMP_ADD_MEMBER_TO_SEGMENT: 'Action'
    MAILCHIMP_ADD_MERGE_FIELD: 'Action'
    MAILCHIMP_ADD_ORDER: 'Action'
    MAILCHIMP_ADD_ORDER_LINE_ITEM: 'Action'
    MAILCHIMP_ADD_OR_REMOVE_MEMBER_TAGS: 'Action'
    MAILCHIMP_ADD_OR_UPDATE_CUSTOMER: 'Action'
    MAILCHIMP_ADD_OR_UPDATE_LIST_MEMBER: 'Action'
    MAILCHIMP_ADD_OR_UPDATE_PRODUCT_VARIANT: 'Action'
    MAILCHIMP_ADD_PRODUCT: 'Action'
    MAILCHIMP_ADD_PRODUCT_IMAGE: 'Action'
    MAILCHIMP_ADD_PRODUCT_VARIANT: 'Action'
    MAILCHIMP_ADD_PROMO_CODE: 'Action'
    MAILCHIMP_ADD_PROMO_RULE: 'Action'
    MAILCHIMP_ADD_SEGMENT: 'Action'
    MAILCHIMP_ADD_STORE: 'Action'
    MAILCHIMP_ADD_SUBSCRIBER_TO_WORKFLOW_EMAIL: 'Action'
    MAILCHIMP_ADD_TEMPLATE: 'Action'
    MAILCHIMP_ADD_TEMPLATE_FOLDER: 'Action'
    MAILCHIMP_ADD_WEBHOOK: 'Action'
    MAILCHIMP_ARCHIVE_AUTOMATION: 'Action'
    MAILCHIMP_ARCHIVE_LIST_MEMBER: 'Action'
    MAILCHIMP_BATCH_ADD_OR_REMOVE_MEMBERS: 'Action'
    MAILCHIMP_BATCH_SUBSCRIBE_OR_UNSUBSCRIBE: 'Action'
    MAILCHIMP_CAMPAIGN_ABUSE_REPORT_DETAILS: 'Action'
    MAILCHIMP_CAMPAIGN_STATISTICS_FEEDBACK: 'Action'
    MAILCHIMP_CANCEL_CAMPAIGN: 'Action'
    MAILCHIMP_CREATE_A_SURVEY_CAMPAIGN: 'Action'
    MAILCHIMP_CUSTOMER_JOURNEYS_API_TRIGGER_FOR_A_CONTACT: 'Action'
    MAILCHIMP_CUSTOMIZE_SIGNUP_FORM: 'Action'
    MAILCHIMP_DELETE_BATCH_REQUEST: 'Action'
    MAILCHIMP_DELETE_BATCH_WEBHOOK: 'Action'
    MAILCHIMP_DELETE_CAMPAIGN: 'Action'
    MAILCHIMP_DELETE_CAMPAIGN_FEEDBACK_MESSAGE: 'Action'
    MAILCHIMP_DELETE_CAMPAIGN_FOLDER: 'Action'
    MAILCHIMP_DELETE_CART: 'Action'
    MAILCHIMP_DELETE_CART_LINE_ITEM: 'Action'
    MAILCHIMP_DELETE_CONNECTED_SITE: 'Action'
    MAILCHIMP_DELETE_CUSTOMER: 'Action'
    MAILCHIMP_DELETE_DOMAIN: 'Action'
    MAILCHIMP_DELETE_FILE: 'Action'
    MAILCHIMP_DELETE_FOLDER: 'Action'
    MAILCHIMP_DELETE_INTEREST_CATEGORY: 'Action'
    MAILCHIMP_DELETE_INTEREST_IN_CATEGORY: 'Action'
    MAILCHIMP_DELETE_LANDING_PAGE: 'Action'
    MAILCHIMP_DELETE_LIST: 'Action'
    MAILCHIMP_DELETE_LIST_MEMBER: 'Action'
    MAILCHIMP_DELETE_MERGE_FIELD: 'Action'
    MAILCHIMP_DELETE_NOTE: 'Action'
    MAILCHIMP_DELETE_ORDER: 'Action'
    MAILCHIMP_DELETE_ORDER_LINE_ITEM: 'Action'
    MAILCHIMP_DELETE_PRODUCT: 'Action'
    MAILCHIMP_DELETE_PRODUCT_IMAGE: 'Action'
    MAILCHIMP_DELETE_PRODUCT_VARIANT: 'Action'
    MAILCHIMP_DELETE_PROMO_CODE: 'Action'
    MAILCHIMP_DELETE_PROMO_RULE: 'Action'
    MAILCHIMP_DELETE_SEGMENT: 'Action'
    MAILCHIMP_DELETE_STORE: 'Action'
    MAILCHIMP_DELETE_TEMPLATE: 'Action'
    MAILCHIMP_DELETE_TEMPLATE_FOLDER: 'Action'
    MAILCHIMP_DELETE_WEBHOOK: 'Action'
    MAILCHIMP_DELETE_WORKFLOW_EMAIL: 'Action'
    MAILCHIMP_GET_ABUSE_REPORT: 'Action'
    MAILCHIMP_GET_ACCOUNT_EXPORT_INFO: 'Action'
    MAILCHIMP_GET_AUTHORIZED_APP_INFO: 'Action'
    MAILCHIMP_GET_AUTOMATED_EMAIL_SUBSCRIBER: 'Action'
    MAILCHIMP_GET_AUTOMATION_INFO: 'Action'
    MAILCHIMP_GET_BATCH_OPERATION_STATUS: 'Action'
    MAILCHIMP_GET_BATCH_WEBHOOK_INFO: 'Action'
    MAILCHIMP_GET_CAMPAIGN_CONTENT: 'Action'
    MAILCHIMP_GET_CAMPAIGN_FEEDBACK_MESSAGE: 'Action'
    MAILCHIMP_GET_CAMPAIGN_FOLDER: 'Action'
    MAILCHIMP_GET_CAMPAIGN_INFO: 'Action'
    MAILCHIMP_GET_CAMPAIGN_LINK_DETAILS: 'Action'
    MAILCHIMP_GET_CAMPAIGN_RECIPIENT_INFO: 'Action'
    MAILCHIMP_GET_CAMPAIGN_REPORT: 'Action'
    MAILCHIMP_GET_CAMPAIGN_SEND_CHECKLIST: 'Action'
    MAILCHIMP_GET_CART_INFO: 'Action'
    MAILCHIMP_GET_CART_LINE_ITEM: 'Action'
    MAILCHIMP_GET_CLICKED_LINK_SUBSCRIBER: 'Action'
    MAILCHIMP_GET_CONNECTED_SITE: 'Action'
    MAILCHIMP_GET_CONVERSATION: 'Action'
    MAILCHIMP_GET_CUSTOMER_INFO: 'Action'
    MAILCHIMP_GET_DOMAIN_INFO: 'Action'
    MAILCHIMP_GET_FACEBOOK_AD_INFO: 'Action'
    MAILCHIMP_GET_FACEBOOK_AD_REPORT: 'Action'
    MAILCHIMP_GET_FILE: 'Action'
    MAILCHIMP_GET_FOLDER: 'Action'
    MAILCHIMP_GET_GROWTH_HISTORY_BY_MONTH: 'Action'
    MAILCHIMP_GET_INFORMATION_ABOUT_ALL_SURVEYS_FOR_A_LIST: 'Action'
    MAILCHIMP_GET_INTEREST_CATEGORY_INFO: 'Action'
    MAILCHIMP_GET_INTEREST_IN_CATEGORY: 'Action'
    MAILCHIMP_GET_LANDING_PAGE_CONTENT: 'Action'
    MAILCHIMP_GET_LANDING_PAGE_INFO: 'Action'
    MAILCHIMP_GET_LANDING_PAGE_REPORT: 'Action'
    MAILCHIMP_GET_LATEST_CHIMP_CHATTER: 'Action'
    MAILCHIMP_GET_LISTS_INFO: 'Action'
    MAILCHIMP_GET_LIST_INFO: 'Action'
    MAILCHIMP_GET_MEMBER_INFO: 'Action'
    MAILCHIMP_GET_MEMBER_NOTE: 'Action'
    MAILCHIMP_GET_MERGE_FIELD: 'Action'
    MAILCHIMP_GET_MESSAGE: 'Action'
    MAILCHIMP_GET_OPENED_CAMPAIGN_SUBSCRIBER: 'Action'
    MAILCHIMP_GET_ORDER_INFO: 'Action'
    MAILCHIMP_GET_ORDER_LINE_ITEM: 'Action'
    MAILCHIMP_GET_PRODUCT_IMAGE_INFO: 'Action'
    MAILCHIMP_GET_PRODUCT_INFO: 'Action'
    MAILCHIMP_GET_PRODUCT_VARIANT_INFO: 'Action'
    MAILCHIMP_GET_PROMO_CODE: 'Action'
    MAILCHIMP_GET_PROMO_RULE: 'Action'
    MAILCHIMP_GET_SEGMENT_INFO: 'Action'
    MAILCHIMP_GET_STORE_INFO: 'Action'
    MAILCHIMP_GET_SUBSCRIBER_EMAIL_ACTIVITY: 'Action'
    MAILCHIMP_GET_SUBSCRIBER_REMOVED_FROM_WORKFLOW: 'Action'
    MAILCHIMP_GET_SURVEY: 'Action'
    MAILCHIMP_GET_SURVEY_QUESTION_REPORT: 'Action'
    MAILCHIMP_GET_SURVEY_REPORT: 'Action'
    MAILCHIMP_GET_SURVEY_RESPONSE: 'Action'
    MAILCHIMP_GET_TEMPLATE_FOLDER: 'Action'
    MAILCHIMP_GET_TEMPLATE_INFO: 'Action'
    MAILCHIMP_GET_UNSUBSCRIBED_MEMBER: 'Action'
    MAILCHIMP_GET_WEBHOOK_INFO: 'Action'
    MAILCHIMP_GET_WORKFLOW_EMAIL_INFO: 'Action'
    MAILCHIMP_LIST_ABUSE_REPORTS: 'Action'
    MAILCHIMP_LIST_ACCOUNT_EXPORTS: 'Action'
    MAILCHIMP_LIST_ACCOUNT_ORDERS: 'Action'
    MAILCHIMP_LIST_ANSWERS_FOR_QUESTION: 'Action'
    MAILCHIMP_LIST_API_ROOT_RESOURCES: 'Action'
    MAILCHIMP_LIST_AUTHORIZED_APPS: 'Action'
    MAILCHIMP_LIST_AUTOMATED_EMAILS: 'Action'
    MAILCHIMP_LIST_AUTOMATED_EMAIL_SUBSCRIBERS: 'Action'
    MAILCHIMP_LIST_AUTOMATIONS: 'Action'
    MAILCHIMP_LIST_BATCH_REQUESTS: 'Action'
    MAILCHIMP_LIST_BATCH_WEBHOOKS: 'Action'
    MAILCHIMP_LIST_CAMPAIGNS: 'Action'
    MAILCHIMP_LIST_CAMPAIGN_DETAILS: 'Action'
    MAILCHIMP_LIST_CAMPAIGN_FEEDBACK: 'Action'
    MAILCHIMP_LIST_CAMPAIGN_FOLDERS: 'Action'
    MAILCHIMP_LIST_CAMPAIGN_OPEN_DETAILS: 'Action'
    MAILCHIMP_LIST_CAMPAIGN_PRODUCT_ACTIVITY: 'Action'
    MAILCHIMP_LIST_CAMPAIGN_RECIPIENTS: 'Action'
    MAILCHIMP_LIST_CAMPAIGN_REPORTS: 'Action'
    MAILCHIMP_LIST_CARTS: 'Action'
    MAILCHIMP_LIST_CART_LINE_ITEMS: 'Action'
    MAILCHIMP_LIST_CHILD_CAMPAIGN_REPORTS: 'Action'
    MAILCHIMP_LIST_CLICKED_LINK_SUBSCRIBERS: 'Action'
    MAILCHIMP_LIST_CONNECTED_SITES: 'Action'
    MAILCHIMP_LIST_CONVERSATIONS: 'Action'
    MAILCHIMP_LIST_CUSTOMERS: 'Action'
    MAILCHIMP_LIST_DOMAIN_PERFORMANCE_STATS: 'Action'
    MAILCHIMP_LIST_EEP_URL_ACTIVITY: 'Action'
    MAILCHIMP_LIST_EMAIL_ACTIVITY: 'Action'
    MAILCHIMP_LIST_FACEBOOK_ADS: 'Action'
    MAILCHIMP_LIST_FACEBOOK_ADS_REPORTS: 'Action'
    MAILCHIMP_LIST_FACEBOOK_ECOMMERCE_REPORT: 'Action'
    MAILCHIMP_LIST_FOLDERS: 'Action'
    MAILCHIMP_LIST_GROWTH_HISTORY_DATA: 'Action'
    MAILCHIMP_LIST_INTERESTS_IN_CATEGORY: 'Action'
    MAILCHIMP_LIST_INTEREST_CATEGORIES: 'Action'
    MAILCHIMP_LIST_LANDING_PAGES: 'Action'
    MAILCHIMP_LIST_LANDING_PAGES_REPORTS: 'Action'
    MAILCHIMP_LIST_LOCATIONS: 'Action'
    MAILCHIMP_LIST_MEMBERS_INFO: 'Action'
    MAILCHIMP_LIST_MEMBERS_IN_SEGMENT: 'Action'
    MAILCHIMP_LIST_MEMBER_EVENTS: 'Action'
    MAILCHIMP_LIST_MEMBER_GOAL_EVENTS: 'Action'
    MAILCHIMP_LIST_MEMBER_TAGS: 'Action'
    MAILCHIMP_LIST_MERGE_FIELDS: 'Action'
    MAILCHIMP_LIST_MESSAGES: 'Action'
    MAILCHIMP_LIST_ORDERS: 'Action'
    MAILCHIMP_LIST_ORDER_LINE_ITEMS: 'Action'
    MAILCHIMP_LIST_PRODUCT: 'Action'
    MAILCHIMP_LIST_PRODUCT_IMAGES: 'Action'
    MAILCHIMP_LIST_PRODUCT_VARIANTS: 'Action'
    MAILCHIMP_LIST_PROMO_CODES: 'Action'
    MAILCHIMP_LIST_PROMO_RULES: 'Action'
    MAILCHIMP_LIST_RECENT_ACTIVITY: 'Action'
    MAILCHIMP_LIST_RECENT_MEMBER_NOTES: 'Action'
    MAILCHIMP_LIST_SEGMENTS: 'Action'
    MAILCHIMP_LIST_SENDING_DOMAINS: 'Action'
    MAILCHIMP_LIST_SIGNUP_FORMS: 'Action'
    MAILCHIMP_LIST_STORED_FILES: 'Action'
    MAILCHIMP_LIST_STORES: 'Action'
    MAILCHIMP_LIST_SUBSCRIBERS_REMOVED_FROM_WORKFLOW: 'Action'
    MAILCHIMP_LIST_SURVEY_QUESTION_REPORTS: 'Action'
    MAILCHIMP_LIST_SURVEY_REPORTS: 'Action'
    MAILCHIMP_LIST_SURVEY_RESPONSES: 'Action'
    MAILCHIMP_LIST_TEMPLATES: 'Action'
    MAILCHIMP_LIST_TEMPLATE_FOLDERS: 'Action'
    MAILCHIMP_LIST_TOP_EMAIL_CLIENTS: 'Action'
    MAILCHIMP_LIST_TOP_OPEN_ACTIVITIES: 'Action'
    MAILCHIMP_LIST_UNSUBSCRIBED_MEMBERS: 'Action'
    MAILCHIMP_LIST_WEBHOOKS: 'Action'
    MAILCHIMP_PAUSE_AUTOMATED_EMAIL: 'Action'
    MAILCHIMP_PAUSE_AUTOMATION_EMAILS: 'Action'
    MAILCHIMP_PAUSE_RSS_CAMPAIGN: 'Action'
    MAILCHIMP_PING: 'Action'
    MAILCHIMP_PUBLISH_A_SURVEY: 'Action'
    MAILCHIMP_PUBLISH_LANDING_PAGE: 'Action'
    MAILCHIMP_REMOVE_LIST_MEMBER_FROM_SEGMENT: 'Action'
    MAILCHIMP_REMOVE_SUBSCRIBER_FROM_WORKFLOW: 'Action'
    MAILCHIMP_REPLICATE_CAMPAIGN: 'Action'
    MAILCHIMP_RESEND_CAMPAIGN: 'Action'
    MAILCHIMP_RESUME_RSS_CAMPAIGN: 'Action'
    MAILCHIMP_RETRIEVE_CAMPAIGN_ABUSE_COMPLAINTS: 'Action'
    MAILCHIMP_RETRIEVE_FOLDER_CONTENTS: 'Action'
    MAILCHIMP_SCHEDULE_CAMPAIGN: 'Action'
    MAILCHIMP_SEARCH_CAMPAIGNS: 'Action'
    MAILCHIMP_SEARCH_FOR_TAGS_ON_A_LIST_BY_NAME: 'Action'
    MAILCHIMP_SEARCH_MEMBERS: 'Action'
    MAILCHIMP_SEND_CAMPAIGN: 'Action'
    MAILCHIMP_SEND_TEST_EMAIL: 'Action'
    MAILCHIMP_SET_CAMPAIGN_CONTENT: 'Action'
    MAILCHIMP_START_AUTOMATED_EMAIL: 'Action'
    MAILCHIMP_START_AUTOMATION_EMAILS: 'Action'
    MAILCHIMP_START_BATCH_OPERATION: 'Action'
    MAILCHIMP_UNPUBLISH_A_SURVEY: 'Action'
    MAILCHIMP_UNPUBLISH_LANDING_PAGE: 'Action'
    MAILCHIMP_UNSCHEDULE_CAMPAIGN: 'Action'
    MAILCHIMP_UPDATE_BATCH_WEBHOOK: 'Action'
    MAILCHIMP_UPDATE_CAMPAIGN_FEEDBACK_MESSAGE: 'Action'
    MAILCHIMP_UPDATE_CAMPAIGN_FOLDER: 'Action'
    MAILCHIMP_UPDATE_CAMPAIGN_SETTINGS: 'Action'
    MAILCHIMP_UPDATE_CART: 'Action'
    MAILCHIMP_UPDATE_CART_LINE_ITEM: 'Action'
    MAILCHIMP_UPDATE_CUSTOMER: 'Action'
    MAILCHIMP_UPDATE_FILE: 'Action'
    MAILCHIMP_UPDATE_FOLDER: 'Action'
    MAILCHIMP_UPDATE_INTEREST_CATEGORY: 'Action'
    MAILCHIMP_UPDATE_INTEREST_IN_CATEGORY: 'Action'
    MAILCHIMP_UPDATE_LANDING_PAGE: 'Action'
    MAILCHIMP_UPDATE_LISTS: 'Action'
    MAILCHIMP_UPDATE_LIST_MEMBER: 'Action'
    MAILCHIMP_UPDATE_MERGE_FIELD: 'Action'
    MAILCHIMP_UPDATE_NOTE: 'Action'
    MAILCHIMP_UPDATE_ORDER: 'Action'
    MAILCHIMP_UPDATE_ORDER_LINE_ITEM: 'Action'
    MAILCHIMP_UPDATE_PRODUCT: 'Action'
    MAILCHIMP_UPDATE_PRODUCT_IMAGE: 'Action'
    MAILCHIMP_UPDATE_PRODUCT_VARIANT: 'Action'
    MAILCHIMP_UPDATE_PROMO_CODE: 'Action'
    MAILCHIMP_UPDATE_PROMO_RULE: 'Action'
    MAILCHIMP_UPDATE_STORE: 'Action'
    MAILCHIMP_UPDATE_TEMPLATE: 'Action'
    MAILCHIMP_UPDATE_TEMPLATE_FOLDER: 'Action'
    MAILCHIMP_UPDATE_WEBHOOK: 'Action'
    MAILCHIMP_UPDATE_WORKFLOW_EMAIL: 'Action'
    MAILCHIMP_VERIFY_CONNECTED_SITE_SCRIPT: 'Action'
    MAILCHIMP_VERIFY_DOMAIN: 'Action'
    MAILCHIMP_VIEW_DEFAULT_CONTENT: 'Action'
    MAILCHIMP_VIEW_RECENT_ACTIVITY: 'Action'
    MAILCHIMP_VIEW_RECENT_ACTIVITY_50: 'Action'
    MATHEMATICAL_CALCULATOR: 'Action'
    MICROSOFT_CLARITY_DATA_EXPORT: 'Action'
    MULTIONAI_CREATE_SESSION: 'Action'
    MULTIONAI_DELETE_SESSION: 'Action'
    MULTIONAI_LIST_SESSIONS: 'Action'
    MULTIONAI_RETRIEVE_DATA: 'Action'
    MULTIONAI_SCREENSHOT: 'Action'
    MULTIONAI_STEP_SESSION: 'Action'
    MULTIONAI_WEB_BROWSE: 'Action'
    NOTION_ADD_PAGE_CONTENT: 'Action'
    NOTION_ARCHIVE_NOTION_PAGE: 'Action'
    NOTION_CREATE_COMMENT: 'Action'
    NOTION_CREATE_DATABASE: 'Action'
    NOTION_CREATE_NOTION_PAGE: 'Action'
    NOTION_DELETE_BLOCK: 'Action'
    NOTION_FETCH_COMMENTS: 'Action'
    NOTION_FETCH_DATABASE: 'Action'
    NOTION_FETCH_NOTION_BLOCK: 'Action'
    NOTION_FETCH_NOTION_CHILD_BLOCK: 'Action'
    NOTION_FETCH_ROW: 'Action'
    NOTION_GET_ABOUT_ME: 'Action'
    NOTION_GET_ABOUT_USER: 'Action'
    NOTION_INSERT_ROW_DATABASE: 'Action'
    NOTION_LIST_USERS: 'Action'
    NOTION_QUERY_DATABASE: 'Action'
    NOTION_SEARCH_NOTION_PAGE: 'Action'
    NOTION_UPDATE_ROW_DATABASE: 'Action'
    NOTION_UPDATE_SCHEMA_DATABASE: 'Action'
    PERPLEXITYAI_PERPLEXITY_AI_SEARCH: 'Action'
    PIPEDRIVE_ADD_AN_ACTIVITY: 'Action'
    PIPEDRIVE_ADD_AN_INSTALLMENT_SUBSCRIPTION: 'Action'
    PIPEDRIVE_ADD_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_ADD_A_CALL_LOG: 'Action'
    PIPEDRIVE_ADD_A_CHANNEL: 'Action'
    PIPEDRIVE_ADD_A_COMMENT_TO_A_NOTE: 'Action'
    PIPEDRIVE_ADD_A_DEAL: 'Action'
    PIPEDRIVE_ADD_A_FOLLOWER_TO_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_ADD_A_FOLLOWER_TO_A_DEAL: 'Action'
    PIPEDRIVE_ADD_A_FOLLOWER_TO_A_PERSON: 'Action'
    PIPEDRIVE_ADD_A_FOLLOWER_TO_A_PRODUCT: 'Action'
    PIPEDRIVE_ADD_A_LEAD: 'Action'
    PIPEDRIVE_ADD_A_LEAD_LABEL: 'Action'
    PIPEDRIVE_ADD_A_NEW_DEAL_FIELD: 'Action'
    PIPEDRIVE_ADD_A_NEW_FILTER: 'Action'
    PIPEDRIVE_ADD_A_NEW_GOAL: 'Action'
    PIPEDRIVE_ADD_A_NEW_ORGANIZATION_FIELD: 'Action'
    PIPEDRIVE_ADD_A_NEW_PERSON_FIELD: 'Action'
    PIPEDRIVE_ADD_A_NEW_PIPELINE: 'Action'
    PIPEDRIVE_ADD_A_NEW_PRODUCT_FIELD: 'Action'
    PIPEDRIVE_ADD_A_NEW_STAGE: 'Action'
    PIPEDRIVE_ADD_A_NEW_TEAM: 'Action'
    PIPEDRIVE_ADD_A_NEW_USER: 'Action'
    PIPEDRIVE_ADD_A_NOTE: 'Action'
    PIPEDRIVE_ADD_A_PARTICIPANT_TO_A_DEAL: 'Action'
    PIPEDRIVE_ADD_A_PERSON: 'Action'
    PIPEDRIVE_ADD_A_PRODUCT: 'Action'
    PIPEDRIVE_ADD_A_PRODUCT_TO_A_DEAL: 'Action'
    PIPEDRIVE_ADD_A_PROJECT: 'Action'
    PIPEDRIVE_ADD_A_RECURRING_SUBSCRIPTION: 'Action'
    PIPEDRIVE_ADD_A_ROLE: 'Action'
    PIPEDRIVE_ADD_A_TASK: 'Action'
    PIPEDRIVE_ADD_FILE: 'Action'
    PIPEDRIVE_ADD_NEW_ACTIVITY_TYPE: 'Action'
    PIPEDRIVE_ADD_OR_UPDATE_ROLE_SETTING: 'Action'
    PIPEDRIVE_ADD_PERSON_PICTURE: 'Action'
    PIPEDRIVE_ADD_ROLE_ASSIGNMENT: 'Action'
    PIPEDRIVE_ADD_USERS_TO_A_TEAM: 'Action'
    PIPEDRIVE_ARCHIVE_A_PROJECT: 'Action'
    PIPEDRIVE_ATTACH_AN_AUDIO_FILE_TO_THE_CALL_LOG: 'Action'
    PIPEDRIVE_CANCEL_A_RECURRING_SUBSCRIPTION: 'Action'
    PIPEDRIVE_CREATE_AN_ORGANIZATION_RELATIONSHIP: 'Action'
    PIPEDRIVE_CREATE_A_NEW_WEBHOOK: 'Action'
    PIPEDRIVE_CREATE_A_REMOTE_FILE_AND_LINK_IT_TO_AN_ITEM: 'Action'
    PIPEDRIVE_DELETE_AN_ACTIVITY: 'Action'
    PIPEDRIVE_DELETE_AN_ACTIVITY_TYPE: 'Action'
    PIPEDRIVE_DELETE_AN_ATTACHED_PRODUCT_FROM_A_DEAL: 'Action'
    PIPEDRIVE_DELETE_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_DELETE_AN_ORGANIZATION_FIELD: 'Action'
    PIPEDRIVE_DELETE_AN_ORGANIZATION_RELATIONSHIP: 'Action'
    PIPEDRIVE_DELETE_A_CALL_LOG: 'Action'
    PIPEDRIVE_DELETE_A_CHANNEL: 'Action'
    PIPEDRIVE_DELETE_A_COMMENT_RELATED_TO_A_NOTE: 'Action'
    PIPEDRIVE_DELETE_A_CONVERSATION: 'Action'
    PIPEDRIVE_DELETE_A_DEAL: 'Action'
    PIPEDRIVE_DELETE_A_DEAL_FIELD: 'Action'
    PIPEDRIVE_DELETE_A_FILE: 'Action'
    PIPEDRIVE_DELETE_A_FILTER: 'Action'
    PIPEDRIVE_DELETE_A_FOLLOWER_FROM_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_DELETE_A_FOLLOWER_FROM_A_DEAL: 'Action'
    PIPEDRIVE_DELETE_A_FOLLOWER_FROM_A_PERSON: 'Action'
    PIPEDRIVE_DELETE_A_FOLLOWER_FROM_A_PRODUCT: 'Action'
    PIPEDRIVE_DELETE_A_LEAD: 'Action'
    PIPEDRIVE_DELETE_A_LEAD_LABEL: 'Action'
    PIPEDRIVE_DELETE_A_NOTE: 'Action'
    PIPEDRIVE_DELETE_A_PARTICIPANT_FROM_A_DEAL: 'Action'
    PIPEDRIVE_DELETE_A_PERSON: 'Action'
    PIPEDRIVE_DELETE_A_PERSON_FIELD: 'Action'
    PIPEDRIVE_DELETE_A_PIPELINE: 'Action'
    PIPEDRIVE_DELETE_A_PRODUCT: 'Action'
    PIPEDRIVE_DELETE_A_PRODUCT_FIELD: 'Action'
    PIPEDRIVE_DELETE_A_PROJECT: 'Action'
    PIPEDRIVE_DELETE_A_ROLE: 'Action'
    PIPEDRIVE_DELETE_A_ROLE_ASSIGNMENT: 'Action'
    PIPEDRIVE_DELETE_A_STAGE: 'Action'
    PIPEDRIVE_DELETE_A_SUBSCRIPTION: 'Action'
    PIPEDRIVE_DELETE_A_TASK: 'Action'
    PIPEDRIVE_DELETE_EXISTING_GOAL: 'Action'
    PIPEDRIVE_DELETE_EXISTING_WEBHOOK: 'Action'
    PIPEDRIVE_DELETE_MAIL_THREAD: 'Action'
    PIPEDRIVE_DELETE_MULTIPLE_ACTIVITIES_IN_BULK: 'Action'
    PIPEDRIVE_DELETE_MULTIPLE_ACTIVITY_TYPES_IN_BULK: 'Action'
    PIPEDRIVE_DELETE_MULTIPLE_DEALS_IN_BULK: 'Action'
    PIPEDRIVE_DELETE_MULTIPLE_DEAL_FIELDS_IN_BULK: 'Action'
    PIPEDRIVE_DELETE_MULTIPLE_FILTERS_IN_BULK: 'Action'
    PIPEDRIVE_DELETE_MULTIPLE_ORGANIZATIONS_IN_BULK: 'Action'
    PIPEDRIVE_DELETE_MULTIPLE_ORGANIZATION_FIELDS_IN_BULK: 'Action'
    PIPEDRIVE_DELETE_MULTIPLE_PERSONS_IN_BULK: 'Action'
    PIPEDRIVE_DELETE_MULTIPLE_PERSON_FIELDS_IN_BULK: 'Action'
    PIPEDRIVE_DELETE_MULTIPLE_PRODUCT_FIELDS_IN_BULK: 'Action'
    PIPEDRIVE_DELETE_MULTIPLE_STAGES_IN_BULK: 'Action'
    PIPEDRIVE_DELETE_PERSON_PICTURE: 'Action'
    PIPEDRIVE_DELETE_USERS_FROM_A_TEAM: 'Action'
    PIPEDRIVE_DOWNLOAD_ONE_FILE: 'Action'
    PIPEDRIVE_DUPLICATE_DEAL: 'Action'
    PIPEDRIVE_ENUMERATE_ACCESSIBLE_USERS_FOR_LEAD: 'Action'
    PIPEDRIVE_FIND_GOALS: 'Action'
    PIPEDRIVE_FIND_SUBSCRIPTION_BY_DEAL: 'Action'
    PIPEDRIVE_FIND_USERS_BY_NAME: 'Action'
    PIPEDRIVE_GET_ALL_ACTIVITIES_ASSIGNED_TO_A_PARTICULAR_USER: 'Action'
    PIPEDRIVE_GET_ALL_ACTIVITY_FIELDS: 'Action'
    PIPEDRIVE_GET_ALL_ACTIVITY_TYPES: 'Action'
    PIPEDRIVE_GET_ALL_ADD_ONS_FOR_A_SINGLE_COMPANY: 'Action'
    PIPEDRIVE_GET_ALL_CALL_LOGS_ASSIGNED_TO_A_PARTICULAR_USER: 'Action'
    PIPEDRIVE_GET_ALL_COMMENTS_FOR_A_NOTE: 'Action'
    PIPEDRIVE_GET_ALL_DEALS: 'Action'
    PIPEDRIVE_GET_ALL_DEAL_FIELDS: 'Action'
    PIPEDRIVE_GET_ALL_FILES: 'Action'
    PIPEDRIVE_GET_ALL_FILTERS: 'Action'
    PIPEDRIVE_GET_ALL_FILTER_HELPERS: 'Action'
    PIPEDRIVE_GET_ALL_LEADS: 'Action'
    PIPEDRIVE_GET_ALL_LEAD_LABELS: 'Action'
    PIPEDRIVE_GET_ALL_LEAD_SOURCES: 'Action'
    PIPEDRIVE_GET_ALL_MAIL_MESSAGES_OF_MAIL_THREAD: 'Action'
    PIPEDRIVE_GET_ALL_NOTES: 'Action'
    PIPEDRIVE_GET_ALL_NOTE_FIELDS: 'Action'
    PIPEDRIVE_GET_ALL_ORGANIZATIONS: 'Action'
    PIPEDRIVE_GET_ALL_ORGANIZATION_FIELDS: 'Action'
    PIPEDRIVE_GET_ALL_PAYMENTS_OF_A_SUBSCRIPTION: 'Action'
    PIPEDRIVE_GET_ALL_PERMISSION_SETS: 'Action'
    PIPEDRIVE_GET_ALL_PERSONS: 'Action'
    PIPEDRIVE_GET_ALL_PERSON_FIELDS: 'Action'
    PIPEDRIVE_GET_ALL_PIPELINES: 'Action'
    PIPEDRIVE_GET_ALL_PRODUCTS: 'Action'
    PIPEDRIVE_GET_ALL_PRODUCT_FIELDS: 'Action'
    PIPEDRIVE_GET_ALL_PROJECTS: 'Action'
    PIPEDRIVE_GET_ALL_PROJECT_BOARDS: 'Action'
    PIPEDRIVE_GET_ALL_PROJECT_TEMPLATES: 'Action'
    PIPEDRIVE_GET_ALL_RELATIONSHIPS_FOR_ORGANIZATION: 'Action'
    PIPEDRIVE_GET_ALL_ROLES: 'Action'
    PIPEDRIVE_GET_ALL_STAGES: 'Action'
    PIPEDRIVE_GET_ALL_SUPPORTED_CURRENCIES: 'Action'
    PIPEDRIVE_GET_ALL_TASKS: 'Action'
    PIPEDRIVE_GET_ALL_TEAMS: 'Action'
    PIPEDRIVE_GET_ALL_TEAMS_OF_A_USER: 'Action'
    PIPEDRIVE_GET_ALL_USERS: 'Action'
    PIPEDRIVE_GET_ALL_USERS_IN_A_TEAM: 'Action'
    PIPEDRIVE_GET_ALL_USER_CONNECTIONS: 'Action'
    PIPEDRIVE_GET_ALL_WEBHOOKS: 'Action'
    PIPEDRIVE_GET_A_SINGLE_TEAM: 'Action'
    PIPEDRIVE_GET_CURRENT_USER_DATA: 'Action'
    PIPEDRIVE_GET_DEALS_CONVERSION_RATES_IN_PIPELINE: 'Action'
    PIPEDRIVE_GET_DEALS_IN_A_PIPELINE: 'Action'
    PIPEDRIVE_GET_DEALS_IN_A_STAGE: 'Action'
    PIPEDRIVE_GET_DEALS_MOVEMENTS_IN_PIPELINE: 'Action'
    PIPEDRIVE_GET_DEALS_SUMMARY: 'Action'
    PIPEDRIVE_GET_DEALS_TIMELINE: 'Action'
    PIPEDRIVE_GET_DEALS_WHERE_A_PRODUCT_IS_ATTACHED_TO: 'Action'
    PIPEDRIVE_GET_DETAILS_OF_AN_ACTIVITY: 'Action'
    PIPEDRIVE_GET_DETAILS_OF_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_GET_DETAILS_OF_A_BOARD: 'Action'
    PIPEDRIVE_GET_DETAILS_OF_A_CALL_LOG: 'Action'
    PIPEDRIVE_GET_DETAILS_OF_A_DEAL: 'Action'
    PIPEDRIVE_GET_DETAILS_OF_A_PERSON: 'Action'
    PIPEDRIVE_GET_DETAILS_OF_A_PHASE: 'Action'
    PIPEDRIVE_GET_DETAILS_OF_A_PROJECT: 'Action'
    PIPEDRIVE_GET_DETAILS_OF_A_SUBSCRIPTION: 'Action'
    PIPEDRIVE_GET_DETAILS_OF_A_TASK: 'Action'
    PIPEDRIVE_GET_DETAILS_OF_A_TEMPLATE: 'Action'
    PIPEDRIVE_GET_MAIL_THREADS: 'Action'
    PIPEDRIVE_GET_ONE_COMMENT: 'Action'
    PIPEDRIVE_GET_ONE_DEAL_FIELD: 'Action'
    PIPEDRIVE_GET_ONE_FILE: 'Action'
    PIPEDRIVE_GET_ONE_FILTER: 'Action'
    PIPEDRIVE_GET_ONE_LEAD: 'Action'
    PIPEDRIVE_GET_ONE_MAIL_MESSAGE: 'Action'
    PIPEDRIVE_GET_ONE_MAIL_THREAD: 'Action'
    PIPEDRIVE_GET_ONE_NOTE: 'Action'
    PIPEDRIVE_GET_ONE_ORGANIZATION_FIELD: 'Action'
    PIPEDRIVE_GET_ONE_ORGANIZATION_RELATIONSHIP: 'Action'
    PIPEDRIVE_GET_ONE_PERMISSION_SET: 'Action'
    PIPEDRIVE_GET_ONE_PERSON_FIELD: 'Action'
    PIPEDRIVE_GET_ONE_PIPELINE: 'Action'
    PIPEDRIVE_GET_ONE_PRODUCT: 'Action'
    PIPEDRIVE_GET_ONE_PRODUCT_FIELD: 'Action'
    PIPEDRIVE_GET_ONE_ROLE: 'Action'
    PIPEDRIVE_GET_ONE_STAGE: 'Action'
    PIPEDRIVE_GET_ONE_USER: 'Action'
    PIPEDRIVE_GET_PROJECT_PHASES: 'Action'
    PIPEDRIVE_GET_RECENTS: 'Action'
    PIPEDRIVE_GET_RESULT_OF_A_GOAL: 'Action'
    PIPEDRIVE_LINK_A_REMOTE_FILE_TO_AN_ITEM: 'Action'
    PIPEDRIVE_LINK_A_USER_WITH_THE_INSTALLED_VIDEO_CALL_INTEGRATION: 'Action'
    PIPEDRIVE_LIST_ACTIVITIES_ASSOCIATED_WITH_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_LIST_ACTIVITIES_ASSOCIATED_WITH_A_DEAL: 'Action'
    PIPEDRIVE_LIST_ACTIVITIES_ASSOCIATED_WITH_A_PERSON: 'Action'
    PIPEDRIVE_LIST_ALL_PERSONS_ASSOCIATED_WITH_A_DEAL: 'Action'
    PIPEDRIVE_LIST_DEALS_ASSOCIATED_WITH_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_LIST_DEALS_ASSOCIATED_WITH_A_PERSON: 'Action'
    PIPEDRIVE_LIST_FILES_ATTACHED_TO_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_LIST_FILES_ATTACHED_TO_A_DEAL: 'Action'
    PIPEDRIVE_LIST_FILES_ATTACHED_TO_A_PERSON: 'Action'
    PIPEDRIVE_LIST_FILES_ATTACHED_TO_A_PRODUCT: 'Action'
    PIPEDRIVE_LIST_FOLLOWERS_OF_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_LIST_FOLLOWERS_OF_A_DEAL: 'Action'
    PIPEDRIVE_LIST_FOLLOWERS_OF_A_PERSON: 'Action'
    PIPEDRIVE_LIST_FOLLOWERS_OF_A_PRODUCT: 'Action'
    PIPEDRIVE_LIST_FOLLOWERS_OF_A_USER: 'Action'
    PIPEDRIVE_LIST_MAIL_MESSAGES_ASSOCIATED_WITH_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_LIST_MAIL_MESSAGES_ASSOCIATED_WITH_A_DEAL: 'Action'
    PIPEDRIVE_LIST_MAIL_MESSAGES_ASSOCIATED_WITH_A_PERSON: 'Action'
    PIPEDRIVE_LIST_PARTICIPANTS_OF_A_DEAL: 'Action'
    PIPEDRIVE_LIST_PERMISSION_SET_ASSIGNMENTS: 'Action'
    PIPEDRIVE_LIST_PERMITTED_USERS: 'Action'
    PIPEDRIVE_LIST_PERMITTED_USERS_LISTS_USERS_PERMITTED_TO_ACCESS_A_PRODUCT: 'Action'
    PIPEDRIVE_LIST_PERMITTED_USERS_LIST_USERS_PERMITTED_TO_ACCESS_A_PERSON: 'Action'
    PIPEDRIVE_LIST_PERSONS_OF_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_LIST_PIPELINE_VISIBILITY_FOR_A_ROLE: 'Action'
    PIPEDRIVE_LIST_PRODUCTS_ASSOCIATED_WITH_A_PERSON: 'Action'
    PIPEDRIVE_LIST_PRODUCTS_ATTACHED_TO_A_DEAL: 'Action'
    PIPEDRIVE_LIST_ROLE_ASSIGNMENTS: 'Action'
    PIPEDRIVE_LIST_ROLE_ASSIGNMENTS_LISTS_ROLE_ASSIGNMENTS_FOR_A_USER: 'Action'
    PIPEDRIVE_LIST_ROLE_SETTINGS: 'Action'
    PIPEDRIVE_LIST_SETTINGS_OF_AN_AUTHORIZED_USER: 'Action'
    PIPEDRIVE_LIST_UPDATES_ABOUT_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_LIST_UPDATES_ABOUT_A_DEAL: 'Action'
    PIPEDRIVE_LIST_UPDATES_ABOUT_A_PERSON: 'Action'
    PIPEDRIVE_LIST_UPDATES_ABOUT_PARTICIPANTS_OF_A_DEAL: 'Action'
    PIPEDRIVE_LIST_USER_PERMISSIONS: 'Action'
    PIPEDRIVE_LIST_USER_ROLE_SETTINGS: 'Action'
    PIPEDRIVE_MERGE_TWO_DEALS: 'Action'
    PIPEDRIVE_MERGE_TWO_ORGANIZATIONS: 'Action'
    PIPEDRIVE_MERGE_TWO_PERSONS: 'Action'
    PIPEDRIVE_ORGANIZATION_ACCESSIBLE_USER_LIST: 'Action'
    PIPEDRIVE_PERFORM_A_SEARCH_FROM_MULTIPLE_ITEM_TYPES: 'Action'
    PIPEDRIVE_PERFORM_A_SEARCH_USING_A_SPECIFIC_FIELD_FROM_AN_ITEM_TYPE: 'Action'
    PIPEDRIVE_RECEIVES_AN_INCOMING_MESSAGE: 'Action'
    PIPEDRIVE_REFRESHING_THE_TOKENS: 'Action'
    PIPEDRIVE_REQUESTING_AUTHORIZATION: 'Action'
    PIPEDRIVE_RETURNS_PROJECT_ACTIVITIES: 'Action'
    PIPEDRIVE_RETURNS_PROJECT_GROUPS: 'Action'
    PIPEDRIVE_RETURNS_PROJECT_PLAN: 'Action'
    PIPEDRIVE_RETURNS_PROJECT_TASKS: 'Action'
    PIPEDRIVE_SEARCH_DEALS: 'Action'
    PIPEDRIVE_SEARCH_LEADS: 'Action'
    PIPEDRIVE_SEARCH_ORGANIZATIONS: 'Action'
    PIPEDRIVE_SEARCH_PERSONS: 'Action'
    PIPEDRIVE_SEARCH_PRODUCTS: 'Action'
    PIPEDRIVE_UNLINK_USER_FROM_VIDEO_CALL_INTEGRATION: 'Action'
    PIPEDRIVE_UPDATE_ACTIVITY_IN_PROJECT_PLAN: 'Action'
    PIPEDRIVE_UPDATE_AN_ACTIVITY: 'Action'
    PIPEDRIVE_UPDATE_AN_ACTIVITY_TYPE: 'Action'
    PIPEDRIVE_UPDATE_AN_INSTALLMENT_SUBSCRIPTION: 'Action'
    PIPEDRIVE_UPDATE_AN_ORGANIZATION: 'Action'
    PIPEDRIVE_UPDATE_AN_ORGANIZATION_FIELD: 'Action'
    PIPEDRIVE_UPDATE_AN_ORGANIZATION_RELATIONSHIP: 'Action'
    PIPEDRIVE_UPDATE_A_COMMENT_RELATED_TO_A_NOTE: 'Action'
    PIPEDRIVE_UPDATE_A_DEAL: 'Action'
    PIPEDRIVE_UPDATE_A_DEAL_FIELD: 'Action'
    PIPEDRIVE_UPDATE_A_LEAD: 'Action'
    PIPEDRIVE_UPDATE_A_LEAD_LABEL: 'Action'
    PIPEDRIVE_UPDATE_A_NOTE: 'Action'
    PIPEDRIVE_UPDATE_A_PERSON: 'Action'
    PIPEDRIVE_UPDATE_A_PERSON_FIELD: 'Action'
    PIPEDRIVE_UPDATE_A_PIPELINE: 'Action'
    PIPEDRIVE_UPDATE_A_PRODUCT: 'Action'
    PIPEDRIVE_UPDATE_A_PRODUCT_FIELD: 'Action'
    PIPEDRIVE_UPDATE_A_PROJECT: 'Action'
    PIPEDRIVE_UPDATE_A_RECURRING_SUBSCRIPTION: 'Action'
    PIPEDRIVE_UPDATE_A_TASK: 'Action'
    PIPEDRIVE_UPDATE_A_TEAM: 'Action'
    PIPEDRIVE_UPDATE_EXISTING_GOAL: 'Action'
    PIPEDRIVE_UPDATE_FILE_DETAILS: 'Action'
    PIPEDRIVE_UPDATE_FILTER: 'Action'
    PIPEDRIVE_UPDATE_MAIL_THREAD_DETAILS: 'Action'
    PIPEDRIVE_UPDATE_PIPELINE_VISIBILITY_FOR_A_ROLE: 'Action'
    PIPEDRIVE_UPDATE_ROLE_DETAILS: 'Action'
    PIPEDRIVE_UPDATE_STAGE_DETAILS: 'Action'
    PIPEDRIVE_UPDATE_TASK_IN_PROJECT_PLAN: 'Action'
    PIPEDRIVE_UPDATE_THE_PRODUCT_ATTACHED_TO_A_DEAL: 'Action'
    PIPEDRIVE_UPDATE_USER_DETAILS: 'Action'
    POSTHOG_ADD_DASHBOARD_COLLABORATORS_WITH_ACCESS_LEVEL: 'Action'
    POSTHOG_ADD_MEMBER_TO_ORGANIZATION_ROLE: 'Action'
    POSTHOG_ADD_PROJECT_SPECIFIC_MEMBER_ROLES: 'Action'
    POSTHOG_ASSIGN_FEATURE_FLAG_ROLE_BASED_ACCESS: 'Action'
    POSTHOG_BOOKMARK_PROJECT_ACTIVITY_NOTIFICATION: 'Action'
    POSTHOG_BULK_CREATE_ORGANIZATION_INVITES: 'Action'
    POSTHOG_CANCEL_INSIGHTS_FOR_A_PROJECT: 'Action'
    POSTHOG_CHECK_PIPELINE_DESTINATION_UPDATES: 'Action'
    POSTHOG_CHECK_PIPELINE_IMPORT_APP_UPDATES: 'Action'
    POSTHOG_CHECK_PIPELINE_PLUGIN_UPDATE_STATUS: 'Action'
    POSTHOG_CHECK_PROJECT_S_DEMO_DATA_GENERATION_STATUS: 'Action'
    POSTHOG_COHORT_DUPLICATION_TO_STATIC: 'Action'
    POSTHOG_CREATE_A_NOTEBOOK_IN_A_PROJECT: 'Action'
    POSTHOG_CREATE_DASHBOARD_FROM_TEMPLATE_IN_PROJECT: 'Action'
    POSTHOG_CREATE_DOMAIN_WITH_SAML_FOR_ORGANIZATION: 'Action'
    POSTHOG_CREATE_EXPERIMENT_EXPOSURE_COHORT: 'Action'
    POSTHOG_CREATE_FEATURE_FLAGS_FOR_PROJECT: 'Action'
    POSTHOG_CREATE_FEATURE_FLAG_DASHBOARD: 'Action'
    POSTHOG_CREATE_FRONTEND_APP_PIPELINE_CONFIG: 'Action'
    POSTHOG_CREATE_FUNNEL_ANALYSIS_FOR_PROJECT_PERSONS: 'Action'
    POSTHOG_CREATE_NEW_ORGANIZATION_WITH_CONFIGURABLE_ACCESS: 'Action'
    POSTHOG_CREATE_NEW_PROJECT_EXPERIMENT: 'Action'
    POSTHOG_CREATE_ORGANIZATION_INVITE_WITH_ROLE_AND_EMAIL: 'Action'
    POSTHOG_CREATE_ORGANIZATION_ROLE_WITH_FEATURE_FLAG_LEVELS: 'Action'
    POSTHOG_CREATE_ORG_PROXY_RECORD_WITH_DOMAIN_AND_STATUS: 'Action'
    POSTHOG_CREATE_PERSON_FUNNEL_CORRELATION: 'Action'
    POSTHOG_CREATE_PERSON_PATH_WITH_FORMAT_OPTION: 'Action'
    POSTHOG_CREATE_PIPELINE_DESTINATION_CONFIG: 'Action'
    POSTHOG_CREATE_PIPELINE_DESTINATION_CONFIG_JOB: 'Action'
    POSTHOG_CREATE_PIPELINE_IMPORT_APPS_CONFIG_JOB: 'Action'
    POSTHOG_CREATE_PLUGIN_JOB_CONFIGURATION: 'Action'
    POSTHOG_CREATE_PROJECT_ACTIONS_WITH_OPTIONAL_CSV_JSON_FORMAT: 'Action'
    POSTHOG_CREATE_PROJECT_COHORTS: 'Action'
    POSTHOG_CREATE_PROJECT_DASHBOARD: 'Action'
    POSTHOG_CREATE_PROJECT_INSIGHTS_WITH_CUSTOMIZABLE_PARAMETERS: 'Action'
    POSTHOG_CREATE_PROJECT_INSIGHTS_WITH_FORMAT_OPTION: 'Action'
    POSTHOG_CREATE_PROJECT_PIPELINE_APP_CONFIGS: 'Action'
    POSTHOG_CREATE_PROJECT_PIPELINE_FRONTEND_APP_JOB: 'Action'
    POSTHOG_CREATE_PROJECT_PIPELINE_TRANSFORMATION_CONFIG: 'Action'
    POSTHOG_CREATE_PROJECT_PLUGIN_CONFIGURATION: 'Action'
    POSTHOG_CREATE_PROJECT_SUBSCRIPTION_WITH_DELIVERY_OPTIONS: 'Action'
    POSTHOG_CREATE_PROJECT_SURVEYS_WITH_QUESTIONS_AND_TARGETS: 'Action'
    POSTHOG_CREATE_PROJECT_TIMING_INSIGHTS: 'Action'
    POSTHOG_CREATE_QUERY_IN_PROJECT_BY_ID: 'Action'
    POSTHOG_CREATE_RETRIEVE_RETENTION_INSIGHTS_FOR_PROJECT: 'Action'
    POSTHOG_CREATE_SESSION_RECORDING_IN_PLAYLIST: 'Action'
    POSTHOG_CREATE_SESSION_RECORDING_PLAYLISTS: 'Action'
    POSTHOG_CREATE_SESSION_RECORDING_SUMMARY: 'Action'
    POSTHOG_CREATE_STATIC_COHORT_FOR_FEATURE_FLAG: 'Action'
    POSTHOG_CRUD_OPERATIONS_FOR_PROJECT_ANNOTATIONS: 'Action'
    POSTHOG_CUSTOM_PROJECT_FUNNEL_ANALYTICS_WITH_ADVANCED_OPTIONS: 'Action'
    POSTHOG_DELETE_ORGANIZATION_BY_UUID: 'Action'
    POSTHOG_DELETE_ORGANIZATION_PROJECT: 'Action'
    POSTHOG_DELETE_PERSON_AND_OPTIONALLY_ASSOCIATED_EVENTS: 'Action'
    POSTHOG_DELETE_SESSION_RECORDING_BY_UUID: 'Action'
    POSTHOG_DELETE_SURVEY_BY_ID: 'Action'
    POSTHOG_ENABLE_PROJECT_EARLY_ACCESS_FEATURE: 'Action'
    POSTHOG_FETCH_BATCH_EXPORT_DETAILS_VIA_UUID: 'Action'
    POSTHOG_FETCH_EXPORT_UNSUBSCRIBE_SETTINGS: 'Action'
    POSTHOG_FETCH_FRONTEND_APP_CONFIG_STATUS: 'Action'
    POSTHOG_FETCH_ORGANIZATION_DETAILS_BY_UUID: 'Action'
    POSTHOG_FETCH_ORGANIZATION_PIPELINE_APP_REPOSITORIES: 'Action'
    POSTHOG_FETCH_PIPELINE_DESTINATION_DETAILS: 'Action'
    POSTHOG_FETCH_PIPELINE_TRANSFORMATION_DETAILS: 'Action'
    POSTHOG_FETCH_PROJECT_EXPERIMENT_SECONDARY_DATA: 'Action'
    POSTHOG_FETCH_PROJECT_SURVEY_ACTIVITY_LOG: 'Action'
    POSTHOG_FETCH_SESSION_RECORDING_PLAYLIST_DETAILS: 'Action'
    POSTHOG_FLAG_ANNOTATION_AS_DELETED: 'Action'
    POSTHOG_GENERATE_PROJECT_FUNNEL_CORRELATION_INSIGHT: 'Action'
    POSTHOG_INITIATE_DOMAIN_VERIFICATION_WITH_SAML_CONFIG: 'Action'
    POSTHOG_INITIATE_PIPELINE_TRANSFORMATION_JOB: 'Action'
    POSTHOG_LIST_AND_FILTER_PROJECT_EVENTS: 'Action'
    POSTHOG_LIST_AND_MANAGE_PROJECT_ANNOTATIONS: 'Action'
    POSTHOG_LIST_AND_MANAGE_PROJECT_FEATURE_FLAGS: 'Action'
    POSTHOG_LIST_BATCH_EXPORT_RUNS_WITH_PAGINATION_AND_ORDERING: 'Action'
    POSTHOG_LIST_DASHBOARD_SHARING_CONFIGS: 'Action'
    POSTHOG_LIST_FEATURE_FLAG_ROLE_ACCESS_DETAILS: 'Action'
    POSTHOG_LIST_NOTEBOOKS_WITH_FILTERS_AND_PAGINATION: 'Action'
    POSTHOG_LIST_OF_PROJECT_S_SESSION_RECORDING_PLAYLISTS: 'Action'
    POSTHOG_LIST_ORGANIZATION_DOMAINS_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_ORGANIZATION_INVITES_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_ORGANIZATION_MEMBERS_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_ORGANIZATION_PLUGINS_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_ORGANIZATION_ROLES_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_ORGANIZATION_S_BATCH_EXPORTS_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_ORGANIZATION_S_PAGINATED_PROXY_RECORDS: 'Action'
    POSTHOG_LIST_ORGANIZATION_S_PIPELINE_DESTINATIONS: 'Action'
    POSTHOG_LIST_ORGANIZATION_S_PIPELINE_FRONTEND_APPS: 'Action'
    POSTHOG_LIST_ORGANIZATION_S_PIPELINE_IMPORT_APPS: 'Action'
    POSTHOG_LIST_ORGANIZATION_S_PIPELINE_TRANSFORMATIONS: 'Action'
    POSTHOG_LIST_OR_DELETE_PERSONS_WITH_OPTIONAL_FILTERS: 'Action'
    POSTHOG_LIST_PAGINATED_SURVEYS_FOR_A_PROJECT: 'Action'
    POSTHOG_LIST_PIPELINE_DESTINATION_CONFIGS_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_PIPELINE_FRONTEND_APP_CONFIGS: 'Action'
    POSTHOG_LIST_PROJECTS_IN_ORGANIZATION_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_PROJECT_ACTIONS_WITH_PAGINATION_AND_FILTERS: 'Action'
    POSTHOG_LIST_PROJECT_BATCH_EXPORTS_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_PROJECT_CONFIGURATION_PLUGIN_LOGS: 'Action'
    POSTHOG_LIST_PROJECT_DASHBOARDS_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_PROJECT_DASHBOARD_COLLABORATORS: 'Action'
    POSTHOG_LIST_PROJECT_DASHBOARD_TEMPLATES: 'Action'
    POSTHOG_LIST_PROJECT_EARLY_ACCESS_FEATURES: 'Action'
    POSTHOG_LIST_PROJECT_EXPERIMENTS_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_PROJECT_EXPORT_ITEMS_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_PROJECT_GROUP_TYPES_BY_ID: 'Action'
    POSTHOG_LIST_PROJECT_MEMBERSHIP_DETAILS: 'Action'
    POSTHOG_LIST_PROJECT_PIPELINE_CONFIGURATIONS: 'Action'
    POSTHOG_LIST_PROJECT_PIPELINE_IMPORT_CONFIGS: 'Action'
    POSTHOG_LIST_PROJECT_PLUGIN_CONFIGURATIONS: 'Action'
    POSTHOG_LIST_PROJECT_SESSION_RECORDINGS: 'Action'
    POSTHOG_LIST_PROJECT_SUBSCRIPTIONS_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_ROLE_MEMBERSHIPS_PAGINATED: 'Action'
    POSTHOG_LIST_SESSION_RECORDING_SHARING_CONFIGS: 'Action'
    POSTHOG_LIST_SPECIFIC_TYPE_GROUPS_WITH_PAGINATION: 'Action'
    POSTHOG_LIST_UNUSED_ORGANIZATION_PIPELINE_TRANSFORMATIONS: 'Action'
    POSTHOG_LIST_USERS_WITH_STAFF_FILTER_AND_PAGINATION: 'Action'
    POSTHOG_MANAGE_FEATURE_FLAG_ENRICHMENT_FOR_USAGE_DASHBOARD: 'Action'
    POSTHOG_MANAGE_PROJECT_FEATURE_FLAGS: 'Action'
    POSTHOG_MANAGE_PROJECT_FEATURE_FLAGS_FOR_LOCAL_EVALUATION: 'Action'
    POSTHOG_MANAGE_USER_FEATURE_FLAGS: 'Action'
    POSTHOG_MARK_DASHBOARD_TEMPLATE_AS_DELETED: 'Action'
    POSTHOG_MARK_INSIGHT_AS_VIEWED_WITH_CONFIGURABLE_FORMAT: 'Action'
    POSTHOG_MARK_PROJECT_ACTION_AS_DELETED: 'Action'
    POSTHOG_MARK_SESSION_RECORDING_PLAYLIST_DELETED: 'Action'
    POSTHOG_MARK_SUBSCRIPTION_AS_DELETED_BY_ID: 'Action'
    POSTHOG_MODIFY_ORG_INFO_VIA_UUID: 'Action'
    POSTHOG_MOVE_DASHBOARD_TILE: 'Action'
    POSTHOG_PARTIALLY_UPDATE_PROJECT_PLUGIN_CONFIG: 'Action'
    POSTHOG_PARTIALLY_UPDATE_PROJECT_PROPERTY_DEFINITION: 'Action'
    POSTHOG_PARTIAL_EXPERIMENT_UPDATE_IN_PROJECT: 'Action'
    POSTHOG_PARTIAL_PIPELINE_FRONTEND_APP_CONFIG_UPDATE: 'Action'
    POSTHOG_PARTIAL_UPDATE_OF_A_PROJECT_INSIGHT: 'Action'
    POSTHOG_PARTIAL_UPDATE_OF_A_PROJECT_S_DASHBOARD: 'Action'
    POSTHOG_PARTIAL_UPDATE_OF_A_PROJECT_S_FEATURE_FLAG: 'Action'
    POSTHOG_PARTIAL_UPDATE_OF_PROJECT_NOTEBOOK: 'Action'
    POSTHOG_PARTIAL_UPDATE_PROJECT_ANNOTATION: 'Action'
    POSTHOG_PERSIST_SESSION_RECORDING_DATA_BY_UUID: 'Action'
    POSTHOG_PERSON_PARTIAL_UPDATE_VIA_PROJECT_ID: 'Action'
    POSTHOG_PERSON_PROPERTY_DELETION_ENDPOINT: 'Action'
    POSTHOG_POST_PROJECT_TRENDS_IN_VARIOUS_FORMATS_WITH_OPTIONAL_FILTERS: 'Action'
    POSTHOG_PREVENT_HARD_DELETE_NOTEBOOK_BY_FLAGGING: 'Action'
    POSTHOG_REARRANGE_FRONTEND_APP_PIPELINE_CONFIGS: 'Action'
    POSTHOG_REARRANGE_PIPELINE_TRANSFORMATION_CONFIGS: 'Action'
    POSTHOG_REARRANGE_PROJECT_IMPORT_APP_CONFIGURATIONS: 'Action'
    POSTHOG_REARRANGE_PROJECT_PIPELINE_DESTINATION_CONFIGS: 'Action'
    POSTHOG_RECONFIGURE_PLUGIN_ORDER_AND_STATUS_IN_PROJECT: 'Action'
    POSTHOG_REMOVE_DOMAIN_BY_UUID_FROM_ORGANIZATION: 'Action'
    POSTHOG_REMOVE_EARLY_ACCESS_FEATURE_FROM_PROJECT: 'Action'
    POSTHOG_REMOVE_EXPLICIT_PROJECT_MEMBER_BY_UUID: 'Action'
    POSTHOG_REMOVE_FEATURE_FLAG_ROLE_ACCESS_BY_ID: 'Action'
    POSTHOG_REMOVE_MEMBER_FROM_ORGANIZATION_BY_UUID: 'Action'
    POSTHOG_REMOVE_ORGANIZATION_BATCH_EXPORT_BY_UUID: 'Action'
    POSTHOG_REMOVE_ORGANIZATION_PIPELINE_DESTINATION: 'Action'
    POSTHOG_REMOVE_ORGANIZATION_PIPELINE_TRANSFORMATION: 'Action'
    POSTHOG_REMOVE_ORGANIZATION_PLUGIN_BY_ID: 'Action'
    POSTHOG_REMOVE_ORGANIZATION_PROXY_RECORD: 'Action'
    POSTHOG_REMOVE_ORGANIZATION_ROLE_BY_ID: 'Action'
    POSTHOG_REMOVE_ORG_PIPELINE_IMPORT_APP_BY_ID: 'Action'
    POSTHOG_REMOVE_PIPELINE_DESTINATION_CONFIG: 'Action'
    POSTHOG_REMOVE_PIPELINE_FRONTEND_APP_BY_ID: 'Action'
    POSTHOG_REMOVE_PIPELINE_FRONTEND_APP_CONFIG: 'Action'
    POSTHOG_REMOVE_PIPELINE_IMPORT_APP_CONFIG: 'Action'
    POSTHOG_REMOVE_PIPELINE_TRANSFORMATION_CONFIG_BY_ID: 'Action'
    POSTHOG_REMOVE_PROJECT_DASHBOARD_COLLABORATOR: 'Action'
    POSTHOG_REMOVE_PROJECT_EVENT_DEFINITION: 'Action'
    POSTHOG_REMOVE_PROJECT_EXPERIMENT_BY_ID: 'Action'
    POSTHOG_REMOVE_PROJECT_PLUGIN_CONFIGURATION: 'Action'
    POSTHOG_REMOVE_PROPERTY_DEFINITION_BY_UUID: 'Action'
    POSTHOG_REMOVE_ROLE_MEMBERSHIP_BY_UUID: 'Action'
    POSTHOG_REMOVE_SESSION_RECORDING_FROM_PLAYLIST: 'Action'
    POSTHOG_REMOVE_SPECIFIC_PROJECT_BATCH_EXPORT: 'Action'
    POSTHOG_REMOVE_SPECIFIC_PROJECT_QUERY: 'Action'
    POSTHOG_RETRIEVE_AND_DELETE_PROJECT_PERSON_TRENDS: 'Action'
    POSTHOG_RETRIEVE_APP_METRICS_BY_IDS: 'Action'
    POSTHOG_RETRIEVE_APP_METRICS_ERROR_DETAILS: 'Action'
    POSTHOG_RETRIEVE_ASYNC_QUERY_STATUS_BY_ID: 'Action'
    POSTHOG_RETRIEVE_BATCH_EXPORT_DETAILS: 'Action'
    POSTHOG_RETRIEVE_BATCH_EXPORT_LOGS_BY_UUID: 'Action'
    POSTHOG_RETRIEVE_BATCH_EXPORT_RUN_LOGS: 'Action'
    POSTHOG_RETRIEVE_COHORT_ACTIVITY_DETAILS: 'Action'
    POSTHOG_RETRIEVE_COHORT_PERSON_DETAILS: 'Action'
    POSTHOG_RETRIEVE_DASHBOARD_TEMPLATE_DETAILS_BY_UUID: 'Action'
    POSTHOG_RETRIEVE_DASHBOARD_TEMPLATE_SCHEMA: 'Action'
    POSTHOG_RETRIEVE_EVENT_DEFINITIONS_BY_PROJECT_ID: 'Action'
    POSTHOG_RETRIEVE_EVENT_DEFINITION_BY_UUID: 'Action'
    POSTHOG_RETRIEVE_EXPERIMENTS_REQUIRING_FLAG_IMPLEMENTATION: 'Action'
    POSTHOG_RETRIEVE_EXPERIMENT_DETAILS_BY_IDS: 'Action'
    POSTHOG_RETRIEVE_EXPORT_UNSUBSCRIBE_CONFIGS: 'Action'
    POSTHOG_RETRIEVE_FEATURE_FLAGS_ACTIVITY_LOG: 'Action'
    POSTHOG_RETRIEVE_FEATURE_FLAGS_EVALUATION_REASONS: 'Action'
    POSTHOG_RETRIEVE_FEATURE_FLAG_ACTIVITY_DETAILS: 'Action'
    POSTHOG_RETRIEVE_FEATURE_FLAG_DETAILS: 'Action'
    POSTHOG_RETRIEVE_FEATURE_FLAG_ROLE_ACCESS_DETAILS: 'Action'
    POSTHOG_RETRIEVE_FILTERED_PROJECT_PROPERTY_DEFINITIONS: 'Action'
    POSTHOG_RETRIEVE_FUNNEL_INSIGHTS_IN_PROJECT: 'Action'
    POSTHOG_RETRIEVE_GROUP_PROPERTY_DEFINITIONS_BY_PROJECT_ID: 'Action'
    POSTHOG_RETRIEVE_GROUP_PROPERTY_VALUES_BY_INDEX_AND_KEY: 'Action'
    POSTHOG_RETRIEVE_HEDGEHOG_CONFIGURATION_BY_UUID: 'Action'
    POSTHOG_RETRIEVE_HISTORICAL_APP_METRICS_EXPORT: 'Action'
    POSTHOG_RETRIEVE_IMPORTANT_PROJECT_ACTIVITY_LOG: 'Action'
    POSTHOG_RETRIEVE_INSIGHT_SHARING_CONFIGURATIONS: 'Action'
    POSTHOG_RETRIEVE_LAST_VIEWED_INSIGHTS_FOR_USER: 'Action'
    POSTHOG_RETRIEVE_MATCHING_EVENTS_FOR_SESSION_RECORDING: 'Action'
    POSTHOG_RETRIEVE_NOTEBOOK_ACTIVITY_FOR_PROJECT: 'Action'
    POSTHOG_RETRIEVE_NOTEBOOK_ACTIVITY_LOG: 'Action'
    POSTHOG_RETRIEVE_NOTEBOOK_DETAILS: 'Action'
    POSTHOG_RETRIEVE_ORGANIZATION_PIPELINE_FRONTEND_APP_DETAILS: 'Action'
    POSTHOG_RETRIEVE_ORGANIZATION_PIPELINE_UNSUBSCRIBE_CONFIGS: 'Action'
    POSTHOG_RETRIEVE_ORGANIZATION_PLUGIN_ACTIVITY: 'Action'
    POSTHOG_RETRIEVE_ORGANIZATION_PLUGIN_DETAILS: 'Action'
    POSTHOG_RETRIEVE_ORGANIZATION_PLUGIN_REPOSITORY_DETAILS: 'Action'
    POSTHOG_RETRIEVE_ORGANIZATION_PLUGIN_UNSUBSCRIBE_CONFIGS: 'Action'
    POSTHOG_RETRIEVE_ORGANIZATION_PROJECT_DETAILS: 'Action'
    POSTHOG_RETRIEVE_ORGANIZATION_ROLE_DETAILS: 'Action'
    POSTHOG_RETRIEVE_ORGANIZATION_S_PIPELINE_REPOSITORY_DETAILS: 'Action'
    POSTHOG_RETRIEVE_ORGANIZATION_S_UNUSED_PIPELINE_APPS: 'Action'
    POSTHOG_RETRIEVE_ORG_PIPELINE_TRANSFORMATION_ACTIVITY: 'Action'
    POSTHOG_RETRIEVE_OR_DELETE_PERSON_RETENTION_DATA: 'Action'
    POSTHOG_RETRIEVE_OR_DELETE_PROJECT_PERSONS_FUNNEL_DATA: 'Action'
    POSTHOG_RETRIEVE_PAGINATED_ORGANIZATION_LIST: 'Action'
    POSTHOG_RETRIEVE_PERSONS_FUNNEL_CORRELATION_DATA: 'Action'
    POSTHOG_RETRIEVE_PERSON_DETAILS_BY_ID: 'Action'
    POSTHOG_RETRIEVE_PERSON_DETAILS_BY_PROJECT: 'Action'
    POSTHOG_RETRIEVE_PERSON_LIFECYCLE_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PERSON_PROPERTIES_TIMELINE: 'Action'
    POSTHOG_RETRIEVE_PERSON_S_ACTIVITY_AND_DELETE_OPTIONS: 'Action'
    POSTHOG_RETRIEVE_PERSON_VALUES_BY_PROJECT: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_DESTINATION_ACTIVITY: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_DESTINATION_CONFIG_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_DESTINATION_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_DESTINATION_FRONTEND_CONFIG: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_DESTINATION_PLUGIN_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_FRONTEND_APP_ACTIVITY: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_FRONTEND_APP_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_FRONTEND_APP_SOURCE_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_FRONTEND_PLUGIN_CONFIG: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_IMPORT_APPS_ACTIVITY: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_IMPORT_APP_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_IMPORT_APP_SOURCE_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_PLUGIN_DETAILS_BY_ID: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_TRANSFORMATION_ACTIVITY: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_TRANSFORMATION_CONFIG: 'Action'
    POSTHOG_RETRIEVE_PIPELINE_TRANSFORMATION_FRONTEND_CONFIG: 'Action'
    POSTHOG_RETRIEVE_PLUGIN_CONFIG_ACTIVITY: 'Action'
    POSTHOG_RETRIEVE_PLUGIN_CONFIG_ACTIVITY_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PLUGIN_CONFIG_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PLUGIN_CONFIG_FRONTEND: 'Action'
    POSTHOG_RETRIEVE_PLUGIN_FRONTEND_CONFIG: 'Action'
    POSTHOG_RETRIEVE_PLUGIN_SOURCE_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PLUGIN_SOURCE_DETAILS_FOR_PIPELINE_TRANSFORMATION: 'Action'
    POSTHOG_RETRIEVE_PLUGIN_UPDATE_INFO: 'Action'
    POSTHOG_RETRIEVE_PLUGIN_UPDATE_STATUS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_ACTION_DETAILS_BY_ID: 'Action'
    POSTHOG_RETRIEVE_PROJECT_ACTIVITY_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_ACTIVITY_INSIGHTS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_ACTIVITY_LOG_WITH_PAGINATION: 'Action'
    POSTHOG_RETRIEVE_PROJECT_ANNOTATION_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_COHORTS_ACTIVITY_LOG: 'Action'
    POSTHOG_RETRIEVE_PROJECT_COHORTS_WITH_PAGINATION: 'Action'
    POSTHOG_RETRIEVE_PROJECT_COHORT_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_DRAFT_SQL_QUERY: 'Action'
    POSTHOG_RETRIEVE_PROJECT_EARLY_ACCESS_FEATURE_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_EVENT_DETAILS_BY_ID: 'Action'
    POSTHOG_RETRIEVE_PROJECT_EVENT_VALUES: 'Action'
    POSTHOG_RETRIEVE_PROJECT_EXPERIMENT_RESULTS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_EXPORT_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_FUNNEL_CORRELATION_INSIGHTS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_GROUP_DETAILS_BY_KEY_AND_TYPE: 'Action'
    POSTHOG_RETRIEVE_PROJECT_INSIGHTS_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_INSIGHTS_WITH_PAGINATION: 'Action'
    POSTHOG_RETRIEVE_PROJECT_INSIGHT_ACTIVITY_DATA: 'Action'
    POSTHOG_RETRIEVE_PROJECT_INSIGHT_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_MEMBER_DETAILS_BY_UUID: 'Action'
    POSTHOG_RETRIEVE_PROJECT_PERSON_ACTIVITY: 'Action'
    POSTHOG_RETRIEVE_PROJECT_PERSON_COHORTS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_PERSON_STICKINESS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_PIPELINE_PLUGIN_CONFIG: 'Action'
    POSTHOG_RETRIEVE_PROJECT_SESSION_VALUES: 'Action'
    POSTHOG_RETRIEVE_PROJECT_SUBSCRIPTION_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PROJECT_TREND_INSIGHTS: 'Action'
    POSTHOG_RETRIEVE_PROPERTIES_AND_EVENTS_ASSOCIATION: 'Action'
    POSTHOG_RETRIEVE_PROPERTY_DEFINITION_DETAILS: 'Action'
    POSTHOG_RETRIEVE_PROXY_RECORD_DETAILS: 'Action'
    POSTHOG_RETRIEVE_RELATED_PROJECT_GROUPS: 'Action'
    POSTHOG_RETRIEVE_RETENTION_INSIGHTS: 'Action'
    POSTHOG_RETRIEVE_SESSION_PROPERTY_DEFINITIONS: 'Action'
    POSTHOG_RETRIEVE_SESSION_RECORDING_DETAILS: 'Action'
    POSTHOG_RETRIEVE_SESSION_RECORDING_ERROR_CLUSTERS: 'Action'
    POSTHOG_RETRIEVE_SESSION_RECORDING_PLAYLIST_DETAILS: 'Action'
    POSTHOG_RETRIEVE_SESSION_RECORDING_PROPERTIES_BY_PROJECT_ID: 'Action'
    POSTHOG_RETRIEVE_SESSION_RECORDING_SNAPSHOTS: 'Action'
    POSTHOG_RETRIEVE_SIMILAR_SESSION_RECORDINGS: 'Action'
    POSTHOG_RETRIEVE_SPECIFIC_BATCH_EXPORT_DETAILS: 'Action'
    POSTHOG_RETRIEVE_SPECIFIC_BATCH_EXPORT_RUN_DETAILS: 'Action'
    POSTHOG_RETRIEVE_SPECIFIC_DOMAIN_DETAILS: 'Action'
    POSTHOG_RETRIEVE_SPECIFIC_EXPORTED_ASSET_CONTENT: 'Action'
    POSTHOG_RETRIEVE_SPECIFIC_HISTORICAL_PLUGIN_EXPORT: 'Action'
    POSTHOG_RETRIEVE_SPECIFIC_PIPELINE_FRONTEND_APP_CONFIG: 'Action'
    POSTHOG_RETRIEVE_SPECIFIC_PROJECT_DASHBOARD_DETAILS: 'Action'
    POSTHOG_RETRIEVE_SURVEY_ACTIVITY_LOGS: 'Action'
    POSTHOG_RETRIEVE_SURVEY_DETAILS_WITH_UUID_AND_PROJECT_ID: 'Action'
    POSTHOG_RETRIEVE_SURVEY_RESPONSES_COUNT_BY_PROJECT_ID: 'Action'
    POSTHOG_RETRIEVE_UNSUBSCRIBED_PIPELINE_CONFIGS: 'Action'
    POSTHOG_RETRIEVE_UNUSED_ORGANIZATION_PIPELINE_FRONTEND_APPS: 'Action'
    POSTHOG_RETRIEVE_UNUSED_ORGANIZATION_PLUGINS: 'Action'
    POSTHOG_RETRIEVE_UNUSED_PIPELINE_DESTINATIONS: 'Action'
    POSTHOG_RETRIEVE_USER_DETAILS_FOR_INITIATING_2_FA_SETUP: 'Action'
    POSTHOG_RETRIEVE_USER_PROFILE_AND_TEAM_DETAILS: 'Action'
    POSTHOG_REVOKE_ORGANIZATION_INVITE: 'Action'
    POSTHOG_SET_INSIGHT_DELETION_FLAG: 'Action'
    POSTHOG_SOFT_DELETE_A_SPECIFIC_COHORT_BY_ID: 'Action'
    POSTHOG_SOFT_DELETE_FEATURE_FLAG_BY_SETTING_STATUS: 'Action'
    POSTHOG_SOFT_DELETE_PROJECT_DASHBOARD: 'Action'
    POSTHOG_SPLIT_PERSON_ENTITIES_IN_PROJECT: 'Action'
    POSTHOG_TRIGGER_PROJECT_EXPORT_WITH_FORMAT_OPTION: 'Action'
    POSTHOG_UPDATE_ANNOTATION_DETAILS: 'Action'
    POSTHOG_UPDATE_EARLY_ACCESS_PROJECT_FEATURE: 'Action'
    POSTHOG_UPDATE_EVENT_DEFINITION_BY_UUID: 'Action'
    POSTHOG_UPDATE_EXPERIMENT_DETAILS: 'Action'
    POSTHOG_UPDATE_FEATURE_FLAG_CONFIGURATION: 'Action'
    POSTHOG_UPDATE_ORGANIZATION_DETAILS_BY_UUID: 'Action'
    POSTHOG_UPDATE_ORGANIZATION_DOMAIN_INFO_AND_SAML_CONFIG: 'Action'
    POSTHOG_UPDATE_ORGANIZATION_DOMAIN_PROPERTIES: 'Action'
    POSTHOG_UPDATE_ORGANIZATION_MEMBER_BY_UUIDS: 'Action'
    POSTHOG_UPDATE_ORGANIZATION_MEMBER_DETAILS: 'Action'
    POSTHOG_UPDATE_ORGANIZATION_S_PROXY_RECORD_DOMAIN: 'Action'
    POSTHOG_UPDATE_PARTIAL_PROJECT_COHORT_DETAILS: 'Action'
    POSTHOG_UPDATE_PARTIAL_ROLE_DETAILS_IN_ORGANIZATION: 'Action'
    POSTHOG_UPDATE_PARTIAL_SUBSCRIPTION_DETAILS: 'Action'
    POSTHOG_UPDATE_PARTIAL_SURVEY_DETAILS: 'Action'
    POSTHOG_UPDATE_PERSON_PROPERTIES: 'Action'
    POSTHOG_UPDATE_PERSON_PROPERTY_ENDPOINT: 'Action'
    POSTHOG_UPDATE_PIPELINE_DESTINATION_CONFIG: 'Action'
    POSTHOG_UPDATE_PIPELINE_FRONTEND_APP_CONFIG: 'Action'
    POSTHOG_UPDATE_PIPELINE_PLUGIN_CONFIG: 'Action'
    POSTHOG_UPDATE_PIPELINE_TRANSFORMATION_CONFIG: 'Action'
    POSTHOG_UPDATE_PLUGIN_CONFIG_FOR_PROJECT: 'Action'
    POSTHOG_UPDATE_PROJECT_ACTION_BY_ID: 'Action'
    POSTHOG_UPDATE_PROJECT_ACTION_WITH_PARTIAL_DATA: 'Action'
    POSTHOG_UPDATE_PROJECT_COHORT_DETAILS: 'Action'
    POSTHOG_UPDATE_PROJECT_DASHBOARD_DETAILS: 'Action'
    POSTHOG_UPDATE_PROJECT_EARLY_ACCESS_FEATURE: 'Action'
    POSTHOG_UPDATE_PROJECT_EVENT_DEFINITION: 'Action'
    POSTHOG_UPDATE_PROJECT_GROUP_TYPE_METADATA: 'Action'
    POSTHOG_UPDATE_PROJECT_INSIGHT_DETAILS: 'Action'
    POSTHOG_UPDATE_PROJECT_MEMBER_ROLE_BY_UUID: 'Action'
    POSTHOG_UPDATE_PROJECT_MEMBER_S_ROLE_BY_UUID: 'Action'
    POSTHOG_UPDATE_PROJECT_NOTEBOOK_DETAILS: 'Action'
    POSTHOG_UPDATE_PROJECT_PIPELINE_DESTINATION_CONFIG: 'Action'
    POSTHOG_UPDATE_PROJECT_PIPELINE_TRANSFORMATION_CONFIG: 'Action'
    POSTHOG_UPDATE_PROJECT_PLUGIN_CONFIGURATION: 'Action'
    POSTHOG_UPDATE_PROJECT_PROPERTY_DEFINITION: 'Action'
    POSTHOG_UPDATE_PROJECT_SESSION_RECORDING_PLAYLIST: 'Action'
    POSTHOG_UPDATE_PROJECT_SUBSCRIPTION_DETAILS: 'Action'
    POSTHOG_UPDATE_PROJECT_SURVEY_DETAILS: 'Action'
    POSTHOG_UPDATE_ROLE_DETAILS_IN_ORGANIZATION: 'Action'
    POSTHOG_UPDATE_SESSION_RECORDING_PLAYLIST_PARTIALLY: 'Action'
    POSTHOG_UPDATE_SPECIFIC_PROXY_RECORD_FIELDS: 'Action'
    RAGTOOL_ADD_CONTENT_TO_RAG_TOOL: 'Action'
    RAGTOOL_RAG_TOOL_QUERY: 'Action'
    SALESFORCE_ACCOUNT_CREATION_WITH_CONTENT_TYPE_OPTION: 'Action'
    SALESFORCE_CREATE_CAMPAIGN_RECORD_VIA_POST: 'Action'
    SALESFORCE_CREATE_LEAD_WITH_SPECIFIED_CONTENT_TYPE: 'Action'
    SALESFORCE_CREATE_NEW_CONTACT_WITH_JSON_HEADER: 'Action'
    SALESFORCE_CREATE_NOTE_RECORD_WITH_CONTENT_TYPE_HEADER: 'Action'
    SALESFORCE_CREATE_OPPORTUNITY_RECORD: 'Action'
    SALESFORCE_DELETE_A_LEAD_OBJECT_BY_ITS_ID: 'Action'
    SALESFORCE_FETCH_ACCOUNT_DETAILS_BY_ID_WITH_CONDITIONAL_QUERIES: 'Action'
    SALESFORCE_FETCH_MODIFIED_OR_UNMODIFIED_SOBJECTS: 'Action'
    SALESFORCE_REMOVE_ACCOUNT_BY_UNIQUE_IDENTIFIER: 'Action'
    SALESFORCE_REMOVE_A_SPECIFIC_CONTACT_BY_ID: 'Action'
    SALESFORCE_REMOVE_CAMPAIGN_OBJECT_BY_ID: 'Action'
    SALESFORCE_REMOVE_NOTE_OBJECT_BY_ID: 'Action'
    SALESFORCE_REMOVE_OPPORTUNITY_BY_ID: 'Action'
    SALESFORCE_RETRIEVE_ACCOUNT_DATA_AND_ERROR_RESPONSES: 'Action'
    SALESFORCE_RETRIEVE_CAMPAIGN_DATA_WITH_ERROR_HANDLING: 'Action'
    SALESFORCE_RETRIEVE_CONTACT_INFO_WITH_STANDARD_RESPONSES: 'Action'
    SALESFORCE_RETRIEVE_LEAD_DATA_WITH_VARIOUS_RESPONSES: 'Action'
    SALESFORCE_RETRIEVE_LEAD_DETAILS_BY_ID_WITH_CONDITIONAL_SUPPORT: 'Action'
    SALESFORCE_RETRIEVE_NOTE_BY_ID_WITH_OPTIONAL_FIELDS_AND_TIME_CONDITIONS: 'Action'
    SALESFORCE_RETRIEVE_NOTE_OBJECT_INFORMATION: 'Action'
    SALESFORCE_RETRIEVE_OPPORTUNITIES_DATA: 'Action'
    SALESFORCE_RETRIEVE_OPPORTUNITY_BY_ID_WITH_OPTIONAL_FIELDS: 'Action'
    SALESFORCE_RETRIEVE_SPECIFIC_CAMPAIGN_OBJECT_DETAILS: 'Action'
    SALESFORCE_RETRIEVE_SPECIFIC_CONTACT_BY_ID: 'Action'
    SALESFORCE_UPDATE_ACCOUNT_OBJECT_BY_ID: 'Action'
    SALESFORCE_UPDATE_CAMPAIGN_BY_ID_WITH_JSON: 'Action'
    SALESFORCE_UPDATE_CONTACT_BY_ID: 'Action'
    SALESFORCE_UPDATE_LEAD_BY_ID_WITH_JSON_PAYLOAD: 'Action'
    SALESFORCE_UPDATE_OPPORTUNITY_BY_ID: 'Action'
    SALESFORCE_UPDATE_SPECIFIC_NOTE_BY_ID: 'Action'
    SENDGRID_ACTIVATE_A_TRANSACTIONAL_TEMPLATE_VERSION: 'Action'
    SENDGRID_ADD_AN_IP_ADDRESS_TO_A_POOL: 'Action'
    SENDGRID_ADD_AN_IP_TO_AN_AUTHENTICATED_DOMAIN: 'Action'
    SENDGRID_ADD_A_BATCH_OF_IPS_TO_AN_IP_POOL: 'Action'
    SENDGRID_ADD_A_SINGLE_RECIPIENT_TO_A_LIST: 'Action'
    SENDGRID_ADD_A_TWILIO_SEND_GRID_IP_ADDRESS: 'Action'
    SENDGRID_ADD_IPS: 'Action'
    SENDGRID_ADD_ONE_OR_MORE_IPS_TO_THE_ALLOW_LIST: 'Action'
    SENDGRID_ADD_OR_UPDATE_A_CONTACT: 'Action'
    SENDGRID_ADD_RECIPIENT_ADDRESSES_TO_THE_GLOBAL_SUPPRESSION_GROUP: 'Action'
    SENDGRID_ADD_SUPPRESSIONS_TO_A_SUPPRESSION_GROUP: 'Action'
    SENDGRID_APPROVE_ACCESS_REQUEST: 'Action'
    SENDGRID_ASSIGN_A_BATCH_OF_SUBUSERS_TO_AN_IP: 'Action'
    SENDGRID_ASSOCIATE_AN_AUTHENTICATED_DOMAIN_WITH_A_GIVEN_USER: 'Action'
    SENDGRID_ASSOCIATE_A_BRANDED_LINK_WITH_A_SUBUSER: 'Action'
    SENDGRID_AUTHENTICATE_AN_ACCOUNT_WITH_SINGLE_SIGN_ON: 'Action'
    SENDGRID_AUTHENTICATE_A_DOMAIN: 'Action'
    SENDGRID_BIND_AUTHENTICATED_DOMAINS_TO_USER: 'Action'
    SENDGRID_BULK_DELETE_SINGLE_SENDS: 'Action'
    SENDGRID_CANCEL_OR_PAUSE_A_SCHEDULED_SEND: 'Action'
    SENDGRID_COMPLETED_STEPS: 'Action'
    SENDGRID_CREATE_AN_ACCOUNT: 'Action'
    SENDGRID_CREATE_AN_IP_POOL: 'Action'
    SENDGRID_CREATE_AN_IP_POOL_WITH_A_NAME_AND_IP_ASSIGNMENTS: 'Action'
    SENDGRID_CREATE_AN_SSO_CERTIFICATE: 'Action'
    SENDGRID_CREATE_AN_SSO_INTEGRATION: 'Action'
    SENDGRID_CREATE_AN_SSO_TEAMMATE: 'Action'
    SENDGRID_CREATE_API_KEYS: 'Action'
    SENDGRID_CREATE_A_BATCH_ID: 'Action'
    SENDGRID_CREATE_A_BRANDED_LINK: 'Action'
    SENDGRID_CREATE_A_CAMPAIGN: 'Action'
    SENDGRID_CREATE_A_CUSTOM_FIELD: 'Action'
    SENDGRID_CREATE_A_LIST: 'Action'
    SENDGRID_CREATE_A_NEW_ALERT: 'Action'
    SENDGRID_CREATE_A_NEW_EVENT_WEBHOOK: 'Action'
    SENDGRID_CREATE_A_NEW_SUPPRESSION_GROUP: 'Action'
    SENDGRID_CREATE_A_NEW_TRANSACTIONAL_TEMPLATE_VERSION: 'Action'
    SENDGRID_CREATE_A_PARSE_SETTING: 'Action'
    SENDGRID_CREATE_A_SEGMENT: 'Action'
    SENDGRID_CREATE_A_SENDER: 'Action'
    SENDGRID_CREATE_A_SENDER_IDENTITY: 'Action'
    SENDGRID_CREATE_A_TRANSACTIONAL_TEMPLATE: 'Action'
    SENDGRID_CREATE_CUSTOM_FIELD_DEFINITION: 'Action'
    SENDGRID_CREATE_DESIGN: 'Action'
    SENDGRID_CREATE_INTEGRATION: 'Action'
    SENDGRID_CREATE_LIST: 'Action'
    SENDGRID_CREATE_SEGMENT: 'Action'
    SENDGRID_CREATE_SINGLE_SEND: 'Action'
    SENDGRID_CREATE_SUBUSER: 'Action'
    SENDGRID_CREATE_VERIFIED_SENDER_REQUEST: 'Action'
    SENDGRID_DELETE_AN_ACCOUNT: 'Action'
    SENDGRID_DELETE_AN_ALERT: 'Action'
    SENDGRID_DELETE_AN_AUTHENTICATED_DOMAIN: 'Action'
    SENDGRID_DELETE_AN_IP_POOL: 'Action'
    SENDGRID_DELETE_AN_SSO_CERTIFICATE: 'Action'
    SENDGRID_DELETE_AN_SSO_INTEGRATION: 'Action'
    SENDGRID_DELETE_API_KEYS: 'Action'
    SENDGRID_DELETE_A_BATCH_OF_IPS_FROM_AN_IP_POOL: 'Action'
    SENDGRID_DELETE_A_BATCH_OF_SUBUSERS_FROM_AN_IP: 'Action'
    SENDGRID_DELETE_A_BOUNCE: 'Action'
    SENDGRID_DELETE_A_BRANDED_LINK: 'Action'
    SENDGRID_DELETE_A_CAMPAIGN: 'Action'
    SENDGRID_DELETE_A_CANCELLATION_OR_PAUSE_FROM_A_SCHEDULED_SEND: 'Action'
    SENDGRID_DELETE_A_CONTACT_IDENTIFIER: 'Action'
    SENDGRID_DELETE_A_CUSTOM_FIELD: 'Action'
    SENDGRID_DELETE_A_GLOBAL_SUPPRESSION: 'Action'
    SENDGRID_DELETE_A_LIST: 'Action'
    SENDGRID_DELETE_A_PARSE_SETTING: 'Action'
    SENDGRID_DELETE_A_RECIPIENT: 'Action'
    SENDGRID_DELETE_A_REVERSE_DNS_RECORD: 'Action'
    SENDGRID_DELETE_A_SEGMENT: 'Action'
    SENDGRID_DELETE_A_SENDER: 'Action'
    SENDGRID_DELETE_A_SENDER_IDENTITY: 'Action'
    SENDGRID_DELETE_A_SINGLE_EVENT_WEBHOOK_BY_ID: 'Action'
    SENDGRID_DELETE_A_SINGLE_RECIPIENT_FROM_A_SINGLE_LIST: 'Action'
    SENDGRID_DELETE_A_SPECIFIC_BLOCK: 'Action'
    SENDGRID_DELETE_A_SPECIFIC_INVALID_EMAIL: 'Action'
    SENDGRID_DELETE_A_SPECIFIC_SPAM_REPORT: 'Action'
    SENDGRID_DELETE_A_SUBUSER: 'Action'
    SENDGRID_DELETE_A_SUPPRESSION_FROM_A_SUPPRESSION_GROUP: 'Action'
    SENDGRID_DELETE_A_SUPPRESSION_GROUP: 'Action'
    SENDGRID_DELETE_A_TEMPLATE: 'Action'
    SENDGRID_DELETE_A_TRANSACTIONAL_TEMPLATE_VERSION: 'Action'
    SENDGRID_DELETE_BLOCKS: 'Action'
    SENDGRID_DELETE_BOUNCES: 'Action'
    SENDGRID_DELETE_BULK_INTEGRATION: 'Action'
    SENDGRID_DELETE_CONTACTS: 'Action'
    SENDGRID_DELETE_CUSTOM_FIELD_DEFINITION: 'Action'
    SENDGRID_DELETE_DESIGN: 'Action'
    SENDGRID_DELETE_INVALID_EMAILS: 'Action'
    SENDGRID_DELETE_IP_POOL: 'Action'
    SENDGRID_DELETE_PENDING_TEAMMATE: 'Action'
    SENDGRID_DELETE_SEGMENT: 'Action'
    SENDGRID_DELETE_SINGLE_SEND_BY_ID: 'Action'
    SENDGRID_DELETE_SINGLE_SEND_SCHEDULE: 'Action'
    SENDGRID_DELETE_SPAM_REPORTS: 'Action'
    SENDGRID_DELETE_TEAMMATE: 'Action'
    SENDGRID_DELETE_VERIFIED_SENDER: 'Action'
    SENDGRID_DENY_ACCESS_REQUEST: 'Action'
    SENDGRID_DISASSOCIATE_AN_AUTHENTICATED_DOMAIN_FROM_A_GIVEN_USER: 'Action'
    SENDGRID_DISASSOCIATE_A_BRANDED_LINK_FROM_A_SUBUSER: 'Action'
    SENDGRID_DOMAIN_WARN_LIST: 'Action'
    SENDGRID_DOWNLOAD_CSV: 'Action'
    SENDGRID_DUPLICATE_A_TRANSACTIONAL_TEMPLATE: 'Action'
    SENDGRID_DUPLICATE_DESIGN: 'Action'
    SENDGRID_DUPLICATE_SEND_GRID_PRE_BUILT_DESIGN: 'Action'
    SENDGRID_DUPLICATE_SINGLE_SEND: 'Action'
    SENDGRID_EDIT_AN_SSO_TEAMMATE: 'Action'
    SENDGRID_EDIT_A_TRANSACTIONAL_TEMPLATE: 'Action'
    SENDGRID_EDIT_A_TRANSACTIONAL_TEMPLATE_VERSION: 'Action'
    SENDGRID_EDIT_VERIFIED_SENDER: 'Action'
    SENDGRID_EMAIL_DNS_RECORDS_TO_A_CO_WORKER: 'Action'
    SENDGRID_ENABLE_DISABLE_A_SUBUSER: 'Action'
    SENDGRID_ENABLE_DISABLE_WEBSITE_ACCESS_FOR_A_SUBUSER: 'Action'
    SENDGRID_ERASE_RECIPIENTS_EMAIL_DATA: 'Action'
    SENDGRID_EXPORT_CONTACTS: 'Action'
    SENDGRID_EXPORT_CONTACTS_STATUS: 'Action'
    SENDGRID_EXPORT_SINGLE_SEND_STATS: 'Action'
    SENDGRID_FILTER_ALL_MESSAGES: 'Action'
    SENDGRID_FILTER_MESSAGES_BY_MESSAGE_ID: 'Action'
    SENDGRID_FILTER_SEGMENTS_BY_PARENT_IDS: 'Action'
    SENDGRID_GET_ACCOUNT_OFFERINGS: 'Action'
    SENDGRID_GET_ALL_ACCOUNTS: 'Action'
    SENDGRID_GET_ALL_AUTOMATION_STATS: 'Action'
    SENDGRID_GET_ALL_AVAILABLE_OFFERINGS: 'Action'
    SENDGRID_GET_ALL_CATEGORIES: 'Action'
    SENDGRID_GET_ALL_EXISTING_EXPORTS: 'Action'
    SENDGRID_GET_ALL_FIELD_DEFINITIONS: 'Action'
    SENDGRID_GET_ALL_IP_POOLS_THAT_HAVE_ASSOCIATED_IPS: 'Action'
    SENDGRID_GET_ALL_LISTS: 'Action'
    SENDGRID_GET_ALL_SENDER_IDENTITIES: 'Action'
    SENDGRID_GET_ALL_SINGLE_SENDS: 'Action'
    SENDGRID_GET_ALL_SINGLE_SENDS_STATS: 'Action'
    SENDGRID_GET_ALL_SSO_CERTIFICATES_BY_INTEGRATION: 'Action'
    SENDGRID_GET_ALL_SSO_INTEGRATIONS: 'Action'
    SENDGRID_GET_ALL_VERIFIED_SENDERS: 'Action'
    SENDGRID_GET_AN_ACCOUNT_S_STATE: 'Action'
    SENDGRID_GET_AN_SSO_CERTIFICATE: 'Action'
    SENDGRID_GET_AN_SSO_INTEGRATION: 'Action'
    SENDGRID_GET_AUTOMATION_CLICK_TRACKING_STATS_BY_ID: 'Action'
    SENDGRID_GET_AUTOMATION_STATS_BY_ID: 'Action'
    SENDGRID_GET_A_CONTACT_BY_ID: 'Action'
    SENDGRID_GET_A_LIST_BY_ID: 'Action'
    SENDGRID_GET_A_LIST_OF_ALL_IP_ADDRESSES_ON_YOUR_ACCOUNT: 'Action'
    SENDGRID_GET_A_LIST_OF_ALL_SENDERS: 'Action'
    SENDGRID_GET_A_LIST_OF_SUBUSERS_ASSIGNED_TO_AN_IP: 'Action'
    SENDGRID_GET_A_SPECIFIC_SENDER: 'Action'
    SENDGRID_GET_A_USER_S_ACCOUNT_INFORMATION: 'Action'
    SENDGRID_GET_A_USER_S_PROFILE: 'Action'
    SENDGRID_GET_BATCHED_CONTACTS_BY_IDS: 'Action'
    SENDGRID_GET_CONTACTS_BY_EMAILS: 'Action'
    SENDGRID_GET_CONTACTS_BY_IDENTIFIERS: 'Action'
    SENDGRID_GET_DESIGN: 'Action'
    SENDGRID_GET_DETAILS_FOR_AN_IP_ADDRESS: 'Action'
    SENDGRID_GET_DETAILS_FOR_AN_IP_POOL: 'Action'
    SENDGRID_GET_ENGAGEMENT_QUALITY_SCORES: 'Action'
    SENDGRID_GET_INFORMATION_ON_A_SINGLE_SUPPRESSION_GROUP: 'Action'
    SENDGRID_GET_INTEGRATION: 'Action'
    SENDGRID_GET_IPS_ASSIGNED_TO_AN_IP_POOL: 'Action'
    SENDGRID_GET_LIST_CONTACT_COUNT: 'Action'
    SENDGRID_GET_LIST_OF_SEGMENTS: 'Action'
    SENDGRID_GET_OPEN_TRACKING_SETTINGS: 'Action'
    SENDGRID_GET_RECIPIENT_UPLOAD_STATUS: 'Action'
    SENDGRID_GET_REMAINING_IPS_COUNT: 'Action'
    SENDGRID_GET_SAMPLE_CONTACTS: 'Action'
    SENDGRID_GET_SEGMENT_BY_ID: 'Action'
    SENDGRID_GET_SEND_GRID_PRE_BUILT_DESIGN: 'Action'
    SENDGRID_GET_SIGNED_EVENT_WEBHOOK_S_PUBLIC_KEY: 'Action'
    SENDGRID_GET_SINGLE_SENDS_SEARCH: 'Action'
    SENDGRID_GET_SINGLE_SEND_BY_ID: 'Action'
    SENDGRID_GET_SINGLE_SEND_CLICK_TRACKING_STATS_BY_ID: 'Action'
    SENDGRID_GET_SINGLE_SEND_STATS_BY_ID: 'Action'
    SENDGRID_GET_SUBUSERS_ENGAGEMENT_QUALITY_SCORES: 'Action'
    SENDGRID_GET_TEAMMATE_SUBUSER_ACCESS: 'Action'
    SENDGRID_GET_THE_CREDITS_FOR_A_SUBUSER: 'Action'
    SENDGRID_GET_THE_DEFAULT_AUTHENTICATION: 'Action'
    SENDGRID_GET_THE_SETTINGS_FOR_A_SINGLE_EVENT_WEBHOOK: 'Action'
    SENDGRID_GET_TOTAL_CONTACT_COUNT: 'Action'
    SENDGRID_IMPORT_CONTACTS: 'Action'
    SENDGRID_IMPORT_CONTACTS_STATUS: 'Action'
    SENDGRID_INVITE_TEAMMATE: 'Action'
    SENDGRID_LIST_ALL_AUTHENTICATED_DOMAINS: 'Action'
    SENDGRID_LIST_ALL_SUBUSERS: 'Action'
    SENDGRID_LIST_DESIGNS: 'Action'
    SENDGRID_LIST_INTEGRATION: 'Action'
    SENDGRID_LIST_SEND_GRID_PRE_BUILT_DESIGNS: 'Action'
    SENDGRID_LIST_THE_AUTHENTICATED_DOMAIN_ASSOCIATED_WITH_THE_GIVEN_USER: 'Action'
    SENDGRID_MANUALLY_REFRESH_A_SEGMENT: 'Action'
    SENDGRID_PRESIGNED_URL_HEADERS_FOR_BULK_EMAIL_VALIDATION: 'Action'
    SENDGRID_REMOVE_AN_IP_ADDRESS_FROM_A_POOL: 'Action'
    SENDGRID_REMOVE_AN_IP_FROM_AN_AUTHENTICATED_DOMAIN: 'Action'
    SENDGRID_REMOVE_A_SPECIFIC_IP_FROM_THE_ALLOWED_LIST: 'Action'
    SENDGRID_REMOVE_CONTACTS_FROM_A_LIST: 'Action'
    SENDGRID_REMOVE_LIST_AND_OPTIONAL_CONTACTS: 'Action'
    SENDGRID_REMOVE_ONE_OR_MORE_IPS_FROM_THE_ALLOW_LIST: 'Action'
    SENDGRID_REMOVE_SEGMENT_WITHOUT_AFFECTING_CONTACTS: 'Action'
    SENDGRID_RENAME_AN_IP_POOL: 'Action'
    SENDGRID_REQUEST_CSV: 'Action'
    SENDGRID_RESEND_A_SENDER_VERIFICATION: 'Action'
    SENDGRID_RESEND_SENDER_IDENTITY_VERIFICATION: 'Action'
    SENDGRID_RESEND_TEAMMATE_INVITE: 'Action'
    SENDGRID_RESEND_VERIFIED_SENDER_REQUEST: 'Action'
    SENDGRID_RETRIEVES_INBOUND_PARSE_WEBHOOK_STATISTICS: 'Action'
    SENDGRID_RETRIEVE_ACCESS_REQUESTS: 'Action'
    SENDGRID_RETRIEVE_ADDRESS_WHITELIST_MAIL_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_ALL_ALERTS: 'Action'
    SENDGRID_RETRIEVE_ALL_API_KEYS_BELONGING_TO_THE_AUTHENTICATED_USER: 'Action'
    SENDGRID_RETRIEVE_ALL_ASSIGNED_IPS: 'Action'
    SENDGRID_RETRIEVE_ALL_BLOCKS: 'Action'
    SENDGRID_RETRIEVE_ALL_BOUNCES: 'Action'
    SENDGRID_RETRIEVE_ALL_BRANDED_LINKS: 'Action'
    SENDGRID_RETRIEVE_ALL_CAMPAIGNS: 'Action'
    SENDGRID_RETRIEVE_ALL_CATEGORIES: 'Action'
    SENDGRID_RETRIEVE_ALL_CUSTOM_FIELDS: 'Action'
    SENDGRID_RETRIEVE_ALL_GLOBAL_SUPPRESSIONS: 'Action'
    SENDGRID_RETRIEVE_ALL_INVALID_EMAILS: 'Action'
    SENDGRID_RETRIEVE_ALL_IPS_CURRENTLY_IN_WARMUP: 'Action'
    SENDGRID_RETRIEVE_ALL_IP_ADDRESSES: 'Action'
    SENDGRID_RETRIEVE_ALL_IP_POOLS: 'Action'
    SENDGRID_RETRIEVE_ALL_IP_POOLS_AN_IP_ADDRESS_BELONGS_TO: 'Action'
    SENDGRID_RETRIEVE_ALL_LISTS: 'Action'
    SENDGRID_RETRIEVE_ALL_MAIL_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_ALL_OF_YOUR_EVENT_WEBHOOKS: 'Action'
    SENDGRID_RETRIEVE_ALL_PARSE_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_ALL_PENDING_TEAMMATES: 'Action'
    SENDGRID_RETRIEVE_ALL_RECENT_ACCESS_ATTEMPTS: 'Action'
    SENDGRID_RETRIEVE_ALL_RECIPIENTS_ON_A_LIST: 'Action'
    SENDGRID_RETRIEVE_ALL_REVERSE_DNS_RECORDS: 'Action'
    SENDGRID_RETRIEVE_ALL_SCHEDULED_SENDS: 'Action'
    SENDGRID_RETRIEVE_ALL_SEGMENTS: 'Action'
    SENDGRID_RETRIEVE_ALL_SPAM_REPORTS: 'Action'
    SENDGRID_RETRIEVE_ALL_SUPPRESSIONS: 'Action'
    SENDGRID_RETRIEVE_ALL_SUPPRESSIONS_FOR_A_SUPPRESSION_GROUP: 'Action'
    SENDGRID_RETRIEVE_ALL_SUPPRESSION_GROUPS_ASSOCIATED_WITH_THE_USER: 'Action'
    SENDGRID_RETRIEVE_ALL_SUPPRESSION_GROUPS_FOR_AN_EMAIL_ADDRESS: 'Action'
    SENDGRID_RETRIEVE_ALL_TEAMMATES: 'Action'
    SENDGRID_RETRIEVE_ALL_THE_IPS_IN_A_SPECIFIED_POOL: 'Action'
    SENDGRID_RETRIEVE_AN_AUTHENTICATED_DOMAIN: 'Action'
    SENDGRID_RETRIEVE_AN_EXISTING_API_KEY: 'Action'
    SENDGRID_RETRIEVE_A_BOUNCE: 'Action'
    SENDGRID_RETRIEVE_A_BRANDED_LINK: 'Action'
    SENDGRID_RETRIEVE_A_COUNT_OF_RECIPIENTS: 'Action'
    SENDGRID_RETRIEVE_A_CUSTOM_FIELD: 'Action'
    SENDGRID_RETRIEVE_A_GLOBAL_SUPPRESSION: 'Action'
    SENDGRID_RETRIEVE_A_LIST_OF_CURRENTLY_ALLOWED_IPS: 'Action'
    SENDGRID_RETRIEVE_A_LIST_OF_SCOPES_FOR_WHICH_THIS_USER_HAS_ACCESS: 'Action'
    SENDGRID_RETRIEVE_A_REVERSE_DNS_RECORD: 'Action'
    SENDGRID_RETRIEVE_A_SEGMENT: 'Action'
    SENDGRID_RETRIEVE_A_SINGLE_CAMPAIGN: 'Action'
    SENDGRID_RETRIEVE_A_SINGLE_LIST: 'Action'
    SENDGRID_RETRIEVE_A_SINGLE_RECIPIENT: 'Action'
    SENDGRID_RETRIEVE_A_SINGLE_TRANSACTIONAL_TEMPLATE: 'Action'
    SENDGRID_RETRIEVE_A_SPECIFIC_ALERT: 'Action'
    SENDGRID_RETRIEVE_A_SPECIFIC_ALLOWED_IP: 'Action'
    SENDGRID_RETRIEVE_A_SPECIFIC_BLOCK: 'Action'
    SENDGRID_RETRIEVE_A_SPECIFIC_INVALID_EMAIL: 'Action'
    SENDGRID_RETRIEVE_A_SPECIFIC_PARSE_SETTING: 'Action'
    SENDGRID_RETRIEVE_A_SPECIFIC_SPAM_REPORT: 'Action'
    SENDGRID_RETRIEVE_A_SPECIFIC_TRANSACTIONAL_TEMPLATE_VERSION: 'Action'
    SENDGRID_RETRIEVE_A_SUBUSER_S_BRANDED_LINK: 'Action'
    SENDGRID_RETRIEVE_BOUNCE_CLASSIFICATION_OVER_TIME_BY_DOMAIN_STATS: 'Action'
    SENDGRID_RETRIEVE_BOUNCE_CLASSIFICATION_TOTALS: 'Action'
    SENDGRID_RETRIEVE_BOUNCE_PURGE_MAIL_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_CLICK_TRACK_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_CURRENT_ENFORCED_TLS_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_EMAIL_STATISTICS_BY_BROWSER: 'Action'
    SENDGRID_RETRIEVE_EMAIL_STATISTICS_BY_CLIENT_TYPE: 'Action'
    SENDGRID_RETRIEVE_EMAIL_STATISTICS_BY_COUNTRY_AND_STATE_PROVINCE: 'Action'
    SENDGRID_RETRIEVE_EMAIL_STATISTICS_BY_DEVICE_TYPE: 'Action'
    SENDGRID_RETRIEVE_EMAIL_STATISTICS_BY_MAILBOX_PROVIDER: 'Action'
    SENDGRID_RETRIEVE_EMAIL_STATISTICS_FOR_CATEGORIES: 'Action'
    SENDGRID_RETRIEVE_EMAIL_STATISTICS_FOR_YOUR_SUBUSERS: 'Action'
    SENDGRID_RETRIEVE_FOOTER_MAIL_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_FORWARD_BOUNCE_MAIL_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_FORWARD_SPAM_MAIL_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_GLOBAL_EMAIL_STATISTICS: 'Action'
    SENDGRID_RETRIEVE_GOOGLE_ANALYTICS_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_LEGACY_TEMPLATE_MAIL_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_MONTHLY_STATS_FOR_ALL_SUBUSERS: 'Action'
    SENDGRID_RETRIEVE_PAGED_TRANSACTIONAL_TEMPLATES: 'Action'
    SENDGRID_RETRIEVE_RECIPIENTS: 'Action'
    SENDGRID_RETRIEVE_RECIPIENTS_ON_A_SEGMENT: 'Action'
    SENDGRID_RETRIEVE_RESERVED_FIELDS: 'Action'
    SENDGRID_RETRIEVE_SCHEDULED_SEND: 'Action'
    SENDGRID_RETRIEVE_SINGLE_SEGMENT_ENDPOINT: 'Action'
    SENDGRID_RETRIEVE_SPECIFIC_TEAMMATE: 'Action'
    SENDGRID_RETRIEVE_STATS_BY_A_SPECIFIC_CLIENT_TYPE: 'Action'
    SENDGRID_RETRIEVE_SUBSCRIPTION_TRACKING_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_SUBUSER_REPUTATIONS: 'Action'
    SENDGRID_RETRIEVE_SUMS_OF_EMAIL_STATS_FOR_EACH_CATEGORY: 'Action'
    SENDGRID_RETRIEVE_THE_COUNT_OF_BILLABLE_RECIPIENTS: 'Action'
    SENDGRID_RETRIEVE_THE_DEFAULT_BRANDED_LINK: 'Action'
    SENDGRID_RETRIEVE_THE_LISTS_THAT_A_RECIPIENT_IS_ON: 'Action'
    SENDGRID_RETRIEVE_THE_MONTHLY_EMAIL_STATISTICS_FOR_A_SINGLE_SUBUSER: 'Action'
    SENDGRID_RETRIEVE_THE_WARMUP_STATUS_FOR_A_SPECIFIC_IP_ADDRESS: 'Action'
    SENDGRID_RETRIEVE_TRACKING_SETTINGS: 'Action'
    SENDGRID_RETRIEVE_USER_S_AUTHENTICATED_DOMAINS: 'Action'
    SENDGRID_RETRIEVE_YOUR_ACCOUNT_EMAIL_ADDRESS: 'Action'
    SENDGRID_RETRIEVE_YOUR_CREDIT_BALANCE: 'Action'
    SENDGRID_RETRIEVE_YOUR_USERNAME: 'Action'
    SENDGRID_RETURNS_A_LIST_OF_ALL_PARTNER_SETTINGS: 'Action'
    SENDGRID_SCHEDULE_A_CAMPAIGN: 'Action'
    SENDGRID_SCHEDULE_SINGLE_SEND: 'Action'
    SENDGRID_SEARCH_CONTACTS: 'Action'
    SENDGRID_SEARCH_FOR_SUPPRESSIONS_WITHIN_A_GROUP: 'Action'
    SENDGRID_SEARCH_RECIPIENTS: 'Action'
    SENDGRID_SEGMENT_JSON_DATA_BY_SPECIFIC_CRITERIA: 'Action'
    SENDGRID_SEND_A_CAMPAIGN: 'Action'
    SENDGRID_SEND_A_TEST_CAMPAIGN: 'Action'
    SENDGRID_SEND_A_TEST_MARKETING_EMAIL: 'Action'
    SENDGRID_SEND_EMAIL_WITH_TWILIO_SEND_GRID: 'Action'
    SENDGRID_SET_UP_REVERSE_DNS: 'Action'
    SENDGRID_SINGLE_SEND_CSV_STATS_RETRIEVAL: 'Action'
    SENDGRID_START_WARMING_UP_AN_IP_ADDRESS: 'Action'
    SENDGRID_STOP_WARMING_UP_AN_IP_ADDRESS: 'Action'
    SENDGRID_SUM_EMAIL_STATS_FOR_SUBUSERS: 'Action'
    SENDGRID_TEST_AN_EVENT_WEBHOOK_S_SETTINGS: 'Action'
    SENDGRID_THIS_REQUEST_LISTS_ALL_OF_A_USER_S_BULK_EMAIL_VALIDATION_JOBS: 'Action'
    SENDGRID_THIS_REQUEST_RETURNS_A_SINGLE_BULK_EMAIL_VALIDATION_JOB: 'Action'
    SENDGRID_TOGGLE_SIGNATURE_VERIFICATION_FOR_A_SINGLE_EVENT_WEBHOOK_BY_ID: 'Action'
    SENDGRID_UNLINK_SUBUSER_DOMAIN: 'Action'
    SENDGRID_UNSCHEDULE_A_SCHEDULED_CAMPAIGN: 'Action'
    SENDGRID_UPDATE_ACCOUNT_OFFERINGS: 'Action'
    SENDGRID_UPDATE_ADDRESS_WHITELIST_MAIL_SETTINGS: 'Action'
    SENDGRID_UPDATE_AN_ACCOUNT_S_STATE: 'Action'
    SENDGRID_UPDATE_AN_ALERT: 'Action'
    SENDGRID_UPDATE_AN_AUTHENTICATED_DOMAIN: 'Action'
    SENDGRID_UPDATE_AN_IP_POOL_NAME: 'Action'
    SENDGRID_UPDATE_AN_SSO_INTEGRATION: 'Action'
    SENDGRID_UPDATE_API_KEY_NAME: 'Action'
    SENDGRID_UPDATE_API_KEY_NAME_AND_SCOPES: 'Action'
    SENDGRID_UPDATE_A_BRANDED_LINK: 'Action'
    SENDGRID_UPDATE_A_CAMPAIGN: 'Action'
    SENDGRID_UPDATE_A_LIST: 'Action'
    SENDGRID_UPDATE_A_PARSE_SETTING: 'Action'
    SENDGRID_UPDATE_A_SCHEDULED_CAMPAIGN: 'Action'
    SENDGRID_UPDATE_A_SCHEDULED_SEND: 'Action'
    SENDGRID_UPDATE_A_SEGMENT: 'Action'
    SENDGRID_UPDATE_A_SENDER: 'Action'
    SENDGRID_UPDATE_A_SENDER_IDENTITY: 'Action'
    SENDGRID_UPDATE_A_SINGLE_EVENT_WEBHOOK_BY_ID: 'Action'
    SENDGRID_UPDATE_A_SUPPRESSION_GROUP: 'Action'
    SENDGRID_UPDATE_A_USER_S_PROFILE: 'Action'
    SENDGRID_UPDATE_BOUNCE_PURGE_MAIL_SETTINGS: 'Action'
    SENDGRID_UPDATE_CLICK_TRACKING_SETTINGS: 'Action'
    SENDGRID_UPDATE_CUSTOM_FIELD_DEFINITION: 'Action'
    SENDGRID_UPDATE_DESIGN: 'Action'
    SENDGRID_UPDATE_DETAILS_FOR_AN_IP_ADDRESS: 'Action'
    SENDGRID_UPDATE_ENFORCED_TLS_SETTINGS: 'Action'
    SENDGRID_UPDATE_FOOTER_MAIL_SETTINGS: 'Action'
    SENDGRID_UPDATE_FORWARD_BOUNCE_MAIL_SETTINGS: 'Action'
    SENDGRID_UPDATE_FORWARD_SPAM_MAIL_SETTINGS: 'Action'
    SENDGRID_UPDATE_GOOGLE_ANALYTICS_SETTINGS: 'Action'
    SENDGRID_UPDATE_INTEGRATION: 'Action'
    SENDGRID_UPDATE_LIST: 'Action'
    SENDGRID_UPDATE_OPEN_TRACKING_SETTINGS: 'Action'
    SENDGRID_UPDATE_SEGMENT: 'Action'
    SENDGRID_UPDATE_SINGLE_SEND: 'Action'
    SENDGRID_UPDATE_SSO_CERTIFICATE: 'Action'
    SENDGRID_UPDATE_SUBSCRIPTION_TRACKING_SETTINGS: 'Action'
    SENDGRID_UPDATE_TEAMMATE_S_PERMISSIONS: 'Action'
    SENDGRID_UPDATE_TEMPLATE_MAIL_SETTINGS: 'Action'
    SENDGRID_UPDATE_THE_CREDITS_FOR_A_SUBUSER: 'Action'
    SENDGRID_UPDATE_THE_REMAINING_CREDITS_FOR_A_SUBUSER: 'Action'
    SENDGRID_UPDATE_YOUR_ACCOUNT_EMAIL_ADDRESS: 'Action'
    SENDGRID_UPDATE_YOUR_PASSWORD: 'Action'
    SENDGRID_UPDATE_YOUR_USERNAME: 'Action'
    SENDGRID_VALIDATE_AN_EMAIL: 'Action'
    SENDGRID_VALIDATE_A_BATCH_ID: 'Action'
    SENDGRID_VALIDATE_A_BRANDED_LINK: 'Action'
    SENDGRID_VALIDATE_A_DOMAIN_AUTHENTICATION: 'Action'
    SENDGRID_VALIDATE_A_REVERSE_DNS_RECORD: 'Action'
    SENDGRID_VERIFY_SENDER_REQUEST: 'Action'
    SENDGRID_VIEW_A_SENDER_IDENTITY: 'Action'
    SENDGRID_VIEW_SCHEDULED_TIME_OF_A_CAMPAIGN: 'Action'
    SERPAPI_DUCK_DUCK_GO_SEARCH: 'Action'
    SERPAPI_EVENT_SEARCH: 'Action'
    SERPAPI_FINANCE_SEARCH: 'Action'
    SERPAPI_GOOGLE_MAPS_SEARCH: 'Action'
    SERPAPI_IMAGE_SEARCH: 'Action'
    SERPAPI_NEWS_SEARCH: 'Action'
    SERPAPI_SCHOLAR_SEARCH: 'Action'
    SERPAPI_SEARCH: 'Action'
    SERPAPI_SHOPPING_SEARCH: 'Action'
    SERPAPI_TRENDS_SEARCH: 'Action'
    SHELLTOOL_CREATE_SHELL: 'Action'
    SHELLTOOL_EXEC_COMMAND: 'Action'
    SHELLTOOL_SPAWN_PROCESS: 'Action'
    SHELLTOOL_TEST_COMMAND: 'Action'
    SHOPIFY_ADD_PRODUCT_TO_COLLECTION: 'Action'
    SHOPIFY_COUNT_PRODUCT_IMAGES: 'Action'
    SHOPIFY_CREATE_CUSTOM_COLLECTION: 'Action'
    SHOPIFY_CREATE_ORDER: 'Action'
    SHOPIFY_CREATE_PRODUCT: 'Action'
    SHOPIFY_DELETE_CUSTOM_COLLECTION: 'Action'
    SHOPIFY_DELETE_PRODUCT: 'Action'
    SHOPIFY_DELETE_PRODUCT_IMAGE: 'Action'
    SHOPIFY_GET_ALL_CUSTOMERS: 'Action'
    SHOPIFY_GET_COLLECTION_BY_ID: 'Action'
    SHOPIFY_GET_COLLECTS: 'Action'
    SHOPIFY_GET_COLLECTS_COUNT: 'Action'
    SHOPIFY_GET_CUSTOMER: 'Action'
    SHOPIFY_GET_CUSTOM_COLLECTIONS: 'Action'
    SHOPIFY_GET_CUSTOM_COLLECTIONS_COUNT: 'Action'
    SHOPIFY_GET_ORDERSBY_ID: 'Action'
    SHOPIFY_GET_ORDER_LIST: 'Action'
    SHOPIFY_GET_PRODUCT: 'Action'
    SHOPIFY_GET_PRODUCTS: 'Action'
    SHOPIFY_GET_PRODUCTS_COUNT: 'Action'
    SHOPIFY_GET_PRODUCTS_IN_COLLECTION: 'Action'
    SHOPIFY_GET_PRODUCT_IMAGE: 'Action'
    SHOPIFY_GET_PRODUCT_IMAGES: 'Action'
    SHOPIFY_GET_SHOP_DETAILS: 'Action'
    SHOPIFY_UPDATE_ORDER: 'Action'
    SLACKBOT_ACTIVATE_OR_MODIFY_DO_NOT_DISTURB_DURATION: 'Action'
    SLACKBOT_ADD_AN_EMOJI_ALIAS_IN_SLACK: 'Action'
    SLACKBOT_ADD_A_CUSTOM_EMOJI_TO_A_SLACK_TEAM: 'Action'
    SLACKBOT_ADD_A_REMOTE_FILE_FROM_A_SERVICE: 'Action'
    SLACKBOT_ADD_A_STAR_TO_AN_ITEM: 'Action'
    SLACKBOT_ADD_DEFAULT_CHANNELS_TO_IDP_GROUP: 'Action'
    SLACKBOT_ADD_ENTERPRISE_USER_TO_WORKSPACE: 'Action'
    SLACKBOT_ADD_IDP_GROUP_ALLOWLIST_TO_CHANNEL: 'Action'
    SLACKBOT_ADD_REACTION_TO_AN_ITEM: 'Action'
    SLACKBOT_APPROVE_AN_APP_INSTALLATION_IN_A_WORKSPACE: 'Action'
    SLACKBOT_APPROVE_WORKSPACE_INVITE_REQUEST: 'Action'
    SLACKBOT_APPS_PERMISSIONS_LIST_PERMISSIONS: 'Action'
    SLACKBOT_APPS_PERMISSIONS_SCOPES_GET_LIST: 'Action'
    SLACKBOT_ARCHIVE_A_PUBLIC_OR_PRIVATE_CHANNEL: 'Action'
    SLACKBOT_ARCHIVE_A_SLACK_CONVERSATION: 'Action'
    SLACKBOT_ASSOCIATE_DEFAULT_WORKSPACES_WITH_IDP_GROUP: 'Action'
    SLACKBOT_CHAT_POST_MESSAGE: 'Action'
    SLACKBOT_CHECKS_API_CALL_AND_RETURNS_SUCCESS_OR_ERROR: 'Action'
    SLACKBOT_CHECKS_AUTHENTICATION_AND_IDENTITY: 'Action'
    SLACKBOT_CLOSE_DM_OR_MULTI_PERSON_DM: 'Action'
    SLACKBOT_CONVERSATIONS_HISTORY: 'Action'
    SLACKBOT_CONVERSATIONS_INFO: 'Action'
    SLACKBOT_CONVERSATIONS_LIST: 'Action'
    SLACKBOT_CONVERT_PUBLIC_CHANNEL_TO_PRIVATE: 'Action'
    SLACKBOT_CREATE_AN_ENTERPRISE_TEAM: 'Action'
    SLACKBOT_CREATE_A_REMINDER: 'Action'
    SLACKBOT_CREATE_A_SLACK_USER_GROUP: 'Action'
    SLACKBOT_CREATE_CHANNEL_BASED_CONVERSATION: 'Action'
    SLACKBOT_CUSTOMIZE_URL_UNFURLING_IN_MESSAGES: 'Action'
    SLACKBOT_DELETES_A_MESSAGE_FROM_A_CHAT: 'Action'
    SLACKBOT_DELETE_A_COMMENT_ON_A_FILE: 'Action'
    SLACKBOT_DELETE_A_FILE_BY_ID: 'Action'
    SLACKBOT_DELETE_A_PUBLIC_OR_PRIVATE_CHANNEL: 'Action'
    SLACKBOT_DELETE_A_SCHEDULED_MESSAGE_IN_A_CHAT: 'Action'
    SLACKBOT_DELETE_A_SLACK_REMINDER: 'Action'
    SLACKBOT_DELETE_USER_PROFILE_PHOTO: 'Action'
    SLACKBOT_DENY_WORKSPACE_INVITE_REQUEST: 'Action'
    SLACKBOT_DISABLE_AN_EXISTING_SLACK_USER_GROUP: 'Action'
    SLACKBOT_DISCONNECT_CHANNEL_FROM_WORKSPACES: 'Action'
    SLACKBOT_ENABLE_A_SPECIFIED_USER_GROUP: 'Action'
    SLACKBOT_ENABLE_PUBLIC_SHARING_OF_A_FILE: 'Action'
    SLACKBOT_END_A_CALL_WITH_DURATION_AND_ID: 'Action'
    SLACKBOT_END_USER_DO_NOT_DISTURB_SESSION: 'Action'
    SLACKBOT_END_USER_SNOOZE_MODE_IMMEDIATELY: 'Action'
    SLACKBOT_EXCHANGE_OAUTH_CODE_FOR_ACCESS_TOKEN: 'Action'
    SLACKBOT_EXCHANGE_OAUTH_CODE_FOR_WORKSPACE_TOKEN: 'Action'
    SLACKBOT_EXCHANGE_OAUTH_VERIFIER_FOR_ACCESS_TOKEN: 'Action'
    SLACKBOT_FETCH_BOT_USER_INFORMATION: 'Action'
    SLACKBOT_FETCH_CONVERSATION_HISTORY: 'Action'
    SLACKBOT_FETCH_CURRENT_TEAM_INFO_WITH_OPTIONAL_TEAM_SCOPE: 'Action'
    SLACKBOT_FETCH_DND_STATUS_FOR_MULTIPLE_TEAM_MEMBERS: 'Action'
    SLACKBOT_FETCH_ITEM_REACTIONS: 'Action'
    SLACKBOT_FETCH_MESSAGE_THREAD_FROM_A_CONVERSATION: 'Action'
    SLACKBOT_FETCH_WORKSPACE_SETTINGS_INFORMATION: 'Action'
    SLACKBOT_FIND_USER_BY_EMAIL_ADDRESS: 'Action'
    SLACKBOT_GET_BILLABLE_TEAM_USER_INFO: 'Action'
    SLACKBOT_GET_CHANNEL_CONVERSATION_PREFERENCES: 'Action'
    SLACKBOT_GET_CHANNEL_S_CONNECTED_WORKSPACES_IN_ENTERPRISE: 'Action'
    SLACKBOT_GET_CURRENT_TEAM_INTEGRATION_LOGS: 'Action'
    SLACKBOT_GET_CURRENT_TEAM_S_ACCESS_LOGS: 'Action'
    SLACKBOT_GET_REMINDER_INFORMATION: 'Action'
    SLACKBOT_GET_USER_PRESENCE_INFO: 'Action'
    SLACKBOT_INDICATE_WORKFLOW_STEP_FAILURE: 'Action'
    SLACKBOT_INITIATES_CHANNEL_BASED_CONVERSATIONS: 'Action'
    SLACKBOT_INVALIDATE_A_USER_SESSION_BY_ID: 'Action'
    SLACKBOT_INVITE_USERS_TO_A_SLACK_CHANNEL: 'Action'
    SLACKBOT_INVITE_USER_TO_CHANNEL: 'Action'
    SLACKBOT_INVITE_USER_TO_WORKSPACE_WITH_OPTIONAL_CHANNEL_INVITES: 'Action'
    SLACKBOT_JOIN_AN_EXISTING_CONVERSATION: 'Action'
    SLACKBOT_LEAVE_A_CONVERSATION: 'Action'
    SLACKBOT_LISTS_PINNED_ITEMS_IN_A_CHANNEL: 'Action'
    SLACKBOT_LISTS_USER_S_STARRED_ITEMS_WITH_PAGINATION: 'Action'
    SLACKBOT_LIST_ACCESSIBLE_CONVERSATIONS_FOR_A_USER: 'Action'
    SLACKBOT_LIST_ALL_SLACK_TEAM_CHANNELS_WITH_VARIOUS_FILTERS: 'Action'
    SLACKBOT_LIST_ALL_SLACK_TEAM_USERS_WITH_PAGINATION: 'Action'
    SLACKBOT_LIST_ALL_TEAMS_IN_AN_ENTERPRISE_ORGANIZATION: 'Action'
    SLACKBOT_LIST_ALL_USERS_IN_A_USER_GROUP: 'Action'
    SLACKBOT_LIST_APPROVED_APPS_FOR_ORG_OR_WORKSPACE: 'Action'
    SLACKBOT_LIST_APPROVED_WORKSPACE_INVITE_REQUESTS: 'Action'
    SLACKBOT_LIST_APP_PERMISSIONS_ON_A_TEAM: 'Action'
    SLACKBOT_LIST_APP_PERMISSIONS_SCOPES_ON_A_TEAM: 'Action'
    SLACKBOT_LIST_APP_RESOURCE_GRANTS_ON_A_TEAM: 'Action'
    SLACKBOT_LIST_APP_USER_GRANTS_AND_SCOPES_ON_TEAM: 'Action'
    SLACKBOT_LIST_DENIED_WORKSPACE_INVITE_REQUESTS: 'Action'
    SLACKBOT_LIST_DISCONNECTED_CHANNELS_WITH_ORIGINAL_IDS_FOR_EKM: 'Action'
    SLACKBOT_LIST_ENTERPRISE_GRID_ORGANIZATION_EMOJIS: 'Action'
    SLACKBOT_LIST_EVENT_AUTHORIZATIONS_FOR_APPS: 'Action'
    SLACKBOT_LIST_FILES_WITH_FILTERS_IN_SLACK: 'Action'
    SLACKBOT_LIST_IDP_GROUPS_LINKED_TO_A_CHANNEL: 'Action'
    SLACKBOT_LIST_ORG_LEVEL_IDP_GROUP_CHANNELS: 'Action'
    SLACKBOT_LIST_PENDING_WORKSPACE_INVITE_REQUESTS: 'Action'
    SLACKBOT_LIST_RESTRICTED_APPS_FOR_AN_ORG_OR_WORKSPACE: 'Action'
    SLACKBOT_LIST_SCHEDULED_MESSAGES_IN_A_CHANNEL: 'Action'
    SLACKBOT_LIST_SLACK_S_REMOTE_FILES_WITH_FILTERS: 'Action'
    SLACKBOT_LIST_TEAM_CUSTOM_EMOJIS: 'Action'
    SLACKBOT_LIST_TEAM_WORKSPACE_APP_REQUESTS: 'Action'
    SLACKBOT_LIST_USER_GROUPS_FOR_TEAM_WITH_OPTIONS: 'Action'
    SLACKBOT_LIST_USER_REACTIONS: 'Action'
    SLACKBOT_LIST_USER_REMINDERS_WITH_DETAILS: 'Action'
    SLACKBOT_LIST_WORKSPACE_ADMINS: 'Action'
    SLACKBOT_LIST_WORKSPACE_OWNERS: 'Action'
    SLACKBOT_LIST_WORKSPACE_USERS: 'Action'
    SLACKBOT_MANUALLY_SET_USER_PRESENCE: 'Action'
    SLACKBOT_MAP_USER_IDS_FOR_ENTERPRISE_GRID_WORKSPACES: 'Action'
    SLACKBOT_MARK_A_USER_AS_ACTIVE_DEPRECATED: 'Action'
    SLACKBOT_MARK_REMINDER_AS_COMPLETE: 'Action'
    SLACKBOT_MARK_WORKFLOW_STEP_AS_COMPLETED: 'Action'
    SLACKBOT_OPEN_A_VIEW_FOR_A_SLACK_USER: 'Action'
    SLACKBOT_OPEN_OR_RESUME_DIRECT_OR_MULTI_PERSON_MESSAGES: 'Action'
    SLACKBOT_OPEN_USER_DIALOG_WITH_JSON_DEFINED_UI: 'Action'
    SLACKBOT_PINS_AN_ITEM_TO_A_CHANNEL: 'Action'
    SLACKBOT_PROMOTE_USER_TO_ADMIN_STATUS: 'Action'
    SLACKBOT_PROMOTE_USER_TO_WORKSPACE_OWNER: 'Action'
    SLACKBOT_PUBLISH_STATIC_VIEW_FOR_USER: 'Action'
    SLACKBOT_PUSH_VIEW_TO_ROOT_VIEW_STACK: 'Action'
    SLACKBOT_REGISTERS_A_NEW_CALL_WITH_PARTICIPANTS: 'Action'
    SLACKBOT_REGISTERS_NEW_CALL_PARTICIPANTS: 'Action'
    SLACKBOT_REGISTER_CALL_PARTICIPANTS_REMOVAL: 'Action'
    SLACKBOT_REMINDERS_ADD: 'Action'
    SLACKBOT_REMOVE_A_REMOTE_FILE: 'Action'
    SLACKBOT_REMOVE_A_STAR_FROM_AN_ITEM: 'Action'
    SLACKBOT_REMOVE_A_USER_FROM_A_CONVERSATION: 'Action'
    SLACKBOT_REMOVE_CHANNELS_FROM_IDP_GROUP: 'Action'
    SLACKBOT_REMOVE_ENTERPRISE_GRID_ORG_EMOJI: 'Action'
    SLACKBOT_REMOVE_IDP_GROUP_FROM_PRIVATE_CHANNEL: 'Action'
    SLACKBOT_REMOVE_REACTION_FROM_ITEM: 'Action'
    SLACKBOT_REMOVE_USER_FROM_WORKSPACE: 'Action'
    SLACKBOT_RENAME_AN_EMOJI: 'Action'
    SLACKBOT_RENAME_A_CONVERSATION: 'Action'
    SLACKBOT_RENAME_A_SLACK_CHANNEL: 'Action'
    SLACKBOT_REQUEST_ADDITIONAL_APP_PERMISSIONS: 'Action'
    SLACKBOT_RESTRICT_APP_INSTALLATION_ON_WORKSPACE: 'Action'
    SLACKBOT_RETRIEVE_A_USER_S_IDENTITY_DETAILS: 'Action'
    SLACKBOT_RETRIEVE_CALL_INFORMATION: 'Action'
    SLACKBOT_RETRIEVE_CONVERSATION_INFORMATION: 'Action'
    SLACKBOT_RETRIEVE_CONVERSATION_MEMBERS_LIST: 'Action'
    SLACKBOT_RETRIEVE_CURRENT_USER_DND_STATUS: 'Action'
    SLACKBOT_RETRIEVE_DETAILED_INFORMATION_ABOUT_A_FILE: 'Action'
    SLACKBOT_RETRIEVE_DETAILED_USER_INFORMATION: 'Action'
    SLACKBOT_RETRIEVE_MESSAGE_PERMALINK_URL: 'Action'
    SLACKBOT_RETRIEVE_REMOTE_FILE_INFO_IN_SLACK: 'Action'
    SLACKBOT_RETRIEVE_TEAM_PROFILE_DETAILS: 'Action'
    SLACKBOT_RETRIEVE_USER_PROFILE_INFORMATION: 'Action'
    SLACKBOT_REVERSE_A_CONVERSATION_S_ARCHIVAL_STATUS: 'Action'
    SLACKBOT_REVOKES_A_TOKEN_WITH_OPTIONAL_TEST_MODE: 'Action'
    SLACKBOT_REVOKE_PUBLIC_SHARING_ACCESS_FOR_A_FILE: 'Action'
    SLACKBOT_SCHEDULES_A_MESSAGE_TO_A_CHANNEL_AT_A_SPECIFIED_TIME: 'Action'
    SLACKBOT_SEARCH_CHANNELS_IN_AN_ENTERPRISE_ORGANIZATION: 'Action'
    SLACKBOT_SEARCH_FOR_MESSAGES_WITH_QUERY: 'Action'
    SLACKBOT_SEARCH_MESSAGES: 'Action'
    SLACKBOT_SENDS_A_MESSAGE_TO_A_SLACK_CHANNEL: 'Action'
    SLACKBOT_SENDS_EPHEMERAL_MESSAGES_TO_CHANNEL_USERS: 'Action'
    SLACKBOT_SET_A_CONVERSATION_S_PURPOSE: 'Action'
    SLACKBOT_SET_CHANNEL_POSTING_PERMISSIONS: 'Action'
    SLACKBOT_SET_EXPIRATION_FOR_A_GUEST_USER: 'Action'
    SLACKBOT_SET_READ_CURSOR_IN_A_CONVERSATION: 'Action'
    SLACKBOT_SET_SLACK_USER_PROFILE_INFORMATION: 'Action'
    SLACKBOT_SET_THE_TOPIC_OF_A_CONVERSATION: 'Action'
    SLACKBOT_SET_USER_PROFILE_PHOTO_WITH_CROPPING_OPTIONS: 'Action'
    SLACKBOT_SET_USER_TO_REGULAR_STATUS: 'Action'
    SLACKBOT_SET_WORKSPACE_CONNECTIONS_FOR_A_CHANNEL: 'Action'
    SLACKBOT_SET_WORKSPACE_DEFAULT_CHANNELS: 'Action'
    SLACKBOT_SET_WORKSPACE_DESCRIPTION: 'Action'
    SLACKBOT_SET_WORKSPACE_DISCOVERABILITY_SETTINGS: 'Action'
    SLACKBOT_SET_WORKSPACE_ICON: 'Action'
    SLACKBOT_SET_WORKSPACE_NAME: 'Action'
    SLACKBOT_SHARE_A_ME_MESSAGE_IN_A_CHANNEL: 'Action'
    SLACKBOT_SHARE_REMOTE_FILE_IN_CHANNELS: 'Action'
    SLACKBOT_START_REAL_TIME_MESSAGING_SESSION: 'Action'
    SLACKBOT_TRIGGER_USER_PERMISSIONS_MODAL: 'Action'
    SLACKBOT_UNARCHIVE_A_PUBLIC_OR_PRIVATE_CHANNEL: 'Action'
    SLACKBOT_UNINSTALL_APP_FROM_WORKSPACE: 'Action'
    SLACKBOT_UNPIN_ITEM_FROM_CHANNEL: 'Action'
    SLACKBOT_UPDATES_AN_EXISTING_REMOTE_FILE: 'Action'
    SLACKBOT_UPDATES_A_SLACK_MESSAGE: 'Action'
    SLACKBOT_UPDATE_AN_EXISTING_SLACK_USER_GROUP: 'Action'
    SLACKBOT_UPDATE_AN_EXISTING_SLACK_VIEW: 'Action'
    SLACKBOT_UPDATE_SLACK_CALL_INFORMATION: 'Action'
    SLACKBOT_UPDATE_USER_GROUP_MEMBERS: 'Action'
    SLACKBOT_UPDATE_WORKFLOW_EXTENSION_STEP_CONFIGURATION: 'Action'
    SLACKBOT_UPLOAD_OR_CREATE_A_FILE_IN_SLACK: 'Action'
    SLACKBOT_USERS_INFO: 'Action'
    SLACKBOT_USERS_LIST: 'Action'
    SLACKBOT_USERS_LOOKUP_BY_EMAIL: 'Action'
    SLACKBOT_USERS_PROFILE_GET_PROFILE_INFO: 'Action'
    SLACKBOT_WIPE_USER_SESSIONS_ACROSS_DEVICES: 'Action'
    SLACK_ACTIVATE_OR_MODIFY_DO_NOT_DISTURB_DURATION: 'Action'
    SLACK_ADD_AN_EMOJI_ALIAS_IN_SLACK: 'Action'
    SLACK_ADD_A_CUSTOM_EMOJI_TO_A_SLACK_TEAM: 'Action'
    SLACK_ADD_A_REMOTE_FILE_FROM_A_SERVICE: 'Action'
    SLACK_ADD_A_STAR_TO_AN_ITEM: 'Action'
    SLACK_ADD_DEFAULT_CHANNELS_TO_IDP_GROUP: 'Action'
    SLACK_ADD_ENTERPRISE_USER_TO_WORKSPACE: 'Action'
    SLACK_ADD_IDP_GROUP_ALLOWLIST_TO_CHANNEL: 'Action'
    SLACK_ADD_REACTION_TO_AN_ITEM: 'Action'
    SLACK_APPROVE_AN_APP_INSTALLATION_IN_A_WORKSPACE: 'Action'
    SLACK_APPROVE_WORKSPACE_INVITE_REQUEST: 'Action'
    SLACK_ARCHIVE_A_PUBLIC_OR_PRIVATE_CHANNEL: 'Action'
    SLACK_ARCHIVE_A_SLACK_CONVERSATION: 'Action'
    SLACK_ASSOCIATE_DEFAULT_WORKSPACES_WITH_IDP_GROUP: 'Action'
    SLACK_CHECKS_API_CALL_AND_RETURNS_SUCCESS_OR_ERROR: 'Action'
    SLACK_CHECKS_AUTHENTICATION_AND_IDENTITY: 'Action'
    SLACK_CLOSE_DM_OR_MULTI_PERSON_DM: 'Action'
    SLACK_CONVERSATIONS_HISTORY: 'Action'
    SLACK_CONVERT_PUBLIC_CHANNEL_TO_PRIVATE: 'Action'
    SLACK_CREATE_AN_ENTERPRISE_TEAM: 'Action'
    SLACK_CREATE_A_REMINDER: 'Action'
    SLACK_CREATE_A_SLACK_USER_GROUP: 'Action'
    SLACK_CREATE_CHANNEL_BASED_CONVERSATION: 'Action'
    SLACK_CUSTOMIZE_URL_UNFURLING_IN_MESSAGES: 'Action'
    SLACK_DELETES_A_MESSAGE_FROM_A_CHAT: 'Action'
    SLACK_DELETE_A_COMMENT_ON_A_FILE: 'Action'
    SLACK_DELETE_A_FILE_BY_ID: 'Action'
    SLACK_DELETE_A_PUBLIC_OR_PRIVATE_CHANNEL: 'Action'
    SLACK_DELETE_A_SCHEDULED_MESSAGE_IN_A_CHAT: 'Action'
    SLACK_DELETE_A_SLACK_REMINDER: 'Action'
    SLACK_DELETE_USER_PROFILE_PHOTO: 'Action'
    SLACK_DENY_WORKSPACE_INVITE_REQUEST: 'Action'
    SLACK_DISABLE_AN_EXISTING_SLACK_USER_GROUP: 'Action'
    SLACK_DISCONNECT_CHANNEL_FROM_WORKSPACES: 'Action'
    SLACK_ENABLE_A_SPECIFIED_USER_GROUP: 'Action'
    SLACK_ENABLE_PUBLIC_SHARING_OF_A_FILE: 'Action'
    SLACK_END_A_CALL_WITH_DURATION_AND_ID: 'Action'
    SLACK_END_USER_DO_NOT_DISTURB_SESSION: 'Action'
    SLACK_END_USER_SNOOZE_MODE_IMMEDIATELY: 'Action'
    SLACK_EXCHANGE_OAUTH_CODE_FOR_ACCESS_TOKEN: 'Action'
    SLACK_EXCHANGE_OAUTH_CODE_FOR_WORKSPACE_TOKEN: 'Action'
    SLACK_EXCHANGE_OAUTH_VERIFIER_FOR_ACCESS_TOKEN: 'Action'
    SLACK_FETCH_BOT_USER_INFORMATION: 'Action'
    SLACK_FETCH_CONVERSATION_HISTORY: 'Action'
    SLACK_FETCH_CURRENT_TEAM_INFO_WITH_OPTIONAL_TEAM_SCOPE: 'Action'
    SLACK_FETCH_DND_STATUS_FOR_MULTIPLE_TEAM_MEMBERS: 'Action'
    SLACK_FETCH_ITEM_REACTIONS: 'Action'
    SLACK_FETCH_MESSAGE_THREAD_FROM_A_CONVERSATION: 'Action'
    SLACK_FETCH_WORKSPACE_SETTINGS_INFORMATION: 'Action'
    SLACK_FIND_USER_BY_EMAIL_ADDRESS: 'Action'
    SLACK_GET_BILLABLE_TEAM_USER_INFO: 'Action'
    SLACK_GET_CHANNEL_CONVERSATION_PREFERENCES: 'Action'
    SLACK_GET_CHANNEL_S_CONNECTED_WORKSPACES_IN_ENTERPRISE: 'Action'
    SLACK_GET_CURRENT_TEAM_INTEGRATION_LOGS: 'Action'
    SLACK_GET_CURRENT_TEAM_S_ACCESS_LOGS: 'Action'
    SLACK_GET_REMINDER_INFORMATION: 'Action'
    SLACK_GET_USER_PRESENCE_INFO: 'Action'
    SLACK_INDICATE_WORKFLOW_STEP_FAILURE: 'Action'
    SLACK_INITIATES_CHANNEL_BASED_CONVERSATIONS: 'Action'
    SLACK_INVALIDATE_A_USER_SESSION_BY_ID: 'Action'
    SLACK_INVITE_USERS_TO_A_SLACK_CHANNEL: 'Action'
    SLACK_INVITE_USER_TO_CHANNEL: 'Action'
    SLACK_INVITE_USER_TO_WORKSPACE_WITH_OPTIONAL_CHANNEL_INVITES: 'Action'
    SLACK_JOIN_AN_EXISTING_CONVERSATION: 'Action'
    SLACK_LEAVE_A_CONVERSATION: 'Action'
    SLACK_LISTS_PINNED_ITEMS_IN_A_CHANNEL: 'Action'
    SLACK_LISTS_USER_S_STARRED_ITEMS_WITH_PAGINATION: 'Action'
    SLACK_LIST_ACCESSIBLE_CONVERSATIONS_FOR_A_USER: 'Action'
    SLACK_LIST_ALL_SLACK_TEAM_CHANNELS_WITH_VARIOUS_FILTERS: 'Action'
    SLACK_LIST_ALL_SLACK_TEAM_USERS_WITH_PAGINATION: 'Action'
    SLACK_LIST_ALL_TEAMS_IN_AN_ENTERPRISE_ORGANIZATION: 'Action'
    SLACK_LIST_ALL_USERS_IN_A_USER_GROUP: 'Action'
    SLACK_LIST_APPROVED_APPS_FOR_ORG_OR_WORKSPACE: 'Action'
    SLACK_LIST_APPROVED_WORKSPACE_INVITE_REQUESTS: 'Action'
    SLACK_LIST_APP_PERMISSIONS_ON_A_TEAM: 'Action'
    SLACK_LIST_APP_PERMISSIONS_SCOPES_ON_A_TEAM: 'Action'
    SLACK_LIST_APP_RESOURCE_GRANTS_ON_A_TEAM: 'Action'
    SLACK_LIST_APP_USER_GRANTS_AND_SCOPES_ON_TEAM: 'Action'
    SLACK_LIST_DENIED_WORKSPACE_INVITE_REQUESTS: 'Action'
    SLACK_LIST_DISCONNECTED_CHANNELS_WITH_ORIGINAL_IDS_FOR_EKM: 'Action'
    SLACK_LIST_ENTERPRISE_GRID_ORGANIZATION_EMOJIS: 'Action'
    SLACK_LIST_EVENT_AUTHORIZATIONS_FOR_APPS: 'Action'
    SLACK_LIST_FILES_WITH_FILTERS_IN_SLACK: 'Action'
    SLACK_LIST_IDP_GROUPS_LINKED_TO_A_CHANNEL: 'Action'
    SLACK_LIST_ORG_LEVEL_IDP_GROUP_CHANNELS: 'Action'
    SLACK_LIST_PENDING_WORKSPACE_INVITE_REQUESTS: 'Action'
    SLACK_LIST_RESTRICTED_APPS_FOR_AN_ORG_OR_WORKSPACE: 'Action'
    SLACK_LIST_SCHEDULED_MESSAGES_IN_A_CHANNEL: 'Action'
    SLACK_LIST_SLACK_S_REMOTE_FILES_WITH_FILTERS: 'Action'
    SLACK_LIST_TEAM_CUSTOM_EMOJIS: 'Action'
    SLACK_LIST_TEAM_WORKSPACE_APP_REQUESTS: 'Action'
    SLACK_LIST_USER_GROUPS_FOR_TEAM_WITH_OPTIONS: 'Action'
    SLACK_LIST_USER_REACTIONS: 'Action'
    SLACK_LIST_USER_REMINDERS_WITH_DETAILS: 'Action'
    SLACK_LIST_WORKSPACE_ADMINS: 'Action'
    SLACK_LIST_WORKSPACE_OWNERS: 'Action'
    SLACK_LIST_WORKSPACE_USERS: 'Action'
    SLACK_MANUALLY_SET_USER_PRESENCE: 'Action'
    SLACK_MAP_USER_IDS_FOR_ENTERPRISE_GRID_WORKSPACES: 'Action'
    SLACK_MARK_A_USER_AS_ACTIVE_DEPRECATED: 'Action'
    SLACK_MARK_REMINDER_AS_COMPLETE: 'Action'
    SLACK_MARK_WORKFLOW_STEP_AS_COMPLETED: 'Action'
    SLACK_OPEN_A_VIEW_FOR_A_SLACK_USER: 'Action'
    SLACK_OPEN_OR_RESUME_DIRECT_OR_MULTI_PERSON_MESSAGES: 'Action'
    SLACK_OPEN_USER_DIALOG_WITH_JSON_DEFINED_UI: 'Action'
    SLACK_PINS_AN_ITEM_TO_A_CHANNEL: 'Action'
    SLACK_PROMOTE_USER_TO_ADMIN_STATUS: 'Action'
    SLACK_PROMOTE_USER_TO_WORKSPACE_OWNER: 'Action'
    SLACK_PUBLISH_STATIC_VIEW_FOR_USER: 'Action'
    SLACK_PUSH_VIEW_TO_ROOT_VIEW_STACK: 'Action'
    SLACK_REGISTERS_A_NEW_CALL_WITH_PARTICIPANTS: 'Action'
    SLACK_REGISTERS_NEW_CALL_PARTICIPANTS: 'Action'
    SLACK_REGISTER_CALL_PARTICIPANTS_REMOVAL: 'Action'
    SLACK_REMOVE_A_REMOTE_FILE: 'Action'
    SLACK_REMOVE_A_STAR_FROM_AN_ITEM: 'Action'
    SLACK_REMOVE_A_USER_FROM_A_CONVERSATION: 'Action'
    SLACK_REMOVE_CHANNELS_FROM_IDP_GROUP: 'Action'
    SLACK_REMOVE_ENTERPRISE_GRID_ORG_EMOJI: 'Action'
    SLACK_REMOVE_IDP_GROUP_FROM_PRIVATE_CHANNEL: 'Action'
    SLACK_REMOVE_REACTION_FROM_ITEM: 'Action'
    SLACK_REMOVE_USER_FROM_WORKSPACE: 'Action'
    SLACK_RENAME_AN_EMOJI: 'Action'
    SLACK_RENAME_A_CONVERSATION: 'Action'
    SLACK_RENAME_A_SLACK_CHANNEL: 'Action'
    SLACK_REQUEST_ADDITIONAL_APP_PERMISSIONS: 'Action'
    SLACK_RESTRICT_APP_INSTALLATION_ON_WORKSPACE: 'Action'
    SLACK_RETRIEVE_A_USER_S_IDENTITY_DETAILS: 'Action'
    SLACK_RETRIEVE_CALL_INFORMATION: 'Action'
    SLACK_RETRIEVE_CONVERSATION_INFORMATION: 'Action'
    SLACK_RETRIEVE_CONVERSATION_MEMBERS_LIST: 'Action'
    SLACK_RETRIEVE_CURRENT_USER_DND_STATUS: 'Action'
    SLACK_RETRIEVE_DETAILED_INFORMATION_ABOUT_A_FILE: 'Action'
    SLACK_RETRIEVE_DETAILED_USER_INFORMATION: 'Action'
    SLACK_RETRIEVE_MESSAGE_PERMALINK_URL: 'Action'
    SLACK_RETRIEVE_REMOTE_FILE_INFO_IN_SLACK: 'Action'
    SLACK_RETRIEVE_TEAM_PROFILE_DETAILS: 'Action'
    SLACK_RETRIEVE_USER_PROFILE_INFORMATION: 'Action'
    SLACK_REVERSE_A_CONVERSATION_S_ARCHIVAL_STATUS: 'Action'
    SLACK_REVOKES_A_TOKEN_WITH_OPTIONAL_TEST_MODE: 'Action'
    SLACK_REVOKE_PUBLIC_SHARING_ACCESS_FOR_A_FILE: 'Action'
    SLACK_SCHEDULES_A_MESSAGE_TO_A_CHANNEL_AT_A_SPECIFIED_TIME: 'Action'
    SLACK_SEARCH_CHANNELS_IN_AN_ENTERPRISE_ORGANIZATION: 'Action'
    SLACK_SEARCH_FOR_MESSAGES_WITH_QUERY: 'Action'
    SLACK_SENDS_A_MESSAGE_TO_A_SLACK_CHANNEL: 'Action'
    SLACK_SENDS_EPHEMERAL_MESSAGES_TO_CHANNEL_USERS: 'Action'
    SLACK_SET_A_CONVERSATION_S_PURPOSE: 'Action'
    SLACK_SET_CHANNEL_POSTING_PERMISSIONS: 'Action'
    SLACK_SET_EXPIRATION_FOR_A_GUEST_USER: 'Action'
    SLACK_SET_READ_CURSOR_IN_A_CONVERSATION: 'Action'
    SLACK_SET_SLACK_USER_PROFILE_INFORMATION: 'Action'
    SLACK_SET_THE_TOPIC_OF_A_CONVERSATION: 'Action'
    SLACK_SET_USER_PROFILE_PHOTO_WITH_CROPPING_OPTIONS: 'Action'
    SLACK_SET_USER_TO_REGULAR_STATUS: 'Action'
    SLACK_SET_WORKSPACE_CONNECTIONS_FOR_A_CHANNEL: 'Action'
    SLACK_SET_WORKSPACE_DEFAULT_CHANNELS: 'Action'
    SLACK_SET_WORKSPACE_DESCRIPTION: 'Action'
    SLACK_SET_WORKSPACE_DISCOVERABILITY_SETTINGS: 'Action'
    SLACK_SET_WORKSPACE_ICON: 'Action'
    SLACK_SET_WORKSPACE_NAME: 'Action'
    SLACK_SHARE_A_ME_MESSAGE_IN_A_CHANNEL: 'Action'
    SLACK_SHARE_REMOTE_FILE_IN_CHANNELS: 'Action'
    SLACK_START_REAL_TIME_MESSAGING_SESSION: 'Action'
    SLACK_TRIGGER_USER_PERMISSIONS_MODAL: 'Action'
    SLACK_UNARCHIVE_A_PUBLIC_OR_PRIVATE_CHANNEL: 'Action'
    SLACK_UNINSTALL_APP_FROM_WORKSPACE: 'Action'
    SLACK_UNPIN_ITEM_FROM_CHANNEL: 'Action'
    SLACK_UPDATES_AN_EXISTING_REMOTE_FILE: 'Action'
    SLACK_UPDATES_A_SLACK_MESSAGE: 'Action'
    SLACK_UPDATE_AN_EXISTING_SLACK_USER_GROUP: 'Action'
    SLACK_UPDATE_AN_EXISTING_SLACK_VIEW: 'Action'
    SLACK_UPDATE_SLACK_CALL_INFORMATION: 'Action'
    SLACK_UPDATE_USER_GROUP_MEMBERS: 'Action'
    SLACK_UPDATE_WORKFLOW_EXTENSION_STEP_CONFIGURATION: 'Action'
    SLACK_UPLOAD_OR_CREATE_A_FILE_IN_SLACK: 'Action'
    SLACK_WIPE_USER_SESSIONS_ACROSS_DEVICES: 'Action'
    SNOWFLAKE_DESCRIBE_TABLE: 'Action'
    SNOWFLAKE_EXPLORE_COLUMNS: 'Action'
    SNOWFLAKE_RUN_QUERY: 'Action'
    SNOWFLAKE_SHOW_TABLES: 'Action'
    SPIDERTOOL_CRAWL: 'Action'
    SPIDERTOOL_SCRAPE: 'Action'
    SQLTOOL_SQL_QUERY: 'Action'
    SUPABASE_ALPHA_CREATES_A_NEW_API_KEY_FOR_THE_PROJECT: 'Action'
    SUPABASE_ALPHA_DELETES_AN_API_KEY_FOR_THE_PROJECT: 'Action'
    SUPABASE_ALPHA_GET_A_THIRD_PARTY_INTEGRATION: 'Action'
    SUPABASE_ALPHA_LISTS_ALL_THIRD_PARTY_AUTH_INTEGRATIONS: 'Action'
    SUPABASE_ALPHA_REMOVES_A_THIRD_PARTY_AUTH_INTEGRATION: 'Action'
    SUPABASE_ALPHA_UPDATES_AN_API_KEY_FOR_THE_PROJECT: 'Action'
    SUPABASE_BETA_ACTIVATES_A_CUSTOM_HOSTNAME_FOR_A_PROJECT: 'Action'
    SUPABASE_BETA_ACTIVATES_A_VANITY_SUBDOMAIN_FOR_A_PROJECT: 'Action'
    SUPABASE_BETA_AUTHORIZE_USER_THROUGH_OAUTH: 'Action'
    SUPABASE_BETA_CHECKS_VANITY_SUBDOMAIN_AVAILABILITY: 'Action'
    SUPABASE_BETA_DELETES_A_PROJECT_S_CUSTOM_HOSTNAME_CONFIGURATION: 'Action'
    SUPABASE_BETA_DELETES_A_PROJECT_S_VANITY_SUBDOMAIN_CONFIGURATION: 'Action'
    SUPABASE_BETA_ENABLES_DATABASE_WEBHOOKS_ON_THE_PROJECT: 'Action'
    SUPABASE_BETA_EXCHANGE_AUTH_CODE_FOR_USER_S_ACCESS_AND_REFRESH_TOKEN: 'Action'
    SUPABASE_BETA_GETS_CURRENT_VANITY_SUBDOMAIN_CONFIG: 'Action'
    SUPABASE_BETA_GETS_PROJECT_S_CUSTOM_HOSTNAME_CONFIG: 'Action'
    SUPABASE_BETA_GETS_PROJECT_S_NETWORK_BANS: 'Action'
    SUPABASE_BETA_GETS_PROJECT_S_NETWORK_RESTRICTIONS: 'Action'
    SUPABASE_BETA_GETS_PROJECT_S_PGSODIUM_CONFIG: 'Action'
    SUPABASE_BETA_GETS_THE_LATEST_STATUS_OF_THE_PROJECT_S_UPGRADE: 'Action'
    SUPABASE_BETA_GET_PROJECT_S_SSL_ENFORCEMENT_CONFIGURATION: 'Action'
    SUPABASE_BETA_REMOVE_A_READ_REPLICA: 'Action'
    SUPABASE_BETA_REMOVE_NETWORK_BANS: 'Action'
    SUPABASE_BETA_RETURNS_THE_PROJECT_S_ELIGIBILITY_FOR_UPGRADES: 'Action'
    SUPABASE_BETA_RUN_SQL_QUERY: 'Action'
    SUPABASE_BETA_SET_UP_A_READ_REPLICA: 'Action'
    SUPABASE_BETA_UPDATES_PROJECT_S_CUSTOM_HOSTNAME_CONFIGURATION: 'Action'
    SUPABASE_BETA_UPDATES_PROJECT_S_NETWORK_RESTRICTIONS: 'Action'
    SUPABASE_BETA_UPDATE_PROJECT_S_SSL_ENFORCEMENT_CONFIGURATION: 'Action'
    SUPABASE_BETA_UPGRADES_THE_PROJECT_S_POSTGRES_VERSION: 'Action'
    SUPABASE_CONFIG_PGSODIUM_UPDATE_WITH_ROOT_KEY_WARNING: 'Action'
    SUPABASE_CREATES_A_NEW_SSO_PROVIDER: 'Action'
    SUPABASE_CREATES_A_NEW_THIRD_PARTY_AUTH_INTEGRATION: 'Action'
    SUPABASE_CREATE_AN_ORGANIZATION: 'Action'
    SUPABASE_CREATE_A_DATABASE_BRANCH: 'Action'
    SUPABASE_CREATE_A_FUNCTION: 'Action'
    SUPABASE_CREATE_A_PROJECT: 'Action'
    SUPABASE_CUSTOM_HOSTNAME_DNS_VERIFICATION: 'Action'
    SUPABASE_DELETES_THE_GIVEN_PROJECT: 'Action'
    SUPABASE_DELETE_A_DATABASE_BRANCH: 'Action'
    SUPABASE_DELETE_A_FUNCTION: 'Action'
    SUPABASE_DISABLES_PREVIEW_BRANCHING: 'Action'
    SUPABASE_DISABLES_PROJECT_S_READONLY_MODE_FOR_THE_NEXT_15_MINUTES: 'Action'
    SUPABASE_GENERATE_TYPE_SCRIPT_TYPES: 'Action'
    SUPABASE_GETS_A_SPECIFIC_SQL_SNIPPET: 'Action'
    SUPABASE_GETS_A_SSO_PROVIDER_BY_ITS_UUID: 'Action'
    SUPABASE_GETS_INFORMATION_ABOUT_THE_ORGANIZATION: 'Action'
    SUPABASE_GETS_PROJECT_S_AUTH_CONFIG: 'Action'
    SUPABASE_GETS_PROJECT_S_POSTGREST_CONFIG: 'Action'
    SUPABASE_GETS_PROJECT_S_POSTGRES_CONFIG: 'Action'
    SUPABASE_GETS_PROJECT_S_SERVICE_HEALTH_STATUS: 'Action'
    SUPABASE_GETS_PROJECT_S_SUPAVISOR_CONFIG: 'Action'
    SUPABASE_GET_DATABASE_BRANCH_CONFIG: 'Action'
    SUPABASE_GET_PROJECT_API_KEYS: 'Action'
    SUPABASE_GET_PROJECT_S_PGBOUNCER_CONFIG: 'Action'
    SUPABASE_LISTS_ALL_BACKUPS: 'Action'
    SUPABASE_LISTS_ALL_BUCKETS: 'Action'
    SUPABASE_LISTS_ALL_SSO_PROVIDERS: 'Action'
    SUPABASE_LISTS_SQL_SNIPPETS_FOR_THE_LOGGED_IN_USER: 'Action'
    SUPABASE_LIST_ALL_DATABASE_BRANCHES: 'Action'
    SUPABASE_LIST_ALL_FUNCTIONS: 'Action'
    SUPABASE_LIST_ALL_ORGANIZATIONS: 'Action'
    SUPABASE_LIST_ALL_PROJECTS: 'Action'
    SUPABASE_LIST_ALL_SECRETS: 'Action'
    SUPABASE_LIST_MEMBERS_OF_AN_ORGANIZATION: 'Action'
    SUPABASE_REMOVES_A_SSO_PROVIDER_BY_ITS_UUID: 'Action'
    SUPABASE_RESETS_A_DATABASE_BRANCH: 'Action'
    SUPABASE_RESTORES_A_PITR_BACKUP_FOR_A_DATABASE: 'Action'
    SUPABASE_RETRIEVE_A_FUNCTION: 'Action'
    SUPABASE_RETRIEVE_A_FUNCTION_BODY: 'Action'
    SUPABASE_RETURNS_PROJECT_S_READONLY_MODE_STATUS: 'Action'
    SUPABASE_UPDATES_A_SSO_PROVIDER_BY_ITS_UUID: 'Action'
    SUPABASE_UPDATES_PROJECT_S_POSTGREST_CONFIG: 'Action'
    SUPABASE_UPDATES_PROJECT_S_POSTGRES_CONFIG: 'Action'
    SUPABASE_UPDATES_PROJECT_S_SUPAVISOR_CONFIG: 'Action'
    SUPABASE_UPDATE_A_FUNCTION: 'Action'
    SUPABASE_UPDATE_DATABASE_BRANCH_CONFIG: 'Action'
    TAVILY_TAVILY_SEARCH: 'Action'
    TRELLO_ACTION_GET_BY_ID: 'Action'
    TRELLO_ACTION_GET_LIST_BY_ID_ACTION: 'Action'
    TRELLO_ADD_BOARDS: 'Action'
    TRELLO_ADD_BOARDS_CALENDAR_KEY_GENERATE_BY_ID_BOARD: 'Action'
    TRELLO_ADD_BOARDS_CHECKLISTS_BY_ID_BOARD: 'Action'
    TRELLO_ADD_BOARDS_EMAIL_KEY_GENERATE_BY_ID_BOARD: 'Action'
    TRELLO_ADD_BOARDS_LABELS_BY_ID_BOARD: 'Action'
    TRELLO_ADD_BOARDS_LISTS_BY_ID_BOARD: 'Action'
    TRELLO_ADD_BOARDS_MARK_AS_VIEWED_BY_ID_BOARD: 'Action'
    TRELLO_ADD_BOARDS_POWER_UPS_BY_ID_BOARD: 'Action'
    TRELLO_ADD_CARDS: 'Action'
    TRELLO_ADD_CARDS_ACTIONS_COMMENTS_BY_ID_CARD: 'Action'
    TRELLO_ADD_CARDS_ATTACHMENTS_BY_ID_CARD: 'Action'
    TRELLO_ADD_CARDS_CHECKLISTS_BY_ID_CARD: 'Action'
    TRELLO_ADD_CARDS_CHECKLIST_CHECK_ITEM_BY_ID_CARD_BY_ID_CHECKLIST: 'Action'
    TRELLO_ADD_CARDS_ID_LABELS_BY_ID_CARD: 'Action'
    TRELLO_ADD_CARDS_ID_MEMBERS_BY_ID_CARD: 'Action'
    TRELLO_ADD_CARDS_LABELS_BY_ID_CARD: 'Action'
    TRELLO_ADD_CARDS_MARK_ASSOCIATED_NOTIFICATIONS_READ_BY_ID_CARD: 'Action'
    TRELLO_ADD_CARDS_MEMBERS_VOTED_BY_ID_CARD: 'Action'
    TRELLO_ADD_CARDS_STICKERS_BY_ID_CARD: 'Action'
    TRELLO_ADD_CHECKLISTS: 'Action'
    TRELLO_ADD_CHECKLISTS_CHECK_ITEMS_BY_ID_CHECKLIST: 'Action'
    TRELLO_ADD_LABELS: 'Action'
    TRELLO_ADD_LISTS: 'Action'
    TRELLO_ADD_LISTS_ARCHIVE_ALL_CARDS_BY_ID_LIST: 'Action'
    TRELLO_ADD_LISTS_CARDS_BY_ID_LIST: 'Action'
    TRELLO_ADD_LISTS_MOVE_ALL_CARDS_BY_ID_LIST: 'Action'
    TRELLO_ADD_MEMBERS_AVATAR_BY_ID_MEMBER: 'Action'
    TRELLO_ADD_MEMBERS_BOARD_BACKGROUNDS_BY_ID_MEMBER: 'Action'
    TRELLO_ADD_MEMBERS_BOARD_STARS_BY_ID_MEMBER: 'Action'
    TRELLO_ADD_MEMBERS_CUSTOM_BOARD_BACKGROUNDS_BY_ID_MEMBER: 'Action'
    TRELLO_ADD_MEMBERS_CUSTOM_EMOJI_BY_ID_MEMBER: 'Action'
    TRELLO_ADD_MEMBERS_CUSTOM_STICKERS_BY_ID_MEMBER: 'Action'
    TRELLO_ADD_MEMBERS_ONE_TIME_MESSAGES_DISMISSED_BY_ID_MEMBER: 'Action'
    TRELLO_ADD_MEMBERS_SAVED_SEARCHES_BY_ID_MEMBER: 'Action'
    TRELLO_ADD_NOTIFICATIONS_ALL_READ: 'Action'
    TRELLO_ADD_ORGANIZATIONS: 'Action'
    TRELLO_ADD_ORGANIZATIONS_LOGO_BY_ID_ORG: 'Action'
    TRELLO_ADD_SESSIONS: 'Action'
    TRELLO_ADD_TOKENS_WEBHOOKS_BY_TOKEN: 'Action'
    TRELLO_BOARD_GET_LISTS_BY_ID_BOARD: 'Action'
    TRELLO_CARD_GET_BY_ID: 'Action'
    TRELLO_CARD_UPDATE_ID_LIST_BY_ID_CARD: 'Action'
    TRELLO_CARD_UPDATE_POS_BY_ID_CARD: 'Action'
    TRELLO_CONVERT_CHECKLIST_ITEM_TO_CARD: 'Action'
    TRELLO_DELETE_ACTIONS_BY_ID_ACTION: 'Action'
    TRELLO_DELETE_BOARDS_MEMBERS_BY_ID_BOARD_BY_ID_MEMBER: 'Action'
    TRELLO_DELETE_BOARDS_POWER_UPS_BY_ID_BOARD_BY_POWER_UP: 'Action'
    TRELLO_DELETE_CARDS_ACTIONS_COMMENTS_BY_ID_CARD_BY_ID_ACTION: 'Action'
    TRELLO_DELETE_CARDS_ATTACHMENTS_BY_ID_CARD_BY_ID_ATTACHMENT: 'Action'
    TRELLO_DELETE_CARDS_BY_ID_CARD: 'Action'
    TRELLO_DELETE_CARDS_CHECKLISTS_BY_ID_CARD_BY_ID_CHECKLIST: 'Action'
    TRELLO_DELETE_CARDS_ID_LABELS_BY_ID_CARD_BY_ID_LABEL: 'Action'
    TRELLO_DELETE_CARDS_ID_MEMBERS_BY_ID_CARD_BY_ID_MEMBER: 'Action'
    TRELLO_DELETE_CARDS_LABELS_BY_ID_CARD_BY_COLOR: 'Action'
    TRELLO_DELETE_CARDS_MEMBERS_VOTED_BY_ID_CARD_BY_ID_MEMBER: 'Action'
    TRELLO_DELETE_CARDS_STICKERS_BY_ID_CARD_BY_ID_STICKER: 'Action'
    TRELLO_DELETE_CHECKLISTS_BY_ID_CHECKLIST: 'Action'
    TRELLO_DELETE_CHECKLISTS_CHECK_ITEMS_BY_ID_CHECKLIST_BY_ID_CHECK_ITEM: 'Action'
    TRELLO_DELETE_LABELS_BY_ID_LABEL: 'Action'
    TRELLO_DELETE_MEMBERS_BOARD_BACKGROUNDS_BY_ID_MEMBER_BY_ID_BOARD_BACKGROUND: 'Action'
    TRELLO_DELETE_MEMBERS_BOARD_STARS_BY_ID_MEMBER_BY_ID_BOARD_STAR: 'Action'
    TRELLO_DELETE_MEMBERS_CUSTOM_STICKERS_BY_ID_MEMBER_BY_ID_CUSTOM_STICKER: 'Action'
    TRELLO_DELETE_MEMBERS_SAVED_SEARCHES_BY_ID_MEMBER_BY_ID_SAVED_SEARCH: 'Action'
    TRELLO_DELETE_ORGANIZATIONS_BY_ID_ORG: 'Action'
    TRELLO_DELETE_ORGANIZATIONS_LOGO_BY_ID_ORG: 'Action'
    TRELLO_DELETE_ORGANIZATIONS_MEMBERS_ALL_BY_ID_ORG_BY_ID_MEMBER: 'Action'
    TRELLO_DELETE_ORGANIZATIONS_MEMBERS_BY_ID_ORG_BY_ID_MEMBER: 'Action'
    TRELLO_DELETE_ORGANIZATIONS_PREFS_ASSOCIATED_DOMAIN_BY_ID_ORG: 'Action'
    TRELLO_DELETE_ORGANIZATIONS_PREFS_ORG_INVITE_RESTRICT_BY_ID_ORG: 'Action'
    TRELLO_DELETE_TOKENS_BY_TOKEN: 'Action'
    TRELLO_DELETE_TOKENS_WEBHOOKS_BY_TOKEN_BY_ID_WEBHOOK: 'Action'
    TRELLO_DELETE_WEBHOOKS_BY_ID_WEBHOOK: 'Action'
    TRELLO_GET_ACTIONS_BOARD_BY_ID_ACTION: 'Action'
    TRELLO_GET_ACTIONS_BOARD_BY_ID_ACTION_BY_FIELD: 'Action'
    TRELLO_GET_ACTIONS_BY_ID_ACTION: 'Action'
    TRELLO_GET_ACTIONS_BY_ID_ACTION_BY_FIELD: 'Action'
    TRELLO_GET_ACTIONS_CARD_BY_ID_ACTION: 'Action'
    TRELLO_GET_ACTIONS_CARD_BY_ID_ACTION_BY_FIELD: 'Action'
    TRELLO_GET_ACTIONS_DISPLAY_BY_ID_ACTION: 'Action'
    TRELLO_GET_ACTIONS_ENTITIES_BY_ID_ACTION: 'Action'
    TRELLO_GET_ACTIONS_LIST_BY_ID_ACTION: 'Action'
    TRELLO_GET_ACTIONS_LIST_BY_ID_ACTION_BY_FIELD: 'Action'
    TRELLO_GET_ACTIONS_MEMBER_BY_ID_ACTION: 'Action'
    TRELLO_GET_ACTIONS_MEMBER_BY_ID_ACTION_BY_FIELD: 'Action'
    TRELLO_GET_ACTIONS_MEMBER_CREATOR_BY_ID_ACTION: 'Action'
    TRELLO_GET_ACTIONS_MEMBER_CREATOR_BY_ID_ACTION_BY_FIELD: 'Action'
    TRELLO_GET_ACTIONS_ORGANIZATION_BY_ID_ACTION: 'Action'
    TRELLO_GET_ACTIONS_ORGANIZATION_BY_ID_ACTION_BY_FIELD: 'Action'
    TRELLO_GET_BATCH: 'Action'
    TRELLO_GET_BOARDS_ACTIONS_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_BOARD_STARS_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_BY_ID_BOARD_BY_FIELD: 'Action'
    TRELLO_GET_BOARDS_CARDS_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_CARDS_BY_ID_BOARD_BY_FILTER: 'Action'
    TRELLO_GET_BOARDS_CARDS_BY_ID_BOARD_BY_ID_CARD: 'Action'
    TRELLO_GET_BOARDS_CHECKLISTS_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_DELTAS_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_LABELS_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_LABELS_BY_ID_BOARD_BY_ID_LABEL: 'Action'
    TRELLO_GET_BOARDS_LISTS_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_LISTS_BY_ID_BOARD_BY_FILTER: 'Action'
    TRELLO_GET_BOARDS_MEMBERSHIPS_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_MEMBERSHIPS_BY_ID_BOARD_BY_ID_MEMBERSHIP: 'Action'
    TRELLO_GET_BOARDS_MEMBERS_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_MEMBERS_BY_ID_BOARD_BY_FILTER: 'Action'
    TRELLO_GET_BOARDS_MEMBERS_CARDS_BY_ID_BOARD_BY_ID_MEMBER: 'Action'
    TRELLO_GET_BOARDS_MEMBERS_INVITED_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_MEMBERS_INVITED_BY_ID_BOARD_BY_FIELD: 'Action'
    TRELLO_GET_BOARDS_MY_PREFS_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_ORGANIZATION_BY_ID_BOARD: 'Action'
    TRELLO_GET_BOARDS_ORGANIZATION_BY_ID_BOARD_BY_FIELD: 'Action'
    TRELLO_GET_CARDS_ACTIONS_BY_ID_CARD: 'Action'
    TRELLO_GET_CARDS_ATTACHMENTS_BY_ID_CARD: 'Action'
    TRELLO_GET_CARDS_ATTACHMENTS_BY_ID_CARD_BY_ID_ATTACHMENT: 'Action'
    TRELLO_GET_CARDS_BOARD_BY_ID_CARD: 'Action'
    TRELLO_GET_CARDS_BOARD_BY_ID_CARD_BY_FIELD: 'Action'
    TRELLO_GET_CARDS_BY_ID_CARD: 'Action'
    TRELLO_GET_CARDS_BY_ID_CARD_BY_FIELD: 'Action'
    TRELLO_GET_CARDS_CHECKLISTS_BY_ID_CARD: 'Action'
    TRELLO_GET_CARDS_CHECK_ITEM_STATES_BY_ID_CARD: 'Action'
    TRELLO_GET_CARDS_LIST_BY_ID_CARD: 'Action'
    TRELLO_GET_CARDS_LIST_BY_ID_CARD_BY_FIELD: 'Action'
    TRELLO_GET_CARDS_MEMBERS_BY_ID_CARD: 'Action'
    TRELLO_GET_CARDS_MEMBERS_VOTED_BY_ID_CARD: 'Action'
    TRELLO_GET_CARDS_STICKERS_BY_ID_CARD: 'Action'
    TRELLO_GET_CARDS_STICKERS_BY_ID_CARD_BY_ID_STICKER: 'Action'
    TRELLO_GET_CHECKLISTS_BOARD_BY_ID_CHECKLIST: 'Action'
    TRELLO_GET_CHECKLISTS_BOARD_BY_ID_CHECKLIST_BY_FIELD: 'Action'
    TRELLO_GET_CHECKLISTS_BY_ID_CHECKLIST: 'Action'
    TRELLO_GET_CHECKLISTS_BY_ID_CHECKLIST_BY_FIELD: 'Action'
    TRELLO_GET_CHECKLISTS_CARDS_BY_ID_CHECKLIST: 'Action'
    TRELLO_GET_CHECKLISTS_CARDS_BY_ID_CHECKLIST_BY_FILTER: 'Action'
    TRELLO_GET_CHECKLISTS_CHECK_ITEMS_BY_ID_CHECKLIST: 'Action'
    TRELLO_GET_CHECKLISTS_CHECK_ITEMS_BY_ID_CHECKLIST_BY_ID_CHECK_ITEM: 'Action'
    TRELLO_GET_LABELS_BOARD_BY_ID_LABEL: 'Action'
    TRELLO_GET_LABELS_BOARD_BY_ID_LABEL_BY_FIELD: 'Action'
    TRELLO_GET_LABELS_BY_ID_LABEL: 'Action'
    TRELLO_GET_LISTS_ACTIONS_BY_ID_LIST: 'Action'
    TRELLO_GET_LISTS_BOARD_BY_ID_LIST: 'Action'
    TRELLO_GET_LISTS_BOARD_BY_ID_LIST_BY_FIELD: 'Action'
    TRELLO_GET_LISTS_BY_ID_LIST: 'Action'
    TRELLO_GET_LISTS_BY_ID_LIST_BY_FIELD: 'Action'
    TRELLO_GET_LISTS_CARDS_BY_ID_LIST: 'Action'
    TRELLO_GET_LISTS_CARDS_BY_ID_LIST_BY_FILTER: 'Action'
    TRELLO_GET_MEMBERS_ACTIONS_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_BOARDS_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_BOARDS_BY_ID_MEMBER_BY_FILTER: 'Action'
    TRELLO_GET_MEMBERS_BOARDS_INVITED_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_BOARDS_INVITED_BY_ID_MEMBER_BY_FIELD: 'Action'
    TRELLO_GET_MEMBERS_BOARD_BACKGROUNDS_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_BOARD_BACKGROUNDS_BY_ID_MEMBER_BY_ID_BOARD_BACKGROUND: 'Action'
    TRELLO_GET_MEMBERS_BOARD_STARS_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_BOARD_STARS_BY_ID_MEMBER_BY_ID_BOARD_STAR: 'Action'
    TRELLO_GET_MEMBERS_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_BY_ID_MEMBER_BY_FIELD: 'Action'
    TRELLO_GET_MEMBERS_CARDS_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_CARDS_BY_ID_MEMBER_BY_FILTER: 'Action'
    TRELLO_GET_MEMBERS_CUSTOM_BOARD_BACKGROUNDS_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_CUSTOM_BOARD_BACKGROUNDS_BY_ID_MEMBER_BY_ID_BOARD_BACKGROUND: 'Action'
    TRELLO_GET_MEMBERS_CUSTOM_EMOJI_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_CUSTOM_EMOJI_BY_ID_MEMBER_BY_ID_CUSTOM_EMOJI: 'Action'
    TRELLO_GET_MEMBERS_CUSTOM_STICKERS_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_CUSTOM_STICKERS_BY_ID_MEMBER_BY_ID_CUSTOM_STICKER: 'Action'
    TRELLO_GET_MEMBERS_DELTAS_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_NOTIFICATIONS_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_NOTIFICATIONS_BY_ID_MEMBER_BY_FILTER: 'Action'
    TRELLO_GET_MEMBERS_ORGANIZATIONS_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_ORGANIZATIONS_BY_ID_MEMBER_BY_FILTER: 'Action'
    TRELLO_GET_MEMBERS_ORGANIZATIONS_INVITED_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_ORGANIZATIONS_INVITED_BY_ID_MEMBER_BY_FIELD: 'Action'
    TRELLO_GET_MEMBERS_SAVED_SEARCHES_BY_ID_MEMBER: 'Action'
    TRELLO_GET_MEMBERS_SAVED_SEARCHES_BY_ID_MEMBER_BY_ID_SAVED_SEARCH: 'Action'
    TRELLO_GET_MEMBERS_TOKENS_BY_ID_MEMBER: 'Action'
    TRELLO_GET_NOTIFICATIONS_BOARD_BY_ID_NOTIFICATION: 'Action'
    TRELLO_GET_NOTIFICATIONS_BOARD_BY_ID_NOTIFICATION_BY_FIELD: 'Action'
    TRELLO_GET_NOTIFICATIONS_BY_ID_NOTIFICATION: 'Action'
    TRELLO_GET_NOTIFICATIONS_BY_ID_NOTIFICATION_BY_FIELD: 'Action'
    TRELLO_GET_NOTIFICATIONS_CARD_BY_ID_NOTIFICATION: 'Action'
    TRELLO_GET_NOTIFICATIONS_CARD_BY_ID_NOTIFICATION_BY_FIELD: 'Action'
    TRELLO_GET_NOTIFICATIONS_DISPLAY_BY_ID_NOTIFICATION: 'Action'
    TRELLO_GET_NOTIFICATIONS_ENTITIES_BY_ID_NOTIFICATION: 'Action'
    TRELLO_GET_NOTIFICATIONS_LIST_BY_ID_NOTIFICATION: 'Action'
    TRELLO_GET_NOTIFICATIONS_LIST_BY_ID_NOTIFICATION_BY_FIELD: 'Action'
    TRELLO_GET_NOTIFICATIONS_MEMBER_BY_ID_NOTIFICATION: 'Action'
    TRELLO_GET_NOTIFICATIONS_MEMBER_BY_ID_NOTIFICATION_BY_FIELD: 'Action'
    TRELLO_GET_NOTIFICATIONS_MEMBER_CREATOR_BY_ID_NOTIFICATION: 'Action'
    TRELLO_GET_NOTIFICATIONS_MEMBER_CREATOR_BY_ID_NOTIFICATION_BY_FIELD: 'Action'
    TRELLO_GET_NOTIFICATIONS_ORGANIZATION_BY_ID_NOTIFICATION: 'Action'
    TRELLO_GET_NOTIFICATIONS_ORGANIZATION_BY_ID_NOTIFICATION_BY_FIELD: 'Action'
    TRELLO_GET_ORGANIZATIONS_ACTIONS_BY_ID_ORG: 'Action'
    TRELLO_GET_ORGANIZATIONS_BOARDS_BY_ID_ORG: 'Action'
    TRELLO_GET_ORGANIZATIONS_BOARDS_BY_ID_ORG_BY_FILTER: 'Action'
    TRELLO_GET_ORGANIZATIONS_BY_ID_ORG: 'Action'
    TRELLO_GET_ORGANIZATIONS_BY_ID_ORG_BY_FIELD: 'Action'
    TRELLO_GET_ORGANIZATIONS_DELTAS_BY_ID_ORG: 'Action'
    TRELLO_GET_ORGANIZATIONS_MEMBERSHIPS_BY_ID_ORG: 'Action'
    TRELLO_GET_ORGANIZATIONS_MEMBERSHIPS_BY_ID_ORG_BY_ID_MEMBERSHIP: 'Action'
    TRELLO_GET_ORGANIZATIONS_MEMBERS_BY_ID_ORG: 'Action'
    TRELLO_GET_ORGANIZATIONS_MEMBERS_BY_ID_ORG_BY_FILTER: 'Action'
    TRELLO_GET_ORGANIZATIONS_MEMBERS_CARDS_BY_ID_ORG_BY_ID_MEMBER: 'Action'
    TRELLO_GET_ORGANIZATIONS_MEMBERS_INVITED_BY_ID_ORG: 'Action'
    TRELLO_GET_ORGANIZATIONS_MEMBERS_INVITED_BY_ID_ORG_BY_FIELD: 'Action'
    TRELLO_GET_SEARCH: 'Action'
    TRELLO_GET_SEARCH_MEMBERS: 'Action'
    TRELLO_GET_SESSIONS_SOCKET: 'Action'
    TRELLO_GET_TOKENS_BY_TOKEN: 'Action'
    TRELLO_GET_TOKENS_BY_TOKEN_BY_FIELD: 'Action'
    TRELLO_GET_TOKENS_MEMBER_BY_TOKEN: 'Action'
    TRELLO_GET_TOKENS_MEMBER_BY_TOKEN_BY_FIELD: 'Action'
    TRELLO_GET_TOKENS_WEBHOOKS_BY_TOKEN: 'Action'
    TRELLO_GET_TOKENS_WEBHOOKS_BY_TOKEN_BY_ID_WEBHOOK: 'Action'
    TRELLO_GET_TYPES_BY_ID: 'Action'
    TRELLO_GET_WEBHOOKS_BY_ID_WEBHOOK: 'Action'
    TRELLO_GET_WEBHOOKS_BY_ID_WEBHOOK_BY_FIELD: 'Action'
    TRELLO_LIST_GET_BY_ID_LIST: 'Action'
    TRELLO_LIST_ID_BOARD_GET: 'Action'
    TRELLO_MEMBER_GET_BOARDS_BY_ID_MEMBER: 'Action'
    TRELLO_MEMBER_GET_BY_ID: 'Action'
    TRELLO_REMOVE_CHECKLIST_ITEM_FROM_CARD_BY_IDS: 'Action'
    TRELLO_REMOVE_SPECIFIC_MEMBER_S_BOARD_BACKGROUNDS: 'Action'
    TRELLO_SEARCH_GET_RESULTS: 'Action'
    TRELLO_UPDATE_ACTIONS_BY_ID_ACTION: 'Action'
    TRELLO_UPDATE_ACTIONS_TEXT_BY_ID_ACTION: 'Action'
    TRELLO_UPDATE_BOARDS_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_CLOSED_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_DESC_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_ID_ORGANIZATION_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_LABEL_NAMES_BLUE_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_LABEL_NAMES_GREEN_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_LABEL_NAMES_ORANGE_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_LABEL_NAMES_PURPLE_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_LABEL_NAMES_RED_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_LABEL_NAMES_YELLOW_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_MEMBERSHIPS_BY_ID_BOARD_BY_ID_MEMBERSHIP: 'Action'
    TRELLO_UPDATE_BOARDS_MEMBERS_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_MEMBERS_BY_ID_BOARD_BY_ID_MEMBER: 'Action'
    TRELLO_UPDATE_BOARDS_MY_PREFS_EMAIL_POSITION_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_MY_PREFS_ID_EMAIL_LIST_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_MY_PREFS_SHOW_LIST_GUIDE_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_MY_PREFS_SHOW_SIDEBAR_ACTIVITY_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_MY_PREFS_SHOW_SIDEBAR_BOARD_ACTIONS_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_MY_PREFS_SHOW_SIDEBAR_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_MY_PREFS_SHOW_SIDEBAR_MEMBERS_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_NAME_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_PREFS_BACKGROUND_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_PREFS_CALENDAR_FEED_ENABLED_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_PREFS_CARD_AGING_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_PREFS_CARD_COVERS_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_PREFS_COMMENTS_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_PREFS_INVITATIONS_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_PREFS_PERMISSION_LEVEL_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_PREFS_SELF_JOIN_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_PREFS_VOTING_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_BOARDS_SUBSCRIBED_BY_ID_BOARD: 'Action'
    TRELLO_UPDATE_CARDS_ACTIONS_COMMENTS_BY_ID_CARD_BY_ID_ACTION: 'Action'
    TRELLO_UPDATE_CARDS_BY_ID_CARD: 'Action'
    TRELLO_UPDATE_CARDS_CLOSED_BY_ID_CARD: 'Action'
    TRELLO_UPDATE_CARDS_DESC_BY_ID_CARD: 'Action'
    TRELLO_UPDATE_CARDS_DUE_BY_ID_CARD: 'Action'
    TRELLO_UPDATE_CARDS_ID_ATTACHMENT_COVER_BY_ID_CARD: 'Action'
    TRELLO_UPDATE_CARDS_ID_BOARD_BY_ID_CARD: 'Action'
    TRELLO_UPDATE_CARDS_ID_LIST_BY_ID_CARD: 'Action'
    TRELLO_UPDATE_CARDS_ID_MEMBERS_BY_ID_CARD: 'Action'
    TRELLO_UPDATE_CARDS_LABELS_BY_ID_CARD: 'Action'
    TRELLO_UPDATE_CARDS_NAME_BY_ID_CARD: 'Action'
    TRELLO_UPDATE_CARDS_POS_BY_ID_CARD: 'Action'
    TRELLO_UPDATE_CARDS_STICKERS_BY_ID_CARD_BY_ID_STICKER: 'Action'
    TRELLO_UPDATE_CARDS_SUBSCRIBED_BY_ID_CARD: 'Action'
    TRELLO_UPDATE_CARD_CHECKLIST_ITEM_POSITION: 'Action'
    TRELLO_UPDATE_CARD_CHECKLIST_ITEM_STATE_BY_IDS: 'Action'
    TRELLO_UPDATE_CHECKLISTS_BY_ID_CHECKLIST: 'Action'
    TRELLO_UPDATE_CHECKLISTS_ID_CARD_BY_ID_CHECKLIST: 'Action'
    TRELLO_UPDATE_CHECKLISTS_NAME_BY_ID_CHECKLIST: 'Action'
    TRELLO_UPDATE_CHECKLISTS_POS_BY_ID_CHECKLIST: 'Action'
    TRELLO_UPDATE_CHECKLIST_ITEM_BY_IDS: 'Action'
    TRELLO_UPDATE_CHECKLIST_ITEM_NAME_IN_CARD: 'Action'
    TRELLO_UPDATE_LABELS_BY_ID_LABEL: 'Action'
    TRELLO_UPDATE_LABELS_COLOR_BY_ID_LABEL: 'Action'
    TRELLO_UPDATE_LABELS_NAME_BY_ID_LABEL: 'Action'
    TRELLO_UPDATE_LISTS_BY_ID_LIST: 'Action'
    TRELLO_UPDATE_LISTS_CLOSED_BY_ID_LIST: 'Action'
    TRELLO_UPDATE_LISTS_ID_BOARD_BY_ID_LIST: 'Action'
    TRELLO_UPDATE_LISTS_NAME_BY_ID_LIST: 'Action'
    TRELLO_UPDATE_LISTS_POS_BY_ID_LIST: 'Action'
    TRELLO_UPDATE_LISTS_SUBSCRIBED_BY_ID_LIST: 'Action'
    TRELLO_UPDATE_MEMBERS_AVATAR_SOURCE_BY_ID_MEMBER: 'Action'
    TRELLO_UPDATE_MEMBERS_BIO_BY_ID_MEMBER: 'Action'
    TRELLO_UPDATE_MEMBERS_BOARD_BACKGROUNDS_BY_ID_MEMBER_BY_ID_BOARD_BACKGROUND: 'Action'
    TRELLO_UPDATE_MEMBERS_BOARD_STARS_BY_ID_MEMBER_BY_ID_BOARD_STAR: 'Action'
    TRELLO_UPDATE_MEMBERS_BOARD_STARS_ID_BOARD_BY_ID_MEMBER_BY_ID_BOARD_STAR: 'Action'
    TRELLO_UPDATE_MEMBERS_BOARD_STARS_POS_BY_ID_MEMBER_BY_ID_BOARD_STAR: 'Action'
    TRELLO_UPDATE_MEMBERS_BY_ID_MEMBER: 'Action'
    TRELLO_UPDATE_MEMBERS_FULL_NAME_BY_ID_MEMBER: 'Action'
    TRELLO_UPDATE_MEMBERS_INITIALS_BY_ID_MEMBER: 'Action'
    TRELLO_UPDATE_MEMBERS_PREFS_COLOR_BLIND_BY_ID_MEMBER: 'Action'
    TRELLO_UPDATE_MEMBERS_PREFS_LOCALE_BY_ID_MEMBER: 'Action'
    TRELLO_UPDATE_MEMBERS_PREFS_MINUTES_BETWEEN_SUMMARIES_BY_ID_MEMBER: 'Action'
    TRELLO_UPDATE_MEMBERS_SAVED_SEARCHES_BY_ID_MEMBER_BY_ID_SAVED_SEARCH: 'Action'
    TRELLO_UPDATE_MEMBERS_SAVED_SEARCHES_NAME_BY_ID_MEMBER_BY_ID_SAVED_SEARCH: 'Action'
    TRELLO_UPDATE_MEMBERS_SAVED_SEARCHES_POS_BY_ID_MEMBER_BY_ID_SAVED_SEARCH: 'Action'
    TRELLO_UPDATE_MEMBERS_SAVED_SEARCHES_QUERY_BY_ID_MEMBER_BY_ID_SAVED_SEARCH: 'Action'
    TRELLO_UPDATE_MEMBERS_USERNAME_BY_ID_MEMBER: 'Action'
    TRELLO_UPDATE_MEMBER_S_CUSTOM_BOARD_BACKGROUNDS: 'Action'
    TRELLO_UPDATE_NOTIFICATIONS_BY_ID_NOTIFICATION: 'Action'
    TRELLO_UPDATE_NOTIFICATIONS_UNREAD_BY_ID_NOTIFICATION: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_DESC_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_DISPLAY_NAME_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_MEMBERSHIPS_BY_ID_ORG_BY_ID_MEMBERSHIP: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_MEMBERS_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_MEMBERS_BY_ID_ORG_BY_ID_MEMBER: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_MEMBERS_DEACTIVATED_BY_ID_ORG_BY_ID_MEMBER: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_NAME_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_PREFS_ASSOCIATED_DOMAIN_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_PREFS_BOARD_VISIBILITY_RESTRICT_ORG_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_PREFS_BOARD_VISIBILITY_RESTRICT_PRIVATE_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_PREFS_BOARD_VISIBILITY_RESTRICT_PUBLIC_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_PREFS_EXTERNAL_MEMBERS_DISABLED_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_PREFS_GOOGLE_APPS_VERSION_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_PREFS_ORG_INVITE_RESTRICT_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_PREFS_PERMISSION_LEVEL_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_ORGANIZATIONS_WEBSITE_BY_ID_ORG: 'Action'
    TRELLO_UPDATE_SESSIONS_BY_ID_SESSION: 'Action'
    TRELLO_UPDATE_SESSIONS_STATUS_BY_ID_SESSION: 'Action'
    TRELLO_UPDATE_TOKENS_WEBHOOKS_BY_TOKEN: 'Action'
    TRELLO_UPDATE_WEBHOOKS: 'Action'
    TRELLO_UPDATE_WEBHOOKS_ACTIVE_BY_ID_WEBHOOK: 'Action'
    TRELLO_UPDATE_WEBHOOKS_BY_ID_WEBHOOK: 'Action'
    TRELLO_UPDATE_WEBHOOKS_CALLBACK_URLBY_ID_WEBHOOK: 'Action'
    TRELLO_UPDATE_WEBHOOKS_DESCRIPTION_BY_ID_WEBHOOK: 'Action'
    TRELLO_UPDATE_WEBHOOKS_ID_MODEL_BY_ID_WEBHOOK: 'Action'
    TWITTER_ADD_A_LIST_MEMBER: 'Action'
    TWITTER_ADD_POST_TO_BOOKMARKS: 'Action'
    TWITTER_BOOKMARKS_BY_USER: 'Action'
    TWITTER_CAUSES_THE_USER_IN_THE_PATH_TO_LIKE_THE_SPECIFIED_POST: 'Action'
    TWITTER_CAUSES_THE_USER_IN_THE_PATH_TO_REPOST_THE_SPECIFIED_POST: 'Action'
    TWITTER_CAUSES_THE_USER_IN_THE_PATH_TO_UNLIKE_THE_SPECIFIED_POST: 'Action'
    TWITTER_CAUSES_THE_USER_IN_THE_PATH_TO_UNRETWEET_THE_SPECIFIED_POST: 'Action'
    TWITTER_CREATE_A_NEW_DM_CONVERSATION: 'Action'
    TWITTER_CREATE_COMPLIANCE_JOB: 'Action'
    TWITTER_CREATE_LIST: 'Action'
    TWITTER_CREATION_OF_A_POST: 'Action'
    TWITTER_DELETE_DM: 'Action'
    TWITTER_DELETE_LIST: 'Action'
    TWITTER_FETCH_LIST_MEMBERS_BY_ID: 'Action'
    TWITTER_FETCH_SPACE_TICKET_BUYERS_LIST: 'Action'
    TWITTER_FOLLOWERS_BY_USER_ID: 'Action'
    TWITTER_FOLLOWING_BY_USER_ID: 'Action'
    TWITTER_FOLLOW_A_LIST: 'Action'
    TWITTER_FOLLOW_USER: 'Action'
    TWITTER_FULL_ARCHIVE_SEARCH: 'Action'
    TWITTER_FULL_ARCHIVE_SEARCH_COUNTS: 'Action'
    TWITTER_GET_A_USER_S_LIST_MEMBERSHIPS: 'Action'
    TWITTER_GET_A_USER_S_OWNED_LISTS: 'Action'
    TWITTER_GET_A_USER_S_PINNED_LISTS: 'Action'
    TWITTER_GET_COMPLIANCE_JOB: 'Action'
    TWITTER_GET_DM_EVENTS_BY_ID: 'Action'
    TWITTER_GET_DM_EVENTS_FOR_A_DM_CONVERSATION: 'Action'
    TWITTER_GET_RECENT_DM_EVENTS: 'Action'
    TWITTER_GET_USER_S_FOLLOWED_LISTS: 'Action'
    TWITTER_HIDE_REPLIES: 'Action'
    TWITTER_LIST_COMPLIANCE_JOBS: 'Action'
    TWITTER_LIST_LOOKUP_BY_LIST_ID: 'Action'
    TWITTER_LIST_POSTS_TIMELINE_BY_LIST_ID: 'Action'
    TWITTER_MUTE_USER_BY_USER_ID: 'Action'
    TWITTER_PIN_A_LIST: 'Action'
    TWITTER_POSTS_LABEL_STREAM: 'Action'
    TWITTER_POST_DELETE_BY_POST_ID: 'Action'
    TWITTER_POST_LOOKUP_BY_POST_ID: 'Action'
    TWITTER_POST_LOOKUP_BY_POST_IDS: 'Action'
    TWITTER_POST_USAGE: 'Action'
    TWITTER_RECENT_SEARCH: 'Action'
    TWITTER_RECENT_SEARCH_COUNTS: 'Action'
    TWITTER_REMOVE_A_BOOKMARKED_POST: 'Action'
    TWITTER_REMOVE_A_LIST_MEMBER: 'Action'
    TWITTER_RETRIEVE_DM_CONVERSATION_EVENTS: 'Action'
    TWITTER_RETRIEVE_POSTS_FROM_A_SPACE: 'Action'
    TWITTER_RETRIEVE_POSTS_THAT_QUOTE_A_POST: 'Action'
    TWITTER_RETRIEVE_POSTS_THAT_REPOST_A_POST: 'Action'
    TWITTER_RETURNS_POST_OBJECTS_LIKED_BY_THE_PROVIDED_USER_ID: 'Action'
    TWITTER_RETURNS_THE_OPEN_API_SPECIFICATION_DOCUMENT: 'Action'
    TWITTER_RETURNS_USER_OBJECTS_THAT_ARE_BLOCKED_BY_PROVIDED_USER_ID: 'Action'
    TWITTER_RETURNS_USER_OBJECTS_THAT_ARE_MUTED_BY_THE_PROVIDED_USER_ID: 'Action'
    TWITTER_RETURNS_USER_OBJECTS_THAT_FOLLOW_A_LIST_BY_THE_PROVIDED_LIST_ID: 'Action'
    TWITTER_RETURNS_USER_OBJECTS_THAT_HAVE_LIKED_THE_PROVIDED_POST_ID: 'Action'
    TWITTER_RETURNS_USER_OBJECTS_THAT_HAVE_RETWEETED_THE_PROVIDED_POST_ID: 'Action'
    TWITTER_SEARCH_FOR_SPACES: 'Action'
    TWITTER_SEND_A_NEW_MESSAGE_TO_A_DM_CONVERSATION: 'Action'
    TWITTER_SEND_A_NEW_MESSAGE_TO_A_USER: 'Action'
    TWITTER_SPACE_LOOKUP_BY_SPACE_ID: 'Action'
    TWITTER_SPACE_LOOKUP_BY_THEIR_CREATORS: 'Action'
    TWITTER_SPACE_LOOKUP_UP_SPACE_IDS: 'Action'
    TWITTER_UNFOLLOW_A_LIST: 'Action'
    TWITTER_UNFOLLOW_USER: 'Action'
    TWITTER_UNMUTE_USER_BY_USER_ID: 'Action'
    TWITTER_UNPIN_A_LIST: 'Action'
    TWITTER_UPDATE_LIST: 'Action'
    TWITTER_USER_HOME_TIMELINE_BY_USER_ID: 'Action'
    TWITTER_USER_LOOKUP_BY_ID: 'Action'
    TWITTER_USER_LOOKUP_BY_IDS: 'Action'
    TWITTER_USER_LOOKUP_BY_USERNAME: 'Action'
    TWITTER_USER_LOOKUP_BY_USERNAMES: 'Action'
    TWITTER_USER_LOOKUP_ME: 'Action'
    WEATHERMAP_WEATHER: 'Action'
    WEBTOOL_SCRAPE_WEBSITE_CONTENT: 'Action'
    WEBTOOL_SCRAPE_WEBSITE_ELEMENT: 'Action'
    WORKSPACE_TOOL_WORKSPACE_STATUS_ACTION: 'Action'
    YOUSEARCH_YOU_SEARCH: 'Action'
    YOUTUBE_LIST_CAPTION_TRACK: 'Action'
    YOUTUBE_LIST_CHANNEL_VIDEOS: 'Action'
    YOUTUBE_LIST_USER_PLAYLISTS: 'Action'
    YOUTUBE_LIST_USER_SUBSCRIPTIONS: 'Action'
    YOUTUBE_LOAD_CAPTIONS: 'Action'
    YOUTUBE_SEARCH_YOU_TUBE: 'Action'
    YOUTUBE_SUBSCRIBE_CHANNEL: 'Action'
    YOUTUBE_UPDATE_THUMBNAIL: 'Action'
    YOUTUBE_UPDATE_VIDEO: 'Action'
    YOUTUBE_VIDEO_DETAILS: 'Action'
    ZENDESK_COUNT_ZENDESK_ORGANIZATIONS: 'Action'
    ZENDESK_CREATE_ZENDESK_ORGANIZATION: 'Action'
    ZENDESK_CREATE_ZENDESK_TICKET: 'Action'
    ZENDESK_DELETE_ZENDESK_ORGANIZATION: 'Action'
    ZENDESK_DELETE_ZENDESK_TICKET: 'Action'
    ZENDESK_GET_ABOUT_ME: 'Action'
    ZENDESK_GET_ALL_ZENDESK_ORGANIZATIONS: 'Action'
    ZENDESK_GET_ZENDESK_ORGANIZATION: 'Action'
    ZENDESK_UPDATE_ZENDESK_ORGANIZATION: 'Action'
    ZEPTOOL_ADD_MEMORY: 'Action'
    ZEPTOOL_CREATE_SESSION: 'Action'
    ZEPTOOL_GET_MEMORY: 'Action'
    ZEPTOOL_SEARCH_MEMORY: 'Action'

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_CREATE_TASK_ATTACHMENT instead.')
    def CLICKUP_ATTACHMENTS_UPLOAD_FILE_TO_TASK_AS_ATTACHMENT(cls) -> 'Action':
        return cls.CLICKUP_CREATE_TASK_ATTACHMENT

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_GET_ACCESS_TOKEN instead.')
    def CLICKUP_AUTHORIZATION_GET_ACCESS_TOKEN(cls) -> 'Action':
        return cls.CLICKUP_GET_ACCESS_TOKEN

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_CREATE_FOLDER instead.')
    def CLICKUP_FOLDERS_CREATE_NEW_FOLDER(cls) -> 'Action':
        return cls.CLICKUP_CREATE_FOLDER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_GET_FOLDERS instead.')
    def CLICKUP_FOLDERS_GET_CONTENTS_OF(cls) -> 'Action':
        return cls.CLICKUP_GET_FOLDERS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_GET_FOLDER instead.')
    def CLICKUP_FOLDERS_GET_FOLDER_CONTENT(cls) -> 'Action':
        return cls.CLICKUP_GET_FOLDER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_GET_LISTS instead.')
    def CLICKUP_LISTS_GET_FOLDER_LISTS(cls) -> 'Action':
        return cls.CLICKUP_GET_LISTS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_GET_LIST_MEMBERS instead.')
    def CLICKUP_MEMBERS_GET_LIST_USERS(cls) -> 'Action':
        return cls.CLICKUP_GET_LIST_MEMBERS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_GET_SPACE instead.')
    def CLICKUP_SPACES_GET_DETAILS(cls) -> 'Action':
        return cls.CLICKUP_GET_SPACE

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_GET_SPACES instead.')
    def CLICKUP_SPACES_GET_SPACE_DETAILS(cls) -> 'Action':
        return cls.CLICKUP_GET_SPACES

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_GET_TASKS instead.')
    def CLICKUP_TASKS_GET_LIST_TASKS(cls) -> 'Action':
        return cls.CLICKUP_GET_TASKS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_CREATE_CHECKLIST instead.')
    def CLICKUP_TASK_CHECKLISTS_CREATE_NEW_CHECKLIST(cls) -> 'Action':
        return cls.CLICKUP_CREATE_CHECKLIST

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_CREATE_TEAM instead.')
    def CLICKUP_TEAMS_USER_GROUPS_CREATE_TEAM(cls) -> 'Action':
        return cls.CLICKUP_CREATE_TEAM

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use CLICKUP_GET_SPACE_VIEWS instead.')
    def CLICKUP_VIEWS_SPACE_VIEWS_GET(cls) -> 'Action':
        return cls.CLICKUP_GET_SPACE_VIEWS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use DISCORD_CREATE_GUILD instead.')
    def DISCORD_CREATEGUILD(cls) -> 'Action':
        return cls.DISCORD_CREATE_GUILD

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use DISCORD_GET_MESSAGE instead.')
    def DISCORD_GETMESSAGE(cls) -> 'Action':
        return cls.DISCORD_GET_MESSAGE

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use DISCORD_GET_MY_APPLICATION instead.')
    def DISCORD_GETMYAPPLICATION(cls) -> 'Action':
        return cls.DISCORD_GET_MY_APPLICATION

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use DISCORD_GET_MY_USER instead.')
    def DISCORD_GETMYUSER(cls) -> 'Action':
        return cls.DISCORD_GET_MY_USER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use ELEVENLABS_DUB_A_VIDEO_OR_AN_AUDIO_FILE instead.')
    def ELEVENLABS_DUB_A_VIDEO_OR_AN_AUDIOFILE_V_1_DUBBING_POST(cls) -> 'Action':
        return cls.ELEVENLABS_DUB_A_VIDEO_OR_AN_AUDIO_FILE

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use ELEVENLABS_GET_MODELS instead.')
    def ELEVENLABS_GET_MODELS_V_1_MODELS_GET(cls) -> 'Action':
        return cls.ELEVENLABS_GET_MODELS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use ELEVENLABS_GET_USER_INFO instead.')
    def ELEVENLABS_GET_USER_INFO_V_1_USER_GET(cls) -> 'Action':
        return cls.ELEVENLABS_GET_USER_INFO

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use ELEVENLABS_GET_VOICES instead.')
    def ELEVENLABS_GET_VOICES_V_1_VOICES_GET(cls) -> 'Action':
        return cls.ELEVENLABS_GET_VOICES

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_REPOSITORIES_STARRED_BY_THE_AUTHENTICATED_USER instead.')
    def GITHUB_ACTIVITY_LIST_REPO_S_STARRED_BY_AUTHENTICATED_USER(cls) -> 'Action':
        return cls.GITHUB_LIST_REPOSITORIES_STARRED_BY_THE_AUTHENTICATED_USER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_STAR_A_REPOSITORY_FOR_THE_AUTHENTICATED_USER instead.')
    def GITHUB_ACTIVITY_STAR_REPO_FOR_AUTHENTICATED_USER(cls) -> 'Action':
        return cls.GITHUB_STAR_A_REPOSITORY_FOR_THE_AUTHENTICATED_USER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_GET_EMOJIS instead.')
    def GITHUB_EMO_J_IS_GET(cls) -> 'Action':
        return cls.GITHUB_GET_EMOJIS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_CREATE_A_GIST instead.')
    def GITHUB_GIST_S_CREATE(cls) -> 'Action':
        return cls.GITHUB_CREATE_A_GIST

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_PUBLIC_GISTS instead.')
    def GITHUB_GIST_S_LIST_PUBLIC(cls) -> 'Action':
        return cls.GITHUB_LIST_PUBLIC_GISTS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_CREATE_AN_ISSUE instead.')
    def GITHUB_ISSUES_CREATE(cls) -> 'Action':
        return cls.GITHUB_CREATE_AN_ISSUE

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_CREATE_AN_ISSUE_COMMENT instead.')
    def GITHUB_ISSUES_CREATE_COMMENT(cls) -> 'Action':
        return cls.GITHUB_CREATE_AN_ISSUE_COMMENT

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_GET_AN_ISSUE instead.')
    def GITHUB_ISSUES_GET(cls) -> 'Action':
        return cls.GITHUB_GET_AN_ISSUE

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_ISSUES_ASSIGNED_TO_THE_AUTHENTICATED_USER instead.')
    def GITHUB_ISSUES_LIST(cls) -> 'Action':
        return cls.GITHUB_LIST_ISSUES_ASSIGNED_TO_THE_AUTHENTICATED_USER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_ASSIGNEES instead.')
    def GITHUB_ISSUES_LIST_ASSIGN_EES(cls) -> 'Action':
        return cls.GITHUB_LIST_ASSIGNEES

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_ISSUE_EVENTS_FOR_A_REPOSITORY instead.')
    def GITHUB_ISSUES_LIST_EVENTS_FOR_REPO(cls) -> 'Action':
        return cls.GITHUB_LIST_ISSUE_EVENTS_FOR_A_REPOSITORY

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_CHECK_IF_A_PULL_REQUEST_HAS_BEEN_MERGED instead.')
    def GITHUB_PULLS_CHECK_IF_MERGED(cls) -> 'Action':
        return cls.GITHUB_CHECK_IF_A_PULL_REQUEST_HAS_BEEN_MERGED

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_GET_A_PULL_REQUEST instead.')
    def GITHUB_PULLS_GET(cls) -> 'Action':
        return cls.GITHUB_GET_A_PULL_REQUEST

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_CREATE_A_FORK instead.')
    def GITHUB_REPO_S_CREATE_FORK(cls) -> 'Action':
        return cls.GITHUB_CREATE_A_FORK

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_CREATE_AN_ORGANIZATION_REPOSITORY instead.')
    def GITHUB_REPO_S_CREATE_IN_ORG(cls) -> 'Action':
        return cls.GITHUB_CREATE_AN_ORGANIZATION_REPOSITORY

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_CREATE_OR_UPDATE_FILE_CONTENTS instead.')
    def GITHUB_REPO_S_CREATE_OR_UPDATE_FILE_CONTENTS(cls) -> 'Action':
        return cls.GITHUB_CREATE_OR_UPDATE_FILE_CONTENTS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_GET_THE_WEEKLY_COMMIT_ACTIVITY instead.')
    def GITHUB_REPO_S_GET_CODE_FREQUENCY_STATS(cls) -> 'Action':
        return cls.GITHUB_GET_THE_WEEKLY_COMMIT_ACTIVITY

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_GET_ALL_CONTRIBUTOR_COMMIT_ACTIVITY instead.')
    def GITHUB_REPO_S_GET_CONTRIBUTORS_STATS(cls) -> 'Action':
        return cls.GITHUB_GET_ALL_CONTRIBUTOR_COMMIT_ACTIVITY

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_BRANCHES instead.')
    def GITHUB_REPO_S_LIST_BRANCHES(cls) -> 'Action':
        return cls.GITHUB_LIST_BRANCHES

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_REPOSITORY_COLLABORATORS instead.')
    def GITHUB_REPO_S_LIST_COLLABORATORS(cls) -> 'Action':
        return cls.GITHUB_LIST_REPOSITORY_COLLABORATORS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_COMMITS instead.')
    def GITHUB_REPO_S_LIST_COMMITS(cls) -> 'Action':
        return cls.GITHUB_LIST_COMMITS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_REPOSITORY_CONTRIBUTORS instead.')
    def GITHUB_REPO_S_LIST_CONTRIBUTORS(cls) -> 'Action':
        return cls.GITHUB_LIST_REPOSITORY_CONTRIBUTORS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_REPOSITORIES_FOR_THE_AUTHENTICATED_USER instead.')
    def GITHUB_REPO_S_LIST_FOR_AUTHENTICATED_USER(cls) -> 'Action':
        return cls.GITHUB_LIST_REPOSITORIES_FOR_THE_AUTHENTICATED_USER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_REPOSITORIES_FOR_A_USER instead.')
    def GITHUB_REPO_S_LIST_FOR_USER(cls) -> 'Action':
        return cls.GITHUB_LIST_REPOSITORIES_FOR_A_USER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_GLOBAL_SECURITY_ADVISORIES instead.')
    def GITHUB_SECURITY_ADVISORIES_LIST_GLOBAL_ADVISORIES(cls) -> 'Action':
        return cls.GITHUB_LIST_GLOBAL_SECURITY_ADVISORIES

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_GET_CONTEXTUAL_INFORMATION_FOR_A_USER instead.')
    def GITHUB_USERS_GET_CONTEXT_FOR_USER(cls) -> 'Action':
        return cls.GITHUB_GET_CONTEXTUAL_INFORMATION_FOR_A_USER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_EMAIL_ADDRESSES_FOR_THE_AUTHENTICATED_USER instead.')
    def GITHUB_USERS_LIST_EMAILS_FOR_AUTHENTICATED_USER(cls) -> 'Action':
        return cls.GITHUB_LIST_EMAIL_ADDRESSES_FOR_THE_AUTHENTICATED_USER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use GITHUB_LIST_FOLLOWERS_OF_THE_AUTHENTICATED_USER instead.')
    def GITHUB_USERS_LIST_FOLLOWERS_FOR_AUTHENTICATED_USER(cls) -> 'Action':
        return cls.GITHUB_LIST_FOLLOWERS_OF_THE_AUTHENTICATED_USER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use SLACK_LIST_APP_PERMISSIONS_ON_A_TEAM instead.')
    def SLACK_APPS_PERMISSIONS_LIST_PERMISSIONS(cls) -> 'Action':
        return cls.SLACK_LIST_APP_PERMISSIONS_ON_A_TEAM

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use SLACK_LIST_APP_PERMISSIONS_SCOPES_ON_A_TEAM instead.')
    def SLACK_APPS_PERMISSIONS_SCOPES_GET_LIST(cls) -> 'Action':
        return cls.SLACK_LIST_APP_PERMISSIONS_SCOPES_ON_A_TEAM

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use SLACK_SENDS_A_MESSAGE_TO_A_SLACK_CHANNEL instead.')
    def SLACK_CHAT_POST_MESSAGE(cls) -> 'Action':
        return cls.SLACK_SENDS_A_MESSAGE_TO_A_SLACK_CHANNEL

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use SLACK_RETRIEVE_CONVERSATION_INFORMATION instead.')
    def SLACK_CONVERSATIONS_INFO(cls) -> 'Action':
        return cls.SLACK_RETRIEVE_CONVERSATION_INFORMATION

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use SLACK_LIST_ALL_SLACK_TEAM_CHANNELS_WITH_VARIOUS_FILTERS instead.')
    def SLACK_CONVERSATIONS_LIST(cls) -> 'Action':
        return cls.SLACK_LIST_ALL_SLACK_TEAM_CHANNELS_WITH_VARIOUS_FILTERS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use SLACK_CREATE_A_REMINDER instead.')
    def SLACK_REMINDERS_ADD(cls) -> 'Action':
        return cls.SLACK_CREATE_A_REMINDER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use SLACK_SEARCH_FOR_MESSAGES_WITH_QUERY instead.')
    def SLACK_SEARCH_MESSAGES(cls) -> 'Action':
        return cls.SLACK_SEARCH_FOR_MESSAGES_WITH_QUERY

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use SLACK_RETRIEVE_DETAILED_USER_INFORMATION instead.')
    def SLACK_USERS_INFO(cls) -> 'Action':
        return cls.SLACK_RETRIEVE_DETAILED_USER_INFORMATION

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use SLACK_LIST_ALL_SLACK_TEAM_USERS_WITH_PAGINATION instead.')
    def SLACK_USERS_LIST(cls) -> 'Action':
        return cls.SLACK_LIST_ALL_SLACK_TEAM_USERS_WITH_PAGINATION

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use SLACK_FIND_USER_BY_EMAIL_ADDRESS instead.')
    def SLACK_USERS_LOOKUP_BY_EMAIL(cls) -> 'Action':
        return cls.SLACK_FIND_USER_BY_EMAIL_ADDRESS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use SLACK_RETRIEVE_USER_PROFILE_INFORMATION instead.')
    def SLACK_USERS_PROFILE_GET_PROFILE_INFO(cls) -> 'Action':
        return cls.SLACK_RETRIEVE_USER_PROFILE_INFORMATION

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use TRELLO_GET_ACTIONS_BOARD_BY_ID_ACTION instead.')
    def TRELLO_ACTION_GET_BOARD_BY_ID_ACTION(cls) -> 'Action':
        return cls.TRELLO_GET_ACTIONS_BOARD_BY_ID_ACTION

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use TRELLO_ADD_BOARDS instead.')
    def TRELLO_BOARD_CREATE_BOARD(cls) -> 'Action':
        return cls.TRELLO_ADD_BOARDS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use TRELLO_GET_BOARDS_CARDS_BY_ID_BOARD_BY_FILTER instead.')
    def TRELLO_BOARD_FILTER_CARDS_BY_ID_BOARD(cls) -> 'Action':
        return cls.TRELLO_GET_BOARDS_CARDS_BY_ID_BOARD_BY_FILTER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use TRELLO_GET_BOARDS_BY_ID_BOARD instead.')
    def TRELLO_BOARD_GET_BY_ID(cls) -> 'Action':
        return cls.TRELLO_GET_BOARDS_BY_ID_BOARD

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use TRELLO_GET_BOARDS_CARDS_BY_ID_BOARD instead.')
    def TRELLO_BOARD_GET_CARDS_BY_ID_BOARD(cls) -> 'Action':
        return cls.TRELLO_GET_BOARDS_CARDS_BY_ID_BOARD

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use TRELLO_ADD_CARDS instead.')
    def TRELLO_CARD_CREATE_AND_UPDATE(cls) -> 'Action':
        return cls.TRELLO_ADD_CARDS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use TRELLO_GET_CARDS_BY_ID_CARD_BY_FIELD instead.')
    def TRELLO_CARD_GET_BY_ID_FIELD(cls) -> 'Action':
        return cls.TRELLO_GET_CARDS_BY_ID_CARD_BY_FIELD

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use TRELLO_UPDATE_CARDS_BY_ID_CARD instead.')
    def TRELLO_CARD_UPDATE_BY_ID_CARD(cls) -> 'Action':
        return cls.TRELLO_UPDATE_CARDS_BY_ID_CARD

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use TRELLO_ADD_LISTS instead.')
    def TRELLO_LIST_CREATE_LIST(cls) -> 'Action':
        return cls.TRELLO_ADD_LISTS

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use TRELLO_GET_LISTS_CARDS_BY_ID_LIST instead.')
    def TRELLO_LIST_GET_CARDS_BY_ID_LIST(cls) -> 'Action':
        return cls.TRELLO_GET_LISTS_CARDS_BY_ID_LIST

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use TRELLO_GET_MEMBERS_BOARDS_BY_ID_MEMBER_BY_FILTER instead.')
    def TRELLO_MEMBER_GET_BOARDS(cls) -> 'Action':
        return cls.TRELLO_GET_MEMBERS_BOARDS_BY_ID_MEMBER_BY_FILTER

    @classmethod  # type: ignore
    @property
    @te.deprecated('Use TRELLO_GET_TOKENS_MEMBER_BY_TOKEN instead.')
    def TRELLO_TOKEN_GET_MEMBER_BY_TOKEN(cls) -> 'Action':
        return cls.TRELLO_GET_TOKENS_MEMBER_BY_TOKEN
    _deprecated: t.Dict = {'CLICKUP_ATTACHMENTS_UPLOAD_FILE_TO_TASK_AS_ATTACHMENT': 'CLICKUP_CREATE_TASK_ATTACHMENT', 'CLICKUP_AUTHORIZATION_GET_ACCESS_TOKEN': 'CLICKUP_GET_ACCESS_TOKEN', 'CLICKUP_FOLDERS_CREATE_NEW_FOLDER': 'CLICKUP_CREATE_FOLDER', 'CLICKUP_FOLDERS_GET_CONTENTS_OF': 'CLICKUP_GET_FOLDERS', 'CLICKUP_FOLDERS_GET_FOLDER_CONTENT': 'CLICKUP_GET_FOLDER', 'CLICKUP_LISTS_GET_FOLDER_LISTS': 'CLICKUP_GET_LISTS', 'CLICKUP_MEMBERS_GET_LIST_USERS': 'CLICKUP_GET_LIST_MEMBERS', 'CLICKUP_SPACES_GET_DETAILS': 'CLICKUP_GET_SPACE', 'CLICKUP_SPACES_GET_SPACE_DETAILS': 'CLICKUP_GET_SPACES', 'CLICKUP_TASKS_GET_LIST_TASKS': 'CLICKUP_GET_TASKS', 'CLICKUP_TASK_CHECKLISTS_CREATE_NEW_CHECKLIST': 'CLICKUP_CREATE_CHECKLIST', 'CLICKUP_TEAMS_USER_GROUPS_CREATE_TEAM': 'CLICKUP_CREATE_TEAM', 'CLICKUP_VIEWS_SPACE_VIEWS_GET': 'CLICKUP_GET_SPACE_VIEWS', 'DISCORD_CREATEGUILD': 'DISCORD_CREATE_GUILD', 'DISCORD_GETMESSAGE': 'DISCORD_GET_MESSAGE', 'DISCORD_GETMYAPPLICATION': 'DISCORD_GET_MY_APPLICATION', 'DISCORD_GETMYUSER': 'DISCORD_GET_MY_USER', 'ELEVENLABS_DUB_A_VIDEO_OR_AN_AUDIOFILE_V_1_DUBBING_POST': 'ELEVENLABS_DUB_A_VIDEO_OR_AN_AUDIO_FILE', 'ELEVENLABS_GET_MODELS_V_1_MODELS_GET': 'ELEVENLABS_GET_MODELS', 'ELEVENLABS_GET_USER_INFO_V_1_USER_GET': 'ELEVENLABS_GET_USER_INFO', 'ELEVENLABS_GET_VOICES_V_1_VOICES_GET': 'ELEVENLABS_GET_VOICES', 'GITHUB_ACTIVITY_LIST_REPO_S_STARRED_BY_AUTHENTICATED_USER': 'GITHUB_LIST_REPOSITORIES_STARRED_BY_THE_AUTHENTICATED_USER', 'GITHUB_ACTIVITY_STAR_REPO_FOR_AUTHENTICATED_USER': 'GITHUB_STAR_A_REPOSITORY_FOR_THE_AUTHENTICATED_USER', 'GITHUB_EMO_J_IS_GET': 'GITHUB_GET_EMOJIS', 'GITHUB_GIST_S_CREATE': 'GITHUB_CREATE_A_GIST', 'GITHUB_GIST_S_LIST_PUBLIC': 'GITHUB_LIST_PUBLIC_GISTS', 'GITHUB_ISSUES_CREATE': 'GITHUB_CREATE_AN_ISSUE', 'GITHUB_ISSUES_CREATE_COMMENT': 'GITHUB_CREATE_AN_ISSUE_COMMENT', 'GITHUB_ISSUES_GET': 'GITHUB_GET_AN_ISSUE', 'GITHUB_ISSUES_LIST': 'GITHUB_LIST_ISSUES_ASSIGNED_TO_THE_AUTHENTICATED_USER', 'GITHUB_ISSUES_LIST_ASSIGN_EES': 'GITHUB_LIST_ASSIGNEES', 'GITHUB_ISSUES_LIST_EVENTS_FOR_REPO': 'GITHUB_LIST_ISSUE_EVENTS_FOR_A_REPOSITORY', 'GITHUB_PULLS_CHECK_IF_MERGED': 'GITHUB_CHECK_IF_A_PULL_REQUEST_HAS_BEEN_MERGED', 'GITHUB_PULLS_GET': 'GITHUB_GET_A_PULL_REQUEST', 'GITHUB_REPO_S_CREATE_FORK': 'GITHUB_CREATE_A_FORK', 'GITHUB_REPO_S_CREATE_IN_ORG': 'GITHUB_CREATE_AN_ORGANIZATION_REPOSITORY', 'GITHUB_REPO_S_CREATE_OR_UPDATE_FILE_CONTENTS': 'GITHUB_CREATE_OR_UPDATE_FILE_CONTENTS', 'GITHUB_REPO_S_GET_CODE_FREQUENCY_STATS': 'GITHUB_GET_THE_WEEKLY_COMMIT_ACTIVITY', 'GITHUB_REPO_S_GET_CONTRIBUTORS_STATS': 'GITHUB_GET_ALL_CONTRIBUTOR_COMMIT_ACTIVITY', 'GITHUB_REPO_S_LIST_BRANCHES': 'GITHUB_LIST_BRANCHES', 'GITHUB_REPO_S_LIST_COLLABORATORS': 'GITHUB_LIST_REPOSITORY_COLLABORATORS', 'GITHUB_REPO_S_LIST_COMMITS': 'GITHUB_LIST_COMMITS', 'GITHUB_REPO_S_LIST_CONTRIBUTORS': 'GITHUB_LIST_REPOSITORY_CONTRIBUTORS', 'GITHUB_REPO_S_LIST_FOR_AUTHENTICATED_USER': 'GITHUB_LIST_REPOSITORIES_FOR_THE_AUTHENTICATED_USER', 'GITHUB_REPO_S_LIST_FOR_USER': 'GITHUB_LIST_REPOSITORIES_FOR_A_USER', 'GITHUB_SECURITY_ADVISORIES_LIST_GLOBAL_ADVISORIES': 'GITHUB_LIST_GLOBAL_SECURITY_ADVISORIES', 'GITHUB_USERS_GET_CONTEXT_FOR_USER': 'GITHUB_GET_CONTEXTUAL_INFORMATION_FOR_A_USER', 'GITHUB_USERS_LIST_EMAILS_FOR_AUTHENTICATED_USER': 'GITHUB_LIST_EMAIL_ADDRESSES_FOR_THE_AUTHENTICATED_USER', 'GITHUB_USERS_LIST_FOLLOWERS_FOR_AUTHENTICATED_USER': 'GITHUB_LIST_FOLLOWERS_OF_THE_AUTHENTICATED_USER', 'SLACK_APPS_PERMISSIONS_LIST_PERMISSIONS': 'SLACK_LIST_APP_PERMISSIONS_ON_A_TEAM', 'SLACK_APPS_PERMISSIONS_SCOPES_GET_LIST': 'SLACK_LIST_APP_PERMISSIONS_SCOPES_ON_A_TEAM', 'SLACK_CHAT_POST_MESSAGE': 'SLACK_SENDS_A_MESSAGE_TO_A_SLACK_CHANNEL', 'SLACK_CONVERSATIONS_INFO': 'SLACK_RETRIEVE_CONVERSATION_INFORMATION', 'SLACK_CONVERSATIONS_LIST': 'SLACK_LIST_ALL_SLACK_TEAM_CHANNELS_WITH_VARIOUS_FILTERS', 'SLACK_REMINDERS_ADD': 'SLACK_CREATE_A_REMINDER', 'SLACK_SEARCH_MESSAGES': 'SLACK_SEARCH_FOR_MESSAGES_WITH_QUERY', 'SLACK_USERS_INFO': 'SLACK_RETRIEVE_DETAILED_USER_INFORMATION', 'SLACK_USERS_LIST': 'SLACK_LIST_ALL_SLACK_TEAM_USERS_WITH_PAGINATION', 'SLACK_USERS_LOOKUP_BY_EMAIL': 'SLACK_FIND_USER_BY_EMAIL_ADDRESS', 'SLACK_USERS_PROFILE_GET_PROFILE_INFO': 'SLACK_RETRIEVE_USER_PROFILE_INFORMATION', 'TRELLO_ACTION_GET_BOARD_BY_ID_ACTION': 'TRELLO_GET_ACTIONS_BOARD_BY_ID_ACTION', 'TRELLO_BOARD_CREATE_BOARD': 'TRELLO_ADD_BOARDS', 'TRELLO_BOARD_FILTER_CARDS_BY_ID_BOARD': 'TRELLO_GET_BOARDS_CARDS_BY_ID_BOARD_BY_FILTER', 'TRELLO_BOARD_GET_BY_ID': 'TRELLO_GET_BOARDS_BY_ID_BOARD', 'TRELLO_BOARD_GET_CARDS_BY_ID_BOARD': 'TRELLO_GET_BOARDS_CARDS_BY_ID_BOARD', 'TRELLO_CARD_CREATE_AND_UPDATE': 'TRELLO_ADD_CARDS', 'TRELLO_CARD_GET_BY_ID_FIELD': 'TRELLO_GET_CARDS_BY_ID_CARD_BY_FIELD', 'TRELLO_CARD_UPDATE_BY_ID_CARD': 'TRELLO_UPDATE_CARDS_BY_ID_CARD', 'TRELLO_LIST_CREATE_LIST': 'TRELLO_ADD_LISTS', 'TRELLO_LIST_GET_CARDS_BY_ID_LIST': 'TRELLO_GET_LISTS_CARDS_BY_ID_LIST', 'TRELLO_MEMBER_GET_BOARDS': 'TRELLO_GET_MEMBERS_BOARDS_BY_ID_MEMBER_BY_FILTER', 'TRELLO_TOKEN_GET_MEMBER_BY_TOKEN': 'TRELLO_GET_TOKENS_MEMBER_BY_TOKEN'}

    @property
    def name(self) -> str:
        """Action name."""
        return self.load().name

    @property
    def app(self) -> str:
        """App name where the actions belongs to."""
        return self.load().app

    @property
    def tags(self) -> t.List[str]:
        """List of tags for action."""
        return self.load().tags

    @property
    def no_auth(self) -> bool:
        """If set `True` the action does not require authentication."""
        return self.load().no_auth

    @property
    def is_local(self) -> bool:
        """If set `True` the `app` is a local app."""
        return self.load().is_local

    @property
    def is_runtime(self) -> bool:
        """If set `True` the `app` is a runtime app."""
        return self.load().is_runtime