from PyQt6.QtCore import QTranslator, QLocale, QLibraryInfo
from PyQt6.QtWidgets import QApplication
from .gui.MainWindow import MainWindow
from .Environment import Environment
import sys
import os


def main() -> None:
    app = QApplication(sys.argv)

    env = Environment(app)

    app.setDesktopFileName("page.codeberg.JakobDev.jdProcessFileWatcher")
    app.setApplicationName("jdProcessFileWatcher")
    app.setApplicationVersion(env.version)
    app.setWindowIcon(env.icon)

    if env.settings.get("language") == "default":
        current_locale = QLocale()
    else:
        current_locale = QLocale(env.settings.get("language"))

    qt_translator = QTranslator()
    if qt_translator.load(current_locale, "qt", "_", QLibraryInfo.path(QLibraryInfo.LibraryPath.TranslationsPath)):
        app.installTranslator(qt_translator)

    app_translator = QTranslator()
    if app_translator.load(current_locale, "jdProcessFileWatcher", "_", os.path.join(env.program_dir, "translations")):
        app.installTranslator(app_translator)

    main_window = MainWindow(env)
    main_window.show()

    if env.settings.get("welcomeDialogStartup"):
        main_window.welcome_dialog.open_dialog()

    sys.exit(app.exec())
