# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aqueduct',
 'aqueduct.components',
 'aqueduct.models',
 'aqueduct.models.fields',
 'aqueduct.models.reports',
 'aqueduct.utils']

package_data = \
{'': ['*'], 'aqueduct': ['data/*']}

install_requires = \
['attrs>=21.4.0,<22.0.0',
 'deepdiff<=5.8.0',
 'fire>=0.4.0,<0.5.0',
 'packaging>=21,<22',
 'pendulum>=2.1.2,<3.0.0',
 'pydantic>=1.9.1,<2.0.0',
 'pyyaml>=6.0,<7.0',
 'requests>=2.27.1,<3.0.0']

setup_kwargs = {
    'name': 'sw-aqueduct',
    'version': '2.0.1b1',
    'description': 'A Swimlane content delivery system written in Python',
    'long_description': '# Aqueduct\n\n![PyPI](https://img.shields.io/pypi/v/sw-aqueduct.svg)\n![Status](https://img.shields.io/pypi/status/sw-aqueduct.svg)\n![Python Version](https://img.shields.io/pypi/pyversions/sw-aqueduct)\n![License](https://img.shields.io/pypi/l/sw-aqueduct)\n\n![Read the documentation at https://swimlane.github.io/aqueduct/](https://img.shields.io/badge/docs-success-green)\n![Tests](https://github.com/swimlane/aqueduct/actions/workflows/quality.yml/badge.svg)\n![Codecov](https://codecov.io/gh/swimlane/aqueduct/branch/main/graph/badge.svg)\n\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)][pre-commit]\n[![Black](https://img.shields.io/badge/code%20style-black-000000.svg)][black]\n\n[pypi status]: https://pypi.org/project/sw-aqueduct/\n[docs]: https://swimlane.github.io/aqueduct\n[tests]: https://github.com/swimlane/aqueduct/actions?workflow=Tests\n[codecov]: https://app.codecov.io/gh/swimlane/aqueduct\n[pre-commit]: https://github.com/pre-commit/pre-commit\n[black]: https://github.com/psf/black\n\n> aq·ue·duct | \\ˈä-kwə-ˌdəkt\\\n\nDefinition of _aqueduct_\n\n1. a conduit for water\n2. a content delivery system for the [Swimlane](https://swimlane.com/) platform\n\n> ([What\'s new?](docs/CHANGELOG.md))\n\n> ([Testing Steps](docs/TESTING.md))\n\n_Aqueduct_ is a Python package to migrate content from one (source) [Swimlane](https://swimlane.com/) instance to another (destination) instance in reliable and repeatable process.\n\n## Table of Contents\n\n* [Why?](#why)\n* [Features](#features)\n    * [Aqueduct Parameters](aqueduct.md)\n* [Getting Started](#getting-started)\n* [Usage Examples](#usage-examples)\n* [Installation](#installation)\n* [Getting Help](#getting-help)\n* [Contributing](#contributing)\n\n## Why?\n\n> Currently we only support transferring of content from one [Swimlane](https://swimlane.com/) instance to another that are the same semantic versioning number. You can bypass this but it is **NOT** recommended and there are limitations. Please see the [available parameters for more information](docs/aqueduct.md).\n\nMany [Swimlane](https://swimlane.com/) customers build their own custom content (e.g. Use Cases) to fit their needs. We understand that every organization is different and because of this we have built `aqueduct` to facilitate the _migration_ of this content from one instance to another. During the creation of `aqueduct` we have decided that we want to re-enforce best practices when using [Swimlane](https://swimlane.com/). This is mainly in the form of **NOT** updating content in your production systems (e.g. destination systems). Changes should strictly be made within a development (source) instance and then migrated to your production instance once your testing is complete.\n\n## Features\n\n> By **default** aqueduct will __NOT__ perform a live migration of data. You must specify `dry_run=False` in order to migrate content.\n\nYou can view all the available parameters for the main Aqueduct class [here](docs/aqueduct.md).\n\n* By default, `aqueduct` will generate a .zip file containing source, altered, and destination JSONs when an error occurs.\n* Providing the `dump_content_path` argument will dump *ALL* source, altered, and destination JSONs into a zip file.\n* `Aqueduct` now reports back a list of `homework` items that must be completed manually on the destination.\n    * You can access the `homework` list by using the `Aqueduct._homework` property.\n* By using the `mirror_app_fields_on_destination` parameter, we will force update application fields\n* By using the `update_default_reports` parameter we will update Default reports\n\n* Collect related content based on one or more application names. Use the `gather` and `collect` methods.\n\n### Components\n\n`aqueduct` can sync several different content components (listed below). Each of the listed component links below contain details on how content for that component is synced from one instance to another. Please read this for detailed information behind how `aqueduct` works.\n\n> Please be aware that the order of this list of components is forced whether you are syncing all components (default) or specific components from one Swimlane instance to another.\n\n* [keystore](docs/components/keystore.md)\n* [packages](docs/components/packages.md)\n* [plugins](docs/components/plugins.md)\n* [assets](docs/components/assets.md)\n* [workspaces](docs/components/workspaces.md)\n* [applications](docs/components/applications.md)\n    * [workflows](docs/components/workflows.md)\n* [tasks](docs/components/tasks.md)\n* [reports](docs/components/reports.md)\n* [dashboards](docs/components/dashboards.md)\n* [users](docs/components/users.md)\n* [groups](docs/components/groups.md)\n* [roles](docs/components/roles.md)\n\n## Getting Started\n\n`aqueduct` is a Python-only package hosted on [PyPi](https://pypi.org/project/sw-aqueduct/) and works with Python 3.6 and greater.\n\n```bash\npip install sw-aqueduct\n```\n\n> Please see the [Installation](#installation) section for more information.\n\n## Usage Examples\n\nAs a [Swimlane](https://swimlane.com/) customer you can utilize `aqueduct` to migrate content from one instance to another. Additionally, you can utilize our `Swimlane Aqueduct` use case and [plugin](https://apphub.swimlane.com/swimbundles/swimlane/sw_swimlane_aqueduct). To do so please reach out to customer support or your PS contact on how to acquire this SSP (Swimlane Solutions Package).\n\nBefore we look at the options available for configuring aqueduct, we must first create two `SwimlaneInstance` objects. One is considered the source instance and the other is the destination instance.\n\n```python\nfrom aqueduct import SwimlaneInstance\n\n\nsw_source = SwimlaneInstance(\n    host="https://10.32.100.xxx",\n    username="admin",\n    password=""\n)\n\nsw_dest = SwimlaneInstance(\n    host="https://10.32.100.xxx",\n    username="admin",\n    password=""\n)\n```\n\nOnce we have these instances configured, we can begin to configure `aqueduct`.  You can view all the available parameters for the main Aqueduct class [here](docs/aqueduct.md).\n\n> By default `aqueduct` will **NOT** transfer your content. You must specify the `dry_run=False` parameter in order to actually transfer content.\n\n```python\nfrom aqueduct import Aqueduct\n\n# Below are the default parameters and values when instantiating a Aqueduct object.\naq = Aqueduct(\n    source=sw_source,\n    destination=sw_dest,\n    dry_run=True,\n    offline=False,\n    update_reports=False,\n    update_dashboards=False,\n    continue_on_error=False,\n    use_unsupported_version=False,\n    force_unsupported_version=False,\n    dump_content_path=None,\n    update_default_reports=False,\n    mirror_app_fields_on_destination=False,\n)\n```\n\nOnce we have configured out `Aqueduct` class instance we can now sync content from one instance to another. To do this we must call the `sync` method on the `Aqueduct` instance.\n\n```python\n# this will sync all components listed above.\naq.sync()\n```\n\nBy default we will sync all components but you can select which components you want to sync by passing in a list of [components](#components) as an argument to the `sync` method.\n\n```python\n# You can specify one or more of them as well.\naq.sync(components=[\'applications\', \'plugins\', \'workspaces\', \'roles\']\n```\n\nYou can also include or exclude specific components themselves. Imagine you have an application and a plugin on your source instance that you do not want to transfer to a destination instance. You can specify this in an `exclude` (or `include`) parameter by passing in the following dictionary:\n\n> Please **NOTE** that if you specify a specific component item to exclude you must also provide that same component in the `components` parameter. If you do not, then it will run all components and only filter for that application name / plugin name as specified.\n\n```python\naq.sync(components=[\'applications\', \'plugins\'], exclude={\'applications\': [\'My Source Application Name\'], \'plugins\': [\'My Source Plugin Name\']})\n```\n\n## Installation\n\nYou can install **aqueduct** on OS X, Linux, or Windows. You can also install it directly from the source. To install, see the commands under the relevant operating system heading, below.\n\n### Prerequisites\n\nThe following libraries are required and installed by `aqueduct`:\n\n```\npyyaml==6.0\nfire==0.4.0\nattrs==21.4.0\npydantic==1.9.1\nswimlane==10.5.0\npackaging>-21\nrequests>=2.27.1\n```\n\n### macOS, Linux and Windows:\n\n```bash\npip install sw-aqueduct\n```\n\n### macOS using M1 processor\n\n```bash\ngit clone https://github.com/swimlane/aqueduct.git\ncd aqueduct\n\n# Satisfy ModuleNotFoundError: No module named \'setuptools_rust\'\nbrew install rust\npip3 install --upgrade pip\npip3 install setuptools_rust\n\n# Back to our regularly scheduled programming . . .\n\npython setup.py install\n\n# or install via poetry\npoetry install --build\n```\n\n### Installing from source\n\n```bash\ngit clone https://github.com/swimlane/aqueduct.git\ncd aqueduct\npython setup.py install\n# or install via poetry\n# poetry install\n```\n\n## Getting Help\n\nPlease create an [issue](https://github.com/swimlane/aqueduct/pulls) if you have questions or run into any issues.\n\n## Security Issues\n\nPlease read [SECURITY.md](docs/SECURITY.md) for details on contacting us related to security issues.\n\n## Built With\n\n* [carcass](https://github.com/MSAdministrator/carcass) - Python packaging template\n\n## Contributing\n\nPlease read [CONTRIBUTING.md](docs/CONTRIBUTING.md) for details on our code of conduct, and the process for submitting pull requests to us.\n\n## Versioning\n\nWe use [SemVer](http://semver.org/) for versioning.\n\n## Authors\n\n* Josh Rickard - *Initial work* - [MSAdministrator](https://github.com/MSAdministrator)\n\nSee also the list of [contributors](https://github.com/swimlane/aqueduct/contributors) who participated in this project.\n\n## License\n\nThis project is licensed under the MIT License - see the [LICENSE](docs/LICENSE.md) file for details\n',
    'author': 'MSAdministrator',
    'author_email': 'rickardja@live.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
