import sys
from typing import Any, AnyStr, Callable, ContextManager, Generic, IO, Optional, Text, Type, Union

if sys.version_info >= (3, 6):
    from os import PathLike
    _Path = Union[str, bytes, PathLike[str], PathLike[bytes]]
else:
    _Path = Union[Text, bytes]

def replace_atomic(src: AnyStr, dst: AnyStr) -> None: ...
def move_atomic(src: AnyStr, dst: AnyStr) -> None: ...
class AtomicWriter(object):
    def __init__(self, path: _Path, mode: Text = ..., overwrite: bool = ...) -> None: ...
    def open(self) -> ContextManager[IO[Any]]: ...
    def _open(self, get_fileobject: Callable[..., IO[AnyStr]]) -> ContextManager[IO[AnyStr]]: ...
    def get_fileobject(self, dir: Optional[_Path] = ..., **kwargs: Any) -> IO[Any]: ...
    def sync(self, f: IO[Any]) -> None: ...
    def commit(self, f: IO[Any]) -> None: ...
    def rollback(self, f: IO[Any]) -> None: ...
def atomic_write(
    path: _Path, writer_cls: Type[AtomicWriter] = ..., **cls_kwargs: object,
) -> ContextManager[IO[Any]]: ...
