import { Test } from 'nodeunit';
declare const _default: {
    'create from components with defaults'(test: Test): void;
    'create from components with specific values for the various components'(test: Test): void;
    'allow empty string in components'(test: Test): void;
    'resourcePathSep can be set to ":" instead of the default "/"'(test: Test): void;
    'resourcePathSep can be set to "" instead of the default "/"'(test: Test): void;
    'fails if resourcePathSep is neither ":" nor "/"'(test: Test): void;
    'Arn.parse(s)': {
        'fails': {
            'if doesn\'t start with "arn:"'(test: Test): void;
            'if the ARN doesnt have enough components'(test: Test): void;
            'if "service" is not specified'(test: Test): void;
            'if "resource" is not specified'(test: Test): void;
        };
        'various successful parses'(test: Test): void;
        'a Token with : separator'(test: Test): void;
        'a Token with / separator'(test: Test): void;
        'returns empty string ARN components'(test: Test): void;
    };
    'can use a fully specified ARN from a different stack without incurring an import'(test: Test): void;
};
export = _default;
