# coding: utf-8

"""
    Martlet Organization API

    Create/maintain organizations, access keys, addresses and permissions.   # noqa: E501

    OpenAPI spec version: 0.151.0
    Contact: apiteam@bmbix.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from bmb_martlet_organization_client.api_client import ApiClient


class AddressesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def activate_access_list(self, address_id, list_id, **kwargs):  # noqa: E501
        """\"create an activation record for this list. Removes any other list's activation record.\"   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.activate_access_list(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListActivationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.activate_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.activate_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def activate_access_list_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """\"create an activation record for this list. Removes any other list's activation record.\"   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.activate_access_list_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListActivationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method activate_access_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `activate_access_list`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `activate_access_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/activation', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListActivationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_access_list(self, body, address_id, **kwargs):  # noqa: E501
        """Add an access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_list(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessList body: List to add (required)
        :param str address_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_access_list_with_http_info(body, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_access_list_with_http_info(body, address_id, **kwargs)  # noqa: E501
            return data

    def create_access_list_with_http_info(self, body, address_id, **kwargs):  # noqa: E501
        """Add an access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_list_with_http_info(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessList body: List to add (required)
        :param str address_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_access_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_access_list`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `create_access_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_access_list_entry(self, body, address_id, list_id, **kwargs):  # noqa: E501
        """Add an entry to an access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_list_entry(body, address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessListEntry body: Entry to add to access list (required)
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_access_list_entry_with_http_info(body, address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_access_list_entry_with_http_info(body, address_id, list_id, **kwargs)  # noqa: E501
            return data

    def create_access_list_entry_with_http_info(self, body, address_id, list_id, **kwargs):  # noqa: E501
        """Add an entry to an access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_list_entry_with_http_info(body, address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessListEntry body: Entry to add to access list (required)
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_access_list_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_access_list_entry`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `create_access_list_entry`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `create_access_list_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/entries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListEntryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_message_processed_receipt(self, body, address_id, **kwargs):  # noqa: E501
        """Submit notification that a message has been processed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_message_processed_receipt(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageProcessedReceipt body: Message processed receipt data. (required)
        :param str address_id: (required)
        :return: MessageProcessedReceiptResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_message_processed_receipt_with_http_info(body, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_message_processed_receipt_with_http_info(body, address_id, **kwargs)  # noqa: E501
            return data

    def create_message_processed_receipt_with_http_info(self, body, address_id, **kwargs):  # noqa: E501
        """Submit notification that a message has been processed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_message_processed_receipt_with_http_info(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageProcessedReceipt body: Message processed receipt data. (required)
        :param str address_id: (required)
        :return: MessageProcessedReceiptResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_message_processed_receipt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_message_processed_receipt`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `create_message_processed_receipt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-processed-receipts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageProcessedReceiptResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_message_type(self, body, address_id, **kwargs):  # noqa: E501
        """Add a message-type processable by this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_message_type(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageType body: The message_type to add. (required)
        :param str address_id: (required)
        :return: MessageTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_message_type_with_http_info(body, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_message_type_with_http_info(body, address_id, **kwargs)  # noqa: E501
            return data

    def create_message_type_with_http_info(self, body, address_id, **kwargs):  # noqa: E501
        """Add a message-type processable by this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_message_type_with_http_info(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageType body: The message_type to add. (required)
        :param str address_id: (required)
        :return: MessageTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_message_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_message_type`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `create_message_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-types', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageTypeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_note(self, body, address_id, **kwargs):  # noqa: E501
        """Add a note for a message connected with this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_note(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageNote body: The note to add. (required)
        :param str address_id: (required)
        :return: MessageNote
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_note_with_http_info(body, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_note_with_http_info(body, address_id, **kwargs)  # noqa: E501
            return data

    def create_note_with_http_info(self, body, address_id, **kwargs):  # noqa: E501
        """Add a note for a message connected with this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_note_with_http_info(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageNote body: The note to add. (required)
        :param str address_id: (required)
        :return: MessageNote
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_note" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_note`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `create_note`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-notes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageNote',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_permission(self, body, address_id, **kwargs):  # noqa: E501
        """Grant a permission.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_permission(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Permission body: Permission data (required)
        :param str address_id: (required)
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_permission_with_http_info(body, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_permission_with_http_info(body, address_id, **kwargs)  # noqa: E501
            return data

    def create_permission_with_http_info(self, body, address_id, **kwargs):  # noqa: E501
        """Grant a permission.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_permission_with_http_info(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Permission body: Permission data (required)
        :param str address_id: (required)
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_permission`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `create_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/permissions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_private_key(self, address_id, **kwargs):  # noqa: E501
        """Rotate private key - create and store new key with life of 90 days.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_private_key(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: PrivateKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_private_key_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_private_key_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def create_private_key_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """Rotate private key - create and store new key with life of 90 days.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_private_key_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: PrivateKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_private_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `create_private_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/private-keys', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrivateKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deactivate_access_list(self, address_id, list_id, **kwargs):  # noqa: E501
        """Delete an activation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deactivate_access_list(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListDeactivationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.deactivate_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.deactivate_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def deactivate_access_list_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """Delete an activation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deactivate_access_list_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListDeactivationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deactivate_access_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `deactivate_access_list`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `deactivate_access_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/activation', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListDeactivationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_access_list(self, address_id, list_id, **kwargs):  # noqa: E501
        """Delete a list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_list(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def delete_access_list_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """Delete a list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_list_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_access_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `delete_access_list`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `delete_access_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_access_list_entry(self, address_id, list_id, entry_id, **kwargs):  # noqa: E501
        """Delete an access list entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_list_entry(address_id, list_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :param str entry_id: (required)
        :return: AccessListEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_access_list_entry_with_http_info(address_id, list_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_access_list_entry_with_http_info(address_id, list_id, entry_id, **kwargs)  # noqa: E501
            return data

    def delete_access_list_entry_with_http_info(self, address_id, list_id, entry_id, **kwargs):  # noqa: E501
        """Delete an access list entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_list_entry_with_http_info(address_id, list_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :param str entry_id: (required)
        :return: AccessListEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id', 'entry_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_access_list_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `delete_access_list_entry`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `delete_access_list_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `delete_access_list_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entry_id'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/entries/{entry_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListEntryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_message_type(self, address_id, message_type_id, **kwargs):  # noqa: E501
        """Delete a message type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_message_type(address_id, message_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_type_id: (required)
        :return: MessageTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_message_type_with_http_info(address_id, message_type_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_message_type_with_http_info(address_id, message_type_id, **kwargs)  # noqa: E501
            return data

    def delete_message_type_with_http_info(self, address_id, message_type_id, **kwargs):  # noqa: E501
        """Delete a message type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_message_type_with_http_info(address_id, message_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_type_id: (required)
        :return: MessageTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'message_type_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_message_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `delete_message_type`")  # noqa: E501
        # verify the required parameter 'message_type_id' is set
        if ('message_type_id' not in params or
                params['message_type_id'] is None):
            raise ValueError("Missing the required parameter `message_type_id` when calling `delete_message_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'message_type_id' in params:
            path_params['message_type_id'] = params['message_type_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-types/{message_type_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageTypeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_permission(self, address_id, permission_id, **kwargs):  # noqa: E501
        """Remove a permission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_permission(address_id, permission_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str permission_id: (required)
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_permission_with_http_info(address_id, permission_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_permission_with_http_info(address_id, permission_id, **kwargs)  # noqa: E501
            return data

    def delete_permission_with_http_info(self, address_id, permission_id, **kwargs):  # noqa: E501
        """Remove a permission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_permission_with_http_info(address_id, permission_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str permission_id: (required)
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'permission_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `delete_permission`")  # noqa: E501
        # verify the required parameter 'permission_id' is set
        if ('permission_id' not in params or
                params['permission_id'] is None):
            raise ValueError("Missing the required parameter `permission_id` when calling `delete_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'permission_id' in params:
            path_params['permission_id'] = params['permission_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/permissions/{permission_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_access_list(self, address_id, list_id, **kwargs):  # noqa: E501
        """get single access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_list(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def get_access_list_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """get single access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_list_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_access_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_access_list`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_access_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_address(self, address_id, **kwargs):  # noqa: E501
        """get an address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_address_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_address_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def get_address_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """get an address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_address_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_inbound_delivery_advice(self, address_id, message_id, **kwargs):  # noqa: E501
        """get the delivery advice for an inbound message, if any  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbound_delivery_advice(address_id, message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id: (required)
        :return: AcceptanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_inbound_delivery_advice_with_http_info(address_id, message_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_inbound_delivery_advice_with_http_info(address_id, message_id, **kwargs)  # noqa: E501
            return data

    def get_inbound_delivery_advice_with_http_info(self, address_id, message_id, **kwargs):  # noqa: E501
        """get the delivery advice for an inbound message, if any  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inbound_delivery_advice_with_http_info(address_id, message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id: (required)
        :return: AcceptanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'message_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inbound_delivery_advice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_inbound_delivery_advice`")  # noqa: E501
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params or
                params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `get_inbound_delivery_advice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'message_id' in params:
            path_params['message_id'] = params['message_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/inbound/delivery-advices/{message_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AcceptanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_message(self, address_id, message_id, **kwargs):  # noqa: E501
        """CHECK THIS get a single message  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_message(address_id, message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id: (required)
        :return: MessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_message_with_http_info(address_id, message_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_message_with_http_info(address_id, message_id, **kwargs)  # noqa: E501
            return data

    def get_message_with_http_info(self, address_id, message_id, **kwargs):  # noqa: E501
        """CHECK THIS get a single message  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_message_with_http_info(address_id, message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id: (required)
        :return: MessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'message_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_message" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_message`")  # noqa: E501
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params or
                params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `get_message`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'message_id' in params:
            path_params['message_id'] = params['message_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/messages/{message_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_outbound_delivery_advice(self, address_id, message_id, **kwargs):  # noqa: E501
        """get the delivery advice for an outbound message, if any  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_outbound_delivery_advice(address_id, message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id: (required)
        :return: AcceptanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_outbound_delivery_advice_with_http_info(address_id, message_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_outbound_delivery_advice_with_http_info(address_id, message_id, **kwargs)  # noqa: E501
            return data

    def get_outbound_delivery_advice_with_http_info(self, address_id, message_id, **kwargs):  # noqa: E501
        """get the delivery advice for an outbound message, if any  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_outbound_delivery_advice_with_http_info(address_id, message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id: (required)
        :return: AcceptanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'message_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_delivery_advice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_outbound_delivery_advice`")  # noqa: E501
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params or
                params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `get_outbound_delivery_advice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'message_id' in params:
            path_params['message_id'] = params['message_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/outbound/delivery-advices/{message_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AcceptanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_public_key(self, address_id, **kwargs):  # noqa: E501
        """Get the public key for a resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_public_key(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: PublicKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_public_key_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_public_key_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def get_public_key_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """Get the public key for a resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_public_key_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: PublicKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_public_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/public-key', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PublicKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rejection_notice(self, address_id, message_id, **kwargs):  # noqa: E501
        """get a rejected-message record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rejection_notice(address_id, message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id: (required)
        :return: RejectedMessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rejection_notice_with_http_info(address_id, message_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rejection_notice_with_http_info(address_id, message_id, **kwargs)  # noqa: E501
            return data

    def get_rejection_notice_with_http_info(self, address_id, message_id, **kwargs):  # noqa: E501
        """get a rejected-message record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rejection_notice_with_http_info(address_id, message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id: (required)
        :return: RejectedMessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'message_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rejection_notice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_rejection_notice`")  # noqa: E501
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params or
                params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `get_rejection_notice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'message_id' in params:
            path_params['message_id'] = params['message_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/outbound/rejection-notices/{message_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RejectedMessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submission_receipt(self, address_id, message_id, **kwargs):  # noqa: E501
        """get a received-message record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submission_receipt(address_id, message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id: (required)
        :return: ReceivedMessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submission_receipt_with_http_info(address_id, message_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submission_receipt_with_http_info(address_id, message_id, **kwargs)  # noqa: E501
            return data

    def get_submission_receipt_with_http_info(self, address_id, message_id, **kwargs):  # noqa: E501
        """get a received-message record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submission_receipt_with_http_info(address_id, message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id: (required)
        :return: ReceivedMessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'message_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submission_receipt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_submission_receipt`")  # noqa: E501
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params or
                params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `get_submission_receipt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'message_id' in params:
            path_params['message_id'] = params['message_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/outbound/submission-receipts/{message_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReceivedMessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index_receiveds(self, address_id, **kwargs):  # noqa: E501
        """CHECK THiS get received-message records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_receiveds(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: ReceivedMessagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.index_receiveds_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.index_receiveds_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def index_receiveds_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """CHECK THiS get received-message records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_receiveds_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: ReceivedMessagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_receiveds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `index_receiveds`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/received-messages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReceivedMessagesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_access_list_entries(self, address_id, list_id, **kwargs):  # noqa: E501
        """Get list entries  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_access_list_entries(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListEntriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_access_list_entries_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_access_list_entries_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def list_access_list_entries_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """Get list entries  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_access_list_entries_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListEntriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_access_list_entries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_access_list_entries`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `list_access_list_entries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/entries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListEntriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_access_lists(self, address_id, **kwargs):  # noqa: E501
        """get access lists for address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_access_lists(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: AccessListsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_access_lists_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_access_lists_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_access_lists_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """get access lists for address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_access_lists_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: AccessListsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_access_lists" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_access_lists`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_inbound_delivery_advices(self, address_id, **kwargs):  # noqa: E501
        """The messages sent to this address available for insertion/delivery. Requires bmbix://power/address/view.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_inbound_delivery_advices(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str query:
        :param float pointer:
        :param float limit:
        :return: AcceptancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_inbound_delivery_advices_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_inbound_delivery_advices_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_inbound_delivery_advices_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """The messages sent to this address available for insertion/delivery. Requires bmbix://power/address/view.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_inbound_delivery_advices_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str query:
        :param float pointer:
        :param float limit:
        :return: AcceptancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'query', 'pointer', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_inbound_delivery_advices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_inbound_delivery_advices`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'pointer' in params:
            query_params.append(('pointer', params['pointer']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/inbound/delivery-advices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AcceptancesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_message_processed_receipts(self, address_id, **kwargs):  # noqa: E501
        """get processed receipts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_message_processed_receipts(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: MessageProcessedReceiptsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_message_processed_receipts_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_message_processed_receipts_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_message_processed_receipts_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """get processed receipts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_message_processed_receipts_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: MessageProcessedReceiptsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_message_processed_receipts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_message_processed_receipts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-processed-receipts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageProcessedReceiptsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_message_types(self, address_id, **kwargs):  # noqa: E501
        """Message types processable by this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_message_types(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: MessageTypesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_message_types_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_message_types_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_message_types_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """Message types processable by this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_message_types_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: MessageTypesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_message_types" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_message_types`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-types', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageTypesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_notes(self, address_id, **kwargs):  # noqa: E501
        """Message notes for messages connected with this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_notes(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id:
        :return: MessageNotesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_notes_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_notes_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_notes_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """Message notes for messages connected with this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_notes_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id:
        :return: MessageNotesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'message_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_notes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_notes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []
        if 'message_id' in params:
            query_params.append(('message_id', params['message_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-notes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageNotesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_outbound_delivery_advices(self, address_id, **kwargs):  # noqa: E501
        """Get a report of all message acceptances send from this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_outbound_delivery_advices(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str query:
        :param float pointer:
        :param float limit:
        :return: AcceptancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_outbound_delivery_advices_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_outbound_delivery_advices_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_outbound_delivery_advices_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """Get a report of all message acceptances send from this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_outbound_delivery_advices_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str query:
        :param float pointer:
        :param float limit:
        :return: AcceptancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'query', 'pointer', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_outbound_delivery_advices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_outbound_delivery_advices`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'pointer' in params:
            query_params.append(('pointer', params['pointer']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/outbound/delivery-advices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AcceptancesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_permissions(self, address_id, **kwargs):  # noqa: E501
        """Get the permissions for an organization.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_permissions(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: PermissionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_permissions_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_permissions_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_permissions_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """Get the permissions for an organization.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_permissions_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: PermissionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/permissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_private_keys(self, address_id, **kwargs):  # noqa: E501
        """Get the private keys for a resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_private_keys(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: PrivateKeysResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_private_keys_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_private_keys_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_private_keys_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """Get the private keys for a resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_private_keys_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: PrivateKeysResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_private_keys" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_private_keys`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/private-keys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrivateKeysResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_rejection_notices(self, address_id, **kwargs):  # noqa: E501
        """get rejected-message records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_rejection_notices(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str query:
        :param float pointer:
        :param float limit:
        :return: RejectedMessagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_rejection_notices_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_rejection_notices_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_rejection_notices_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """get rejected-message records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_rejection_notices_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str query:
        :param float pointer:
        :param float limit:
        :return: RejectedMessagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'query', 'pointer', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_rejection_notices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_rejection_notices`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'pointer' in params:
            query_params.append(('pointer', params['pointer']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/outbound/rejection-notices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RejectedMessagesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_submission_receipts(self, address_id, **kwargs):  # noqa: E501
        """get received-message records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_submission_receipts(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str query:
        :param float pointer:
        :param float limit:
        :return: ReceivedMessagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_submission_receipts_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_submission_receipts_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_submission_receipts_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """get received-message records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_submission_receipts_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str query:
        :param float pointer:
        :param float limit:
        :return: ReceivedMessagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'query', 'pointer', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_submission_receipts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_submission_receipts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'pointer' in params:
            query_params.append(('pointer', params['pointer']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/outbound/submission-receipts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReceivedMessagesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def mark_read(self, body, address_id, **kwargs):  # noqa: E501
        """mark a message as read  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mark_read(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageReadReceipt body: Query body (required)
        :param str address_id: (required)
        :return: MessageReadReceiptResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.mark_read_with_http_info(body, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.mark_read_with_http_info(body, address_id, **kwargs)  # noqa: E501
            return data

    def mark_read_with_http_info(self, body, address_id, **kwargs):  # noqa: E501
        """mark a message as read  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mark_read_with_http_info(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageReadReceipt body: Query body (required)
        :param str address_id: (required)
        :return: MessageReadReceiptResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `mark_read`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `mark_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-read-receipts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageReadReceiptResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def select_accepted_messages(self, address_id, **kwargs):  # noqa: E501
        """CHECK THIS get accepted-message records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.select_accepted_messages(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: AcceptancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.select_accepted_messages_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.select_accepted_messages_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def select_accepted_messages_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """CHECK THIS get accepted-message records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.select_accepted_messages_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: AcceptancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method select_accepted_messages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `select_accepted_messages`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/accepted-messages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AcceptancesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def select_no_context(self, message_id, **kwargs):  # noqa: E501
        """get a single message, without address or org context  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.select_no_context(message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str message_id: (required)
        :return: MessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.select_no_context_with_http_info(message_id, **kwargs)  # noqa: E501
        else:
            (data) = self.select_no_context_with_http_info(message_id, **kwargs)  # noqa: E501
            return data

    def select_no_context_with_http_info(self, message_id, **kwargs):  # noqa: E501
        """get a single message, without address or org context  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.select_no_context_with_http_info(message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str message_id: (required)
        :return: MessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['message_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method select_no_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params or
                params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `select_no_context`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'message_id' in params:
            path_params['message_id'] = params['message_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/messages/{message_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def submit_message(self, body, address_id, **kwargs):  # noqa: E501
        """Make a message submission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_message(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Message body: Message data (required)
        :param str address_id: (required)
        :return: SubmissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.submit_message_with_http_info(body, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.submit_message_with_http_info(body, address_id, **kwargs)  # noqa: E501
            return data

    def submit_message_with_http_info(self, body, address_id, **kwargs):  # noqa: E501
        """Make a message submission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_message_with_http_info(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Message body: Message data (required)
        :param str address_id: (required)
        :return: SubmissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_message" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `submit_message`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `submit_message`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/outbound/messages', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmissionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_address(self, body, address_id, **kwargs):  # noqa: E501
        """Update is_closed or purpose status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_address(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Address body: Address patch data (required)
        :param str address_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_address_with_http_info(body, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_address_with_http_info(body, address_id, **kwargs)  # noqa: E501
            return data

    def update_address_with_http_info(self, body, address_id, **kwargs):  # noqa: E501
        """Update is_closed or purpose status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_address_with_http_info(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Address body: Address patch data (required)
        :param str address_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_address`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `update_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_private_key(self, body, address_id, private_key_id, **kwargs):  # noqa: E501
        """Update a private key.  set_rescinded ============= {   \"op\": \"replace\",   \"path\": \"/rescinded\",   \"value\": true }   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_private_key(body, address_id, private_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericPatch body: Private Key Patch (required)
        :param str address_id: (required)
        :param str private_key_id: (required)
        :return: PrivateKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_private_key_with_http_info(body, address_id, private_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_private_key_with_http_info(body, address_id, private_key_id, **kwargs)  # noqa: E501
            return data

    def update_private_key_with_http_info(self, body, address_id, private_key_id, **kwargs):  # noqa: E501
        """Update a private key.  set_rescinded ============= {   \"op\": \"replace\",   \"path\": \"/rescinded\",   \"value\": true }   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_private_key_with_http_info(body, address_id, private_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericPatch body: Private Key Patch (required)
        :param str address_id: (required)
        :param str private_key_id: (required)
        :return: PrivateKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id', 'private_key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_private_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_private_key`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `update_private_key`")  # noqa: E501
        # verify the required parameter 'private_key_id' is set
        if ('private_key_id' not in params or
                params['private_key_id'] is None):
            raise ValueError("Missing the required parameter `private_key_id` when calling `update_private_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'private_key_id' in params:
            path_params['private_key_id'] = params['private_key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/private-keys/{private_key_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrivateKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
