"""
Physical constants in SI units.
"""

PLANCK = 6.62607004e-34  # (m2 kg s-1)
LIGHT = 299792458.0  # (m s-1)
BOLTZMANN = 1.38064852e-23  # (m2 kg s-2 K-1)
GRAVITY = 6.67408e-11  # (m3 kg−1 s−2)
PARSEC = 3.08567758147e16  # (m)
AU = 149597870700.0  # (m)
M_JUP = 1.89813e27  # (kg)
R_JUP = 69911000.0  # (m)
L_SUN = 3.828e26  # (W)
M_SUN = 1.9891e30  # (kg)
R_SUN = 6.95700e8  # (m)
M_EARTH = 5.9722e24  # (kg)
R_EARTH = 6.3781e6  # (m)
SIGMA_SB = 5.670374419e-8  # (W m−2 K−4)
ATOMIC_MASS = 1.66053906660e-27  # (kg)
