"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnOutput = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn_element_1 = require("./cfn-element");
class CfnOutput extends cfn_element_1.CfnElement {
    /**
     * Creates an CfnOutput value for this stack.
     * @param scope The parent construct.
     * @param props CfnOutput properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_core_CfnOutputProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.value === undefined) {
            throw new Error(`Missing value for CloudFormation output at path "${this.node.path}"`);
        }
        this._description = props.description;
        this._value = props.value;
        this._condition = props.condition;
        this._exportName = props.exportName;
    }
    /**
     * A String type that describes the output value.
     * The description can be a maximum of 4 K in length.
     *
     * @default - No description.
     */
    get description() {
        return this._description;
    }
    set description(description) {
        this._description = description;
    }
    /**
     * The value of the property returned by the aws cloudformation describe-stacks command.
     * The value of an output can include literals, parameter references, pseudo-parameters,
     * a mapping value, or intrinsic functions.
     */
    get value() {
        return this._value;
    }
    set value(value) {
        this._value = value;
    }
    /**
     * A condition to associate with this output value. If the condition evaluates
     * to `false`, this output value will not be included in the stack.
     *
     * @default - No condition is associated with the output.
     */
    get condition() {
        return this._condition;
    }
    set condition(condition) {
        this._condition = condition;
    }
    /**
     * The name used to export the value of this output across stacks.
     *
     * To use the value in another stack, pass the value of
     * `output.importValue` to it.
     *
     * @default - the output is not exported
     */
    get exportName() {
        return this._exportName;
    }
    set exportName(exportName) {
        this._exportName = exportName;
    }
    /**
     * Return the `Fn.importValue` expression to import this value into another stack
     *
     * The returned value should not be used in the same stack, but in a
     * different one. It must be deployed to the same environment, as
     * CloudFormation exports can only be imported in the same Region and
     * account.
     *
     * The is no automatic registration of dependencies between stacks when using
     * this mechanism, so you should make sure to deploy them in the right order
     * yourself.
     *
     * You can use this mechanism to share values across Stacks in different
     * Stages. If you intend to share the value to another Stack inside the same
     * Stage, the automatic cross-stack referencing mechanism is more convenient.
     */
    get importValue() {
        // We made _exportName mutable so this will have to be lazy.
        return cfn_fn_1.Fn.importValue(lazy_1.Lazy.uncachedString({
            produce: (ctx) => {
                if (stack_1.Stack.of(ctx.scope) === this.stack) {
                    throw new Error(`'importValue' property of '${this.node.path}' should only be used in a different Stack`);
                }
                if (!this._exportName) {
                    throw new Error(`Add an exportName to the CfnOutput at '${this.node.path}' in order to use 'output.importValue'`);
                }
                return this._exportName;
            },
        }));
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return {
            Outputs: {
                [this.logicalId]: {
                    Description: this._description,
                    Value: this._value,
                    Export: this._exportName != null ? { Name: this._exportName } : undefined,
                    Condition: this._condition ? this._condition.logicalId : undefined,
                },
            },
        };
    }
    validate() {
        if (this._exportName && !token_1.Token.isUnresolved(this._exportName) && this._exportName.length > 255) {
            return [`Export name cannot exceed 255 characters (got ${this._exportName.length} characters)`];
        }
        return [];
    }
}
exports.CfnOutput = CfnOutput;
_a = JSII_RTTI_SYMBOL_1;
CfnOutput[_a] = { fqn: "@aws-cdk/core.CfnOutput", version: "1.154.0" };
const cfn_fn_1 = require("./cfn-fn");
const lazy_1 = require("./lazy");
const stack_1 = require("./stack");
const token_1 = require("./token");
//# sourceMappingURL=data:application/json;base64,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