# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest

class CreateNetworkAccessEndpointRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'Eiam', '2021-12-01', 'CreateNetworkAccessEndpoint','eiam')
		self.set_protocol_type('https')
		self.set_method('POST')

	def get_ClientToken(self): # String
		return self.get_query_params().get('ClientToken')

	def set_ClientToken(self, ClientToken):  # String
		self.add_query_param('ClientToken', ClientToken)
	def get_VSwitchIds(self): # Array
		return self.get_query_params().get('VSwitchIds')

	def set_VSwitchIds(self, VSwitchIds):  # Array
		for index1, value1 in enumerate(VSwitchIds):
			self.add_query_param('VSwitchIds.' + str(index1 + 1), value1)
	def get_NetworkAccessEndpointName(self): # String
		return self.get_query_params().get('NetworkAccessEndpointName')

	def set_NetworkAccessEndpointName(self, NetworkAccessEndpointName):  # String
		self.add_query_param('NetworkAccessEndpointName', NetworkAccessEndpointName)
	def get_VpcRegionId(self): # String
		return self.get_query_params().get('VpcRegionId')

	def set_VpcRegionId(self, VpcRegionId):  # String
		self.add_query_param('VpcRegionId', VpcRegionId)
	def get_InstanceId(self): # String
		return self.get_query_params().get('InstanceId')

	def set_InstanceId(self, InstanceId):  # String
		self.add_query_param('InstanceId', InstanceId)
	def get_VpcId(self): # String
		return self.get_query_params().get('VpcId')

	def set_VpcId(self, VpcId):  # String
		self.add_query_param('VpcId', VpcId)
