from   headerparser import HeaderParser, BOOL
from   .util        import fieldnorm, strfield

infoparser = HeaderParser(normalizer=fieldnorm)
# NOTE: WHEEL files generated by `wheel` (but not by `flit`) end with a blank
# line, which headerparser interprets as the start of an empty body.
infoparser.add_field('Wheel-Version', required=True)
infoparser.add_field('Generator', required=True)
infoparser.add_field('Root-Is-Purelib', required=True, type=BOOL)
infoparser.add_field('Tag', required=True, multiple=True)
infoparser.add_field('Build')
infoparser.add_additional(multiple=True, type=strfield)

def parse_wheel_info(fp):
    """ Parsing :file:`{distribution}-{version}.dist-info/WHEEL` files """
    wi = infoparser.parse(fp)
    wheel_info = wi.normalized_dict()
    for k,v in wheel_info.items():
        if isinstance(v, list):
            wheel_info[k] = [u for u in v if u is not None]
    if wi.body is not None and wi.body.strip():
        wheel_info["BODY"] = wi.body
    return wheel_info
