# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetBrandingResult',
    'AwaitableGetBrandingResult',
    'get_branding',
    'get_branding_output',
]

@pulumi.output_type
class GetBrandingResult:
    """
    A collection of values returned by getBranding.
    """
    def __init__(__self__, colors=None, favicon_url=None, fonts=None, id=None, logo_url=None, universal_logins=None):
        if colors and not isinstance(colors, list):
            raise TypeError("Expected argument 'colors' to be a list")
        pulumi.set(__self__, "colors", colors)
        if favicon_url and not isinstance(favicon_url, str):
            raise TypeError("Expected argument 'favicon_url' to be a str")
        pulumi.set(__self__, "favicon_url", favicon_url)
        if fonts and not isinstance(fonts, list):
            raise TypeError("Expected argument 'fonts' to be a list")
        pulumi.set(__self__, "fonts", fonts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if logo_url and not isinstance(logo_url, str):
            raise TypeError("Expected argument 'logo_url' to be a str")
        pulumi.set(__self__, "logo_url", logo_url)
        if universal_logins and not isinstance(universal_logins, list):
            raise TypeError("Expected argument 'universal_logins' to be a list")
        pulumi.set(__self__, "universal_logins", universal_logins)

    @property
    @pulumi.getter
    def colors(self) -> Sequence['outputs.GetBrandingColorResult']:
        """
        Configuration settings for colors for branding.
        """
        return pulumi.get(self, "colors")

    @property
    @pulumi.getter(name="faviconUrl")
    def favicon_url(self) -> str:
        """
        URL for the favicon.
        """
        return pulumi.get(self, "favicon_url")

    @property
    @pulumi.getter
    def fonts(self) -> Sequence['outputs.GetBrandingFontResult']:
        """
        Configuration settings to customize the font.
        """
        return pulumi.get(self, "fonts")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> str:
        """
        URL of logo for branding.
        """
        return pulumi.get(self, "logo_url")

    @property
    @pulumi.getter(name="universalLogins")
    def universal_logins(self) -> Sequence['outputs.GetBrandingUniversalLoginResult']:
        """
        Configuration settings for Universal Login.
        """
        return pulumi.get(self, "universal_logins")


class AwaitableGetBrandingResult(GetBrandingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBrandingResult(
            colors=self.colors,
            favicon_url=self.favicon_url,
            fonts=self.fonts,
            id=self.id,
            logo_url=self.logo_url,
            universal_logins=self.universal_logins)


def get_branding(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBrandingResult:
    """
    Use this data source to access information about the tenant's branding settings.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    my_branding = auth0.get_branding()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('auth0:index/getBranding:getBranding', __args__, opts=opts, typ=GetBrandingResult).value

    return AwaitableGetBrandingResult(
        colors=pulumi.get(__ret__, 'colors'),
        favicon_url=pulumi.get(__ret__, 'favicon_url'),
        fonts=pulumi.get(__ret__, 'fonts'),
        id=pulumi.get(__ret__, 'id'),
        logo_url=pulumi.get(__ret__, 'logo_url'),
        universal_logins=pulumi.get(__ret__, 'universal_logins'))
def get_branding_output(opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBrandingResult]:
    """
    Use this data source to access information about the tenant's branding settings.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    my_branding = auth0.get_branding()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('auth0:index/getBranding:getBranding', __args__, opts=opts, typ=GetBrandingResult)
    return __ret__.apply(lambda __response__: GetBrandingResult(
        colors=pulumi.get(__response__, 'colors'),
        favicon_url=pulumi.get(__response__, 'favicon_url'),
        fonts=pulumi.get(__response__, 'fonts'),
        id=pulumi.get(__response__, 'id'),
        logo_url=pulumi.get(__response__, 'logo_url'),
        universal_logins=pulumi.get(__response__, 'universal_logins')))
