"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.TableProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ots_generated_1 = require("./ots.generated");
Object.defineProperty(exports, "TableProperty", { enumerable: true, get: function () { return ots_generated_1.RosTable; } });
/**
 * A ROS resource type:  `ALIYUN::OTS::Table`
 */
class Table extends ros.Resource {
    /**
     * Create a new `ALIYUN::OTS::Table`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTable = new ots_generated_1.RosTable(this, id, {
            instanceName: props.instanceName,
            tableName: props.tableName,
            timeToLive: props.timeToLive ? props.timeToLive : -1,
            maxVersions: props.maxVersions ? props.maxVersions : 1,
            secondaryIndices: props.secondaryIndices,
            deviationCellVersionInSec: props.deviationCellVersionInSec ? props.deviationCellVersionInSec : 86400,
            primaryKey: props.primaryKey,
            columns: props.columns,
            reservedThroughput: props.reservedThroughput,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTable;
        this.attrTableName = rosTable.attrTableName;
    }
}
exports.Table = Table;
//# sourceMappingURL=data:application/json;base64,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