# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2018-05-15 20:03
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailcore', '0032_add_bulk_delete_page_permission'),
        ('wagtailimages', '0018_remove_rendition_filter'),
    ]

    operations = [
        migrations.CreateModel(
            name='CountrySite',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, verbose_name=b'Country Name')),
                ('code', models.CharField(help_text=b'eg. ZA', max_length=6, verbose_name=b'Country Code')),
                ('site_url', models.CharField(help_text=b'Link to the country site. eg. http://www.zm.sitename.org/', max_length=128)),
                ('flag', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image')),
            ],
            options={
                'verbose_name': 'Country site',
            },
        ),
        migrations.CreateModel(
            name='GlobalSiteSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_globalsite', models.BooleanField(default=False, help_text=b'When activated it will set the current site as the global site.', verbose_name=b'Activate Global Site')),
                ('autoredirect', models.BooleanField(default=False, help_text=b'When activated it will automatically redirect the users to the country of their choice when accessing the global site.', verbose_name=b'Activate Auto Redirect')),
                ('geolocation', models.BooleanField(default=False, help_text=b'When activated it will detect users country and redirect them to the supported country site. If the detected country is not available it will display the available country sites.', verbose_name=b'Activate Geolocation')),
                ('description', models.TextField(blank=True, help_text=b'This description will be displayed on the homepage of the global site', null=True)),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Region',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, verbose_name=b'Region')),
                ('image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image')),
            ],
            options={
                'verbose_name': 'Country Region',
            },
        ),
        migrations.AddField(
            model_name='countrysite',
            name='region',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='country_sites', to='globalsite.Region', verbose_name=b'Country Region'),
        ),
    ]
