# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAlarmResult',
    'AwaitableGetAlarmResult',
    'get_alarm',
    'get_alarm_output',
]

@pulumi.output_type
class GetAlarmResult:
    """
    A collection of values returned by getAlarm.
    """
    def __init__(__self__, alarm_id=None, body=None, compartment_id=None, defined_tags=None, destinations=None, display_name=None, freeform_tags=None, id=None, is_enabled=None, is_notifications_per_metric_dimension_enabled=None, message_format=None, metric_compartment_id=None, metric_compartment_id_in_subtree=None, namespace=None, pending_duration=None, query=None, repeat_notification_duration=None, resolution=None, resource_group=None, severity=None, state=None, suppressions=None, time_created=None, time_updated=None):
        if alarm_id and not isinstance(alarm_id, str):
            raise TypeError("Expected argument 'alarm_id' to be a str")
        pulumi.set(__self__, "alarm_id", alarm_id)
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        pulumi.set(__self__, "body", body)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if destinations and not isinstance(destinations, list):
            raise TypeError("Expected argument 'destinations' to be a list")
        pulumi.set(__self__, "destinations", destinations)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if is_notifications_per_metric_dimension_enabled and not isinstance(is_notifications_per_metric_dimension_enabled, bool):
            raise TypeError("Expected argument 'is_notifications_per_metric_dimension_enabled' to be a bool")
        pulumi.set(__self__, "is_notifications_per_metric_dimension_enabled", is_notifications_per_metric_dimension_enabled)
        if message_format and not isinstance(message_format, str):
            raise TypeError("Expected argument 'message_format' to be a str")
        pulumi.set(__self__, "message_format", message_format)
        if metric_compartment_id and not isinstance(metric_compartment_id, str):
            raise TypeError("Expected argument 'metric_compartment_id' to be a str")
        pulumi.set(__self__, "metric_compartment_id", metric_compartment_id)
        if metric_compartment_id_in_subtree and not isinstance(metric_compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'metric_compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "metric_compartment_id_in_subtree", metric_compartment_id_in_subtree)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if pending_duration and not isinstance(pending_duration, str):
            raise TypeError("Expected argument 'pending_duration' to be a str")
        pulumi.set(__self__, "pending_duration", pending_duration)
        if query and not isinstance(query, str):
            raise TypeError("Expected argument 'query' to be a str")
        pulumi.set(__self__, "query", query)
        if repeat_notification_duration and not isinstance(repeat_notification_duration, str):
            raise TypeError("Expected argument 'repeat_notification_duration' to be a str")
        pulumi.set(__self__, "repeat_notification_duration", repeat_notification_duration)
        if resolution and not isinstance(resolution, str):
            raise TypeError("Expected argument 'resolution' to be a str")
        pulumi.set(__self__, "resolution", resolution)
        if resource_group and not isinstance(resource_group, str):
            raise TypeError("Expected argument 'resource_group' to be a str")
        pulumi.set(__self__, "resource_group", resource_group)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if suppressions and not isinstance(suppressions, list):
            raise TypeError("Expected argument 'suppressions' to be a list")
        pulumi.set(__self__, "suppressions", suppressions)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> str:
        return pulumi.get(self, "alarm_id")

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        The human-readable content of the delivered alarm notification. Oracle recommends providing guidance to operators for resolving the alarm condition. Consider adding links to standard runbook practices. Avoid entering confidential information.  Example: `High CPU usage alert. Follow runbook instructions for resolution.`
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def destinations(self) -> Sequence[str]:
        """
        A list of destinations for alarm notifications. Each destination is represented by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a related resource, such as a [topic](https://docs.cloud.oracle.com/iaas/api/#/en/notification/latest/NotificationTopic). Supported destination services: Notifications, Streaming. Limit: One destination per supported destination service.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name for the alarm. It does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether the alarm is enabled.  Example: `true`
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isNotificationsPerMetricDimensionEnabled")
    def is_notifications_per_metric_dimension_enabled(self) -> bool:
        """
        Whether the alarm sends a separate message for each metric stream. See [Creating an Alarm That Splits Messages by Metric Stream](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/create-alarm-split.htm). Example: `true`
        """
        return pulumi.get(self, "is_notifications_per_metric_dimension_enabled")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> str:
        """
        The format to use for alarm notifications. The formats are:
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="metricCompartmentId")
    def metric_compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric being evaluated by the alarm.
        """
        return pulumi.get(self, "metric_compartment_id")

    @property
    @pulumi.getter(name="metricCompartmentIdInSubtree")
    def metric_compartment_id_in_subtree(self) -> bool:
        """
        When true, the alarm evaluates metrics from all compartments and subcompartments. The parameter can only be set to true when metricCompartmentId is the tenancy OCID (the tenancy is the root compartment). A true value requires the user to have tenancy-level permissions. If this requirement is not met, then the call is rejected. When false, the alarm evaluates metrics from only the compartment specified in metricCompartmentId. Default is false.  Example: `true`
        """
        return pulumi.get(self, "metric_compartment_id_in_subtree")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The source service or application emitting the metric that is evaluated by the alarm.  Example: `oci_computeagent`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="pendingDuration")
    def pending_duration(self) -> str:
        """
        The period of time that the condition defined in the alarm must persist before the alarm state changes from "OK" to "FIRING". For example, a value of 5 minutes means that the alarm must persist in breaching the condition for five minutes before the alarm updates its state to "FIRING".
        """
        return pulumi.get(self, "pending_duration")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of the Monitoring service interprets results for each returned time series as Boolean values, where zero represents false and a non-zero value represents true. A true value means that the trigger rule condition has been met. The query must specify a metric, statistic, interval, and trigger rule (threshold or absence). Supported values for interval depend on the specified time range. More interval values are supported for smaller time ranges. You can optionally specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`. For information about writing MQL expressions, see [Editing the MQL Expression for a Query](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/query-metric-mql.htm). For details about MQL, see [Monitoring Query Language (MQL) Reference](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Reference/mql.htm). For available dimensions, review the metric definition for the supported service. See [Supported Services](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#SupportedServices).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="repeatNotificationDuration")
    def repeat_notification_duration(self) -> str:
        """
        The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, `PT4H` indicates four hours. Minimum: PT1M. Maximum: P30D.
        """
        return pulumi.get(self, "repeat_notification_duration")

    @property
    @pulumi.getter
    def resolution(self) -> str:
        """
        The time between calculated aggregation windows for the alarm. Supported value: `1m`
        """
        return pulumi.get(self, "resolution")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        """
        Resource group to match for metric data retrieved by the alarm. A resource group is a custom string that you can match when retrieving custom metrics. Only one resource group can be applied per metric. A valid resourceGroup value starts with an alphabetical character and includes only alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($).  Example: `frontend-fleet`
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The perceived type of response required when the alarm is in the "FIRING" state.  Example: `CRITICAL`
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the alarm.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def suppressions(self) -> Sequence['outputs.GetAlarmSuppressionResult']:
        """
        The configuration details for suppressing an alarm.
        """
        return pulumi.get(self, "suppressions")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the alarm was created. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the alarm was last updated. Format defined by RFC3339.  Example: `2023-02-03T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAlarmResult(GetAlarmResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlarmResult(
            alarm_id=self.alarm_id,
            body=self.body,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            destinations=self.destinations,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_enabled=self.is_enabled,
            is_notifications_per_metric_dimension_enabled=self.is_notifications_per_metric_dimension_enabled,
            message_format=self.message_format,
            metric_compartment_id=self.metric_compartment_id,
            metric_compartment_id_in_subtree=self.metric_compartment_id_in_subtree,
            namespace=self.namespace,
            pending_duration=self.pending_duration,
            query=self.query,
            repeat_notification_duration=self.repeat_notification_duration,
            resolution=self.resolution,
            resource_group=self.resource_group,
            severity=self.severity,
            state=self.state,
            suppressions=self.suppressions,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_alarm(alarm_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlarmResult:
    """
    This data source provides details about a specific Alarm resource in Oracle Cloud Infrastructure Monitoring service.

    Gets the specified alarm.
    For more information, see
    [Getting an Alarm](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/get-alarm.htm).
    For important limits information, see
    [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

    This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
    Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
    or transactions, per second (TPS) for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alarm = oci.Monitoring.get_alarm(alarm_id=oci_monitoring_alarm["test_alarm"]["id"])
    ```


    :param str alarm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of an alarm.
    """
    __args__ = dict()
    __args__['alarmId'] = alarm_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Monitoring/getAlarm:getAlarm', __args__, opts=opts, typ=GetAlarmResult).value

    return AwaitableGetAlarmResult(
        alarm_id=pulumi.get(__ret__, 'alarm_id'),
        body=pulumi.get(__ret__, 'body'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        destinations=pulumi.get(__ret__, 'destinations'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        is_notifications_per_metric_dimension_enabled=pulumi.get(__ret__, 'is_notifications_per_metric_dimension_enabled'),
        message_format=pulumi.get(__ret__, 'message_format'),
        metric_compartment_id=pulumi.get(__ret__, 'metric_compartment_id'),
        metric_compartment_id_in_subtree=pulumi.get(__ret__, 'metric_compartment_id_in_subtree'),
        namespace=pulumi.get(__ret__, 'namespace'),
        pending_duration=pulumi.get(__ret__, 'pending_duration'),
        query=pulumi.get(__ret__, 'query'),
        repeat_notification_duration=pulumi.get(__ret__, 'repeat_notification_duration'),
        resolution=pulumi.get(__ret__, 'resolution'),
        resource_group=pulumi.get(__ret__, 'resource_group'),
        severity=pulumi.get(__ret__, 'severity'),
        state=pulumi.get(__ret__, 'state'),
        suppressions=pulumi.get(__ret__, 'suppressions'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_alarm)
def get_alarm_output(alarm_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlarmResult]:
    """
    This data source provides details about a specific Alarm resource in Oracle Cloud Infrastructure Monitoring service.

    Gets the specified alarm.
    For more information, see
    [Getting an Alarm](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/get-alarm.htm).
    For important limits information, see
    [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

    This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
    Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
    or transactions, per second (TPS) for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alarm = oci.Monitoring.get_alarm(alarm_id=oci_monitoring_alarm["test_alarm"]["id"])
    ```


    :param str alarm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of an alarm.
    """
    ...
