# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAccessRequestResult',
    'AwaitableGetAccessRequestResult',
    'get_access_request',
    'get_access_request_output',
]

@pulumi.output_type
class GetAccessRequestResult:
    """
    A collection of values returned by getAccessRequest.
    """
    def __init__(__self__, access_reason_summary=None, access_request_id=None, action_requests_lists=None, approver_comment=None, audit_types=None, closure_comment=None, compartment_id=None, defined_tags=None, duration=None, extend_duration=None, freeform_tags=None, id=None, is_auto_approved=None, lifecycle_details=None, opctl_additional_message=None, opctl_id=None, opctl_name=None, operator_id=None, reason=None, request_id=None, resource_id=None, resource_name=None, resource_type=None, severity=None, state=None, sub_resource_lists=None, system_message=None, time_of_creation=None, time_of_modification=None, time_of_user_creation=None, user_id=None, workflow_ids=None):
        if access_reason_summary and not isinstance(access_reason_summary, str):
            raise TypeError("Expected argument 'access_reason_summary' to be a str")
        pulumi.set(__self__, "access_reason_summary", access_reason_summary)
        if access_request_id and not isinstance(access_request_id, str):
            raise TypeError("Expected argument 'access_request_id' to be a str")
        pulumi.set(__self__, "access_request_id", access_request_id)
        if action_requests_lists and not isinstance(action_requests_lists, list):
            raise TypeError("Expected argument 'action_requests_lists' to be a list")
        pulumi.set(__self__, "action_requests_lists", action_requests_lists)
        if approver_comment and not isinstance(approver_comment, str):
            raise TypeError("Expected argument 'approver_comment' to be a str")
        pulumi.set(__self__, "approver_comment", approver_comment)
        if audit_types and not isinstance(audit_types, list):
            raise TypeError("Expected argument 'audit_types' to be a list")
        pulumi.set(__self__, "audit_types", audit_types)
        if closure_comment and not isinstance(closure_comment, str):
            raise TypeError("Expected argument 'closure_comment' to be a str")
        pulumi.set(__self__, "closure_comment", closure_comment)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if duration and not isinstance(duration, int):
            raise TypeError("Expected argument 'duration' to be a int")
        pulumi.set(__self__, "duration", duration)
        if extend_duration and not isinstance(extend_duration, int):
            raise TypeError("Expected argument 'extend_duration' to be a int")
        pulumi.set(__self__, "extend_duration", extend_duration)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_auto_approved and not isinstance(is_auto_approved, bool):
            raise TypeError("Expected argument 'is_auto_approved' to be a bool")
        pulumi.set(__self__, "is_auto_approved", is_auto_approved)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if opctl_additional_message and not isinstance(opctl_additional_message, str):
            raise TypeError("Expected argument 'opctl_additional_message' to be a str")
        pulumi.set(__self__, "opctl_additional_message", opctl_additional_message)
        if opctl_id and not isinstance(opctl_id, str):
            raise TypeError("Expected argument 'opctl_id' to be a str")
        pulumi.set(__self__, "opctl_id", opctl_id)
        if opctl_name and not isinstance(opctl_name, str):
            raise TypeError("Expected argument 'opctl_name' to be a str")
        pulumi.set(__self__, "opctl_name", opctl_name)
        if operator_id and not isinstance(operator_id, str):
            raise TypeError("Expected argument 'operator_id' to be a str")
        pulumi.set(__self__, "operator_id", operator_id)
        if reason and not isinstance(reason, str):
            raise TypeError("Expected argument 'reason' to be a str")
        pulumi.set(__self__, "reason", reason)
        if request_id and not isinstance(request_id, str):
            raise TypeError("Expected argument 'request_id' to be a str")
        pulumi.set(__self__, "request_id", request_id)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_name and not isinstance(resource_name, str):
            raise TypeError("Expected argument 'resource_name' to be a str")
        pulumi.set(__self__, "resource_name", resource_name)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if sub_resource_lists and not isinstance(sub_resource_lists, list):
            raise TypeError("Expected argument 'sub_resource_lists' to be a list")
        pulumi.set(__self__, "sub_resource_lists", sub_resource_lists)
        if system_message and not isinstance(system_message, str):
            raise TypeError("Expected argument 'system_message' to be a str")
        pulumi.set(__self__, "system_message", system_message)
        if time_of_creation and not isinstance(time_of_creation, str):
            raise TypeError("Expected argument 'time_of_creation' to be a str")
        pulumi.set(__self__, "time_of_creation", time_of_creation)
        if time_of_modification and not isinstance(time_of_modification, str):
            raise TypeError("Expected argument 'time_of_modification' to be a str")
        pulumi.set(__self__, "time_of_modification", time_of_modification)
        if time_of_user_creation and not isinstance(time_of_user_creation, str):
            raise TypeError("Expected argument 'time_of_user_creation' to be a str")
        pulumi.set(__self__, "time_of_user_creation", time_of_user_creation)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)
        if workflow_ids and not isinstance(workflow_ids, list):
            raise TypeError("Expected argument 'workflow_ids' to be a list")
        pulumi.set(__self__, "workflow_ids", workflow_ids)

    @property
    @pulumi.getter(name="accessReasonSummary")
    def access_reason_summary(self) -> str:
        """
        Summary comment by the operator creating the access request.
        """
        return pulumi.get(self, "access_reason_summary")

    @property
    @pulumi.getter(name="accessRequestId")
    def access_request_id(self) -> str:
        return pulumi.get(self, "access_request_id")

    @property
    @pulumi.getter(name="actionRequestsLists")
    def action_requests_lists(self) -> Sequence[str]:
        """
        List of operator actions for which approval is sought by the operator user.
        """
        return pulumi.get(self, "action_requests_lists")

    @property
    @pulumi.getter(name="approverComment")
    def approver_comment(self) -> str:
        """
        The last recent Comment entered by the approver of the request.
        """
        return pulumi.get(self, "approver_comment")

    @property
    @pulumi.getter(name="auditTypes")
    def audit_types(self) -> Sequence[str]:
        """
        Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.  By default, auditing is enabled at the command level i.e., each command issued by the operator is audited. When keystroke-level is chosen,  in addition to command level logging, key strokes are also logged.
        """
        return pulumi.get(self, "audit_types")

    @property
    @pulumi.getter(name="closureComment")
    def closure_comment(self) -> str:
        """
        The comment entered by the operator while closing the request.
        """
        return pulumi.get(self, "closure_comment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the access request.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        Duration in hours for which access is sought on the target resource.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="extendDuration")
    def extend_duration(self) -> int:
        """
        Duration in hours for which extension access is sought on the target resource.
        """
        return pulumi.get(self, "extend_duration")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoApproved")
    def is_auto_approved(self) -> bool:
        """
        Whether the access request was automatically approved.
        """
        return pulumi.get(self, "is_auto_approved")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        more in detail about the lifeCycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="opctlAdditionalMessage")
    def opctl_additional_message(self) -> str:
        """
        Additional message specific to the access request that can be specified by the approver at the time of approval.
        """
        return pulumi.get(self, "opctl_additional_message")

    @property
    @pulumi.getter(name="opctlId")
    def opctl_id(self) -> str:
        """
        The OCID of the operator control governing the target resource.
        """
        return pulumi.get(self, "opctl_id")

    @property
    @pulumi.getter(name="opctlName")
    def opctl_name(self) -> str:
        """
        Name of the Operator control governing the target resource.
        """
        return pulumi.get(self, "opctl_name")

    @property
    @pulumi.getter(name="operatorId")
    def operator_id(self) -> str:
        """
        A unique identifier associated with the operator who raised the request. This identifier can not be used directly to identify the operator. You need to provide this identifier if you would like Oracle to provide additional information about the operator action within Oracle tenancy.
        """
        return pulumi.get(self, "operator_id")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        Summary reason for which the operator is requesting access on the target resource.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> str:
        """
        This is an automatic identifier generated by the system which is easier for human comprehension.
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The OCID of the target resource associated with the access request. The operator raises an access request to get approval to  access the target resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        The name of the target resource.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        resourceType for which the AccessRequest is applicable
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Priority assigned to the access request by the operator
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the AccessRequest.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subResourceLists")
    def sub_resource_lists(self) -> Sequence[str]:
        """
        The subresources requested for approval.
        """
        return pulumi.get(self, "sub_resource_lists")

    @property
    @pulumi.getter(name="systemMessage")
    def system_message(self) -> str:
        """
        System message that will be displayed to the operator at login to the target resource.
        """
        return pulumi.get(self, "system_message")

    @property
    @pulumi.getter(name="timeOfCreation")
    def time_of_creation(self) -> str:
        """
        Time when the access request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_creation")

    @property
    @pulumi.getter(name="timeOfModification")
    def time_of_modification(self) -> str:
        """
        Time when the access request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_modification")

    @property
    @pulumi.getter(name="timeOfUserCreation")
    def time_of_user_creation(self) -> str:
        """
        The time when access request is scheduled to be approved in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_user_creation")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The OCID of the user that last modified the access request.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="workflowIds")
    def workflow_ids(self) -> Sequence[str]:
        """
        The OCID of the workflow associated with the access request. This is needed if you want to contact Oracle Support for a stuck access request or for an access request that encounters an internal error.
        """
        return pulumi.get(self, "workflow_ids")


class AwaitableGetAccessRequestResult(GetAccessRequestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessRequestResult(
            access_reason_summary=self.access_reason_summary,
            access_request_id=self.access_request_id,
            action_requests_lists=self.action_requests_lists,
            approver_comment=self.approver_comment,
            audit_types=self.audit_types,
            closure_comment=self.closure_comment,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            duration=self.duration,
            extend_duration=self.extend_duration,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_auto_approved=self.is_auto_approved,
            lifecycle_details=self.lifecycle_details,
            opctl_additional_message=self.opctl_additional_message,
            opctl_id=self.opctl_id,
            opctl_name=self.opctl_name,
            operator_id=self.operator_id,
            reason=self.reason,
            request_id=self.request_id,
            resource_id=self.resource_id,
            resource_name=self.resource_name,
            resource_type=self.resource_type,
            severity=self.severity,
            state=self.state,
            sub_resource_lists=self.sub_resource_lists,
            system_message=self.system_message,
            time_of_creation=self.time_of_creation,
            time_of_modification=self.time_of_modification,
            time_of_user_creation=self.time_of_user_creation,
            user_id=self.user_id,
            workflow_ids=self.workflow_ids)


def get_access_request(access_request_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessRequestResult:
    """
    This data source provides details about a specific Access Request resource in Oracle Cloud Infrastructure Operator Access Control service.

    Gets details of an access request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_access_request = oci.OperatorAccessControl.get_access_request(access_request_id=oci_operator_access_control_access_request["test_access_request"]["id"])
    ```


    :param str access_request_id: unique AccessRequest identifier
    """
    __args__ = dict()
    __args__['accessRequestId'] = access_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OperatorAccessControl/getAccessRequest:getAccessRequest', __args__, opts=opts, typ=GetAccessRequestResult).value

    return AwaitableGetAccessRequestResult(
        access_reason_summary=pulumi.get(__ret__, 'access_reason_summary'),
        access_request_id=pulumi.get(__ret__, 'access_request_id'),
        action_requests_lists=pulumi.get(__ret__, 'action_requests_lists'),
        approver_comment=pulumi.get(__ret__, 'approver_comment'),
        audit_types=pulumi.get(__ret__, 'audit_types'),
        closure_comment=pulumi.get(__ret__, 'closure_comment'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        duration=pulumi.get(__ret__, 'duration'),
        extend_duration=pulumi.get(__ret__, 'extend_duration'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_auto_approved=pulumi.get(__ret__, 'is_auto_approved'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        opctl_additional_message=pulumi.get(__ret__, 'opctl_additional_message'),
        opctl_id=pulumi.get(__ret__, 'opctl_id'),
        opctl_name=pulumi.get(__ret__, 'opctl_name'),
        operator_id=pulumi.get(__ret__, 'operator_id'),
        reason=pulumi.get(__ret__, 'reason'),
        request_id=pulumi.get(__ret__, 'request_id'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        resource_name=pulumi.get(__ret__, 'resource_name'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        severity=pulumi.get(__ret__, 'severity'),
        state=pulumi.get(__ret__, 'state'),
        sub_resource_lists=pulumi.get(__ret__, 'sub_resource_lists'),
        system_message=pulumi.get(__ret__, 'system_message'),
        time_of_creation=pulumi.get(__ret__, 'time_of_creation'),
        time_of_modification=pulumi.get(__ret__, 'time_of_modification'),
        time_of_user_creation=pulumi.get(__ret__, 'time_of_user_creation'),
        user_id=pulumi.get(__ret__, 'user_id'),
        workflow_ids=pulumi.get(__ret__, 'workflow_ids'))


@_utilities.lift_output_func(get_access_request)
def get_access_request_output(access_request_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccessRequestResult]:
    """
    This data source provides details about a specific Access Request resource in Oracle Cloud Infrastructure Operator Access Control service.

    Gets details of an access request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_access_request = oci.OperatorAccessControl.get_access_request(access_request_id=oci_operator_access_control_access_request["test_access_request"]["id"])
    ```


    :param str access_request_id: unique AccessRequest identifier
    """
    ...
