"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
const k8s = require("./imports/k8s");
const probe_1 = require("./probe");
/**
 * Utility class to implement the conversion between our API and the k8s action
 * structure. Used both for probes and handlers.
 *
 * @internal
 */
class Action {
    static fromTcpSocket(container, options = {}) {
        return {
            port: k8s.IntOrString.fromNumber(options.port ?? container.portNumber ?? 80),
            host: options.host,
        };
    }
    static fromCommand(command) {
        return { command };
    }
    static fromHttpGet(container, path, options = {}) {
        return {
            path,
            port: k8s.IntOrString.fromNumber(options.port ?? container.portNumber ?? 80),
            scheme: toHttpGetActionScheme(options.scheme ?? probe_1.ConnectionScheme.HTTP),
        };
    }
}
exports.Action = Action;
function toHttpGetActionScheme(scheme) {
    return k8s.IoK8SApiCoreV1HttpGetActionScheme[probe_1.ConnectionScheme[scheme]];
}
//# sourceMappingURL=data:application/json;base64,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