# Solidity Basics to Advanced Concepts

Welcome — this repository contains small, focused Solidity example contracts grouped by topic. Use the dropdowns below to explore each folder. The sections use HTML <details> so they expand/collapse when clicked (supported on GitHub and most Markdown renderers).

<!-- Solidity folder list with collapsible sections -->

  # Solidity Basics to Advanced Concepts
<details>

  Welcome — this repository contains small, focused Solidity example contracts grouped by topic. Use the dropdowns below to explore each folder. The sections use HTML <details> so they expand/collapse when clicked (supported on GitHub and most Markdown renderers).

  <!-- Solidity folder list with collapsible sections -->

  ## Solidity Basics (folders)

  ### 01_data-types
  <details>
    <summary>Data types</summary>

    - <a href="01_data-types/DataTypes.sol">DataTypes.sol</a>
    - <a href="01_data-types/SolidityOperations.sol">SolidityOperations.sol</a>

  </details>

  ### 02_contructors
  <details>
    <summary>Constructors</summary>

    - <a href="02_contructors/Constructor.sol">Constructor.sol</a>

  </details>

  ### 03_variables
  <details>
    <summary>Variables</summary>

    - <a href="03_variables/Variables.sol">Variables.sol</a>

  </details>

  ### 04_functions
  <details>
    <summary>Functions</summary>

    - <a href="04_functions/Functions.sol">Functions.sol</a>

  </details>

  ### 05_visibility
  <details>
    <summary>Function visibility</summary>

    - <a href="05_visibility/FunctionVisibility.sol">FunctionVisibility.sol</a>

  </details>

  ### 06_pure_and_view_functions
  <details>
    <summary>Pure and view functions</summary>

    - <a href="06_pure_and_view_functions/PureAndViewFunction.sol">PureAndViewFunction.sol</a>

  </details>

  ### 07_function_modifiers
  <details>
    <summary>Function modifiers</summary>

    - <a href="07_function_modifiers/Modifiers.sol">Modifiers.sol</a>

  </details>

  ### 09_events
  <details>
    <summary>Events</summary>

    - <a href="09_events/Events.sol">Events.sol</a>

  </details>

  ### 10_error_handling
  <details>
    <summary>Error handling</summary>

    - <a href="10_error_handling/ErrorHandling.sol">ErrorHandling.sol</a>

  </details>

  ### 11_fallback_function
  <details>
    <summary>Fallback functions</summary>

    - <a href="11_fallback_function/Fallback.sol">Fallback.sol</a>

  </details>

  ### 12_for_loop
  <details>
    <summary>For loop</summary>

    - <a href="12_for_loop/ForLoop.sol">ForLoop.sol</a>

  </details>

  ### 13_array
  <details>
    <summary>Array examples</summary>

    - <a href="13_array/Array.sol">Array.sol</a>

  </details>

  ### 14_mapping
  <details>
    <summary>Mappings</summary>

    - <a href="14_mapping/Mapping.sol">Mapping.sol</a>
    - <a href="14_mapping/NestedMapping.sol">NestedMapping.sol</a>

  </details>

  ### 15_enum
  <details>
    <summary>Enums</summary>

    - <a href="15_enum/Enum.sol">Enum.sol</a>

  </details>

  ### 16_struct
  <details>
    <summary>Structs</summary>

    - <a href="16_struct/Struct.sol">Struct.sol</a>

  </details>

  ### 17_payable_modifier
  <details>
    <summary>Payable modifier</summary>

    - <a href="17_payable_modifier/Payable.sol">Payable.sol</a>

  </details>

  ### 18_imports
  <details>
    <summary>Imports</summary>

    - <a href="18_imports/Contract1.sol">Contract1.sol</a>
    - <a href="18_imports/Contract2.sol">Contract2.sol</a>

  </details>

  ### 19_contract_cleanup
  <details>
    <summary>Contract cleanup</summary>

    - <a href="19_contract_cleanup/Cleanup.sol">Cleanup.sol</a>

  </details>

  ### 20_memory_and_storage
  <details>
    <summary>Memory and storage</summary>

    - <a href="20_memory_and_storage/MemoryAndStorage.sol">MemoryAndStorage.sol</a>

  </details>

  ### 21_inheritance
  <details>
    <summary>Inheritance</summary>

    - <a href="21_inheritance/Inheritance.sol">Inheritance.sol</a>

  </details>

  ### 22_if_statement
  <details>
    <summary>If statements</summary>

    - <a href="22_if_statement/if-statement.sol">if-statement.sol</a>

  </details>

  ### 23_libraries
  <details>
    <summary>Libraries</summary>

    - <a href="23_libraries/libraries.sol">libraries.sol</a>
    - <a href="23_libraries/safemath.sol">safemath.sol</a>

  </details>

  ### 24_interface
  <details>
    <summary>Interfaces</summary>

    # Solidity Basics to Advanced Concepts

    A small collection of focused Solidity example contracts organized by topic. Click a folder to expand its files. The lists use HTML <details> which render on GitHub and most Markdown viewers.

    ---

    ### 01_data-types — Basic data types
    Examples of Solidity primitive and composite types: ints, uints, bools, address, bytes, strings, arrays, structs and enums.
    <details>
    <summary>Files</summary>

    - [DataTypes.sol](01_data-types/DataTypes.sol) — type examples
    - [SolidityOperations.sol](01_data-types/SolidityOperations.sol) — operations and examples

    </details>

    ### 02_contructors — Constructors
    How to initialize contracts and use constructor parameters.
    <details>
    <summary>Files</summary>

    - [Constructor.sol](02_contructors/Constructor.sol)

    </details>

    ### 03_variables — State & local variables
    Examples showing state variables, local variables and global variables (msg, block).
    <details>
    <summary>Files</summary>

    - [Variables.sol](03_variables/Variables.sol)

    </details>

    ### 04_functions — Functions
    Function definitions, visibility, view/pure vs transactions.
    <details>
    <summary>Files</summary>

    - [Functions.sol](04_functions/Functions.sol)

    </details>

    ### 05_visibility — Function & state visibility
    Demonstrates public, private, internal and external.
    <details>
    <summary>Files</summary>

    - [FunctionVisibility.sol](05_visibility/FunctionVisibility.sol)

    </details>

    ### 06_pure_and_view_functions — Pure & view
    Read-only functions vs pure functions that don't read state.
    <details>
    <summary>Files</summary>

    - [PureAndViewFunction.sol](06_pure_and_view_functions/PureAndViewFunction.sol)

    </details>

    ### 07_function_modifiers — Modifiers
    Using modifiers to guard or change behavior (e.g., onlyOwner).
    <details>
    <summary>Files</summary>

    - [Modifiers.sol](07_function_modifiers/Modifiers.sol)

    </details>

    ### 09_events — Events
    How to declare and emit events for off-chain listeners.
    <details>
    <summary>Files</summary>

    - [Events.sol](09_events/Events.sol)

    </details>

    ### 10_error_handling — Errors, require, revert, assert
    Safe patterns for input validation and error handling.
    <details>
    <summary>Files</summary>

    - [ErrorHandling.sol](10_error_handling/ErrorHandling.sol)

    </details>

    ### 11_fallback_function — Receive & fallback
    Fallback and receive functions to handle plain transfers and unknown calls.
    <details>
    <summary>Files</summary>

    - [Fallback.sol](11_fallback_function/Fallback.sol)

    </details>

    ### 12_for_loop — Loops
    Simple for-loop examples in Solidity.
    <details>
    <summary>Files</summary>

    - [ForLoop.sol](12_for_loop/ForLoop.sol)

    </details>

    ### 13_array — Arrays
    Fixed-size and dynamic array usage.
    <details>
    <summary>Files</summary>

    - [Array.sol](13_array/Array.sol)

    </details>

    ### 14_mapping — Mappings
    Single and nested mappings for key-value storage.
    <details>
    <summary>Files</summary>

    - [Mapping.sol](14_mapping/Mapping.sol)
    - [NestedMapping.sol](14_mapping/NestedMapping.sol)

    </details>

    ### 15_enum — Enums
    Using enums for state and control flow.
    <details>
    <summary>Files</summary>

    - [Enum.sol](15_enum/Enum.sol)

    </details>

    ### 16_struct — Structs
    Custom data types with structs.
    <details>
    <summary>Files</summary>

    - [Struct.sol](16_struct/Struct.sol)

    </details>

    ### 17_payable_modifier — Payable functions
    Examples showing payable functions and receiving ether.
    <details>
    <summary>Files</summary>

    - [Payable.sol](17_payable_modifier/Payable.sol)

    </details>

    ### 18_imports — Imports & modular contracts
    How to split code across files and import contracts/libraries.
    <details>
    <summary>Files</summary>

    - [Contract1.sol](18_imports/Contract1.sol)
    - [Contract2.sol](18_imports/Contract2.sol)

    </details>

    ### 19_contract_cleanup — Contract maintenance
    Patterns for cleaning up contracts (selfdestruct, ownership transfer, etc.).
    <details>
    <summary>Files</summary>

    - [Cleanup.sol](19_contract_cleanup/Cleanup.sol)

    </details>

    ### 20_memory_and_storage — Memory vs storage
    Differences between memory and storage and how to use them.
    <details>
    <summary>Files</summary>

    - [MemoryAndStorage.sol](20_memory_and_storage/MemoryAndStorage.sol)

    </details>

    ### 21_inheritance — Inheritance & overrides
    Contract inheritance examples and method overriding.
    <details>
    <summary>Files</summary>

    - [Inheritance.sol](21_inheritance/Inheritance.sol)

    </details>

    ### 22_if_statement — Conditionals
    If/else examples and control flow.
    <details>
    <summary>Files</summary>

    - [if-statement.sol](22_if_statement/if-statement.sol)

    </details>

    ### 23_libraries — Libraries & SafeMath
    Reusable libraries and safety helpers like SafeMath.
    <details>
    <summary>Files</summary>

    - [libraries.sol](23_libraries/libraries.sol)
    - [safemath.sol](23_libraries/safemath.sol)

    </details>

    ### 24_interface — Interfaces
    Using interfaces to interact with external contracts.
    <details>
    <summary>Files</summary>

    - [interface.sol](24_interface/interface.sol)

    </details>

    ---

    Notes
    - Click a folder's header to expand (GitHub supports <details>).
    - To preview locally open this repo in VS Code and use the Markdown preview (or view on GitHub).

    Happy learning!
