# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotebookSessionArgs', 'NotebookSession']

@pulumi.input_type
class NotebookSessionArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 notebook_session_config_details: Optional[pulumi.Input['NotebookSessionNotebookSessionConfigDetailsArgs']] = None,
                 notebook_session_configuration_details: Optional[pulumi.Input['NotebookSessionNotebookSessionConfigurationDetailsArgs']] = None,
                 notebook_session_runtime_config_details: Optional[pulumi.Input['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs']] = None,
                 notebook_session_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NotebookSession resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the notebook session.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the notebook session.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My NotebookSession`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['NotebookSessionNotebookSessionConfigDetailsArgs'] notebook_session_config_details: Details for the notebook session configuration.
        :param pulumi.Input['NotebookSessionNotebookSessionConfigurationDetailsArgs'] notebook_session_configuration_details: (Updatable) Details for the notebook session configuration.
        :param pulumi.Input['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs'] notebook_session_runtime_config_details: (Updatable) Notebook Session runtime configuration details.
        :param pulumi.Input[Sequence[pulumi.Input['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs']]] notebook_session_storage_mount_configuration_details_lists: (Updatable) Collection of NotebookSessionStorageMountConfigurationDetails.
        :param pulumi.Input[str] state: The state of the notebook session.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "project_id", project_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if notebook_session_config_details is not None:
            pulumi.set(__self__, "notebook_session_config_details", notebook_session_config_details)
        if notebook_session_configuration_details is not None:
            pulumi.set(__self__, "notebook_session_configuration_details", notebook_session_configuration_details)
        if notebook_session_runtime_config_details is not None:
            pulumi.set(__self__, "notebook_session_runtime_config_details", notebook_session_runtime_config_details)
        if notebook_session_storage_mount_configuration_details_lists is not None:
            pulumi.set(__self__, "notebook_session_storage_mount_configuration_details_lists", notebook_session_storage_mount_configuration_details_lists)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the notebook session.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the notebook session.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My NotebookSession`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="notebookSessionConfigDetails")
    def notebook_session_config_details(self) -> Optional[pulumi.Input['NotebookSessionNotebookSessionConfigDetailsArgs']]:
        """
        Details for the notebook session configuration.
        """
        return pulumi.get(self, "notebook_session_config_details")

    @notebook_session_config_details.setter
    def notebook_session_config_details(self, value: Optional[pulumi.Input['NotebookSessionNotebookSessionConfigDetailsArgs']]):
        pulumi.set(self, "notebook_session_config_details", value)

    @property
    @pulumi.getter(name="notebookSessionConfigurationDetails")
    def notebook_session_configuration_details(self) -> Optional[pulumi.Input['NotebookSessionNotebookSessionConfigurationDetailsArgs']]:
        """
        (Updatable) Details for the notebook session configuration.
        """
        return pulumi.get(self, "notebook_session_configuration_details")

    @notebook_session_configuration_details.setter
    def notebook_session_configuration_details(self, value: Optional[pulumi.Input['NotebookSessionNotebookSessionConfigurationDetailsArgs']]):
        pulumi.set(self, "notebook_session_configuration_details", value)

    @property
    @pulumi.getter(name="notebookSessionRuntimeConfigDetails")
    def notebook_session_runtime_config_details(self) -> Optional[pulumi.Input['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs']]:
        """
        (Updatable) Notebook Session runtime configuration details.
        """
        return pulumi.get(self, "notebook_session_runtime_config_details")

    @notebook_session_runtime_config_details.setter
    def notebook_session_runtime_config_details(self, value: Optional[pulumi.Input['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs']]):
        pulumi.set(self, "notebook_session_runtime_config_details", value)

    @property
    @pulumi.getter(name="notebookSessionStorageMountConfigurationDetailsLists")
    def notebook_session_storage_mount_configuration_details_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs']]]]:
        """
        (Updatable) Collection of NotebookSessionStorageMountConfigurationDetails.
        """
        return pulumi.get(self, "notebook_session_storage_mount_configuration_details_lists")

    @notebook_session_storage_mount_configuration_details_lists.setter
    def notebook_session_storage_mount_configuration_details_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs']]]]):
        pulumi.set(self, "notebook_session_storage_mount_configuration_details_lists", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the notebook session.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _NotebookSessionState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 notebook_session_config_details: Optional[pulumi.Input['NotebookSessionNotebookSessionConfigDetailsArgs']] = None,
                 notebook_session_configuration_details: Optional[pulumi.Input['NotebookSessionNotebookSessionConfigurationDetailsArgs']] = None,
                 notebook_session_runtime_config_details: Optional[pulumi.Input['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs']] = None,
                 notebook_session_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs']]]] = None,
                 notebook_session_url: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NotebookSession resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the notebook session.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the notebook session.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My NotebookSession`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: Details about the state of the notebook session.
        :param pulumi.Input['NotebookSessionNotebookSessionConfigDetailsArgs'] notebook_session_config_details: Details for the notebook session configuration.
        :param pulumi.Input['NotebookSessionNotebookSessionConfigurationDetailsArgs'] notebook_session_configuration_details: (Updatable) Details for the notebook session configuration.
        :param pulumi.Input['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs'] notebook_session_runtime_config_details: (Updatable) Notebook Session runtime configuration details.
        :param pulumi.Input[Sequence[pulumi.Input['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs']]] notebook_session_storage_mount_configuration_details_lists: (Updatable) Collection of NotebookSessionStorageMountConfigurationDetails.
        :param pulumi.Input[str] notebook_session_url: The URL to interact with the notebook session.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the notebook session.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The state of the notebook session.
        :param pulumi.Input[str] time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if notebook_session_config_details is not None:
            pulumi.set(__self__, "notebook_session_config_details", notebook_session_config_details)
        if notebook_session_configuration_details is not None:
            pulumi.set(__self__, "notebook_session_configuration_details", notebook_session_configuration_details)
        if notebook_session_runtime_config_details is not None:
            pulumi.set(__self__, "notebook_session_runtime_config_details", notebook_session_runtime_config_details)
        if notebook_session_storage_mount_configuration_details_lists is not None:
            pulumi.set(__self__, "notebook_session_storage_mount_configuration_details_lists", notebook_session_storage_mount_configuration_details_lists)
        if notebook_session_url is not None:
            pulumi.set(__self__, "notebook_session_url", notebook_session_url)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the notebook session.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the notebook session.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My NotebookSession`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the state of the notebook session.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="notebookSessionConfigDetails")
    def notebook_session_config_details(self) -> Optional[pulumi.Input['NotebookSessionNotebookSessionConfigDetailsArgs']]:
        """
        Details for the notebook session configuration.
        """
        return pulumi.get(self, "notebook_session_config_details")

    @notebook_session_config_details.setter
    def notebook_session_config_details(self, value: Optional[pulumi.Input['NotebookSessionNotebookSessionConfigDetailsArgs']]):
        pulumi.set(self, "notebook_session_config_details", value)

    @property
    @pulumi.getter(name="notebookSessionConfigurationDetails")
    def notebook_session_configuration_details(self) -> Optional[pulumi.Input['NotebookSessionNotebookSessionConfigurationDetailsArgs']]:
        """
        (Updatable) Details for the notebook session configuration.
        """
        return pulumi.get(self, "notebook_session_configuration_details")

    @notebook_session_configuration_details.setter
    def notebook_session_configuration_details(self, value: Optional[pulumi.Input['NotebookSessionNotebookSessionConfigurationDetailsArgs']]):
        pulumi.set(self, "notebook_session_configuration_details", value)

    @property
    @pulumi.getter(name="notebookSessionRuntimeConfigDetails")
    def notebook_session_runtime_config_details(self) -> Optional[pulumi.Input['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs']]:
        """
        (Updatable) Notebook Session runtime configuration details.
        """
        return pulumi.get(self, "notebook_session_runtime_config_details")

    @notebook_session_runtime_config_details.setter
    def notebook_session_runtime_config_details(self, value: Optional[pulumi.Input['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs']]):
        pulumi.set(self, "notebook_session_runtime_config_details", value)

    @property
    @pulumi.getter(name="notebookSessionStorageMountConfigurationDetailsLists")
    def notebook_session_storage_mount_configuration_details_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs']]]]:
        """
        (Updatable) Collection of NotebookSessionStorageMountConfigurationDetails.
        """
        return pulumi.get(self, "notebook_session_storage_mount_configuration_details_lists")

    @notebook_session_storage_mount_configuration_details_lists.setter
    def notebook_session_storage_mount_configuration_details_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs']]]]):
        pulumi.set(self, "notebook_session_storage_mount_configuration_details_lists", value)

    @property
    @pulumi.getter(name="notebookSessionUrl")
    def notebook_session_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to interact with the notebook session.
        """
        return pulumi.get(self, "notebook_session_url")

    @notebook_session_url.setter
    def notebook_session_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notebook_session_url", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the notebook session.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the notebook session.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class NotebookSession(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 notebook_session_config_details: Optional[pulumi.Input[Union['NotebookSessionNotebookSessionConfigDetailsArgs', 'NotebookSessionNotebookSessionConfigDetailsArgsDict']]] = None,
                 notebook_session_configuration_details: Optional[pulumi.Input[Union['NotebookSessionNotebookSessionConfigurationDetailsArgs', 'NotebookSessionNotebookSessionConfigurationDetailsArgsDict']]] = None,
                 notebook_session_runtime_config_details: Optional[pulumi.Input[Union['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs', 'NotebookSessionNotebookSessionRuntimeConfigDetailsArgsDict']]] = None,
                 notebook_session_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs', 'NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Notebook Session resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new notebook session.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_notebook_session = oci.data_science.NotebookSession("test_notebook_session",
            compartment_id=compartment_id,
            project_id=test_project["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=notebook_session_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            notebook_session_config_details={
                "shape": notebook_session_notebook_session_config_details_shape,
                "block_storage_size_in_gbs": notebook_session_notebook_session_config_details_block_storage_size_in_gbs,
                "notebook_session_shape_config_details": {
                    "memory_in_gbs": notebook_session_notebook_session_config_details_notebook_session_shape_config_details_memory_in_gbs,
                    "ocpus": notebook_session_notebook_session_config_details_notebook_session_shape_config_details_ocpus,
                },
                "private_endpoint_id": test_private_endpoint["id"],
                "subnet_id": test_subnet["id"],
            },
            notebook_session_configuration_details={
                "shape": notebook_session_notebook_session_configuration_details_shape,
                "subnet_id": test_subnet["id"],
                "block_storage_size_in_gbs": notebook_session_notebook_session_configuration_details_block_storage_size_in_gbs,
                "notebook_session_shape_config_details": {
                    "memory_in_gbs": notebook_session_notebook_session_configuration_details_notebook_session_shape_config_details_memory_in_gbs,
                    "ocpus": notebook_session_notebook_session_configuration_details_notebook_session_shape_config_details_ocpus,
                },
                "private_endpoint_id": test_private_endpoint["id"],
            },
            notebook_session_runtime_config_details={
                "custom_environment_variables": notebook_session_notebook_session_runtime_config_details_custom_environment_variables,
                "notebook_session_git_config_details": {
                    "notebook_session_git_repo_config_collections": [{
                        "url": notebook_session_notebook_session_runtime_config_details_notebook_session_git_config_details_notebook_session_git_repo_config_collection_url,
                    }],
                },
            },
            notebook_session_storage_mount_configuration_details_lists=[{
                "destination_directory_name": notebook_session_notebook_session_storage_mount_configuration_details_list_destination_directory_name,
                "storage_type": notebook_session_notebook_session_storage_mount_configuration_details_list_storage_type,
                "bucket": notebook_session_notebook_session_storage_mount_configuration_details_list_bucket,
                "destination_path": notebook_session_notebook_session_storage_mount_configuration_details_list_destination_path,
                "export_id": test_export["id"],
                "mount_target_id": test_mount_target["id"],
                "namespace": notebook_session_notebook_session_storage_mount_configuration_details_list_namespace,
                "prefix": notebook_session_notebook_session_storage_mount_configuration_details_list_prefix,
            }])
        ```

        ## Import

        NotebookSessions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/notebookSession:NotebookSession test_notebook_session "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the notebook session.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My NotebookSession`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['NotebookSessionNotebookSessionConfigDetailsArgs', 'NotebookSessionNotebookSessionConfigDetailsArgsDict']] notebook_session_config_details: Details for the notebook session configuration.
        :param pulumi.Input[Union['NotebookSessionNotebookSessionConfigurationDetailsArgs', 'NotebookSessionNotebookSessionConfigurationDetailsArgsDict']] notebook_session_configuration_details: (Updatable) Details for the notebook session configuration.
        :param pulumi.Input[Union['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs', 'NotebookSessionNotebookSessionRuntimeConfigDetailsArgsDict']] notebook_session_runtime_config_details: (Updatable) Notebook Session runtime configuration details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs', 'NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgsDict']]]] notebook_session_storage_mount_configuration_details_lists: (Updatable) Collection of NotebookSessionStorageMountConfigurationDetails.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the notebook session.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The state of the notebook session.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotebookSessionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Notebook Session resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new notebook session.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_notebook_session = oci.data_science.NotebookSession("test_notebook_session",
            compartment_id=compartment_id,
            project_id=test_project["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=notebook_session_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            notebook_session_config_details={
                "shape": notebook_session_notebook_session_config_details_shape,
                "block_storage_size_in_gbs": notebook_session_notebook_session_config_details_block_storage_size_in_gbs,
                "notebook_session_shape_config_details": {
                    "memory_in_gbs": notebook_session_notebook_session_config_details_notebook_session_shape_config_details_memory_in_gbs,
                    "ocpus": notebook_session_notebook_session_config_details_notebook_session_shape_config_details_ocpus,
                },
                "private_endpoint_id": test_private_endpoint["id"],
                "subnet_id": test_subnet["id"],
            },
            notebook_session_configuration_details={
                "shape": notebook_session_notebook_session_configuration_details_shape,
                "subnet_id": test_subnet["id"],
                "block_storage_size_in_gbs": notebook_session_notebook_session_configuration_details_block_storage_size_in_gbs,
                "notebook_session_shape_config_details": {
                    "memory_in_gbs": notebook_session_notebook_session_configuration_details_notebook_session_shape_config_details_memory_in_gbs,
                    "ocpus": notebook_session_notebook_session_configuration_details_notebook_session_shape_config_details_ocpus,
                },
                "private_endpoint_id": test_private_endpoint["id"],
            },
            notebook_session_runtime_config_details={
                "custom_environment_variables": notebook_session_notebook_session_runtime_config_details_custom_environment_variables,
                "notebook_session_git_config_details": {
                    "notebook_session_git_repo_config_collections": [{
                        "url": notebook_session_notebook_session_runtime_config_details_notebook_session_git_config_details_notebook_session_git_repo_config_collection_url,
                    }],
                },
            },
            notebook_session_storage_mount_configuration_details_lists=[{
                "destination_directory_name": notebook_session_notebook_session_storage_mount_configuration_details_list_destination_directory_name,
                "storage_type": notebook_session_notebook_session_storage_mount_configuration_details_list_storage_type,
                "bucket": notebook_session_notebook_session_storage_mount_configuration_details_list_bucket,
                "destination_path": notebook_session_notebook_session_storage_mount_configuration_details_list_destination_path,
                "export_id": test_export["id"],
                "mount_target_id": test_mount_target["id"],
                "namespace": notebook_session_notebook_session_storage_mount_configuration_details_list_namespace,
                "prefix": notebook_session_notebook_session_storage_mount_configuration_details_list_prefix,
            }])
        ```

        ## Import

        NotebookSessions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/notebookSession:NotebookSession test_notebook_session "id"
        ```

        :param str resource_name: The name of the resource.
        :param NotebookSessionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotebookSessionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 notebook_session_config_details: Optional[pulumi.Input[Union['NotebookSessionNotebookSessionConfigDetailsArgs', 'NotebookSessionNotebookSessionConfigDetailsArgsDict']]] = None,
                 notebook_session_configuration_details: Optional[pulumi.Input[Union['NotebookSessionNotebookSessionConfigurationDetailsArgs', 'NotebookSessionNotebookSessionConfigurationDetailsArgsDict']]] = None,
                 notebook_session_runtime_config_details: Optional[pulumi.Input[Union['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs', 'NotebookSessionNotebookSessionRuntimeConfigDetailsArgsDict']]] = None,
                 notebook_session_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs', 'NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotebookSessionArgs.__new__(NotebookSessionArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["notebook_session_config_details"] = notebook_session_config_details
            __props__.__dict__["notebook_session_configuration_details"] = notebook_session_configuration_details
            __props__.__dict__["notebook_session_runtime_config_details"] = notebook_session_runtime_config_details
            __props__.__dict__["notebook_session_storage_mount_configuration_details_lists"] = notebook_session_storage_mount_configuration_details_lists
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["state"] = state
            __props__.__dict__["created_by"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["notebook_session_url"] = None
            __props__.__dict__["time_created"] = None
        super(NotebookSession, __self__).__init__(
            'oci:DataScience/notebookSession:NotebookSession',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            notebook_session_config_details: Optional[pulumi.Input[Union['NotebookSessionNotebookSessionConfigDetailsArgs', 'NotebookSessionNotebookSessionConfigDetailsArgsDict']]] = None,
            notebook_session_configuration_details: Optional[pulumi.Input[Union['NotebookSessionNotebookSessionConfigurationDetailsArgs', 'NotebookSessionNotebookSessionConfigurationDetailsArgsDict']]] = None,
            notebook_session_runtime_config_details: Optional[pulumi.Input[Union['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs', 'NotebookSessionNotebookSessionRuntimeConfigDetailsArgsDict']]] = None,
            notebook_session_storage_mount_configuration_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs', 'NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgsDict']]]]] = None,
            notebook_session_url: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'NotebookSession':
        """
        Get an existing NotebookSession resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the notebook session.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the notebook session.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My NotebookSession`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: Details about the state of the notebook session.
        :param pulumi.Input[Union['NotebookSessionNotebookSessionConfigDetailsArgs', 'NotebookSessionNotebookSessionConfigDetailsArgsDict']] notebook_session_config_details: Details for the notebook session configuration.
        :param pulumi.Input[Union['NotebookSessionNotebookSessionConfigurationDetailsArgs', 'NotebookSessionNotebookSessionConfigurationDetailsArgsDict']] notebook_session_configuration_details: (Updatable) Details for the notebook session configuration.
        :param pulumi.Input[Union['NotebookSessionNotebookSessionRuntimeConfigDetailsArgs', 'NotebookSessionNotebookSessionRuntimeConfigDetailsArgsDict']] notebook_session_runtime_config_details: (Updatable) Notebook Session runtime configuration details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgs', 'NotebookSessionNotebookSessionStorageMountConfigurationDetailsListArgsDict']]]] notebook_session_storage_mount_configuration_details_lists: (Updatable) Collection of NotebookSessionStorageMountConfigurationDetails.
        :param pulumi.Input[str] notebook_session_url: The URL to interact with the notebook session.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the notebook session.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The state of the notebook session.
        :param pulumi.Input[str] time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotebookSessionState.__new__(_NotebookSessionState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["notebook_session_config_details"] = notebook_session_config_details
        __props__.__dict__["notebook_session_configuration_details"] = notebook_session_configuration_details
        __props__.__dict__["notebook_session_runtime_config_details"] = notebook_session_runtime_config_details
        __props__.__dict__["notebook_session_storage_mount_configuration_details_lists"] = notebook_session_storage_mount_configuration_details_lists
        __props__.__dict__["notebook_session_url"] = notebook_session_url
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return NotebookSession(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the notebook session.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the notebook session.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My NotebookSession`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the state of the notebook session.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="notebookSessionConfigDetails")
    def notebook_session_config_details(self) -> pulumi.Output['outputs.NotebookSessionNotebookSessionConfigDetails']:
        """
        Details for the notebook session configuration.
        """
        return pulumi.get(self, "notebook_session_config_details")

    @property
    @pulumi.getter(name="notebookSessionConfigurationDetails")
    def notebook_session_configuration_details(self) -> pulumi.Output['outputs.NotebookSessionNotebookSessionConfigurationDetails']:
        """
        (Updatable) Details for the notebook session configuration.
        """
        return pulumi.get(self, "notebook_session_configuration_details")

    @property
    @pulumi.getter(name="notebookSessionRuntimeConfigDetails")
    def notebook_session_runtime_config_details(self) -> pulumi.Output['outputs.NotebookSessionNotebookSessionRuntimeConfigDetails']:
        """
        (Updatable) Notebook Session runtime configuration details.
        """
        return pulumi.get(self, "notebook_session_runtime_config_details")

    @property
    @pulumi.getter(name="notebookSessionStorageMountConfigurationDetailsLists")
    def notebook_session_storage_mount_configuration_details_lists(self) -> pulumi.Output[Sequence['outputs.NotebookSessionNotebookSessionStorageMountConfigurationDetailsList']]:
        """
        (Updatable) Collection of NotebookSessionStorageMountConfigurationDetails.
        """
        return pulumi.get(self, "notebook_session_storage_mount_configuration_details_lists")

    @property
    @pulumi.getter(name="notebookSessionUrl")
    def notebook_session_url(self) -> pulumi.Output[str]:
        """
        The URL to interact with the notebook session.
        """
        return pulumi.get(self, "notebook_session_url")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the notebook session.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the notebook session.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

