# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAlarmSuppressionsResult',
    'AwaitableGetAlarmSuppressionsResult',
    'get_alarm_suppressions',
    'get_alarm_suppressions_output',
]

@pulumi.output_type
class GetAlarmSuppressionsResult:
    """
    A collection of values returned by getAlarmSuppressions.
    """
    def __init__(__self__, alarm_id=None, alarm_suppression_collections=None, display_name=None, filters=None, id=None, state=None):
        if alarm_id and not isinstance(alarm_id, str):
            raise TypeError("Expected argument 'alarm_id' to be a str")
        pulumi.set(__self__, "alarm_id", alarm_id)
        if alarm_suppression_collections and not isinstance(alarm_suppression_collections, list):
            raise TypeError("Expected argument 'alarm_suppression_collections' to be a list")
        pulumi.set(__self__, "alarm_suppression_collections", alarm_suppression_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_id")

    @property
    @pulumi.getter(name="alarmSuppressionCollections")
    def alarm_suppression_collections(self) -> Sequence['outputs.GetAlarmSuppressionsAlarmSuppressionCollectionResult']:
        """
        The list of alarm_suppression_collection.
        """
        return pulumi.get(self, "alarm_suppression_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAlarmSuppressionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the alarm suppression.  Example: `DELETED`
        """
        return pulumi.get(self, "state")


class AwaitableGetAlarmSuppressionsResult(GetAlarmSuppressionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlarmSuppressionsResult(
            alarm_id=self.alarm_id,
            alarm_suppression_collections=self.alarm_suppression_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_alarm_suppressions(alarm_id: Optional[str] = None,
                           display_name: Optional[str] = None,
                           filters: Optional[Sequence[Union['GetAlarmSuppressionsFilterArgs', 'GetAlarmSuppressionsFilterArgsDict']]] = None,
                           state: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlarmSuppressionsResult:
    """
    This data source provides the list of Alarm Suppressions in Oracle Cloud Infrastructure Monitoring service.

    Lists alarm suppressions for the specified alarm.
    Only dimension-level suppressions are listed. Alarm-level suppressions are not listed.

    For important limits information, see
    [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

    This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
    Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
    or transactions, per second (TPS) for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alarm_suppressions = oci.Monitoring.get_alarm_suppressions(alarm_id=test_alarm["id"],
        display_name=alarm_suppression_display_name,
        state=alarm_suppression_state)
    ```


    :param str alarm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
    :param str display_name: A filter to return only resources that match the given display name exactly. Use this filter to list a alarm suppression by name. Alternatively, when you know the alarm suppression OCID, use the GetAlarmSuppression operation.
    :param str state: A filter to return only resources that match the given lifecycle state exactly. When not specified, only resources in the ACTIVE lifecycle state are listed.
    """
    __args__ = dict()
    __args__['alarmId'] = alarm_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Monitoring/getAlarmSuppressions:getAlarmSuppressions', __args__, opts=opts, typ=GetAlarmSuppressionsResult).value

    return AwaitableGetAlarmSuppressionsResult(
        alarm_id=pulumi.get(__ret__, 'alarm_id'),
        alarm_suppression_collections=pulumi.get(__ret__, 'alarm_suppression_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_alarm_suppressions)
def get_alarm_suppressions_output(alarm_id: Optional[pulumi.Input[str]] = None,
                                  display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAlarmSuppressionsFilterArgs', 'GetAlarmSuppressionsFilterArgsDict']]]]] = None,
                                  state: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlarmSuppressionsResult]:
    """
    This data source provides the list of Alarm Suppressions in Oracle Cloud Infrastructure Monitoring service.

    Lists alarm suppressions for the specified alarm.
    Only dimension-level suppressions are listed. Alarm-level suppressions are not listed.

    For important limits information, see
    [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

    This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
    Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
    or transactions, per second (TPS) for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alarm_suppressions = oci.Monitoring.get_alarm_suppressions(alarm_id=test_alarm["id"],
        display_name=alarm_suppression_display_name,
        state=alarm_suppression_state)
    ```


    :param str alarm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm that is the target of the alarm suppression.
    :param str display_name: A filter to return only resources that match the given display name exactly. Use this filter to list a alarm suppression by name. Alternatively, when you know the alarm suppression OCID, use the GetAlarmSuppression operation.
    :param str state: A filter to return only resources that match the given lifecycle state exactly. When not specified, only resources in the ACTIVE lifecycle state are listed.
    """
    ...
