# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetNamespaceResult',
    'AwaitableGetNamespaceResult',
    'get_namespace',
    'get_namespace_output',
]

@pulumi.output_type
class GetNamespaceResult:
    """
    A collection of values returned by getNamespace.
    """
    def __init__(__self__, compartment_id=None, id=None, namespace=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        (Computed) The name of the user's namespace.
        """
        return pulumi.get(self, "namespace")


class AwaitableGetNamespaceResult(GetNamespaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespaceResult(
            compartment_id=self.compartment_id,
            id=self.id,
            namespace=self.namespace)


def get_namespace(compartment_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespaceResult:
    """
    This data source provides details about a specific Namespace resource in Oracle Cloud Infrastructure Object Storage service.

    Each Oracle Cloud Infrastructure tenant is assigned one unique and uneditable Object Storage namespace. The namespace
    is a system-generated string assigned during account creation. For some older tenancies, the namespace string may be
    the tenancy name in all lower-case letters. You cannot edit a namespace.

    GetNamespace returns the name of the Object Storage namespace for the user making the request.
    If an optional compartmentId query parameter is provided, GetNamespace returns the namespace name of the corresponding
    tenancy, provided the user has access to it.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace = oci.ObjectStorage.get_namespace(compartment_id=compartment_id)
    ```


    :param str compartment_id: This is an optional field representing either the tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) or the compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) within the tenancy whose Object Storage namespace is to be retrieved.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ObjectStorage/getNamespace:getNamespace', __args__, opts=opts, typ=GetNamespaceResult).value

    return AwaitableGetNamespaceResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'))


@_utilities.lift_output_func(get_namespace)
def get_namespace_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNamespaceResult]:
    """
    This data source provides details about a specific Namespace resource in Oracle Cloud Infrastructure Object Storage service.

    Each Oracle Cloud Infrastructure tenant is assigned one unique and uneditable Object Storage namespace. The namespace
    is a system-generated string assigned during account creation. For some older tenancies, the namespace string may be
    the tenancy name in all lower-case letters. You cannot edit a namespace.

    GetNamespace returns the name of the Object Storage namespace for the user making the request.
    If an optional compartmentId query parameter is provided, GetNamespace returns the namespace name of the corresponding
    tenancy, provided the user has access to it.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace = oci.ObjectStorage.get_namespace(compartment_id=compartment_id)
    ```


    :param str compartment_id: This is an optional field representing either the tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) or the compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) within the tenancy whose Object Storage namespace is to be retrieved.
    """
    ...
