# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetProtectedDatabaseResult',
    'AwaitableGetProtectedDatabaseResult',
    'get_protected_database',
    'get_protected_database_output',
]

@pulumi.output_type
class GetProtectedDatabaseResult:
    """
    A collection of values returned by getProtectedDatabase.
    """
    def __init__(__self__, compartment_id=None, database_id=None, database_size=None, db_unique_name=None, defined_tags=None, deletion_schedule=None, display_name=None, freeform_tags=None, health=None, health_details=None, id=None, is_read_only_resource=None, is_redo_logs_shipped=None, lifecycle_details=None, metrics=None, password=None, policy_locked_date_time=None, protected_database_id=None, protection_policy_id=None, recovery_service_subnets=None, state=None, subscription_id=None, system_tags=None, time_created=None, time_updated=None, vpc_user_name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if database_size and not isinstance(database_size, str):
            raise TypeError("Expected argument 'database_size' to be a str")
        pulumi.set(__self__, "database_size", database_size)
        if db_unique_name and not isinstance(db_unique_name, str):
            raise TypeError("Expected argument 'db_unique_name' to be a str")
        pulumi.set(__self__, "db_unique_name", db_unique_name)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if deletion_schedule and not isinstance(deletion_schedule, str):
            raise TypeError("Expected argument 'deletion_schedule' to be a str")
        pulumi.set(__self__, "deletion_schedule", deletion_schedule)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if health and not isinstance(health, str):
            raise TypeError("Expected argument 'health' to be a str")
        pulumi.set(__self__, "health", health)
        if health_details and not isinstance(health_details, str):
            raise TypeError("Expected argument 'health_details' to be a str")
        pulumi.set(__self__, "health_details", health_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_read_only_resource and not isinstance(is_read_only_resource, bool):
            raise TypeError("Expected argument 'is_read_only_resource' to be a bool")
        pulumi.set(__self__, "is_read_only_resource", is_read_only_resource)
        if is_redo_logs_shipped and not isinstance(is_redo_logs_shipped, bool):
            raise TypeError("Expected argument 'is_redo_logs_shipped' to be a bool")
        pulumi.set(__self__, "is_redo_logs_shipped", is_redo_logs_shipped)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if metrics and not isinstance(metrics, list):
            raise TypeError("Expected argument 'metrics' to be a list")
        pulumi.set(__self__, "metrics", metrics)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if policy_locked_date_time and not isinstance(policy_locked_date_time, str):
            raise TypeError("Expected argument 'policy_locked_date_time' to be a str")
        pulumi.set(__self__, "policy_locked_date_time", policy_locked_date_time)
        if protected_database_id and not isinstance(protected_database_id, str):
            raise TypeError("Expected argument 'protected_database_id' to be a str")
        pulumi.set(__self__, "protected_database_id", protected_database_id)
        if protection_policy_id and not isinstance(protection_policy_id, str):
            raise TypeError("Expected argument 'protection_policy_id' to be a str")
        pulumi.set(__self__, "protection_policy_id", protection_policy_id)
        if recovery_service_subnets and not isinstance(recovery_service_subnets, list):
            raise TypeError("Expected argument 'recovery_service_subnets' to be a list")
        pulumi.set(__self__, "recovery_service_subnets", recovery_service_subnets)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if vpc_user_name and not isinstance(vpc_user_name, str):
            raise TypeError("Expected argument 'vpc_user_name' to be a str")
        pulumi.set(__self__, "vpc_user_name", vpc_user_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the protected database.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> str:
        """
        The OCID of the protected database.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseSize")
    def database_size(self) -> str:
        """
        The size of the protected database. XS - Less than 5GB, S - 5GB to 50GB, M - 50GB to 500GB, L - 500GB to 1TB, XL - 1TB to 5TB, XXL - Greater than 5TB.
        """
        return pulumi.get(self, "database_size")

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> str:
        """
        The dbUniqueName for the protected database in Recovery Service. You cannot change the unique name.
        """
        return pulumi.get(self, "db_unique_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deletionSchedule")
    def deletion_schedule(self) -> str:
        return pulumi.get(self, "deletion_schedule")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The protected database name. You can change the displayName. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Indicates the protection status of the database.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthDetails")
    def health_details(self) -> str:
        """
        A message describing the current health of the protected database.
        """
        return pulumi.get(self, "health_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the protected database.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isReadOnlyResource")
    def is_read_only_resource(self) -> bool:
        """
        Indicates whether the protected database is created by Recovery Service or created manually. Set to <b>TRUE</b> for a service-defined protected database. When you enable the OCI-managed automatic backups option for a database and set Recovery Service as the backup destination, then Recovery Service creates the associated protected database resource. Set to <b>FALSE</b> for a user-defined protected database.
        """
        return pulumi.get(self, "is_read_only_resource")

    @property
    @pulumi.getter(name="isRedoLogsShipped")
    def is_redo_logs_shipped(self) -> bool:
        """
        The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups. For this to be effective, additional configuration is needed on client side.
        """
        return pulumi.get(self, "is_redo_logs_shipped")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Detailed description about the current lifecycle state of the protected database. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetProtectedDatabaseMetricResult']:
        """
        Backup performance and storage utilization metrics for the protected database.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="policyLockedDateTime")
    def policy_locked_date_time(self) -> str:
        """
        An RFC3339 formatted datetime string that specifies the exact date and time for the retention lock to take effect and permanently lock the retention period defined in the policy.
        """
        return pulumi.get(self, "policy_locked_date_time")

    @property
    @pulumi.getter(name="protectedDatabaseId")
    def protected_database_id(self) -> str:
        return pulumi.get(self, "protected_database_id")

    @property
    @pulumi.getter(name="protectionPolicyId")
    def protection_policy_id(self) -> str:
        """
        The OCID of the protection policy associated with the protected database.
        """
        return pulumi.get(self, "protection_policy_id")

    @property
    @pulumi.getter(name="recoveryServiceSubnets")
    def recovery_service_subnets(self) -> Sequence['outputs.GetProtectedDatabaseRecoveryServiceSubnetResult']:
        """
        List of recovery service subnet resources associated with the protected database.
        """
        return pulumi.get(self, "recovery_service_subnets")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Protected Database.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        The OCID of the cloud service subscription to which the protected database is linked.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        An RFC3339 formatted datetime string that indicates the created time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        An RFC3339 formatted datetime string that indicates the last updated time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vpcUserName")
    def vpc_user_name(self) -> str:
        """
        The virtual private catalog (VPC) user credentials that authenticates the protected database to access Recovery Service.
        """
        return pulumi.get(self, "vpc_user_name")


class AwaitableGetProtectedDatabaseResult(GetProtectedDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProtectedDatabaseResult(
            compartment_id=self.compartment_id,
            database_id=self.database_id,
            database_size=self.database_size,
            db_unique_name=self.db_unique_name,
            defined_tags=self.defined_tags,
            deletion_schedule=self.deletion_schedule,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            health=self.health,
            health_details=self.health_details,
            id=self.id,
            is_read_only_resource=self.is_read_only_resource,
            is_redo_logs_shipped=self.is_redo_logs_shipped,
            lifecycle_details=self.lifecycle_details,
            metrics=self.metrics,
            password=self.password,
            policy_locked_date_time=self.policy_locked_date_time,
            protected_database_id=self.protected_database_id,
            protection_policy_id=self.protection_policy_id,
            recovery_service_subnets=self.recovery_service_subnets,
            state=self.state,
            subscription_id=self.subscription_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            vpc_user_name=self.vpc_user_name)


def get_protected_database(protected_database_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProtectedDatabaseResult:
    """
    This data source provides details about a specific Protected Database resource in Oracle Cloud Infrastructure Recovery service.

    Gets information about a specified protected database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_protected_database = oci.RecoveryMod.get_protected_database(protected_database_id=test_protected_database_oci_recovery_protected_database["id"])
    ```


    :param str protected_database_id: The protected database OCID.
    """
    __args__ = dict()
    __args__['protectedDatabaseId'] = protected_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:RecoveryMod/getProtectedDatabase:getProtectedDatabase', __args__, opts=opts, typ=GetProtectedDatabaseResult).value

    return AwaitableGetProtectedDatabaseResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_id=pulumi.get(__ret__, 'database_id'),
        database_size=pulumi.get(__ret__, 'database_size'),
        db_unique_name=pulumi.get(__ret__, 'db_unique_name'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        deletion_schedule=pulumi.get(__ret__, 'deletion_schedule'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        health=pulumi.get(__ret__, 'health'),
        health_details=pulumi.get(__ret__, 'health_details'),
        id=pulumi.get(__ret__, 'id'),
        is_read_only_resource=pulumi.get(__ret__, 'is_read_only_resource'),
        is_redo_logs_shipped=pulumi.get(__ret__, 'is_redo_logs_shipped'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        metrics=pulumi.get(__ret__, 'metrics'),
        password=pulumi.get(__ret__, 'password'),
        policy_locked_date_time=pulumi.get(__ret__, 'policy_locked_date_time'),
        protected_database_id=pulumi.get(__ret__, 'protected_database_id'),
        protection_policy_id=pulumi.get(__ret__, 'protection_policy_id'),
        recovery_service_subnets=pulumi.get(__ret__, 'recovery_service_subnets'),
        state=pulumi.get(__ret__, 'state'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        vpc_user_name=pulumi.get(__ret__, 'vpc_user_name'))


@_utilities.lift_output_func(get_protected_database)
def get_protected_database_output(protected_database_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProtectedDatabaseResult]:
    """
    This data source provides details about a specific Protected Database resource in Oracle Cloud Infrastructure Recovery service.

    Gets information about a specified protected database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_protected_database = oci.RecoveryMod.get_protected_database(protected_database_id=test_protected_database_oci_recovery_protected_database["id"])
    ```


    :param str protected_database_id: The protected database OCID.
    """
    ...
