# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPrivateApplicationPackagesResult',
    'AwaitableGetPrivateApplicationPackagesResult',
    'get_private_application_packages',
    'get_private_application_packages_output',
]

@pulumi.output_type
class GetPrivateApplicationPackagesResult:
    """
    A collection of values returned by getPrivateApplicationPackages.
    """
    def __init__(__self__, display_name=None, filters=None, id=None, package_types=None, private_application_id=None, private_application_package_collections=None, private_application_package_id=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if package_types and not isinstance(package_types, list):
            raise TypeError("Expected argument 'package_types' to be a list")
        pulumi.set(__self__, "package_types", package_types)
        if private_application_id and not isinstance(private_application_id, str):
            raise TypeError("Expected argument 'private_application_id' to be a str")
        pulumi.set(__self__, "private_application_id", private_application_id)
        if private_application_package_collections and not isinstance(private_application_package_collections, list):
            raise TypeError("Expected argument 'private_application_package_collections' to be a list")
        pulumi.set(__self__, "private_application_package_collections", private_application_package_collections)
        if private_application_package_id and not isinstance(private_application_package_id, str):
            raise TypeError("Expected argument 'private_application_package_id' to be a str")
        pulumi.set(__self__, "private_application_package_id", private_application_package_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the package.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPrivateApplicationPackagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="packageTypes")
    def package_types(self) -> Optional[Sequence[str]]:
        """
        The specified package's type.
        """
        return pulumi.get(self, "package_types")

    @property
    @pulumi.getter(name="privateApplicationId")
    def private_application_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private application where the package is hosted.
        """
        return pulumi.get(self, "private_application_id")

    @property
    @pulumi.getter(name="privateApplicationPackageCollections")
    def private_application_package_collections(self) -> Sequence['outputs.GetPrivateApplicationPackagesPrivateApplicationPackageCollectionResult']:
        """
        The list of private_application_package_collection.
        """
        return pulumi.get(self, "private_application_package_collections")

    @property
    @pulumi.getter(name="privateApplicationPackageId")
    def private_application_package_id(self) -> Optional[str]:
        return pulumi.get(self, "private_application_package_id")


class AwaitableGetPrivateApplicationPackagesResult(GetPrivateApplicationPackagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivateApplicationPackagesResult(
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            package_types=self.package_types,
            private_application_id=self.private_application_id,
            private_application_package_collections=self.private_application_package_collections,
            private_application_package_id=self.private_application_package_id)


def get_private_application_packages(display_name: Optional[str] = None,
                                     filters: Optional[Sequence[Union['GetPrivateApplicationPackagesFilterArgs', 'GetPrivateApplicationPackagesFilterArgsDict']]] = None,
                                     package_types: Optional[Sequence[str]] = None,
                                     private_application_id: Optional[str] = None,
                                     private_application_package_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivateApplicationPackagesResult:
    """
    This data source provides the list of Private Application Packages in Oracle Cloud Infrastructure Service Catalog service.

    Lists the packages in the specified private application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_application_packages = oci.ServiceCatalog.get_private_application_packages(private_application_id=test_private_application["id"],
        display_name=private_application_package_display_name,
        package_types=private_application_package_package_type,
        private_application_package_id=test_private_application_package["id"])
    ```


    :param str display_name: Exact match name filter.
    :param Sequence[str] package_types: Name of the package type. If multiple package types are provided, then any resource with one or more matching package types will be returned.
    :param str private_application_id: The unique identifier for the private application.
    :param str private_application_package_id: The unique identifier for the private application package.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['packageTypes'] = package_types
    __args__['privateApplicationId'] = private_application_id
    __args__['privateApplicationPackageId'] = private_application_package_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ServiceCatalog/getPrivateApplicationPackages:getPrivateApplicationPackages', __args__, opts=opts, typ=GetPrivateApplicationPackagesResult).value

    return AwaitableGetPrivateApplicationPackagesResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        package_types=pulumi.get(__ret__, 'package_types'),
        private_application_id=pulumi.get(__ret__, 'private_application_id'),
        private_application_package_collections=pulumi.get(__ret__, 'private_application_package_collections'),
        private_application_package_id=pulumi.get(__ret__, 'private_application_package_id'))


@_utilities.lift_output_func(get_private_application_packages)
def get_private_application_packages_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPrivateApplicationPackagesFilterArgs', 'GetPrivateApplicationPackagesFilterArgsDict']]]]] = None,
                                            package_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                            private_application_id: Optional[pulumi.Input[str]] = None,
                                            private_application_package_id: Optional[pulumi.Input[Optional[str]]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPrivateApplicationPackagesResult]:
    """
    This data source provides the list of Private Application Packages in Oracle Cloud Infrastructure Service Catalog service.

    Lists the packages in the specified private application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_application_packages = oci.ServiceCatalog.get_private_application_packages(private_application_id=test_private_application["id"],
        display_name=private_application_package_display_name,
        package_types=private_application_package_package_type,
        private_application_package_id=test_private_application_package["id"])
    ```


    :param str display_name: Exact match name filter.
    :param Sequence[str] package_types: Name of the package type. If multiple package types are provided, then any resource with one or more matching package types will be returned.
    :param str private_application_id: The unique identifier for the private application.
    :param str private_application_package_id: The unique identifier for the private application package.
    """
    ...
