"""
Newsletter APP Settings
"""

from django.conf import settings

PROJECT_SETTINGS = getattr(settings, 'PLUGS_NEWSLETTER', {})

DEFAULTS = {
    'NEWSLETTER_ENDPOINT': 'newsletter',
    'AUTH_MODEL_NEWSLETTER_FIELD': 'newsletter'
}

if not PROJECT_SETTINGS.get('NEWSLETTER_ENDPOINT'):
    PROJECT_SETTINGS['NEWSLETTER_ENDPOINT'] = DEFAULTS['NEWSLETTER_ENDPOINT']

if not PROJECT_SETTINGS.get('AUTH_MODEL_NEWSLETTER_FIELD'):
    PROJECT_SETTINGS['AUTH_MODEL_NEWSLETTER_FIELD'] = DEFAULTS['AUTH_MODEL_NEWSLETTER_FIELD']


plugs_newsletter_settings = PROJECT_SETTINGS
