# -*- coding: utf-8 -*-
from TaiwanLottery import TaiwanLotteryCrawler


def test_super_lotto():
    # Given user wants to get 威力彩 2023-06 result
    lottery = TaiwanLotteryCrawler()

    # When user get the 威力彩 2023-06 result without print and output to json
    super_lotto_result = lottery.super_lotto(['2023', '06'])

    # Then the super_lotto_result should be equal to test result
    assert super_lotto_result == [
        {'期別': 112000052, '開獎日期': '2023-06-29T00:00:00', '第一區': [1, 8, 26, 27, 29, 36], '第二區': 2},
        {'期別': 112000051, '開獎日期': '2023-06-26T00:00:00', '第一區': [1, 15, 16, 17, 24, 35], '第二區': 6},
        {'期別': 112000050, '開獎日期': '2023-06-22T00:00:00', '第一區': [1, 4, 7, 17, 24, 28], '第二區': 8},
        {'期別': 112000049, '開獎日期': '2023-06-19T00:00:00', '第一區': [4, 8, 12, 20, 27, 36], '第二區': 1},
        {'期別': 112000048, '開獎日期': '2023-06-15T00:00:00', '第一區': [2, 24, 25, 26, 34, 36], '第二區': 8},
        {'期別': 112000047, '開獎日期': '2023-06-12T00:00:00', '第一區': [1, 2, 16, 18, 35, 38], '第二區': 1},
        {'期別': 112000046, '開獎日期': '2023-06-08T00:00:00', '第一區': [3, 8, 12, 18, 35, 38], '第二區': 3},
        {'期別': 112000045, '開獎日期': '2023-06-05T00:00:00', '第一區': [4, 11, 28, 32, 34, 35], '第二區': 1},
        {'期別': 112000044, '開獎日期': '2023-06-01T00:00:00', '第一區': [10, 18, 25, 29, 36, 37], '第二區': 2}
    ]


def test_lotto649():
    # Given user wants to get 大樂透 2023-06 result
    lottery = TaiwanLotteryCrawler()

    # When user get the 大樂透 2023-06 result without print and output to json
    lotto649_result = lottery.lotto649(['2023', '06'])

    # Then the lotto649_result should be equal to test result
    assert lotto649_result == [
        {'期別': 112000064, '開獎日期': '2023-06-30T00:00:00', '獎號': [6, 22, 26, 29, 32, 43], '特別號': 38},
        {'期別': 112000063, '開獎日期': '2023-06-27T00:00:00', '獎號': [13, 24, 30, 37, 43, 44], '特別號': 4},
        {'期別': 112000062, '開獎日期': '2023-06-23T00:00:00', '獎號': [4, 8, 23, 31, 42, 49], '特別號': 16},
        {'期別': 112000061, '開獎日期': '2023-06-20T00:00:00', '獎號': [5, 15, 32, 34, 37, 41], '特別號': 11},
        {'期別': 112000060, '開獎日期': '2023-06-16T00:00:00', '獎號': [2, 21, 22, 30, 33, 41], '特別號': 42},
        {'期別': 112000059, '開獎日期': '2023-06-13T00:00:00', '獎號': [1, 6, 8, 9, 10, 21], '特別號': 2},
        {'期別': 112000058, '開獎日期': '2023-06-09T00:00:00', '獎號': [30, 32, 36, 38, 46, 49], '特別號': 26},
        {'期別': 112000057, '開獎日期': '2023-06-06T00:00:00', '獎號': [8, 13, 27, 30, 41, 43], '特別號': 18},
        {'期別': 112000056, '開獎日期': '2023-06-02T00:00:00', '獎號': [1, 5, 13, 16, 23, 34], '特別號': 49}
    ]


def test_daily_cash():
    # Given user wants to get 今彩539 2023-06 result
    lottery = TaiwanLotteryCrawler()

    # When user get the 今彩539 2023-06 result without print and output to json
    daily_cash_result = lottery.daily_cash(['2023', '06'])

    # Then the daily_cash_result should be equal to test result
    assert daily_cash_result == [
        {'期別': 112000155, '開獎日期': '2023-06-30T00:00:00', '獎號': [3, 11, 20, 30, 36]},
        {'期別': 112000154, '開獎日期': '2023-06-29T00:00:00', '獎號': [2, 10, 14, 17, 27]},
        {'期別': 112000153, '開獎日期': '2023-06-28T00:00:00', '獎號': [5, 8, 21, 32, 33]},
        {'期別': 112000152, '開獎日期': '2023-06-27T00:00:00', '獎號': [4, 12, 14, 28, 39]},
        {'期別': 112000151, '開獎日期': '2023-06-26T00:00:00', '獎號': [5, 14, 15, 20, 26]},
        {'期別': 112000150, '開獎日期': '2023-06-24T00:00:00', '獎號': [7, 10, 13, 14, 22]},
        {'期別': 112000149, '開獎日期': '2023-06-23T00:00:00', '獎號': [11, 13, 20, 24, 30]},
        {'期別': 112000148, '開獎日期': '2023-06-22T00:00:00', '獎號': [6, 10, 33, 34, 39]},
        {'期別': 112000147, '開獎日期': '2023-06-21T00:00:00', '獎號': [2, 9, 23, 30, 38]},
        {'期別': 112000146, '開獎日期': '2023-06-20T00:00:00', '獎號': [11, 25, 27, 34, 37]},
        {'期別': 112000145, '開獎日期': '2023-06-19T00:00:00', '獎號': [1, 13, 33, 36, 39]},
        {'期別': 112000144, '開獎日期': '2023-06-17T00:00:00', '獎號': [2, 9, 20, 29, 36]},
        {'期別': 112000143, '開獎日期': '2023-06-16T00:00:00', '獎號': [9, 12, 24, 28, 39]},
        {'期別': 112000142, '開獎日期': '2023-06-15T00:00:00', '獎號': [2, 11, 15, 18, 21]},
        {'期別': 112000141, '開獎日期': '2023-06-14T00:00:00', '獎號': [1, 6, 21, 32, 34]},
        {'期別': 112000140, '開獎日期': '2023-06-13T00:00:00', '獎號': [24, 29, 34, 36, 37]},
        {'期別': 112000139, '開獎日期': '2023-06-12T00:00:00', '獎號': [8, 13, 19, 22, 26]},
        {'期別': 112000138, '開獎日期': '2023-06-10T00:00:00', '獎號': [1, 8, 9, 19, 28]},
        {'期別': 112000137, '開獎日期': '2023-06-09T00:00:00', '獎號': [2, 13, 15, 17, 29]},
        {'期別': 112000136, '開獎日期': '2023-06-08T00:00:00', '獎號': [1, 12, 15, 23, 38]},
        {'期別': 112000135, '開獎日期': '2023-06-07T00:00:00', '獎號': [3, 7, 8, 11, 29]},
        {'期別': 112000134, '開獎日期': '2023-06-06T00:00:00', '獎號': [11, 18, 26, 29, 37]},
        {'期別': 112000133, '開獎日期': '2023-06-05T00:00:00', '獎號': [1, 5, 16, 20, 29]},
        {'期別': 112000132, '開獎日期': '2023-06-03T00:00:00', '獎號': [3, 7, 13, 23, 34]},
        {'期別': 112000131, '開獎日期': '2023-06-02T00:00:00', '獎號': [4, 8, 9, 22, 37]},
        {'期別': 112000130, '開獎日期': '2023-06-01T00:00:00', '獎號': [8, 18, 25, 27, 34]}
    ]


def test_lotto1224():
    # Given user wants to get 雙贏彩 2023-06 result
    lottery = TaiwanLotteryCrawler()

    # When user get the 雙贏彩 2023-06 result without print and output to json
    lotto1224_result = lottery.lotto1224(['2023', '06'])

    # Then the lotto1224_result should be equal to test result
    assert lotto1224_result == [
        {'期別': 112000155, '開獎日期': '2023-06-30T00:00:00', '獎號': [1, 2, 5, 6, 7, 10, 12, 14, 15, 16, 20, 24]},
        {'期別': 112000154, '開獎日期': '2023-06-29T00:00:00', '獎號': [1, 2, 4, 5, 6, 8, 11, 12, 13, 19, 23, 24]},
        {'期別': 112000153, '開獎日期': '2023-06-28T00:00:00', '獎號': [4, 5, 6, 7, 8, 9, 10, 13, 19, 21, 23, 24]},
        {'期別': 112000152, '開獎日期': '2023-06-27T00:00:00', '獎號': [1, 2, 4, 7, 8, 9, 10, 13, 15, 16, 22, 24]},
        {'期別': 112000151, '開獎日期': '2023-06-26T00:00:00', '獎號': [4, 5, 6, 7, 10, 15, 16, 17, 18, 21, 23, 24]},
        {'期別': 112000150, '開獎日期': '2023-06-24T00:00:00', '獎號': [1, 5, 8, 9, 14, 15, 16, 17, 18, 19, 20, 22]},
        {'期別': 112000149, '開獎日期': '2023-06-23T00:00:00', '獎號': [3, 4, 5, 6, 10, 12, 13, 16, 19, 20, 22, 23]},
        {'期別': 112000148, '開獎日期': '2023-06-22T00:00:00', '獎號': [3, 4, 6, 9, 12, 13, 14, 17, 18, 19, 21, 23]},
        {'期別': 112000147, '開獎日期': '2023-06-21T00:00:00', '獎號': [1, 3, 7, 10, 12, 13, 14, 18, 19, 22, 23, 24]},
        {'期別': 112000146, '開獎日期': '2023-06-20T00:00:00', '獎號': [1, 2, 3, 4, 5, 6, 7, 10, 14, 18, 19, 23]},
        {'期別': 112000145, '開獎日期': '2023-06-19T00:00:00', '獎號': [3, 4, 6, 7, 9, 11, 16, 17, 19, 22, 23, 24]},
        {'期別': 112000144, '開獎日期': '2023-06-17T00:00:00', '獎號': [1, 2, 4, 5, 8, 9, 11, 13, 16, 20, 21, 24]},
        {'期別': 112000143, '開獎日期': '2023-06-16T00:00:00', '獎號': [1, 3, 8, 9, 11, 12, 14, 18, 19, 21, 22, 23]},
        {'期別': 112000142, '開獎日期': '2023-06-15T00:00:00', '獎號': [2, 4, 8, 9, 13, 15, 18, 19, 20, 21, 22, 24]},
        {'期別': 112000141, '開獎日期': '2023-06-14T00:00:00', '獎號': [2, 3, 4, 6, 10, 12, 13, 18, 19, 20, 23, 24]},
        {'期別': 112000140, '開獎日期': '2023-06-13T00:00:00', '獎號': [2, 3, 4, 6, 7, 9, 10, 16, 21, 22, 23, 24]},
        {'期別': 112000139, '開獎日期': '2023-06-12T00:00:00', '獎號': [1, 2, 3, 4, 6, 7, 9, 12, 15, 16, 23, 24]},
        {'期別': 112000138, '開獎日期': '2023-06-10T00:00:00', '獎號': [1, 8, 9, 12, 15, 17, 18, 20, 21, 22, 23, 24]},
        {'期別': 112000137, '開獎日期': '2023-06-09T00:00:00', '獎號': [4, 5, 8, 9, 10, 12, 13, 16, 19, 20, 22, 23]},
        {'期別': 112000136, '開獎日期': '2023-06-08T00:00:00', '獎號': [2, 3, 4, 5, 7, 8, 10, 12, 17, 19, 22, 24]},
        {'期別': 112000135, '開獎日期': '2023-06-07T00:00:00', '獎號': [1, 2, 3, 4, 7, 8, 9, 11, 14, 19, 21, 23]},
        {'期別': 112000134, '開獎日期': '2023-06-06T00:00:00', '獎號': [2, 9, 10, 11, 12, 13, 16, 17, 19, 21, 22, 24]},
        {'期別': 112000133, '開獎日期': '2023-06-05T00:00:00', '獎號': [2, 3, 6, 8, 12, 14, 15, 17, 19, 20, 21, 23]},
        {'期別': 112000132, '開獎日期': '2023-06-03T00:00:00', '獎號': [1, 5, 7, 11, 12, 13, 14, 15, 16, 20, 22, 23]},
        {'期別': 112000131, '開獎日期': '2023-06-02T00:00:00', '獎號': [1, 6, 7, 8, 11, 12, 14, 15, 18, 19, 21, 24]},
        {'期別': 112000130, '開獎日期': '2023-06-01T00:00:00', '獎號': [3, 5, 7, 9, 10, 12, 14, 15, 17, 19, 20, 23]}
    ]


def test_lotto3d():
    # Given user wants to get 3星彩 2023-08 result
    lottery = TaiwanLotteryCrawler()

    # When user get the 3星彩 2023-08 result without print and output to json
    lotto3d_result = lottery.lotto3d(['2023', '08'])

    print(lotto3d_result)

    assert lotto3d_result == [
        {'期別': 112000208, '開獎日期': '2023-08-31T00:00:00', '獎號': [7, 2, 7]},
        {'期別': 112000207, '開獎日期': '2023-08-30T00:00:00', '獎號': [9, 0, 1]},
        {'期別': 112000206, '開獎日期': '2023-08-29T00:00:00', '獎號': [1, 5, 9]},
        {'期別': 112000205, '開獎日期': '2023-08-28T00:00:00', '獎號': [5, 6, 6]},
        {'期別': 112000204, '開獎日期': '2023-08-26T00:00:00', '獎號': [5, 8, 0]},
        {'期別': 112000203, '開獎日期': '2023-08-25T00:00:00', '獎號': [9, 7, 1]},
        {'期別': 112000202, '開獎日期': '2023-08-24T00:00:00', '獎號': [7, 0, 4]},
        {'期別': 112000201, '開獎日期': '2023-08-23T00:00:00', '獎號': [6, 3, 2]},
        {'期別': 112000200, '開獎日期': '2023-08-22T00:00:00', '獎號': [1, 5, 2]},
        {'期別': 112000199, '開獎日期': '2023-08-21T00:00:00', '獎號': [0, 9, 7]},
        {'期別': 112000198, '開獎日期': '2023-08-19T00:00:00', '獎號': [7, 4, 3]},
        {'期別': 112000197, '開獎日期': '2023-08-18T00:00:00', '獎號': [9, 8, 6]},
        {'期別': 112000196, '開獎日期': '2023-08-17T00:00:00', '獎號': [2, 7, 7]},
        {'期別': 112000195, '開獎日期': '2023-08-16T00:00:00', '獎號': [3, 1, 6]},
        {'期別': 112000194, '開獎日期': '2023-08-15T00:00:00', '獎號': [6, 4, 8]},
        {'期別': 112000193, '開獎日期': '2023-08-14T00:00:00', '獎號': [8, 9, 5]},
        {'期別': 112000192, '開獎日期': '2023-08-12T00:00:00', '獎號': [2, 1, 5]},
        {'期別': 112000191, '開獎日期': '2023-08-11T00:00:00', '獎號': [6, 1, 7]},
        {'期別': 112000190, '開獎日期': '2023-08-10T00:00:00', '獎號': [2, 7, 2]},
        {'期別': 112000189, '開獎日期': '2023-08-09T00:00:00', '獎號': [6, 8, 6]},
        {'期別': 112000188, '開獎日期': '2023-08-08T00:00:00', '獎號': [8, 0, 5]},
        {'期別': 112000187, '開獎日期': '2023-08-07T00:00:00', '獎號': [1, 2, 7]},
        {'期別': 112000186, '開獎日期': '2023-08-05T00:00:00', '獎號': [4, 7, 2]},
        {'期別': 112000185, '開獎日期': '2023-08-04T00:00:00', '獎號': [5, 0, 4]},
        {'期別': 112000184, '開獎日期': '2023-08-03T00:00:00', '獎號': [7, 4, 0]},
        {'期別': 112000183, '開獎日期': '2023-08-02T00:00:00', '獎號': [4, 0, 4]},
        {'期別': 112000182, '開獎日期': '2023-08-01T00:00:00', '獎號': [9, 0, 1]}
    ]


def test_lotto4d():
    # Given user wants to get 4星彩 2023-08 result
    lottery = TaiwanLotteryCrawler()

    # When user get the 4星彩 2023-08 result without print and output to json
    lotto4d_result = lottery.lotto4d(['2023', '08'])

    print(lotto4d_result)

    assert lotto4d_result == [
        {'期別': 112000208, '開獎日期': '2023-08-31T00:00:00', '獎號': [1, 1, 6, 1]},
        {'期別': 112000207, '開獎日期': '2023-08-30T00:00:00', '獎號': [1, 4, 3, 6]},
        {'期別': 112000206, '開獎日期': '2023-08-29T00:00:00', '獎號': [0, 1, 4, 9]},
        {'期別': 112000205, '開獎日期': '2023-08-28T00:00:00', '獎號': [3, 6, 2, 5]},
        {'期別': 112000204, '開獎日期': '2023-08-26T00:00:00', '獎號': [6, 1, 3, 8]},
        {'期別': 112000203, '開獎日期': '2023-08-25T00:00:00', '獎號': [2, 5, 8, 0]},
        {'期別': 112000202, '開獎日期': '2023-08-24T00:00:00', '獎號': [1, 8, 5, 1]},
        {'期別': 112000201, '開獎日期': '2023-08-23T00:00:00', '獎號': [5, 2, 8, 6]},
        {'期別': 112000200, '開獎日期': '2023-08-22T00:00:00', '獎號': [5, 4, 4, 9]},
        {'期別': 112000199, '開獎日期': '2023-08-21T00:00:00', '獎號': [7, 1, 5, 2]},
        {'期別': 112000198, '開獎日期': '2023-08-19T00:00:00', '獎號': [3, 4, 7, 6]},
        {'期別': 112000197, '開獎日期': '2023-08-18T00:00:00', '獎號': [6, 7, 8, 7]},
        {'期別': 112000196, '開獎日期': '2023-08-17T00:00:00', '獎號': [0, 3, 2, 6]},
        {'期別': 112000195, '開獎日期': '2023-08-16T00:00:00', '獎號': [4, 1, 3, 0]},
        {'期別': 112000194, '開獎日期': '2023-08-15T00:00:00', '獎號': [0, 9, 1, 1]},
        {'期別': 112000193, '開獎日期': '2023-08-14T00:00:00', '獎號': [3, 2, 5, 8]},
        {'期別': 112000192, '開獎日期': '2023-08-12T00:00:00', '獎號': [8, 4, 0, 9]},
        {'期別': 112000191, '開獎日期': '2023-08-11T00:00:00', '獎號': [4, 0, 6, 3]},
        {'期別': 112000190, '開獎日期': '2023-08-10T00:00:00', '獎號': [7, 1, 5, 5]},
        {'期別': 112000189, '開獎日期': '2023-08-09T00:00:00', '獎號': [9, 7, 8, 0]},
        {'期別': 112000188, '開獎日期': '2023-08-08T00:00:00', '獎號': [2, 7, 7, 0]},
        {'期別': 112000187, '開獎日期': '2023-08-07T00:00:00', '獎號': [7, 7, 2, 4]},
        {'期別': 112000186, '開獎日期': '2023-08-05T00:00:00', '獎號': [8, 2, 5, 4]},
        {'期別': 112000185, '開獎日期': '2023-08-04T00:00:00', '獎號': [6, 3, 0, 3]},
        {'期別': 112000184, '開獎日期': '2023-08-03T00:00:00', '獎號': [5, 1, 3, 9]},
        {'期別': 112000183, '開獎日期': '2023-08-02T00:00:00', '獎號': [5, 5, 5, 1]},
        {'期別': 112000182, '開獎日期': '2023-08-01T00:00:00', '獎號': [5, 0, 9, 3]}
    ]


def test_lotto38m6():
    # Given user wants to get 38樂合彩 2023-08 result
    lottery = TaiwanLotteryCrawler()

    # When user get the 38樂合彩 2023-08 result without print and output to json
    lotto38m6_result = lottery.lotto38m6(['2023', '08'])

    print(lotto38m6_result)

    assert lotto38m6_result == [
        {'期別': 112000070, '開獎日期': '2023-08-31T00:00:00', '獎號': [4, 22, 23, 27, 30, 34]},
        {'期別': 112000069, '開獎日期': '2023-08-28T00:00:00', '獎號': [3, 6, 8, 15, 24, 38]},
        {'期別': 112000068, '開獎日期': '2023-08-24T00:00:00', '獎號': [3, 10, 17, 21, 23, 38]},
        {'期別': 112000067, '開獎日期': '2023-08-21T00:00:00', '獎號': [1, 12, 14, 19, 33, 34]},
        {'期別': 112000066, '開獎日期': '2023-08-17T00:00:00', '獎號': [4, 18, 21, 23, 28, 37]},
        {'期別': 112000065, '開獎日期': '2023-08-14T00:00:00', '獎號': [2, 3, 4, 10, 17, 26]},
        {'期別': 112000064, '開獎日期': '2023-08-10T00:00:00', '獎號': [3, 11, 21, 29, 30, 38]},
        {'期別': 112000063, '開獎日期': '2023-08-07T00:00:00', '獎號': [3, 27, 29, 31, 33, 37]},
        {'期別': 112000062, '開獎日期': '2023-08-03T00:00:00', '獎號': [17, 18, 21, 25, 27, 33]}
    ]


def test_lotto49m6():
    # Given user wants to get 49樂合彩 2023-07 result
    lottery = TaiwanLotteryCrawler()

    # When user get the 49樂合彩 2023-07 result without print and output to json
    lotto49m6_result = lottery.lotto49m6(['2023', '07'])

    print(lotto49m6_result)

    assert lotto49m6_result == [
        {'期別': 112000072, '開獎日期': '2023-07-28T00:00:00', '獎號': [1, 3, 22, 25, 34, 44]},
        {'期別': 112000071, '開獎日期': '2023-07-25T00:00:00', '獎號': [12, 17, 28, 33, 40, 45]},
        {'期別': 112000070, '開獎日期': '2023-07-21T00:00:00', '獎號': [3, 15, 35, 39, 41, 49]},
        {'期別': 112000069, '開獎日期': '2023-07-18T00:00:00', '獎號': [4, 5, 16, 19, 34, 40]},
        {'期別': 112000068, '開獎日期': '2023-07-14T00:00:00', '獎號': [10, 15, 17, 33, 34, 45]},
        {'期別': 112000067, '開獎日期': '2023-07-11T00:00:00', '獎號': [10, 21, 26, 34, 48, 49]},
        {'期別': 112000066, '開獎日期': '2023-07-07T00:00:00', '獎號': [3, 6, 15, 21, 24, 33]},
        {'期別': 112000065, '開獎日期': '2023-07-04T00:00:00', '獎號': [6, 12, 15, 16, 24, 41]}
    ]


def test_lotto39m5():
    # Given user wants to get 39樂合彩 2023-07 result
    lottery = TaiwanLotteryCrawler()

    # When user get the 39樂合彩 2023-07 result without print and output to json
    lotto39m5_result = lottery.lotto39m5(['2023', '07'])

    assert lotto39m5_result == [
        {'期別': 112000181, '開獎日期': '2023-07-31T00:00:00', '獎號': [3, 13, 19, 21, 35]},
        {'期別': 112000180, '開獎日期': '2023-07-29T00:00:00', '獎號': [15, 18, 20, 30, 37]},
        {'期別': 112000179, '開獎日期': '2023-07-28T00:00:00', '獎號': [1, 7, 13, 20, 26]},
        {'期別': 112000178, '開獎日期': '2023-07-27T00:00:00', '獎號': [10, 13, 18, 37, 39]},
        {'期別': 112000177, '開獎日期': '2023-07-26T00:00:00', '獎號': [6, 13, 33, 37, 38]},
        {'期別': 112000176, '開獎日期': '2023-07-25T00:00:00', '獎號': [15, 18, 19, 26, 32]},
        {'期別': 112000175, '開獎日期': '2023-07-24T00:00:00', '獎號': [2, 13, 31, 34, 37]},
        {'期別': 112000174, '開獎日期': '2023-07-22T00:00:00', '獎號': [4, 9, 15, 24, 32]},
        {'期別': 112000173, '開獎日期': '2023-07-21T00:00:00', '獎號': [9, 26, 27, 31, 39]},
        {'期別': 112000172, '開獎日期': '2023-07-20T00:00:00', '獎號': [13, 18, 20, 23, 31]},
        {'期別': 112000171, '開獎日期': '2023-07-19T00:00:00', '獎號': [2, 12, 20, 22, 35]},
        {'期別': 112000170, '開獎日期': '2023-07-18T00:00:00', '獎號': [12, 15, 23, 29, 38]},
        {'期別': 112000169, '開獎日期': '2023-07-17T00:00:00', '獎號': [1, 18, 22, 29, 30]},
        {'期別': 112000168, '開獎日期': '2023-07-15T00:00:00', '獎號': [8, 16, 19, 21, 22]},
        {'期別': 112000167, '開獎日期': '2023-07-14T00:00:00', '獎號': [12, 14, 20, 25, 37]},
        {'期別': 112000166, '開獎日期': '2023-07-13T00:00:00', '獎號': [4, 6, 10, 19, 32]},
        {'期別': 112000165, '開獎日期': '2023-07-12T00:00:00', '獎號': [1, 2, 9, 10, 32]},
        {'期別': 112000164, '開獎日期': '2023-07-11T00:00:00', '獎號': [24, 25, 35, 36, 38]},
        {'期別': 112000163, '開獎日期': '2023-07-10T00:00:00', '獎號': [1, 4, 15, 19, 37]},
        {'期別': 112000162, '開獎日期': '2023-07-08T00:00:00', '獎號': [1, 4, 18, 24, 33]},
        {'期別': 112000161, '開獎日期': '2023-07-07T00:00:00', '獎號': [12, 16, 25, 28, 30]},
        {'期別': 112000160, '開獎日期': '2023-07-06T00:00:00', '獎號': [2, 14, 17, 21, 33]},
        {'期別': 112000159, '開獎日期': '2023-07-05T00:00:00', '獎號': [5, 7, 8, 25, 30]},
        {'期別': 112000158, '開獎日期': '2023-07-04T00:00:00', '獎號': [14, 26, 27, 29, 35]},
        {'期別': 112000157, '開獎日期': '2023-07-03T00:00:00', '獎號': [13, 28, 33, 34, 39]},
        {'期別': 112000156, '開獎日期': '2023-07-01T00:00:00', '獎號': [7, 8, 12, 22, 39]}
    ]
