#[=============================================================================[.rst

pybind11Config.cmake
--------------------

PYBIND11 cmake module.
This module sets the following variables in your project::

  pybind11_FOUND - true if pybind11 and all required components found on the system
  pybind11_VERSION - pybind11 version in format Major.Minor.Release
  pybind11_VERSION_TYPE - pybind11 version type (dev, release)
  pybind11_INCLUDE_DIRS - Directories where pybind11 and python headers are located.
  pybind11_INCLUDE_DIR - Directory where pybind11 headers are located.
  pybind11_DEFINITIONS - Definitions necessary to use pybind11, namely USING_pybind11.
  pybind11_LIBRARIES - compile flags and python libraries (as needed) to link against.
  pybind11_LIBRARY - empty.


Available components: None


Exported targets::

If pybind11 is found, this module defines the following :prop_tgt:`IMPORTED`
interface library targets::

  pybind11::module - for extension modules
  pybind11::embed - for embedding the Python interpreter

Python headers, libraries (as needed by platform), and the C++ standard
are attached to the target.

Advanced targets are also supplied - these are primary for users building
complex applications, and they are available in all modes::

  pybind11::headers - Just the pybind11 headers and minimum compile requirements
  pybind11::pybind11 - Python headers too
  pybind11::python_link_helper - Just the "linking" part of pybind11:module, for CMake < 3.15
  pybind11::python2_no_register - Quiets the warning/error when mixing C++14+ and Python 2, also included in pybind11::module
  pybind11::thin_lto - An alternative to INTERPROCEDURAL_OPTIMIZATION
  pybind11::lto - An alternative to INTERPROCEDURAL_OPTIMIZATION (also avoids thin LTO on clang)
  pybind11::windows_extras - Adds bigobj and mp for MSVC

Modes::

There are two modes provided; classic, which is built on the old Python
discovery packages in CMake, or the new FindPython mode, which uses FindPython
from 3.12+ forward (3.15+ _highly_ recommended).

New FindPython mode::

To activate this mode, either call ``find_package(Python COMPONENTS Interpreter Development)``
before finding this package, or set the ``PYBIND11_FINDPYTHON`` variable to ON. In this mode,
you can either use the basic targets, or use the FindPython tools::

  find_package(Python COMPONENTS Interpreter Development)
  find_package(pybind11 CONFIG)

  # pybind11 method:
  pybind11_add_module(MyModule1 src1.cpp)

  # Python method:
  Python_add_library(MyModule2 src2.cpp)
  target_link_libraries(MyModule2 pybind11::headers)
  set_target_properties(MyModule2 PROPERTIES
                                  INTERPROCEDURAL_OPTIMIZATION ON
                                  CXX__VISIBILITY_PRESET ON
                                  VISIBLITY_INLINES_HIDDEN ON)

If you build targets yourself, you may be interested in stripping the output
for reduced size; this is the one other feature that the helper function gives you.

Classic mode::

Set PythonLibsNew variables to influence python detection and
CMAKE_CXX_STANDARD to influence standard setting. ::

  find_package(pybind11 CONFIG REQUIRED)

  # Create an extension module
  add_library(mylib MODULE main.cpp)
  target_link_libraries(mylib PUBLIC pybind11::module)

  # Or embed the Python interpreter into an executable
  add_executable(myexe main.cpp)
  target_link_libraries(myexe PUBLIC pybind11::embed)

Suggested usage::

find_package with version info is not recommended except for release versions. ::

  find_package(pybind11 CONFIG)
  find_package(pybind11 2.0 EXACT CONFIG REQUIRED)


The following variables can be set to guide the search for this package::

  pybind11_DIR - CMake variable, set to directory containing this Config file
  CMAKE_PREFIX_PATH - CMake variable, set to root directory of this package
  PATH - environment variable, set to bin directory of this package
  CMAKE_DISABLE_FIND_PACKAGE_pybind11 - CMake variable, disables
    find_package(pybind11) when not REQUIRED, perhaps to force internal build

Helper functions::

  pybind11_add_module(...) - Add a library and setup all helpers
  pybind11_strip(target) - Strip a target after building it (linux/macOS)
  pybind11_extension(target) - Injects the Python extension name

See ``pybind11Tools.cmake`` or ``pybind11NewTools.cmake`` for details on
``pybind11_add_module``.

#]=============================================================================]

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was pybind11Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Location of pybind11/pybind11.h
set(pybind11_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")

set(pybind11_LIBRARY "")
set(pybind11_DEFINITIONS USING_pybind11)
set(pybind11_VERSION_TYPE "")

check_required_components(pybind11)

if(TARGET pybind11::python_link_helper)
  # This has already been setup elsewhere, such as with a previous call or
  # add_subdirectory
  return()
endif()

include("${CMAKE_CURRENT_LIST_DIR}/pybind11Targets.cmake")

# Easier to use / remember
add_library(pybind11::headers IMPORTED INTERFACE)
set_target_properties(pybind11::headers PROPERTIES INTERFACE_LINK_LIBRARIES
                                                   pybind11::pybind11_headers)

include("${CMAKE_CURRENT_LIST_DIR}/pybind11Common.cmake")

if(NOT pybind11_FIND_QUIETLY)
  message(
    STATUS
      "Found pybind11: ${pybind11_INCLUDE_DIR} (found version \"${pybind11_VERSION}\" ${pybind11_VERSION_TYPE})"
  )
endif()
