/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2;

import ee.ut.soras.ajavtV2.AjaTuvastaja;
import ee.ut.soras.ajavtV2.EelTootlus;
import ee.ut.soras.ajavtV2.JarelTootlus;
import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.util.FileUtils;
import ee.ut.soras.ajavtV2.util.LogiPidaja;
import ee.ut.soras.wrappers.mudel.MorfAnRida;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.LocalDateTime;

public class Main {
    static Pattern jsonDCT = Pattern.compile("(?i)\"(dct)\"\\s*:\\s*\"([^\"]+)\"");

    private static void kuvaAbiInfo() {
        System.out.println();
        System.out.println("Ajavt, ver " + AjaTuvastaja.getVersioon());
        System.out.println();
        System.out.println(" Sisendi formaadi m22ramine:");
        System.out.println("  -format text  -- puhas tekst (vaikimisi);");
        System.out.println("                   (NB! selle lipu kasutamiseks peab T3MESTA olema");
        System.out.println("                    systeemis saadaval, vt allpool);");
        System.out.println("          t3olp -- osalausestatud T3MESTA v2ljund;");
        System.out.println("          json  -- vabamorfi JSON v2ljund;");
        System.out.println(" V2ljund on samas formaadis, mis sisend - lisatud on vaid ajav2ljendi-");
        System.out.println(" m2rgendid.");
        System.out.println();
        System.out.println(" Sisendi ja v2ljundi allika m22ramine: ");
        System.out.println("  -pyvabamorf          -- yhe rea kaupa JSON sisendi t88tlus: loeb standard-");
        System.out.println("                          sisendist rea, analyysib seda ja kirjutab tulemuse");
        System.out.println("                          standardv2ljundisse.");
        System.out.println("  -in  stdin           -- standardsisendist lugemine (vaikimisi); ");
        System.out.println("       file <fileName> -- sisend loetakse failist <fileName>;");
        System.out.println("  -out stdout          -- standardv2ljundisse kirjutamine (vaikimisi);");
        System.out.println("       file <fileName> -- v2ljund kirjutatakse faili <fileName>;");
        System.out.println();
        System.out.println("   NB! Eeldatakse, et sisend on alati UTF-8 kodeeringus, v2ljundisse ");
        System.out.println("  kirjutatav sisu on samuti alati UTF-8 kodeeringus. ");
        System.out.println();
        System.out.println(" Muud t2psustused:");
        System.out.println("  -r <rulesFile> -- teistsuguse reeglifaili kasutamine;");
        System.out.println("                    (vaikimisi on failiks 'reeglid.xml')");
        System.out.println("  -TimeML        -- v2ljund peaks olema rangelt TimeML-ile");
        System.out.println("                    vastav (TimeML-i alamosa);");
        System.out.println("  -unesc_DBS     -- sisendis kahekordsete \\ m2rkide asendamine yhekordsetega;");
        System.out.println("  -pretty_print  -- JSON-i v2ljastamine ilusti joondatult;");
        System.out.println();
        System.out.println(" DEBUG lipud:");
        System.out.println("  -par_debug -- osaline DEBUG valjund (esialgne tekst, kus on m2rgendatud");
        System.out.println("                ajavaljendid ning samuti m6ned olulisemad analyysi k2igus ");
        System.out.println("                leitud teksti tunnused (arvs6nad, grammatiline aeg jms). ");
        System.out.println("  -debug     -- taielik DEBUG valjund (sisseloetud reeglid, morf analyysi");
        System.out.println("                tulemus ning 'margendatud' tekst, iga s6na eraldi real ) ");
        System.out.println();
        System.out.println(" Kasutamine puhtal tekstil (vaikerezhiim):");
        System.out.println();
        System.out.println(" *) Arvutisse peab olema installeeritud Filosofti morfoloogiline analysaator");
        System.out.println("    ja yhestaja T3MESTA;");
        System.out.println();
        System.out.println("--> Programmi standardsisendisse tuleb anda eestikeelsetest lausetest");
        System.out.println("    koosnev tekst (kodeeringus UTF-8);");
        System.out.println("<-- Programm yritab leida lausetest ajavaljendeid, margistab leitud");
        System.out.println("    ajavaljendid ning kuvab standardvaljundisse tulemuse;");
        System.out.println();
        System.out.println("  echo Homme tulen sinna ka . | java -jar Ajavt.jar ");
        System.out.println("    ==> Leitakse etteantud lauses esinevad ajavaljendid, referentsajana");
        System.out.println("        kasutatakse programmi kaivitamise hetke;");
        System.out.println("  echo Homme tulen sinna ka . | java -jar Ajavt.jar \"2008-03-21T15:30\"");
        System.out.println("    ==> Leitakse etteantud lauses esinevad ajavaljendid, referentsajana");
        System.out.println("        kasutatakse parameetrina etteantud aega (2008-03-21T15:30);");
        System.out.println("        NB! Palume jalgida, et parameetrina antud referentsaeg jaaks jutu-");
        System.out.println("        markide vahele.");
        System.out.println();
    }

    public static void main(String[] stringArray) {
        PrintStream printStream;
        List<AjavtSona> list;
        Object object;
        String[] stringArray2 = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        String string3 = "text";
        String string4 = "stdin";
        String string5 = null;
        String string6 = "stdout";
        String string7 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-TimeML")) {
                    bl = true;
                }
                if (stringArray[i].matches("[0-9X]{4}-[0-9X]{2}-[0-9X]{2}T[0-9X]{2}:[0-9X]{2}")) {
                    stringArray2 = Main.looSonePohjalReferentsAeg(stringArray[i]);
                    string = stringArray[i];
                }
                if (stringArray[i].matches("-r") && i + 1 < stringArray.length) {
                    string2 = stringArray[i + 1];
                }
                if (stringArray[i].matches("(?i)(-){1,2}(h|help|abi|appi)")) {
                    Main.kuvaAbiInfo();
                    System.exit(0);
                }
                if (stringArray[i].matches("-format") && i + 1 < stringArray.length && stringArray[i + 1].matches("(text|t3olp|json)")) {
                    string3 = stringArray[i + 1];
                }
                if (stringArray[i].matches("(?i)(-){1,2}pyvabamorf")) {
                    bl9 = true;
                }
                if (stringArray[i].matches("-in") && i + 1 < stringArray.length) {
                    if (stringArray[i + 1].matches("(stdin|file)")) {
                        string4 = stringArray[i + 1];
                        if (string4.equalsIgnoreCase("file")) {
                            if (i + 2 < stringArray.length) {
                                string5 = stringArray[i + 2];
                            } else {
                                Main.kuvaAbiInfo();
                                System.exit(0);
                            }
                        }
                    } else {
                        Main.kuvaAbiInfo();
                        System.exit(0);
                    }
                }
                if (stringArray[i].matches("-out") && i + 1 < stringArray.length) {
                    if (stringArray[i + 1].matches("(stdout|file)")) {
                        string6 = stringArray[i + 1];
                        if (string6.equalsIgnoreCase("file")) {
                            if (i + 2 < stringArray.length) {
                                string7 = stringArray[i + 2];
                            } else {
                                Main.kuvaAbiInfo();
                                System.exit(0);
                            }
                        }
                    } else {
                        Main.kuvaAbiInfo();
                        System.exit(0);
                    }
                }
                if (stringArray[i].matches("-debug")) {
                    bl3 = true;
                }
                if (stringArray[i].matches("-alignmentOnly")) {
                    bl6 = true;
                }
                if (stringArray[i].matches("-par_debug")) {
                    bl4 = true;
                }
                if (stringArray[i].matches("-log")) {
                    bl2 = true;
                }
                if (stringArray[i].matches("(?i)(-){1,2}(unesc_DBS)")) {
                    bl7 = true;
                }
                if (!stringArray[i].matches("(?i)(-){1,2}(pretty_?print)")) continue;
                bl8 = true;
            }
        }
        if (bl9) {
            AjaTuvastaja ajaTuvastaja = new AjaTuvastaja();
            object = Pattern.compile("^\\s*$");
            try {
                if (string2 != null) {
                    ajaTuvastaja.uuendaReegleid(string2, false);
                }
                list = new Scanner(System.in, "UTF-8");
                printStream = new PrintStream((OutputStream)System.out, false, "UTF-8");
                while (((Scanner)((Object)list)).hasNextLine()) {
                    String string8 = ((Scanner)((Object)list)).nextLine();
                    if (((Pattern)object).matcher(string8).matches()) {
                        printStream.println(string8);
                        printStream.flush();
                        continue;
                    }
                    String string9 = ajaTuvastaja.tuvastaAjavaljendidPyVabamorfJSON(string, string8, bl, false);
                    printStream.println(string9);
                    printStream.flush();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(-1);
            }
            System.exit(0);
        }
        String string10 = null;
        if (string4.equalsIgnoreCase("stdin")) {
            try {
                string10 = Main.readInputFromStdIn();
            }
            catch (Exception exception) {
                System.err.println("Viga: Standardsisendist lugemine ebaonnestus!");
                exception.printStackTrace();
                System.exit(-1);
            }
        } else if (string4.equalsIgnoreCase("file") && string5 != null) {
            try {
                string10 = Main.readInputFromFile(string5);
            }
            catch (Exception exception) {
                System.err.println("Viga: Failist lugemine ebaonnestus!");
                exception.printStackTrace();
                System.exit(-1);
            }
        }
        if (string10 == null || string10.length() == 0) {
            System.err.println("Viga: Sisendit pole antud (v6i sisendiks on tyhis6ne).");
            Main.kuvaAbiInfo();
            System.exit(-1);
        }
        if (bl7) {
            string10 = string10.replace("\\\\", "\\");
        }
        if (stringArray2 == null) {
            stringArray2 = Main.looSonePohjalReferentsAeg(null);
        }
        object = new AjaTuvastaja();
        if (string2 != null) {
            ((AjaTuvastaja)object).setReegliFail(string2);
        }
        list = null;
        try {
            if (string3.equalsIgnoreCase("text")) {
                list = ((AjaTuvastaja)object).tuvastaAjavaljendidTekstis(stringArray2, string10, null, bl);
            } else if (string3.equalsIgnoreCase("t3olp")) {
                list = ((AjaTuvastaja)object).tuvastaAjavaljendidT3OLP(stringArray2, string10, bl, bl3);
            } else if (string3.equalsIgnoreCase("json")) {
                list = ((AjaTuvastaja)object).tuvastaAjavaljendidVabamorfJSON(stringArray2, string10, bl, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        try {
            if (string6.equalsIgnoreCase("stdout")) {
                printStream = new PrintStream((OutputStream)System.out, false, "UTF-8");
                if (string3.equalsIgnoreCase("text")) {
                    printStream.println(JarelTootlus.eraldamiseTulemusPretty(list, string10, bl, JarelTootlus.formatAsCreationTime(stringArray2)));
                } else if (string3.equalsIgnoreCase("t3olp")) {
                    printStream.println(JarelTootlus.eraldamiseTulemusT3OLPEraldiReal(string10, list, JarelTootlus.formatAsCreationTime(stringArray2), false, false));
                } else if (string3.equalsIgnoreCase("json")) {
                    printStream.println(JarelTootlus.eraldamiseTulemusVabaMorfiJSON(string10, list, JarelTootlus.formatAsCreationTime(stringArray2), bl, bl8));
                }
                printStream.flush();
                printStream.close();
            } else if (string6.equalsIgnoreCase("file") && string7 != null) {
                if (string3.equalsIgnoreCase("text")) {
                    FileUtils.printIntoFile(JarelTootlus.eraldamiseTulemusPretty(list, string10, bl, JarelTootlus.formatAsCreationTime(stringArray2)), "UTF-8", string7);
                } else if (string3.equalsIgnoreCase("t3olp")) {
                    FileUtils.printIntoFile(JarelTootlus.eraldamiseTulemusT3OLPEraldiReal(string10, list, JarelTootlus.formatAsCreationTime(stringArray2), false, false), "UTF-8", string7);
                } else if (string3.equalsIgnoreCase("json")) {
                    FileUtils.printIntoFile(JarelTootlus.eraldamiseTulemusVabaMorfiJSON(string10, list, JarelTootlus.formatAsCreationTime(stringArray2), bl, bl8), "UTF-8", string7);
                }
            }
            if (bl5 || bl3 || bl4 || bl6) {
                if (string3.equalsIgnoreCase("t3olp")) {
                    Main.debugOutputForT3OLP(string10, list, stringArray2, string7, bl, bl3, bl5, bl6);
                }
                if (string3.equalsIgnoreCase("text") && (bl3 || bl4)) {
                    Main.debugOutputForText_partialDebug(string10, list, stringArray2, bl, bl3, bl2, (AjaTuvastaja)object);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public static String[] looSonePohjalReferentsAeg(String string) {
        if (string != null) {
            if (string.matches("[0-9X]{4}-[0-9X]{2}-[0-9X]{2}T[0-9X]{2}:[0-9X]{2}")) {
                String[] stringArray = new String[5];
                int n = 0;
                boolean bl = false;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "-:T");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (n < stringArray.length) {
                        stringArray[n] = string2;
                    }
                    if (string2.matches("X+")) {
                        bl = true;
                    } else if (bl) {
                        stringArray[n] = "XX";
                    }
                    if (n >= stringArray.length) continue;
                    ++n;
                }
                return stringArray;
            }
            if (string.matches("^[0-9X]{4}-[0-9X]{2}-[0-9X]{2}$")) {
                String[] stringArray = new String[5];
                int n = 0;
                boolean bl = false;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (n < stringArray.length) {
                        stringArray[n] = string3;
                    }
                    if (string3.matches("X+")) {
                        bl = true;
                    } else if (bl) {
                        stringArray[n] = "XX";
                    }
                    if (n >= stringArray.length) continue;
                    ++n;
                }
                stringArray[3] = "XX";
                stringArray[4] = "XX";
                return stringArray;
            }
            return null;
        }
        LocalDateTime localDateTime = new LocalDateTime();
        String[] stringArray = new String[]{String.valueOf(localDateTime.getYear()), String.valueOf(localDateTime.getMonthOfYear()), String.valueOf(localDateTime.getDayOfMonth()), String.valueOf(localDateTime.getHourOfDay()), String.valueOf(localDateTime.getMinuteOfHour())};
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].length() != 1) continue;
            stringArray[i] = "0" + stringArray[i];
        }
        return stringArray;
    }

    public static String[] leiaJSONSonestReferentsAeg(String string) {
        Matcher matcher;
        if (string != null && (matcher = jsonDCT.matcher(string)).find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            return new String[]{string2, string3};
        }
        return null;
    }

    public static String[] prooviLuuaJSONsisendiP6hjalRefAeg(String string) {
        String[] stringArray = Main.leiaJSONSonestReferentsAeg(string);
        if (stringArray != null) {
            return Main.looSonePohjalReferentsAeg(stringArray[1]);
        }
        return null;
    }

    private static String readInputFromStdIn() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        while ((n = bufferedReader.read()) != -1) {
            stringBuffer.append(Character.toChars(n));
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    private static String readInputFromFile(String string) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)dataInputStream, "UTF-8"));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.length() <= 0) continue;
            stringBuilder.append(string2 + "\n");
        }
        return stringBuilder.toString();
    }

    private static void debugOutputForT3OLP(String string, List<AjavtSona> list, String[] stringArray, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        if (string2 == null) {
            throw new Exception(" Output file must be specified in order to debug T3OLP output! ");
        }
        if (bl2) {
            FileUtils.printIntoFile(JarelTootlus.eraldamiseTulemusIgaSonaEraldiRealDebug(list, JarelTootlus.formatAsCreationTime(stringArray)), "UTF-8", string2, "debug");
        } else if (bl3) {
            FileUtils.printIntoFile(JarelTootlus.eraldamiseTulemusPrettyT3OLP(list, JarelTootlus.formatAsCreationTime(stringArray), bl), "UTF-8", string2, "txt-timex");
            FileUtils.printIntoFile(JarelTootlus.eraldamiseTulemusT3OLPEraldiReal(string, list, JarelTootlus.formatAsCreationTime(stringArray), bl, true), "UTF-8", string2, "t3-olp-ri-timex");
        } else if (bl4) {
            List<AjavtSona> list2 = EelTootlus.eeltootlusT3OLP(string);
            StringBuilder stringBuilder = new StringBuilder();
            for (AjavtSona ajavtSona : list2) {
                stringBuilder.append(ajavtSona.getInnerTokenPosition() + ":" + ajavtSona.getTokenPosition() + ": " + ajavtSona.getAlgSona());
                stringBuilder.append("\n");
            }
            FileUtils.printIntoFile(stringBuilder.toString(), "UTF-8", string2, "t3-olp-align");
        }
    }

    private static void debugOutputForText_partialDebug(String string, List<AjavtSona> list, String[] stringArray, boolean bl, boolean bl2, boolean bl3, AjaTuvastaja ajaTuvastaja) {
        if (!bl2) {
            if (bl3) {
                LogiPidaja logiPidaja = new LogiPidaja(true);
                logiPidaja.setKirjutaLogiFaili(true);
                logiPidaja.setKirjutaLogiValjundisse(true);
                logiPidaja.println(JarelTootlus.eraldamiseTulemusDebug(list, string, bl, JarelTootlus.formatAsCreationTime(stringArray)));
                logiPidaja.setKirjutaLogiFaili(false);
            } else {
                System.out.println("*******************************************************");
                System.out.println(JarelTootlus.eraldamiseTulemusDebug(list, string, bl, JarelTootlus.formatAsCreationTime(stringArray)));
            }
        } else {
            LogiPidaja logiPidaja = new LogiPidaja(true);
            logiPidaja.setKirjutaLogiValjundisse(false);
            ajaTuvastaja.kuvaSonaKlassidJaReeglid(logiPidaja);
            logiPidaja.println("-------------------------------------");
            logiPidaja.println("Sonu oli kokku: " + list.size());
            logiPidaja.println("-------------------------------------");
            logiPidaja.println(" Morf analyysi tulemused mudelisse vormitult:");
            logiPidaja.println("");
            for (AjavtSona ajavtSona : list) {
                logiPidaja.print(ajavtSona.getAlgSona());
                if (ajavtSona.getAlgSonaYmbritsevateMarkideta() != null) {
                    logiPidaja.println("(" + ajavtSona.getAlgSonaYmbritsevateMarkideta() + ")");
                } else {
                    logiPidaja.println();
                }
                if (!ajavtSona.kasLeidusAnalyys()) continue;
                List<MorfAnRida> list2 = ajavtSona.getAnalyysiTulemused();
                for (MorfAnRida morfAnRida : list2) {
                    logiPidaja.println("\t" + morfAnRida.getLemma() + " + " + morfAnRida.getLopp());
                    logiPidaja.println("\t\t" + morfAnRida.getSonaLiikPikalt());
                    if (morfAnRida.getVormiNimetused().length() <= 0) continue;
                    logiPidaja.print(morfAnRida.getVormiNimetusedPikalt("\t\t"));
                }
            }
            logiPidaja.println();
            logiPidaja.println(JarelTootlus.eraldamiseTulemusIgaSonaEraldiRealDebug(list, JarelTootlus.formatAsCreationTime(stringArray)));
            logiPidaja.setKirjutaLogiFaili(false);
        }
    }
}

