/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.util;

import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.FraasisPaiknemiseKoht;
import ee.ut.soras.wrappers.mudel.MorfAnRida;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArvSonaFraasideTuvastaja {
    private static final Object[][] murdJaEriArvulised = new Object[][]{{"veerand", new Double(0.25)}, {"pool(e)?", new Double(0.5)}, {"kolmveerand", new Double(0.75)}, {"pool(e)?teis(e|t)", new Double(1.5)}, {"veerandsa(d|j)a", new Integer(25)}, {"veerandtuhat", new Integer(250)}, {"poolsada", new Integer(50)}, {"poolesaja", new Integer(50)}, {"pooltuhat", new Integer(500)}};
    private static final String[] yhelised = new String[]{"null(ine|is)?", "((\u00fc(ks|he(ne)?){1})|(esimene))", "(ka(ks|he(ne)?){1}|teine)", "kolm(e(ne)?|as)?", "nel(i|ja(ne)?|jas){1}", "vii(s|e(ne)?|es){1}", "kuu(s|e(ne)?|es){1}", "seits(e|me(ne)?|mes){1}", "kaheksa(ne|s)?", "\u00fcheksa(ne|s)?"};
    private static final String[] teistkymnelised = new String[]{"k\u00fcm(me|ne(ne)?|nes)", "((\u00fcksteist(k\u00fcmmend)?)|(\u00fcheteist)|(\u00fcheteistk\u00fcmne(ne|s)?))", "((kaksteist(k\u00fcmmend)?)|(kaheteist)|(kaheteistk\u00fcmne(ne|s)?))", "((kolmteist(k\u00fcmmend)?)|(kolmeteist)|(kolmeteistk\u00fcmne(ne|s)?))", "((neliteist(k\u00fcmmend)?)|(neljateist)|(neljateistk\u00fcmne(ne|s)?))", "((viisteist(k\u00fcmmend)?)|(viieteist)|(viieteistk\u00fcmne(ne|s)?))", "((kuusteist(k\u00fcmmend)?)|(kuueteist)|(kuueteistk\u00fcmne(ne|s)?))", "((seitseteist(k\u00fcmmend)?)|(seitsmeteist)|(seitsmeteistk\u00fcmne(ne|s)?))", "((kaheksateist(k\u00fcmmend)?)|(kaheksateist)|(kaheksateistk\u00fcmne(ne|s)?))", "((\u00fcheksateist(k\u00fcmmend)?)|(\u00fcheksateist)|(\u00fcheksateistk\u00fcmne(ne|s)?))"};
    private static final String[] kymnelised = new String[]{"((kaksk\u00fcmmend)|(kahek\u00fcmne(ne|s)?))", "((kolmk\u00fcmmend)|(kolmek\u00fcmne(ne|s)?))", "((nelik\u00fcmmend)|(neljak\u00fcmne(ne|s)?))", "((viisk\u00fcmmend)|(viiek\u00fcmne(ne|s)?))", "((kuusk\u00fcmmend)|(kuuek\u00fcmne(ne|s)?))", "((seitsek\u00fcmmend)|(seitsmek\u00fcmne(ne|s)?))", "((kaheksak\u00fcmmend)|(kaheksak\u00fcmne(ne|s)?))", "((\u00fcheksak\u00fcmmend)|(\u00fcheksak\u00fcmne(ne|s)?))"};
    private static final String[] sajalised = new String[]{"sa(da|ja(ne)?|jas){1}", "((\u00fckssada)|(\u00fchesaja(ne|s)?))", "((kakssada)|(kahesaja(ne|s)?))", "((kolmsada)|(kolmesaja(ne|s)?))", "((nelisada)|(neljasaja(ne|s)?))", "((viissada)|(viiesaja(ne|s)?))", "((kuussada)|(kuuesaja(ne|s)?))", "((seitsesada)|(seitsmesaja(ne|s)?))", "((kaheksasada)|(kaheksasaja(ne|s)?))", "((\u00fcheksasada)|(\u00fcheksasaja(ne|s)?))"};
    private static final String tuhat = "tuha(t|nde(ne)?|ndes){1}";
    private static final String prefiksiteKontrollAvaldis = "((null|veeran|pool|\u00fcks|\u00fche|esim|kaks|kahe|tei|kolm|nel|vii|kuu|seits|k\u00fcm|sa|tuha){1}).*";
    private Map<Pattern, Object> murdJaEriArvulisteKompilRegExp;
    private Pattern[] yhelisedKompilRegExp;
    private Pattern[] teistkymnelisedKompilRegExp;
    private Pattern[] kymnelisedKompilRegExp;
    private Pattern[] sajalisedKompilRegExp;
    private Pattern tuhatKompilRegExp;
    private Pattern prefiksiKontrollKompilRegExp;
    private boolean viimaneEtteantudSoneOliArvsona = false;
    private int loodavTaisArv = -1;
    private double loodavMurdArv = -1.0;
    private int loodavaArvSonaFraasiPikkus = 0;
    private int eelmiseArvuKlass = 0;
    private List<AjavtSona> labitavTekst = null;

    public ArvSonaFraasideTuvastaja(List<AjavtSona> list) {
        this.labitavTekst = list;
        this.kompileeriRegulaarAvaldised();
    }

    private void kompileeriRegulaarAvaldised() {
        this.murdJaEriArvulisteKompilRegExp = new HashMap<Pattern, Object>(murdJaEriArvulised.length);
        for (Object[] objectArray : murdJaEriArvulised) {
            this.murdJaEriArvulisteKompilRegExp.put(Pattern.compile((String)objectArray[0], 64), objectArray[1]);
        }
        this.yhelisedKompilRegExp = new Pattern[yhelised.length];
        int n = 0;
        for (String string : yhelised) {
            this.yhelisedKompilRegExp[n++] = Pattern.compile(string, 64);
        }
        this.teistkymnelisedKompilRegExp = new Pattern[teistkymnelised.length];
        n = 0;
        for (String string : teistkymnelised) {
            this.teistkymnelisedKompilRegExp[n++] = Pattern.compile(string, 64);
        }
        this.kymnelisedKompilRegExp = new Pattern[kymnelised.length];
        n = 0;
        for (String string : kymnelised) {
            this.kymnelisedKompilRegExp[n++] = Pattern.compile(string, 64);
        }
        this.sajalisedKompilRegExp = new Pattern[sajalised.length];
        n = 0;
        for (String string : sajalised) {
            this.sajalisedKompilRegExp[n++] = Pattern.compile(string, 64);
        }
        this.tuhatKompilRegExp = Pattern.compile(tuhat, 64);
        this.prefiksiKontrollKompilRegExp = Pattern.compile(prefiksiteKontrollAvaldis, 64);
    }

    public Object leiaArvSonaArvulineVaartus(String string) {
        int n;
        for (Pattern object2 : this.murdJaEriArvulisteKompilRegExp.keySet()) {
            Matcher matcher = object2.matcher(string);
            if (!matcher.matches()) continue;
            return this.murdJaEriArvulisteKompilRegExp.get(object2);
        }
        for (n = 0; n < this.yhelisedKompilRegExp.length; ++n) {
            Matcher matcher = this.yhelisedKompilRegExp[n].matcher(string);
            if (!matcher.matches()) continue;
            return new Integer(n);
        }
        for (n = 0; n < this.teistkymnelisedKompilRegExp.length; ++n) {
            Matcher matcher = this.teistkymnelisedKompilRegExp[n].matcher(string);
            if (!matcher.matches()) continue;
            return new Integer(10 + n);
        }
        for (n = 0; n < this.kymnelisedKompilRegExp.length; ++n) {
            Matcher matcher = this.kymnelisedKompilRegExp[n].matcher(string);
            if (!matcher.matches()) continue;
            return new Integer(10 * (n + 2));
        }
        for (n = 0; n < this.sajalisedKompilRegExp.length; ++n) {
            Matcher matcher = this.sajalisedKompilRegExp[n].matcher(string);
            if (!matcher.matches()) continue;
            return new Integer(n < 2 ? 100 : 100 * n);
        }
        Matcher matcher = this.tuhatKompilRegExp.matcher(string);
        if (matcher.matches()) {
            return new Integer(1000);
        }
        return null;
    }

    public boolean tuvastaArvSonaFraas(AjavtSona ajavtSona) {
        boolean bl = false;
        if (ajavtSona.kasLeidusAnalyys()) {
            for (MorfAnRida morfAnRida : ajavtSona.getAnalyysiTulemused()) {
                String string = morfAnRida.getLemmaIlmaVahemarkideta();
                Matcher matcher = this.prefiksiKontrollKompilRegExp.matcher(string);
                if (!matcher.matches()) continue;
                Object object = this.leiaArvSonaArvulineVaartus(string);
                if (object != null && object instanceof Integer) {
                    int n = (Integer)object;
                    bl = true;
                    int n2 = this.leiaArvuKlass(n);
                    if (this.viimaneEtteantudSoneOliArvsona) {
                        if (this.loodavTaisArv > -1) {
                            if (n == 1000 && this.loodavTaisArv < n) {
                                this.loodavTaisArv *= n;
                                ++this.loodavaArvSonaFraasiPikkus;
                            } else if (this.esimeneArvuKlassOnSuurem(this.eelmiseArvuKlass, n2)) {
                                this.loodavTaisArv += n;
                                ++this.loodavaArvSonaFraasiPikkus;
                            } else {
                                this.sulgeArvSonaFraas(ajavtSona);
                                this.loodavaArvSonaFraasiPikkus = 1;
                                this.loodavTaisArv = n;
                            }
                        } else {
                            this.sulgeArvSonaFraas(ajavtSona);
                            this.loodavaArvSonaFraasiPikkus = 1;
                            this.loodavTaisArv = n;
                        }
                    } else {
                        this.loodavTaisArv = n;
                        this.loodavaArvSonaFraasiPikkus = 1;
                    }
                    this.eelmiseArvuKlass = n2;
                    break;
                }
                if (object == null || !(object instanceof Double)) continue;
                if (this.viimaneEtteantudSoneOliArvsona) {
                    this.sulgeArvSonaFraas(ajavtSona);
                }
                this.loodavaArvSonaFraasiPikkus = 1;
                this.loodavMurdArv = (Double)object;
                bl = true;
            }
        }
        if (!bl && this.viimaneEtteantudSoneOliArvsona) {
            this.sulgeArvSonaFraas(ajavtSona);
        }
        this.viimaneEtteantudSoneOliArvsona = bl;
        return bl;
    }

    private int leiaArvuKlass(int n) {
        if (n >= 0 && n < 10) {
            return 1;
        }
        if (n < 20) {
            return 11;
        }
        if (n < 100) {
            return 50;
        }
        if (n < 1000) {
            return 100;
        }
        return 1000;
    }

    private boolean esimeneArvuKlassOnSuurem(int n, int n2) {
        if (n == 11) {
            return false;
        }
        if (n2 == 11) {
            return n > 50;
        }
        return n > n2;
    }

    public void sulgeArvSonaFraas(AjavtSona ajavtSona) {
        if ((this.loodavTaisArv > -1 || this.loodavMurdArv > -1.0) && this.loodavaArvSonaFraasiPikkus > 0 && this.labitavTekst != null) {
            int n = this.labitavTekst.size() - 1;
            if (ajavtSona != null && this.labitavTekst.get(this.labitavTekst.size() - 1).equals(ajavtSona)) {
                --n;
            }
            if (this.loodavaArvSonaFraasiPikkus == 1) {
                this.labitavTekst.get(n).setArvSonaFraasis(FraasisPaiknemiseKoht.AINUSSONA);
                if (this.loodavTaisArv > -1) {
                    this.labitavTekst.get(n).setArvSonaTaisArvVaartus(new Integer(this.loodavTaisArv));
                } else {
                    this.labitavTekst.get(n).setArvSonaMurdArvVaartus(new Double(this.loodavMurdArv));
                }
            } else {
                for (int i = n; i >= n - this.loodavaArvSonaFraasiPikkus + 1; --i) {
                    if (i == n) {
                        this.labitavTekst.get(i).setArvSonaFraasis(FraasisPaiknemiseKoht.LOPUS);
                        if (this.loodavTaisArv > -1) {
                            this.labitavTekst.get(i).setArvSonaTaisArvVaartus(new Integer(this.loodavTaisArv));
                            continue;
                        }
                        this.labitavTekst.get(i).setArvSonaMurdArvVaartus(new Double(this.loodavMurdArv));
                        continue;
                    }
                    if (i == n - this.loodavaArvSonaFraasiPikkus + 1) {
                        this.labitavTekst.get(i).setArvSonaFraasis(FraasisPaiknemiseKoht.ALGUSES);
                        if (this.loodavTaisArv > -1) {
                            this.labitavTekst.get(i).setArvSonaTaisArvVaartus(new Integer(this.loodavTaisArv));
                            continue;
                        }
                        this.labitavTekst.get(i).setArvSonaMurdArvVaartus(new Double(this.loodavMurdArv));
                        continue;
                    }
                    this.labitavTekst.get(i).setArvSonaFraasis(FraasisPaiknemiseKoht.KESKEL);
                    if (this.loodavTaisArv > -1) {
                        this.labitavTekst.get(i).setArvSonaTaisArvVaartus(new Integer(this.loodavTaisArv));
                        continue;
                    }
                    this.labitavTekst.get(i).setArvSonaMurdArvVaartus(new Double(this.loodavMurdArv));
                }
            }
            this.loodavTaisArv = -1;
            this.loodavMurdArv = -1.0;
            this.loodavaArvSonaFraasiPikkus = 0;
        }
    }
}

