"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketPolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const s3_generated_1 = require("./s3.generated");
/**
 * Applies an Amazon S3 bucket policy to an Amazon S3 bucket.
 *
 * @stability stable
 */
class BucketPolicy extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * A policy document containing permissions to add to the specified bucket.
         *
         * For more information, see Access Policy Language Overview in the Amazon
         * Simple Storage Service Developer Guide.
         *
         * @stability stable
         */
        this.document = new aws_iam_1.PolicyDocument();
        jsiiDeprecationWarnings._aws_cdk_aws_s3_BucketPolicyProps(props);
        if (!props.bucket.bucketName) {
            throw new Error('Bucket doesn\'t have a bucketName defined');
        }
        this.resource = new s3_generated_1.CfnBucketPolicy(this, 'Resource', {
            bucket: props.bucket.bucketName,
            policyDocument: this.document,
        });
        if (props.removalPolicy) {
            this.resource.applyRemovalPolicy(props.removalPolicy);
        }
    }
    /**
     * Sets the removal policy for the BucketPolicy.
     *
     * @param removalPolicy the RemovalPolicy to set.
     * @stability stable
     */
    applyRemovalPolicy(removalPolicy) {
        this.resource.applyRemovalPolicy(removalPolicy);
    }
}
exports.BucketPolicy = BucketPolicy;
_a = JSII_RTTI_SYMBOL_1;
BucketPolicy[_a] = { fqn: "@aws-cdk/aws-s3.BucketPolicy", version: "1.134.0" };
//# sourceMappingURL=data:application/json;base64,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